import React from "react";

function SvgWave(props) {
	return (
		<svg
			preserveAspectRatio="none"
			xmlns="http://www.w3.org/2000/svg"
			viewBox="0 0 409.02 188.02"
		>
			<defs></defs>
			<g id="a"></g>
			<g id="b">
				<g id="c">
					<path
						class="d"
						d="M2.02,188.02l407-.06v-49.94c-10-61-65-62-65-62l-22.69-1.89-1.31-.11-38.3-2c5.44-1.19-150.2,3.78-199.7-9C8.76,44.11-.56-.98,.02,.02V188.02H2.02Z"
					></path>
				</g>
			</g>
		</svg>
	);
}

function SvgAlignstart(props) {
	return (
		<svg
			width="24px"
			height="24px"
			viewBox="0 0 24 24"
			fill="none"
			xmlns="http://www.w3.org/2000/svg"
		>
			<g id="SVGRepo_bgCarrier" stroke-width="0"></g>
			<g
				id="SVGRepo_tracerCarrier"
				stroke-linecap="round"
				stroke-linejoin="round"
			></g>
			<g id="SVGRepo_iconCarrier">
				{" "}
				<path
					d="M5 6H19M5 10H15M5 14H19M5 18H15"
					stroke="#007bff"
					stroke-width="2"
					stroke-linecap="round"
					stroke-linejoin="round"
				></path>{" "}
			</g>
		</svg>
	);
}

function SvgAligncenter(props) {
	return (
		<svg
			width="24px"
			height="24px"
			viewBox="0 0 24 24"
			fill="none"
			xmlns="http://www.w3.org/2000/svg"
		>
			<g id="SVGRepo_bgCarrier" stroke-width="0"></g>
			<g
				id="SVGRepo_tracerCarrier"
				stroke-linecap="round"
				stroke-linejoin="round"
			></g>
			<g id="SVGRepo_iconCarrier">
				{" "}
				<path
					d="M5 6H19M7 10H17M5 14H19M7 18H17"
					stroke="#007bff"
					stroke-width="2"
					stroke-linecap="round"
					stroke-linejoin="round"
				></path>{" "}
			</g>
		</svg>
	);
}

function SvgAlignend(props) {
	return (
		<svg
			width="24px"
			height="24px"
			viewBox="0 0 24 24"
			fill="none"
			xmlns="http://www.w3.org/2000/svg"
		>
			<g id="SVGRepo_bgCarrier" stroke-width="0"></g>
			<g
				id="SVGRepo_tracerCarrier"
				stroke-linecap="round"
				stroke-linejoin="round"
			></g>
			<g id="SVGRepo_iconCarrier">
				{" "}
				<path
					d="M5 6H19M9 10H19M5 14H19M9 18H19"
					stroke="#007bff"
					stroke-width="2"
					stroke-linecap="round"
					stroke-linejoin="round"
				></path>{" "}
			</g>
		</svg>
	);
}
function SvgSearch(props) {
	return (
		<svg
			width="20px"
			height="20px"
			viewBox="0 0 24 24"
			fill="none"
			xmlns="http://www.w3.org/2000/svg"
		>
			<path
				d="M17 17L21 21"
				stroke="#ffffff" // Use the prop to set the stroke color
				stroke-width="2"
				stroke-linecap="round"
				stroke-linejoin="round"
			></path>
			<path
				d="M19 11C19 15.4183 15.4183 19 11 19C6.58172 19 3 15.4183 3 11C3 6.58172 6.58172 3 11 3C15.4183 3 19 6.58172 19 11Z"
				stroke="#ffffff" // Use the prop to set the stroke color
				stroke-width="2"
			></path>
		</svg>
	);
}

function SvgLink() {
	return (
		<svg
			width="24px"
			height="24px"
			viewBox="0 0 24 24"
			fill="none"
			xmlns="http://www.w3.org/2000/svg"
			style={{ fill: "none" }}
		>
			<g id="SVGRepo_bgCarrier" stroke-width="0"></g>
			<g
				id="SVGRepo_tracerCarrier"
				stroke-linecap="round"
				stroke-linejoin="round"
				stroke="#CCCCCC"
				stroke-width="0.048"
			></g>
			<g id="SVGRepo_iconCarrier">
				{" "}
				<path
					d="M10.6666 13.3333L10.0808 12.7475C9.29978 11.9664 9.29978 10.7001 10.0808 9.91905L14.5857 5.41416C15.3668 4.63311 16.6331 4.63311 17.4142 5.41415L18.5857 6.58572C19.3668 7.36677 19.3668 8.6331 18.5857 9.41415L16.9999 10.9999M13.3333 10.6666L13.919 11.2524C14.7001 12.0335 14.7001 13.2998 13.919 14.0808L9.41415 18.5857C8.6331 19.3668 7.36677 19.3668 6.58572 18.5857L5.41416 17.4142C4.63311 16.6331 4.63311 15.3668 5.41416 14.5857L6.99994 12.9999"
					stroke="#007bff"
					stroke-width="2"
					stroke-linecap="round"
					stroke-linejoin="round"
				></path>{" "}
			</g>
		</svg>
	);
}

function SvgDownload() {
	return (
		<svg
			width="24px"
			height="24px"
			viewBox="0 0 24 24"
			fill="none"
			xmlns="http://www.w3.org/2000/svg"
			style={{ fill: "none" }}
		>
			<circle
				cx="12"
				cy="12"
				r="9"
				stroke="#ffffff"
				stroke-width="2"
				stroke-linecap="round"
				stroke-linejoin="round"
			></circle>
			<path
				d="M12 7V17M12 17L9.5 14.5M12 17L14.5 14.5"
				stroke="#ffffff"
				stroke-width="2"
				stroke-linecap="round"
				stroke-linejoin="round"
			></path>
		</svg>
	);
}

function SvgPlay() {
	return (
		<svg
			width="24px"
			height="24px"
			viewBox="0 0 24 24"
			fill="none"
			xmlns="http://www.w3.org/2000/svg"
		>
			<g id="SVGRepo_bgCarrier" stroke-width="0"></g>
			<g
				id="SVGRepo_tracerCarrier"
				stroke-linecap="round"
				stroke-linejoin="round"
			></g>
			<g id="SVGRepo_iconCarrier">
				{" "}
				<circle
					cx="12"
					cy="12"
					r="9"
					stroke="#ffffff"
					stroke-width="2"
					stroke-linecap="round"
					stroke-linejoin="round"
				></circle>{" "}
				<path
					d="M9.5 15.0568V8.94319C9.5 8.12982 10.4194 7.65669 11.0812 8.12946L15.3608 11.1863C15.9191 11.5851 15.9191 12.4149 15.3608 12.8137L11.0812 15.8705C10.4194 16.3433 9.5 15.8702 9.5 15.0568Z"
					stroke="#ffffff"
					stroke-width="2"
					stroke-linecap="round"
					stroke-linejoin="round"
				></path>{" "}
			</g>
		</svg>
	);
}
function SvgFilter(props) {
	return (
		<span className="up-pannel-control-icon">
			<svg
				width="800px"
				height="800px"
				viewBox="0 0 24 24"
				fill="none"
				xmlns="http://www.w3.org/2000/svg"
			>
				<path
					d="M20.17 3.91C20.1062 3.78712 20.0101 3.68399 19.8921 3.61173C19.774 3.53947 19.6384 3.50084 19.5 3.5H4.5C4.36157 3.50084 4.226 3.53947 4.10792 3.61173C3.98984 3.68399 3.89375 3.78712 3.83 3.91C3.76636 4.03323 3.73915 4.17204 3.75155 4.31018C3.76395 4.44832 3.81544 4.58007 3.9 4.69L9.25 12V19.75C9.25259 19.9481 9.33244 20.1374 9.47253 20.2775C9.61263 20.4176 9.80189 20.4974 10 20.5H14C14.1981 20.4974 14.3874 20.4176 14.5275 20.2775C14.6676 20.1374 14.7474 19.9481 14.75 19.75V12L20.1 4.69C20.1846 4.58007 20.236 4.44832 20.2484 4.31018C20.2608 4.17204 20.2336 4.03323 20.17 3.91Z"
					fill="#007bff"
				/>
			</svg>
		</span>
	);
}
function SvgImagesetting(props) {
	return (
		<span className="up-pannel-control-icon">
			<svg
				width="800px"
				height="800px"
				viewBox="0 0 24 24"
				fill="none"
				xmlns="http://www.w3.org/2000/svg"
			>
				<path
					d="M13 4H8.8C7.11984 4 6.27976 4 5.63803 4.32698C5.07354 4.6146 4.6146 5.07354 4.32698 5.63803C4 6.27976 4 7.11984 4 8.8V15.2C4 16.8802 4 17.7202 4.32698 18.362C4.6146 18.9265 5.07354 19.3854 5.63803 19.673C6.27976 20 7.11984 20 8.8 20H15.2C16.8802 20 17.7202 20 18.362 19.673C18.9265 19.3854 19.3854 18.9265 19.673 18.362C20 17.7202 20 16.8802 20 15.2V11"
					stroke="#007bff"
					stroke-width="2"
					stroke-linecap="round"
					stroke-linejoin="round"
				/>
				<path
					d="M4 16L8.29289 11.7071C8.68342 11.3166 9.31658 11.3166 9.70711 11.7071L13 15M13 15L15.7929 12.2071C16.1834 11.8166 16.8166 11.8166 17.2071 12.2071L20 15M13 15L15.25 17.25"
					stroke="#007bff"
					stroke-width="2"
					stroke-linecap="round"
					stroke-linejoin="round"
				/>
				<path
					d="M18.5 3V5.5M18.5 8V5.5M18.5 5.5H16M18.5 5.5H21"
					stroke="#007bff"
					stroke-width="2"
					stroke-linecap="round"
					stroke-linejoin="round"
				/>
			</svg>
		</span>
	);
}
function SvgcontentIcon(props) {
	return (
		<span className="up-pannel-control-icon">
			<svg
				width="24px"
				height="24px"
				viewBox="0 0 24 24"
				fill="none"
				xmlns="http://www.w3.org/2000/svg"
			>
				<g id="SVGRepo_bgCarrier" stroke-width="0"></g>
				<g
					id="SVGRepo_tracerCarrier"
					stroke-linecap="round"
					stroke-linejoin="round"
				></g>
				<g id="SVGRepo_iconCarrier">
					{" "}
					<path
						d="M3 6C3 4.34315 4.34315 3 6 3H14C15.6569 3 17 4.34315 17 6V14C17 15.6569 15.6569 17 14 17H6C4.34315 17 3 15.6569 3 14V6Z"
						stroke="#007bff"
						stroke-width="2"
						stroke-linecap="round"
						stroke-linejoin="round"
					></path>{" "}
					<path
						d="M21 7V18C21 19.6569 19.6569 21 18 21H7"
						stroke="#007bff"
						stroke-width="2"
						stroke-linecap="round"
						stroke-linejoin="round"
					></path>{" "}
					<path
						d="M3 12.375L6.66789 8.70711C7.05842 8.31658 7.69158 8.31658 8.08211 8.70711L10.875 11.5M10.875 11.5L13.2304 9.1446C13.6209 8.75408 14.2541 8.75408 14.6446 9.14461L17 11.5M10.875 11.5L12.8438 13.4688"
						stroke="#007bff"
						stroke-width="2"
						stroke-linecap="round"
						stroke-linejoin="round"
					></path>{" "}
				</g>
			</svg>
		</span>
	);
}
function SvgfilterIcon(props) {
	return (
		<span className="up-pannel-control-icon">
			<svg
				width="64px"
				height="64px"
				viewBox="0 0 24 24"
				fill="none"
				xmlns="http://www.w3.org/2000/svg"
			>
				<g id="SVGRepo_bgCarrier" stroke-width="0"></g>
				<g
					id="SVGRepo_tracerCarrier"
					stroke-linecap="round"
					stroke-linejoin="round"
				></g>
				<g id="SVGRepo_iconCarrier">
					{" "}
					<path
						d="M4 6C4 6 9.57574 6 13 6M16 4V6M16 8V6M16 6H20"
						stroke="#007bff"
						stroke-width="2"
						stroke-linecap="round"
						stroke-linejoin="round"
					></path>{" "}
					<path
						d="M4 18C4 18 6.57574 18 10 18M13 16V18M13 20V18M13 18H20"
						stroke="#007bff"
						stroke-width="2"
						stroke-linecap="round"
						stroke-linejoin="round"
					></path>{" "}
					<path
						d="M20 12C20 12 14.4243 12 11 12M8 14L8 12M8 10L8 12M8 12L4 12"
						stroke="#007bff"
						stroke-width="2"
						stroke-linecap="round"
						stroke-linejoin="round"
					></path>{" "}
				</g>
			</svg>
		</span>
	);
}
function SvggenralIcon(props) {
	return (
		<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
			<g id="SVGRepo_bgCarrier" stroke-width="0"></g>
			<g
				id="SVGRepo_tracerCarrier"
				stroke-linecap="round"
				stroke-linejoin="round"
			></g>
			<g id="SVGRepo_iconCarrier">
				{" "}
				<path
					d="M14 5.28988H13C13 5.7323 13.2907 6.12213 13.7148 6.24833L14 5.28988ZM15.3302 5.84137L14.8538 6.72058C15.2429 6.93144 15.7243 6.86143 16.0373 6.54847L15.3302 5.84137ZM16.2426 4.92891L15.5355 4.2218V4.2218L16.2426 4.92891ZM17.6569 4.92891L16.9498 5.63601L16.9498 5.63602L17.6569 4.92891ZM19.0711 6.34312L19.7782 5.63602V5.63602L19.0711 6.34312ZM19.0711 7.75734L18.364 7.05023L19.0711 7.75734ZM18.1586 8.66978L17.4515 7.96268C17.1386 8.27563 17.0686 8.75709 17.2794 9.14621L18.1586 8.66978ZM18.7101 10L17.7517 10.2853C17.8779 10.7093 18.2677 11 18.7101 11V10ZM18.7101 14V13C18.2677 13 17.8779 13.2907 17.7517 13.7148L18.7101 14ZM18.1586 15.3302L17.2794 14.8538C17.0686 15.2429 17.1386 15.7244 17.4515 16.0373L18.1586 15.3302ZM19.0711 16.2427L19.7782 15.5356V15.5356L19.0711 16.2427ZM19.0711 17.6569L18.364 16.9498L18.364 16.9498L19.0711 17.6569ZM17.6569 19.0711L18.364 19.7782V19.7782L17.6569 19.0711ZM15.3302 18.1586L16.0373 17.4515C15.7243 17.1386 15.2429 17.0686 14.8538 17.2794L15.3302 18.1586ZM14 18.7101L13.7148 17.7517C13.2907 17.8779 13 18.2677 13 18.7101H14ZM10 18.7101H11C11 18.2677 10.7093 17.8779 10.2853 17.7517L10 18.7101ZM8.6698 18.1586L9.14623 17.2794C8.7571 17.0685 8.27565 17.1385 7.96269 17.4515L8.6698 18.1586ZM7.75736 19.071L7.05026 18.3639L7.05026 18.3639L7.75736 19.071ZM6.34315 19.071L5.63604 19.7782H5.63604L6.34315 19.071ZM4.92894 17.6568L4.22183 18.3639H4.22183L4.92894 17.6568ZM4.92894 16.2426L4.22183 15.5355H4.22183L4.92894 16.2426ZM5.84138 15.3302L6.54849 16.0373C6.86144 15.7243 6.93146 15.2429 6.7206 14.8537L5.84138 15.3302ZM5.28989 14L6.24835 13.7147C6.12215 13.2907 5.73231 13 5.28989 13V14ZM5.28989 10V11C5.73231 11 6.12215 10.7093 6.24835 10.2852L5.28989 10ZM5.84138 8.66982L6.7206 9.14625C6.93146 8.75712 6.86145 8.27567 6.54849 7.96272L5.84138 8.66982ZM4.92894 7.75738L4.22183 8.46449H4.22183L4.92894 7.75738ZM4.92894 6.34317L5.63605 7.05027H5.63605L4.92894 6.34317ZM6.34315 4.92895L7.05026 5.63606L7.05026 5.63606L6.34315 4.92895ZM7.75737 4.92895L8.46447 4.22185V4.22185L7.75737 4.92895ZM8.6698 5.84139L7.9627 6.54849C8.27565 6.86145 8.7571 6.93146 9.14623 6.7206L8.6698 5.84139ZM10 5.28988L10.2853 6.24833C10.7093 6.12213 11 5.7323 11 5.28988H10ZM11 2C9.89545 2 9.00002 2.89543 9.00002 4H11V4V2ZM13 2H11V4H13V2ZM15 4C15 2.89543 14.1046 2 13 2V4H15ZM15 5.28988V4H13V5.28988H15ZM15.8066 4.96215C15.3271 4.70233 14.8179 4.48994 14.2853 4.33143L13.7148 6.24833C14.1132 6.36691 14.4944 6.52587 14.8538 6.72058L15.8066 4.96215ZM15.5355 4.2218L14.6231 5.13426L16.0373 6.54847L16.9498 5.63602L15.5355 4.2218ZM18.364 4.2218C17.5829 3.44075 16.3166 3.44075 15.5355 4.2218L16.9498 5.63602V5.63601L18.364 4.2218ZM19.7782 5.63602L18.364 4.2218L16.9498 5.63602L18.364 7.05023L19.7782 5.63602ZM19.7782 8.46444C20.5592 7.68339 20.5592 6.41706 19.7782 5.63602L18.364 7.05023L18.364 7.05023L19.7782 8.46444ZM18.8657 9.37689L19.7782 8.46444L18.364 7.05023L17.4515 7.96268L18.8657 9.37689ZM19.6686 9.71475C19.5101 9.18211 19.2977 8.67285 19.0378 8.19335L17.2794 9.14621C17.4741 9.50555 17.6331 9.8868 17.7517 10.2853L19.6686 9.71475ZM18.7101 11H20V9H18.7101V11ZM20 11H22C22 9.89543 21.1046 9 20 9V11ZM20 11V13H22V11H20ZM20 13V15C21.1046 15 22 14.1046 22 13H20ZM20 13H18.7101V15H20V13ZM19.0378 15.8066C19.2977 15.3271 19.5101 14.8179 19.6686 14.2852L17.7517 13.7148C17.6331 14.1132 17.4741 14.4944 17.2794 14.8538L19.0378 15.8066ZM19.7782 15.5356L18.8657 14.6231L17.4515 16.0373L18.364 16.9498L19.7782 15.5356ZM19.7782 18.364C20.5592 17.5829 20.5592 16.3166 19.7782 15.5356L18.364 16.9498H18.364L19.7782 18.364ZM18.364 19.7782L19.7782 18.364L18.364 16.9498L16.9498 18.364L18.364 19.7782ZM15.5355 19.7782C16.3166 20.5592 17.5829 20.5592 18.364 19.7782L16.9498 18.364L15.5355 19.7782ZM14.6231 18.8657L15.5355 19.7782L16.9498 18.364L16.0373 17.4515L14.6231 18.8657ZM14.2853 19.6686C14.8179 19.5101 15.3271 19.2977 15.8066 19.0378L14.8538 17.2794C14.4944 17.4741 14.1132 17.6331 13.7148 17.7517L14.2853 19.6686ZM15 20V18.7101H13V20H15ZM13 22C14.1046 22 15 21.1046 15 20H13V22ZM11 22H13V20H11V22ZM9.00002 20C9.00002 21.1046 9.89545 22 11 22V20H9.00002ZM9.00002 18.7101V20H11V18.7101H9.00002ZM8.19337 19.0378C8.67287 19.2977 9.18213 19.5101 9.71477 19.6686L10.2853 17.7517C9.88681 17.6331 9.50557 17.4741 9.14623 17.2794L8.19337 19.0378ZM8.46447 19.7782L9.3769 18.8657L7.96269 17.4515L7.05026 18.3639L8.46447 19.7782ZM5.63604 19.7782C6.41709 20.5592 7.68342 20.5592 8.46447 19.7781L7.05026 18.3639L5.63604 19.7782ZM4.22183 18.3639L5.63604 19.7782L7.05026 18.3639L5.63604 16.9497L4.22183 18.3639ZM4.22183 15.5355C3.44078 16.3166 3.44078 17.5829 4.22183 18.3639L5.63604 16.9497V16.9497L4.22183 15.5355ZM5.13427 14.6231L4.22183 15.5355L5.63604 16.9497L6.54849 16.0373L5.13427 14.6231ZM4.33144 14.2852C4.48996 14.8179 4.70234 15.3271 4.96217 15.8066L6.7206 14.8537C6.52589 14.4944 6.36693 14.1132 6.24835 13.7147L4.33144 14.2852ZM5.28989 13H4V15H5.28989V13ZM4 13H4H2C2 14.1046 2.89543 15 4 15V13ZM4 13V11H2V13H4ZM4 11V9C2.89543 9 2 9.89543 2 11H4ZM4 11H5.28989V9H4V11ZM4.96217 8.1934C4.70235 8.67288 4.48996 9.18213 4.33144 9.71475L6.24835 10.2852C6.36693 9.88681 6.52589 9.50558 6.7206 9.14625L4.96217 8.1934ZM4.22183 8.46449L5.13428 9.37693L6.54849 7.96272L5.63605 7.05027L4.22183 8.46449ZM4.22183 5.63606C3.44078 6.41711 3.44079 7.68344 4.22183 8.46449L5.63605 7.05027L5.63605 7.05027L4.22183 5.63606ZM5.63605 4.22185L4.22183 5.63606L5.63605 7.05027L7.05026 5.63606L5.63605 4.22185ZM8.46447 4.22185C7.68343 3.4408 6.4171 3.4408 5.63605 4.22185L7.05026 5.63606V5.63606L8.46447 4.22185ZM9.37691 5.13428L8.46447 4.22185L7.05026 5.63606L7.9627 6.54849L9.37691 5.13428ZM9.71477 4.33143C9.18213 4.48995 8.67287 4.70234 8.19337 4.96218L9.14623 6.7206C9.50557 6.52588 9.88681 6.36692 10.2853 6.24833L9.71477 4.33143ZM9.00002 4V5.28988H11V4H9.00002Z"
					fill="#007bff"
				></path>{" "}
				<circle
					cx="12"
					cy="12"
					r="3"
					stroke="#007bff"
					stroke-width="2"
					stroke-linecap="round"
					stroke-linejoin="round"
				></circle>{" "}
			</g>
		</svg>
	);
}
function SvgColorPaletteIcon(props) {
	return (
		<svg
			fill="#007bff"
			width="64px"
			height="64px"
			viewBox="0 0 256 256"
			id="Flat"
			xmlns="http://www.w3.org/2000/svg"
			style={{ fill: "#007bff" }}
		>
			<g id="SVGRepo_bgCarrier" stroke-width="0"></g>
			<g
				id="SVGRepo_tracerCarrier"
				stroke-linecap="round"
				stroke-linejoin="round"
			></g>
			<g id="SVGRepo_iconCarrier">
				{" "}
				<path d="M203.57422,51.03516A107.94829,107.94829,0,1,0,92.02783,229.86133,36.00178,36.00178,0,0,0,140,195.90234V192a12.01343,12.01343,0,0,1,12-12h46.20947a35.799,35.799,0,0,0,35.10547-27.98535,108.514,108.514,0,0,0,2.68115-24.93945A107.179,107.179,0,0,0,203.57422,51.03516Zm6.33838,95.65918h-.00049A11.92176,11.92176,0,0,1,198.20947,156H152a36.04061,36.04061,0,0,0-36,36v3.90234a12.00172,12.00172,0,0,1-15.98,11.32813A84.01471,84.01471,0,0,1,127.13379,44.00391q.42919-.00439.85791-.00391a84.32979,84.32979,0,0,1,84.00537,83.27637A84.50809,84.50809,0,0,1,209.9126,146.69434ZM144,76a16,16,0,1,1-16-16A16.00008,16.00008,0,0,1,144,76ZM96.8208,109.99854A15.99729,15.99729,0,1,1,90.96533,88.146,15.99745,15.99745,0,0,1,96.8208,109.99854Zm0,36.00292A15.99729,15.99729,0,1,1,74.968,140.146,15.99716,15.99716,0,0,1,96.8208,146.00146Zm90.06665-52A15.99729,15.99729,0,1,1,165.03467,88.146,15.99716,15.99716,0,0,1,186.88745,94.00146Z"></path>{" "}
			</g>
		</svg>
	);
}
function SvgDown(props) {
	return (
		<svg
			width="16"
			height="16"
			viewBox="0 0 24 24"
			fill="none"
			xmlns="http://www.w3.org/2000/svg"
		>
			<g id="SVGRepo_bgCarrier" stroke-width="0" style={{ stroke: "bisque" }}>
				{/* empty */}
			</g>
			<g
				id="SVGRepo_tracerCarrier"
				stroke-linecap="round"
				stroke-linejoin="round"
			>
				{/* empty */}
			</g>
			<g id="SVGRepo_iconCarrier">
				<path
					d="M19 9L12.7071 15.2929C12.3166 15.6834 11.6834 15.6834 11.2929 15.2929L5 9"
					stroke="#000"
					strokeWidth="2"
					strokeLinecap="round"
					strokeLinejoin="round"
				/>
			</g>
		</svg>
	);
}

function SvgClose(props) {
	return (
		<svg
			width="16px"
			height="16px"
			viewBox="0 0 24 24"
			fill="none"
			xmlns="http://www.w3.org/2000/svg"
		>
			<g id="SVGRepo_bgCarrier" stroke-width="0"></g>
			<g
				id="SVGRepo_tracerCarrier"
				stroke-linecap="round"
				stroke-linejoin="round"
			></g>
			<g id="SVGRepo_iconCarrier">
				{" "}
				<path
					d="M8 8L16 16"
					stroke="#000000"
					stroke-width="2"
					stroke-linecap="round"
					stroke-linejoin="round"
				></path>{" "}
				<path
					d="M16 8L8 16"
					stroke="#000000"
					stroke-width="2"
					stroke-linecap="round"
					stroke-linejoin="round"
				></path>{" "}
			</g>
		</svg>
	);
}

function SvgLightbox(props) {
	return (
		<span className="up-pannel-control-icon">
			<svg
				fill="#007bff"
				height="64px"
				width="64px"
				version="1.1"
				id="Capa_1"
				xmlns="http://www.w3.org/2000/svg"
				xmlnsXlink="http://www.w3.org/1999/xlink"
				viewBox="-189.2 -189.2 851.40 851.40"
				xmlSpace="preserve"
				stroke="#007bff"
				strokeWidth="4.73"
				transform="rotate(0)"
			>
				<g id="SVGRepo_bgCarrier" strokeWidth="0"></g>
				<g
					id="SVGRepo_tracerCarrier"
					strokeLinecap="round"
					strokeLinejoin="round"
					stroke="#007bff"
					strokeWidth="12.298"
				></g>
				<g id="SVGRepo_iconCarrier">
					<g>
						<g>
							<path d="M459.5,0H330.4c-7.5,0-13.5,6-13.5,13.5s6,13.5,13.5,13.5h96.5L218.8,235.1c-5.3,5.3-5.3,13.8,0,19.1c2.6,2.6,6.1,4,9.5,4 s6.9-1.3,9.5-4L446,46.1v96.5c0,7.5,6,13.5,13.5,13.5s13.5-6,13.5-13.5V13.5C473,6,467,0,459.5,0z"></path>
							<path d="M459.5,231.2c-7.5,0-13.5,6-13.5,13.5v130.9c0,38.8-31.6,70.4-70.4,70.4H97.4C58.6,446,27,414.4,27,375.6V97.4 C27,58.6,58.6,27,97.4,27h129.9c7.5,0,13.5-6,13.5-13.5S234.8,0,227.3,0H97.4C43.7,0,0,43.7,0,97.4v278.2 C0,429.3,43.7,473,97.4,473h278.2c53.7,0,97.4-43.7,97.4-97.4V244.7C473,237.2,467,231.2,459.5,231.2z"></path>
						</g>
					</g>
				</g>
			</svg>
		</span>
	);
}
function SvgUltimatePortfolioIcon(props) {
	return (
		<svg
			style={{ fill: "none" }}
			width="24px"
			height="24px"
			viewBox="0 0 24 24"
			fill="none"
			xmlns="http://www.w3.org/2000/svg"
		>
			<g id="SVGRepo_bgCarrier" stroke-width="0"></g>
			<g
				id="SVGRepo_tracerCarrier"
				stroke-linecap="round"
				stroke-linejoin="round"
			></g>
			<g id="SVGRepo_iconCarrier">
				{" "}
				<path
					d="M3 6C3 4.34315 4.34315 3 6 3H14C15.6569 3 17 4.34315 17 6V14C17 15.6569 15.6569 17 14 17H6C4.34315 17 3 15.6569 3 14V6Z"
					stroke="#007bff"
					stroke-width="2"
					stroke-linecap="round"
					stroke-linejoin="round"
				></path>{" "}
				<path
					d="M21 7V18C21 19.6569 19.6569 21 18 21H7"
					stroke="#007bff"
					stroke-width="2"
					stroke-linecap="round"
					stroke-linejoin="round"
				></path>{" "}
				<path
					d="M3 12.375L6.66789 8.70711C7.05842 8.31658 7.69158 8.31658 8.08211 8.70711L10.875 11.5M10.875 11.5L13.2304 9.1446C13.6209 8.75408 14.2541 8.75408 14.6446 9.14461L17 11.5M10.875 11.5L12.8438 13.4688"
					stroke="#007bff"
					stroke-width="2"
					stroke-linecap="round"
					stroke-linejoin="round"
				></path>{" "}
			</g>
		</svg>
	);
}
function SvgFilteroptionIcon(props) {
	return (
		<svg
			width="20px"
			height="20px"
			viewBox="0 0 24 24"
			fill="none"
			xmlns="http://www.w3.org/2000/svg"
		>
			<g id="SVGRepo_bgCarrier" stroke-width="0"></g>
			<g
				id="SVGRepo_tracerCarrier"
				stroke-linecap="round"
				stroke-linejoin="round"
			></g>
			<g id="SVGRepo_iconCarrier">
				{" "}
				<path
					d="M5 6H19M7 10H17M5 14H19M7 18H17"
					stroke="#007bff"
					stroke-width="2"
					stroke-linecap="round"
					stroke-linejoin="round"
				></path>{" "}
			</g>
		</svg>
	);
}
function SvgAddfilterIcon(props) {
	return (
		<svg
			style={{ width: "20px", height: "20px", fill: "none" }}
			width="18px"
			height="18px"
			viewBox="0 0 24 24"
			fill="none"
			xmlns="http://www.w3.org/2000/svg"
		>
			<g id="SVGRepo_bgCarrier" stroke-width="0"></g>
			<g
				id="SVGRepo_tracerCarrier"
				stroke-linecap="round"
				stroke-linejoin="round"
			></g>
			<g id="SVGRepo_iconCarrier">
				{" "}
				<path
					d="M7 12L12 12M12 12L17 12M12 12V7M12 12L12 17"
					stroke="#007bff"
					stroke-width="2"
					stroke-linecap="round"
					stroke-linejoin="round"
				></path>{" "}
				<circle
					cx="12"
					cy="12"
					r="9"
					stroke="#007bff"
					stroke-width="2"
					stroke-linecap="round"
					stroke-linejoin="round"
				></circle>{" "}
			</g>
		</svg>
	);
}
function SvgDragHandle(props) {
	return (
		<svg
			width="18px"
			height="18px"
			viewBox="0 0 24 24"
			fill="none"
			xmlns="http://www.w3.org/2000/svg"
		>
			<g id="SVGRepo_bgCarrier" stroke-width="0"></g>
			<g
				id="SVGRepo_tracerCarrier"
				stroke-linecap="round"
				stroke-linejoin="round"
			></g>
			<g id="SVGRepo_iconCarrier">
				{" "}
				<path
					d="M12 9V3.34315M12 3.34315L9.17157 6.17157M12 3.34315L14.8284 6.17157"
					stroke="#007bff"
					stroke-width="2"
					stroke-linecap="round"
					stroke-linejoin="round"
				></path>{" "}
				<path
					d="M15 12H20.6569M20.6569 12L17.8284 9.17157M20.6569 12L17.8284 14.8284"
					stroke="#007bff"
					stroke-width="2"
					stroke-linecap="round"
					stroke-linejoin="round"
				></path>{" "}
				<path
					d="M9 12H3.34315M3.34315 12L6.17157 14.8284M3.34315 12L6.17157 9.17157"
					stroke="#007bff"
					stroke-width="2"
					stroke-linecap="round"
					stroke-linejoin="round"
				></path>{" "}
				<path
					d="M12 15V20.6569M12 20.6569L14.8284 17.8284M12 20.6569L9.17157 17.8284"
					stroke="#007bff"
					stroke-width="2"
					stroke-linecap="round"
					stroke-linejoin="round"
				></path>{" "}
			</g>
		</svg>
	);
}
function SvgEditIcon(props) {
	return (
		<svg
			width="18px"
			height="18px"
			viewBox="0 0 24 24"
			fill="none"
			xmlns="http://www.w3.org/2000/svg"
			style={{ fill: "none" }}
		>
			<g id="SVGRepo_bgCarrier" stroke-width="0"></g>
			<g
				id="SVGRepo_tracerCarrier"
				stroke-linecap="round"
				stroke-linejoin="round"
			></g>
			<g id="SVGRepo_iconCarrier">
				{" "}
				<path
					d="M12 3.99997H6C4.89543 3.99997 4 4.8954 4 5.99997V18C4 19.1045 4.89543 20 6 20H18C19.1046 20 20 19.1045 20 18V12M18.4142 8.41417L19.5 7.32842C20.281 6.54737 20.281 5.28104 19.5 4.5C18.7189 3.71895 17.4526 3.71895 16.6715 4.50001L15.5858 5.58575M18.4142 8.41417L12.3779 14.4505C12.0987 14.7297 11.7431 14.9201 11.356 14.9975L8.41422 15.5858L9.00257 12.6441C9.08001 12.2569 9.27032 11.9013 9.54951 11.6221L15.5858 5.58575M18.4142 8.41417L15.5858 5.58575"
					stroke="#007bff"
					stroke-width="2"
					stroke-linecap="round"
					stroke-linejoin="round"
				></path>{" "}
			</g>
		</svg>
	);
}
function SvgTrashIcon(props) {
	return (
		<svg
			width="18px"
			height="18px"
			viewBox="0 0 24 24"
			fill="none"
			xmlns="http://www.w3.org/2000/svg"
		>
			<g id="SVGRepo_bgCarrier" stroke-width="0"></g>
			<g
				id="SVGRepo_tracerCarrier"
				stroke-linecap="round"
				stroke-linejoin="round"
			></g>
			<g id="SVGRepo_iconCarrier">
				{" "}
				<path
					d="M10 11V17"
					stroke="#FF5252"
					stroke-width="2"
					stroke-linecap="round"
					stroke-linejoin="round"
				></path>{" "}
				<path
					d="M14 11V17"
					stroke="#FF5252"
					stroke-width="2"
					stroke-linecap="round"
					stroke-linejoin="round"
				></path>{" "}
				<path
					d="M4 7H20"
					stroke="#FF5252"
					stroke-width="2"
					stroke-linecap="round"
					stroke-linejoin="round"
				></path>{" "}
				<path
					d="M6 7H12H18V18C18 19.6569 16.6569 21 15 21H9C7.34315 21 6 19.6569 6 18V7Z"
					stroke="#FF5252"
					stroke-width="2"
					stroke-linecap="round"
					stroke-linejoin="round"
				></path>{" "}
				<path
					d="M9 5C9 3.89543 9.89543 3 11 3H13C14.1046 3 15 3.89543 15 5V7H9V5Z"
					stroke="#FF5252"
					stroke-width="2"
					stroke-linecap="round"
					stroke-linejoin="round"
				></path>{" "}
			</g>
		</svg>
	);
}
function SvgDesktoprespIcon(props) {
	return (
		<svg
			style={{ width: "18px", height: "18px", fill: "none" }}
			width="18px"
			height="18px"
			viewBox="0 0 24 24"
			fill="none"
			xmlns="http://www.w3.org/2000/svg"
		>
			<g id="SVGRepo_bgCarrier" stroke-width="0"></g>
			<g
				id="SVGRepo_tracerCarrier"
				stroke-linecap="round"
				stroke-linejoin="round"
			></g>
			<g id="SVGRepo_iconCarrier">
				{" "}
				<rect
					x="4"
					y="4"
					width="16"
					height="12"
					rx="2"
					stroke="#007bff"
					stroke-width="2"
					stroke-linecap="round"
					stroke-linejoin="round"
				></rect>{" "}
				<path
					d="M12 16V20"
					stroke="#007bff"
					stroke-width="2"
					stroke-linecap="round"
					stroke-linejoin="round"
				></path>{" "}
				<path
					d="M8 20H16"
					stroke="#007bff"
					stroke-width="2"
					stroke-linecap="round"
					stroke-linejoin="round"
				></path>{" "}
			</g>
		</svg>
	);
}
function SvgTabrespIcon(props) {
	return (
		<svg
			style={{ width: "18px", height: "18px", fill: "none" }}
			width="64px"
			height="64px"
			viewBox="0 0 24 24"
			fill="none"
			xmlns="http://www.w3.org/2000/svg"
			transform="rotate(90)"
		>
			<g id="SVGRepo_bgCarrier" stroke-width="0"></g>
			<g
				id="SVGRepo_tracerCarrier"
				stroke-linecap="round"
				stroke-linejoin="round"
			></g>
			<g id="SVGRepo_iconCarrier">
				{" "}
				<path
					d="M11 17H13M9 21H15C16.6569 21 18 19.6569 18 18V6C18 4.34315 16.6569 3 15 3H9C7.34315 3 6 4.34315 6 6V18C6 19.6569 7.34315 21 9 21Z"
					stroke="#007fbb"
					stroke-width="2"
					stroke-linecap="round"
				></path>{" "}
			</g>
		</svg>
	);
}
function SvgMobilerespIcon(props) {
	return (
		<svg
			style={{ width: "18px", height: "18px", fill: "none" }}
			width="64px"
			height="64px"
			viewBox="0 0 24 24"
			fill="none"
			xmlns="http://www.w3.org/2000/svg"
		>
			<g id="SVGRepo_bgCarrier" stroke-width="0"></g>
			<g
				id="SVGRepo_tracerCarrier"
				stroke-linecap="round"
				stroke-linejoin="round"
			></g>
			<g id="SVGRepo_iconCarrier">
				{" "}
				<path
					d="M11 17H13M9 21H15C16.6569 21 18 19.6569 18 18V6C18 4.34315 16.6569 3 15 3H9C7.34315 3 6 4.34315 6 6V18C6 19.6569 7.34315 21 9 21Z"
					stroke="#007fbb"
					stroke-width="2"
					stroke-linecap="round"
				></path>{" "}
			</g>
		</svg>
	);
}

function SvgLoadmoreIcon(props) {
	return (
		<span className="up-pannel-control-icon">
			<svg
				width="24px"
				height="24px"
				viewBox="0 0 24 24"
				fill="none"
				xmlns="http://www.w3.org/2000/svg"
				style={{ fill: "none" }}
			>
				<g id="SVGRepo_bgCarrier" stroke-width="0"></g>
				<g
					id="SVGRepo_tracerCarrier"
					stroke-linecap="round"
					stroke-linejoin="round"
				></g>
				<g id="SVGRepo_iconCarrier">
					{" "}
					<circle
						cx="12"
						cy="12"
						r="9"
						stroke="#007bff"
						stroke-width="2"
						stroke-linecap="round"
						stroke-linejoin="round"
					></circle>{" "}
					<path
						d="M12 7V17M12 17L9.5 14.5M12 17L14.5 14.5"
						stroke="#007bff"
						stroke-width="2"
						stroke-linecap="round"
						stroke-linejoin="round"
					></path>{" "}
				</g>
			</svg>
		</span>
	);
}
function SvgUploadimgIcon(props) {
	return (
		<span className="up-pannel-control-icon">
			<svg
				width="24px"
				height="24px"
				viewBox="0 0 24 24"
				fill="none"
				xmlns="http://www.w3.org/2000/svg"
				style={{ fill: "none" }}
			>
				<g id="SVGRepo_bgCarrier" stroke-width="0"></g>
				<g
					id="SVGRepo_tracerCarrier"
					stroke-linecap="round"
					stroke-linejoin="round"
				></g>
				<g id="SVGRepo_iconCarrier">
					{" "}
					<path
						d="M12 4H8.8C7.11984 4 6.27976 4 5.63803 4.32698C5.07354 4.6146 4.6146 5.07354 4.32698 5.63803C4 6.27976 4 7.11984 4 8.8V15.2C4 16.8802 4 17.7202 4.32698 18.362C4.6146 18.9265 5.07354 19.3854 5.63803 19.673C6.27976 20 7.11984 20 8.8 20H15.2C16.8802 20 17.7202 20 18.362 19.673C18.9265 19.3854 19.3854 18.9265 19.673 18.362C20 17.7202 20 16.8802 20 15.2V11"
						stroke="#007bff"
						stroke-width="2"
						stroke-linecap="round"
						stroke-linejoin="round"
					></path>{" "}
					<path
						d="M4 16L8.29289 11.7071C8.68342 11.3166 9.31658 11.3166 9.70711 11.7071L13 15M13 15L15.7929 12.2071C16.1834 11.8166 16.8166 11.8166 17.2071 12.2071L20 15M13 15L15.25 17.25"
						stroke="#007bff"
						stroke-width="2"
						stroke-linecap="round"
						stroke-linejoin="round"
					></path>{" "}
					<path
						d="M15 6L17 8L20.5 4.5"
						stroke="#007bff"
						stroke-width="2"
						stroke-linecap="round"
						stroke-linejoin="round"
					></path>{" "}
				</g>
			</svg>
		</span>
	);
}
function SvgDragIcon(props) {
	return (
		<span className="up-pannel-control-icon">
			<svg
				width="20px"
				height="20px"
				viewBox="0 0 24 24"
				fill="none"
				xmlns="http://www.w3.org/2000/svg"
			>
				<g id="SVGRepo_bgCarrier" stroke-width="0"></g>
				<g
					id="SVGRepo_tracerCarrier"
					stroke-linecap="round"
					stroke-linejoin="round"
				></g>
				<g id="SVGRepo_iconCarrier">
					{" "}
					<path
						d="M12 9V3.34315M12 3.34315L9.17157 6.17157M12 3.34315L14.8284 6.17157"
						stroke="#FFFFFF"
						stroke-width="2"
						stroke-linecap="round"
						stroke-linejoin="round"
					></path>{" "}
					<path
						d="M15 12H20.6569M20.6569 12L17.8284 9.17157M20.6569 12L17.8284 14.8284"
						stroke="#FFFFFF"
						stroke-width="2"
						stroke-linecap="round"
						stroke-linejoin="round"
					></path>{" "}
					<path
						d="M9 12H3.34315M3.34315 12L6.17157 14.8284M3.34315 12L6.17157 9.17157"
						stroke="#FFFFFF"
						stroke-width="2"
						stroke-linecap="round"
						stroke-linejoin="round"
					></path>{" "}
					<path
						d="M12 15V20.6569M12 20.6569L14.8284 17.8284M12 20.6569L9.17157 17.8284"
						stroke="#FFFFFF"
						stroke-width="2"
						stroke-linecap="round"
						stroke-linejoin="round"
					></path>{" "}
				</g>
			</svg>
		</span>
	);
}
function SvgDeleteIcon(props) {
	return (
		<span className="up-pannel-control-icon">
			<svg
				width="18px"
				height="18px"
				viewBox="0 0 24 24"
				fill="none"
				xmlns="http://www.w3.org/2000/svg"
				style={{ fill: "none" }}
			>
				<g id="SVGRepo_bgCarrier" stroke-width="0"></g>
				<g
					id="SVGRepo_tracerCarrier"
					stroke-linecap="round"
					stroke-linejoin="round"
				></g>
				<g id="SVGRepo_iconCarrier">
					{" "}
					<path
						d="M10 11V17"
						stroke="#FFFFFF"
						stroke-width="2"
						stroke-linecap="round"
						stroke-linejoin="round"
					></path>{" "}
					<path
						d="M14 11V17"
						stroke="#FFFFFF"
						stroke-width="2"
						stroke-linecap="round"
						stroke-linejoin="round"
					></path>{" "}
					<path
						d="M4 7H20"
						stroke="#FFFFFF"
						stroke-width="2"
						stroke-linecap="round"
						stroke-linejoin="round"
					></path>{" "}
					<path
						d="M6 7H12H18V18C18 19.6569 16.6569 21 15 21H9C7.34315 21 6 19.6569 6 18V7Z"
						stroke="#FFFFFF"
						stroke-width="2"
						stroke-linecap="round"
						stroke-linejoin="round"
					></path>{" "}
					<path
						d="M9 5C9 3.89543 9.89543 3 11 3H13C14.1046 3 15 3.89543 15 5V7H9V5Z"
						stroke="#FFFFFF"
						stroke-width="2"
						stroke-linecap="round"
						stroke-linejoin="round"
					></path>{" "}
				</g>
			</svg>
		</span>
	);
}
function SvgSettingIcon(props) {
	return (
		<svg
			width="18px"
			height="18px"
			viewBox="0 0 24 24"
			fill="none"
			xmlns="http://www.w3.org/2000/svg"
		>
			<g id="SVGRepo_bgCarrier" stroke-width="0"></g>
			<g
				id="SVGRepo_tracerCarrier"
				stroke-linecap="round"
				stroke-linejoin="round"
			></g>
			<g id="SVGRepo_iconCarrier">
				{" "}
				<path
					d="M14 5.28988H13C13 5.7323 13.2907 6.12213 13.7148 6.24833L14 5.28988ZM15.3302 5.84137L14.8538 6.72058C15.2429 6.93144 15.7243 6.86143 16.0373 6.54847L15.3302 5.84137ZM16.2426 4.92891L15.5355 4.2218V4.2218L16.2426 4.92891ZM17.6569 4.92891L16.9498 5.63601L16.9498 5.63602L17.6569 4.92891ZM19.0711 6.34312L19.7782 5.63602V5.63602L19.0711 6.34312ZM19.0711 7.75734L18.364 7.05023L19.0711 7.75734ZM18.1586 8.66978L17.4515 7.96268C17.1386 8.27563 17.0686 8.75709 17.2794 9.14621L18.1586 8.66978ZM18.7101 10L17.7517 10.2853C17.8779 10.7093 18.2677 11 18.7101 11V10ZM18.7101 14V13C18.2677 13 17.8779 13.2907 17.7517 13.7148L18.7101 14ZM18.1586 15.3302L17.2794 14.8538C17.0686 15.2429 17.1386 15.7244 17.4515 16.0373L18.1586 15.3302ZM19.0711 16.2427L19.7782 15.5356V15.5356L19.0711 16.2427ZM19.0711 17.6569L18.364 16.9498L18.364 16.9498L19.0711 17.6569ZM17.6569 19.0711L18.364 19.7782V19.7782L17.6569 19.0711ZM15.3302 18.1586L16.0373 17.4515C15.7243 17.1386 15.2429 17.0686 14.8538 17.2794L15.3302 18.1586ZM14 18.7101L13.7148 17.7517C13.2907 17.8779 13 18.2677 13 18.7101H14ZM10 18.7101H11C11 18.2677 10.7093 17.8779 10.2853 17.7517L10 18.7101ZM8.6698 18.1586L9.14623 17.2794C8.7571 17.0685 8.27565 17.1385 7.96269 17.4515L8.6698 18.1586ZM7.75736 19.071L7.05026 18.3639L7.05026 18.3639L7.75736 19.071ZM6.34315 19.071L5.63604 19.7782H5.63604L6.34315 19.071ZM4.92894 17.6568L4.22183 18.3639H4.22183L4.92894 17.6568ZM4.92894 16.2426L4.22183 15.5355H4.22183L4.92894 16.2426ZM5.84138 15.3302L6.54849 16.0373C6.86144 15.7243 6.93146 15.2429 6.7206 14.8537L5.84138 15.3302ZM5.28989 14L6.24835 13.7147C6.12215 13.2907 5.73231 13 5.28989 13V14ZM5.28989 10V11C5.73231 11 6.12215 10.7093 6.24835 10.2852L5.28989 10ZM5.84138 8.66982L6.7206 9.14625C6.93146 8.75712 6.86145 8.27567 6.54849 7.96272L5.84138 8.66982ZM4.92894 7.75738L4.22183 8.46449H4.22183L4.92894 7.75738ZM4.92894 6.34317L5.63605 7.05027H5.63605L4.92894 6.34317ZM6.34315 4.92895L7.05026 5.63606L7.05026 5.63606L6.34315 4.92895ZM7.75737 4.92895L8.46447 4.22185V4.22185L7.75737 4.92895ZM8.6698 5.84139L7.9627 6.54849C8.27565 6.86145 8.7571 6.93146 9.14623 6.7206L8.6698 5.84139ZM10 5.28988L10.2853 6.24833C10.7093 6.12213 11 5.7323 11 5.28988H10ZM11 2C9.89545 2 9.00002 2.89543 9.00002 4H11V4V2ZM13 2H11V4H13V2ZM15 4C15 2.89543 14.1046 2 13 2V4H15ZM15 5.28988V4H13V5.28988H15ZM15.8066 4.96215C15.3271 4.70233 14.8179 4.48994 14.2853 4.33143L13.7148 6.24833C14.1132 6.36691 14.4944 6.52587 14.8538 6.72058L15.8066 4.96215ZM15.5355 4.2218L14.6231 5.13426L16.0373 6.54847L16.9498 5.63602L15.5355 4.2218ZM18.364 4.2218C17.5829 3.44075 16.3166 3.44075 15.5355 4.2218L16.9498 5.63602V5.63601L18.364 4.2218ZM19.7782 5.63602L18.364 4.2218L16.9498 5.63602L18.364 7.05023L19.7782 5.63602ZM19.7782 8.46444C20.5592 7.68339 20.5592 6.41706 19.7782 5.63602L18.364 7.05023L18.364 7.05023L19.7782 8.46444ZM18.8657 9.37689L19.7782 8.46444L18.364 7.05023L17.4515 7.96268L18.8657 9.37689ZM19.6686 9.71475C19.5101 9.18211 19.2977 8.67285 19.0378 8.19335L17.2794 9.14621C17.4741 9.50555 17.6331 9.8868 17.7517 10.2853L19.6686 9.71475ZM18.7101 11H20V9H18.7101V11ZM20 11H22C22 9.89543 21.1046 9 20 9V11ZM20 11V13H22V11H20ZM20 13V15C21.1046 15 22 14.1046 22 13H20ZM20 13H18.7101V15H20V13ZM19.0378 15.8066C19.2977 15.3271 19.5101 14.8179 19.6686 14.2852L17.7517 13.7148C17.6331 14.1132 17.4741 14.4944 17.2794 14.8538L19.0378 15.8066ZM19.7782 15.5356L18.8657 14.6231L17.4515 16.0373L18.364 16.9498L19.7782 15.5356ZM19.7782 18.364C20.5592 17.5829 20.5592 16.3166 19.7782 15.5356L18.364 16.9498H18.364L19.7782 18.364ZM18.364 19.7782L19.7782 18.364L18.364 16.9498L16.9498 18.364L18.364 19.7782ZM15.5355 19.7782C16.3166 20.5592 17.5829 20.5592 18.364 19.7782L16.9498 18.364L15.5355 19.7782ZM14.6231 18.8657L15.5355 19.7782L16.9498 18.364L16.0373 17.4515L14.6231 18.8657ZM14.2853 19.6686C14.8179 19.5101 15.3271 19.2977 15.8066 19.0378L14.8538 17.2794C14.4944 17.4741 14.1132 17.6331 13.7148 17.7517L14.2853 19.6686ZM15 20V18.7101H13V20H15ZM13 22C14.1046 22 15 21.1046 15 20H13V22ZM11 22H13V20H11V22ZM9.00002 20C9.00002 21.1046 9.89545 22 11 22V20H9.00002ZM9.00002 18.7101V20H11V18.7101H9.00002ZM8.19337 19.0378C8.67287 19.2977 9.18213 19.5101 9.71477 19.6686L10.2853 17.7517C9.88681 17.6331 9.50557 17.4741 9.14623 17.2794L8.19337 19.0378ZM8.46447 19.7782L9.3769 18.8657L7.96269 17.4515L7.05026 18.3639L8.46447 19.7782ZM5.63604 19.7782C6.41709 20.5592 7.68342 20.5592 8.46447 19.7781L7.05026 18.3639L5.63604 19.7782ZM4.22183 18.3639L5.63604 19.7782L7.05026 18.3639L5.63604 16.9497L4.22183 18.3639ZM4.22183 15.5355C3.44078 16.3166 3.44078 17.5829 4.22183 18.3639L5.63604 16.9497V16.9497L4.22183 15.5355ZM5.13427 14.6231L4.22183 15.5355L5.63604 16.9497L6.54849 16.0373L5.13427 14.6231ZM4.33144 14.2852C4.48996 14.8179 4.70234 15.3271 4.96217 15.8066L6.7206 14.8537C6.52589 14.4944 6.36693 14.1132 6.24835 13.7147L4.33144 14.2852ZM5.28989 13H4V15H5.28989V13ZM4 13H4H2C2 14.1046 2.89543 15 4 15V13ZM4 13V11H2V13H4ZM4 11V9C2.89543 9 2 9.89543 2 11H4ZM4 11H5.28989V9H4V11ZM4.96217 8.1934C4.70235 8.67288 4.48996 9.18213 4.33144 9.71475L6.24835 10.2852C6.36693 9.88681 6.52589 9.50558 6.7206 9.14625L4.96217 8.1934ZM4.22183 8.46449L5.13428 9.37693L6.54849 7.96272L5.63605 7.05027L4.22183 8.46449ZM4.22183 5.63606C3.44078 6.41711 3.44079 7.68344 4.22183 8.46449L5.63605 7.05027L5.63605 7.05027L4.22183 5.63606ZM5.63605 4.22185L4.22183 5.63606L5.63605 7.05027L7.05026 5.63606L5.63605 4.22185ZM8.46447 4.22185C7.68343 3.4408 6.4171 3.4408 5.63605 4.22185L7.05026 5.63606V5.63606L8.46447 4.22185ZM9.37691 5.13428L8.46447 4.22185L7.05026 5.63606L7.9627 6.54849L9.37691 5.13428ZM9.71477 4.33143C9.18213 4.48995 8.67287 4.70234 8.19337 4.96218L9.14623 6.7206C9.50557 6.52588 9.88681 6.36692 10.2853 6.24833L9.71477 4.33143ZM9.00002 4V5.28988H11V4H9.00002Z"
					fill="#FFFFFF"
				></path>{" "}
				<circle
					cx="12"
					cy="12"
					r="3"
					stroke="#FFFFFF"
					stroke-width="2"
					stroke-linecap="round"
					stroke-linejoin="round"
				></circle>{" "}
			</g>
		</svg>
	);
}
function SvgSpinner(props) {
	return (
		<svg
			class="up-spinner"
			width="32px"
			height="32px"
			viewBox="0 0 24 24"
			fill="none"
			xmlns="http://www.w3.org/2000/svg"
		>
			<g id="SVGRepo_bgCarrier" stroke-width="0"></g>
			<g
				id="SVGRepo_tracerCarrier"
				stroke-linecap="round"
				stroke-linejoin="round"
			></g>
			<g id="SVGRepo_iconCarrier">
				<path
					fill-rule="evenodd"
					clip-rule="evenodd"
					d="M12 19C15.866 19 19 15.866 19 12C19 8.13401 15.866 5 12 5C8.13401 5 5 8.13401 5 12C5 15.866 8.13401 19 12 19ZM12 22C17.5228 22 22 17.5228 22 12C22 6.47715 17.5228 2 12 2C6.47715 2 2 6.47715 2 12C2 17.5228 6.47715 22 12 22Z"
					fill="#ddd"
				></path>
				<path
					d="M2 12C2 6.47715 6.47715 2 12 2V5C8.13401 5 5 8.13401 5 12H2Z"
					fill="#007bff"
				></path>
			</g>
		</svg>
	);
}
function SvgPrev(props) {
	return (
		<svg
			width="20px"
			height="20px"
			viewBox="0 0 24 24"
			fill="none"
			xmlns="http://www.w3.org/2000/svg"
		>
			<g id="SVGRepo_bgCarrier" stroke-width="0"></g>
			<g
				id="SVGRepo_tracerCarrier"
				stroke-linecap="round"
				stroke-linejoin="round"
			></g>
			<g id="SVGRepo_iconCarrier">
				{" "}
				<path
					d="M15.5 19L9.20711 12.7071C8.81658 12.3166 8.81658 11.6834 9.20711 11.2929L15.5 5"
					stroke="#000000"
					stroke-width="2"
					stroke-linecap="round"
					stroke-linejoin="round"
				></path>{" "}
			</g>
		</svg>
	);
}
function SvgNext(props) {
	return (
		<svg
			width="20px"
			height="20px"
			viewBox="0 0 24 24"
			fill="none"
			xmlns="http://www.w3.org/2000/svg"
		>
			<g id="SVGRepo_bgCarrier" stroke-width="0"></g>
			<g
				id="SVGRepo_tracerCarrier"
				stroke-linecap="round"
				stroke-linejoin="round"
			></g>
			<g id="SVGRepo_iconCarrier">
				{" "}
				<path
					d="M9.5 5L15.7929 11.2929C16.1834 11.6834 16.1834 12.3166 15.7929 12.7071L9.5 19"
					stroke="#000000"
					stroke-width="2"
					stroke-linecap="round"
					stroke-linejoin="round"
				></path>{" "}
			</g>
		</svg>
	);
}
function SvgPagination(props) {
	return (
		<span className="up-pannel-control-icon">
			<svg
				width="20px"
				height="20px"
				viewBox="0 0 24 24"
				fill="none"
				xmlns="http://www.w3.org/2000/svg"
			>
				<g id="SVGRepo_bgCarrier" stroke-width="0"></g>
				<g
					id="SVGRepo_tracerCarrier"
					stroke-linecap="round"
					stroke-linejoin="round"
				></g>
				<g id="SVGRepo_iconCarrier">
					{" "}
					<path
						d="M6 5C6 5.55228 5.55228 6 5 6C4.44772 6 4 5.55228 4 5C4 4.44772 4.44772 4 5 4C5.55228 4 6 4.44772 6 5Z"
						stroke="#007bff"
						stroke-width="2"
						stroke-linecap="round"
						stroke-linejoin="round"
					></path>{" "}
					<path
						d="M6 12C6 12.5523 5.55228 13 5 13C4.44772 13 4 12.5523 4 12C4 11.4477 4.44772 11 5 11C5.55228 11 6 11.4477 6 12Z"
						stroke="#007bff"
						stroke-width="2"
						stroke-linecap="round"
						stroke-linejoin="round"
					></path>{" "}
					<path
						d="M13 5C13 5.55228 12.5523 6 12 6C11.4477 6 11 5.55228 11 5C11 4.44772 11.4477 4 12 4C12.5523 4 13 4.44772 13 5Z"
						stroke="#007bff"
						stroke-width="2"
						stroke-linecap="round"
						stroke-linejoin="round"
					></path>{" "}
					<path
						d="M13 12C13 12.5523 12.5523 13 12 13C11.4477 13 11 12.5523 11 12C11 11.4477 11.4477 11 12 11C12.5523 11 13 11.4477 13 12Z"
						stroke="#007bff"
						stroke-width="2"
						stroke-linecap="round"
						stroke-linejoin="round"
					></path>{" "}
					<path
						d="M13 19C13 19.5523 12.5523 20 12 20C11.4477 20 11 19.5523 11 19C11 18.4477 11.4477 18 12 18C12.5523 18 13 18.4477 13 19Z"
						stroke="#007bff"
						stroke-width="2"
						stroke-linecap="round"
						stroke-linejoin="round"
					></path>{" "}
					<path
						d="M20 5C20 5.55228 19.5523 6 19 6C18.4477 6 18 5.55228 18 5C18 4.44772 18.4477 4 19 4C19.5523 4 20 4.44772 20 5Z"
						stroke="#007bff"
						stroke-width="2"
						stroke-linecap="round"
						stroke-linejoin="round"
					></path>{" "}
					<path
						d="M20 12C20 12.5523 19.5523 13 19 13C18.4477 13 18 12.5523 18 12C18 11.4477 18.4477 11 19 11C19.5523 11 20 11.4477 20 12Z"
						stroke="#007bff"
						stroke-width="2"
						stroke-linecap="round"
						stroke-linejoin="round"
					></path>{" "}
				</g>
			</svg>
		</span>
	);
}
function SvgPostexclude(props) {
	return (
		<span className="up-pannel-control-icon">
			<svg
				width="20px"
				height="20px"
				viewBox="0 0 24 24"
				fill="none"
				xmlns="http://www.w3.org/2000/svg"
			>
				<path
					d="M13.5 3H12H8C6.34315 3 5 4.34315 5 6V18C5 19.6569 6.34315 21 8 21H10M13.5 3L19 8.625M13.5 3V7.625C13.5 8.17728 13.9477 8.625 14.5 8.625H19M19 8.625V10.8125"
					stroke="#007bff"
					stroke-width="2"
					stroke-linecap="round"
					stroke-linejoin="round"
				/>
				<path
					d="M14.0251 15.0251C13.3918 15.6585 13 16.5335 13 17.5C13 19.433 14.567 21 16.5 21C17.4665 21 18.3415 20.6082 18.9749 19.9749M14.0251 15.0251C14.6585 14.3918 15.5335 14 16.5 14C18.433 14 20 15.567 20 17.5C20 18.4665 19.6082 19.3415 18.9749 19.9749M14.0251 15.0251L16.5 17.5L18.9749 19.9749"
					stroke="#007bff"
					stroke-width="2"
					stroke-linecap="round"
				/>
			</svg>
		</span>
	);
}
function SvgImageAddIcon(props) {
	return (
		<svg
			style={{ fill: "none" }}
			width="20px"
			height="20px"
			viewBox="0 0 24 24"
			fill="none"
			xmlns="http://www.w3.org/2000/svg"
		>
			<g id="SVGRepo_bgCarrier" stroke-width="0"></g>
			<g
				id="SVGRepo_tracerCarrier"
				stroke-linecap="round"
				stroke-linejoin="round"
			></g>
			<g id="SVGRepo_iconCarrier">
				{" "}
				<g id="Edit / Add_To_Queue">
					{" "}
					<path
						id="Vector"
						d="M3 9V19.4C3 19.9601 3 20.2399 3.10899 20.4538C3.20487 20.642 3.35774 20.7952 3.5459 20.8911C3.7596 21 4.0395 21 4.59846 21H15.0001M14 13V10M14 10V7M14 10H11M14 10H17M7 13.8002V6.2002C7 5.08009 7 4.51962 7.21799 4.0918C7.40973 3.71547 7.71547 3.40973 8.0918 3.21799C8.51962 3 9.08009 3 10.2002 3H17.8002C18.9203 3 19.4801 3 19.9079 3.21799C20.2842 3.40973 20.5905 3.71547 20.7822 4.0918C21.0002 4.51962 21.0002 5.07969 21.0002 6.19978L21.0002 13.7998C21.0002 14.9199 21.0002 15.48 20.7822 15.9078C20.5905 16.2841 20.2842 16.5905 19.9079 16.7822C19.4805 17 18.9215 17 17.8036 17H10.1969C9.07899 17 8.5192 17 8.0918 16.7822C7.71547 16.5905 7.40973 16.2842 7.21799 15.9079C7 15.4801 7 14.9203 7 13.8002Z"
						stroke="#007bff"
						stroke-width="2"
						stroke-linecap="round"
						stroke-linejoin="round"
					></path>{" "}
				</g>{" "}
			</g>
		</svg>
	);
}

function SvgContentSlider(props) {
	return (
		<svg
			width="100%"
			height="100%"
			viewBox="0 0 2905 2158"
			version="1.1"
			xmlns="http://www.w3.org/2000/svg"
			xmlnsXlink="http://www.w3.org/1999/xlink"
			xmlSpace="preserve"
			xmlnsSerif="http://www.serif.com/"
			style={{
				fillRule: "evenodd",
				clipRule: "evenodd",
				strokeLinejoin: "round",
				strokeMiterlimit: 2,
			}}
		>
			<path
				d="M1338.4,137.813c0,-73.867 -59.971,-133.842 -133.837,-133.842l-1070.72,-0c-73.871,-0 -133.842,59.975 -133.842,133.842l-0,1070.72c-0,73.867 59.971,133.842 133.842,133.842l1070.72,0c73.866,0 133.837,-59.975 133.837,-133.842l0,-1070.72Z"
				style={{ fill: "#ffbd27" }}
			/>
			<path
				d="M2903.33,133.842c0,-73.871 -59.971,-133.842 -133.842,-133.842l-1070.72,0c-73.866,0 -133.837,59.971 -133.837,133.842l-0,1070.72c-0,73.866 59.971,133.837 133.837,133.837l1070.72,0c73.871,0 133.842,-59.971 133.842,-133.837l0,-1070.72Z"
				style={{ fill: "#ffbd27" }}
			/>
			<rect
				x="930.808"
				y="1874.43"
				width="207.304"
				height="207.304"
				style={{ fill: "#ffbd27" }}
			/>
			<rect
				x="1769.96"
				y="1872.38"
				width="216.467"
				height="216.467"
				style={{ fill: "#ffbd27" }}
			/>
			<rect
				x="1348.43"
				y="1868.28"
				width="216.467"
				height="216.467"
				style={{ fill: "#ffbd27" }}
			/>
			<g>
				<circle
					cx="550.847"
					cy="1964.22"
					r="179.332"
					style={{ fill: "#ffbd27" }}
				/>
				<path
					d="M614.501,2037.24l0.019,37.743l-156.973,-107.808l156.867,-108.025l0.017,33.818l-104.857,72.209l104.927,72.063Z"
					style={{ fill: "#fff" }}
				/>
			</g>
			<g>
				<circle
					cx="2406.42"
					cy="1977.85"
					r="179.332"
					style={{ fill: "#ffbd27" }}
				/>
				<path
					d="M2342.76,2050.87l-0.019,37.743l156.973,-107.807l-156.867,-108.026l-0.016,33.818l104.856,72.209l-104.927,72.063Z"
					style={{ fill: "#fff" }}
				/>
			</g>
		</svg>
	);
}
function SvgCoverflow(props) {
	return (
		<svg
			width="16px"
			height="16px"
			viewBox="0 0 24 24"
			version="1.1"
			xmlns="http://www.w3.org/2000/svg"
		>
			<g
				id="Page-1"
				stroke="none"
				stroke-width="1"
				fill="none"
				fill-rule="evenodd"
			>
				<g
					id="Dribbble-Light-Preview"
					transform="translate(-299.000000, -640.000000)"
					fill="#007bff"
				>
					<g id="icons" transform="translate(56.000000, 160.000000)">
						<path
							d="M247.2,482 C246.6204,482 246.15,482.448 246.15,483 L246.15,495 C246.15,495.552 246.6204,496 247.2,496 C247.7796,496 248.25,495.552 248.25,495 L248.25,483 C248.25,482.448 247.7796,482 247.2,482 L247.2,482 Z M255.6,487 C255.6,486.448 255.1296,486 254.55,486 L252.45,486 C251.8704,486 251.4,486.448 251.4,487 L251.4,491 C251.4,491.552 251.8704,492 252.45,492 L254.55,492 C255.1296,492 255.6,491.552 255.6,491 L255.6,487 Z M257.7,492 C257.7,493.105 256.76025,494 255.6,494 L251.4,494 C250.23975,494 249.3,493.105 249.3,492 L249.3,486 C249.3,484.895 250.23975,484 251.4,484 L255.6,484 C256.76025,484 257.7,484.895 257.7,486 L257.7,492 Z M260.85,495 L260.85,483 C260.85,482.448 260.3796,482 259.8,482 C259.2204,482 258.75,482.448 258.75,483 L258.75,495 C258.75,495.552 259.2204,496 259.8,496 C260.3796,496 260.85,495.552 260.85,495 L260.85,495 Z M261.9,481 L261.9,497 C261.9,497.552 262.3704,498 262.95,498 C263.5296,498 264,497.552 264,497 L264,481 C264,480.448 263.5296,480 262.95,480 C262.3704,480 261.9,480.448 261.9,481 L261.9,481 Z M244.05,498 C243.4704,498 243,497.552 243,497 L243,481 C243,480.448 243.4704,480 244.05,480 C244.6296,480 245.1,480.448 245.1,481 L245.1,497 C245.1,497.552 244.6296,498 244.05,498 L244.05,498 Z"
							id="cover_flow-[#1414]"
						></path>
					</g>
				</g>
			</g>
		</svg>
	);
}
function SvgCard(props) {
	return (
		<svg width="16px" height="16px" viewBox="0 0 24 24" version="1.1">
			<g id="multiple">
				<g>
					<path d="M16,24H0V8h4V4h4V0h16v16h-4v4h-4V24z M2,22h12V10H2V22z M16,18h2V6H6v2h10V18z M20,14h2V2H10v2h10V14z" />
				</g>
			</g>
		</svg>
	);
}
function SvgFade(props) {
	return (
		<svg
			width="16px"
			height="16px"
			viewBox="0 0 24 24"
			version="1.1"
			xmlns="http://www.w3.org/2000/svg"
		>
			<g
				id="Page-1"
				stroke="none"
				stroke-width="1"
				fill="none"
				fill-rule="evenodd"
			>
				<g
					id="Dribbble-Light-Preview"
					transform="translate(-220.000000, -3839.000000)"
					fill="#007bff"
				>
					<g id="icons" transform="translate(56.000000, 160.000000)">
						<path
							d="M166,3695 L182,3695 L182,3681 L166,3681 L166,3695 Z M164,3699 L184,3699 L184,3679 L164,3679 L164,3699 Z"
							id="image_cover-[#986]"
						></path>
					</g>
				</g>
			</g>
		</svg>
	);
}

function SvgContentCheck(props) {
	return (
		<svg
			width="16px"
			height="16px"
			viewBox="0 0 24 24"
			fill="none"
			xmlns="http://www.w3.org/2000/svg"
		>
			<g id="SVGRepo_bgCarrier" stroke-width="0"></g>
			<g
				id="SVGRepo_tracerCarrier"
				stroke-linecap="round"
				stroke-linejoin="round"
			></g>
			<g id="SVGRepo_iconCarrier">
				{" "}
				<g id="style=fill">
					{" "}
					<g id="check-circle">
						{" "}
						<path
							id="Subtract"
							fill-rule="evenodd"
							clip-rule="evenodd"
							d="M12 1.25C6.06294 1.25 1.25 6.06294 1.25 12C1.25 17.9371 6.06294 22.75 12 22.75C17.9371 22.75 22.75 17.9371 22.75 12C22.75 6.06294 17.9371 1.25 12 1.25ZM16.5303 10.0303C16.8232 9.73744 16.8232 9.26256 16.5303 8.96967C16.2374 8.67678 15.7626 8.67678 15.4697 8.96967L10.8434 13.5959C10.7458 13.6935 10.5875 13.6935 10.4899 13.5959L8.53033 11.6363C8.23744 11.3434 7.76256 11.3434 7.46967 11.6363C7.17678 11.9292 7.17678 12.4041 7.46967 12.697L9.42923 14.6566C10.1126 15.34 11.2207 15.34 11.9041 14.6566L16.5303 10.0303Z"
							fill="#007bff"
						></path>{" "}
					</g>{" "}
				</g>{" "}
			</g>
		</svg>
	);
}

function SvgContentGallery(props) {
	return (
		<svg
			viewBox="0 0 24 24"
			xmlns="http://www.w3.org/2000/svg"
			fill="none"
			style={{
				fill: "none",
			}}
		>
			<g id="SVGRepo_bgCarrier" stroke-width="0"></g>
			<g
				id="SVGRepo_tracerCarrier"
				stroke-linecap="round"
				stroke-linejoin="round"
			></g>
			<g id="SVGRepo_iconCarrier">
				<path
					stroke="#007bff"
					stroke-linecap="round"
					stroke-linejoin="round"
					stroke-width="2"
					d="M22 6v12a4 4 0 0 1-4 4H6"
				></path>
				<path
					fill="#007bff"
					fill-rule="evenodd"
					d="M1 3.7A2.7 2.7 0 0 1 3.7 1h12.6A2.7 2.7 0 0 1 19 3.7v5.85c0 .078-.01.153-.028.225A.897.897 0 0 1 19 10v6.3a2.7 2.7 0 0 1-2.7 2.7H3.7A2.7 2.7 0 0 1 1 16.3v-2.7a.9.9 0 0 1 .028-.225A.902.902 0 0 1 1 13.15V3.7zm2.695 8.848a13.81 13.81 0 0 0-.895.04V3.7a.9.9 0 0 1 .9-.9h12.6a.9.9 0 0 1 .9.9v5.414c-3.868.125-6.66 1.057-8.623 2.36.745.265 1.575.64 2.391 1.131 1.26.756 2.54 1.819 3.4 3.225a.9.9 0 1 1-1.535.94c-.663-1.083-1.69-1.96-2.792-2.622-1.1-.66-2.218-1.073-2.994-1.253a13.924 13.924 0 0 0-3.333-.348h-.02zM5.48 5.04a2.403 2.403 0 0 1 1.37-.44c.369 0 .903.103 1.37.44.513.369.88.977.88 1.81 0 .833-.367 1.441-.88 1.81a2.403 2.403 0 0 1-1.37.44c-.369 0-.903-.103-1.37-.44-.513-.369-.88-.977-.88-1.81 0-.833.367-1.441.88-1.81z"
					clip-rule="evenodd"
				></path>
			</g>
		</svg>
	);
}

function SvgContentPosts(props) {
	return (
		<svg
			width="100%"
			height="100%"
			viewBox="0 0 3597 2211"
			version="1.1"
			xmlns="http://www.w3.org/2000/svg"
			xmlnsXlink="http://www.w3.org/1999/xlink"
			xmlSpace="preserve"
			xmlnsSerif="http://www.serif.com/"
			style={{
				fillRule: "evenodd",
				clipRule: "evenodd",
				strokeLinejoin: "round",
				strokeMiterlimit: 2,
			}}
		>
			<path
				d="M3596.59,203.689c-0,-112.419 -91.27,-203.689 -203.689,-203.689l-3189.21,0c-112.419,0 -203.689,91.27 -203.689,203.689l0,1802.85c0,112.419 91.27,203.689 203.689,203.689l3189.21,0c112.419,0 203.689,-91.27 203.689,-203.689l-0,-1802.85Z"
				style={{ fill: "#007bff" }}
			/>
			<g>
				<path
					d="M1641.13,577.014c-0,-108.696 -88.248,-196.943 -196.944,-196.943l-919.068,-0c-108.696,-0 -196.943,88.247 -196.943,196.943l-0,1019.52c-0,108.696 88.247,196.943 196.943,196.943l919.068,0c108.696,0 196.944,-88.247 196.944,-196.943l-0,-1019.52Z"
					style={{ fill: "#fff" }}
				/>
				<g>
					<path
						d="M3248.75,622.323c-0,-20.017 -16.252,-36.268 -36.269,-36.268l-1236.44,-0c-20.018,-0 -36.269,16.251 -36.269,36.268l0,72.537c0,20.017 16.251,36.269 36.269,36.269l1236.44,-0c20.017,-0 36.269,-16.252 36.269,-36.269l-0,-72.537Z"
						style={{ fill: "#fff" }}
					/>
					<path
						d="M3254.71,1097.37c-0,-20.017 -16.252,-36.268 -36.269,-36.268l-1236.44,-0c-20.018,-0 -36.269,16.251 -36.269,36.268l0,72.537c0,20.017 16.251,36.268 36.269,36.268l1236.44,0c20.017,0 36.269,-16.251 36.269,-36.268l-0,-72.537Z"
						style={{ fill: "#fff" }}
					/>
					<path
						d="M2756.38,1526.93c-0,-20.017 -16.251,-36.268 -36.268,-36.268l-738.114,-0c-20.018,-0 -36.269,16.251 -36.269,36.268l0,72.537c0,20.017 16.251,36.268 36.269,36.268l738.114,0c20.017,0 36.268,-16.251 36.268,-36.268l-0,-72.537Z"
						style={{ fill: "#fff" }}
					/>
				</g>
			</g>
		</svg>
	);
}
function SvgContentSocial(props) {
	return (
		<svg
			width="100%"
			height="100%"
			viewBox="0 0 3597 2211"
			version="1.1"
			xmlns="http://www.w3.org/2000/svg"
			xmlnsXlink="http://www.w3.org/1999/xlink"
			xmlSpace="preserve"
			xmlnsSerif="http://www.serif.com/"
			style={{
				fillRule: "evenodd",
				clipRule: "evenodd",
				strokeLinejoin: "round",
				strokeMiterlimit: 2,
			}}
		>
			<path
				d="M3596.59,203.689c-0,-112.419 -91.27,-203.689 -203.689,-203.689l-3189.21,-0c-112.419,-0 -203.689,91.27 -203.689,203.689l0,1802.85c0,112.419 91.27,203.689 203.689,203.689l3189.21,0c112.419,0 203.689,-91.27 203.689,-203.689l-0,-1802.85Z"
				style={{ fill: "#007bff" }}
			/>
			<g>
				<circle
					cx="1025.79"
					cy="1477.92"
					r="227.481"
					style={{ fill: "#fff" }}
				/>
				<circle
					cx="1989.51"
					cy="732.308"
					r="227.481"
					style={{ fill: "#fff" }}
				/>
				<path
					d="M2528.75,1315.1l-416.879,-500.642l-65.472,54.518l416.879,500.642l65.472,-54.518Z"
					style={{ fill: "#fff" }}
				/>
				<path
					d="M1178.37,1411.7l695.261,-538.432l-52.166,-67.361l-695.261,538.432l52.166,67.361Z"
					style={{ fill: "#fff" }}
				/>
				<circle cx="2570.8" cy="1457.23" r="227.481" style={{ fill: "#fff" }} />
			</g>
		</svg>
	);
}
function SvgRightArrow(props) {
	return (
		<svg
			width="16px"
			height="16px"
			viewBox="0 0 24 24"
			xmlns="http://www.w3.org/2000/svg"
			fill="#000000"
		>
			<g id="SVGRepo_bgCarrier" stroke-width="0"></g>
			<g
				id="SVGRepo_tracerCarrier"
				stroke-linecap="round"
				stroke-linejoin="round"
			></g>
			<g id="SVGRepo_iconCarrier">
				{" "}
				<title></title>{" "}
				<g id="Complete">
					{" "}
					<g id="arrow-right">
						{" "}
						<g>
							{" "}
							<polyline
								data-name="Right"
								fill="none"
								id="Right-2"
								points="16.4 7 21.5 12 16.4 17"
								stroke="#ffffff"
								stroke-linecap="round"
								stroke-linejoin="round"
								stroke-width="2"
							></polyline>{" "}
							<line
								fill="none"
								stroke="#ffffff"
								stroke-linecap="round"
								stroke-linejoin="round"
								stroke-width="2"
								x1="2.5"
								x2="19.2"
								y1="12"
								y2="12"
							></line>{" "}
						</g>{" "}
					</g>{" "}
				</g>{" "}
			</g>
		</svg>
	);
}

function SvgLayoutGrid(props) {
	return (
		<svg
			width="64px"
			height="64px"
			viewBox="0 0 24 24"
			xmlns="http://www.w3.org/2000/svg"
			fill="#007bff"
		>
			<g id="SVGRepo_bgCarrier" stroke-width="0"></g>
			<g
				id="SVGRepo_tracerCarrier"
				stroke-linecap="round"
				stroke-linejoin="round"
			></g>
			<g id="SVGRepo_iconCarrier">
				{" "}
				<g>
					{" "}
					<path fill="none" d="M0 0h24v24H0z"></path>{" "}
					<path d="M22 12.999V20a1 1 0 0 1-1 1h-8v-8.001h9zm-11 0V21H3a1 1 0 0 1-1-1v-7.001h9zM11 3v7.999H2V4a1 1 0 0 1 1-1h8zm10 0a1 1 0 0 1 1 1v6.999h-9V3h8z"></path>{" "}
				</g>{" "}
			</g>
		</svg>
	);
}
function SvgLayoutMasonry(props) {
	return (
		<svg
			width="64px"
			height="64px"
			viewBox="0 0 24 24"
			xmlns="http://www.w3.org/2000/svg"
			fill="#007bff"
		>
			<g id="SVGRepo_bgCarrier" stroke-width="0"></g>
			<g
				id="SVGRepo_tracerCarrier"
				stroke-linecap="round"
				stroke-linejoin="round"
			></g>
			<g id="SVGRepo_iconCarrier">
				{" "}
				<g>
					{" "}
					<path fill="none" d="M0 0h24v24H0z"></path>{" "}
					<path d="M22 9.999V20a1 1 0 0 1-1 1h-8V9.999h9zm-11 6V21H3a1 1 0 0 1-1-1v-4.001h9zM11 3v10.999H2V4a1 1 0 0 1 1-1h8zm10 0a1 1 0 0 1 1 1v3.999h-9V3h8z"></path>{" "}
				</g>{" "}
			</g>
		</svg>
	);
}
function SvgLayoutSlider(props) {
	return (
		<svg
			fill="#007bff"
			width="64px"
			height="64px"
			viewBox="0 0 24 24"
			xmlns="http://www.w3.org/2000/svg"
		>
			<g id="SVGRepo_bgCarrier" stroke-width="0"></g>
			<g
				id="SVGRepo_tracerCarrier"
				stroke-linecap="round"
				stroke-linejoin="round"
			></g>
			<g id="SVGRepo_iconCarrier">
				<path d="M16 3H8c-1.103 0-2 .897-2 2v14c0 1.103.897 2 2 2h8c1.103 0 2-.897 2-2V5c0-1.103-.897-2-2-2zM2 7v10c0 1.103.897 2 2 2V5c-1.103 0-2 .897-2 2zm18-2v14c1.103 0 2-.897 2-2V7c0-1.103-.897-2-2-2z"></path>
			</g>
		</svg>
	);
}
function SvgFilterWiz(props) {
	return (
		<svg
			width="64px"
			height="64px"
			viewBox="0 0 24 24"
			xmlns="http://www.w3.org/2000/svg"
			fill="#007bff"
		>
			<g id="SVGRepo_bgCarrier" stroke-width="0"></g>
			<g
				id="SVGRepo_tracerCarrier"
				stroke-linecap="round"
				stroke-linejoin="round"
			></g>
			<g id="SVGRepo_iconCarrier">
				<path d="M20.5 17h-17A2.502 2.502 0 0 1 1 14.5v-4A2.502 2.502 0 0 1 3.5 8h17a2.502 2.502 0 0 1 2.5 2.5v4a2.502 2.502 0 0 1-2.5 2.5zm-17-8A1.502 1.502 0 0 0 2 10.5v4A1.502 1.502 0 0 0 3.5 16h17a1.502 1.502 0 0 0 1.5-1.5v-4A1.502 1.502 0 0 0 20.5 9zM17 12H7v1h10z"></path>
				<path fill="none" d="M0 0h24v24H0z"></path>
			</g>
		</svg>
	);
}
function SvgPaginationWiz(props) {
	return (
		<svg
			width="64px"
			height="64px"
			viewBox="0 0 24 24"
			fill="none"
			xmlns="http://www.w3.org/2000/svg"
			style={{ transform: "rotate(45deg)", fill: "none" }}
		>
			<g id="SVGRepo_bgCarrier" stroke-width="0"></g>
			<g
				id="SVGRepo_tracerCarrier"
				stroke-linecap="round"
				stroke-linejoin="round"
			></g>
			<g id="SVGRepo_iconCarrier">
				{" "}
				<g id="Arrow / Expand">
					{" "}
					<path
						id="Vector"
						d="M10 19H5V14M14 5H19V10"
						stroke="#007bff"
						stroke-width="1"
						stroke-linecap="round"
						stroke-linejoin="round"
					></path>{" "}
				</g>{" "}
			</g>
		</svg>
	);
}
function SvgYoutube(props) {
	return (
		<svg
			width="20px"
			height="20px"
			viewBox="0 0 48 48"
			xmlns="http://www.w3.org/2000/svg"
			fill="#fff"
		>
			<g id="SVGRepo_bgCarrier" strokeWidth="0" />
			<g
				id="SVGRepo_tracerCarrier"
				strokeLinecap="round"
				strokeLinejoin="round"
				stroke="#CCCCCC"
				strokeWidth="2.4"
			>
				<defs>
					<style>{`.a{fill:none;stroke:#007bff;stroke-linecap:round;stroke-linejoin:round;}`}</style>
				</defs>
				<path
					className="a"
					d="M43.1124,14.394a5.0056,5.0056,0,0,0-3.5332-3.5332c-2.3145-.8936-24.7326-1.3314-31.2358.0256A5.0059,5.0059,0,0,0,4.81,14.42c-1.0446,4.583-1.1239,14.4914.0256,19.1767A5.006,5.006,0,0,0,8.369,37.13c4.5829,1.0548,26.3712,1.2033,31.2358,0a5.0057,5.0057,0,0,0,3.5332-3.5333C44.2518,28.6037,44.3311,19.31,43.1124,14.394Z"
				></path>
				<path className="a" d="M30.5669,23.9952,20.1208,18.004V29.9863Z"></path>
			</g>
			<g id="SVGRepo_iconCarrier">
				<defs>
					<style>{`.a{fill:none;stroke:#007bff;stroke-linecap:round;stroke-linejoin:round;}`}</style>
				</defs>
				<path
					className="a"
					d="M43.1124,14.394a5.0056,5.0056,0,0,0-3.5332-3.5332c-2.3145-.8936-24.7326-1.3314-31.2358.0256A5.0059,5.0059,0,0,0,4.81,14.42c-1.0446,4.583-1.1239,14.4914.0256,19.1767A5.006,5.006,0,0,0,8.369,37.13c4.5829,1.0548,26.3712,1.2033,31.2358,0a5.0057,5.0057,0,0,0,3.5332-3.5333C44.2518,28.6037,44.3311,19.31,43.1124,14.394Z"
				></path>
				<path className="a" d="M30.5669,23.9952,20.1208,18.004V29.9863Z"></path>
			</g>
		</svg>
	);
}

function SvgInstagram(props) {
	return (
		<svg
			width="64px"
			height="64px"
			viewBox="-4.8 -4.8 57.60 57.60"
			id="Layer_2"
			data-name="Layer 2"
			xmlns="http://www.w3.org/2000/svg"
			fill="#000000"
		>
			<g id="SVGRepo_bgCarrier" strokeWidth="0" />
			<g
				id="SVGRepo_tracerCarrier"
				strokeLinecap="round"
				strokeLinejoin="round"
				stroke="#CCCCCC"
				strokeWidth="2.4"
			>
				<defs>
					<style>{`.cls-1{fill:none;stroke:#007bff;stroke-linecap:round;stroke-linejoin:round;}`}</style>
				</defs>
				<path
					className="cls-1"
					d="M35.38,10.46a2.19,2.19,0,1,0,2.16,2.22v-.06A2.18,2.18,0,0,0,35.38,10.46Z"
				/>
				<path
					className="cls-1"
					d="M40.55,5.5H7.45a2,2,0,0,0-1.95,2v33.1a2,2,0,0,0,2,2h33.1a2,2,0,0,0,2-2V7.45A2,2,0,0,0,40.55,5.5Z"
				/>
				<path
					className="cls-1"
					d="M24,15.72A8.28,8.28,0,1,0,32.28,24h0A8.28,8.28,0,0,0,24,15.72Z"
				/>
			</g>
			<g id="SVGRepo_iconCarrier">
				<defs>
					<style>{`.cls-1{fill:none;stroke:#007bff;stroke-linecap:round;stroke-linejoin:round;}`}</style>
				</defs>
				<path
					className="cls-1"
					d="M35.38,10.46a2.19,2.19,0,1,0,2.16,2.22v-.06A2.18,2.18,0,0,0,35.38,10.46Z"
				/>
				<path
					className="cls-1"
					d="M40.55,5.5H7.45a2,2,0,0,0-1.95,2v33.1a2,2,0,0,0,2,2h33.1a2,2,0,0,0,2-2V7.45A2,2,0,0,0,40.55,5.5Z"
				/>
				<path
					className="cls-1"
					d="M24,15.72A8.28,8.28,0,1,0,32.28,24h0A8.28,8.28,0,0,0,24,15.72Z"
				/>
			</g>
		</svg>
	);
}
function SvgFlickr(props) {
	return (
		<svg
			width="20px"
			height="20px"
			viewBox="0 0 48 48"
			id="Layer_2"
			data-name="Layer 2"
			xmlns="http://www.w3.org/2000/svg"
			fill="#000000"
		>
			<g id="SVGRepo_bgCarrier" strokeWidth="0" />
			<g
				id="SVGRepo_tracerCarrier"
				strokeLinecap="round"
				strokeLinejoin="round"
				stroke="#CCCCCC"
				strokeWidth="2.4"
			>
				<defs>
					<style>{`.cls-1{fill:none;stroke:#007bff;stroke-linecap:round;stroke-linejoin:round;}`}</style>
				</defs>
				<circle className="cls-1" cx="34.14" cy="24" r="9.36" />
				<circle className="cls-1" cx="13.86" cy="24" r="9.36" />
			</g>
			<g id="SVGRepo_iconCarrier">
				<defs>
					<style>{`.cls-1{fill:none;stroke:#007bff;stroke-linecap:round;stroke-linejoin:round;}`}</style>
				</defs>
				<circle className="cls-1" cx="34.14" cy="24" r="9.36" />
				<circle className="cls-1" cx="13.86" cy="24" r="9.36" />
			</g>
		</svg>
	);
}
function SvgVimeoicon(props) {
	return (
		<svg
			width="20px"
			height="20px"
			viewBox="0 -3.5 48 48"
			version="1.1"
			xmlns="http://www.w3.org/2000/svg"
		>
			<g
				id="Icons"
				stroke="#007bff"
				stroke-width="2.4"
				fill="none"
				fill-rule="evenodd"
			>
				<g
					id="Color-"
					transform="translate(-300.000000, -365.000000)"
					fill="none"
				>
					<path
						d="M347.975851,374.479329 C347.767002,379.100014 344.498808,385.41644 338.193846,393.431401 C331.668746,401.81233 326.13991,406 321.621448,406 C318.827396,406 316.459507,403.452198 314.526249,398.339832 C313.230825,393.649305 311.943867,388.958779 310.651265,384.282221 C309.211905,379.167061 307.670943,376.610878 306.022735,376.610878 C305.664306,376.610878 304.414038,377.356781 302.25782,378.85138 L300,375.971134 C302.365066,373.917807 304.696265,371.856098 306.996419,369.799977 C310.146078,367.101318 312.513967,365.684941 314.094441,365.536878 C317.819844,365.179292 320.117175,367.701951 320.983614,373.096476 C321.906498,378.921221 322.555621,382.541782 322.91405,383.960952 C323.992159,388.788367 325.17187,391.196487 326.464472,391.196487 C327.466379,391.196487 328.973474,389.637634 330.982934,386.517135 C332.992393,383.391049 334.062036,381.016453 334.208794,379.379378 C334.496666,376.680719 333.421379,375.339771 330.982934,375.339771 C329.834268,375.339771 328.648912,375.580024 327.432512,376.08288 C329.803223,368.486965 334.318863,364.793769 340.99072,365.00888 C345.932524,365.145768 348.266545,368.308172 347.975851,374.479329"
						id="Vimeo"
					></path>
				</g>
			</g>
		</svg>
	);
}
function Svgunsplashicon(props) {
	return (
		<svg
			width="20px"
			height="20px"
			viewBox="0 0 24 24"
			xmlns="http://www.w3.org/2000/svg"
		>
			<g fill="#007bff">
				<path fill="none" d="M0 0H24V24H0z" />
				<path d="M10 10v4h4v-4h7v11H3V10h7zm-2 2H5v7h14v-7h-3l-.001 4H8v-4zm8-9v6H8V3h8zm-2 2h-4v2h4V5z" />
			</g>
		</svg>
	);
}
function SvgFile(props) {
	return (
		<svg
			width="64px"
			height="64px"
			viewBox="0 0 24 24"
			fill="none"
			xmlns="http://www.w3.org/2000/svg"
			style={{ fill: "none" }}
		>
			<g id="SVGRepo_bgCarrier" stroke-width="0"></g>
			<g
				id="SVGRepo_tracerCarrier"
				stroke-linecap="round"
				stroke-linejoin="round"
			></g>
			<g id="SVGRepo_iconCarrier">
				{" "}
				<path
					d="M13.5 3H12H8C6.34315 3 5 4.34315 5 6V18C5 19.6569 6.34315 21 8 21H16C17.6569 21 19 19.6569 19 18V8.625M13.5 3L19 8.625M13.5 3V7.625C13.5 8.17728 13.9477 8.625 14.5 8.625H19"
					stroke="#007bff"
					stroke-width="2"
					stroke-linecap="round"
					stroke-linejoin="round"
				></path>{" "}
				<path
					d="M9 13H15"
					stroke="#007bff"
					stroke-width="2"
					stroke-linecap="round"
					stroke-linejoin="round"
				></path>{" "}
				<path
					d="M9 17H15"
					stroke="#007bff"
					stroke-width="2"
					stroke-linecap="round"
					stroke-linejoin="round"
				></path>{" "}
			</g>
		</svg>
	);
}
function SvgCode(props) {
	return (
		<span className="up-pannel-control-icon">
			<svg
				width="64px"
				height="64px"
				viewBox="0 0 24 24"
				fill="none"
				xmlns="http://www.w3.org/2000/svg"
			>
				<g id="SVGRepo_bgCarrier" stroke-width="0"></g>
				<g
					id="SVGRepo_tracerCarrier"
					stroke-linecap="round"
					stroke-linejoin="round"
				></g>
				<g id="SVGRepo_iconCarrier">
					{" "}
					<path
						d="M9 7L4 12L9 17"
						stroke="#007bff"
						stroke-width="2"
						stroke-linecap="round"
						stroke-linejoin="round"
					></path>{" "}
					<path
						d="M15 7L20 12L15 17"
						stroke="#007bff"
						stroke-width="2"
						stroke-linecap="round"
						stroke-linejoin="round"
					></path>{" "}
				</g>
			</svg>
		</span>
	);
}
function SvgTag(props) {
	return (
		<svg
			width="64px"
			height="64px"
			viewBox="0 0 24 24"
			fill="none"
			xmlns="http://www.w3.org/2000/svg"
			style={{ fill: "none" }}
		>
			<g id="SVGRepo_bgCarrier" stroke-width="0"></g>
			<g
				id="SVGRepo_tracerCarrier"
				stroke-linecap="round"
				stroke-linejoin="round"
			></g>
			<g id="SVGRepo_iconCarrier">
				{" "}
				<path
					d="M11.1716 3H5C3.89543 3 3 3.89543 3 5V11.1716C3 11.702 3.21071 12.2107 3.58579 12.5858L10.8787 19.8787C12.0503 21.0503 13.9497 21.0503 15.1213 19.8787L19.8787 15.1213C21.0503 13.9497 21.0503 12.0503 19.8787 10.8787L12.5858 3.58579C12.2107 3.21071 11.702 3 11.1716 3Z"
					stroke="#007bff"
					stroke-width="2"
					stroke-linecap="round"
					stroke-linejoin="round"
				></path>{" "}
				<circle cx="7.5" cy="7.5" r="1.5" fill="#007bff"></circle>{" "}
			</g>
		</svg>
	);
}
function SvgScroll(props) {
	return (
		<svg
			width="64px"
			height="64px"
			viewBox="0 0 24 24"
			fill="none"
			xmlns="http://www.w3.org/2000/svg"
		>
			<g id="SVGRepo_bgCarrier" stroke-width="0"></g>
			<g
				id="SVGRepo_tracerCarrier"
				stroke-linecap="round"
				stroke-linejoin="round"
			></g>
			<g id="SVGRepo_iconCarrier">
				{" "}
				<path
					fill-rule="evenodd"
					clip-rule="evenodd"
					d="M12.0006 10.9409L9.53062 8.46979L8.46973 9.53021L12.0006 13.0626L15.5315 9.53021L14.4706 8.46979L12.0006 10.9409Z"
					fill="#007bff"
				></path>{" "}
				<path
					fill-rule="evenodd"
					clip-rule="evenodd"
					d="M12.0006 14.9409L9.53062 12.4698L8.46973 13.5302L12.0006 17.0626L15.5315 13.5302L14.4706 12.4698L12.0006 14.9409Z"
					fill="#007bff"
				></path>{" "}
			</g>
		</svg>
	);
}
function SvgItemControl(props) {
	return (
		<span className="up-pannel-control-icon">
			<svg
				width="64px"
				height="64px"
				viewBox="0 0 24 24"
				fill="none"
				xmlns="http://www.w3.org/2000/svg"
				style={{ fill: "none" }}
			>
				<g id="SVGRepo_bgCarrier" stroke-width="0"></g>
				<g
					id="SVGRepo_tracerCarrier"
					stroke-linecap="round"
					stroke-linejoin="round"
				></g>
				<g id="SVGRepo_iconCarrier">
					{" "}
					<path
						d="M3 10V18C3 19.1046 3.89543 20 5 20H11M3 10V6C3 4.89543 3.89543 4 5 4H19C20.1046 4 21 4.89543 21 6V10M3 10H21M21 10V12"
						stroke="#007bff"
						stroke-width="2"
						stroke-linecap="round"
						stroke-linejoin="round"
					></path>{" "}
					<circle cx="6" cy="7" r="1" fill="#007bff"></circle>{" "}
					<circle cx="9" cy="7" r="1" fill="#007bff"></circle>{" "}
					<path
						d="M18 15.75C18.641 15.75 19.2007 16.1019 19.5002 16.6249M18 15.75C17.3589 15.75 16.7992 16.1019 16.4997 16.6249M18 15.75V14M18 21V19.2209M21 15.75L19.5002 16.6249M15 19.25L16.4997 18.3751M21 19.25L19.5003 18.3752M15 15.75L16.4997 16.6249M16.4997 18.3751C16.3523 18.1177 16.2679 17.8188 16.2679 17.5C16.2679 17.1812 16.3523 16.8823 16.4997 16.6249M16.4997 18.3751C16.8408 18.9707 17.4229 19.2326 18 19.2209M18 19.2209C18.5958 19.2088 19.1862 18.9049 19.5003 18.3752M19.5003 18.3752C19.6458 18.1298 19.732 17.8358 19.732 17.5C19.732 17.1812 19.6477 16.8823 19.5002 16.6249"
						stroke="#007bff"
						stroke-width="2"
						stroke-linecap="round"
					></path>{" "}
				</g>
			</svg>
		</span>
	);
}
function SvgLayoutWave(props) {
	return (
		<svg
			width="100%"
			height="100%"
			viewBox="0 0 3568 3951"
			version="1.1"
			xmlns="http://www.w3.org/2000/svg"
			xmlnsXlink="http://www.w3.org/1999/xlink"
			xmlSpace="preserve"
			xmlnsSerif="http://www.serif.com/"
			style={{
				fillRule: "evenodd",
				clipRule: "evenodd",
				strokeLinecap: "round",
				strokeLinejoin: "round",
				strokeMiterlimit: "1.5",
			}}
		>
			<path
				d="M3421.7,473.42c0,-180.8 -146.786,-327.587 -327.586,-327.587l-2620.69,0c-180.8,0 -327.587,146.787 -327.587,327.587l0,3003.67c0,180.8 146.787,327.587 327.587,327.587l2620.69,-0c180.8,-0 327.586,-146.787 327.586,-327.587l0,-3003.67Z"
				style={{ fill: "#fff", stroke: "#007bff", strokeWidth: "291.67px" }}
			/>
			<path
				d="M3402.07,3131.26l-3247.73,-0l0,399.483c0,124.02 100.689,224.709 224.709,224.709l2785.83,-0c130.911,-0 237.193,-106.283 237.193,-237.193l0,-386.999Z"
				style={{ fill: "#007bff" }}
			/>
			<path
				d="M148.619,1958.32c295.01,959.322 1015.51,1016.78 1688.6,557.498c692.509,-472.528 719.272,-478.969 1474.94,-444.277l66.198,1214.23l-3223.64,13.614l-6.094,-1341.07Z"
				style={{ fill: "#007bff", stroke: "#007bff", strokeWidth: "14.64px" }}
			/>
		</svg>
	);
}
function SvgLayoutClassic(props) {
	return (
		<svg
			width="100%"
			height="100%"
			viewBox="0 0 3568 3951"
			version="1.1"
			xmlns="http://www.w3.org/2000/svg"
			xmlnsXlink="http://www.w3.org/1999/xlink"
			xmlSpace="preserve"
			xmlnsSerif="http://www.serif.com/"
			style={{
				fillRule: "evenodd",
				clipRule: "evenodd",
				strokeLinecap: "round",
				strokeLinejoin: "round",
				strokeMiterlimit: "1.5",
			}}
		>
			<path
				d="M3421.7,473.42c0,-180.8 -146.786,-327.587 -327.586,-327.587l-2620.69,0c-180.8,0 -327.587,146.787 -327.587,327.587l0,3003.67c0,180.8 146.787,327.587 327.587,327.587l2620.69,-0c180.8,-0 327.586,-146.787 327.586,-327.587l0,-3003.67Z"
				style={{ fill: "#fff", stroke: "#007bff", strokeWidth: "291.67px" }}
			/>
			<path
				d="M3402.07,3131.26l-3247.73,-0l0,399.483c0,124.02 100.689,224.709 224.709,224.709l2785.83,-0c130.911,-0 237.193,-106.283 237.193,-237.193l0,-386.999Z"
				style={{ fill: "#007bff" }}
			/>
			<rect
				x="191.145"
				y="2420.44"
				width="3103.94"
				height="1191.56"
				style={{ fill: "#007bff", stroke: "#007bff", strokeWidth: "291.67px" }}
			/>
		</svg>
	);
}
function SvgLayoutTilt(props) {
	return (
		<svg
			width="100%"
			height="100%"
			viewBox="0 0 3568 3951"
			version="1.1"
			xmlns="http://www.w3.org/2000/svg"
			xmlnsXlink="http://www.w3.org/1999/xlink"
			xmlSpace="preserve"
			xmlnsSerif="http://www.serif.com/"
			style={{
				fillRule: "evenodd",
				clipRule: "evenodd",
				strokeLinecap: "round",
				strokeLinejoin: "round",
				strokeMiterlimit: "1.5",
			}}
		>
			<path
				d="M3421.7,473.42c0,-180.8 -146.786,-327.587 -327.586,-327.587l-2620.69,0c-180.8,0 -327.587,146.787 -327.587,327.587l0,3003.67c0,180.8 146.787,327.587 327.587,327.587l2620.69,-0c180.8,-0 327.586,-146.787 327.586,-327.587l0,-3003.67Z"
				style={{ fill: "#fff", stroke: "#007bff", strokeWidth: "291.67px" }}
			/>
			<path
				d="M776.498,3046.75l19.172,-2138.45l2016.03,464.794l-6.14,1307.31l-2029.06,366.343Z"
				style={{ fill: "#007bff", stroke: "#007bff", strokeWidth: "291.67px" }}
			/>
		</svg>
	);
}
function SvgLayoutStanderd(props) {
	return (
		<svg
			width="100%"
			height="100%"
			viewBox="0 0 3568 3953"
			version="1.1"
			xmlns="http://www.w3.org/2000/svg"
			xmlnsXlink="http://www.w3.org/1999/xlink"
			xmlSpace="preserve"
			xmlnsSerif="http://www.serif.com/"
			style={{
				fillRule: "evenodd",
				clipRule: "evenodd",
				strokeLinecap: "round",
				strokeLinejoin: "round",
				strokeMiterlimit: "1.5",
			}}
		>
			<path
				d="M3421.7,441.286c0,-163.065 -132.388,-295.453 -295.452,-295.453l-2684.96,0c-163.065,0 -295.453,132.388 -295.453,295.453l0,2363.62c0,163.065 132.388,295.453 295.453,295.453l2684.96,-0c163.064,-0 295.452,-132.388 295.452,-295.453l0,-2363.62Z"
				style={{ fill: "#fff", stroke: "#007bff", strokeWidth: "291.67px" }}
			/>
			<rect
				x="403.06"
				y="3655.9"
				width="2749.58"
				height="150.636"
				style={{ fill: "#007bff", stroke: "#007bff", strokeWidth: "291.67px" }}
			/>
		</svg>
	);
}
function SvgLayoutNone(props) {
	return (
		<svg
			width="100%"
			height="100%"
			viewBox="0 0 3568 3951"
			version="1.1"
			xmlns="http://www.w3.org/2000/svg"
			xmlnsXlink="http://www.w3.org/1999/xlink"
			xmlSpace="preserve"
			xmlnsSerif="http://www.serif.com/"
			style={{
				fillRule: "evenodd",
				clipRule: "evenodd",
				strokeLinecap: "round",
				strokeLinejoin: "round",
				strokeMiterlimit: "1.5",
			}}
		>
			<path
				d="M3421.7,473.42c0,-180.8 -146.786,-327.587 -327.586,-327.587l-2620.69,0c-180.8,0 -327.587,146.787 -327.587,327.587l0,3003.67c0,180.8 146.787,327.587 327.587,327.587l2620.69,-0c180.8,-0 327.586,-146.787 327.586,-327.587l0,-3003.67Z"
				style={{ fill: "#fff", stroke: "#007bff", strokeWidth: "291.67px" }}
			/>
			<circle
				cx="1792.53"
				cy="1979.17"
				r="700.305"
				style={{ fill: "#fff", stroke: "#007bff", strokeWidth: "265.29px" }}
			/>
			<path
				d="M1379.89,1496.1l-51.883,48.461l892.898,955.943l51.883,-48.46l-892.898,-955.944Z"
				style={{ fill: "#fff", stroke: "#007bff", strokeWidth: "149.08px" }}
			/>
		</svg>
	);
}

function SvgLayoutFIlterMinimal(props) {
	return (
		<svg
			xmlns="http://www.w3.org/2000/svg"
			fill="#007bff"
			width="64px"
			height="64px"
			viewBox="0 0 24 24"
		>
			<g id="SVGRepo_bgCarrier" stroke-width="0"></g>
			<g
				id="SVGRepo_tracerCarrier"
				stroke-linecap="round"
				stroke-linejoin="round"
			></g>
			<g id="SVGRepo_iconCarrier">
				<path d="M23 13H2v-2h21v2z"></path>
			</g>
		</svg>
	);
}
function SvgLayoutFIlterStandred(props) {
	return (
		<svg
			width="100%"
			height="100%"
			viewBox="0 0 14713 5814"
			version="1.1"
			xmlns="http://www.w3.org/2000/svg"
			style={{
				fillRule: "evenodd",
				clipRule: "evenodd",
				strokeLinecap: "round",
				strokeLinejoin: "round",
				strokeMiterlimit: "1.5",
			}}
		>
			<rect
				x="537.612"
				y="537.612"
				width="13636.9"
				height="4738.3"
				style={{ fill: "#fff", stroke: "#007bff", strokeWidth: "1075.22px" }}
			></rect>
		</svg>
	);
}

function SvgLayoutFIlterDown(props) {
	return (
		<svg
			fill="#000000"
			width="64px"
			height="64px"
			viewBox="0 0 24 24"
			id="down-circle"
			xmlns="http://www.w3.org/2000/svg"
			className="icon line"
		>
			<circle
				cx="12"
				cy="12"
				r="9"
				style={{
					fill: "none",
					stroke: "#007bff",
					strokeLinecap: "round",
					strokeLinejoin: "round",
					strokeWidth: "2",
				}}
			/>
			<polyline
				points="9 11 12 14 15 11"
				style={{
					fill: "none",
					stroke: "#007bff",
					strokeLinecap: "round",
					strokeLinejoin: "round",
					strokeWidth: "1.5",
				}}
			/>
		</svg>
	);
}
function Svgauthor(props) {
	return (
		<svg
			width="20px"
			height="20px"
			viewBox="0 0 24 24"
			fill="none"
			xmlns="http://www.w3.org/2000/svg"
		>
			<path
				d="M5 20V19C5 16.2386 7.23858 14 10 14H14C16.7614 14 19 16.2386 19 19V20M16 7C16 9.20914 14.2091 11 12 11C9.79086 11 8 9.20914 8 7C8 4.79086 9.79086 3 12 3C14.2091 3 16 4.79086 16 7Z"
				stroke="#fff"
				stroke-width="2"
				stroke-linecap="round"
				stroke-linejoin="round"
			/>
		</svg>
	);
}
function Svgcalendar(props) {
	return (
		<svg width="20px" height="20px" viewBox="0 0 24 24" fill="none">
			<path
				d="M2 12C2 8.22876 2 6.34315 3.17157 5.17157C4.34315 4 6.22876 4 10 4H14C17.7712 4 19.6569 4 20.8284 5.17157C22 6.34315 22 8.22876 22 12V14C22 17.7712 22 19.6569 20.8284 20.8284C19.6569 22 17.7712 22 14 22H10C6.22876 22 4.34315 22 3.17157 20.8284C2 19.6569 2 17.7712 2 14V12Z"
				stroke="#fff"
				stroke-width="1.5"
			/>
			<path
				d="M7 4V2.5"
				stroke="#fff"
				stroke-width="1.5"
				stroke-linecap="round"
			/>
			<path
				d="M17 4V2.5"
				stroke="#fff"
				stroke-width="1.5"
				stroke-linecap="round"
			/>
			<path
				d="M2.5 9H21.5"
				stroke="#fff"
				stroke-width="1.5"
				stroke-linecap="round"
			/>
			<path
				d="M18 17C18 17.5523 17.5523 18 17 18C16.4477 18 16 17.5523 16 17C16 16.4477 16.4477 16 17 16C17.5523 16 18 16.4477 18 17Z"
				fill="#fff"
			/>
			<path
				d="M18 13C18 13.5523 17.5523 14 17 14C16.4477 14 16 13.5523 16 13C16 12.4477 16.4477 12 17 12C17.5523 12 18 12.4477 18 13Z"
				fill="#fff"
			/>
			<path
				d="M13 17C13 17.5523 12.5523 18 12 18C11.4477 18 11 17.5523 11 17C11 16.4477 11.4477 16 12 16C12.5523 16 13 16.4477 13 17Z"
				fill="#fff"
			/>
			<path
				d="M13 13C13 13.5523 12.5523 14 12 14C11.4477 14 11 13.5523 11 13C11 12.4477 11.4477 12 12 12C12.5523 12 13 12.4477 13 13Z"
				fill="#fff"
			/>
			<path
				d="M8 17C8 17.5523 7.55228 18 7 18C6.44772 18 6 17.5523 6 17C6 16.4477 6.44772 16 7 16C7.55228 16 8 16.4477 8 17Z"
				fill="#fff"
			/>
			<path
				d="M8 13C8 13.5523 7.55228 14 7 14C6.44772 14 6 13.5523 6 13C6 12.4477 6.44772 12 7 12C7.55228 12 8 12.4477 8 13Z"
				fill="#fff"
			/>
		</svg>
	);
}
function Svgtime(props) {
	return (
		<svg width="20px" height="20px" viewBox="0 0 24 24" fill="none">
			<path
				d="M12 21C16.9706 21 21 16.9706 21 12C21 7.02944 16.9706 3 12 3C7.02944 3 3 7.02944 3 12C3 16.9706 7.02944 21 12 21Z"
				stroke="#fff"
				stroke-width="1.5"
				stroke-linecap="round"
				stroke-linejoin="round"
			/>
			<path
				d="M12 6V12"
				stroke="#fff"
				stroke-width="1.5"
				stroke-linecap="round"
				stroke-linejoin="round"
			/>
			<path
				d="M16.24 16.24L12 12"
				stroke="#fff"
				stroke-width="1.5"
				stroke-linecap="round"
				stroke-linejoin="round"
			/>
		</svg>
	);
}

function SvgComment(props) {
	return (
		<svg
			fill="#000000"
			width="20px"
			height="20px"
			viewBox="0 0 24 24"
			xmlns="http://www.w3.org/2000/svg"
		>
			<g id="SVGRepo_bgCarrier" stroke-width="0"></g>
			<g
				id="SVGRepo_tracerCarrier"
				stroke-linecap="round"
				stroke-linejoin="round"
			></g>
			<g id="SVGRepo_iconCarrier">
				{" "}
				<path d="M8.2881437,19.1950792 C8.38869181,19.1783212 8.49195996,19.1926955 8.58410926,19.2362761 C9.64260561,19.7368747 10.8021412,20 12,20 C16.418278,20 20,16.418278 20,12 C20,7.581722 16.418278,4 12,4 C7.581722,4 4,7.581722 4,12 C4,13.7069096 4.53528582,15.3318588 5.51454846,16.6849571 C5.62010923,16.830816 5.63909672,17.022166 5.5642591,17.1859256 L4.34581002,19.8521348 L8.2881437,19.1950792 Z M3.58219949,20.993197 C3.18698783,21.0590656 2.87870208,20.6565881 3.04523765,20.2921751 L4.53592782,17.0302482 C3.54143337,15.5576047 3,13.818993 3,12 C3,7.02943725 7.02943725,3 12,3 C16.9705627,3 21,7.02943725 21,12 C21,16.9705627 16.9705627,21 12,21 C10.707529,21 9.4528641,20.727055 8.30053434,20.2068078 L3.58219949,20.993197 Z"></path>{" "}
			</g>
		</svg>
	);
}
function SvgPro(props) {
	return (
		<span className="up-pannel-control-icon">
			<svg
				width="18px"
				height="18px"
				viewBox="0 0 24 24"
				fill="none"
				xmlns="http://www.w3.org/2000/svg"
			>
				<path
					d="M16 9V6C16 4.34315 14.6569 3 13 3H11C9.34315 3 8 4.34315 8 6V9M16 9H8M16 9C17.6569 9 19 10.3431 19 12V18C19 19.6569 17.6569 21 16 21H8C6.34315 21 5 19.6569 5 18V12C5 10.3431 6.34315 9 8 9M12 14V17M13 14C13 14.5523 12.5523 15 12 15C11.4477 15 11 14.5523 11 14C11 13.4477 11.4477 13 12 13C12.5523 13 13 13.4477 13 14Z"
					stroke="#007bff"
					stroke-width="2"
					stroke-linecap="round"
					stroke-linejoin="round"
				/>
			</svg>
		</span>
	);
}

export {
	SvgWave,
	SvgAlignstart,
	SvgAligncenter,
	SvgAlignend,
	SvgSearch,
	SvgLink,
	SvgDownload,
	SvgPlay,
	SvgFilter,
	SvgImagesetting,
	SvgcontentIcon,
	SvgfilterIcon,
	SvggenralIcon,
	SvgDown,
	SvgClose,
	SvgLightbox,
	SvgUltimatePortfolioIcon,
	SvgFilteroptionIcon,
	SvgAddfilterIcon,
	SvgDragHandle,
	SvgEditIcon,
	SvgTrashIcon,
	SvgDesktoprespIcon,
	SvgTabrespIcon,
	SvgMobilerespIcon,
	SvgLoadmoreIcon,
	SvgUploadimgIcon,
	SvgDragIcon,
	SvgDeleteIcon,
	SvgSettingIcon,
	SvgSpinner,
	SvgPrev,
	SvgNext,
	SvgPagination,
	SvgPostexclude,
	SvgImageAddIcon,
	SvgContentSlider,
	SvgContentGallery,
	SvgContentPosts,
	SvgCoverflow,
	SvgCard,
	SvgFade,
	SvgContentCheck,
	SvgContentSocial,
	SvgRightArrow,
	SvgLayoutGrid,
	SvgLayoutMasonry,
	SvgLayoutSlider,
	SvgFilterWiz,
	SvgPaginationWiz,
	SvgYoutube,
	SvgInstagram,
	SvgFlickr,
	SvgVimeoicon,
	Svgunsplashicon,
	SvgFile,
	SvgCode,
	SvgTag,
	SvgScroll,
	SvgItemControl,
	SvgColorPaletteIcon,
	SvgLayoutWave,
	SvgLayoutClassic,
	SvgLayoutTilt,
	SvgLayoutStanderd,
	SvgLayoutNone,
	SvgLayoutFIlterMinimal,
	SvgLayoutFIlterStandred,
	SvgLayoutFIlterDown,
	Svgauthor,
	Svgcalendar,
	Svgtime,
	SvgComment,
	SvgPro,
};
