<?php
namespace BimPlugin\Widgets;

use Elementor\Widget_Base; 
use Elementor\Controls_Manager;
use Elementor\Utils;
use Elementor\Group_Control_Typography;
use Elementor\Core\Schemes\Typography;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly


		
/**
 * @since 1.0.0
 */
class Bim_WorkProcess extends Widget_Base {

	/**
	 * Retrieve the widget name.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'bim-work-process';
	}
		//script depend
	public function get_script_depends() { return [ 'jquery-slick','bim-work-process' ]; }

	/**
	 * Retrieve the widget title.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return __( 'Bim work procss', 'bim_plg' );
	}

	/**
	 * Retrieve the widget icon.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-image-box';
	}

	/**
	 * Retrieve the list of categories the widget belongs to.
	 *
	 * Used to determine where to display the widget in the editor.
	 *
	 * Note that currently Elementor supports only one category.
	 * When multiple categories passed, Elementor uses the first one.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'bim-elements' ];
	}

	/**
	 * Register the widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 *
	 * @access protected
	 */
	protected function _register_controls() {
	
		$this->start_controls_section(
			'section_content',
			[
				'label' => __( 'Image-box Settings', 'bim_plg' ),
			]
		);
		
		$this->add_control(
			'item_num',
			[
				'label' => __( 'Slides to show', 'bim_plg' ),
				'type' => Controls_Manager::SELECT,
				'options' => [
					'1' => __( '1', 'bim_plg' ),
					'2' => __( '2', 'bim_plg' ),
					'3' => __( '3', 'bim_plg' ),
					'4' => __( '4', 'bim_plg' ),
					'5' => __( '5', 'bim_plg' ),
				],
				'default' => '3',
			]
		);
	
		$this->add_control(
			'work_process_list',
			[
				'label' => __( 'Image-box List', 'bim_plg' ),
				'type' => Controls_Manager::REPEATER,
				'default' => [
					[
						'title' => 'Concept design',
						'text' => '001',
					],
					[
						'title' => 'Schematic Development',
						'text' => '002',
					],
					[
						'title' => 'Detail Design',
						'text' => '003',
					],
					[
						'title' => 'Tender Design',
						'text' => '004',
					],
					[
						'title' => 'Construction stage',
						'text' => '005',
					],
				],
				'fields' => [
					[
						'name' => 'title',
						'label' => __( 'Image-box Title', 'bim_plg' ),
						'type' => Controls_Manager::TEXT,
						'label_block' => true,
						'placeholder' => __( 'Image-box Title', 'bim_plg' ),
					],
					
					[
						'name' => 'image',
						'label' => __( 'Image', 'bim_plg' ),
						'type' => Controls_Manager::MEDIA,
						'default' => [
							'url' => Utils::get_placeholder_image_src(),
						],
					],
					[
						'name' => 'text',
						'label' => __( 'Image-box Text', 'bim_plg' ),
						'type' => Controls_Manager::TEXT,
						'label_block' => true,
						'placeholder' => __( 'Image-box Text', 'bim_plg' ),
					],
					[
						'name' => 'description',
						'label' => __( 'Description', 'bim_plg' ),
						'type' => Controls_Manager::TEXTAREA,
						'label_block' => true,
						'placeholder' => __( 'Description', 'bim_plg' ),
					],

				],
			]
		);
		$this->end_controls_section();

		$this->start_controls_section(
			'box_settings',
			[
				'label' => __( 'Box Setting','bim_plg' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'box_margin',
			[
				'label' => __( 'Box margin','bim_plg' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors' => [
					'{{WRAPPER}} .work-process .item .box-img .bg-img' => 'margin:{{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->add_responsive_control(
			'size',
			[
				'label' => __( 'Size', 'bim_plg' ),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 6,
						'max' => 300,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .work-process .item .box-img .bg-img' => 'width: {{SIZE}}{{UNIT}};height: {{SIZE}}{{UNIT}};line-height: {{SIZE}}{{UNIT}};',
				],
				
			]
		);


		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' => 'box_border',
				'selector' => '{{WRAPPER}} .work-process .item .box-img .bg-img',
			]
		);

		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name' => 'box_box_shadow',
				'selector' => '{{WRAPPER}} .work-process .item .box-img .bg-img',
			]
		);
		$this->end_controls_section();

		
		$this->start_controls_section(
			'style_section',
			[
				'label' => __( 'Content Style', 'bim_plg' ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'num_typography',
				'label' => esc_html__( 'Numbers Typography', 'bim_plg' ),
				'selector' => '{{WRAPPER}} .work-process .item .box-img .num',
			]
		);
		$this->add_control(
			'num_bg',
			[
				'label' => __( 'Number color','bim_plg' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .work-process .item .box-img .num' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'num_color_stroke',
			[
				'label' => __( 'Number color stroke','bim_plg' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .work-process .item .box-img .num' => '-webkit-text-stroke-color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'num_width_stroke',
			[
				'label' => __( 'Number stroke width','bim_plg' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%' ],
				'selectors' => [
					'{{WRAPPER}} .work-process .item .box-img .num' => '-webkit-text-stroke-width:{{SIZE}}{{UNIT}}',
				],
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'title_typography',
				'label' => esc_html__( 'Title Typography', 'bim_plg' ),
				'selector' => '{{WRAPPER}} .work-process .item .box-cont h3',
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'text_typography',
				'label' => esc_html__( 'Text Typography', 'bim_plg' ),
				'selector' => '{{WRAPPER}} .work-process .item .box-cont p',
			]
		);

		$this->end_controls_section();

	}

	/**
	 * Render the widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 *
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings(); 
		$slide_to_show="data-slick=";
		$slide_to_show.="'{";
		$slide_to_show.='"slidesToShow":';
		$slide_to_show.=$settings['item_num'];
		$slide_to_show.=', "slidesToScroll":';
		$slide_to_show.=$settings['item_num'];
		$slide_to_show.=', "autoplay" : false}';
		$slide_to_show.="'";




		?>
		
            <div class="work-process" <?php echo  $slide_to_show; ?>>
                <?php foreach ( $settings['work_process_list'] as $index => $item ) : 
                ?>
                <div class="item">
                    
                    <div class="box-img">
	                	<div class="bg-img">
							<img src="<?php echo esc_url ( $item['image']['url']); ?>" alt="img">
						</div>
						<span class="num"><?php echo  $item['text']; ?></span>
					</div>

					<div class="box-cont"> 
					 <h3><?php echo  $item['title']; ?></h3> 
					 <p class="desc"><?php echo  $item['description']; ?></p>                   
                    
                    </div>
                    
                </div>
                
                <?php endforeach; ?>
            </div><!-- .work-process --> 
	
		
	<?php 

		}

	/**
	 * Render the widget output in the editor. 
	 *
	 * Written as a Backbone JavaScript template and used to generate the live preview.
	 *
	 * @since 1.0.0
	 *
	 * @access protected
	 */
	protected function _content_template() {
		
		
	}
}


