<?php
namespace BimPlugin\Widgets;

use Elementor\Group_Control_Typography;
use Elementor\Core\Schemes\Typography;
use Elementor\Core\Schemes;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Utils;
use Elementor\Group_Control_Border;



if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly
	
/**
 * @since 1.0.0
 */
class Dsc_Slider extends Widget_Base {

	/**
	 * Retrieve the widget name.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'dsc-slider';
	}
	
	//script depend
	public function get_script_depends() { return [ 'jquery-slick','bim-animation','bim-slider-script','jquery-swiper','bim-swiper-slider-script' ]; }

	/**
	 * Retrieve the widget title.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return __( 'Bim Slider', 'bim_plg' );
	}
	

	/**
	 * Retrieve the widget icon.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-slideshow';
	}

	/**
	 * Retrieve the list of categories the widget belongs to.
	 *
	 * Used to determine where to display the widget in the editor.
	 *
	 * Note that currently Elementor supports only one category.
	 * When multiple categories passed, Elementor uses the first one.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'bim-elements' ];
	}

	/**
	 * Register the widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 *
	 * @access protected
	 */
	protected function _register_controls() {
	
		$this->start_controls_section(
			'section_content',
			[
				'label' => __( 'Slider Settings', 'bim_plg' ),
			]
		);

		$this->add_control(
			'slider_style',
			[
				'label' => __( 'Style', 'bim_plg' ),
				'type' => Controls_Manager::SELECT,
				'options' => [
					'1' => __( 'Style 1', 'bim_plg' ),
					'2' => __( 'Style 2', 'bim_plg' ),
					'3' => __( 'Style 3', 'bim_plg' ),
					'4' => __( 'Style 4', 'bim_plg' ),
					'5' => __( 'Style 5', 'bim_plg' ),
				],
				'default' => '1',
			]
		);
		
		
		
		$this->add_control(
			'slider_list',
			[
				'label' => __( 'Slider List', 'bim_plg' ),
				'type' => Controls_Manager::REPEATER,
				'default' => [
					[
						'title' => __( 'Slider Heading Title', 'bim_plg' ),
						'subtitle' => __( 'Slider subtitle', 'bim_plg' ),
						'text' => __( 'Slider text', 'bim_plg' ),
					],
					[
						'title' => __( 'Slider Heading Title', 'bim_plg' ),
						'subtitle' => __( 'Slider subtitle', 'bim_plg' ),
						'text' => __( 'Slider text', 'bim_plg' ),
					],
					[
						'title' => __( 'Slider Heading Title', 'bim_plg' ),
						'subtitle' => __( 'Slider subtitle', 'bim_plg' ),
						'text' => __( 'Slider text', 'bim_plg' ),
					],
				],
				'fields' => [
					[
						'name' => 'title',
						'label' => __( 'Slider Heading Title', 'bim_plg' ),
						'type' => Controls_Manager::TEXT,
						'label_block' => true,
						'placeholder' => __( 'Insert your slider heading title here..', 'bim_plg' ),
						'default' => __( 'Slider Heading Title' ,  'bim_plg'  ),
					],
					[
						'name' => 'subtitle',
						'label' => __( 'Slider Subtitle', 'bim_plg' ),
						'type' => Controls_Manager::TEXT,
						'label_block' => true,
						'placeholder' => __( 'Insert your slider subtitle here..', 'bim_plg' ),
						'default' => __( 'Slider Subtitle' ,  'bim_plg'  ),
					],
					[
						'name' => 'text',
						'label' => __( 'Slider Text', 'bim_plg' ),
						'type' => Controls_Manager::TEXTAREA,
						'label_block' => true,
						'default' => __( 'Slider Text' ,  'bim_plg' ),
					],
					[
						'name' => 'btn_text',
						'label' => __( 'Button Text', 'bim_plg' ),
						'type' => Controls_Manager::TEXT,
						'label_block' => true,
					],
					[
						'name' => 'btn_link',
						'label' => __( 'Button Link', 'bim_plg' ),
						'type' => Controls_Manager::URL,
						'label_block' => true,
						'placeholder' => __( 'Leave it blank if you don\'t need this button', 'bim_plg' ),
					],
					[
						'name' => 'btn_text2',
						'label' => __( 'Button Text', 'bim_plg' ),
						'type' => Controls_Manager::TEXT,
						'label_block' => true,
					],
					[
						'name' => 'btn_link2',
						'label' => __( 'Button Link', 'bim_plg' ),
						'type' => Controls_Manager::URL,
						'label_block' => true,
						'placeholder' => __( 'Leave it blank if you don\'t need this button', 'bim_plg' ),
					],
					[
						'name' => 'image',
						'label' => __( 'Slider Image', 'bim_plg' ),
						'type' => Controls_Manager::MEDIA,
						'default' => [
							'url' => Utils::get_placeholder_image_src(),
						],
					],
					[
						'name' => 'image_animation',
						'label' => __( 'Animation Effect', 'bim_plg' ),
						'type' => Controls_Manager::SWITCHER,
						'default' => '',
					],
					[
						'name' => 'zoom_direction',
						'label' => __( 'Zoom Direction', 'bim_plg' ),
						'type' => Controls_Manager::SELECT,
						'default' => 'in',
						'options' => [
							'in' => __( 'In', 'bim_plg' ),
							'out' => __( 'Out', 'bim_plg' ),
						],
						'conditions' => [
							'terms' => [
								[
									'name' => 'image_animation',
									'operator' => '!=',
									'value' => '',
								],
							],
						],
					],
				],
				'title_field' => '{{{ title }}}',
			]
		);
		
		$this->add_responsive_control(
			'slider_width',
			[
				'label' => __( 'Slider Container Max Width (px)', 'bim_plg' ),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' =>100,
						'max' => 4000,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .slider-box ' => 'max-width: {{SIZE}}px;',
				],
			]
		);
		
		$this->add_responsive_control(
			'slider_content',
			[
				'label' => __( 'Slider Content Max Width (px)', 'bim_plg' ),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' =>100,
						'max' => 4000,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .slider-content ' => 'max-width: {{SIZE}}px;',
				],
			]
		);
		
		$this->add_responsive_control(
			'slider_height',
			[
				'label' => __( 'Slider Top Padding (%)', 'bim_plg' ),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' =>0,
						'max' => 50,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .slider-box ' => 'padding-top: {{SIZE}}%;',
				],
			]
		);
		
		$this->add_responsive_control(
			'slider_height_bottom',
			[
				'label' => __( 'Slider Bottom Padding (%)', 'bim_plg' ),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' =>0,
						'max' => 50,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .slider-box ' => 'padding-bottom: {{SIZE}}%;',
				],
			]
		);
		
		$this->add_control(
			'slider_speed',
			[
				'label' => __( 'Slider Speed', 'bim_plg' ),
				'type' => Controls_Manager::NUMBER,
				'default' => 5000,
				'frontend_available' => true,
			]
		);
		$this->add_control(
			'animation_speed',
			[
				'label' => __( 'Animation Speed', 'bim_plg' ),
				'type' => Controls_Manager::NUMBER,
				'default' => 1000,
				'frontend_available' => true,
			]
		);
		
		$this->add_control(
			'show_line',
			[
				'label' => __( 'Show Line','bim_plg' ),
				'type' => Controls_Manager::SELECT,
				'options' => [
					'show' => __( 'Show','bim_plg' ),
					'hide' => __( 'Hide','bim_plg' ),
				],
				'default' => 'show',
			]
		);
		$this->add_control(
			'animation_type',
			[
				'label' => __( 'Animation type','bim_plg' ),
				'type' => Controls_Manager::SELECT,
				'options' => [
					'true' => __( 'Fade','bim_plg' ),
					'false' => __( 'Slide','bim_plg' ),
				],
				'default' => 'true',
			]
		);
		
		$this->add_control(
			'pos_line',
			[
				'label' => __( 'Line Position','bim_plg' ),
				'type' => Controls_Manager::SELECT,
				'options' => [
					'top' => __( 'Top','bim_plg' ),
					'bottom' => __( 'Bottom','bim_plg' ),
				],
				'default' => 'bottom',
				'condition' => [
					'show_line' => 'show',
				],
			]
			
		);
		
		$this->add_control(
			'show_arrows',
			[
				'label' => __( 'Show Arrows','bim_plg' ),
				'type' => Controls_Manager::SELECT,
				'options' => [
					'visible' => __( 'Show','bim_plg' ),
					'hidden' => __( 'Hide','bim_plg' ),
				],
				'default' => 'visible',
				'selectors' => [
					'{{WRAPPER}} .slider .slick-arrow' => 'visibility: {{VALUE}};',
					'{{WRAPPER}} .swiper-nav-ctrl' => 'visibility: {{VALUE}};',
				],
			]
		);
		
		$this->add_control(
			'show_dots',
			[
				'label' => __( 'Show Dots','bim_plg' ),
				'type' => Controls_Manager::SELECT,
				'options' => [
					'visible' => __( 'Show','bim_plg' ),
					'hidden' => __( 'Hide','bim_plg' ),
				],
				'default' => 'visible',
				'selectors' => [
					'{{WRAPPER}} .slider .slick-dots' => 'visibility: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'show_paging',
			[
				'label' => __( 'Show Paging','bim_plg' ),
				'type' => Controls_Manager::SELECT,
				'options' => [
					'visible' => __( 'Show','bim_plg' ),
					'hidden' => __( 'Hide','bim_plg' ),
				],
				'default' => 'visible',
				'selectors' => [
					'{{WRAPPER}} .slider .custom-paging' => 'visibility: {{VALUE}};',
					'{{WRAPPER}} .swiper-pagination' => 'visibility: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'animate_lines',
			[
				'label' => __( 'Hide animated lines', 'bim_plg' ),
				'type' => Controls_Manager::SWITCHER,
				'selectors' => [
					'{{WRAPPER}} .line-item' => 'display: none',
				],
			]
		);
		
		$this->add_responsive_control(
			'align',
			[
				'label' => __( 'Slider Alignment', 'bim_plg' ),
				'type' => Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => __( 'Left', 'bim_plg' ),
						'icon' => 'fa fa-align-left',
					],
					'center' => [
						'title' => __( 'Center', 'bim_plg' ),
						'icon' => 'fa fa-align-center',
					],
					'right' => [
						'title' => __( 'Right', 'bim_plg'),
						'icon' => 'fa fa-align-right',
					],
				],
				'default' => 'center',
				'selectors' => [
					'{{WRAPPER}} .slider-box' => 'text-align: {{VALUE}};',
				],
			]
		);
		
		$this->end_controls_section();

		$this->start_controls_section(
			'content_section',
			[
				'label' => __( 'Slider Content Settings', 'bim_plg' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'content_bgcolor',
			[
				'label' => __( 'Background Color', 'bim_plg' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .slider-content' => 'background: {{VALUE}};',
				],
			]
		);
		
		$this->add_responsive_control(
			'slider_slide_height',
			[
				'label' => __( 'Slider Height', 'bim_plg' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem', 'vw', 'vh', 'custom' ],
				'range' => [
					'px' => [
						'min' =>0,
						'max' => 50,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .slider .slick-slide' => 'height: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->end_controls_section();

		
		$this->start_controls_section(
			'title_section',
			[
				'label' => __( 'Slider Title Settings', 'bim_plg' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		
		$this->add_responsive_control(
			'title_margin',
			[
				'label' => __( 'Margin', 'bim_plg' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors' => [
					'{{WRAPPER}} .slider-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		
		$this->add_responsive_control(
			'title_padding',
			[
				'label' => __( 'Padding', 'bim_plg' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors' => [
					'{{WRAPPER}} .slider-title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'      => 'title_typo',
				'label'     => __( 'Title Typography', 'bim_plg' ),
				'selector'  => '{{WRAPPER}} .slider-title',
			]
		);
		
		$this->add_control(
			'title_color',
			[
				'label' => __( 'Color', 'bim_plg' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .slider-title' => 'color: {{VALUE}};',
				],
			]
		);
		
		$this->add_control(
			'title_bgcolor',
			[
				'label' => __( 'Background Color', 'bim_plg' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .slider-title' => 'background: {{VALUE}};',
				],
			]
		);
		
		$this->add_control(
			'title_type',
			[
				'label' => __( 'Title Display','bim_plg' ),
				'type' => Controls_Manager::SELECT,
				'options' => [
					'block' => __( 'Block','bim_plg' ),
					'inline-block' => __( 'Inline Block','bim_plg' ),
				],
				'default' => 'block',
				'selectors' => [
					'{{WRAPPER}} .slider-title' => 'display: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'title_animate',
			[
				'label' => __( 'Title Animation','bim_plg' ),
				'type' => Controls_Manager::SELECT,
				'options' => [
					'fadeInUp' => __( 'fadeInUp','bim_plg' ),
					'fadeInRight' => __( 'fadeInRight','bim_plg' ),
				],
				'default' => 'fadeInUp',

			]
		);
		
		$this->end_controls_section();
		
		
		
		$this->start_controls_section(
			'subtitle_section',
			[
				'label' => __( 'Slider Subtitle Settings', 'bim_plg' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		
		$this->add_responsive_control(
			'subtitle_margin',
			[
				'label' => __( 'Margin', 'bim_plg' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors' => [
					'{{WRAPPER}} .slider-subtitle' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->add_responsive_control(
			'subtitle_padding',
			[
				'label' => __( 'Padding', 'bim_plg' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors' => [
					'{{WRAPPER}} .slider-subtitle' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'      => 'subtitle_typo',
				'label'     => __( 'Subtitle Typography', 'bim_plg' ),
				'selector'  => '{{WRAPPER}} .slider-subtitle',
			]
		);
		
		$this->add_control(
			'subtitle_color',
			[
				'label' => __( 'Color', 'bim_plg' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .slider-subtitle' => 'color: {{VALUE}};',
				],
			]
		);
		
		$this->add_control(
			'subtitle_bgcolor',
			[
				'label' => __( 'Background Color', 'bim_plg' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .slider-subtitle' => 'background: {{VALUE}};',
				],
			]
		);
		
		$this->add_control(
			'subtitle_type',
			[
				'label' => __( 'Subtitle Display','bim_plg' ),
				'type' => Controls_Manager::SELECT,
				'options' => [
					'block' => __( 'Block','bim_plg' ),
					'inline-block' => __( 'Inline Block','bim_plg' ),
				],
				'default' => 'block',
				'selectors' => [
					'{{WRAPPER}} .slider-subtitle' => 'display: {{VALUE}};',
				],
			]
		);
		
		$this->end_controls_section();
		
		$this->start_controls_section(
			'textsetting_section',
			[
				'label' => __( 'Slider Text Settings', 'bim_plg' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		
		$this->add_responsive_control(
			'text_margin',
			[
				'label' => __( 'Margin', 'bim_plg' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors' => [
					'{{WRAPPER}} .slider-text' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->add_responsive_control(
			'text_padding',
			[
				'label' => __( 'Padding', 'bim_plg' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors' => [
					'{{WRAPPER}} .slider-text' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->add_responsive_control(
			'text_width',
			[
				'label' => __( 'Width', 'bim_plg' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%' ],
				'range' => [
					'px' => [
						'min' =>10,
						'max' => 2000,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .slider-text' =>'width: {{SIZE}}{{UNIT}};max-width:100%;',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'      => 'text_typo',
				'label'     => __( 'Text Typography', 'bim_plg' ),
				'selector'  => '{{WRAPPER}} .slider-text',
			]
		);
		
		$this->add_control(
			'text_color',
			[
				'label' => __( 'Color', 'bim_plg' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .slider-text' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'text_bgcolor',
			[
				'label' => __( 'Background Color', 'bim_plg' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .slider-text' => 'background: {{VALUE}};',
				],
			]
		);
		
		$this->add_responsive_control(
			'text_type',
			[
				'label' => __( 'Subtitle Display','bim_plg' ),
				'type' => Controls_Manager::SELECT,
				'options' => [
					'block' => __( 'Block','bim_plg' ),
					'inline-block' => __( 'Inline Block','bim_plg' ),
					'none' => __( 'None','bim_plg' ),
				],
				'default' => 'block',
				'selectors' => [
					'{{WRAPPER}} .slider-text' => 'display: {{VALUE}};',
				],
			]
		);
		
		$this->end_controls_section();
		
		
		
		$this->start_controls_section(
			'sl_line_section',
			[
				'label' => __( 'Slider Line Settings', 'bim_plg' ),
				'tab' => Controls_Manager::TAB_STYLE,
				'condition' => [
					'show_line' => 'show',
				],
			]
		);
		
		$this->add_responsive_control(
			'line_width',
			[
				'label' => __( 'Slider Line Width', 'bim_plg' ),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' =>10,
						'max' => 2000,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .slider-line ' => 'width: {{SIZE}}px;max-width:100%;',
				],
			]
		);
		
		$this->add_responsive_control(
			'line_height',
			[
				'label' => __( 'Slider Line Height', 'bim_plg' ),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' =>10,
						'max' => 500,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .slider-line ' => 'height: {{SIZE}}px;',
				],
			]
		);

		$this->add_responsive_control(
			'line_top_position',
			[
				'label' => __( 'Slider Line Top Position', 'bim_plg' ),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' =>-100,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .slider-line ' => 'top: {{SIZE}}px;',
				],
			]
		);
		
		$this->add_control(
			'linecolor',
			[
				'label' => __( 'Color', 'bim_plg' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .slider-line' => 'background: {{VALUE}};',
				],
			]
		);
		
		$this->add_responsive_control(
			'line_margin',
			[
				'label' => __( 'Margin', 'bim_plg' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors' => [
					'{{WRAPPER}} .slider-line' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		
		$this->end_controls_section();
		
		$this->start_controls_section(
			'btn_settings',
			[
				'label' => __( 'Button Setting','bim_plg' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		
		$this->add_control(
			'icon',
			[
				'label' => __( 'Button Icon', 'bim_plg' ),
				'type' => Controls_Manager::ICON,
				'label_block' => true,
				'default' => '',
			]
		);

		$this->add_control(
			'icon_align',
			[
				'label' => __( 'Button Icon Position', 'bim_plg' ),
				'type' => Controls_Manager::SELECT,
				'default' => 'left',
				'options' => [
					'left' => __( 'Before', 'bim_plg' ),
					'right' => __( 'After', 'bim_plg' ),
				],
				'condition' => [
					'icon!' => '',
				],
			]
		);

		$this->add_control(
			'icon_indent',
			[
				'label' => __( 'Button Icon Spacing', 'bim_plg' ),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'max' => 50,
					],
				],
				'condition' => [
					'icon!' => '',
				],
				'selectors' => [
					'{{WRAPPER}} .slider-btn .content-btn-align-icon-right' => 'margin-left: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .slider-btn .content-btn-align-icon-left' => 'margin-right: {{SIZE}}{{UNIT}};',
				],
			]
		);
		
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'      => 'btn_typography',
				'label'     => __( 'Typography', 'bim_plg' ),
				'selector'  => '{{WRAPPER}} .slider-btn',
			]
		);
		
		$this->add_responsive_control(
			'btn_margin',
			[
				'label' => __( 'Margin', 'bim_plg' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors' => [
					'{{WRAPPER}} .slider-btn' => 'margin:{{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		
		$this->add_responsive_control(
			'btn_padding',
			[
				'label' => __( 'Padding', 'bim_plg' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors' => [
					'{{WRAPPER}} .slider-btn' => 'padding:{{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		
		$this->add_responsive_control(
			'btn_border_radius',
			[
				'label' => __( 'Border Radius', 'bim_plg' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors' => [
					'{{WRAPPER}} .slider-btn' => 'border-radius:{{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		
		
		$this->end_controls_section();
		
		$this->start_controls_section(
			'btn_color_section',
			[
				'label' => __( 'Button Color Scheme Setting','bim_plg' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		
		$this->add_control(
			'btn_color_1',
			[
				'label' => __( 'Color 1','bim_plg' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .dsc-btn-style1' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'btn_color_2',
			[
				'label' => __( 'Color 2','bim_plg' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .dsc-btn-style2' => 'color: {{VALUE}};',
				],
			]
		);
		
		$this->add_control(
			'btn_color_hover_1',
			[
				'label' => __( 'Color on Hover','bim_plg' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .dsc-btn-style1:hover' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'btn_color_hover_2',
			[
				'label' => __( 'Color on Hover','bim_plg' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .dsc-btn-style2:hover' => 'color: {{VALUE}};',
				],
			]
		);
		
		$this->add_control(
			'btn_bg_1',
			[
				'label' => __( 'Background Color btn 1','bim_plg' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .dsc-btn-style1' => 'background: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'btn_bg_2',
			[
				'label' => __( 'Background Color btn 2','bim_plg' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .dsc-btn-style2' => 'background: {{VALUE}};',
				],
			]
		);
		
		$this->add_control(
			'btn_bg_hover_1',
			[
				'label' => __( 'Background Color on Hover 1','bim_plg' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .dsc-btn-style1:hover' => 'background: {{VALUE}};',
					'{{WRAPPER}} .dsc-btn-style1::after' => 'background: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'btn_bg_hover_2',
			[
				'label' => __( 'Background Color on Hover 2','bim_plg' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .dsc-btn-style2:hover' => 'background: {{VALUE}};',
					'{{WRAPPER}} .dsc-btn-style2::after' => 'background: {{VALUE}};',
				],
			]
		);
		
		$this->add_responsive_control(
			'btn_border',
			[
				'label' => __( 'Border', 'bim_plg' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors' => [
					'{{WRAPPER}} .slider-btn' => 'border-style:solid;border-width:{{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					
				],
			]
		);
		
		$this->add_responsive_control(
			'btn_border_hover_1',
			[
				'label' => __( 'Border on Hover', 'bim_plg' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors' => [
					'{{WRAPPER}} .dsc-btn-style1:hover' => 'border-style:solid;border-width:{{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					
				],
			]
		);
		$this->add_responsive_control(
			'btn_border_hover_2',
			[
				'label' => __( 'Border on Hover', 'bim_plg' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors' => [
					'{{WRAPPER}} .dsc-btn-style2:hover' => 'border-style:solid;border-width:{{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					
				],
			]
		);
		
		$this->add_control(
			'btn_border_color',
			[
				'label' => __( 'Border Color','bim_plg' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .slider-btn' => 'border-color: {{VALUE}};',
				],
			]
		);
		
		$this->add_control(
			'btn_border_color_hover_1',
			[
				'label' => __( 'Border Color on  Hover 1','bim_plg' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .dsc-btn-style1:hover' => 'border-color: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'btn_border_color_hover_2',
			[
				'label' => __( 'Border Color on  Hover 2','bim_plg' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .dsc-btn-style2:hover' => 'border-color: {{VALUE}};',
				],
			]
		);
		
		
		$this->end_controls_section();
		
		$this->start_controls_section(
			'sl_mask',
			[
				'label' => __( 'Slider Mask Settings', 'bim_plg' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		
		$this->add_control(
			'slider_mask',
			[
				'label' => __( 'Color', 'bim_plg' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .slider-mask' => 'background: {{VALUE}};',
				],
			]
		);
		
		$this->end_controls_section();

/*------------------------------------------------------------------------------------------------Arrows options-----------------*/

		$this->start_controls_section(
			'sl_arrow',
			[
				'label' => __( 'Slider Arrows Settings', 'bim_plg' ),
				'tab' => Controls_Manager::TAB_STYLE,
				'condition' => [
					'show_arrows' => 'visible',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' => 'border',
				'selector' => '{{WRAPPER}} .home-slider .slick-arrow',
				'separator' => 'before',
			]
		);
		$this->add_control(
			'border_radius',
			[
				'label' => __( 'Border Radius', 'bim_plg' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors' => [
					'{{WRAPPER}} .home-slider .slick-arrow' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->add_responsive_control(
			'arrow_width',
			[
				'label' => __( 'Slider arrow size', 'bim_plg' ),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' =>10,
						'max' => 400,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .slider .slick-arrow ' => 'width: {{SIZE}}px;height: {{SIZE}}px;line-height: {{SIZE}}px;',
					'{{WRAPPER}} .home-slider .fa.fa-angle-right.slick-arrow' => 'left: {{SIZE}}px;',
				],
			]
		);

		$this->start_controls_tabs( 'arrow_style' );

		$this->start_controls_tab(
			'arrow_left_orintation',
			[
				'label' => __( 'Left arrow', 'bim_plg' ),
			]
		);


		$this->add_control(
			'arrow_offset_orientation_h_left',
			[
				'label' => __( 'Horizontal Orientation', 'bim_plg' ),
				'type' => Controls_Manager::CHOOSE,
				'toggle' => false,
				'default' => 'start',
				'options' => [
					'start' => [
						'title' => 'Left',
						'icon' => 'eicon-h-align-left',
					],
					'end' => [
						'title' => 'Left',
						'icon' => 'eicon-h-align-right',
					],
				],
				'classes' => 'elementor-control-start-end',
				'render_type' => 'ui',
			]
		);
		$this->add_responsive_control(
			'arrow_offset_x_left',
			[
				'label' => __( 'Offset', 'bim_plg' ),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => -1000,
						'max' => 1000,
						'step' => 1,
					],
					'%' => [
						'min' => -200,
						'max' => 200,
					],
					'vw' => [
						'min' => -200,
						'max' => 200,
					],
					'vh' => [
						'min' => -200,
						'max' => 200,
					],
				],
				'size_units' => [ 'px', '%', 'vw', 'vh' ],
				'selectors' => [
					'{{WRAPPER}} .home-slider .fa.fa-angle-left.slick-arrow' => 'right: auto',
					'{{WRAPPER}} .home-slider .fa.fa-angle-left.slick-arrow' => 'left: {{SIZE}}{{UNIT}}',
				],
				'condition' => [
					'arrow_offset_orientation_h_left!' => 'end',
				],
			]
		);
		$this->add_responsive_control(
			'arrow_offset_x_end_left',
			[
				'label' => __( 'Offset', 'bim_plg' ),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => -1000,
						'max' => 1000,
						'step' => 0.1,
					],
					'%' => [
						'min' => -200,
						'max' => 200,
					],
					'vw' => [
						'min' => -200,
						'max' => 200,
					],
					'vh' => [
						'min' => -200,
						'max' => 200,
					],
				],
				'size_units' => [ 'px', '%', 'vw', 'vh' ],
				'selectors' => [
					'{{WRAPPER}} .home-slider .fa.fa-angle-left.slick-arrow'=> 'left:initial',
					'{{WRAPPER}} .home-slider .slick-arrow'=> 'left: initial',
					'{{WRAPPER}} .elementor-widget-dsc-slider .home-slider:hover .fa.fa-angle-left.slick-arrow'=> 'left:initial',
					'{{WRAPPER}} .home-slider .fa.fa-angle-left.slick-arrow'=> 'right: {{SIZE}}{{UNIT}}',
					'{{WRAPPER}} .home-slider:hover .fa.fa-angle-left.slick-arrow'=> 'right: {{SIZE}}{{UNIT}}',


				],
				'condition' => [
					'arrow_offset_orientation_h_left' => 'end',
				],
			]
		);
		$this->add_control(
			'arrow_offset_orientation_v_left',
			[
				'label' => __( 'Vertical Orientation', 'bim_plg' ),
				'type' => Controls_Manager::CHOOSE,
				'toggle' => false,
				'default' => 'start',
				'options' => [
					'start' => [
						'title' => __( 'Top', 'bim_plg' ),
						'icon' => 'eicon-v-align-top',
					],
					'end' => [
						'title' => __( 'Bottom', 'bim_plg' ),
						'icon' => 'eicon-v-align-bottom',
					],
				],
				'render_type' => 'ui',
			]
		);

		$this->add_responsive_control(
			'arrow_offset_y_left',
			[
				'label' => __( 'Offset', 'bim_plg' ),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => -1000,
						'max' => 1000,
						'step' => 1,
					],
					'%' => [
						'min' => -200,
						'max' => 200,
					],
					'vh' => [
						'min' => -200,
						'max' => 200,
					],
					'vw' => [
						'min' => -200,
						'max' => 200,
					],
				],
				'size_units' => [ 'px', '%', 'vh', 'vw' ],
				'selectors' => [
					'{{WRAPPER}} .home-slider .fa.fa-angle-left.slick-arrow' => 'top: {{SIZE}}{{UNIT}}',

				],
				'condition' => [
					'arrow_offset_orientation_v_left!' => 'end',
				],
			]
		);

		$this->add_responsive_control(
			'arrow_offset_y_end_left',
			[
				'label' => __( 'Offset', 'bim_plg' ),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => -1000,
						'max' => 1000,
						'step' => 1,
					],
					'%' => [
						'min' => -200,
						'max' => 200,
					],
					'vh' => [
						'min' => -200,
						'max' => 200,
					],
					'vw' => [
						'min' => -200,
						'max' => 200,
					],
				],
				'size_units' => [ 'px', '%', 'vh', 'vw' ],
				'selectors' => [
					'{{WRAPPER}} .home-slider .fa.fa-angle-left.slick-arrow' => 'bottom: {{SIZE}}{{UNIT}}',
				],
				'condition' => [
					'arrow_offset_orientation_v_left' => 'end',
				],
			]
		);
		$this->end_controls_tab();

		$this->start_controls_tab(
			'arrow_right_orintation',
			[
				'label' => __( 'Right arrow', 'bim_plg' ),
			]
		);
		$this->add_control(
			'arrow_offset_orientation_h',
			[
				'label' => __( 'Horizontal Orientation', 'bim_plg' ),
				'type' => Controls_Manager::CHOOSE,
				'toggle' => false,
				'default' => 'start',
				'options' => [
					'start' => [
						'title' => 'Left',
						'icon' => 'eicon-h-align-left',
					],
					'end' => [
						'title' => 'Left',
						'icon' => 'eicon-h-align-right',
					],
				],
				'classes' => 'elementor-control-start-end',
				'render_type' => 'ui',
			]
		);
		$this->add_responsive_control(
			'arrow_offset_x',
			[
				'label' => __( 'Offset', 'bim_plg' ),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => -1000,
						'max' => 1000,
						'step' => 1,
					],
					'%' => [
						'min' => -200,
						'max' => 200,
					],
					'vw' => [
						'min' => -200,
						'max' => 200,
					],
					'vh' => [
						'min' => -200,
						'max' => 200,
					],
				],
				'size_units' => [ 'px', '%', 'vw', 'vh' ],
				'selectors' => [
					'{{WRAPPER}} .home-slider .fa.fa-angle-right.slick-arrow' => 'left: {{SIZE}}{{UNIT}}',
				],
				'condition' => [
					'arrow_offset_orientation_h!' => 'end',
				],
			]
		);
		$this->add_responsive_control(
			'arrow_offset_x_end',
			[
				'label' => __( 'Offset', 'bim_plg' ),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => -1000,
						'max' => 1000,
						'step' => 0.1,
					],
					'%' => [
						'min' => -200,
						'max' => 200,
					],
					'vw' => [
						'min' => -200,
						'max' => 200,
					],
					'vh' => [
						'min' => -200,
						'max' => 200,
					],
				],
				'size_units' => [ 'px', '%', 'vw', 'vh' ],
				'selectors' => [
					'{{WRAPPER}} .home-slider .fa.fa-angle-right.slick-arrow'=> 'right: {{SIZE}}{{UNIT}}',
				],
				'condition' => [
					'arrow_offset_orientation_h' => 'end',
				],
			]
		);


		$this->add_control(
			'arrow_offset_orientation_v',
			[
				'label' => __( 'Vertical Orientation', 'bim_plg' ),
				'type' => Controls_Manager::CHOOSE,
				'toggle' => false,
				'default' => 'start',
				'options' => [
					'start' => [
						'title' => __( 'Top', 'bim_plg' ),
						'icon' => 'eicon-v-align-top',
					],
					'end' => [
						'title' => __( 'Bottom', 'bim_plg' ),
						'icon' => 'eicon-v-align-bottom',
					],
				],
				'render_type' => 'ui',
			]
		);

		$this->add_responsive_control(
			'arrow_offset_y',
			[
				'label' => __( 'Offset', 'bim_plg' ),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => -1000,
						'max' => 1000,
						'step' => 1,
					],
					'%' => [
						'min' => -200,
						'max' => 200,
					],
					'vh' => [
						'min' => -200,
						'max' => 200,
					],
					'vw' => [
						'min' => -200,
						'max' => 200,
					],
				],
				'size_units' => [ 'px', '%', 'vh', 'vw' ],
				'selectors' => [
					'{{WRAPPER}} .home-slider .fa.fa-angle-right.slick-arrow' => 'top: {{SIZE}}{{UNIT}}',
				],
				'condition' => [
					'arrow_offset_orientation_v!' => 'end',
				],
			]
		);

		$this->add_responsive_control(
			'arrow_offset_y_end',
			[
				'label' => __( 'Offset', 'bim_plg' ),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => -1000,
						'max' => 1000,
						'step' => 1,
					],
					'%' => [
						'min' => -200,
						'max' => 200,
					],
					'vh' => [
						'min' => -200,
						'max' => 200,
					],
					'vw' => [
						'min' => -200,
						'max' => 200,
					],
				],
				'size_units' => [ 'px', '%', 'vh', 'vw' ],
				'selectors' => [
					'{{WRAPPER}} .home-slider .slick-arrow' => 'top:auto',
					'{{WRAPPER}} .home-slider .fa.fa-angle-right.slick-arrow' => 'bottom: {{SIZE}}{{UNIT}}',
				],
				'condition' => [
					'arrow_offset_orientation_v' => 'end',
				],
			]
		);

		$this->end_controls_tab();

		$this->end_controls_tabs();

		
		$this->add_control(
			'arrow_color',
			[
				'label' => __( 'Color', 'bim_plg' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .slider .slick-arrow' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'arrow_color_hover',
			[
				'label' => __( 'Color on Hover', 'bim_plg' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .slider .slick-arrow:hover' => 'color: {{VALUE}};',
				],
			]
		);
		
		$this->add_control(
			'arrow_bg_color',
			[
				'label' => __( 'Background Color', 'bim_plg' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .slider .slick-arrow' => 'background: {{VALUE}};',
				],
			]
		);
		
		$this->add_control(
			'arrow_bg_color_hover',
			[
				'label' => __( 'Background Color on Hover', 'bim_plg' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .slider .slick-arrow:hover' => 'background: {{VALUE}};',
				],
			]
		);
		
		$this->end_controls_section();
/*------------------------------------------------------------------------------------------------Paging options-----------------*/
		$this->start_controls_section(
			'sl_paging',
			[
				'label' => __( 'Slider Paging Settings', 'bim_plg' ),
				'tab' => Controls_Manager::TAB_STYLE,
				'condition' => [
					'show_paging' => 'visible',
				],
			]
		);

		$this->add_control(
			'paging_offset_orientation_h',
			[
				'label' => __( 'Horizontal Orientation', 'bim_plg' ),
				'type' => Controls_Manager::CHOOSE,
				'toggle' => false,
				'default' => 'start',
				'options' => [
					'start' => [
						'title' => 'Left',
						'icon' => 'eicon-h-align-left',
					],
					'end' => [
						'title' => 'Left',
						'icon' => 'eicon-h-align-right',
					],
				],
				'classes' => 'elementor-control-start-end',
				'render_type' => 'ui',
				'condition' => [
					'show_paging' => 'visible',
				],
			]
		);
		$this->add_responsive_control(
			'paging_offset_x',
			[
				'label' => __( 'Offset', 'bim_plg' ),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => -1000,
						'max' => 1000,
						'step' => 1,
					],
					'%' => [
						'min' => -200,
						'max' => 200,
					],
					'vw' => [
						'min' => -200,
						'max' => 200,
					],
					'vh' => [
						'min' => -200,
						'max' => 200,
					],
				],
				'size_units' => [ 'px', '%', 'vw', 'vh' ],
				'selectors' => [
					'{{WRAPPER}} .custom-paging' => 'left: {{SIZE}}{{UNIT}}',
				],
				'condition' => [
					'paging_offset_orientation_h!' => 'end',
				],
			]
		);
		$this->add_responsive_control(
			'paging_offset_x_end',
			[
				'label' => __( 'Offset', 'bim_plg' ),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => -1000,
						'max' => 1000,
						'step' => 0.1,
					],
					'%' => [
						'min' => -200,
						'max' => 200,
					],
					'vw' => [
						'min' => -200,
						'max' => 200,
					],
					'vh' => [
						'min' => -200,
						'max' => 200,
					],
				],
				'size_units' => [ 'px', '%', 'vw', 'vh' ],
				'selectors' => [
					'{{WRAPPER}} .custom-paging'=> 'right: {{SIZE}}{{UNIT}}',
				],
				'condition' => [
					'paging_offset_orientation_h' => 'end',
				],
			]
		);
		$this->add_control(
			'paging_offset_orientation_v',
			[
				'label' => __( 'Vertical Orientation', 'bim_plg' ),
				'type' => Controls_Manager::CHOOSE,
				'toggle' => false,
				'default' => 'start',
				'options' => [
					'start' => [
						'title' => __( 'Top', 'bim_plg' ),
						'icon' => 'eicon-v-align-top',
					],
					'end' => [
						'title' => __( 'Bottom', 'bim_plg' ),
						'icon' => 'eicon-v-align-bottom',
					],
				],
				'render_type' => 'ui',
				'condition' => [
					'show_paging' => 'visible',
				],
			]
		);

		$this->add_responsive_control(
			'paging_offset_y',
			[
				'label' => __( 'Offset', 'bim_plg' ),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => -1000,
						'max' => 1000,
						'step' => 1,
					],
					'%' => [
						'min' => -200,
						'max' => 200,
					],
					'vh' => [
						'min' => -200,
						'max' => 200,
					],
					'vw' => [
						'min' => -200,
						'max' => 200,
					],
				],
				'size_units' => [ 'px', '%', 'vh', 'vw' ],
				'selectors' => [
					'{{WRAPPER}} .custom-paging' => 'top: {{SIZE}}{{UNIT}}',
				],
				'condition' => [
					'paging_offset_orientation_v!' => 'end',
				],
			]
		);

		$this->add_responsive_control(
			'paging_offset_y_end',
			[
				'label' => __( 'Offset', 'bim_plg' ),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => -1000,
						'max' => 1000,
						'step' => 1,
					],
					'%' => [
						'min' => -200,
						'max' => 200,
					],
					'vh' => [
						'min' => -200,
						'max' => 200,
					],
					'vw' => [
						'min' => -200,
						'max' => 200,
					],
				],
				'size_units' => [ 'px', '%', 'vh', 'vw' ],
				'selectors' => [
					'{{WRAPPER}} .custom-paging' => 'bottom: {{SIZE}}{{UNIT}}',
				],
				'condition' => [
					'paging_offset_orientation_v' => 'end',
				],
			]
		);


			$this->add_group_control(
				Group_Control_Typography::get_type(),
				[
					'name'      => 'paging_typo',
					'label'     => __( 'Paging Typography', 'bim_plg' ),
					'selector'  => '{{WRAPPER}} .custom-paging li',
				]
			);
			$this->add_group_control(
				Group_Control_Typography::get_type(),
				[
					'name'      => 'paging_typo_active',
					'label'     => __( 'Active Paging Typography', 'bim_plg' ),
					'selector'  => '{{WRAPPER}} .custom-paging li:first-letter',
				]
			);

			$this->add_control(
				'paging_color',
				[
					'label' => __( 'Paging Color', 'bim_plg' ),
					'type' => Controls_Manager::COLOR,
					'default' => '',
					'selectors' => [
						'{{WRAPPER}} .custom-paging li' => 'color: {{VALUE}};',
					],
				]
			);
			$this->add_control(
				'paging_color_active',
				[
					'label' => __( 'Active Paging Color', 'bim_plg' ),
					'type' => Controls_Manager::COLOR,
					'default' => '',
					'selectors' => [
						'{{WRAPPER}} .custom-paging li:first-letter' => 'color: {{VALUE}};',
					],
				]
			);


			$this->add_control(
				'paging_color_stroke',
				[
					'label' => __( 'Number color stroke','bim_plg' ),
					'type' => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .custom-paging li' => '-webkit-text-stroke-color: {{VALUE}}',
					],
				]
			);
			$this->add_control(
				'paging_width_stroke',
				[
					'label' => __( 'Number stroke width','bim_plg' ),
					'type' => \Elementor\Controls_Manager::SLIDER,
					'size_units' => [ 'px', '%' ],
					'selectors' => [
						'{{WRAPPER}} .custom-paging li' => '-webkit-text-stroke-width:{{SIZE}}{{UNIT}}',
					],
				]
			);


		$this->end_controls_section();


	}

	/**
	 * Render the widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 *
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings();
		$this->add_render_attribute( 'icon-align', 'class', 'content-btn-align-icon-' . $settings['icon_align'] );
		$this->add_render_attribute( 'icon-align', 'class', 'content-btn-button-icon' );
		
		$settings = $this->get_settings();

		$style = $settings['slider_style'];

		require( 'style'.$style.'.php' );
	}

	/**
	 * Render the widget output in the editor.
	 *
	 * Written as a Backbone JavaScript template and used to generate the live preview.
	 *
	 * @since 1.0.0
	 *
	 * @access protected
	 */
	protected function _content_template() {

	}
}


