<?php
/**
 * Metabox Class Fill.
 *
 * @package Bim
 */
?>
<?php
/**
 * Calls the class on the post edit screen.
 */
defined('BIM_ADDONS_ROOT') or define('BIM_ADDONS_ROOT', dirname(__FILE__));
defined('BIM_ADDONS_CUSTOM_POST_TYPE') or define('BIM_ADDONS_CUSTOM_POST_TYPE', dirname(__FILE__).'/custom-post-type');
defined('BIM_ADDONS_ROOT_DIR') or define('BIM_ADDONS_ROOT_DIR', plugins_url().'/bim_plugin');


function Bim_Meta_Boxes() 
{
    new bimMetaboxes();
}

	if ( is_admin() ) {
	    add_action( 'load-post.php', 'Bim_Meta_Boxes' );
	    add_action( 'load-post-new.php', 'Bim_Meta_Boxes' );
	}


/** 
 * The bimMetaboxes Class.
 */
class bimMetaboxes {

	/**
	 * Hook into the appropriate actions when the class is constructed.
	 */
	public function __construct() {
		$this->bim_metabox_addons();
		add_action( 'add_meta_boxes', array( $this, 'bim_add_meta_boxs' ) );
		add_action( 'save_post', array( $this, 'bim_save_meta_box' ) );
		add_action('admin_enqueue_scripts', array($this, 'admin_script_loader'));

		/* Portfolio */
		add_action( 'add_meta_boxes', array( $this, 'bim_add_meta_boxs_portfolios' ) );
	}

	/**
	 * Adds the meta box functions container.
	 */
	public function bim_metabox_addons(){
		include('meta-box-maps.php'); 
	}

	/**
	 * Adds the meta box container.
	 */
	public function bim_add_meta_boxs( $bim_post_type ) {
		$bim_post_types = array('post', 'page', 'portfolio','product');    //limit meta box to certain post types
		$flag = false; 
        if ( in_array( $bim_post_type, $bim_post_types )){
           	$flag = true;
        }
        if($flag == true){
	        $this->bim_add_meta_box('bim_admin_options', 'Bim '.ucfirst($bim_post_type).' Settings', $bim_post_type);
	    }

	}

	public function bim_add_meta_box($bim_id, $bim_label_name, $bim_post_type)
	{
		add_meta_box(
			$bim_id
			,$bim_label_name
			,array( $this, $bim_id )
			,$bim_post_type
			
		);
	}

	public function bim_admin_options()
	{
		global $post;
		if($post->post_type == 'post' || $post->post_type == 'portfolio'|| $post->post_type == 'product'){
			$bim_tabs_title = array('General Settings', 'Header Settings', 'Footer','Sidepanel');
			$bim_tabs_sub_title = array('General configuration settings', 'Header section configuration settings', 'Enable/Disable comments in '.$post->post_type, 'Footer section configuration settings', 'Sidepanel section configuration settings');
			$bim_page_tabs = array('General Settings', 'Header Settings', 'Footer','Sidepanel');
			$bim_page_tab_content = array('general','header', 'footer','sidepanel');
		}else{
			$bim_tabs_title = array('General Settings','Header Settings', 'Footer Settings','Sidepanel Settings');
			$bim_tabs_sub_title = array( 'General configuration settings','Header section configuration settings', 'Enable/Disable comments in page', 'Footer section configuration settings', 'Sidepanel section configuration settings');
			$bim_page_tabs = array( 'General Settings','Header Settings', 'Footer Settings','Sidepanel Settings');
			$bim_page_tab_content = array('general','header','footer','sidepanel');
		}

		$bim_icon_class = array('icon-gears','fa fa-header', 'el-icon-website', 'fa fa-align-left', 'fa fa-server', 'el-icon-website icon-rotate', 'fa fa-list-alt');
		echo '<ul class="bim_meta_box_tabs">';
		$bim_icon = 0;
		$bim_showicon = '';
			foreach( $bim_page_tabs as $tab_key => $tab_name ) {
				if($bim_icon_class){
					$bim_showicon = '<i class="'.esc_attr($bim_icon_class[$bim_icon]).'"></i>';
				}
				echo '<li class="bim_tab_'.$bim_page_tab_content[$tab_key].'"><a href="'.esc_url($tab_name).'">'.$bim_showicon.'<span class="group_title">'.esc_attr($tab_name).'</span></a></li>';
				$bim_icon++;
			}
		echo '</ul>';

		echo '<div class="bim_meta_box_tab_content">';
		foreach( $bim_page_tab_content as $tab_content_key => $tab_content_name ) {
			echo '<div class="bim_meta_box_tab" id="bim_tab_'.esc_attr($tab_content_name).'">';
				echo "<div class='main_tab_title'>";
					echo "<h3>".$bim_tabs_title[$tab_content_key]."</h3>";
					echo "<span class='description'>".$bim_tabs_sub_title[$tab_content_key]."</span>";
				echo "</div>";
				include('metabox-tabs/metabox_'.$tab_content_name.'.php'); 
			echo '</div>';
		}
		echo '</div>';
		echo '<div class="clear"></div>';
	}


	/**
	 * Adds the meta box for Portfolio.
	 */
	public function bim_add_meta_boxs_portfolios( $bim_post_type ) 
	{
		$bim_post_types = array('portfolio','post');     //limit meta box to certain post types
		$flag = false;
        if ( in_array( $bim_post_type, $bim_post_types )){
           	$flag = true;
        }
        if($flag == true){
	        $this->bim_add_meta_box('bim_admin_options_single', 'Bim '.ucfirst($bim_post_type).' Format Settings', $bim_post_type);
	    }

	}

	public function bim_add_meta_boxs_portfolio($bim_id, $bim_label_name, $bim_post_type)
	{
		add_meta_box(
			$bim_id
			,$bim_label_name
			,array( $this, $bim_id )
			,$bim_post_type
			,'advanced'
			,'high'
		);
	}

	public function bim_admin_options_single()
	{
        global $post;
		echo '<div class="bim_meta_box_tab_content_single">';
			echo '<div class="bim_meta_box_tab" id="bim_tab_single">';
		
		echo '</div>';
		if($post->post_type == 'portfolio'):
                include('metabox-tabs/metabox_portfolio_setting.php' );
                endif;
		echo '</div>';
		echo '<div class="clear"></div>';
	}

	/**
	 * Save the meta when the post is saved.
	 *
	 * @param int $post_id The ID of the post being saved.
	 */
	public function bim_save_meta_box( $bim_post_id ) {
	
		// If this is an autosave, our form has not been submitted,
        // so we don't want to do anything.
		if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) 
			return $bim_post_id;

		/* OK, its safe for us to save the data now. */
		$bim_data = array();
		foreach ( $_POST as $key => $value ) {
			if ( strstr( $key, 'bim_') ) {
				// Sanitize the user input.
				$bim_data = sanitize_text_field( $_POST[$key] );
				// Update the meta field.
				update_post_meta( $bim_post_id, $key, $bim_data );
			}
		}
	}

	function admin_script_loader() {
		
		global $pagenow;
		if( is_admin() && ( $pagenow=='post-new.php' || $pagenow=='post.php' ) ) {
			wp_enqueue_script('media-upload'); 
			wp_enqueue_script('thickbox');
	   		wp_enqueue_style('thickbox');
	   		wp_enqueue_style( 'wp-color-picker' );
    		wp_enqueue_script( 'wp-color-picker');
    		wp_register_script('alpha-color-picker', BIM_ADDONS_ROOT_DIR.'/meta-box/js/alpha-color-picker.js', array('jquery', 'wp-color-picker'), '1.0' );
		   	wp_enqueue_script('alpha-color-picker');
		   	wp_register_style('alpha-color-picker', BIM_ADDONS_ROOT_DIR.'/meta-box/css/alpha-color-picker.css', array('wp-color-picker'), '1.0' );
		   	wp_enqueue_style('alpha-color-picker');
	   		wp_register_script('bim-admin-metabox-cookie-js', BIM_ADDONS_ROOT_DIR.'/meta-box/js/metabox-cookie.js', array('jquery'), '1.0' );
	   		wp_enqueue_script('bim-admin-metabox-cookie-js');
	   		wp_register_script('bim-admin-metabox-js', BIM_ADDONS_ROOT_DIR.'/meta-box/js/meta-box.js', array('jquery'), '1.0' );
			wp_enqueue_script('bim-admin-metabox-js');
	   		wp_register_style('bim-admin-metabox-css', BIM_ADDONS_ROOT_DIR.'/meta-box/css/meta-box.css',null, '1.0' );
	   		wp_enqueue_style('bim-admin-metabox-css');
		}
	}
}