<?php
/**
 * Metabox Map
 *
 * @package Bim
 */
?>
<?php
function bim_meta_box_text($bim_id, $bim_label, $bim_desc = '', $bim_short_desc = '')
{
	global $post;

	$html = '';
		$html .= '<div class="'.esc_attr($bim_id).'_box description_box">';
		$html .= '<div class="left-part">';
			$html .= $bim_label;
			if($bim_desc) {
				$html .= '<span class="description">' . esc_attr($bim_desc) . '</span>';
			}
		$html .='</div>';
		$html .= '<div class="right-part">';
			$html .= '<input type="text" id="' . esc_attr($bim_id) . '" name="' . esc_attr($bim_id) . '" value="' . get_post_meta($post->ID, $bim_id, true) . '" />';
			if($bim_short_desc) {
				$html .= '<span class="short-description">' . esc_attr($bim_short_desc) . '</span>';
			}
		$html .= '</div>';
		$html .= '</div>';
	echo sprintf("%s",$html);
}

function bim_meta_box_dropdown($bim_id, $bim_label, $bim_options, $bim_desc = '')
{
	global $post;
	

	$html = $bim_select_class = '';

			$html .= '<div class="'.esc_attr($bim_id).'_box description_box">';
					$html .= '<div class="left-part">';
							$html .= $bim_label;
							if($bim_desc) {
									$html .= '<span class="description">' . esc_attr($bim_desc) . '</span>';
							}
					$html .='</div>';
					$html .= '<div class="right-part">';
							$html .= '<select id="' . esc_attr($bim_id) . '" class="'.$bim_select_class.'" name="' . esc_attr($bim_id) . '">';
							foreach($bim_options as $key => $option) {
									if(get_post_meta($post->ID, $bim_id, true) == (string)$key && get_post_meta($post->ID, $bim_id, true) != '') {
											$bim_selected = 'selected="selected"';
									}else {
													$bim_selected = '';
									}

									$html .= '<option ' . $bim_selected . ' value="' . esc_attr($key) . '">' . esc_attr($option) . '</option>';

							}
							$html .= '</select>';
					$html .='</div>';	
		$html .= '</div>';
	echo sprintf("%s",$html);
}

function bim_meta_box_dropdown_sidebar($bim_id, $bim_label, $bim_options, $bim_desc = '', $bim_child_hidden = '')
{
	global $post;

	$html = $bim_select_class = '';
	$flag = false;
		$bim_child_hidden = ( $bim_child_hidden ) ? ' hide-child '.$bim_child_hidden : '';
		$html .= '<div class="'.esc_attr($bim_id).'_box description_box'.$bim_child_hidden.'">';
			$html .= '<div class="left-part">';
				$html .= $bim_label;
				if($bim_desc) {
					$html .= '<span class="description">' . esc_attr($bim_desc) . '</span>';
				}
			$html .='</div>';
			$html .= '<div class="right-part">';
				$html .= '<select id="' . esc_attr($bim_id) . '" class="'.esc_attr($bim_select_class).'" name="' . esc_attr($bim_id) . '">';
				foreach($bim_options as $key => $option) {
					if(get_post_meta($post->ID, $bim_id, true) == $key && get_post_meta($post->ID, $bim_id, true) != '') {
						$bim_selected = 'selected="selected"';
					}else {
							$bim_selected = '';
					}

					$html .= '<option ' . $bim_selected . ' value="' . esc_attr($key) . '">' . esc_attr($option) . '</option>';

				}
				$html .= '</select>';
			$html .='</div>';	
		$html .= '</div>';
	echo sprintf("%s",$html);
}

/* menu dropdown */

function bim_meta_box_dropdown_menu($bim_id, $bim_label, $bim_options, $bim_desc = '')
{
	global $post;

	$html = $bim_select_class = '';
	$flag = false;

	
		$html .= '<div class="'.esc_attr($bim_id).'_box description_box">';
			$html .= '<div class="left-part">';
				$html .= $bim_label;
				if($bim_desc) {
					$html .= '<span class="description">' . esc_attr($bim_desc) . '</span>';
				}
			$html .='</div>';
			$html .= '<div class="right-part">';
				$html .= '<select id="' . esc_attr($bim_id) . '" class="'.esc_attr($bim_select_class).'" name="' . esc_attr($bim_id) . '">';
				$html .= '<option value="">Default</option>';
				$bim_menus = wp_get_nav_menus();
				$bim_menu_array = array();
				foreach ($bim_menus as $key => $value) {
					if(get_post_meta($post->ID, $bim_id, true) == $value->slug && get_post_meta($post->ID, $bim_id, true) != '') {
						$bim_selected = 'selected="selected"';
					}else {
							$bim_selected = ''; 
					}

					$html .= '<option ' . $bim_selected . ' value="' . esc_attr($value->slug) . '">' . esc_attr($value->name) . '</option>';
				}
				$html .= '</select>';
			$html .='</div>';	
		$html .= '</div>';
	echo sprintf("%s",$html);
}

function bim_meta_box_dropdown_custom_headers($bim_id, $bim_label, $bim_options, $bim_desc = '')
{
	global $post;

	$html = $bim_select_class = '';
	$flag = false;

	
		$html .= '<div class="'.esc_attr($bim_id).'_box description_box">';
			$html .= '<div class="left-part">';
				$html .= $bim_label;
				if($bim_desc) {
					$html .= '<span class="description">' . esc_attr($bim_desc) . '</span>';
				}
			$html .='</div>';
			$html .= '<div class="right-part">';
				$html .= '<select id="' . esc_attr($bim_id) . '" class="'.esc_attr($bim_select_class).'" name="' . esc_attr($bim_id) . '">';
				$html .= '<option value="">Default</option>';
				$bim_custom_headers = new WP_Query( array( 'post_type' => 'header' ) );
				$posts = $bim_custom_headers->posts; 
				foreach ($posts as $key => $value) {
					if(get_post_meta($post->ID, $bim_id, true) == $value->ID && get_post_meta($post->ID, $bim_id, true) != '') {
						$bim_selected = 'selected="selected"';
					}else {
							$bim_selected = '';
					}

					$html .= '<option ' . $bim_selected . ' value="' . esc_attr($value->ID) . '">' . esc_attr($value->post_name) . '</option>';
				}
				$html .= '</select>';
			$html .='</div>';	
		$html .= '</div>';
	echo sprintf("%s",$html);
}

function bim_meta_box_dropdown_custom_footers($bim_id, $bim_label, $bim_options, $bim_desc = '')
{
	global $post;

	$html = $bim_select_class = '';
	$flag = false;

	
		$html .= '<div class="'.esc_attr($bim_id).'_box description_box">';
			$html .= '<div class="left-part">';
				$html .= $bim_label;
				if($bim_desc) {
					$html .= '<span class="description">' . esc_attr($bim_desc) . '</span>';
				}
			$html .='</div>';
			$html .= '<div class="right-part">';
				$html .= '<select id="' . esc_attr($bim_id) . '" class="'.esc_attr($bim_select_class).'" name="' . esc_attr($bim_id) . '">';
				$html .= '<option value="">Default</option>';
				$bim_custom_footers = new WP_Query( array( 'post_type' => 'footer' ) );
				$posts = $bim_custom_footers->posts; 
				foreach ($posts as $key => $value) {
					if(get_post_meta($post->ID, $bim_id, true) == $value->ID && get_post_meta($post->ID, $bim_id, true) != '') {
						$bim_selected = 'selected="selected"'; 
					}else {
							$bim_selected = '';
					}

					$html .= '<option ' . $bim_selected . ' value="' . esc_attr($value->ID) . '">' . esc_attr($value->post_name) . '</option>';
				}
				$html .= '</select>';
			$html .='</div>';	
		$html .= '</div>';
	echo sprintf("%s",$html);
}
function bim_meta_box_dropdown_custom_sidepanels($bim_id, $bim_label, $bim_options, $bim_desc = '')
{
	global $post;

	$html = $bim_select_class = '';
	$flag = false;

	
		$html .= '<div class="'.esc_attr($bim_id).'_box description_box">';
			$html .= '<div class="left-part">';
				$html .= $bim_label;
				if($bim_desc) {
					$html .= '<span class="description">' . esc_attr($bim_desc) . '</span>';
				}
			$html .='</div>';
			$html .= '<div class="right-part">';
				$html .= '<select id="' . esc_attr($bim_id) . '" class="'.esc_attr($bim_select_class).'" name="' . esc_attr($bim_id) . '">';
				$html .= '<option value="">Default</option>';
				$bim_custom_sidepanels = new WP_Query( array( 'post_type' => 'sidepanel' ) );
				$posts = $bim_custom_sidepanels->posts; 
				foreach ($posts as $key => $value) {
					if(get_post_meta($post->ID, $bim_id, true) == $value->ID && get_post_meta($post->ID, $bim_id, true) != '') {
						$bim_selected_sidepanel = 'selected="selected"'; 
					}else {
							$bim_selected_sidepanel = '';
					}

					$html .= '<option ' . $bim_selected_sidepanel . ' value="' . esc_attr($value->ID) . '">' . esc_attr($value->post_name) . '</option>';
				}
				$html .= '</select>';
			$html .='</div>';	
		$html .= '</div>';
	echo sprintf("%s",$html);
}

function bim_meta_box_textarea($bim_id, $bim_label, $bim_desc = '', $bim_default = '' )
{
	global $post;
	$html = '';
	$html .= '<div class="'.esc_attr($bim_id).'_box description_box">';
	$html .= '<div class="left-part">';
		$html .= $bim_label;
		if($bim_desc) {
			$html .= '<span class="description">' . esc_attr($bim_desc) . '</span>';
		}
	$html .='</div>';
	
	if( get_post_meta($post->ID, $bim_id, true)) {
		$bim_value = get_post_meta($post->ID, $bim_id, true);
	} else {
		$bim_value = '';
	}
	$html .= '<div class="right-part">';
		$html .= '<textarea cols="120" id="' . esc_attr($bim_id) . '" name="' . esc_attr($bim_id) . '">' . esc_attr($bim_value) . '</textarea>';
	$html .='</div>';
	$html .= '</div>';

	echo sprintf("%s",$html);
}

function bim_meta_box_upload($bim_id, $bim_label, $bim_desc = '')
{
	global $post;

	$html = '';
	$html .= '<div class="'.esc_attr($bim_id).'_box description_box">';
	$html .= '<div class="left-part">';
		$html .= $bim_label;
		if($bim_desc) {
			$html .= '<span class="description">' . esc_attr($bim_desc) . '</span>';
		}
	$html .='</div>';
	$html .= '<div class="right-part">';
		$html .= '<input name="' . esc_attr($bim_id) . '" class="upload_field" id="bim_upload" type="text" value="' . get_post_meta($post->ID,  $bim_id, true) . '" />';
		$html .= '<input name="'. $bim_id.'_thumb" class="'. $bim_id.'_thumb" id="'. $bim_id.'_thumb" type="hidden" value="'.get_post_meta($post->ID,  $bim_id, true).'" />';
				$html .= '<img class="upload_image_screenshort" src="'.get_post_meta($post->ID,  $bim_id, true).'" />';
		$html .= '<input class="bim_upload_button" id="bim_upload_button" type="button" value="'.__( 'Browse', 'bim_plg' ).'" />';
		$html .= '<span class="bim_remove_button button">'.__( 'Remove', 'bim_plg' ).'</span>';
				
	$html .='</div>';
	$html .= '</div>';
	echo sprintf("%s",$html);
}

function bim_meta_box_upload_multiple($bim_id, $bim_label, $bim_desc = '')
{
	global $post;

	$html = '';
	$html .= '<div class="'.esc_attr($bim_id).'_box description_box">';
		$html .= '<div class="left-part">';
			$html .= $bim_label;
			if($bim_desc) {
				$html .= '<span class="description">' . esc_attr($bim_desc) . '</span>';
			}
		$html .='</div>';
		$html .= '<div class="right-part">';
		
			$html .= '<input name="' . esc_attr($bim_id) . '" class="upload_field" id="bim_upload" type="hidden" value="'.get_post_meta($post->ID,  $bim_id, true).'" />';
			$html .= '<div class="multiple_images">';
			$bim_val = explode(",",get_post_meta($post->ID,  $bim_id, true));
			
			foreach ($bim_val as $key => $value) {
				if(!empty($value)):
					$bim_image_url = wp_get_attachment_url( $value );
					$html .='<div id='.esc_attr($value).'>';
						$html .= '<img class="upload_image_screenshort_multiple" src="'.$bim_image_url.'" style="width:100px;" />';
						$html .= '<a href="javascript:void(0)" class="remove">'.__( 'Remove', 'bim_plg' ).'</a>';
					$html .= '</div>';
				endif;
			}
			$html .= '</div>';
			$html .= '<input class="bim_upload_button_multiple" id="bim_upload_button_multiple" type="button" value="Browse" />'.__( ' Select Files', 'bim_plg' );
					
		$html .='</div>';
	$html .= '</div>';
	echo sprintf( "%s", $html );
}

	if ( ! function_exists( 'bim_meta_box_colorpicker' ) ) {
		function bim_meta_box_colorpicker( $id, $label, $desc = '', $bim_dependency = '' ) {
			global $post;
	        
			$dependency_attr = '';
			$dependency_arr = array();

			if( !empty($bim_dependency) ){
				$val = array();
				$dependency_arr[] = 'data-element="'.$bim_dependency['element'].'"';
				foreach ($bim_dependency['value'] as $key => $value) {
					$val[] = $value; 
				}
				$dep_list = implode(",", $val);
				$dependency_arr[] = 'data-value="'.$dep_list.'"';
				$dependency_attr = implode(" ", $dependency_arr);
			}

			$html = '';
			$html .= '<div class="'.$id.'_box description_box"'.$dependency_attr.'>';
				$html .= '<div class="left-part">';
					$html .= $label;
					if($desc) {
						$html .= '<span class="description">' . $desc . '</span>';
					}
				$html .='</div>';
				$html .= '<div class="right-part">';
					$html .= '<input type="text" class="bim-color-picker" id="' . $id . '" name="' . $id . '" value="' . get_post_meta($post->ID, $id, true) . '" />';
				$html .='</div>';
			$html .='</div>';
			echo $html;
		}
	}