<?php
/**
 * Plugin Name: Bim Theme Addons
 * Plugin URI: http://themeforest.net/user/themescamp
 * Description: This is plugin bundle for Bim WordPress Theme.
 * Author: ThemesCamp
 * Author URI: http://themeforest.net/user/themescamp
 * Version: 1.3.9
 */

function bim_mime_types( $mimes ) {
	
        // New allowed mime types.
        $mimes['svg'] = 'image/svg+xml';
	$mimes['svgz'] = 'image/svg+xml';
        $mimes['doc'] = 'application/msword'; 

        // Optional. Remove a mime type.
        unset( $mimes['exe'] );

	return $mimes;
}
add_filter( 'upload_mimes', 'bim_mime_types' );



if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

define( 'BIM__FILE__', __FILE__ );
define( 'BIM_URL', plugins_url( '/', BIM__FILE__ ) );
define( 'BIM_PLUGIN_BASE', plugin_basename( BIM__FILE__ ) );


/**
 * Load Hello World
 *
 * Load the plugin after Elementor (and other plugins) are loaded.
 *
 * @since 1.0.0
 */
function bim_plg_load() {
	// Load localization file
	load_plugin_textdomain( 'bim_plg' );

	// Require the main plugin file
	require( __DIR__ . '/plugin.php' );
	// require __DIR__ . '/modules/plugin.php';
	//require __DIR__ . '/control/animation.php';


}
add_action( 'plugins_loaded','bim_plg_load' );


function bim_plg_fail_load_out_of_date() {
	if ( ! current_user_can( 'update_plugins' ) ) {
		return;
	}

	$file_path = 'elementor/elementor.php';

	$upgrade_link = wp_nonce_url( self_admin_url( 'update.php?action=upgrade-plugin&plugin=' ) . $file_path, 'upgrade-plugin_' . $file_path );
	$message = '<p>' . __( 'Bim Plugin is not working because you are using an old version of Elementor.', 'bim_plg' ) . '</p>';
	$message .= '<p>' . sprintf( '<a href="%s" class="button-primary">%s</a>', $upgrade_link, __( 'Update Elementor Now', 'bim_plg' ) ) . '</p>';

	echo '<div class="error">' . $message . '</div>';
}


//adding reduxoptions into themes
/**
 * Optional: set 'ot_show_pages' filter to false.
 * This will hide the settings & documentation pages.
 */
add_filter( 'ot_show_pages', '__return_false' );
	/**
 * Optional: set 'ot_show_new_layout' filter to false.
 * This will hide the "New Layout" section on the Theme Options page.
 */
add_filter( 'ot_show_new_layout', '__return_false' );



//include elementor addon
include('inc/elementor-addon.php');

//include portfolio custom post type,metaboxes & single portfolio script
include('inc/portfolio.php');
include('inc/portfolio-metaboxes.php');

//include page metabox
include('inc/page-metaboxes.php');

//include post metabox
include('inc/post-metaboxes.php');
include('meta-box/meta-box.php');

//include custom footer
include('inc/footer.php');

//include custom header
include('inc/header.php');

//include side panel
include('inc/side-panel.php');

//include admin custom script 
include('inc/admin-script.php');

//include single portfolio function
include('inc/single-portfolio.php');



//included custom widget
include('inc/about-us.php');

//included recent posts widget
include('inc/recent-posts.php');

//included sharing
include('inc/sharebox.php');

//included one click importer
include('inc/one-click.php');

//included shortcode importer
include('inc/shortcode.php');

//reduxoptions included function
//included theme options export/import
include('inc/theme-import.php');
//included theme options
include('inc/theme-options.php');

//included custom fonts
include('inc/license.php');

function bim_admin_styles() {
  wp_enqueue_style('admin-styles', BIM_URL.'inc/css/admin.css');
}
add_action('admin_enqueue_scripts', 'bim_admin_styles');


//plugin translation
function bim_textdomain_translation() {
    load_plugin_textdomain('bim_plg', false, dirname(plugin_basename(__FILE__)) . '/lang/');
} // end custom_theme_setup
add_action('after_setup_theme', 'bim_textdomain_translation');

