<?php
namespace BetterWidgets\Widgets;

use Elementor\Group_Control_Typography;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Utils;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly


		
/**
 * @since 1.1.0
 */
class Better_Bottom_Shape extends Widget_Base {

	/**
	 * Retrieve the widget name.
	 *
	 * @since 1.1.0
	 *
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'better-bottom-shape';
	}

	/**
	 * Retrieve the widget title.
	 *
	 * @since 1.1.0
	 *
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return __( 'Bottom Shape', 'better-el-addons' );
	}

	/**
	 * Retrieve the widget icon.
	 *
	 * @since 1.1.0
	 *
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-square bea-widget-badge';
	}

	/**
	 * Retrieve the list of categories the widget belongs to.
	 *
	 * Used to determine where to display the widget in the editor.
	 *
	 * Note that currently Elementor supports only one category.
	 * When multiple categories passed, Elementor uses the first one.
	 *
	 * @since 1.1.0
	 *
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'better-category' ];
	}

	/**
	 * Register the widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.1.0
	 *
	 * @access protected
	 */
	protected function _register_controls() {

        $this->start_controls_section(
			'section_title',
			[
				'label' => __( 'Main', 'better-el-addons' ),
			]
		);

        $this->end_controls_section();
	
	}

	/**
	 * Render the widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.1.0
	 *
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings(); ?>
		 
            <div class="better-shape-bottom">
                <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
                    width="1920px" height="27px" viewBox="0 0 1920 27" enable-background="new 0 0 1920 27"
                    xml:space="preserve">
                    <path fill="#fff" d="M1906.688,12.029c-1.653-1.78-3.943-0.347-5.823-0.883c-0.623,0.442-0.879,1.208-1.873,1.044
                                    c-1.992-1.974-5.01-1.6-7.448-2.713c-0.417,0.074-0.441,0.997-1.238,0.33c-0.103-0.113-0.323-0.356-1.033-1.142
                                    c-0.492,0.938-0.948,1.805-1.409,2.683c-2.1-2.389-5.174,0.159-7.012-2.03c-0.991,1.465-3.179,0.306-4.117,1.874
                                    c-0.5-0.379-0.778-1.019-1.599-0.989c-3.682,0.135-6.783,2.202-10.129,2.986c-2.646-2.246-6.298,0.391-8.975-2.322
                                    c-1.84,3.085-5.408-0.125-7.492,2.352c-2.784-1.202-5.6-0.211-7.657,1.15c-2.544,1.684-5.658-0.525-7.617,2.049
                                    c-0.711-0.49-1.225-0.845-1.762-1.215c-1.235,0.125-2.3,1.9-3.511,0.95c-1.499-1.176-3.069-1.008-4.633-0.888
                                    c-1.598,0.122-2.832-0.717-3.89-1.47c-1.507-1.073-2.629-2.676-4.531-0.757c-2.571-1.628-5.022,1.022-7.607,0.219
                                    c-0.723-0.225-1.504-0.072-2.258,0.563c-1.085,0.914-2.433,0.347-4.001,0.191c-0.359-0.553-0.792-1.217-1.557-2.392
                                    c-0.742,1.224-1.258,2.076-1.313,2.166c-2.294,1.216-3.012-0.829-4.299-0.584c-2.297,1.75-4.521,1.209-6.864-0.046
                                    c-0.324,0.259-0.688,0.799-1.059,0.804c-4.448,0.06-8.899,0.038-13.98,0.038c-0.24-0.405-0.749-1.262-1.173-1.976
                                    c-2.149,1.008-3.842,2.035-5.738,0.538c-1.279-1.01-3.3,0.474-4.443-1.4c-0.961-1.577-3.543-0.592-4.438-2.496
                                    c-3.05-0.142-5.799-2.602-9.159-0.84c-1.687,0.884-4.072,1.045-5.593-0.089c-1.931-1.44-2.974,0.217-4.092,0.435
                                    c-1.995-0.727-3.73-1.358-5.471-1.992c-1.57,1.758-3.127,1.162-4.602-0.068c-1.607,1.257-3.317,1.732-4.943,0.605
                                    c-0.969-0.671-1.885-0.5-2.809-0.466c-3.405,0.126-6.516-1.034-9.699-2.036c-0.351,0.323-0.711,0.655-1.266,1.166
                                    c-0.591-0.759-1.198-1.538-1.725-2.212c-2.557,0-4.875,0-8.18,0c-0.132-0.319-0.531-1.282-0.687-1.656
                                    c-1.575-0.655-1.718,0.829-2.71,0.698c-0.934,0.347-1.032-1.229-2.004-0.986c-0.555-0.477-1.205-0.576-1.831-0.262
                                    c-4.749,2.376-9.568,1.722-14.54,0.734c-3.522-0.699-7.345-0.937-10.771-0.021c-8.529,2.281-14.354-0.386-22.609-1.185
                                    c-0.667,0-3.228,0.765-3.895,0.765c-0.269,1.448-2.103,0.853-2.87,2.04c-2.285-0.507-4.856,0.825-6.996-1.004
                                    c-0.521,0.312-0.772,1.039-1.604,0.942c-2.775-0.322-5.41,0.34-7.854,1.536c-1.457,0.712-3.183,0.871-4.261,0.345
                                    c-3.696-1.805-7.167-0.856-10.271,0.122c-1.912-0.04-2.112-2.065-3.931-2.006c-1.694-0.765-1.941,1.694-3.332,1.995
                                    c-1.699,0-3.39,0.18-5.024-0.049c-1.732-0.243-2.798,1.396-4.604,1.124c-2.718-0.409-5.469-0.152-7.379,2.128
                                    c-2.17-1.577-4.005,0.289-5.965-0.134c-2.103-0.454-4.128,0.208-5.64,1.813c-3.357,0.918-6.184-1.798-9.276-0.846
                                    c-0.445-0.925-0.152-1.714-0.918-2.031c-0.971-0.401-1.309,0.68-2.029,0.883c-0.604-1.118-1.666-0.873-2.634-0.885
                                    c-1.143-0.013-2.285-0.003-3.268-0.003c-1.106-1.114-2.044-2.06-2.726-2.746c-1.358-0.58-2.729,0.321-3.578-0.645
                                    c-1.388-1.575-3.174,0.984-4.441-0.609c-4.224,1.665-8.423,1.515-12.691,0.062c-0.804-0.273-1.865-0.181-2.867,0.204
                                    c-3.121,1.199-6.329,2.133-10.131,1.631c-0.475,0.7-1.028,1.521-1.345,1.989c-2.119,0.122-3.817-0.032-5.385,0.352
                                    c-9.312,2.279-14.828,3.395-21.018,2.769c-0.495-0.05-1.111-0.196-1.481,0.024c-2.459,1.461-5.34,1.699-7.979,2.411
                                    c-2.833,0.764-5.061,2.335-7.593,3.466c-0.969,0.433-1.489,1.215-2.317,1.644c-3.614,1.874-8.017,1.064-11.524,3.343
                                    c-3.526-2.029-7.422-0.189-11.06-1.061c-0.589-0.589-1.179-1.178-1.834-1.834c-3.257,0-6.584-0.095-9.903,0.026
                                    c-3.349,0.123-5.717-2.383-8.814-3.184c-0.867,0.785-1.689,1.528-2.857,2.584c-0.712-1.586-2.597-1.038-3.396-2.375
                                    c-4.875-0.261-9.631-0.244-13.903,2.711c-0.939,0.65-2.543,0.629-3.646-0.316c-1.049-0.897-2.626-0.786-3.243-0.338
                                    c-1.525,1.113-3.112,1.029-4.655,0.83c-1.742-0.225-3.054,1.255-4.583,1.003c-2.853-0.469-5.448,0.766-8.049,1.29
                                    c-1.847,0.371-3.941,0.443-5.849,1.488c-2.252,1.235-4.988,2.07-7.542,2.143c-2.824,0.081-5.771,1.03-8.669-0.719
                                    c-1.008-0.608-3.135-0.79-4.648,0.541c-0.876,0.771-2.188,0.289-3.313,0.232c-0.589-0.591-1.179-1.181-1.768-1.771
                                    c-1.306-0.537-3.041,0.573-4.061-1.059c-3.901-0.564-7.618-2.124-11.633-2.111c-1.087,0.004-2.119,0.145-3.253-0.631
                                    c-1.381-0.944-2.94-0.271-4.455,0.588c-1.642,0.931-3.068-1.93-4.954-0.711c-0.273,0.178-0.443,0.617-0.717,0.676
                                    c-2.816,0.599-5.678,1.731-8.461,1.572c-4.614-0.264-9.223-1.017-13.843-1.456c-5.847-0.556-11.815,1.072-17.592-0.986
                                    c-0.592-0.211-1.58-0.312-1.946,0.02c-1.806,1.633-4.211,1.089-6.27,1.794c-2.087,0.716-4.611,0.158-6.944,0.158
                                    c-1.503-0.432-2.372-2.113-4.172-2.019c-1.662,0.087-3.478-0.396-4.961,0.126c-1.763,0.62-3.121-2.656-4.758-0.227
                                    c-1.436-2.093-2.76,0.089-4.118,0.178c-5.541,0.364-10.891-0.694-16.074-2.332c-1.263-0.398-2.465-0.812-3.678-0.678
                                    c-2.656,0.294-5.127-0.484-7.456-1.379c-2.272-0.874-4.205-0.792-6.463-0.06c-7.844,2.541-6.753,3.244-15.267,0.626
                                    c-3.086-0.949-5.96-2.991-9.862-2.097c-0.385-0.789-0.739-1.516-1.019-2.087c-2.055,1.425-3.956,1.311-5.706,0.346
                                    c-1.307-0.72-2.924-0.75-3.775-0.278c-2.287,1.266-4.743,0.539-6.987,1.041c-0.512,2.917-2.846,3.626-4.926,3.726
                                    c-2.612,0.124-5.023,0.659-7.318,1.736c-0.653,0.306-1.226,0.383-1.847,0.363c-2.501-0.082-4.068,1.571-5.756,3.013
                                    c-2.233,0.087-4.569-0.512-6.791,1.418c-0.471-1.835-1.769-1.304-2.878-1.432c-1.256-0.146-2.88,0.903-3.375,0.583
                                    c-1.313-0.849-2.553-0.435-3.8-0.543c-1.323-0.114-2.667-0.082-3.997-0.014c-3.085,0.157-5.937-1.626-9.063-1.063
                                    c-1.444-1.706-3.651-1.35-5.054-0.812c-3.057,1.172-6.092,0.68-9.137,0.865c-0.644,0.039-1.326-0.01-1.922,0.189
                                    c-3.33,1.112-6.717,1.99-10.247,1.782c-4.751-0.28-9.317,1.747-14.083,1.016c-0.645-0.099-0.807,0.622-1.214,0.686
                                    c-2.856,0.444-5.156,2.096-8.292,3.524c-2.365-0.867-6.328-2.242-7.198-2.998c-2.773-1.573-5.327,2.088-8.085,0.087
                                    c-2.148,1.771-5.14-0.317-7.36,1.629c-0.443,0.388-1.774,0.116-2.783-0.26c-3.272-1.218-6.678-0.943-10.029-0.181
                                    c-1.969,0.448-3.911,1.011-5.864,1.521c-2.057-2.154-4.113-0.146-6.17,0c-3.287-1.954-6.9-2.259-10.441-1.98
                                    c-1.35-1.258-2.661-1.43-4.34-1.475c-1.521-0.041-3.323-1.036-4.664-1.791c-1.818-1.022-3.526-0.294-5.167-0.868
                                    c-0.98-1.14-2.457-1.3-3.7-1.961c-0.413,0.362-0.778,0.682-1.144,1.002c-0.575-0.178-0.733-1.094-2.059-0.819
                                    c-2.482,2.394-6.367,2.596-10.038,3.972c-0.554-0.703-1.166-1.48-1.646-2.09c-1.979,0-4.188,0.655-5.173-0.163
                                    c-1.275-1.062-3.067-0.118-3.902-1.604c-1.041,0.813-2.247,0.834-3.494,0.791c-1.498-0.051-2.998-0.007-4.497-0.014
                                    c-0.628-0.003-0.699,1.07-1.693,0.694c-0.168-0.025-0.191-0.975-0.831-0.406c-0.595,0.832,0.337,2.039-1.103,2.948
                                    c-4.826-1.897-10.075-3.35-15.699-3.981c-1.394,1.522-3.377,0.406-5.231,0.826c-0.671-0.881-1.173-1.539-1.694-2.225
                                    c-3.583,1.016-6.671-1.573-10.036-0.792c-0.321-0.779-0.555-1.348-0.792-1.918c-0.626-0.23-1.209-0.299-1.579,0.402
                                    c0.392,0.502,1.087,0.815,0.885,1.839c-0.179,0.216-0.486,0.574-0.78,0.944c-1.035,1.3-2.845,0.007-3.629,0.784
                                    c-1.345,1.334-2.823,0.95-4.168,0.8c-1.271-0.141-2.348,1.22-3.343,0.52c-1.493-1.049-2.836,0.617-3.76,0.188
                                    c-3.873-1.803-7.05,0.221-10.776,1.511c-0.034-1.703-1.615-1.113-2.562-1.535c-1.959-0.873-4.205-1.103-6.333-1.597
                                    c-2.651,2.137-5.744,0.481-8.584,0.997c-1.03,0.187-1.323-1.671-2.58-0.931c-0.573,0.574-1.162,1.163-1.979,1.98
                                    c-3.573-0.473-7.454,0.813-11.184-0.814c-0.588,0.588-1.178,1.177-1.856,1.855c-0.747-1.711-2.58-1.477-3.434-0.98
                                    c-2.351,1.366-4.772,0.632-7.144,0.905c-2.861,0.331-5.878-0.878-8.616,0.939c-0.418,0.277-1.558,0.173-1.839-0.177
                                    c-0.937-1.166-2.153-0.861-3.209-0.732c-2.721,0.335-4.974-0.697-7.014-2.082c-1.225,0.262-2.051,0.971-3.23,1.146
                                    c-1.83,0.272-3.478-1.175-5.255-0.274c-1.221-1.703-3.44-0.036-4.774-1.426c-0.81-0.844-1.946-0.515-2.812-0.338
                                    c-1.199,0.245-2.174,1.308-3.604,0.95c-1.085-0.271-2.321,0.4-3.334-0.396c-0.89-0.699-1.901,0.168-2.997-0.49
                                    c-0.985-0.593-2.724-0.445-3.89,0.755c-0.626-0.689-1.18-1.299-1.712-1.886c-0.417,0.359-0.834,0.993-1.151,0.946
                                    c-2.219-0.328-4.478,0.692-6.735-0.643c-1.276-0.755-3.208-0.837-4.623,0.225c-0.953,0.714-1.799,0.449-2.726,0.279
                                    c-0.216-0.592-0.427-1.169-0.691-1.895c-2.699,0.559-5.569-0.833-8.078,0.906c-2.688-2.219-6.326,0.428-9.251-1.695
                                    c-1.083-0.785-3.216-0.127-4.599-0.127c-1.52,1.064-2.737,2.025-4.478,2.028c-1.248,0.001-2.699-0.55-3.62,0.888
                                    c-1.256-1.885-2.411-0.326-3.646,0.052c-0.609,0.187-1.425,0.252-1.974-0.003c-4.376-2.026-9.253-1.71-13.748-3.037
                                    c-2.021-0.598-3.899-1.248-5.899-0.768c-2.022,2.468-5.151,2.399-7.581,3.781c-1.367,0.776-2.691-0.603-4.131-1.026
                                    c-0.883,1.229-2.49,1.193-3.612,2.149c-2.816-2.362-5.209-0.515-7.65,0.778c-0.844-1.183-2.169-1.243-3.021-0.547
                                    c-1.399,1.144-2.736,0.768-4.105,0.391c-3.305-0.909-8.024-0.512-11.431-0.089c-4.46,0.554-8.897,3.014-13.567,0.466
                                    c-1.463-0.799-3.078,0.344-4.375,1.056c-0.85-0.495-1.261-1.27-2.264-1.15c-1.15,0.136-2.331-0.018-3.494,0.046
                                    c-1.043,0.057-1.391-1.352-2.594-1.049c-1.111,0.28-2.241,0.104-3.049-0.898c-0.695,0.735-1.469,1.58-2.388,0.432
                                    c-0.857-1.071-2.272,0.091-3.115-1.019c-0.583-0.768-1.884,1.156-2.445-0.465c-1.418,1.769-3.375,0.822-5.093,0.953
                                    c-1.822,0.139-3.981,0.636-5.417-0.119c-1.878-0.987-3.198,0.296-4.747,0.313c-1.509,0.017-2.263-1.29-3.565-1.185
                                    c-1.332,1.381-3.052,1.563-4.426,0.635c-1.61-1.089-3.452-0.974-4.711-0.479c-2.676,1.051-5.646,0.289-7.828,1.938
                                    c-0.683-0.542-1.055-0.839-1.688-1.342c-0.829,0.576-1.777,1.076-2.848,1.373c-3.517,0.977-7.056,1.02-10.609,0.846
                                    c-1.409-0.068-2.471,0.435-3.549,1.069c-1.926-0.894-3.757-0.987-5.342-1.232c-2.083-0.321-4.088-1.155-6.135-1.772
                                    c-0.341,0.311-0.696,0.633-1.05,0.955c-0.949-0.949-1.892-1.892-2.967-2.968c-0.514,0-1.163-0.001-1.811,0
                                    c-0.608,0.001-0.663-1.126-1.408-0.78c-0.296,0.296-0.532,0.532-0.768,0.768c-2.003-1.778-2.003-1.778-4.481-2.451
                                    c-0.039-0.618,0.13-1.346-0.79-1.529c-3.206,1.594-6.601,0.994-9.968,0.765c-0.931-1.668-1.427,0.507-2.274,0.259
                                    c-1.041-0.306-1.756-1.276-3.085-1.105c-1.035,0.133-1.745,0.709-2.603,0.992c-1.053,0.346-2.321,0.197-3.468,0.05
                                    c-1.123-0.144-1.734,0.768-2.601,0.985c-2.311,0.58-4.655,1.614-7.058,0.991c-1.986-0.515-3.309,1.3-5.096,1.04
                                    c-1.716-0.248-2.819-2.006-4.672-1.988c-0.48,0.006-1.005,0.111-1.326-0.419c0.217-1.201-0.782-1.697-1.415-2.407
                                    c-1.292-0.588-2.923,0.468-4.132-1c-0.348-0.423-1.842-0.491-2.335-0.108c-2.484,1.927-5.761-0.025-8.259,1.882
                                    c-0.759,0.579-1.799-0.181-2.503-0.876c-4.245,1.979-5.566,2.092-10.38,2.008c-1.64-0.028-3.296,0.806-4.912,1.238
                                    c-0.235,0.615,0.028,1.39-1.033,1.775c-1.321-0.673-2.828-1.439-4.226-2.15c-0.913,0.293-1.238,1.397-2.357,1.017
                                    c-0.283-0.255-0.646-0.579-1.189-1.069c-0.287,1.471-1.421,1.18-2.375,1.095c-2.043-0.183-3.799-1.27-5.693-1.917
                                    c-2.101-0.717-4.565,0.853-6.657-0.875c-0.408-0.337-1.498,0.116-1.865-0.229c-2.137-2.005-4.153-0.596-6.215,0.222
                                    c-0.931-1.526-2.305-1.788-3.374-0.746c-1.943,1.897-3.276-0.342-4.864-0.531c-1.855-0.221-3.326,2.316-4.94,0.811
                                    c-1.349-1.258-2.909-0.114-4.57-1.309c-0.179-0.207-0.711-0.823-1.21-1.402c-0.616,0.412-0.896,1.157-1.866,0.963
                                    c-2.224-2.004-5.235-3.755-8.021-2.738c-2.296,0.838-3.802,0.482-5.77-0.179c-2.098-0.704-4.248-1.223-6.57-1.123
                                    c-2.024,0.087-4.011,0.092-6.159-0.72c-2.105-0.795-4.683-0.251-6.682-2.073c-0.509-0.463-1.934-0.53-2.637,0.516
                                    c-0.365,0.543-0.893,0.287-1.114,0.319c-1.406-0.75-2.636-1.405-3.804-2.028c-2.504,1.352-4.994,2.255-7.78,2.065
                                    c-1.37-0.094-2.727-0.035-3.96,0.694c-1.209-1.401-2.82-0.387-4.208-0.702c-3.62-0.819-6.958,1.528-11.579,0.768
                                    c-0.032-0.08-0.401-0.995-0.917-2.273c-1.01,2.458-2.813,2.302-4.293,2.836c-2.534,0.914-5.234,0.974-7.805,1.67
                                    c-3.218-1.734-6.673-0.716-9.859-1.035c-1.111,1.111-2.053,2.054-3.036,3.037c-2.809,0.018-5.796-0.494-8.012,1.982
                                    c-0.656-0.656-1.245-1.245-2.011-2.011c-3.176,0.305-6.626-0.709-9.844,1.024c-2.124-1.083-2.086-0.977-3.818-0.358
                                    c-1.165,0.416-2.049,1.458-3.438,1.375c-2.79-0.167-5.621,0.335-8.363-0.534c-0.075,0.488,0.207,1.044-0.828,1.633
                                    c-2.107-1.286-4.136,1.014-6.53,0.899c-1.032-0.532-1.426-1.861-2.992-2.075c-1.815,1.799-4.035,1.946-6.656,1.126
                                    c-3.284-1.028-6.238,2.367-9.666,1.103c-1.319,1.573-3.447,0.094-4.576,0.938c-1.846,1.38-3.191-0.94-4.748-0.105
                                    c-1.646-1.447-3.679-0.854-5.396-1.017c-2.018-1.521-3.892-2.889-5.871-1.552c-0.93,0.408-0.84-0.752-1.598-0.083
                                    c-0.175,0.18-0.407,0.417-0.643,0.659c-0.566-0.59-1.054-1.341-2.827-0.624c-0.076,0.131-0.547,0.951-1.02,1.77
                                    c0-0.371-0.001-0.741-0.001-1.112c-5.352,0.475-9.849-1.026-13.06-4.952c-2.449,0.903-2.449,0.903-4.533-0.089
                                    c-2.724,1.548-5.446,1.525-8.169,0.001c-1.368,0.71-2.736,1.42-3.397,1.763c-3.532-0.728-6.427-1.307-8.771-2.919
                                    c-0.741,0.571-1.028,1.297-1.82,1.158c-1.388-0.72-2.756-1.43-3.868-2.007c-3.021,1.753-5.96,0.652-8.615,1.049
                                    c-0.797-0.871-1.356-1.482-2.097-2.291c-1.741,1.015-3.215-0.443-4.653-0.828c-0.575,0.466-0.91,0.737-1.235,1.001
                                    c-0.673-0.673-1.262-1.263-1.872-1.872c-2.219,2.337-4.406,0.048-6.982-0.156c-2.32,3.421-6.463,3.874-10.109,4.943
                                    c-2.834,0.832-6.127-0.284-9.045,1.139c-0.256,0.125-0.796,0.116-0.944-0.055c-1.258-1.452-3.393-0.696-4.481-2.077
                                    c-0.706,0.45-1.174,0.75-1.612,1.028c-0.348-0.348-0.583-0.583-0.843-0.843c-0.689,0.644-1.378,1.288-2.452,2.29
                                    c-0.484-0.839-0.958-1.658-1.373-2.377c-1.433,0.871-1.534,2.105-2.202,2.649c-3.546,2.57-7.799,0.318-11.329,1.861
                                    c-4.142,1.811-7.867-1.129-11.987-0.347c-0.829,2.764-4.707,1.139-5.532,3.898c-1.179,0-2.176,0-3.211,0
                                    c-1.179,1.822-3.615,2.105-4.897,3.997c-1.657-0.287-3.448,0.627-5.084-0.896c-0.539-0.502-2.363-0.525-2.833-0.034
                                    c-1.654,1.725-3.939,0.716-5.85,1.736c-1.677,0.895-4.209,0.187-6.288,0.187c-1.525-1.737-3.758-1.651-5.562-2.533
                                    c-1.992-0.974-4.315-0.342-6.438-1.366c-1.779-0.858-4.248,0.826-6.021-1.063c-0.493,0.387-0.786,1.106-2.217,0.851
                                    c-0.233-0.399-0.736-1.259-0.868-1.485c-2.381-0.849-4.2,0.149-5.89-1.215c-0.813-0.657-2.962-0.701-3.794-0.075
                                    c-1.715,1.29-3.445,0.783-5.17,0.861c-2.328,0.105-4.664,0.026-6.997,0.025c-1.719,1.708-3.815,2.123-6.171,2.029
                                    c-2.98-0.118-5.97-0.028-8.855-0.028c-0.689,0.688-1.278,1.278-1.867,1.867c-0.498-0.308-0.996-0.616-1.897-1.175
                                    c-0.388,2.401-2.434,0.696-3.564,1.615c-0.293,0.569,0.012,1.362-0.338,1.51c-3.463,0.326-6.337,0.991-8.169,2.808
                                    c-4.955,1.452-9.135-1.267-13.568-0.623c-4.48,0.649-8.601-1.6-12.961-1.979c0,2.838,0,5.29,0,7.976c341.006,0,681.882,0,1022.758,0
                                    c14.494,0,28.988-0.069,43.481-0.015c3.862,0.015,5.46-0.053,5.55-0.188c283.215,0,565.436,0,847.625,0c0-6.655,0-13.224,0-19.867
                                    C1915.898,10.076,1910.912,9.958,1906.688,12.029z"></path>
                </svg>
            </div>
		
	<?php }

}


